# Hilfsfunktionen fr CLISP auf VMS
# Zum Teil abgeschrieben von sysdep.c aus der Emacs-Distribution.
# Zum Teil abgeschrieben von vms_compat.c aus der Tgif-Distribution.
# Bruno Haible 13.5.1993

#include "lispbibl.c"

# ==============================================================================

# Allgemein:

# Event-Flags allgemein:
local int process_ef = 0;

void vms_init (void);
local void vms_init_timer (void);
local void vms_init_input (void);
local void vms_exit_input (void);
void vms_init()
  {
    if (!process_ef) { LIB$GET_EF(&process_ef); } # Event-Flag allozieren
    SYS$CLREF(process_ef); # Event-Flag lschen
    vms_init_timer();
    vms_init_input();
  }

#include <descrip.h>

local struct dsc$descriptor * set_dsc (struct dsc$descriptor * x, char* buf, int len);
local struct dsc$descriptor * set_dsc(x,buf,len)
  var reg1 struct dsc$descriptor * x;
  var reg2 char* buf;
  var reg3 int len;
  { x->dsc$a_pointer = buf; x->dsc$w_length = len;
    x->dsc$b_class = DSC$K_CLASS_S; x->dsc$b_dtype = DSC$K_DTYPE_T;
    return x;
  }

local struct dsc$descriptor * set_dsc_asciz (struct dsc$descriptor * x, char* buf);
local struct dsc$descriptor * set_dsc_asciz(x,buf)
  var reg1 struct dsc$descriptor * x;
  var reg2 char* buf;
  { x->dsc$a_pointer = buf; x->dsc$w_length = asciz_length(buf);
    x->dsc$b_class = DSC$K_CLASS_S; x->dsc$b_dtype = DSC$K_DTYPE_T;
    return x;
  }

# ==============================================================================

# Event-Flags fr den Timer:
local int timer_ef = 0;
local int timer_ef_list;

local void vms_init_timer (void);
local void vms_init_timer()
  {
    if (!timer_ef) { LIB$GET_EF(&timer_ef); } # Event-Flag allozieren
    SYS$CLREF(timer_ef); # Event-Flag lschen
    timer_ef_list = bit(timer_ef%32) | bit(process_ef%32);
  }

# Wartet amount/100 sec.
# The standard `sleep' routine works some other way and it stops working
# if you have ever quit out of it. This one continues to work.
global void vms_sleep (int amount);
global void vms_sleep(amount)
  var int amount;
  { var uintL time[2];
    # Convert to VMS format: time := amount * (1/100 s) / (100 ns)
    # (negativ, bedeutet delta time)
    local var sintL zero = 0;
    local var sintL large = -10000000/ticks_per_second;
    LIB$EMUL(&amount,&large,&zero,&time);
    # Timer-Hackerei:
    SYS$CANTIM(1,0); # request 1 lschen
    if (SYS$SETIMR(timer_ef,time,0,1) & 1) # Set timer, request 1
      { SYS$WAITFR(timer_ef); } # Wait for timer expiry only
  }

# ==============================================================================

# ttyname(), siehe TTYNAME(3V)
global char* ttyname (int fd);
global char* ttyname(fd)
  var int fd;
  { local var char buffer[MAXPATHLEN];
    getname(fd,&buffer);
    return &buffer;
  }

# ==============================================================================

#include <iodef.h>

# Low-Level Buffer (zyklisch, FIFO):
#define input_buffer_size  10000
local char input_buffer_cyclic [input_buffer_size];
local int input_count; # >=0, <=input_buffer_size
local char* input_buffer_getptr; # Pointer in den Buffer, an den Anfang
local char* input_buffer_putptr; # Pointer in den Buffer, ans Ende
            # = input_buffer_getptr + input_count - (0 oder input_buffer_size)
#define input_buffer_start  &input_buffer_cyclic[0]
#define input_buffer_end    &input_buffer_cyclic[input_buffer_size]

local char input_buffer_get (void);
local char input_buffer_get() # Voraussetzung: input_count>0
  { if (input_buffer_getptr == input_buffer_end)
      { input_buffer_getptr = input_buffer_start; }
    input_count--;
    return *input_buffer_getptr++;
  }

local void input_buffer_put (char c);
local void input_buffer_put(c)
  { if (input_count == input_buffer_size) # Buffer voll?
      return;
    if (input_buffer_putptr == input_buffer_end)
      { input_buffer_putptr = input_buffer_start; }
    *input_buffer_putptr++ = c;
    input_count++;
  }


# Event-Flags fr den Input:
local int input_ef = 0;
local int input_ef_list;

# Weitere Descriptoren:
local int input_chan;
local struct dsc$descriptor input_dsc;
local int terminator_mask[2] = { 0,0 };
local struct iosb { short status; short offset; short termlen; short term; }
      input_iosb;

# Das Herzstck ist folgende asynchron aufgerufene Routine:
  global void input_ast();
# Wird sie aufgerufen, so
# 1. gibt sie ein Signal an die Variable waiting_for_ast,
# 2. holt sie ein Character ab und legt es im Buffer ab,
# 3. reaktiviert sich frs nchste Mal, auer falls stop_input gesetzt.

# Flag: gesetzt, falls man auf den Aufruf wartet.
local boolean waiting_for_ast;

# Flag: gesetzt, falls Input zum Stillstand kommen soll.
local boolean stop_input;

# Lowest-Level Buffer:
local short input_smallbuffer;

# Request reading one character into the keyboard buffer.
# This is done as soon as the buffer becomes empty.
local void input_activate()
  { waiting_for_ast = FALSE;
    stop_input = FALSE;
    SYS$QIO(0, input_chan, /* IO$_READVBLK */ IO$_TTYREADALL | IO$M_NOECHO,
            &input_iosb,&input_ast,1,&input_smallbuffer,1,0,&terminator_mask,0,0);
  }

# Ast routine that is called when keyboard input comes in
# in accord with the SYS$QIO above.
local void input_ast()
  { var reg1 int c = -1;
    var reg2 int old_errno = errno;
    if (waiting_for_ast) { SYS$SETEF(input_ef); }
    waiting_for_ast = FALSE;
    if (input_iosb.offset) { c = input_smallbuffer; }
    if (c>=0) { input_buffer_put(c); }
    if (!stop_input) { input_activate(); }
    errno = old_errno;
  }


local boolean vms_kbhit (void);
local boolean vms_kbhit()
  { return (input_count>0); }

local int vms_getch (void);
local int vms_getch()
  { if (input_count==0)
      { # Warten, bis die AST-Routine etwas in den Buffer schreibt:
        waiting_for_ast = FALSE;
        SYS$CLREF(input_ef);
        waiting_for_ast = TRUE;
        while (input_count==0) { SYS$WFLOR(input_ef,input_ef_list); }
        waiting_for_ast = FALSE;
      }
    return input_buffer_get();
  }

#if 0
global void vms_scrsize (int* scrsize);
global void vms_scrsize(scrsize)
  var reg1 int* scrsize;
  { var struct sensemode { short status;
                           unsigned char xmit_baud;
                           unsigned char rcv_baud;
                           unsigned char crfill;
                           unsigned char lffill;
                           unsigned char parity;
                           unsigned char unused;
                           char class;
                           char type;
                           short scr_wid;
                           unsigned long tt_char : 24, scr_len : 8;
                           unsigned long tt2_char;
                         }
        tty;
    SYS$QIOW(0,input_chan,IO$_SENSEMODE,&tty,0,0,&tty.class,12,0,0,0,0);
    scrsize[0] = tty.scr_wid; # width
    scrsize[1] = tty.scr_len; # height
  }
#endif

local boolean active = FALSE;

local void vms_start_input (void);
local void vms_start_input()
  { if (active) return;
    input_activate();
    active = TRUE;
  }

local void vms_stop_input (void);
local void vms_stop_input()
  { if (!active) return;
    SYS$SETAST(0); # Disable AST interrupts (avoid races)
    SYS$CLREF(input_ef); # Event-Flag lschen
    stop_input = TRUE;
    waiting_for_ast = TRUE;
    SYS$CANCEL(input_chan); # Cancel pending QIO on input_chan
    SYS$SETAST(1); # Enable AST interrupts
    SYS$WAITFR(input_ef); # Wait until AST is called. Then it will set input_ef. ??
    waiting_for_ast = FALSE;
    active = FALSE;
  }

local boolean initialized = FALSE;

local void vms_init_input (void);
local void vms_init_input()
  { if (initialized) return;
    input_buffer_getptr = input_buffer_putptr = input_buffer_start;
    input_count = 0;
    # input_ef und input_ef_list initialisieren:
    if (!input_ef) { LIB$GET_EF(&input_ef); } # Event-Flag allozieren
    SYS$CLREF(input_ef); # Event-Flag lschen
    input_ef_list = bit(input_ef%32) | bit(process_ef%32);
    # input_dsc und input_chan initialisieren:
    set_dsc_asciz(&input_dsc,"TT");
    {var reg1 int status = SYS$ASSIGN(&input_dsc,&input_chan,0,0);
     if (!(status & 1)) { LIB$STOP(status); } # Fehler -> Proze beenden
    }
    # Exit-Handler installieren:
    { local struct argument_block
            { int forward_link;
              int (*exit_routine)();
              int arg_count;
              int *status_address;
              int exit_status;
            }
            exit_block = { 0, NULL, 1, &exit_block.exit_status, 0};
      if (exit_block.exit_routine == NULL)
        { exit_block.exit_routine = &vms_exit_input; SYS$DCLEXH(&exit_block); }
    }
    initialized = TRUE;
    # Los geht's.
    # (ESCstring"=" ESCstring"[?1l")   # Enable Application Keypad ??
    input_activate();
  }

local void vms_exit_input()
  { if (!initialized) return;
    SYS$DASSGN(input_chan);
    # (ESCstring">")   # Enable Numeric Keypad ??
    initialized = FALSE;
  }

# ==============================================================================

# Directories lesen:

# include <errno.h>
# include <setjmp.h>
#ifndef FAB$C_BID
  #include <fab.h>     # FAB = File Access Block
#endif
#ifndef NAM$C_BID
  #include <nam.h>
#endif
# #ifndef RMS$_SUC
#   #include <rmsdef.h>  # RMS = Record Management Service
# #endif

# Filename mu bereits die Gestalt "host::device:[directory]*.*;*" haben.
global DIR* opendir (char* filename);
global struct direct * readdir (DIR* dirp);
global void closedir (DIR* dirp);

local DIR search_dir;

local jmp_buf search_jmpbuf;

local struct direct * * dpp;

local void nextfile_ok (struct FAB * fabptr);
local void nextfile_error (struct FAB * fabptr);

global DIR* opendir(filename)
  var reg5 char* filename;
  { var reg4 DIR* dirp = &search_dir;
    # Das ganze Directory auf einmal einlesen:
    dirp->dd_all = NULL;
    { var char search_esn[NAM$C_MAXRSS];
      var char search_rsn[NAM$C_MAXRSS];
      var struct NAM search_nam = cc$rms_nam;
      search_nam.nam$l_esa = search_esn; search_nam.nam$b_ess = sizeof(search_esn);
      search_nam.nam$l_rsa = search_rsn; search_nam.nam$b_rss = sizeof(search_rsn);
     {var struct FAB search_fab = cc$rms_fab;
      search_fab.fab$l_fna = filename; search_fab.fab$b_fns = asciz_length(filename);
      search_fab.fab$l_nam = &search_nam;
      search_fab.fab$l_fop = FAB$M_NAM;
      if (setjmp(search_jmpbuf)==0)
        { loop
            { var reg1 int status;
              # nchstes File suchen:
              status = LIB$FILE_SCAN(&search_fab,&nextfile_ok,&nextfile_error);
              if (status==0) # Keine weiteren Files?
                break;
              if (!(status&1)) # Error?
                { errno = EVMSERR; vaxc$errno = status; longjmp(search_jmpbuf,1); }
            }
          LIB$FILE_SCAN_END(&search_fab);
        }
        else
        # Wegen Error mit longjmp() herausgesprungen.
        { LIB$FILE_SCAN_END(&search_fab);
          if (!(errno==0)) { OS_error(); }
          # malloc() schaffte es nicht mehr.
          closedir(dirp); # Liste wieder freigeben
          return NULL;
        }
    }}
    dirp->dd_next = dirp->dd_all;
    return dirp;
  }

local void nextfile_ok (fabptr)
  var reg6 struct FAB * fabptr;
  { var reg5 struct NAM * namptr = fabptr->fab$l_nam;
    # Namen namptr->nam$l_rsa[0..namptr->nam$b_rsl-1]
    # (bzw. nur den Name/Typ/Version-Teil) herauskopieren:
    var reg3 uintC len = namptr->nam$b_rsl;
    #if 0 # den ganzen Namen
    var reg2 char* ptr1 = &namptr->nam$l_rsa[0];
    #else # nur den hinteren Teil
    var reg2 char* ptr1 = &namptr->nam$l_rsa[len];
    {var reg3 uintC count = len;
     len = 0;
     dotimesC(count,count,
       { var reg1 char ch = ptr1[-1];
         if ((ch==':') || (ch==']') || (ch=='>')) break;
         ptr1--; len++;
       });
    }
    #endif
   {var reg4 struct direct * dp = malloc(offsetofa(struct direct,d_name)+len);
    if (dp==NULL) { errno=0; longjmp(search_jmpbuf,1); }
    {var reg1 char* ptr2 = &dp->d_name[0];
     dp->d_namlen = len;
     dotimesC(len,len, { *ptr2++ = *ptr1++; } );
    }
    # und dp in die Liste einhngen:
    dp->d_next = NULL; *dpp = dp; dpp = &dp->d_next;
  }}

local void nextfile_error (fabptr)
  var struct FAB * fabptr;
  { # Man knnte hier errno und vaxc$errno ausgeben.
    # Man knnte auch ein longjmp(search_jmpbuf,1); ausfhren.
    # Wir tun all das nicht, weil es vielleicht besser es, wegen eines
    # einzelnen Files nicht zu viel Unruhe zu stiften.
  }

global void closedir(dirp)
  var reg2 DIR* dirp;
  { # Wir mssen nur die Liste der malloc()-Blcke freigeben:
    var reg1 struct direct * dp = dirp->dd_all;
    until (dp==NULL)
      { var reg2 struct direct * next = dp->d_next;
        free(dp);
        dp = next;
  }   }

global struct direct * readdir(dirp)
  var reg2 DIR* dirp;
  { var reg1 struct direct * next = dirp->dd_next;
    if (next == NULL) # Ende der Liste erreicht?
      { return NULL; }
      else
      { dirp->dd_next = next->d_next; return next; }
  }

# ==============================================================================

# Wildcard-Expansion fr Argumente der Kommandozeile:
# Author: George Carrette, <GJC@MITECH.COM> in November 1990.

#include <errno.h>
#include <descrip.h>
#include <rmsdef.h>
#include <ssdef.h>
# include <string.h>

# Testet, ob Wildcards vorkommen.
# > s: Asciz-String
# < ergebnis: TRUE wenn s Wildcard-Zeichen enthlt
# Modifiziert s.
  local boolean has_wildcards (char* s);
  local boolean has_wildcards(s)
    var reg1 char* s;
    { var reg2 boolean has = FALSE;
      until (*s == '\0')
        { if ((*s == '*') || (*s == '%')) { has = TRUE; }
          elif (*s == '?') { *s = '%'; has = TRUE; }
          s++;
        }
      return has;
    }

# Die folgenden Funktionen verhalten sich wie vector_push_extend:
# argv_put_one(s,argvp); fgt den String s zu argvp hinzu.
# argv_put_wild(s,argvp); fgt alle Wildcard-Expansionen des Strings s zu
#                         argvp hinzu (s selbst, falls keine Files gefunden).

typedef struct { char** argv; int argvsize; int argc; /* 0 <= argc <= argvsize */ }
        argvd_t;
typedef argvd_t* argvp_t;

local void argv_put_one (char* s, argvp_t argvp);
local void argv_put_one(s,argvp)
  var reg2 char* s;
  var reg1 argvp_t argvp;
  { if (argvp->argc == argvp->argvsize)
      { var reg6 int old_size = argvp->argvsize;
        var reg7 int new_size = 2*old_size;
        var reg5 char** old_argv = argvp->argv;
        var reg4 char** new_argv = (char**) malloc(new_size*sizeof(char*));
        var reg3 int i;
        for (i=0; i<old_size; i++) { new_argv[i] = old_argv[i]; }
        argvp->argv = new_argv; argvp->argvsize = new_size; free(old_argv);
      }
    argvp->argv[argvp->argc++] = s;
  }

local void argv_put_wild (char* s, argvp_t argvp);
local void argv_put_wild(s,argvp)
  var reg6 char* s;
  var reg5 argvp_t argvp;
  { var reg4 boolean found_something = FALSE;
    var long context = 0;
    var struct dsc$descriptor fnamed;
    var struct dsc$descriptor foutd;
    var struct dsc$descriptor rfnamed;
    set_dsc_asciz(&fnamed,s);
    set_dsc(&foutd,0,0); foutd.dsc$b_class = DSC$K_CLASS_D;
    set_dsc_asciz(&rfnamed,";");
    loop
      { var reg1 int status = LIB$FIND_FILE(&fnamed,&foutd,&context,0,&rfnamed,0,0);
        if (!(status==RMS$_NORMAL))
          { if ((status==RMS$_NMF) || (status==RMS$_FNF)) break;
            /* errno = EVMSERR; vaxc$errno = status; OS_error(); */ exit(status);
          }
       {var reg3 int len = foutd.dsc$w_length;
        var reg2 char* news = (char*)malloc(len+1);
        memcpy(news,foutd.dsc$a_pointer,len); news[len] = '\0';
        argv_put_one(news,argvp); found_something = TRUE;
      }}
    if (foutd.dsc$a_pointer) { LIB$SFREE1_DD(&foutd); }
    if (context)
      { var reg1 int status = LIB$FIND_FILE_END(&context);
        if (!(status==SS$_NORMAL))
          { /* errno = EVMSERR; vaxc$errno = status; OS_error(); */ exit(status); }
      }
    if (!found_something)
      { argv_put_one(s,argvp); }
  }

local void argv_put (char* s, argvp_t argvp);
local void argv_put(s,argvp)
  var reg2 char* s;
  var reg1 argvp_t argvp;
  { if (has_wildcards(s))
      { argv_put_wild(s,argvp); }
      else
      { argv_put_one(s,argvp); }
  }

global void _wildcard (int * argc_, char** * argv_);
global void _wildcard(argc_,argv_)
  var reg5 int * argc_;
  var reg4 char** * argv_;
  { var reg3 int argc = *argc_;
    var reg2 char** argv = *argv_;
    var argvd_t argvd;
    argvd.argv = (char**)malloc((argvd.argvsize = 3) * sizeof(char*));
    argvd.argc = 0;
    {var reg1 int i; for (i=0; i<argc; i++) { argv_put(argv[i],&argvd); } }
    *argv_ = argvd.argv; *argc_ = argvd.argc;
  }

# ==============================================================================

# Implement unix popen and pclose in vms by using mailboxes.
# Author: George Carrette, <GJC@MITECH.COM> in April 1991.

#include <errno.h>
#include <descrip.h>
#include <rmsdef.h>
#include <ssdef.h>
#include <string.h>

globalvalue CLI$M_NOWAIT;

#define mailbox_size  512
#define mailbox_byte_quota  (3*mailbox_size)
#define mailbox_protection_mask  0x0000F000

local int create_mbx (char* name);
local int create_mbx(name)
  var reg2 char* name;
  { var short chan;
    var reg3 int prmflg = 0;
    var reg4 int maxmsg = mailbox_size;
    var reg5 int bufquo = mailbox_byte_quota;
    var reg6 int promsk = mailbox_protection_mask;
    var reg7 int acmode = 0;
    var struct dsc$descriptor lognam;
    set_dsc_asciz(&lognam,name);
   {var reg1 int status = SYS$CREMBX(prmflg,&chan,maxmsg,bufquo,promsk,acmode,&lognam);
    if (!(status==SS$_NORMAL)) { errno = EVMSERR; vaxc$errno = status; return -1; }
    return chan;
  }}

local void pipe_exit_ast (pipe_info* pipe);
local void pipe_exit_ast(pipe)
  var reg1 pipe_info* pipe;
  { pipe->completed = TRUE; }

local void pipe_cleanup (pipe_info* pipe);
local void pipe_cleanup(pipe)
  var reg1 pipe_info* pipe;
  { SYS$DASSGN(pipe->mbx_chan);
    if (!pipe->completed) { SYS$DELPRC(&pipe->pid,0); }
    free(pipe->mbx_name);
    free(pipe);
  }

global pipe_info* pipe_open (char* command, char mode);
global pipe_info* pipe_open(command,mode)
  var reg5 char* command;
  var reg4 char mode;
  { var reg3 boolean readp;
    if (mode=='r') { readp = TRUE; }
    elif (mode=='w') { readp = FALSE; }
    else { errno = 0; return NULL; }
   {var reg1 pipe_info* pipe = (pipe_info*)malloc(sizeof(pipe_info));
    {var reg2 char* temp_name = mktemp("PIPE_OPEN_MB_XXXXXXXXXX");
     pipe->mbx_name = (char*)malloc(asciz_length(temp_name)+1);
     strcpy(pipe->mbx_name,temp_name);
    }
    if ((pipe->mbx_chan = create_mbx(pipe->mbx_name)) < 0)
      { pipe->completed = TRUE; pipe_cleanup(pipe); return NULL; }
    { var reg6 char* in;
      var reg7 char* out;
      if (readp)
        { in = "NL:"; out = pipe->mbx_name; }
        else
        { in = pipe->mbx_name; out = "NL:"; }
      pipe->completed = FALSE;
     {var reg8 char* name = NULL;
      var reg9 char* prompt = NULL;
      var struct dsc$descriptor comm_d;
      var struct dsc$descriptor in_d;
      var struct dsc$descriptor out_d;
      var struct dsc$descriptor name_d;
      var struct dsc$descriptor prompt_d;
      var int mask = CLI$M_NOWAIT;
      var reg2 int status =
        LIB$SPAWN(command ? set_dsc_asciz(&comm_d,command) : NULL,
                  in ? set_dsc_asciz(&in_d,in) : NULL,
                  out ? set_dsc_asciz(&out_d,out) : NULL,
                  &mask,
                  name ? set_dsc_asciz(&name_d,name) : NULL,
                  &pipe->pid,
                  &pipe->completion_status,
                  0, # event flag
                  &pipe_exit_ast, pipe,
                  prompt ? set_dsc_asciz(&prompt_d,prompt) : NULL,
                  0 # command line interpreter
                 );
      if (!(status==SS$_NORMAL))
        { pipe->completed = TRUE; pipe_cleanup(pipe);
          errno = EVMSERR; vaxc$errno = status;
          return NULL;
        }
      if ((pipe->fd = open(pipe->mbx_name,(readp ? O_RDONLY : O_WRONLY),0644)) < 0)
        { pipe_cleanup(pipe); return NULL; }
    }}
    return pipe;
  }}

global int pipe_close (pipe_info* pipe);
global int pipe_close(pipe)
  var reg1 pipe_info* pipe;
  { var reg2 int retval = close(pipe->fd);
    pipe_cleanup(pipe);
    return retval;
  }

# ==============================================================================

#include <dvidef.h>

# I/O status block
typedef struct { short i_cond; # Condition value
                 short i_xfer; # Transfer count
                 long i_info;  # Device information
               }
        iosb;

global void vms_scrsize (int* scrsize);
global void vms_scrsize(scrsize)
  var reg1 int* scrsize;
  { var struct dsc$descriptor devnam;
    set_dsc_asciz(&devnam,"SYS$OUTPUT");
    scrsize[1] = 24; scrsize[0] = 80; # Default-Werte
   {var struct { short row_buflen; short row_itmcod; int* row_bufadr; short* row_retlen;
                 short col_buflen; short col_itmcod; int* col_bufadr; short* col_retlen;
                 int listend;
               }
        itmlst = { sizeof(int), DVI$_TT_PAGE, &scrsize[1], 0,
                   sizeof(int), DVI$_DEVBUFSIZ, &scrsize[0], 0,
                   0
                 };
    var iosb iostatus;
    var reg2 int status = # Get current terminal characteristics
      SYS$GETDVIW(0,         # Wait on event flag zero ??
                  0,         # Channel to input terminal ??
                  &devnam,   # device name
                  &itmlst,   # Item descriptor List
                  &iostatus, # Status after operation
                  0, 0,      # No AST service
                  0          # nullarg
                 );
    #if 0
    if (!(status & 1)) # Error?
      { errno = EVMSERR; vaxc$errno = status; ... }
    if (!(iostatus.i_cond & 1)) # Error?
      { errno = EVMSERR; vaxc$errno = iostatus.i_cond; ... }
    #endif
  }}

# ==============================================================================

