
#include "window.h"

static char *aboutSTDWIN[] = {
	 "STDWIN version 1.0"
	,"by"
	,"Henk Lohuis"
	,"Copyright (c) 1988"
	,"Stichting Mathematisch Centrum"
	,"Amsterdam"
};

WINDOW	**winlist;
int	nrwin;
WINDOW	*active;

int	vdi_handle = -1;
int appl_id;

int	x_def, y_def, w_def, h_def;

int	max_width;
int	max_height;

int	pix_width;
int	pix_height;

int	scr_width;
int	scr_height;

bool mousedown[3];
bool mouseoff;

int	w_l_border;
int	w_t_border;
int	w_r_border;
int	w_b_border;

int	w_ch_width;
int w_ch_height;
int	w_bx_width;
int	w_bx_height;
int	chheight;

void *w_rootmenu;

/* variables used by the vdi library */
int	contrl[12];
int	intin[128];
int	intout[128];
int	ptsin[128];
int	ptsout[128];

/* variables used for drawing */

WINDOW *drawing;
TEXTATTR savetextattr;

int	extrah;
int	extrav;

int	curr_interior;
int	curr_color;
int	curr_mode;

int w_min_height;
int w_min_v_pos;

int w_poll_flag;

int w_def_opt;
int w_from_con;

void initglobmenus(void);

bool (*own_keybd)(EVENT *, int, int, int, int);
void w_strt_event(void);

struct w_pile w_win_pile[MAXWINDOWS];
int num_w_pile = 0;
int w_no_erase;

OBJECT *w_u_about = (OBJECT *)0;

WORKPARM vdiworkparams;
FONT oldfont = (FONT)0;
FONT fontbuffer = (FONT)0;

int ButState;
int (*OldInter)();
int ButInter();

void
winit()
{
	int	x_inside, y_inside, w_inside, h_inside;
	int	x_outside, y_outside, w_outside, h_outside;
	register int i;
	int	workin[11];
	int	workout[57];
	int *w;
	int	dummy;

	nrwin = 0;
	active = NULL;
	vdi_handle = -1;
	mousedown[1] = mousedown[2] = FALSE;
	mouseoff = FALSE;
	drawing = (WINDOW *) NULL;
	curr_interior = -1;
	curr_color = -1;
	curr_mode = -1;
	w_min_height = MIN_HEIGHT;
	w_min_v_pos = 0;
	w_def_opt = DEF_OPT;
	w_from_con = 0;
	w_no_erase = 0;
/*
	If the user hasn't called wsetabout we do it with a standard message
*/
	if ( w_u_about == 0 ) {
		wsetabout("About STDWIN",sizeof(aboutSTDWIN)/sizeof(char *),aboutSTDWIN);
	}
/*
	We don't put in `num_w_pile = 0;' because this way we can use
	wdone and restart later, rebuilding the window positions.
	The user should call wclose for his windows and reopen then afterwards
	in opposite order. This feature compensates a little bit for the
	rather limited window system (only 8 windows).
*/
	w_strt_event();

	if ( fontbuffer != NULL ) chheight = fontbuffer->pixellines;

	if ( ( appl_id = appl_init () ) < 0) return;
/*
	Get the size of characters and the screen size
*/
	vdi_handle = graf_handle (&w_ch_width, &w_ch_height, &w_bx_width, &w_bx_height);
	vex_butv(vdi_handle,ButInter,&OldInter);

	if ( fontbuffer != NULL ) w_ch_height = chheight;
	else chheight = w_ch_height;

	w = workin;
	for (i = 0; i < 10; i++) *w++ = 1;
	*w = 2;
	v_opnvwk (workin, &vdi_handle, workout);

	scr_width = workout[0] + 1;
	scr_height = workout[1] + 1;

	pix_width = workout[2];
	pix_height = workout[3];
/*
	Some atributes for drawing...
*/
	vsf_perimeter (vdi_handle, 1);

	vsl_color (vdi_handle, 1);
	vsl_type (vdi_handle, 1);

	vst_color (vdi_handle, 1);
	vst_alignment (vdi_handle, 0, 5, &dummy, &dummy);

	x_outside = 0;
	y_outside = BAR_HEIGHT;
	w_outside = scr_width;
	h_outside = scr_height - y_outside;

	wind_calc (1, DEF_OPT,
			x_outside, y_outside, w_outside, h_outside,
			&x_inside, &y_inside, &w_inside, &h_inside);

	w_l_border = x_inside - x_outside;
	w_t_border = y_inside - y_outside;
	w_r_border = w_outside - w_inside - w_l_border;
	w_b_border = h_outside - h_inside - w_t_border;

	initglobmenus();

	/* Set window positions and sizes */

	wsetdefwinpos(0, 0);
	wsetmaxwinsize(scr_width, scr_height);
	wsetdefwinsize((scr_width*3)>>2, (scr_height*3)>>2);

	wsetplain();
	graf_mouse (BUSY_BEE, (MFORM *)0);

	w_poll_flag = 0;

	own_keybd = 0;
}

