

#include<stdio.h>
#ifdef USE_VARARGS
#include<varargs.h>
#else
#include<stdarg.h>
#endif
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include<assert.h>
#include"types.c"
#include"debug.e"



Class classes= NULL;


struct _STRING{
	char *s;
	int linkcount;
	STRING next;
};
STRING hashtable[8009];
int r1[8009],r2[8009];
int nused= 0;


Class toplevel= NULL;



char *Strdup(s)
char *s;
{
	char *t;
	t= strdup(s);
	if(t==NULL){
		(void)fprintf(stderr,"out of memory\n");
		exit(1);
	}
	return t;
}

void *Malloc(size)
size_t size;
{
	void *t;
	t= malloc(size);
	if(t==NULL){
		(void)fprintf(stderr,"out of memory\n");
		exit(1);
	}
	return t;
}


static int hashval(name)
char *name;
{
	char *p;
	unsigned int h= 0,g,n= 20;
	if(name==NULL)return 0;
	for(p= name;n&& *p;p++,n--){
		h= (h<<4)+( *p);
		if(g= h&0xf0000000){
			h= h^(g>>24);
			h= h^g;
		}
	}
	return h%8009;
}


STRING hash(s)
char *s;
{
	int h;
	STRING t;
	if(s==NULL||s[0]=='\0')return((STRING)NULL);
	h= hashval(s);
	if(!(0<=r2[h]&&r2[h]<nused&&r1[r2[h]]==h)){
		t= Malloc(sizeof( *(t)));
		t->s= Strdup(s);
		t->linkcount= 1;
		t->next= ((STRING)NULL);
		r2[h]= nused,r1[nused]= h,nused++;
		hashtable[h]= t;
		return t;
	}
	for(t= hashtable[h];t;t= t->next){
		if(strcmp(t->s,s)==0){
			t->linkcount++;
			return t;
		}
	}
	t= Malloc(sizeof( *(t)));
	t->s= Strdup(s);
	t->linkcount= 1;
	t->next= hashtable[h];
	hashtable[h]= t;
	return t;
}


void delete(s)
STRING s;
{
#ifdef NDEBUG
	int h;
	STRING t;
#endif
	if(s==((STRING)NULL))return;
	s->linkcount--;
	if(s->linkcount>0)return;
#ifdef NDEBUG
	h= hashval(s->s);
	if(hashtable[h]==s)
		hashtable[h]= s->next;
	else{
		for(t= hashtable[h];t->next!=s;t= t->next);
		t->next= s->next;
	}
	(void)free(s->s);
	(void)free(s);
#else
	if(s->linkcount<0)
		;
#endif
}


char *get(s)
STRING s;
{
	if(s==((STRING)NULL))
		return NULL;
	else
		return s->s;
}


STRING hdup(s)
STRING s;
{
	if(s==((STRING)NULL))return((STRING)NULL);
	s->linkcount++;
	return s;
}



#ifdef USE_VARARGS
STRING catstr(va_alist)va_dcl
#else
#ifdef __STDC__
STRING catstr(int n,...)
#else
STRING catstr(n)int n;
#endif
#endif
{
	va_list ap;
#ifdef USE_VARARGS
	int n;
#endif
	unsigned int len= 0;
	char *s;
	STRING t;
	int i;

#ifdef USE_VARARGS
	va_start(ap);
	n= va_arg(ap,int);
#else
	va_start(ap,n);
#endif
	;
	if(n==0){
		va_end(ap);
		;
		return((STRING)NULL);
	} else{
		for(i= n;i>0;i--)len+= strlen(va_arg(ap,char *));
		va_end(ap);
		s= Malloc(len *sizeof(char)+1);
		s[0]= '\0';
#ifdef USE_VARARGS
		va_start(ap);
		n= va_arg(ap,int);
#else
		va_start(ap,n);
#endif
		for(i= n;i>0;i--)(void)strcat(s,va_arg(ap,char *));
		va_end(ap);
		t= hash(s);
		;
		return t;
	}
}


size_t Strlen(s)
STRING s;
{
	return strlen(s->s);
}



STRING get_classname(s)
STRING s;
{
	char *h;
	STRING t;
	h= Strdup(s->s);
	if('a'<=h[0]&&h[0]<='z')h[0]+= 'A'-'a';
	if(h[0]=='X'&&'a'<=h[1]&&h[1]<='z')h[1]+= 'A'-'a';
	t= hash(h);
	free(h);
	return t;
}


STRING get_instname(s)
STRING s;
{
	char *h;
	STRING t;
	h= Strdup(s->s);
	if('A'<=h[0]&&h[0]<='Z')h[0]+= 'a'-'A';
	if(h[0]=='x'&&'A'<=h[1]&&h[1]<='Z')h[1]+= 'a'-'A';
	t= hash(h);
	free(h);
	return t;
}


STRING get_word(s)
char *s;
{
	char *word;
	STRING t;
	int i;
	word= Malloc(sizeof(char) *strlen(s)+1);
	for(i= 0;isalnum(s[i])||s[i]=='_';i++)
		word[i]= s[i];
	word[i]= '\0';
	t= hash(word);
	free(word);
	return t;
}



void add_class(c)
Class c;
{
	assert(c->next==NULL);
	c->next= classes;
	classes= c;
}


Boolean get_option(value,c,name)
STRING *value;
Class c;
STRING name;
{
	Option h;
	h= c->options;
	while(h!=NULL&&h->opt!=name)
		h= h->next;
	if(h!=NULL){
		*value= h->val;
		return True;
	} else{
		return False;
	}
}


STRING get_guard(c)
Class c;
{
	STRING guard;
	if(!get_option(&guard,c,hash("guard")))
		guard= catstr(3,"_",get(c->name),"_H_");
	return guard;
}


STRING get_guardP(c)
Class c;
{
	STRING guard;
	if(!get_option(&guard,c,hash("guardP")))
		guard= catstr(3,"_",get(c->name),"P_H_");
	return guard;
}


STRING get_headername(dir,c)
char *dir;
Class c;
{
	STRING t;
	static STRING file= ((STRING)NULL);
	char *s;
	if(file==((STRING)NULL))file= hash("file");
	s= Malloc(strlen(dir)+16);

	if(dir!=NULL&&dir[0]!='\0'){
		(void)strcpy(s,dir);
		if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
	}


	if(!get_option(&t,c,file))t= c->name;
	(void)strncat(s,get(t),12);
	(void)strcat(s,".h");
	t= hash(s);
	free(s);
	return t;
}


STRING get_headerPname(dir,c)
char *dir;
Class c;
{
	char *s;
	static STRING file= ((STRING)NULL);
	STRING t;
	if(file==((STRING)NULL))file= hash("file");
	s= Malloc(strlen(dir)+16);

	if(dir!=NULL&&dir[0]!='\0'){
		(void)strcpy(s,dir);
		if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
	}


	if(!get_option(&t,c,file))t= c->name;
	(void)strncat(s,get(t),11);
	(void)strcat(s,"P.h");
	t= hash(s);
	free(s);
	return t;
}


STRING get_implementationname(dir,c)
char *dir;
Class c;
{
	char *s;
	static STRING file= ((STRING)NULL);
	STRING t;
	if(file==((STRING)NULL))file= hash("file");
	s= Malloc(strlen(dir)+16);

	if(dir!=NULL&&dir[0]!='\0'){
		(void)strcpy(s,dir);
		if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
	}


	if(!get_option(&t,c,file))t= c->name;
	(void)strncat(s,get(t),12);
	(void)strcat(s,".c");
	t= hash(s);
	free(s);
	return t;
}


STRING get_docfilename(dir,c)
char *dir;
Class c;
{
	char *s;
	static STRING file= ((STRING)NULL);
	STRING t;
	if(file==((STRING)NULL))file= hash("file");
	s= Malloc(strlen(dir)+16);

	if(dir!=NULL&&dir[0]!='\0'){
		(void)strcpy(s,dir);
		if(dir[strlen(dir)-1]!='/')(void)strcat(s,"/");
	}


	if(!get_option(&t,c,file))t= c->name;
	(void)strncat(s,get(t),10);
	(void)strcat(s,".doc");
	t= hash(s);
	free(s);
	return t;
}


static Class find_class(name)
STRING name;
{
	Class h;
	h= classes;
	while(h&&h->name!=name)
		h= h->next;
	return h;
}


Section find_method(c,m)
Class c;
STRING m;
{
	Section d,h;
	if(c==NULL)return NULL;
	if((h= find_method(c->super,m)))
		return h;
	for(d= c->methods;d;d= d->next)
		if(d->decl&&d->decl->tp==Proc&&d->decl->name==m)return d;
	return NULL;
}


Boolean has_method(c,m)
Class c;
STRING m;
{
	Section d;
	for(d= c->methods;d;d= d->next)
		if(d->decl&&d->decl->tp==Proc&&d->decl->name==m)return True;
	return False;
}


Section find_pubvar(c,m)
Class c;
STRING m;
{
	Section d,h;
	if(c==NULL)return NULL;
	if((h= find_pubvar(c->super,m)))
		return h;
	for(d= c->publicvars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==m)return d;
	return NULL;
}


STRING find_classvar_value(c,name)
Class c;
STRING name;
{
	Section d;
	for(d= c->classvars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==name)
			return d->decl->value;
	if(c->super!=NULL)
		return find_classvar_value(c->super,name);
	else
		return NULL;
}


STRING find_instvar_value(c,name)
Class c;
STRING name;
{
	Section d;
	for(d= c->publicvars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==name)
			return d->decl->value;
	for(d= c->privatevars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==name)
			return d->decl->value;
	if(c->super!=NULL)
		return find_instvar_value(c->super,name);
	else
		return NULL;
}


void set_hierarchy()
{
	Class c;
	for(c= classes;c;c= c->next){
		c->super= find_class(c->superclass);
		if(c->super==NULL){
			c->sister= toplevel;
			toplevel= c;
		} else{
			c->sister= c->super->daughters;
			c->super->daughters= c;
		}
	}
}



Class find_classvar_class(c,name)
Class c;
STRING name;
{
	Class h;
	Section d;
	if(c==NULL)return NULL;
	if((h= find_classvar_class(c->super,name)))
		return h;
	for(d= c->classvars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==name)return c;
	return NULL;
}


Class find_instvar_class(c,name)
Class c;
STRING name;
{
	Class h;
	Section d;
	if(c==NULL)return NULL;
	if((h= find_instvar_class(c->super,name)))
		return h;
	for(d= c->publicvars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==name)return c;
	for(d= c->privatevars;d;d= d->next)
		if(d->decl&&d->decl->tp==Var&&d->decl->name==name)return c;
	return NULL;
}


Class find_method_class(c,name)
Class c;
STRING name;
{
	Class h;
	Section d;
	if(c==NULL)return NULL;
	if((h= find_method_class(c->super,name)))
		return h;
	for(d= c->methods;d;d= d->next)
		if(d->decl&&d->decl->tp==Proc&&d->decl->name==name)return c;
	return NULL;
}
