#ifndef _FDC_IO_H
#define _FDC_IO_H

/*
 * Copyright (C) 1993 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.9d/RCS/fdc-io.h,v $
 $Author: bas $
 *
 $Revision: 1.18 $
 $Date: 1994/01/16 15:44:54 $
 $State: ALPHA $
 *
 *      This file contains the low level functions
 *      that communicate with the floppy disk controller,
 *      for the QIC-40/80 floppy-tape driver for Linux.
 */

#include <linux/fdreg.h>
#include <linux/sched.h>
#include <linux/time.h>

#define MILLISECOND     1
#define SECOND          1000

#if !defined( HZ)
# error "HZ undefined."
#endif
#define MSPT (SECOND / HZ)      /* milliseconds per tick */

#define FLOPPY_DMA      2

#define FDC_SK_BIT      (0x20)
#define FDC_MT_BIT      (0x80)

#define FDC_READ        (FD_READ & ~(FDC_SK_BIT | FDC_MT_BIT))
#define FDC_WRITE       (FD_WRITE & ~FDC_MT_BIT)
#define FDC_READ_DELETED (0x4c)
#define FDC_WRITE_DELETED (0x49)
#define FDC_READID      (0x4a)
#define FDC_SENSED      (0x04)
#define FDC_SENSEI      (FD_SENSEI)
#define FDC_RECAL       (FD_RECALIBRATE)
#define FDC_SEEK        (FD_SEEK)
#define FDC_SPECIFY     (FD_SPECIFY)
#define FDC_RECALIBR    (FD_RECALIBRATE)

#define FDC_STATUS      (FD_STATUS)
#define FDC_DATA        (FD_DATA)
#define FDC_CONTROL     (FD_DOR)
#define FDC_VFO         (FD_DCR)

#define FDC_STATUS_MASK (STATUS_BUSY | STATUS_DMA | STATUS_DIR | STATUS_READY)
#define FDC_DATA_READY  (STATUS_READY)
#define FDC_DATA_OUTPUT (STATUS_DIR)
#define FDC_DATA_READY_MASK (STATUS_READY | STATUS_DIR)
#define FDC_DATA_OUT_READY  (STATUS_READY | STATUS_DIR)
#define FDC_DATA_IN_READY   (STATUS_READY)
#define FDC_BUSY        (STATUS_BUSY)

#define ST0_INT_MASK    (ST0_INTR)
#define FDC_INT_NORMAL  (ST0_INTR & 0x00)
#define FDC_INT_ABNORMAL (ST0_INTR & 0x40)
#define FDC_INT_INVALID (ST0_INTR & 0x80)
#define FDC_INT_READYCH (ST0_INTR & 0xC0)
#define ST0_SEEK_END    (ST0_SE)
#define ST3_TRACK_0     (ST3_TZ)

#define FDC_RESET_NOT   (0x04)
#define FDC_DMA_MODE    (0x08)
#define FDC_MOTOR_0     (0x10)
#define FDC_MOTOR_1     (0x20)

#define SECTOR_SIZE      (1024)

#define NR_ITEMS( x) (sizeof( x)/ sizeof( *x))
#define BUFF_SIZE (32*SECTOR_SIZE)

#ifdef NO_TRACE_AT_ALL
#define TOP_LEVEL -2
#else
#ifdef NO_TRACE
#define TOP_LEVEL 2
#else
#define TOP_LEVEL 10
#endif
#endif
#define TRACE_(l,f,m) \
{ \
 if (tracing >= (l) && (l) <= TOP_LEVEL) { \
    printk( "[%03d] " __FILE__ " (" f ") - ", (int)trace_id++); \
    m; \
  } \
}
#define TRACE(l,f,m) TRACE_(l,f,printk(m".\n"))
#define TRACEi(l,f,m,i) TRACE_(l,f,printk(m" %d.\n",i))
#define TRACElx(l,f,m,i) TRACE_(l,f,printk(m" 0x%08lx.\n",i))
#define TRACEx1(l,f,m,a) TRACE_(l,f,printk(m".\n",a))
#define TRACEx2(l,f,m,a,b) TRACE_(l,f,printk(m".\n",a,b))
#define TRACEx3(l,f,m,a,b,c) TRACE_(l,f,printk(m".\n",a,b,c))
#define TRACEx4(l,f,m,a,b,c,d) TRACE_(l,f,printk(m".\n",a,b,c,d))
#define TRACEx5(l,f,m,a,b,c,d,e) TRACE_(l,f,printk(m".\n",a,b,c,d,e))

#ifdef FDC_UNIT_SELECT
#define FTAPE_UNIT      (ftape_unit & 1)
#else
#define FTAPE_UNIT      0
#endif

typedef enum {
  empty = 0,
  reading,
  writing,
  full,
  error,
} buffer_state_enum;

typedef volatile enum {
  fdc_idle = 0,
  fdc_reading_data = FDC_READ,
  fdc_seeking = FDC_SEEK, 
  fdc_writing_data = FDC_WRITE,
  fdc_reading_id = FDC_READID,
  fdc_recalibrating = FDC_RECAL,
} fdc_mode_enum;

enum runner_status_enum {
  idle = 0,
  running,
  do_abort,
  aborting,
  logical_eot, 
  end_of_tape,
  buffer_overrun,
  buffer_underrun,
};        

typedef struct {
  volatile buffer_state_enum status;
  char* address;
  volatile unsigned int bytes;
  volatile unsigned int segment_id;
  volatile unsigned long crc_error_map;
} buffer_struct;

/*  this function only serves to suppress a compiler warning :-( */
static inline const char* RCSdummy( void) { return RCSid; }

/*
 *      fdc-io.c defined public variables
 */
extern fdc_mode_enum fdc_mode;
extern volatile enum runner_status_enum runner_status;
extern buffer_struct buffer[];
extern int old_vfo;
extern volatile int head;
extern volatile int tail;
extern int fdc_setup_error; /* outdated ??? */
extern volatile unsigned char fdc_head; /* FDC head */
extern volatile unsigned char fdc_cyl; /* FDC track */
extern volatile unsigned char fdc_sect; /* FDC sector */
extern int tracing;
extern unsigned char trace_id;
extern struct wait_queue *wait_intr;
extern unsigned char global_in[];
extern volatile unsigned int next_segment; /* next segment for read ahead */
extern volatile unsigned int bad_sector_map; /* bad sector map for one segment */
extern volatile unsigned int sector_count; /* nr of sectors to read from segment */
extern volatile unsigned int remaining; /* nr of sector remaining in segment */
extern volatile unsigned long int buffer_ptr; /* where to put next sector(s) */
extern volatile unsigned char sector_offset; /* offset for first sector to read */
extern int ftape_unit;          /* fdc unit specified at ftape_open() */
extern int ftape_motor;         /* fdc motor line state */
extern int current_cylinder;    /* track nr the FDC thinks we're on */
extern int expect_stray_interrupt; /* mask stray interrupts */
extern int seek_completed;      /* flag set by isr */
extern int interrupt_seen;      /* flag set by isr */

/*
 *      fdc-io.c defined public functions
 */
extern int fdc_ready_wait( int timeout);
extern int fdc_write( unsigned char data);
extern int fdc_read( unsigned char* data);
extern int fdc_command( unsigned char* cmd_data, int cmd_len);
extern int fdc_result( unsigned char* res_data, int res_len);
extern int fdc_issue_command( unsigned char *out_data, int out_count,\
                             unsigned char *in_data, int in_count);
extern void fdc_isr( void);
extern int fdc_interrupt_wait( int time);
extern void fdt_sleep( unsigned int time);
extern int fdc_specify( int head_unload_time, int seek_rate,
                       int head_load_time, int non_dma);
extern int fdc_set_seek_rate( int seek_rate);
extern int fdc_seek( int track);
extern int fdc_sense_drive_status( int *st3);
extern void fdc_motor(int motor);
extern void fdc_reset(void);
extern int fdc_recalibrate( void);
extern void fdc_disable( void);
extern int fdc_wait_calibrate( void);

/*
 *      A kernel hook: Should be changed...
 */
extern void (*do_floppy)(void); /* declared in ../../blk_drv/blk.h */

#endif
