: Use /bin/sh
#
# $Id: makedict.sh,v 1.5 89/04/28 01:12:10 geoff Exp $
#
# Copyright 1987, 1988, 1989, by Geoff Kuenning, Manhattan Beach, CA
# Permission for non-profit use is hereby granted.
# All other rights reserved.
# See "version.h" for a more complete copyright notice.
#
# $Log:	makedict.sh,v $
# Revision 1.5  89/04/28  01:12:10  geoff
# Change Header to Id;  nobody cares about my pathnames.
# 
# Revision 1.4  88/12/26  02:31:22  geoff
# Add a copyright notice.
# 
# Revision 1.3  87/09/24  23:24:28  geoff
# Get rid of colons in the optional-variable setting (Israel Pinkas).
# 
# Revision 1.2  87/05/28  21:15:29  geoff
# Fix a typo
# 
# Revision 1.1  87/05/10  20:19:23  geoff
# Initial revision
# 
#
#	Make a beginning dictionary file for ispell, using an existing
#	speller.
#
#	Usage:
#
#	makedict file-list
#
#	The specified files are collected, split into words, and run through
#	the system speller (usually spell(1)).  Any words that the speller
#	accepts will be written to the standard output for use in making
#	an ispell dictionary.  Usually, you will want to run the output
#	of this script through "munchlist" to get a final dictionary.
#

# This program must produce a list of INCORRECTLY spelled words on standard
# output, given a list of words on standard input.  If you don't have a
# speller, but do have a lot of correctly-spelled files, try /bin/true.
#
SPELLPROG="${SPELLPROG-spell}"

TMP=${TMPDIR-/tmp}/mkdict$$

case "$#" in
    0)
	set X -
	shift
	;;
esac

trap "/bin/rm ${TMP}; exit 1" 1 2 15

cat "$@" | deroff | tr -cs "[A-Z][a-z]'" '[\012*]' | sort -uf -o ${TMP}
$SPELLPROG < ${TMP} | comm -13 - ${TMP}
/bin/rm ${TMP}
