/*
 * msRusage.h	Get resource utilization
 *
 * Stefan Haenssgen 26-oct-92
 *
 * 26-oct-92	First implementation
 *
 */


#ifndef DEFINITION_msRusage

#include "MSHEADERS.LINX.h"
#include <sys/time.h>
#include <sys/resource.h>


extern void	RusageStart();		/* Set start for delta measuring*/

extern double	RusageUTime();		/* Spent user time in seconds	*/
extern double	RusageSTime();		/* Spent system time in seconds	*/
extern double	RusageTime();		/* Sum of the above		*/
extern long	RusageSwaps();		/* Number of swaps		*/
extern long	RusageSize();		/* Maximum process size in bytes*/
extern long	RusagePfaults();	/* Return # of page faults w.I/O*/

/* Same for delta times, i.e. since last call of RusageStart()		*/

extern double	RusageDUTime();		/* Spent user time in seconds	*/
extern double	RusageDSTime();		/* Spent system time in seconds	*/
extern double	RusageDTime();		/* Sum of the above		*/
extern long	RusageDSwaps();		/* Number of swaps		*/
extern long	RusageDSize();		/* Maximum process size in bytes*/
extern long	RusageDPfaults();	/* Return # of page faults w.I/O*/

/* from old msTimer module */
#define p_0_TimerStart RusageStart
#define p_0_TimerElapsed RusageDUTime


#endif
#define DEFINITION_msRusage
