/* GENERIC STDWIN -- INTERFACE HEADER FILE. */

#ifndef GENERIC_STDWIN

#define GENERIC_STDWIN
	/* So this header file is skipped if included twice */

#define CURSOR_CARET
	/* Defined so textedit will always set the caret at the start of
	   the focus -- useful only for ASCII terminals. */

#ifndef ARGS
#ifdef ANSI
#define ARGS(x) x
#else
#define ARGS(x) ()	/* replace by x for ANSI C */
#endif
#endif

#ifndef NOARGS
#ifdef ANSI
#define NOARGS (void)
#else
#define NOARGS ()	/* replace by (void) for ANSI C */
#endif
#endif

#ifndef bool
#define bool int
#endif

void winit NOARGS;
void winitnew ARGS((int *pargc, char ***pargv));
void wdone NOARGS;

void wgetscrsize ARGS((int *pwidth, int *pheight));
void wgetscrmm ARGS((int *pmmwidth, int *pmmheight));

void wsetmaxwinsize ARGS((int width, int height));

void wsetdefwinsize ARGS((int width, int height));
#define wsetdefwinpos(x,y) wsetposdefwin(x,y)
void wsetposdefwin ARGS((int h, int v));

#define wgetdefwinsize(x,y) wgetsizedefwin(x,y)
void wgetsizedefwin ARGS((int *width, int *height));
#define wgetdefwinpos(x,y) wgetposdefwin(x,y)
void wgetposdefwin ARGS((int *h, int *v));

/* The contents of a text attributes struct are disclosed here because
   the interface allows the programmer to declare objects of this type.
   (I'm not so sure anymore that this is the right thing to do!) */

struct textattr {
	short font;
	unsigned char size;
	unsigned char style;
};

#define TEXTATTR struct textattr

#ifndef WINDOW

struct window {
	short tag;
};

#define WINDOW struct window

#endif

WINDOW *wopencon ARGS((void (*drawproc)(/*WINDOW *win,
				int left, int top, int right, int bottom*/)));
WINDOW *wopen ARGS((char *title,
		void (*drawproc)(/*WINDOW *win,
				int left, int top, int right, int bottom*/)));
void wclose ARGS((WINDOW *win));
#define wgettag(win) ((win)->tag)
#define wsettag(win, newtag) ((win)->tag= newtag)
void wsetactive ARGS((WINDOW *win));
WINDOW *wgetactive NOARGS;
void wgetwinsize ARGS((WINDOW *win, int *width, int *height));
void wsetdocsize ARGS((WINDOW *win, int width, int height));
void wsettitle ARGS((WINDOW *win, char *title));

void wsetorigin ARGS((WINDOW *win, int h, int v));
void wshow ARGS((WINDOW *win, int left, int top, int right, int bottom));
void wchange ARGS((WINDOW *win, int left, int top, int right, int bottom));
void wscroll ARGS((WINDOW *win, int left, int top, int right, int bottom,
	int dh, int dv));

void wfleep NOARGS;
void wmessage ARGS((char *str));
void wperror ARGS((char *name));
bool waskstr ARGS((char *prompt, char *buf, int buflen));
int waskync ARGS((char *question, int dflt));
bool waskfile ARGS((char *prompt, char *buf, int buflen, bool newfile));

void wsetcaret ARGS((WINDOW *win, int h, int v));
void wnocaret ARGS((WINDOW *win));

void wsettimer ARGS((WINDOW *win, int deciseconds));

#define wmenusetitem(x,y,z) wmenuitemset(x,y,z)
#define wmenusetdeflocal(x) wmenudeflocalset(x)

void *wmenucreate ARGS((int id, char *title));
void wmenudelete ARGS((void *mp));
int  wmenuadditem ARGS((void *mp, char *text, int shortcut));
void wmenuitemset ARGS((void *mp, int i, char *text));
void wmenudeflocalset ARGS((bool local));
void wmenuattach ARGS((WINDOW *win, void *mp));
void wmenudetach ARGS((WINDOW *win, void *mp));
void wmenuenable ARGS((void *mp, int item, int flag));
void wmenucheck ARGS((void *mp, int item, int flag));

void wsetabout(char *title, int argc, char **argv);

/* The following is only available in termcap stdwin: */
void wsetshortcut ARGS((int id, int item, char *keys));

/* STDWIN -- EVENT STRUCT DEFINITION. */

struct event {
	int type;
	WINDOW *window;
	union {
	/* case WE_CHAR: */
		int character;
	/* case WE_COMMAND: */
		int command;
	/* case WE_MENU: */
		struct { int id; int item; } m;
	/* case WE_DRAW: */
		struct { int left, top, right, bottom; } area;
	/* case WE_MOUSE_DOWN, WE_MOUSE_MOVE, WE_MOUSE_UP: */
		struct {
			int v;
			int h;
			int clicks;
			int button;
			int mask;
		} where;
	} u;
};

#define EVENT struct event

/* Event types (should be grouped differently). */

#define WE_NULL		0	/* (Used internally) */
#define WE_ACTIVATE	1	/* Window became active */
#define WE_CHAR		2	/* Character typed at keyboard */
#define WE_COMMAND	3	/* Special command, function key etc. */
#define WE_MOUSE_DOWN	4	/* Mouse button pressed */
#define WE_MOUSE_MOVE	5	/* Mouse moved with button down */
#define WE_MOUSE_UP	6	/* Mouse button released */
#define WE_MENU		7	/* Menu item selected */
#define WE_SIZE		8	/* Window size changed */
#define WE_MOVE		9	/* (Reserved) */
#define WE_DRAW		10	/* Request to redraw part of window */
#define WE_TIMER	11	/* Window's timer went off */
#define WE_DEACTIVATE	12	/* Window became inactive */

/* Command codes for WE_COMMAND.
   Special ways of entering these are usually available,
   such as clicking icons, standard menu items or special keys.
   Some ASCII keys are also passed back as commands since they
   more often than not need special processing. */

#define WC_CLOSE	1	/* Should become a separate event! */
/* The following four are arrow keys */
#define WC_LEFT		2
#define WC_RIGHT	3
#define WC_UP		4
#define WC_DOWN		5
/* ASCII keys */
#define WC_CANCEL	6
#define WC_BACKSPACE	7
#define WC_TAB		8
#define WC_RETURN	9
/* IBM-PC keys -- not in all implementations */
#define WC_HOME		10
#define WC_END		11
#define WC_CLEAR	12
#define WC_INS		13
#define WC_DEL		14
#define WC_PAGE_UP	15
#define WC_PAGE_DOWN	16
#define WC_META_LEFT	17
#define WC_META_RIGHT	18
#define WC_META_HOME	19
#define WC_META_END	20
#define WC_META_PAGE_UP	21
#define WC_META_PAGE_DOWN	22
/* Should have entries for Alt-letter and F1-F10 etc. ? */

void wgetevent ARGS((EVENT *ep));
void wpollevent ARGS((EVENT *ep));
void wungetevent ARGS((EVENT *ep));
void wsetkeyhandler ARGS((bool (*own_keybd)(EVENT *,
	 int asciipart, int metakeys, int keynumber, int termcap)));
void wupdate ARGS((WINDOW *win));
void wbegindrawing ARGS((WINDOW *win));
void wenddrawing ARGS((WINDOW *win));
void wflush NOARGS;

void wdrawline ARGS((int h1, int v1, int h2, int v2));
void wxorline ARGS((int h1, int v1, int h2, int v2));
void wdrawcircle ARGS((int h, int v, int radius));
void wdrawelarc ARGS((int h, int v, int hrad, int vrad, int ang1, int ang2));
void wdrawbox ARGS((int left, int top, int right, int bottom));
void werase ARGS((int left, int top, int right, int bottom));
void wpaint ARGS((int left, int top, int right, int bottom));
void winvert ARGS((int left, int top, int right, int bottom));
void wshade ARGS((int left, int top, int right, int bottom, int percent));

int wdrawtext ARGS((int h, int v, char *str, int len));
int wdrawchar ARGS((int h, int v, int c));
int wlineheight NOARGS;
int wbaseline NOARGS;
int wtextwidth ARGS((char *str, int len));
int wcharwidth ARGS((int c));
int wtextbreak ARGS((char *str, int len, int width));

void wgettextattr ARGS((TEXTATTR *attr));
void wsettextattr ARGS((TEXTATTR *attr));
void wgetwintextattr ARGS((WINDOW *win, TEXTATTR *attr));
void wsetwintextattr ARGS((WINDOW *win, TEXTATTR *attr));

void wsetplain NOARGS;
void wsethilite NOARGS;
void wsetinverse NOARGS;
void wsetitalic NOARGS;
void wsetbold NOARGS;

#define wsetbolditalic wsetbitalic
void wsetbitalic NOARGS;
void wsetunderline NOARGS;

void wnoerase ARGS((int noeraseflag));

void wsetfont ARGS((char *fontname));
void wsetsize ARGS((int pointsize));

struct m_item {
	int	id ;
	char	*line ;
	char	*ittext ;
	char	*sctext ;
	int	enabled ;
	int	checked ;
} ;

struct menu {
	int	id ;
	char	*title ;
	bool	local ;
	bool	dirty ;
	int	maxlen ;
	int	nritems ;
	struct m_item	**itemlist ;
} ;

#define MENU struct menu

#endif /* GENERIC_STDWIN */
