/* STDWIN INTERFACE */

#ifndef __STDWIN_H__    /* Guard against multiple inclusion */
#define __STDWIN_H__


/* Definition of _ARGS() macro */

#ifndef _ARGS
#ifdef __STDC__
#define _ARGS(x) x
#else
#define _ARGS(x) ()
#endif
#endif /* _ARGS */

/* Definition of _VARARGS() macro */

#ifndef _VARARGS
#if defined(__STDC__) && defined(CONFIG) /* prototypes? config.h included? */
#ifdef HAVE_STDARG_H
#define _VARARGS(x) x
#else
#ifdef HAVE_VARARGS_H
#include <varargs.h>
#define _VARARGS(x) va_dcl
#else
#define _VARARGS(x) ()
#endif
#endif
#else
#define _VARARGS(x) ()
#endif
#endif /* _VARARGS */

/* Lists of ports of STDWIN we implement */

#include "ports.h"


/***********************************/
/* Section 1.  Types and constants */
/***********************************/


/* Boolean data type: */
#ifndef bool
#define bool int        /* For single variable, argument or return value */
#define tbool char      /* Tiny bool, used in structs or arrays */
#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif
#endif


/* These structs are implementation-dependent, the user only sees
   pointers to them */

#define WINDOW struct _window
#define MENU struct _menu
#define CURSOR struct _cursor


/* Fake window type used by the wgettag() and wsettag() macros */

struct _fakewindow {
        short tag;
};

#define _FAKEWINDOW struct _fakewindow


/* Fake menu type, see Ports/x11/x11.h and Ports/alfa/menu.h */

struct _fakemenu {
        int id;
        char *title;
        int nitems;
};

#define _FAKEMENU struct _fakemenu


/* EVENT struct */

struct _event {
        int type;
        WINDOW *window;
        union {
        /* case WE_CHAR: */
                int character;
        /* case WE_COMMAND: */
                int command;
        /* case WE_MENU: */
                struct { int id; int item; } m;
        /* case WE_DRAW: */
                struct { int left, top, right, bottom; } area;
        /* case WE_MOUSE_DOWN, WE_MOUSE_MOVE, WE_MOUSE_UP: */
                struct {
                        int h;
                        int v;
                        int clicks;
                        int button;
                        int mask;
                } where;
        /* case WE_LOST_SEL: */
                int sel;
        /* case WE_KEY: */
                struct { int code; int mask; } key;
        } u;
};

#define EVENT struct _event


/* Event types */
/* XXX Should be reordered */

#define WE_NULL         0       /* (Used internally) */
#define WE_ACTIVATE     1       /* Window became active */
#define WE_CHAR         2       /* Character typed at keyboard */
#define WE_COMMAND      3       /* Special command, function key etc. */
#define WE_MOUSE_DOWN   4       /* Mouse button pressed */
#define WE_MOUSE_MOVE   5       /* Mouse moved with button down */
#define WE_MOUSE_UP     6       /* Mouse button released */
#define WE_MENU         7       /* Menu item selected */
#define WE_SIZE         8       /* Window size changed */
#define WE_MOVE         9       /* Window moved (reserved) */
#define WE_DRAW         10      /* Request to redraw part of window */
#define WE_TIMER        11      /* Window's timer went off */
#define WE_DEACTIVATE   12      /* Window became inactive */
#define WE_EXTERN       13      /* Externally generated event (Amoeba) */
#define WE_KEY          14      /* Non-ASCII key event */
#define WE_LOST_SEL     15      /* Lost selection */
#define WE_CLOSE        16      /* User wants to close window */


/* Special keys reported by WE_COMMAND */
/* XXX Should become key events */

#define WC_CLOSE        1       /* Obsolete */
/* The following four are arrow keys */
#define WC_LEFT         2
#define WC_RIGHT        3
#define WC_UP           4
#define WC_DOWN         5
/* ASCII keys */
#define WC_CANCEL       6
#define WC_BACKSPACE    7
#define WC_TAB          8
#define WC_RETURN       9
/* IBM-PC keys -- not in all implementations */
/* XXX Should be done differently */
#define WC_HOME         10
#define WC_END          11
#define WC_CLEAR        12
#define WC_INS          13
#define WC_DEL          14
#define WC_PAGE_UP      15
#define WC_PAGE_DOWN    16
#define WC_META_LEFT    17
#define WC_META_RIGHT   18
#define WC_META_HOME    19
#define WC_META_END     20
#define WC_META_PAGE_UP 21
#define WC_META_PAGE_DOWN       22
/* XXX Should have entries for Alt-letter and F1-F10 etc. ? */


/* Codes for selections (e.u.sel for WE_LOST_SEL) */

#define WS_CLIPBOARD    0
#define WS_PRIMARY      1
#define WS_SECONDARY    2


/* Masks for EVENT->u.where.mask and EVENT->u.key.mask.
   Some of these happen to be the same as the X11 masks (which are cast
   in stone for eternity); the implementation relies on that.
   (It is merely a convention that Meta is bit 3, and Option/Num aren't
   normally used in X11.) */

#define WM_SHIFT        (1 << 0)
#define WM_LOCK         (1 << 1)
#define WM_CONTROL      (1 << 2)
#define WM_META         (1 << 3)
#define WM_OPTION       (1 << 4)
#define WM_NUM          (1 << 5)

#define WM_BUTTON1      (1 << 8)
#define WM_BUTTON2      (1 << 9)
#define WM_BUTTON3      (1 << 10)
#define WM_BUTTON4      (1 << 11)
#define WM_BUTTON5      (1 << 12)


/* TEXTATTR struct */

/* The contents of a text attributes struct are disclosed here because
   the interface allows the programmer to declare objects of this type.
   (I'm not so sure anymore that this is the right thing to do!) */

struct _textattr {
        short font;
        unsigned char size;
        unsigned char style;
};

#define TEXTATTR struct _textattr


/* Color */

#define COLOR long


/* Point type for wdrawpoly and wfillpoly -- compatible with X */

struct _point {
        short h, v;
};
#define POINT struct _point


/*************************************/
/* Section 2.  Function declarations */
/*************************************/

#if defined(BOTH_X11_ALFA) && !defined(wdone)

/* Include prototypes for the x11 port functions */
#include "only_x11.h"
#include "stdwproto.h"
#include "only.h"

/* Include prototypes for the alfa port functions */
#include "only_alfa.h"
#include "stdwproto.h"
#include "only.h"

/* run-time dispatch between both the x11 and the alfa port */
#include "both_x11_alfa.h"

#else

/* Include prototypes */
#include "stdwproto.h"

#endif


/* STDWIN TEXTEDIT PACKAGE INTERFACE */

#define TEXTEDIT struct _textedit

extern TEXTEDIT *tealloc _ARGS((WINDOW *win, int left, int top, int width));
extern TEXTEDIT *tecreate _ARGS((WINDOW *win,
        int left, int top, int right, int bottom));
extern void tefree _ARGS((TEXTEDIT *tp));
extern void tedestroy _ARGS((TEXTEDIT *tp));
extern void tesetactive _ARGS((TEXTEDIT *tp, bool active));

extern void tedraw _ARGS((TEXTEDIT *tp));
extern void tedrawnew _ARGS((TEXTEDIT *tp,
        int left, int top, int right, int bottom));
extern void temove _ARGS((TEXTEDIT *tp, int left, int top, int width));
extern void temovenew _ARGS((TEXTEDIT *tp,
        int left, int top, int right, int bottom));

extern void tesetview _ARGS((TEXTEDIT *tp, int left, int top, int right, int bottom));
extern void tenoview _ARGS((TEXTEDIT *tp));

extern void tesetfocus _ARGS((TEXTEDIT *tp, int foc1, int foc2));
extern void tereplace _ARGS((TEXTEDIT *tp, char *str));
extern void tesetbuf _ARGS((TEXTEDIT *tp, char *buf, int buflen));

extern void tearrow _ARGS((TEXTEDIT *tp, int code));
extern void tebackspace _ARGS((TEXTEDIT *tp));
extern bool teclicknew _ARGS((TEXTEDIT *tp, int h, int v, bool extend, bool dclick));
extern bool tedoubleclick _ARGS((TEXTEDIT *tp, int h, int v));
extern bool teevent _ARGS((TEXTEDIT *tp, EVENT *ep));

#define teclick(tp, h, v) teclicknew(tp, h, v, FALSE)
#define teclickextend(tp, h, v) teclicknew(tp, h, v, TRUE)

extern char *tegettext _ARGS((TEXTEDIT *tp));
extern int tegetlen _ARGS((TEXTEDIT *tp));
extern int tegetnlines _ARGS((TEXTEDIT *tp));
extern int tegetfoc1 _ARGS((TEXTEDIT *tp));
extern int tegetfoc2 _ARGS((TEXTEDIT *tp));
extern int tegetleft _ARGS((TEXTEDIT *tp));
extern int tegettop _ARGS((TEXTEDIT *tp));
extern int tegetright _ARGS((TEXTEDIT *tp));
extern int tegetbottom _ARGS((TEXTEDIT *tp));

/* Text paragraph drawing functions: */

extern int wdrawpar _ARGS((int h, int v, char *text, int width));
        /* Returns new v coord. */
extern int wparheight _ARGS((char *text, int width));
        /* Returns height */

/* Formatted output to text windows: */

extern void wprintf _VARARGS((int h, int v, char *fmt, ...));
extern void wcprintf _VARARGS((int align, int h, int v, char *fmt, ...));


#endif /* __STDWIN_H__ */
