------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                   S Y S T E M . E N V I R O N M E N T                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.8 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains functions to access arguments on the command line

package System.Environment is

   type Arg_Ptr is access String;

   function Arg_Count return Positive;
   pragma Interface (C, Arg_Count);
   --  Return the number of arg in the command line (equivalent to argc in C)
   --  Note in particular that the count is one more than might be expected,
   --  since it includes Arg_Value (0) which is the command name.

   function Arg_Value (Arg_Num : Natural) return Arg_Ptr;
   --  Return the desired arg. from the command line (0 is the command name)

end System.Environment;
