------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--              A D A . T A S K _ I D E N T I F I C A T I O N               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_Clock;

package Ada.Real_Time is

   pragma Unimplemented_Unit;

   type Time is private;

   Time_First : constant Time;
   Time_Last  : constant Time;

   Time_Unit : constant := 10#1.0#E-9;

   type Time_Span is private;

   Time_Span_First : constant Time_Span;
   Time_Span_Last  : constant Time_Span;
   Time_Span_Zero  : constant Time_Span;
   Time_Span_Unit  : constant Time_Span;

   Tick : constant Time_Span;

   function Clock return Time;

   function "+"  (Left : Time;      Right : Time_Span) return Time;
   function "+"  (Left : Time_Span; Right : Time)      return Time;
   function "-"  (Left : Time;      Right : Time_Span) return Time;
   function "-"  (Left : Time;      Right : Time)      return Time_Span;

   function "<"  (Left, Right : Time) return Boolean;
   function "<=" (Left, Right : Time) return Boolean;
   function ">"  (Left, Right : Time) return Boolean;
   function ">=" (Left, Right : Time) return Boolean;

   function "+"  (Left, Right : Time_Span) return Time_Span;
   function "-"  (Left, Right : Time_Span) return Time_Span;

   function "-"  (Right : Time_Span) return Time_Span;

   function "/"  (Left, Right : Time_Span) return Integer;

   function "/"  (Left : Time_Span; Right : Integer) return Time_Span;

   function "*"  (Left : Time_Span; Right : integer)   return Time_Span;
   function "*"  (Left : Integer;   Right : Time_Span) return Time_Span;

   function "<"  (Left, Right : Time_Span) return Boolean;
   function "<=" (Left, Right : Time_Span) return Boolean;
   function ">"  (Left, Right : Time_Span) return Boolean;
   function ">=" (Left, Right : Time_Span) return Boolean;

   function "abs" (Right : Time_Span) return Time_Span;

   function To_Duration  (TS : Time_Span) return Duration;
   function To_Time_Span (D  : Duration)  return Time_Span;

   function Nanoseconds  (NS : Integer) return Time_Span;
   function Microseconds (US : Integer) return Time_Span;
   function Milliseconds (MS : Integer) return Time_Span;

   protected Delay_Object is
      entry Wait (TS : Time_Span);
   private
   end Delay_Object;

   type Seconds_Count is range -Integer'Last .. Integer'Last;
   --  Symmetrical range to avoid some overflow problems

   procedure Split (T : in Time; SC : out Seconds_Count; TS : out Time_Span);

   function Time_Of (SC : Seconds_Count; TS : Time_Span) return Time;

private
   type Time is new System.Task_Clock.Stimespec;

   Time_First : constant Time := Time (System.Task_Clock.Stimespec_First);
   Time_Last  : constant Time := Time (Sustem.Task_Clock.Stimespec_Last);

   type Time_Span is new System.Task_Clock.Stimespec;

   Time_Span_First : constant Time_Span :=
     Time_Span (System.Task_Clock.Stimespec_First);

   Time_Span_Last  : constant Time_Span :=
     Time_Span (System.Task_Clock.Stimespec_Last);

   Time_Span_Zero  : constant Time_Span :=
     Time_Span (System.Task_Clock.Stimespec_Zero);

   Time_Span_Unit  : constant Time_Span :=
     Time_Span (System.Task_Clock.Stimespec_Unit);

   Ticks           : constant Time_Span :=
     Time_Span (System.Task_Clock.Stimespec_Ticks);

end Ada.Real_Time;
