#ifndef _VENDORS_H
#define _VENDORS_H

/*
 *      Copyright (C) 1993,1994 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-1.12/RCS/vendors.h,v $
 $Author: bas $
 *
 $Revision: 1.16 $
 $Date: 1994/05/26 23:43:45 $
 $State: Beta $
 *
 *      This file contains the supported drive types
 *      with their QIC-117 spec. vendor code and
 *      drive dependent configuration information.
 */

typedef enum {
  unknown_wake_up = 0,
  no_wake_up,
  wake_up_colorado,
  wake_up_mountain,
  wake_up_insight,
} wake_up_types;

typedef struct {
  wake_up_types wake_up;        /* see wake_up_types */
  char *name;                   /* Text describing the drive */
} wakeup_method;

/*  Note: order of entries in WAKEUP_METHODS must be so that a variable
 *        of type wake_up_types can be used as an index in the array.
 */
#define WAKEUP_METHODS { \
  { unknown_wake_up,    "Unknown" }, \
  { no_wake_up,         "None" }, \
  { wake_up_colorado,   "Colorado" }, \
  { wake_up_mountain,   "Mountain" }, \
  { wake_up_insight,    "Motor-on" }, \
}

typedef struct {
  unsigned int vendor_id;       /* vendor id from drive */
  wake_up_types wake_up;        /* see wake_up_types */
  char *name;                   /* Text describing the drive */
} vendor_struct;

#define UNKNOWN_VENDOR (-1)

#define QIC117_VENDORS { \
/* see _vendor_struct */ \
  { 0x00047, wake_up_colorado,  "Colorado DJ-10/DJ-20" }, \
  { 0x011c4, wake_up_colorado,  "Colorado DJ-10/DJ-20 (new)" }, \
  { 0x00005, wake_up_mountain,  "Archive 5580i" }, \
  { 0x10005, wake_up_insight,   "Insight 80 Mb" }, \
  { 0x0014a, wake_up_mountain,  "Archive XL9250i [Conner/Escom]" }, \
  { 0x0014c, wake_up_mountain,  "Conner C250MQT" }, \
  { 0x001c1, no_wake_up,        "Wangtek 3040F" }, \
  { 0x001c8, wake_up_colorado,  "Wangtek 3080F" }, \
  { 0x08880, no_wake_up,        "Iomega 250" }, \
  { 0x00146, wake_up_mountain,  "Escom/Archive 31250Q" }, \
  { 0x00180, wake_up_mountain,  "Summit SE 150" }, \
  { 0x00181, wake_up_mountain,  "Summit SE 250, Mountain FS8000" }, \
  { 0x00140, wake_up_mountain,  "Identity IDTBU120E, Escom ?" }, \
}

#define QIC117_MAKE_CODES { \
  { 0, "Unassigned" }, \
  { 1, "Colorado" }, \
  { 5, "Archive/Conner" }, \
  { 6, "Summit" }, \
  { 7, "Wangtek" }, \
  { 71, "Colorado+" }, \
  { 546, "Iomega" }, \
}

#endif
