.\" $Xorg: xfd.man,v 1.4 2001/02/09 02:05:42 xorgcvs Exp $
.\" Copyright 1989, 1994, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xfd/xfd.man,v 1.9 2003/04/19 23:49:27 herrb Exp $
.\"
.TH XFD 1 __xorgversion__
.SH NAME
xfd \- display all the characters in an X font
.SH SYNOPSIS
.B xfd
[\-options ...] \fB\-fn\fP \fIfontname\fP
.PP
.B xfd
[\-options ...] \fB\-fa\fP \fIfontname\fP
.SH DESCRIPTION
The \fIxfd\fP utility creates a window containing the name of the font being
displayed, a row of command buttons, several lines of text for displaying
character metrics, and a grid containing one glyph per cell.  The
characters are shown in increasing order from left to right, top to
bottom.  The first character displayed at the top left will be character
number 0 unless the \fB\-start\fP option has been supplied in which case the
character with the number given in the \fB\-start\fP option will be used.
.PP
The characters are displayed in a grid of boxes, each large enough to hold
any single character in the font.  Each character glyph is drawn using
the PolyText16 request (used by the \fIXlib\fP routine \fBXDrawString16\fP)
or the XftDrawString32 routine, depending on whether the \fB\-fn\fP or
\fB\-fa\fP option was given.
If the \fB\-box\fP option is given, a rectangle will be drawn around each
character, showing where an ImageText16 request (used by the \fIXlib\fP
routine \fBXDrawImageString16\fP) would cause background color to be displayed.
.PP
The origin of each glyph is normally set so that the character is drawn in
the upper left hand corner of the grid cell.  However, if a glyph has a
negative left bearing or an unusually large ascent, descent, or right bearing
(as is the case with \fIcursor\fP font), some character may not appear in their
own grid cells.  The \fB\-center\fP option may be used to force all glyphs to
be centered in their respective cells.
.PP
All the characters in the font may not fit in the window at once.
To see the next page of glyphs, press the \fINext\fP button at the top
of the window.  To see the previous page, press \fIPrev\fP.  To exit \fIxfd\fP,
press \fIQuit\fP.
.PP
Individual character metrics (index, width, bearings, ascent and descent) can
be displayed at the top of the window by clicking on the desired character.
.PP
The font name displayed at the top of the window is the full name of the
font, as determined by the server.  See \fIxlsfonts\fP and \fIfc-list\fP
for ways to generate lists of fonts, as well as more detailed summaries of
their metrics and properties.
.SH "OPTIONS"
.PP
.I xfd
accepts all of the standard toolkit command line options along with
the additional options listed below:
.TP 8
.B \-fn \fIfont\fP
This option specifies the core X server side font to be displayed.
This can also be set with
the FontGrid \fBfont\fP resource.  A font must be specified.
.TP 8
.B \-fa \fIfont\fP
This option specifies a Xft font to be displayed. This can also be set with
the FontGrid \fBface\fP resource. A font pattern must be specified.
.TP 8
.B \-box
This option indicates that a box should be displayed outlining the area
that would be filled with background color by an ImageText request.
This can also be set with
the FontGrid \fBboxChars\fP resource.  The default is False.
.TP 8
.B \-center
This option indicates that each glyph should be centered in its grid.
This can also be set with
the FontGrid \fBcenterChars\fP resource.  The default is False.
.TP 8
.B \-start \fInumber\fP
This option specifies the glyph index of the upper left hand corner of the
grid.  This is used to view characters at arbitrary locations in the font.
This can also be set with
the FontGrid \fBstartChar\fP resource.  The default is 0.
.TP 8
.B \-bc \fIcolor\fP
This option specifies the color to be used if ImageText boxes are drawn.
This can also be set with
the FontGrid \fBboxColor\fP resource.
.TP 8
.B \-rows \fInumrows\fP
This option specifies the number of rows in the grid.
This can also be set with
the FontGrid \fBcellRows\fP resource.
.TP 8
.B \-columns \fInumcols\fP
This option specifies the number of columns in the grid.
This can also be set with
the FontGrid \fBcellColumns\fP resource.
.SH WIDGETS
In order to specify resources, it is useful to know the
widgets which compose \fIxfd\fR.  In the notation below, indentation
indicates hierarchical structure.  The widget class name is given first,
followed by the widget instance name.
The application class name is Xfd.
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i 6.5i 7.0i
Xfd  xfd
	Paned  pane
		Label  fontname
		Box  box
			Command  quit
			Command  prev
			Command  next
		Label  select
		Label  metrics
		Label  range
		Label  start
		Form  form
			FontGrid  grid
.fi
.SH FONTGRID RESOURCES
The FontGrid widget is an application-specific widget, and a subclass
of the Simple widget in the Athena widget set.  The effects and
instance names of this widget's resources are given in the
\fBOPTIONS\fP section.  Capitalize the first letter of the resource
instance name to get the corresponding class name.
.SH APPLICATION SPECIFIC RESOURCES
The instance names of the application specific resources
are given below.  Capitalize the first letter of the resource
instance name to get the corresponding class name.
These resources are unlikely to be interesting unless you are localizing
xfd for a different language.
.TP 8
.B selectFormat
Specifies a printf-style format string used to display information
about the selected character.  The default is "character 0x%02x%02x
(%u,%u) (%#o,%#o)".  The arguments that will come after the format string are
char.byte1, char.byte2, char.byte1, char.byte2, char.byte1, char.byte2.
char.byte1 is byte 1 of the selected character.
char.byte2 is byte 2 of the selected character.
.TP 8
.B metricsFormat
Specifies a printf-style format string used to display character
metrics.  The default is "width %d; left %d, right %d; ascent %d,
descent %d (font %d, %d)".  The arguments that will come after the
format string are the character metrics width, lbearing, rbearing,
character ascent, character descent, font ascent, and font descent.
.TP 8
.B rangeFormat
Specifies a printf-style format string used to display the range of
characters currently being displayed.  The default is "range:
0x%02x%02x (%u,%u) thru 0x%02x%02x (%u,%u)".  The arguments that will
come after the format string are the following fields from the
XFontStruct that is returned from opening the font:
min_byte1, min_char_or_byte2, min_byte1, min_char_or_byte2,
max_byte1, max_char_or_byte2, max_byte1, max_char_or_byte2.
.TP 8
.B startFormat
Specifies a printf-style format string used to display information
about the character at the upper left corner of the font grid.  The
default is "upper left: 0x%04x (%d,%d)".  The arguments that will come
after the format string are the new character, the high byte of the new
character, and the low byte of the new character.
.TP 8
.B nocharFormat
Specifies a printf-style format string to display when the selected
character does not exist.  The default is "no such character
0x%02x%02x (%u,%u) (%#o,%#o)".  The arguments that will come after the
format string are the same as for the \fBselectFormat\fP resource.
.SH "SEE ALSO"
X(__miscmansuffix__), xlsfonts(__appmansuffix__), xrdb(__appmansuffix__), xfontsel(__appmansuffix__), fc-list(__appmansuffix__),
fonts.conf(__filemansuffix__),
.I "X Logical Font Description Conventions"
.SH "BUGS"
The program should skip over pages full of non-existent characters.
.SH AUTHOR
Jim Fulton, MIT X Consortium; previous program of the same name by
Mark Lillibridge, MIT Project Athena.

