/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* system.sql */

static const char *tbl0 = 
"create table SYS_VT_INDEX (VI_TABLE varchar, VI_INDEX varchar, VI_COL varchar,\n"
"VI_ID_COL varchar, VI_INDEX_TABLE varchar,\n"
"VI_ID_IS_PK integer, VI_ID_CONSTR varchar,\n"
"VI_OFFBAND_COLS varchar, VI_OPTIONS varchar, VI_LANGUAGE varchar,\n"
"primary key (VI_TABLE, VI_COL))\n"
"alter index SYS_VT_INDEX on SYS_VT_INDEX partition cluster REPLICATED\n";

static const char *tbl1 = 
"create table DB.DBA.SYS_CACHED_RESOURCES\n"
"(\n"
"CRES_URI              varchar not null,\n"
"CRES_PUBLIC_ID        varchar,\n"
"CRES_CONTENT          long varchar,\n"
"CRES_LOADING_DATE     datetime,\n"
"CRES_COMMENT          long varchar,\n"
"primary key (CRES_URI)\n"
")\n";

static const char *proc0 = 
"create procedure DB.DBA.SYS_CACHED_RESOURCE_ADD (\n"
"in _uri varchar, in _public_id varchar,\n"
"in _content varchar, in _loading_date datetime, in _comment varchar)\n"
"{\n"
"if (exists (\n"
"select top 1 1 from DB.DBA.SYS_CACHED_RESOURCES\n"
"where CRES_URI = _uri and CRES_PUBLIC_ID = _public_id and\n"
"blob_to_string (CRES_CONTENT) = _content and\n"
"CRES_LOADING_DATE = _loading_date and\n"
"blob_to_string (CRES_COMMENT) = _comment ) )\n"
"return;\n"
"insert replacing DB.DBA.SYS_CACHED_RESOURCES\n"
"(CRES_URI, CRES_PUBLIC_ID, CRES_CONTENT, CRES_LOADING_DATE, CRES_COMMENT)\n"
"values (_uri, _public_id, _content, _loading_date, _comment);\n"
"commit work;\n"
"}\n"
"--src system.sql:42\n";

static const char *proc1 = 
" create procedure WS.WS.PARSE_URI (in uri varchar)\n"
"{\n"
"return rfc1808_parse_uri (uri);\n"
"}\n"
"--src system.sql:70\n";

static const char *proc2 = 
" create function WS.WS.EXPAND_URL (in base varchar, in rel varchar, in output_charset varchar := null) returns any\n"
"{\n"
"\n"
"\n"
"return rfc1808_expand_uri (base, rel, output_charset);\n"
"}\n"
"--src system.sql:78\n";

static const char *proc3 = 
"create procedure repl_undot_name (in id varchar)\n"
"{\n"
"declare last_dot_inx integer;\n"
"last_dot_inx := strrchr(id, \'.\');\n"
"if (last_dot_inx > 0)\n"
"return subseq(sprintf(\'%s\', id), last_dot_inx + 1);\n"
"else\n"
"return id;\n"
"}\n"
"--src system.sql:86\n";

static const char *proc4 = 
"create procedure REPL_FQNAME (in _tbl varchar)\n"
"{\n"
"declare _parts any;\n"
"_parts := vector (\'\', \'\', \'\');\n"
"declare _ix, _len integer;\n"
"_ix := 0;\n"
"_len := length (_parts);\n"
"while (_ix < _len)\n"
"{\n"
"declare _p any;\n"
"_p := name_part (_tbl, _ix);\n"
"if (isstring (_p))\n"
"_parts[_ix] := sprintf (\'\"%I\"\', _p);\n"
"_ix := _ix + 1;\n"
"}\n"
"return concat (_parts[0], \'.\', _parts[1], \'.\', _parts[2]);\n"
"}\n"
"--src system.sql:97\n";

static const char *proc5 = 
"create procedure REPL_COLTYPE_PS (\n"
"in _coltype varchar,\n"
"in _col_dtp integer, in _col_prec integer, in _col_scale integer)\n"
"returns varchar\n"
"{\n"
"if ((_col_dtp = 181 or _col_dtp = 182 or _col_dtp = 192 or\n"
"_col_dtp = 222 or _col_dtp = 225)\n"
"and _col_prec is not null and _col_prec <> 0)\n"
"{\n"
"\n"
"declare _pos integer;\n"
"declare _len_spec varchar;\n"
"_pos := strstr (_coltype, \'()\');\n"
"_len_spec := sprintf (\'(%d)\', _col_prec);\n"
"if (_pos is null)\n"
"_coltype := concat (_coltype, _len_spec);\n"
"else\n"
"{\n"
"declare _prefix, _suffix varchar;\n"
"_prefix := subseq (_coltype, 0, _pos);\n"
"_suffix := subseq (_coltype, _pos + 2);\n"
"_coltype := concat (_prefix, _len_spec, _suffix);\n"
"}\n"
"}\n"
"else if (_col_dtp = 219)\n"
"{\n"
"\n"
"if (_col_prec < _col_scale)\n"
"_col_scale := 0;\n"
"_coltype := concat (_coltype, sprintf(\'(%d, %d)\', _col_prec, _col_scale));\n"
"}\n"
"return _coltype;\n"
"}\n"
"--src system.sql:116\n";

static const char *proc6 = 
"create procedure REPL_COLTYPE (in _col any) returns varchar\n"
"{\n"
"declare _col_dtp, _col_prec, _col_scale integer;\n"
"_col_dtp := aref (_col, 1);\n"
"_col_scale := aref (_col, 2);\n"
"_col_prec := aref (_col, 3);\n"
"\n"
"if (_col_dtp = 219)\n"
"{\n"
"if (_col_scale > 15)\n"
"_col_scale := 15;\n"
"if (_col_prec > 40)\n"
"_col_prec := 40;\n"
"}\n"
"return REPL_COLTYPE_PS (\n"
"dv_type_title(_col_dtp), _col_dtp, _col_prec, _col_scale);\n"
"}\n"
"--src system.sql:151\n";

static const char *proc7 = 
"create procedure WS.WS.HEX_DIGIT (in i integer)\n"
"{\n"
"if ( i >= 0 and i < 10)\n"
"return i + ascii (\'0\');\n"
"if ( i > 9 and  i < 16 )\n"
"return i + ascii (\'A\') - 10;\n"
"return ascii (\'0\');\n"
"}\n"
"--src system.sql:170\n";

static const char *proc8 = 
"create procedure WS.WS.STR_SQL_APOS (in str varchar)\n"
"{\n"
"declare tmp varchar;\n"
"declare inx, inx1, len integer;\n"
"declare c char;\n"
"declare cascii integer;\n"
"len := length (str);\n"
"\n"
"if (len = 0)\n"
"return \'\'\'\'\'\';\n"
"tmp := space(len * 4 + 2);\n"
"\n"
"aset(tmp, 0, ascii(\'\'\'\'));\n"
"\n"
"inx := 0;\n"
"inx1 := 1;\n"
"while (inx < len)\n"
"{\n"
"c := chr (aref (str, inx));\n"
"cascii := ascii(c);\n"
"if (cascii < 32)\n"
"{\n"
"aset (tmp, inx1, ascii(\'\\\\\'));\n"
"aset (tmp, inx1 + 1, ascii(\'0\'));\n"
"aset (tmp, inx1 + 2, WS.WS.HEX_DIGIT (cascii / 8));\n"
"aset (tmp, inx1 + 3, WS.WS.HEX_DIGIT (mod (cascii, 8)));\n"
"inx1 := inx1 + 4;\n"
"}\n"
"else\n"
"{\n"
"if ((c = \'\'\'\') or (c = \'\\\\\'))\n"
"{\n"
"aset (tmp, inx1, cascii);\n"
"inx1 := inx1 + 1;\n"
"}\n"
"aset (tmp, inx1, cascii);\n"
"inx1 := inx1 + 1;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"aset(tmp, inx1, ascii(\'\'\'\'));\n"
"\n"
"return trim(tmp);\n"
"}\n"
"--src system.sql:181\n";

static const char *proc9 = 
"create procedure WS.WS.STR_FT_QUOT (in str varchar)\n"
"{\n"
"declare tmp varchar;\n"
"declare inx, inx1, len integer;\n"
"declare c char;\n"
"declare cascii integer;\n"
"len := length (str);\n"
"\n"
"if (len = 0)\n"
"return \'\"\"\';\n"
"tmp := space(len * 4 + 2);\n"
"\n"
"aset(tmp, 0, ascii(\'\"\'));\n"
"\n"
"inx := 0;\n"
"inx1 := 1;\n"
"while (inx < len)\n"
"{\n"
"c := chr (aref (str, inx));\n"
"cascii := ascii(c);\n"
"if ((cascii < 32) or (\'\'\'\' = c) or (\'\\\\\' = c) or (\'\"\' = c))\n"
"{\n"
"aset (tmp, inx1, ascii(\'\\\\\'));\n"
"aset (tmp, inx1 + 1, ascii(\'0\'));\n"
"aset (tmp, inx1 + 2, WS.WS.HEX_DIGIT (cascii / 8));\n"
"aset (tmp, inx1 + 3, WS.WS.HEX_DIGIT (mod (cascii, 8)));\n"
"inx1 := inx1 + 4;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"aset(tmp, inx1, ascii(\'\"\'));\n"
"return trim(tmp);\n"
"}\n"
"--src system.sql:228\n";

static const char *proc10 = 
" create procedure SQL_PROCEDURE_COLUMNS (\n"
"in qual varchar,\n"
"in owner varchar,\n"
"in name varchar,\n"
"in col varchar,\n"
"in casemode integer,\n"
"in is_odbc3 integer\n"
")\n"
"{\n"
"declare PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME, TYPE_NAME, REMARKS varchar;\n"
"declare COLUMN_SIZE, BUFFER_LENGTH integer;\n"
"declare COLUMN_TYPE, DATA_TYPE, DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE smallint;\n"
"\n"
"declare COLUMN_DEF, IS_NULLABLE varchar;\n"
"declare SQL_DATA_TYPE, SQL_DATETIME_SUB smallint;\n"
"declare CHAR_OCTET_LENGTH, ORDINAL_POSITION integer;\n"
"\n"
"\n"
"result_names (PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME,\n"
"COLUMN_TYPE, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH,\n"
"DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE, REMARKS,\n"
"COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE);\n"
"\n"
"declare full_name varchar;\n"
"declare inx, sz integer;\n"
"declare cols, elt any;\n"
"\n"
"full_name := name;\n"
"if (owner is not null)\n"
"full_name := concat (owner, \'.\', full_name);\n"
"else if (qual is not null)\n"
"full_name := concat (\'.\', full_name);\n"
"\n"
"if (qual is not null)\n"
"full_name := concat (qual, \'.\', full_name);\n"
"\n"
"for\n"
"select\n"
"P_NAME\n"
"from DB.DBA.SYS_PROCEDURES\n"
"where\n"
"either (casemode, upper (P_NAME), P_NAME) like either (casemode, upper (full_name), full_name)\n"
"do\n"
"{\n"
"cols := procedure_cols (P_NAME);\n"
"if (cols)\n"
"{\n"
"sz := length (cols);\n"
"inx := 0;\n"
"while (inx < sz)\n"
"{\n"
"elt := aref (cols, inx);\n"
"if (either (casemode, upper (aref (elt, 3)), aref (elt, 3)) like\n"
"either (casemode, upper (col), col))\n"
"{\n"
"result (\n"
"aref (elt, 0),\n"
"aref (elt, 1),\n"
"aref (elt, 2),\n"
"aref (elt, 3),\n"
"aref (elt, 4),\n"
"either (is_odbc3, dv_to_sql_type3 (aref (elt, 5)), dv_to_sql_type (aref (elt, 5))),\n"
"dv_type_title (aref (elt, 5)),\n"
"aref (elt, 7),\n"
"aref (elt, 7),\n"
"aref (elt, 6),\n"
"10,\n"
"aref (elt, 8),\n"
"NULL,\n"
"\n"
"NULL,\n"
"either (is_odbc3, dv_to_sql_type3 (aref (elt, 5)), dv_to_sql_type (aref (elt, 5))),\n"
"NULL,\n"
"aref (elt, 7),\n"
"aref (elt, 9),\n"
"either (aref (elt, 8), \'YES\', \'NO\')\n"
");\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:265\n";

static const char *proc11 = 
" create procedure XML_URI_RESOLVE_LIKE_GET (in base_uri varchar, in rel_uri varchar, in output_charset varchar := null) returns any\n"
"{\n"
"declare res any;\n"
"\n"
"if (__tag (base_uri) in (225, 226))\n"
"base_uri := charset_recode (base_uri, \'_WIDE_\', \'UTF-8\');\n"
"else\n"
"base_uri := coalesce (cast (base_uri as varchar), \'\');\n"
"if (__tag (rel_uri) in (225, 226))\n"
"rel_uri := charset_recode (rel_uri, \'_WIDE_\', \'UTF-8\');\n"
"else\n"
"rel_uri := coalesce (cast (rel_uri as varchar), \'\');\n"
"\n"
"res := rfc1808_expand_uri (base_uri, rel_uri, output_charset, 1);\n"
"\n"
"return res;\n"
"}\n"
"--src system.sql:351\n";

static const char *proc12 = 
"create function XML_URI_GET_AND_CACHE (in absolute_uri varchar)\n"
"{\n"
"declare head, content any;\n"
"whenever not found goto try_http_get;\n"
"\n"
"if (__tag (absolute_uri) in (225, 226))\n"
"absolute_uri := charset_recode (absolute_uri, \'_WIDE_\', \'UTF-8\');\n"
"else\n"
"absolute_uri := charset_recode (absolute_uri, NULL, \'UTF-8\');\n"
"select CRES_CONTENT into content from DB.DBA.SYS_CACHED_RESOURCES where CRES_URI = absolute_uri;\n"
"return content;\n"
"try_http_get:\n"
"content := http_get (absolute_uri, head);\n"
"if (aref (head, 0) not like \'% 200%\')\n"
"signal (\'H0001\', concat (\'HTTP GET failed for \', absolute_uri, \': \', aref (head, 0)));\n"
"insert into DB.DBA.SYS_CACHED_RESOURCES\n"
"(CRES_URI, CRES_CONTENT, CRES_LOADING_DATE)\n"
"values\n"
"(absolute_uri, content, now());\n"
"return content;\n"
"}\n"
"--src system.sql:370\n";

static const char *proc13 = 
" create procedure XML_URI_PARSE_VIRT (in base_uri varchar, inout table_name varchar, inout datacol_name varchar, inout pathcol_name varchar, inout path varchar)\n"
"{\n"
"declare table_start, col_start, path_start integer;\n"
"declare inx integer;\n"
"\n"
"inx := 5;\n"
"while (length (base_uri) > inx + 1 and\n"
"aref (base_uri, inx) = ascii (\'/\'))\n"
"inx := inx + 1;\n"
"table_start := inx;\n"
"path_start := locate (\':\', base_uri, table_start);\n"
"if (path_start = 0)\n"
"signal (\'HT421\', concat (\'Non-valid Virtuoso uri (missing path separator): \', base_uri));\n"
"path := subseq (base_uri, path_start);\n"
"table_name := subseq (base_uri, table_start, path_start - 1);\n"
"\n"
"col_start := strrchr (table_name, \'.\');\n"
"if (col_start is null)\n"
"signal (\'HT422\',\n"
"concat (\'Non-valid Virtuoso uri (missing data column separator in the column ref): \', base_uri));\n"
"datacol_name := subseq (table_name, col_start + 1);\n"
"table_name := subseq (table_name, 0, col_start);\n"
"\n"
"\n"
"col_start := strrchr (table_name, \'.\');\n"
"if (col_start is null)\n"
"signal (\'HT423\',\n"
"concat (\'Non-valid Virtuoso uri (missing path column separator in the column ref): \', base_uri));\n"
"pathcol_name := subseq (table_name, col_start + 1);\n"
"table_name := subseq (table_name, 0, col_start);\n"
"}\n"
"--src system.sql:395\n";

static const char *proc14 = 
"create procedure XML_URI_GET (in base_uri varchar, in rel_uri varchar)\n"
"{\n"
"declare head, str, proto varchar;\n"
"declare inx, timeout integer;\n"
"declare s_uri any;\n"
"\n"
"base_uri := XML_URI_RESOLVE_LIKE_GET (base_uri, rel_uri);\n"
"\n"
"if (__tag (base_uri) in (225, 226))\n"
"base_uri := charset_recode (base_uri, \'_WIDE_\', \'UTF-8\');\n"
"else\n"
"base_uri := charset_recode (base_uri, NULL, \'UTF-8\');\n"
"again:\n"
"s_uri := rfc1808_parse_uri (base_uri);\n"
"str := null;\n"
"proto := aref (s_uri, 0);\n"
"try_all:\n"
"if (proto = \'http\' or proto = \'https\')\n"
"{\n"
"declare hcli_uid, hcli_pwd any;\n"
"if (base_uri like \'http://www.w3.org/TR/%\')\n"
"return XML_URI_GET_AND_CACHE (charset_recode (base_uri, \'UTF-8\', \'_WIDE_\'));\n"
"if (base_uri like \'http://localdav.virt/%\')\n"
"{\n"
"base_uri := \'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\' || subseq (base_uri, 20);\n"
"goto again;\n"
"}\n"
"whenever not found goto try_http_get;\n"
"select CRES_CONTENT into str from DB.DBA.SYS_CACHED_RESOURCES where CRES_URI = base_uri;\n"
"return str;\n"
"try_http_get:\n"
"\n"
"\n"
"hcli_uid := connection_get (\'HTTP_CLI_UID\');\n"
"hcli_pwd := connection_get (\'HTTP_CLI_PWD\');\n"
"timeout := connection_get (\'HTTP_CLI_TIMEOUT\');\n"
"declare _auth_get varchar;\n"
"if ( (hcli_pwd is null) and (hcli_uid is null) )\n"
"{\n"
"_auth_get := HTTP_GET_AUTH_INFO (base_uri);\n"
"if (_auth_get is not null)\n"
"{\n"
"hcli_uid := aref (_auth_get, 0);\n"
"hcli_pwd := aref (_auth_get, 1);\n"
"}\n"
"}\n"
"if (lcase (base_uri) like \'http://local.virt/dav/%\')\n"
"{\n"
"proto := \'virt\';\n"
"base_uri := \'virt://WS.WS.SYS_DAV_RES.RES_FULL_PATH.RES_CONTENT:\' || subseq (base_uri, 17);\n"
"goto try_all;\n"
"}\n"
"else if (proto = \'https\' or (length (hcli_uid) and length (hcli_pwd)) or (timeout is not null and timeout > 0))\n"
"{\n"
"str := http_client_ext (url=>base_uri, uid=>hcli_uid, pwd=>hcli_pwd, headers=>head, timeout=>timeout);\n"
"}\n"
"else\n"
"str := http_get (base_uri, head);\n"
"if (aref (head, 0) not like \'% 200%\')\n"
"signal (\'H0001\', concat (\'HTTP request failed: \', aref (head, 0), \'for URI \', base_uri));\n"
"}\n"
"else if (proto = \'file\')\n"
"{\n"
"inx := 5;\n"
"base_uri := charset_recode (base_uri, \'UTF-8\', NULL);\n"
"while (length (base_uri) > inx + 1 and\n"
"aref (base_uri, inx) = ascii (\'/\'))\n"
"inx := inx + 1;\n"
"str := file_to_string (concat (http_root(), \'/\' , subseq (base_uri, inx)));\n"
"}\n"
"else if (proto = \'virt\')\n"
"{\n"
"declare datacol_name, path, table_name, pathcol_name varchar;\n"
"declare path1 any;\n"
"\n"
"base_uri := charset_recode (base_uri, \'UTF-8\', NULL);\n"
"\n"
"XML_URI_PARSE_VIRT (base_uri, table_name, datacol_name, pathcol_name, path);\n"
"\n"
"declare st, msg varchar;\n"
"st := \'00000\';\n"
"\n"
"\n"
"if (__any_grants_to_user (table_name, USER, 1))\n"
"goto skip_auth;\n"
"if (0 = casemode_strcmp (table_name, \'WS.WS.SYS_DAV_RES\'))\n"
"{\n"
"declare _dav_user_id integer;\n"
"_dav_user_id := connection_get (\'DAVUserID\');\n"
"\n"
"\n"
"\n"
"\n"
"if (0 = WS.WS.CHECKPERM (WS.WS.HREF_TO_ARRAY (path, \'\'), _dav_user_id, \'100\'))\n"
"{\n"
"if (is_http_ctx() and not http_map_get (\'executable\'))\n"
"{\n"
"\n"
"DB.DBA.vsp_auth_get (\'DAV\', \'/DAV\',\n"
"md5 (datestring(now())),\n"
"md5 (\'opaakki\'),\n"
"\'false\', http_request_header (), 1);\n"
"signal (\'VSPRT\', concat (\'Not authorized to read from \', base_uri));\n"
"}\n"
"signal (\'42000\', concat (\'Not authorized to read from \', base_uri));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare _dav_user_id integer;\n"
"_dav_user_id := connection_get (\'DAVUserID\');\n"
"if (isinteger (_dav_user_id) and 0 = __any_grants_to_user (table_name, NULL, 1))\n"
"signal (\'42000\', concat (\'Not authorized  to read from \', base_uri));\n"
"}\n"
"skip_auth:;\n"
"\n"
"path1 := path;\n"
"\n"
"{\n"
"declare tp integer;\n"
"declare cl cursor for select COL_DTP from DB.DBA.SYS_COLS\n"
"where 0 = casemode_strcmp (\"TABLE\", complete_table_name (table_name, 1))\n"
"and 0 = casemode_strcmp (\"COLUMN\", pathcol_name);\n"
"tp := 0;\n"
"whenever not found goto cl_err;\n"
"open cl (prefetch 1);\n"
"fetch cl into tp;\n"
"if (tp = 189 or tp = 188)\n"
"path1 := cast (path as integer);\n"
"else if (tp = 191 or tp = 190)\n"
"path1 := cast (path as double precision);\n"
"else if (tp = 211 or tp = 128 or tp = 129)\n"
"path1 := cast (path as datetime);\n"
"cl_err:;\n"
"close cl;\n"
"}\n"
"\n"
"exec (concat (\'select \"\', datacol_name, \'\" from \"\', table_name, \'\" where \"\', pathcol_name, \'\" = ?\'),\n"
"st, msg, vector (path1), 1, null, str);\n"
"if (st <> \'00000\')\n"
"signal (st, msg);\n"
"if (isarray (str) and length (str) > 0)\n"
"{\n"
"str := aref (str, 0);\n"
"if (isarray (str) and length (str) > 0)\n"
"str := aref (str, 0);\n"
"}\n"
"if (isblob (str))\n"
"return str;\n"
"if (isentity (str))\n"
"return str;\n"
"if (isstring (str) = 0)\n"
"{\n"
"if (0 = casemode_strcmp (table_name, \'WS.WS.SYS_DAV_RES\'))\n"
"{\n"
"declare content, type any;\n"
"declare id any;\n"
"declare rc integer;\n"
"id := DAV_SEARCH_ID (path, \'R\');\n"
"if (isinteger (id))\n"
"if (id < 0)\n"
"signal (\'42000\', concat (\'DAV does not contain resource with path equal to \"\', path, \'\"\'));\n"
"rc := DAV_RES_CONTENT_INT (id, content, type, 0, 0, null, null);\n"
"if (isinteger (rc))\n"
"if (rc < 0)\n"
"signal (\'42000\', concat (\'Error on reading DAV resource with path equal to \"\', path, \'\"\'));\n"
"if (__tag (content) = 222)\n"
"content := cast (content as varchar);\n"
"return content;\n"
"}\n"
"signal (\'42000\', concat (\'The table \', table_name, \' does not have row with \',\n"
"pathcol_name, \' equal to \"\', path, \'\"\'));\n"
"}\n"
"}\n"
"else if (proto like \'x-virt-cache-%\')\n"
"{\n"
"declare content any;\n"
"whenever not found goto cache_miss;\n"
"select CRES_CONTENT into content from DB.DBA.SYS_CACHED_RESOURCES where CRES_URI = base_uri;\n"
"return content;\n"
"cache_miss:\n"
"signal (\'HT068\', sprintf (\'Resource \"%s\" not found in SYS_CACHED_RESOURCES\', base_uri));\n"
"}\n"
"else\n"
"{\n"
"signal (\'HT424\', sprintf (\'Unsupported protocol %s\', proto));\n"
"}\n"
"return str;\n"
"}\n"
"--src system.sql:430\n";

static const char *proc15 = 
"create procedure XML_URI_GET_STRING (in base_uri varchar, in rel_uri varchar)\n"
"{\n"
"declare _res any;\n"
"_res := XML_URI_GET (base_uri, rel_uri);\n"
"if (isstring (_res))\n"
"return _res;\n"
"return cast (_res as varchar);\n"
"}\n"
"--src system.sql:621\n";

static const char *proc16 = 
"create procedure XML_URI_GET_STRING_OR_ENT (in base_uri varchar, in rel_uri varchar)\n"
"{\n"
"declare _res any;\n"
"_res := XML_URI_GET (base_uri, rel_uri);\n"
"if (isstring (_res) or isentity (_res))\n"
"return _res;\n"
"return cast (_res as varchar);\n"
"}\n"
"--src system.sql:631\n";

static const char *proc17 = 
"create procedure XML_COLLECTION_DIR_LIST_LOCAL (in collection_uri varchar, in dav_path varchar, inout res any, in recursive int)\n"
"{\n"
"declare dir_list any;\n"
"declare r_dict, r_list any;\n"
"\n"
"dir_list := DAV_DIR_LIST_INT (dav_path, case recursive when 0 then 0 else 1 end, \'%\', null, null, http_dav_uid());\n"
"if (not isarray (dir_list))\n"
"return;\n"
"r_dict := dict_new (length (dir_list) + 13);\n"
"foreach (any dir_itm in dir_list) do\n"
"{\n"
"if (\'R\' = dir_itm[1])\n"
"{\n"
"declare res_id any;\n"
"declare res_path varchar;\n"
"res_id := dir_itm[4];\n"
"if (isarray (res_id))\n"
"{\n"
"res_path := DAV_SEARCH_PATH (res_id, \'R\');\n"
"if (not isstring (res_path))\n"
"res_path := dir_itm[0];\n"
"}\n"
"else\n"
"res_path := dir_itm[0];\n"
"dict_put (r_dict, res_path, 0);\n"
"}\n"
"}\n"
"r_list := dict_list_keys (r_dict, 2);\n"
"gvector_sort (r_list, 1, 0, 1);\n"
"foreach (varchar r_path in r_list) do\n"
"xq_sequencebld_acc (res, subseq (collection_uri, 0, 22) || subseq (r_path, 5));\n"
"}\n"
"--src system.sql:642\n";

static const char *proc18 = 
"create procedure XML_COLLECTION_DIR_LIST_TABLE (in collection_uri varchar, inout res any, in recursive int)\n"
"{\n"
"declare datacol_name, path, table_name, pathcol_name varchar;\n"
"\n"
"XML_URI_PARSE_VIRT (collection_uri || \':_id\', table_name, datacol_name, pathcol_name, path);\n"
"\n"
"if (__any_grants_to_user (table_name, USER, 1))\n"
"goto skip_auth;\n"
"if (0 = casemode_strcmp (table_name, \'WS.WS.SYS_DAV_RES\'))\n"
"{\n"
"signal (\'42000\', \'Access to WS.WS.SYS_DAV_RES is not allowed by virt://... collection\');\n"
"}\n"
"else\n"
"{\n"
"if (0 = __any_grants_to_user (table_name, NULL, 1))\n"
"signal (\'42000\', concat (\'Not authorized to read from \', collection_uri));\n"
"}\n"
"skip_auth:;\n"
"\n"
"declare st, msg varchar;\n"
"declare stmt varchar;\n"
"declare rows any;\n"
"st := \'00000\';\n"
"stmt := concat (\'select \"\', pathcol_name, \'\" from \"\', table_name, \'\"\');\n"
"\n"
"exec (stmt, st, msg, null, 100, null, rows);\n"
"if (st <> \'00000\')\n"
"signal (st, msg);\n"
"if (isarray (rows))\n"
"{\n"
"foreach (any _id in rows) do\n"
"xq_sequencebld_acc (res, concat (\'virt://\', table_name, \'.\', pathcol_name, \'.\', datacol_name, \':\', cast (aref (_id, 0) as varchar)));\n"
"}\n"
"}\n"
"--src system.sql:676\n";

static const char *proc19 = 
"create procedure HTTP_GET_AUTH_INFO (in base_uri varchar)\n"
"{\n"
"declare _auth_get, hcli_uid, hcli_pwd varchar;\n"
"_auth_get := connection_get (\'HTTPAuthManager\');\n"
"if (_auth_get is not null)\n"
"{\n"
"declare _st, _msg varchar;\n"
"declare _auth_card any;\n"
"_st := \'00000\';\n"
"exec (\'select \"\' || _auth_get || \'\"(?)\', _st, _msg, vector (base_uri), 1, null, _auth_card);\n"
"if (_st <> \'00000\')\n"
"signal (_st, _msg);\n"
"if (isarray (_auth_card) and isarray (aref (_auth_card, 0)) and isarray (aref (aref (_auth_card, 0), 0) ))\n"
"{\n"
"hcli_uid := aref (aref (aref (_auth_card, 0), 0), 0);\n"
"hcli_pwd := aref (aref (aref (_auth_card, 0), 0), 1);\n"
"if (isstring (hcli_pwd) and isstring (hcli_uid))\n"
"return vector (hcli_uid, hcli_pwd);\n"
"}\n"
"signal (\'H0002\', \'Authentication callback function returned wrong authentication info\');\n"
"}\n"
"return null;\n"
"}\n"
"--src system.sql:713\n";

static const char *proc20 = 
"create procedure XML_COLLECTION_DIR_LIST_REMOTE (in host_part varchar, in auth_digest varchar, in dav_path varchar, inout res any, in recursive int)\n"
"{\n"
"declare r any;\n"
"declare b any;\n"
"declare body, hdr varchar;\n"
"declare _auth_get varchar;\n"
"\n"
"hdr := null;\n"
"if (auth_digest is null)\n"
"{\n"
"_auth_get := HTTP_GET_AUTH_INFO (dav_path);\n"
"if (_auth_get is not null)\n"
"hdr := \'Authorization: Basic \' || encode_base64 (aref (_auth_get, 0) || \':\' || aref (_auth_get, 1));\n"
"}\n"
"else\n"
"hdr := sprintf (\'Authorization: Basic %s\', auth_digest);\n"
"b := http_get (dav_path, r, \'PROPFIND\', hdr);\n"
"if (isarray (r) and (aref (r, 0) not like \'HTTP/1.1 2__%\'))\n"
"{\n"
"r := null;\n"
"b := http_get (dav_path, r, \'GET\', hdr);\n"
"if (isarray (r) and (aref (r, 0) not like \'HTTP/1.1 2__%\'))\n"
"signal (\'H0001\', concat (\'HTTP request failed: \', aref (r, 0), \'for URI \', dav_path));\n"
"b := xtree_doc (b, 2);\n"
"declare _hrefs any;\n"
"_hrefs := xpath_eval (\'//a/@href\', b, 0);\n"
"if (isarray (_hrefs)) {\n"
"foreach (varchar uri in xpath_eval (\'//a/@href\', b, 0)) do\n"
"{\n"
"uri := lcase (uri);\n"
"if (uri <> \'..\' and uri not like \'mailto:%\') {\n"
"if (uri like \'http://%\') {\n"
"xq_sequencebld_acc (res, uri);\n"
"} else {\n"
"xq_sequencebld_acc (res, dav_path || uri);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare dav_part, file_part varchar;\n"
"dav_part := subseq (dav_path, length (host_part));\n"
"b := xtree_doc (b);\n"
"foreach (any uri in xpath_eval (\'distinct-values (/multistatus/response[not propstat/prop/resourcetype/collection]/href/text())\', b)) do\n"
"{\n"
"if (recursive = 0)\n"
"{\n"
"file_part := subseq (cast (uri as varchar), length (dav_part));\n"
"if (strchr (file_part, \'/\') is null)\n"
"xq_sequencebld_acc (res, host_part || cast (uri as varchar));\n"
"}\n"
"else\n"
"xq_sequencebld_acc (res, host_part || cast (uri as varchar));\n"
"\n"
"}\n"
"}\n"
"\n"
"}\n"
"--src system.sql:739\n";

static const char *proc21 = 
"create procedure XML_COLLECTION_DIR_LIST (in collection_uri any, in recursive int)\n"
"{\n"
"declare res, uri_dict any;\n"
"\n"
"if (isstring (collection_uri))\n"
"{\n"
"xq_sequencebld_init (res);\n"
"declare lcase_collection_uri varchar;\n"
"declare dir_list any;\n"
"declare dav_path varchar;\n"
"lcase_collection_uri := lcase (collection_uri);\n"
"if (lcase_collection_uri like \'http://local.virt/dav/%\')\n"
"dav_path := subseq (collection_uri, 17);\n"
"else if ((lcase_collection_uri not like \'http://%\') and (lcase_collection_uri not like \'~%\') and (lcase_collection_uri not like \'virt://%\'))\n"
"signal (\'XXXXX\', \'collection must begin with \"http://\"\');\n"
"else\n"
"dav_path := collection_uri;\n"
"if ((dav_path not like \'%/\') and (dav_path not like \'virt://%\'))\n"
"dav_path := dav_path || \'/\';\n"
"if (dav_path like \'~%\')\n"
"{\n"
"declare _home, _uname, arr varchar;\n"
"arr := split_and_decode (dav_path, 0, \'\\0\\0/\');\n"
"if (isarray (arr) and (length (arr) > 0))\n"
"_uname := subseq (aref (arr, 0), 1);\n"
"_home := (select U_HOME from SYS_USERS where U_NAME = _uname);\n"
"if (_home is null)\n"
"signal (\'XXXXX\', \'user \' || _uname || \' does not have home DAV collection\');\n"
"dav_path := subseq (_home, 0, length (_home) - 1);\n"
"declare _idx int;\n"
"_idx := 1;\n"
"while (_idx < length (arr)) {\n"
"dav_path := dav_path || \'/\' || aref (arr, _idx);\n"
"_idx := _idx + 1;\n"
"}\n"
"collection_uri := \'http://local.virt\' || dav_path;\n"
"}\n"
"if (dav_path like \'/DAV/%\')\n"
"{\n"
"XML_COLLECTION_DIR_LIST_LOCAL (collection_uri, dav_path, res, recursive);\n"
"}\n"
"else if (dav_path like \'virt://%\')\n"
"{\n"
"XML_COLLECTION_DIR_LIST_TABLE (dav_path, res, recursive);\n"
"}\n"
"else\n"
"{\n"
"declare host_part varchar;\n"
"declare hcli_uid, hcli_pwd varchar;\n"
"host_part := coalesce (regexp_match (\'http://[^:/]*(:[0-9]+)?\', dav_path), \'\');\n"
"hcli_uid := connection_get (\'HTTP_CLI_UID\');\n"
"hcli_pwd := connection_get (\'HTTP_CLI_PWD\');\n"
"XML_COLLECTION_DIR_LIST_REMOTE (host_part,\n"
"case when ((hcli_uid is not null) and (hcli_pwd is not null)) then encode_base64 (hcli_uid || \':\' || hcli_pwd) else null end,\n"
"dav_path, res, recursive);\n"
"}\n"
"xq_sequencebld_final (res);\n"
"return res;\n"
"}\n"
"}\n"
"--src system.sql:801\n";

static const char *other0 = 
"grant execute on XML_COLLECTION_DIR_LIST to public\n";
static const char *proc22 = 
"create procedure SYS_ALFANUM_NAME (in name varchar)\n"
"{\n"
"declare inx, c integer;\n"
"\n"
"inx :=0;\n"
"while (inx < length (name)) {\n"
"c := aref (name, inx);\n"
"if (not ((c >= aref (\'A\', 0) and c <= aref (\'Z\', 0))\n"
"or (c >= aref (\'a\', 0) and c <= aref (\'z\', 0))\n"
"or (c >= aref (\'0\', 0) and c <= aref (\'9\', 0))))\n"
"aset (name, inx, aref (\'_\', 0));\n"
"inx := inx + 1;\n"
"}\n"
"return name;\n"
"}\n"
"--src system.sql:867\n";

static const char *proc23 = 
" create procedure SYS_COPY_TABLE (in source_tbl varchar, in dest_tbl varchar)\n"
"{\n"
"declare src_meta, dest_meta any;\n"
"declare comm, col_list varchar;\n"
"declare inx integer;\n"
"\n"
"exec (sprintf (\'select * from \"%I\"\', source_tbl), NULL, NULL, NULL, 1, src_meta, NULL);\n"
"exec (sprintf (\'select * from \"%I\"\', dest_tbl), NULL, NULL, NULL, 1, dest_meta, NULL);\n"
"\n"
"if (0 = isarray (src_meta) or 0 = isarray (aref (src_meta, 0)))\n"
"signal (\'42S22\', sprintf (\'No columns in the source table %s\', src_meta), \'SR288\');\n"
"if (not isarray (dest_meta) or 0 = isarray (aref (src_meta, 0)))\n"
"signal (\'42S22\', sprintf (\'No columns in the source table %s\', dest_meta), \'SR289\');\n"
"\n"
"src_meta := aref (src_meta, 0);\n"
"dest_meta := aref (dest_meta, 0);\n"
"inx := 0;\n"
"\n"
"col_list := \'\';\n"
"while (inx < length (src_meta))\n"
"{\n"
"declare col any;\n"
"declare col_name varchar;\n"
"declare col_dtp integer;\n"
"declare inx1, have_match integer;\n"
"\n"
"col := aref (src_meta, inx);\n"
"col_name := aref (col, 0);\n"
"col_dtp := aref (col, 1);\n"
"\n"
"inx1 := 0;\n"
"have_match := 0;\n"
"\n"
"while (inx1 < length (dest_meta) and have_match = 0)\n"
"{\n"
"if (aref (aref (dest_meta, inx1), 0) = col_name and (aref (aref (dest_meta, inx1), 1) = col_dtp))\n"
"have_match := 1;\n"
"else\n"
"inx1 := inx1 + 1;\n"
"}\n"
"if (have_match = 0)\n"
"signal (\'42S22\', sprintf (\'The column %s in the source table %s does not have a match in the destination table %s\', col_name, source_tbl, dest_tbl), \'SR290\');\n"
"\n"
"if (inx > 0)\n"
"col_list := concat (col_list, \' , \');\n"
"\n"
"col_list := concat (col_list, sprintf (\'\"%I\"\', col_name));\n"
"inx := inx + 1;\n"
"}\n"
"exec (sprintf (\'insert into \"%I\" (%s) select %s from \"%I\"\', dest_tbl, col_list, col_list, source_tbl));\n"
"}\n"
"--src system.sql:906\n";

static const char *proc24 = 
" create procedure ddl_pk_fill_pk_parts (in pk_id integer, in k_id integer, in n_k_parts integer)\n"
"{\n"
"declare n_pk integer;\n"
"select KEY_N_SIGNIFICANT into n_pk from DB.DBA.SYS_KEYS where KEY_ID = pk_id;\n"
"for select KP_COL as pk_col from DB.DBA.SYS_KEY_PARTS where KP_KEY_ID = pk_id and KP_NTH < n_pk do\n"
"{\n"
"if (not (exists (select 1 from DB.DBA.SYS_KEY_PARTS where KP_KEY_ID = k_id and KP_COL = pk_col)))\n"
"{\n"
"insert into DB.DBA.SYS_KEY_PARTS (KP_KEY_ID, KP_NTH, KP_COL) values (k_id, n_k_parts, pk_col);\n"
"n_k_parts := n_k_parts + 1;\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:963\n";

static const char *proc25 = 
" create procedure ddl_pk_copy_inx (in tb varchar, in ntb varchar, in nk_id integer)\n"
"{\n"
"\n"
"declare k_id integer;\n"
"for select\n"
"KEY_NAME, KEY_ID as _KEY_ID, KEY_DECL_PARTS as _KEY_DECL_PARTS,\n"
"KEY_CLUSTER_ON_ID, KEY_IS_UNIQUE, KEY_IS_OBJECT_ID\n"
"from DB.DBA.SYS_KEYS where KEY_IS_MAIN = 0 and KEY_TABLE = tb\n"
"and KEY_MIGRATE_TO is null do\n"
"{\n"
"k_id := new_key_id (0);\n"
"insert into DB.DBA.SYS_KEYS (KEY_TABLE, KEY_NAME, KEY_ID, KEY_DECL_PARTS,\n"
"KEY_CLUSTER_ON_ID, KEY_SUPER_ID, KEY_IS_UNIQUE, KEY_IS_OBJECT_ID, KEY_VERSION)\n"
"values (ntb, KEY_NAME, k_id, _KEY_DECL_PARTS,\n"
"k_id, k_id, KEY_IS_UNIQUE, KEY_IS_OBJECT_ID, 1);\n"
"\n"
"insert into DB.DBA.SYS_KEY_PARTS (KP_KEY_ID, KP_NTH, KP_COL)\n"
"select k_id, KP_NTH, (select n.COL_ID from DB.DBA.SYS_COLS n where n.\"TABLE\" = ntb and n.\"COLUMN\" = c.\"COLUMN\")\n"
"from DB.DBA.SYS_KEY_PARTS, DB.DBA.SYS_COLS c where KP_NTH < _KEY_DECL_PARTS and KP_KEY_ID = _KEY_ID\n"
"and c.COL_ID = KP_COL;\n"
"DB.DBA.ddl_pk_fill_pk_parts (nk_id, k_id, _KEY_DECL_PARTS);\n"
"if (KEY_IS_UNIQUE = 1)\n"
"update DB.DBA.SYS_KEYS set KEY_N_SIGNIFICANT = KEY_DECL_PARTS,\n"
"KEY_IS_MAIN = 0\n"
"where KEY_ID = k_id;\n"
"else\n"
"update DB.DBA.SYS_KEYS set KEY_N_SIGNIFICANT = (select count (*) from DB.DBA.SYS_KEY_PARTS where KP_KEY_ID = k_id),\n"
"KEY_IS_MAIN = 0\n"
"where KEY_ID = k_id;\n"
"}\n"
"}\n"
"--src system.sql:980\n";

static const char *proc26 = 
" create procedure ddl_pk_change_1 (in tb varchar, in cols any)\n"
"{\n"
"declare pk_id, nk_id, inx, cid integer;\n"
"declare tname, tname_esc, st, msg, pk_name varchar;\n"
"\n"
"tname := complete_table_name (\'TEMP__\', 0);\n"
"tname_esc := sprintf (\'\"%I\".\"%I\".\"%I\"\',\n"
"name_part (tname, 0), name_part (tname, 1), name_part (tname, 2));\n"
"exec (concat (\'drop table \', tname_esc), st, msg, vector ());\n"
"select KEY_ID, KEY_NAME\n"
"into pk_id, pk_name\n"
"from DB.DBA.SYS_KEYS\n"
"where KEY_TABLE = tb and KEY_IS_MAIN = 1 and KEY_MIGRATE_TO is null;\n"
"nk_id := new_key_id (0);\n"
"insert into DB.DBA.SYS_KEYS (KEY_TABLE, KEY_NAME, KEY_ID, KEY_DECL_PARTS, KEY_N_SIGNIFICANT,\n"
"KEY_CLUSTER_ON_ID, KEY_SUPER_ID, KEY_IS_MAIN, KEY_IS_UNIQUE, KEY_VERSION)\n"
"values  (tname, pk_name, nk_id, length (cols), length (cols),\n"
"nk_id, nk_id, 1, 1, 1);\n"
"declare cr cursor for select\n"
"\"COLUMN\",\n"
"COL_DTP,\n"
"COL_PREC,\n"
"COL_SCALE,\n"
"COL_CHECK,\n"
"deserialize (COL_DEFAULT),\n"
"COL_NTH,\n"
"COL_NULLABLE from DB.DBA.SYS_COLS\n"
"where concat (\'\', \"TABLE\") = tb order by COL_ID;\n"
"whenever not found goto done;\n"
"open cr;\n"
"while (1)\n"
"{\n"
"declare _col1, _col2, _col3, _col4, _col5, _col6, _col7, _col8, _col9, _col10 any;\n"
"fetch cr into  _col3, _col4, _col5, _col6, _col7, _col8, _col9, _col10;\n"
"_col1 := new_col_id (0);\n"
"_col2 := tname;\n"
"insert into DB.DBA.SYS_COLS\n"
"(COL_ID, \"TABLE\", \"COLUMN\", COL_DTP, COL_PREC, COL_SCALE, COL_CHECK, COL_DEFAULT,\n"
"COL_NTH, COL_NULLABLE)\n"
"values (_col1, _col2, _col3, _col4, _col5, _col6, _col7, serialize (_col8), _col9, _col10);\n"
"}\n"
"done:\n"
"close cr;\n"
"whenever not found default;\n"
"inx := 0;\n"
"while (inx < length (cols))\n"
"{\n"
"cid := (select COL_ID from DB.DBA.SYS_COLS where \"TABLE\" = tname and 0 = casemode_strcmp (\\COLUMN, aref (cols, inx)));\n"
"if (cid is null)\n"
"{\n"
"txn_error (6);\n"
"signal (\'42000\', concat (\'Column \', aref (cols, inx), \' not found in alter table\'));\n"
"}\n"
"insert into DB.DBA.SYS_KEY_PARTS (KP_KEY_ID, KP_NTH, KP_COL) values (nk_id, inx, cid);\n"
"inx := inx + 1;\n"
"}\n"
"DB.DBA.att_fill_non_pk_parts (tname, nk_id, inx);\n"
"DB.DBA.ddl_pk_copy_inx (tb, tname, nk_id);\n"
"__ddl_changed (tname);\n"
"DB.DBA.SYS_COPY_TABLE (tb, tname);\n"
"}\n"
"--src system.sql:1015\n";

static const char *proc27 = 
" create procedure ddl_pk_change_final (in tb varchar, in cols any)\n"
"{\n"
"declare st, msg, tname, tname_esc, tb_esc varchar;\n"
"tname := complete_table_name (\'TEMP__\', 0);\n"
"tname_esc := sprintf (\'\"%I\".\"%I\".\"%I\"\',\n"
"name_part (tname, 0), name_part (tname, 1), name_part (tname, 2));\n"
"tb_esc := sprintf (\'\"%I\".\"%I\".\"%I\"\',\n"
"name_part (tb, 0), name_part (tb, 1), name_part (tb, 2));\n"
"update DB.DBA.SYS_TRIGGERS set T_TABLE = tname where T_TABLE = tb;\n"
"update DB.DBA.SYS_GRANTS set G_OBJECT = tname where G_OBJECT = tb and G_OP < 16;\n"
"exec (sprintf (\'drop table %s\', tb_esc), st, msg, vector ());\n"
"update DB.DBA.SYS_TRIGGERS set T_TABLE = tb where T_TABLE = tname;\n"
"update DB.DBA.SYS_GRANTS set G_OBJECT = tb where G_OBJECT = tname and G_OP < 16;\n"
"exec (sprintf (\'alter table %s rename %s\', tname_esc, tb_esc), st, msg, vector ());\n"
"commit work;\n"
"\n"
"}\n"
"--src system.sql:1080\n";

static const char *proc28 = 
" create procedure ddl_pk_modify_check (in tb varchar, in cols any)\n"
"{\n"
"declare inx integer;\n"
"declare pk_id integer;\n"
"pk_id := (select KEY_ID from DB.DBA.SYS_KEYS where KEY_TABLE = tb and KEY_MIGRATE_TO is null and KEY_IS_MAIN = 1);\n"
"if (exists (select 1 from DB.DBA.SYS_KEY_SUBKEY where SUB = pk_id)\n"
"or exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = tb)\n"
"or exists (select 1 from DB.DBA.SYS_VT_INDEX where VI_TABLE = tb)\n"
"or exists (select 1 from DB.DBA.SYS_KEY_SUBKEY, DB.DBA.SYS_KEYS where SUPER = pk_id and KEY_ID = SUB and KEY_MIGRATE_TO is null)\n"
")\n"
"signal (\'42S11\', \'Primary key modification is prohibited if: Table is a subtable or has subtables, is attached or has a free text index\', \'SR291\');\n"
"inx := 0;\n"
"while (inx < length (cols))\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_KEY_PARTS, DB.DBA.SYS_COLS where  KP_KEY_ID = pk_id and COL_ID = KP_COL and\n"
"0 = casemode_strcmp (\"COLUMN\", aref (cols, inx))))\n"
"signal (\'42S22\', sprintf (\'Bad new pk column %s in list\', aref (cols, inx)), \'SR292\');\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src system.sql:1101\n";

static const char *proc29 = 
" create procedure ddl_pk_is_changed (in tb varchar, in cols any) returns integer\n"
"{\n"
"declare inx integer;\n"
"\n"
"inx := 0;\n"
"\n"
"for select c.\"COLUMN\" as _column from\n"
"DB.DBA.SYS_COLS c, DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp\n"
"where\n"
"c.COL_ID = kp.KP_COL and\n"
"kp.KP_KEY_ID = k.KEY_ID and\n"
"k.KEY_TABLE = tb and\n"
"k.KEY_IS_MAIN = 1 and\n"
"k.KEY_MIGRATE_TO is null and\n"
"kp.KP_NTH < k.KEY_N_SIGNIFICANT\n"
"order by kp.KP_NTH do\n"
"{\n"
"if (inx >= length (cols))\n"
"return 1;\n"
"if (_column <> cols[inx])\n"
"return 1;\n"
"inx := inx + 1;\n"
"}\n"
"if (inx <> length (cols))\n"
"return 1;\n"
"else\n"
"return 0;\n"
"}\n"
"--src system.sql:1125\n";

static const char *proc30 = 
" create procedure ddl_pk_modify (in tb varchar, in cols any)\n"
"{\n"
"\n"
"\n"
"declare st, msg varchar;\n"
"st := \'00000\';\n"
"log_enable(0);\n"
"DB.DBA.ddl_pk_modify_check (tb, cols);\n"
"if (not DB.DBA.ddl_pk_is_changed (tb, cols))\n"
"{\n"
"log_enable (1);\n"
"return;\n"
"}\n"
"__atomic (1);\n"
"exec (\'DB.DBA.ddl_pk_change_1 (?, ?)\', st, msg, vector (tb, cols));\n"
"if (st <> \'00000\')\n"
"{\n"
"declare tname, tname_esc varchar;\n"
"tname := complete_table_name (\'TEMP__\', 0);\n"
"tname_esc := sprintf (\'\"%I\".\"%I\".\"%I\"\',\n"
"name_part (tname, 0), name_part (tname, 1), name_part (tname, 2));\n"
"declare st1, msg1 varchar;\n"
"exec (concat (\'drop table \', tname_esc), st1, msg1, vector ());\n"
"__atomic (0);\n"
"commit work;\n"
"log_enable(0);\n"
"signal (st, msg);\n"
"}\n"
"\n"
"exec (\'DB.DBA.ddl_pk_change_final (?, ?)\', st, msg, vector (tb, cols));\n"
"if (st <> \'00000\')\n"
"{\n"
"\n"
"raw_exit (1);\n"
"}\n"
"log_enable (1);\n"
"log_text (\'DB.DBA.ddl_pk_modify (?, ?)\', tb, cols);\n"
"commit work;\n"
"__atomic (0);\n"
"}\n"
"--src system.sql:1157\n";

static const char *proc31 = 
"create procedure DB.DBA.fk_check_input_values (in mod integer)\n"
"{\n"
"declare ret, ret1 any;\n"
"ret1 := registry_get (\'FK_UNIQUE_CHEK\');\n"
"if (ret1 = \'ON\')\n"
"ret := 1;\n"
"else\n"
"ret := 0;\n"
"\n"
"if (mod = 1)\n"
"registry_set (\'FK_UNIQUE_CHEK\', \'ON\');\n"
"else if (mod = 0)\n"
"registry_set (\'FK_UNIQUE_CHEK\', \'OFF\');\n"
"else if (mod = -1)\n"
"{\n"
"if (not (ret1 = \'ON\' or ret1 = \'OFF\'))\n"
"registry_set (\'FK_UNIQUE_CHEK\', \'ON\');\n"
"}\n"
"else\n"
"signal (\'22023\', \'function fk_check_input_values expect -1, 0 or 1 as first parameter\', \'SR293\');\n"
"return ret;\n"
"}\n"
"--src system.sql:1199\n";

static const char *other1 = 
"DB.DBA.fk_check_input_values (-1)\n";
static const char *proc32 = 
"create procedure DB.DBA.ddl_check_constraint (in pk_table varchar, in decl any)\n"
"{\n"
"declare inx, n_pc, n_pkc integer;\n"
"declare pk_col_name, uniq, col_name varchar;\n"
"declare pkc, pkcols any;\n"
"declare k_id, parts integer;\n"
"declare iu cursor for select SC.\"COLUMN\"\n"
"from  DB.DBA.SYS_KEY_PARTS KP, DB.DBA.SYS_COLS SC\n"
"where KP.KP_KEY_ID = k_id and SC.COL_ID = KP.KP_COL;\n"
"\n"
"\n"
"pkcols := aref (decl, 3);\n"
"inx := 0;\n"
"n_pc := length (pkcols);\n"
"pkc := DB.DBA.ddl_table_pk_cols (pk_table);\n"
"\n"
"n_pkc := length (pkc);\n"
"while (inx < n_pc)\n"
"{\n"
"pk_col_name := convert (varchar, aref (pkcols, inx));\n"
"if (not exists (select 1 from DB.DBA.SYS_KEY_COLUMNS\n"
"where \"KEY_TABLE\" = pk_table and 0 = casemode_strcmp (\"COLUMN\", pk_col_name)) and\n"
"not exists (select 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = pk_table and 0 = casemode_strcmp (\"COLUMN\", pk_col_name)))\n"
"signal (\'42S22\', sprintf (\'Foreign key references invalid column \"%s\" in referenced table \"%s\"\',\n"
"pk_col_name, pk_table), \'SR294\');\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"uniq := registry_get (\'FK_UNIQUE_CHEK\');\n"
"\n"
"if (uniq <> \'ON\' or bit_and (decl [8], 1))\n"
"return;\n"
"\n"
"if (n_pc = n_pkc)\n"
"{\n"
"inx := 0;\n"
"while (inx < n_pc)\n"
"{\n"
"pk_col_name := convert (varchar, aref (pkcols, inx));\n"
"if (0 <> casemode_strcmp (pk_col_name, aref (pkc, inx)))\n"
"goto unq_check;\n"
"inx := inx + 1;\n"
"}\n"
"return;\n"
"}\n"
"\n"
"unq_check:\n"
"\n"
"for select KEY_ID, KEY_DECL_PARTS from DB.DBA.SYS_KEYS\n"
"where 0 = casemode_strcmp (KEY_TABLE, pk_table) and KEY_IS_MAIN = 0 and KEY_IS_UNIQUE = 1 do {\n"
"k_id := KEY_ID; parts := KEY_DECL_PARTS;\n"
"if (n_pc = parts and parts > 0)\n"
"{\n"
"whenever not found goto uk_done;\n"
"open iu;\n"
"inx := 0;\n"
"while (inx < parts)\n"
"{\n"
"pk_col_name := convert (varchar, aref (pkcols, inx));\n"
"fetch iu into col_name;\n"
"if (0 <> casemode_strcmp (pk_col_name, col_name))\n"
"goto uk_done;\n"
"inx := inx + 1;\n"
"}\n"
"uk_done:\n"
"close iu;\n"
"\n"
"if (inx = parts)\n"
"return;\n"
"}\n"
"}\n"
"\n"
"\n"
"inx := 0;\n"
"while (inx < n_pc)\n"
"{\n"
"pk_col_name := convert (varchar, aref (pkcols, inx));\n"
"if (not exists (select 1 from DB.DBA.SYS_KEY_COLUMNS where \"KEY_TABLE\" = pk_table\n"
"and 0 = casemode_strcmp (\"COLUMN\", pk_col_name) and COL_CHECK = \'I\'))\n"
"signal (\'37000\', sprintf (\'Foreign key references non-unique column \"%s\" in table \"%s\"\',\n"
"pk_col_name, pk_table), \'SR295\');\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src system.sql:1227\n";

static const char *proc33 = 
"create procedure ddl_fk_modify (in tb varchar, in op integer, in decl any)\n"
"{\n"
"declare pkt varchar;\n"
"declare fkn any;\n"
"if (isstring (aref (decl, 2)))\n"
"pkt := complete_table_name (aref (decl, 2), 1);\n"
"else\n"
"pkt := null;\n"
"\n"
"if (op = 1 and pkt is null)\n"
"signal (\'37000\', \'To add foreign key REFERENCES should be specified\', \'SR296\');\n"
"\n"
"fkn := aref (decl, 7);\n"
"\n"
"if (op = 1)\n"
"ddl_foreign_key (tb, pkt, decl);\n"
"else if (op = 2)\n"
"{\n"
"if (pkt is not null)\n"
"{\n"
"declare inx, n_fc, n_pc integer;\n"
"declare fk_col_name, pk_col_name, fnam, fnam1, lastf varchar;\n"
"if (not exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS where FK_TABLE = tb and PK_TABLE = pkt))\n"
"signal (\'42S12\', sprintf (\'Foreign key does not exist in table \"%s\" referencing table \"%s\"\', tb, pkt), \'SR297\');\n"
"\n"
"\n"
"if (0 = isarray (aref (decl, 3)) or 0 = length (aref (decl, 3)))\n"
"aset (decl, 3, ddl_table_pk_cols (pkt));\n"
"else\n"
"DB.DBA.ddl_check_constraint (pkt, decl);\n"
"\n"
"n_fc := length (aref (decl, 1));\n"
"n_pc := length (aref (decl, 3));\n"
"if (n_fc <> n_pc)\n"
"signal (\'37000\',\n"
"concat (\'Different number of referencing and referenced columns in foreign key declaration from \',\n"
"tb, \' to \', pkt), \'SQ125\');\n"
"\n"
"inx := 0; fnam := \'\';\n"
"while (inx < n_pc)\n"
"{\n"
"fk_col_name := convert (varchar, aref (aref (decl, 1), inx));\n"
"pk_col_name := convert (varchar, aref (aref (decl, 3), inx));\n"
"fnam := concat (fnam, \'_\', convert (varchar, aref (aref (decl, 1), inx)), \'_\',\n"
"convert (varchar, aref (aref (decl, 3), inx)));\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"fnam1 := \'\'; lastf := \'\';\n"
"for select FK_NAME, FKCOLUMN_NAME, PKCOLUMN_NAME from DB.DBA.SYS_FOREIGN_KEYS\n"
"where FK_TABLE = tb and PK_TABLE = pkt order by KEY_SEQ do\n"
"{\n"
"if (lastf <> FK_NAME)\n"
"{\n"
"if (fnam1 = fnam)\n"
"goto dro;\n"
"else\n"
"fnam1 := \'\';\n"
"}\n"
"\n"
"lastf := FK_NAME;\n"
"fnam1 := concat (fnam1, FKCOLUMN_NAME, \'_\', PKCOLUMN_NAME);\n"
"}\n"
"dro:\n"
"\n"
"delete from DB.DBA.SYS_FOREIGN_KEYS where FK_TABLE = tb and 0 = casemode_strcmp (FK_NAME, lastf);\n"
"DB.DBA.ddl_fk_rules (pkt, null, null);\n"
"DB.DBA.ddl_fk_check_input (tb, 0);\n"
"}\n"
"else if (fkn <> 0)\n"
"{\n"
"fkn := convert (varchar, fkn);\n"
"if (exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS where FK_TABLE = tb and 0 = casemode_strcmp (FK_NAME, fkn)))\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"pkt := (select distinct PK_TABLE from DB.DBA.SYS_FOREIGN_KEYS\n"
"where FK_TABLE = tb and 0 = casemode_strcmp (FK_NAME, fkn));\n"
"delete from DB.DBA.SYS_FOREIGN_KEYS where FK_TABLE = tb and 0 = casemode_strcmp (FK_NAME, fkn);\n"
"DB.DBA.ddl_fk_rules (pkt, null, null);\n"
"DB.DBA.ddl_fk_check_input (tb, 0);\n"
"}\n"
"else\n"
"signal (\'42S12\', sprintf (\'Foreign key \"%s\" does not exist\', fkn), \'SR298\');\n"
"}\n"
"else\n"
"signal (\'37000\', \'To drop foreign key should be specified NAME or REFERENCES\', \'SR299\');\n"
"}\n"
"else\n"
"signal (\'42S11\', \'To modify a foreign key first drop the old and then add the new\', \'SR300\');\n"
"}\n"
"--src system.sql:1315\n";

static const char *proc34 = 
" create procedure ddl_alter_constr (in tb varchar, in op integer, in decl any)\n"
"{\n"
"declare type integer;\n"
"declare orig_pkt varchar;\n"
"tb := complete_table_name (tb, 1);\n"
"ddl_owner_check (tb);\n"
"\n"
"type := decl[0];\n"
"if (op = 2 and length (decl) = 9 and type = 1 and 127 = __tag (aref (decl, 7)))\n"
"{\n"
"declare _name varchar;\n"
"_name := convert (varchar, decl[7]);\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_CONSTRAINTS\n"
"where C_TABLE = tb and 0 = casemode_strcmp (C_TEXT, _name)))\n"
"decl := vector (3, NULL, _name);\n"
"else if (not exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS\n"
"where FK_TABLE = tb and 0 = casemode_strcmp (FK_NAME, _name)))\n"
"decl[0] := 2;\n"
"\n"
"type := decl[0];\n"
"if (type = 1)\n"
"{\n"
"whenever not found goto next;\n"
"whenever sqlstate \'*\' goto next;\n"
"orig_pkt := null;\n"
"if (not isstring (decl[2]))\n"
"select PK_TABLE into orig_pkt from DB.DBA.SYS_FOREIGN_KEYS\n"
"where FK_TABLE = tb and 0 = casemode_strcmp (FK_NAME, _name);\n"
"}\n"
"}\n"
"\n"
"next:\n"
"if (0 = type)\n"
"{\n"
"if (3 <> op)\n"
"signal (\'37000\', \'A primary key cannot be added or dropped. It can only be modified. Use alter table .. modify primary key ...\', \'SR301\');\n"
"ddl_pk_modify (tb, decl[3]);\n"
"}\n"
"else if (1 = type)\n"
"{\n"
"ddl_fk_modify (tb, op, decl);\n"
"}\n"
"else if (2 = type)\n"
"ddl_unq_modify (tb, op, decl);\n"
"else if (3 = type)\n"
"{\n"
"ddl_check_modify (tb, op, decl);\n"
"}\n"
"if (not sys_stat (\'st_lite_mode\'))\n"
"__REPL_DDL_FK_MODIFY_PROPAGATE (tb, op, decl, orig_pkt);\n"
"}\n"
"--src system.sql:1411\n";

static const char *proc35 = 
"create procedure ddl_unq_modify (in tb varchar, in op integer, in decl any)\n"
"{\n"
"declare nconstr, txt, cols_txt, stat, msg varchar;\n"
"declare cols any;\n"
"declare inx, len, int_name integer;\n"
"\n"
"int_name := 0;\n"
"if (length (decl) = 9 and op = 2)\n"
"nconstr := aref (decl, 7);\n"
"else\n"
"nconstr := aref (decl, 1);\n"
"\n"
"\n"
"\n"
"if (127 <> __tag (nconstr))\n"
"{\n"
"int_name := 1;\n"
"nconstr := \'\';\n"
"}\n"
"else\n"
"nconstr := convert (varchar, nconstr);\n"
"\n"
"txt := \'\'; cols_txt := \'\'; stat := \'00000\'; msg := \'\'; inx := 0;\n"
"if (int_name or op = 1)\n"
"{\n"
"cols := aref (decl, 3);\n"
"len := length (cols);\n"
"}\n"
"\n"
"if (op = 1)\n"
"{\n"
"while (inx < len)\n"
"{\n"
"cols_txt := concat (cols_txt, \',\', aref (cols, inx));\n"
"if (int_name)\n"
"nconstr := concat (nconstr, \'_\',  aref (cols, inx));\n"
"inx := inx + 1;\n"
"}\n"
"if (int_name)\n"
"{\n"
"nconstr := concat (name_part(tb,0), \'_\', name_part(tb, 1), \'_\', name_part (tb, 2), \'_UNQC\', nconstr);\n"
"nconstr := DB.DBA.SYS_ALFANUM_NAME (nconstr);\n"
"}\n"
"cols_txt := substring (cols_txt, 2, length (cols_txt));\n"
"txt := sprintf (\'CREATE UNIQUE INDEX \"%I\" ON \"%I\".\"%I\".\"%I\" (%s)\',\n"
"nconstr, name_part (tb, 0), name_part (tb, 1), name_part (tb, 2), cols_txt);\n"
"if (exec (txt, stat, msg))\n"
"signal (stat, msg);\n"
"}\n"
"else if (op = 2)\n"
"{\n"
"if (int_name)\n"
"{\n"
"while (inx < len)\n"
"{\n"
"nconstr := concat (nconstr, \'_\',  aref (cols, inx));\n"
"inx := inx + 1;\n"
"}\n"
"nconstr := concat (name_part(tb,0), \'_\', name_part(tb, 1), \'_\', name_part (tb, 2), \'_UNQC\', nconstr);\n"
"nconstr := DB.DBA.SYS_ALFANUM_NAME (nconstr);\n"
"}\n"
"if (not exists (select 1 from DB.DBA.SYS_KEYS where\n"
"0 = casemode_strcmp(KEY_TABLE, complete_table_name (tb, 0))\n"
"and 0 = casemode_strcmp (KEY_NAME, nconstr)\n"
"and KEY_IS_UNIQUE = 1))\n"
"signal (\'42S12\', sprintf (\'Constraint \"%s\" does not exist for table \"%s\"\', nconstr, tb), \'SR320\');\n"
"\n"
"txt := sprintf (\'DROP INDEX \"%I\" \"%I\".\"%I\".\"%I\"\',\n"
"nconstr, name_part (tb, 0), name_part (tb, 1), name_part (tb, 2));\n"
"if (exec (txt, stat, msg))\n"
"signal (stat, msg);\n"
"}\n"
"else\n"
"signal (\'37000\', \'To modify a unique constraint first drop the old and then add the new\', \'SR302\');\n"
"}\n"
"--src system.sql:1465\n";

static const char *proc36 = 
"create procedure ddl_check_modify (in tb varchar, in op integer, in decl any)\n"
"{\n"
"declare constr_name varchar;\n"
"declare constr_check any;\n"
"\n"
"constr_name := decl[2];\n"
"constr_check := decl[1];\n"
"\n"
"\n"
"if (op = 1)\n"
"{\n"
"declare cr cursor for\n"
"select C_ID from DB.DBA.SYS_CONSTRAINTS where C_TABLE = tb order by C_TABLE, C_ID desc;\n"
"declare last_id integer;\n"
"\n"
"if (isstring (constr_name))\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_CONSTRAINTS WHERE C_TABLE = tb and C_TEXT = constr_name))\n"
"signal (\'22023\', concat (\'CHECK constraint \', constr_name, \' for table \', tb, \' already exists\'),\n"
"\'SR3634\');\n"
"}\n"
"\n"
"last_id := null;\n"
"{\n"
"whenever not found goto notf;\n"
"open cr (exclusive, prefetch 1);\n"
"fetch cr into last_id;\n"
"\n"
"notf:;\n"
"}\n"
"last_id := coalesce (last_id, -1) + 1;\n"
"\n"
"DDL_ENSURE_CONSTRAINT_NAME_UNIQUE (constr_name);\n"
"insert into DB.DBA.SYS_CONSTRAINTS (C_TABLE, C_ID, C_TEXT, C_MODE)\n"
"values (\n"
"tb,\n"
"last_id,\n"
"constr_name,\n"
"serialize (constr_check));\n"
"}\n"
"else if (op = 2)\n"
"{\n"
"if (isstring (constr_name))\n"
"delete from DB.DBA.SYS_CONSTRAINTS where C_TABLE = tb and C_TEXT = constr_name;\n"
"else\n"
"delete from DB.DBA.SYS_CONSTRAINTS where C_TABLE = tb and blob_to_string (C_MODE) = serialize (constr_check);\n"
"}\n"
"else if (op = 3)\n"
"{\n"
"if (isstring (constr_name))\n"
"update DB.DBA.SYS_CONSTRAINTS set C_MODE = serialize (constr_check) where C_TABLE = tb and C_TEXT = constr_name;\n"
"else\n"
"signal (\'22023\', \'Cannot MODIFY unnamed check constraints\', \'SR365\');\n"
"}\n"
"else\n"
"signal (\'22023\', \'Invalid code in ALTER TABLE (CHECK constraint)\', \'SR366\');\n"
"\n"
"if (row_count () <> 1)\n"
"{\n"
"if (isstring (constr_name))\n"
"signal (\'22023\', concat (\'CHECK Constraint \', constr_name, \' on table \', tb, \' not defined\'), \'SR367\');\n"
"else\n"
"signal (\'22023\', concat (\'unnamed CHECK Constraint on table \', tb, \' not defined\'), \'SR368\');\n"
"}\n"
"__ddl_read_constraints (tb);\n"
"}\n"
"--src system.sql:1542\n";

static const char *proc37 = 
"create procedure __HTTP_XSLT (inout _XML any, inout DOC_URI varchar, inout XSLT_URI varchar, inout PARAMS any, inout MEDIATYPE varchar, inout ENC varchar)\n"
"{\n"
"declare result any;\n"
"declare _xslt_url varchar;\n"
"if (XSLT_URI like \'precompiled:%\')\n"
"_xslt_url := substring (XSLT_URI, 13, length (XSLT_URI));\n"
"else\n"
"_xslt_url := WS.WS.EXPAND_URL (DOC_URI, XSLT_URI);\n"
"if (isarray (PARAMS))\n"
"result := xslt (_xslt_url, xml_tree_doc (xml_tree (_XML), DOC_URI), PARAMS);\n"
"else\n"
"result := xslt (_xslt_url, xml_tree_doc (xml_tree (_XML), DOC_URI));\n"
"http_output_flush ();\n"
"MEDIATYPE := xml_tree_doc_media_type(result);\n"
"ENC := xml_tree_doc_encoding (result);\n"
"http_value (result);\n"
"}\n"
"--src system.sql:1610\n";

static const char *proc38 = 
"create procedure DB.DBA.ddl_fk_rules (in pktb varchar, in drop_tb varchar, in drop_col varchar)\n"
"{\n"
"declare stmt, set_cl, whe_cl, updst, delst, thetb, pkcols, pkvars, trig_pref, skip_on_this varchar;\n"
"declare is_upd, is_del integer;\n"
"\n"
"is_upd := 0;\n"
"is_del := 0;\n"
"\n"
"DB.DBA.ddl_pk_check_input (pktb, drop_tb, drop_col);\n"
"pktb := complete_table_name (pktb, 1);\n"
"if (exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = pktb))\n"
"return;\n"
"\n"
"if (drop_tb is not null)\n"
"drop_tb := complete_table_name (drop_tb, 1);\n"
"else\n"
"drop_tb := \'\';\n"
"\n"
"\n"
"if (drop_col is null)\n"
"{\n"
"skip_on_this := \'\';\n"
"drop_col := \'\';\n"
"}\n"
"else\n"
"{\n"
"skip_on_this := drop_tb;\n"
"drop_tb := \'\';\n"
"}\n"
"pkcols := \'\'; pkvars := \'\'; thetb := \'\'; set_cl := \'\'; whe_cl := \'\'; updst := \'\';\n"
"trig_pref := sprintf (\'%s_%s_%s\', DB.DBA.SYS_ALFANUM_NAME (name_part (pktb, 0)),\n"
"DB.DBA.SYS_ALFANUM_NAME (name_part (pktb, 1)),\n"
"DB.DBA.SYS_ALFANUM_NAME (name_part (pktb, 2)));\n"
"\n"
"for select distinct PKCOLUMN_NAME from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (PK_TABLE, pktb) and (UPDATE_RULE > 0 or DELETE_RULE > 0)\n"
"and 0 <> casemode_strcmp (FK_TABLE, drop_tb)\n"
"and not (0 = casemode_strcmp (FK_TABLE, skip_on_this) and 0 = casemode_strcmp (FKCOLUMN_NAME, drop_col))\n"
"do\n"
"{\n"
"pkcols := concat (pkcols, \'\"\', PKCOLUMN_NAME, \'\", \');\n"
"pkvars := concat (pkvars, \' DECLARE _VAR_\' , DB.DBA.SYS_ALFANUM_NAME (PKCOLUMN_NAME), \' VARCHAR; \\n _VAR_\',\n"
"DB.DBA.SYS_ALFANUM_NAME (PKCOLUMN_NAME), \' := O.\"\', PKCOLUMN_NAME, \'\";\\n\');\n"
"}\n"
"if (length (pkcols) > 2)\n"
"pkcols := substring (pkcols, 1, length (pkcols) - 2);\n"
"else\n"
"{\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = sprintf (\'%s_FK_UPDATE\', trig_pref)))\n"
"{\n"
"stmt := sprintf (\'DROP TRIGGER \"%I\".\"%I\".\"%s_FK_UPDATE\"\', name_part (pktb, 0), name_part (pktb, 1), trig_pref);\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = sprintf (\'%s_FK_DELETE\', trig_pref)))\n"
"{\n"
"stmt := sprintf (\'DROP TRIGGER \"%I\".\"%I\".\"%s_FK_DELETE\"\', name_part (pktb, 0), name_part (pktb, 1), trig_pref);\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"return;\n"
"}\n"
"\n"
"\n"
"for select FK_TABLE, FKCOLUMN_NAME, PKCOLUMN_NAME, UPDATE_RULE  from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (PK_TABLE, pktb) and UPDATE_RULE is not null and UPDATE_RULE > 0\n"
"and 0 <> casemode_strcmp (FK_TABLE, drop_tb)\n"
"and not (0 = casemode_strcmp (FK_TABLE, skip_on_this) and 0 = casemode_strcmp (FKCOLUMN_NAME, drop_col))\n"
"order by FK_TABLE do\n"
"{\n"
"\n"
"is_upd := 1;\n"
"if (FK_TABLE <> thetb and thetb <> \'\')\n"
"{\n"
"set_cl := substring (set_cl, 1, length (set_cl) - 2);\n"
"whe_cl := concat (\' WHERE \', whe_cl);\n"
"whe_cl := substring (whe_cl, 1, length (whe_cl) - 5);\n"
"updst := concat (updst, sprintf (\'  UPDATE \"%I\".\"%I\".\"%I\" SET \', name_part (thetb, 0),\n"
"name_part (thetb, 1), name_part (thetb, 2)), set_cl, whe_cl, \';\\n\');\n"
"set_cl := \'\';\n"
"whe_cl := \'\';\n"
"}\n"
"if (FK_TABLE is not null)\n"
"{\n"
"thetb := FK_TABLE;\n"
"if (UPDATE_RULE = 1)\n"
"set_cl := concat (set_cl, sprintf (\'\"%I\" = N.\"%I\", \' , FKCOLUMN_NAME, PKCOLUMN_NAME));\n"
"else if (UPDATE_RULE = 2)\n"
"set_cl := concat (set_cl, sprintf (\'\"%I\" = NULL, \' , FKCOLUMN_NAME));\n"
"else if (UPDATE_RULE = 3)\n"
"set_cl := concat (set_cl,\n"
"sprintf (\'\"%I\" = coalesce ((select deserialize (COL_DEFAULT) from DB.DBA.SYS_COLS where \"COLUMN\" = \'\'%I\'\' and \"TABLE\" = \'\'%I\'\'), NULL), \' ,\n"
"FKCOLUMN_NAME, FKCOLUMN_NAME, FK_TABLE));\n"
"\n"
"whe_cl := concat (whe_cl, sprintf (\'\"%I\" = O.\"%I\" and \' , FKCOLUMN_NAME, PKCOLUMN_NAME));\n"
"}\n"
"}\n"
"if (thetb <> \'\' and set_cl <> \'\' and whe_cl <> \'\')\n"
"{\n"
"set_cl := substring (set_cl, 1, length (set_cl) - 2);\n"
"whe_cl := concat (\' WHERE \', whe_cl);\n"
"whe_cl := substring (whe_cl, 1, length (whe_cl) - 5);\n"
"updst := concat (updst, sprintf (\'  UPDATE \"%I\".\"%I\".\"%I\" SET \', name_part (thetb, 0),\n"
"name_part (thetb, 1), name_part (thetb, 2)), set_cl, whe_cl, \';\\n\');\n"
"set_cl := \'\';\n"
"whe_cl := \'\';\n"
"}\n"
"\n"
"if (is_upd > 0)\n"
"{\n"
"stmt := sprintf (\'CREATE TRIGGER \"%s_FK_UPDATE\" AFTER UPDATE (%s)\\n ON \"%I\".\"%I\".\"%I\" ORDER 99 REFERENCING OLD AS O, NEW AS N {\\n DECLARE EXIT HANDLER FOR SQLSTATE \\\'*\\\' { ROLLBACK WORK; RESIGNAL; };\\n %s \\n }\',\n"
"trig_pref, pkcols,\n"
"name_part (pktb, 0), name_part (pktb, 1), name_part (pktb, 3), updst);\n"
"DB.DBA.execstr1 (stmt);\n"
"}\n"
"else if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = sprintf (\'%s_FK_UPDATE\', trig_pref)))\n"
"{\n"
"\n"
"stmt := sprintf (\'DROP TRIGGER \"%I\".\"%I\".\"%s_FK_UPDATE\"\', name_part (pktb, 0), name_part (pktb, 1), trig_pref);\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"delst := \'\'; thetb := \'\';\n"
"\n"
"for select FK_TABLE, FKCOLUMN_NAME, PKCOLUMN_NAME from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (PK_TABLE, pktb) and DELETE_RULE = 1\n"
"and 0 <> casemode_strcmp (FK_TABLE, drop_tb)\n"
"and not (0 = casemode_strcmp (FK_TABLE, skip_on_this) and 0 = casemode_strcmp (FKCOLUMN_NAME, drop_col))\n"
"order by FK_TABLE do\n"
"{\n"
"is_del := 1;\n"
"if (FK_TABLE <> thetb and thetb <> \'\')\n"
"{\n"
"whe_cl := concat (\' WHERE \', whe_cl);\n"
"whe_cl := substring (whe_cl, 1, length (whe_cl) - 5);\n"
"delst := concat (delst, sprintf (\'  DELETE FROM \"%I\".\"%I\".\"%I\" \', name_part (thetb, 0),\n"
"name_part (thetb, 1), name_part (thetb, 2)), whe_cl, \';\\n\');\n"
"whe_cl := \'\';\n"
"}\n"
"if (FK_TABLE is not null)\n"
"{\n"
"thetb := FK_TABLE;\n"
"whe_cl := concat (whe_cl, sprintf (\'\"%I\" = _VAR_%s and \' , FKCOLUMN_NAME, DB.DBA.SYS_ALFANUM_NAME (PKCOLUMN_NAME)));\n"
"}\n"
"}\n"
"if (thetb <> \'\' and whe_cl <> \'\')\n"
"{\n"
"whe_cl := concat (\' WHERE \', whe_cl);\n"
"whe_cl := substring (whe_cl, 1, length (whe_cl) - 5);\n"
"delst := concat (delst, sprintf (\'  DELETE FROM \"%I\".\"%I\".\"%I\" \', name_part (thetb, 0),\n"
"name_part (thetb, 1), name_part (thetb, 2)), whe_cl, \';\\n\');\n"
"set_cl := \'\';\n"
"whe_cl := \'\';\n"
"}\n"
"\n"
"updst := \'\';  thetb := \'\';\n"
"for select FK_TABLE, FKCOLUMN_NAME, PKCOLUMN_NAME, DELETE_RULE  from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (PK_TABLE, pktb) and DELETE_RULE is not null and DELETE_RULE > 1\n"
"and 0 <> casemode_strcmp (FK_TABLE, drop_tb)\n"
"and not (0 = casemode_strcmp (FK_TABLE, skip_on_this) and 0 = casemode_strcmp (FKCOLUMN_NAME, drop_col))\n"
"order by FK_TABLE do\n"
"{\n"
"is_del := 1;\n"
"if (FK_TABLE <> thetb and thetb <> \'\')\n"
"{\n"
"set_cl := substring (set_cl, 1, length (set_cl) - 2);\n"
"whe_cl := concat (\' WHERE \', whe_cl);\n"
"whe_cl := substring (whe_cl, 1, length (whe_cl) - 5);\n"
"updst := concat (updst, sprintf (\'  UPDATE \"%I\".\"%I\".\"%I\" SET \', name_part (thetb, 0),\n"
"name_part (thetb, 1), name_part (thetb, 2)), set_cl, whe_cl, \';\\n\');\n"
"set_cl := \'\';\n"
"whe_cl := \'\';\n"
"}\n"
"if (FK_TABLE is not null)\n"
"{\n"
"thetb := FK_TABLE;\n"
"if (DELETE_RULE = 2)\n"
"set_cl := concat (set_cl, sprintf (\'\"%I\" = NULL, \' , FKCOLUMN_NAME));\n"
"else if (DELETE_RULE = 3)\n"
"set_cl := concat (set_cl,\n"
"sprintf (\'\"%I\" = coalesce ((select deserialize (COL_DEFAULT) from DB.DBA.SYS_COLS where \"COLUMN\" = \'\'%I\'\' and \"TABLE\" = \'\'%I\'\'), NULL), \' ,\n"
"FKCOLUMN_NAME, FKCOLUMN_NAME, FK_TABLE));\n"
"\n"
"whe_cl := concat (whe_cl, sprintf (\'\"%I\" = _VAR_%s and \' , FKCOLUMN_NAME, DB.DBA.SYS_ALFANUM_NAME (PKCOLUMN_NAME)));\n"
"}\n"
"}\n"
"if (thetb <> \'\' and set_cl <> \'\' and whe_cl <> \'\')\n"
"{\n"
"set_cl := substring (set_cl, 1, length (set_cl) - 2);\n"
"whe_cl := concat (\' WHERE \', whe_cl);\n"
"whe_cl := substring (whe_cl, 1, length (whe_cl) - 5);\n"
"updst := concat (updst, sprintf (\'  UPDATE \"%I\".\"%I\".\"%I\" SET \', name_part (thetb, 0),\n"
"name_part (thetb, 1), name_part (thetb, 2)), set_cl, whe_cl, \';\\n\');\n"
"set_cl := \'\';\n"
"whe_cl := \'\';\n"
"}\n"
"\n"
"if (is_del > 0)\n"
"{\n"
"stmt := sprintf (\'CREATE TRIGGER \"%s_FK_DELETE\" AFTER DELETE \\n ON \"%I\".\"%I\".\"%I\" ORDER 99 referencing old as O {\\n DECLARE EXIT HANDLER FOR SQLSTATE \\\'*\\\' { ROLLBACK WORK; RESIGNAL; };\\n %s %s %s \\n}\',\n"
"trig_pref, name_part (pktb, 0), name_part (pktb, 1), name_part (pktb, 3), pkvars, delst, updst);\n"
"DB.DBA.execstr1 (stmt);\n"
"}\n"
"else if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = sprintf (\'%s_FK_DELETE\', trig_pref)))\n"
"{\n"
"\n"
"stmt := sprintf (\'DROP TRIGGER \"%I\".\"%I\".\"%s_FK_DELETE\"\', name_part (pktb, 0), name_part (pktb, 1), trig_pref);\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"}\n"
"--src system.sql:1631\n";

static const char *proc39 = 
"create procedure DB.DBA.ddl_pk_check_input (in pktb varchar, in drop_tb varchar, in drop_col varchar)\n"
"{\n"
"declare uniq, trig_pref, vars, whe, uwhe, stmt, ins, upd, fktb, skip_on_this, pku varchar;\n"
"declare _u, _d, _uc, _dc integer;\n"
"\n"
"\n"
"vars := \'\'; whe := \'\'; uwhe := \'\'; ins := \'\'; upd := \'\'; pku := \'\';\n"
"pktb := complete_table_name (pktb, 1);\n"
"if (exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = pktb))\n"
"return;\n"
"trig_pref := DB.DBA.SYS_ALFANUM_NAME (pktb);\n"
"\n"
"if (drop_tb is not null)\n"
"drop_tb := complete_table_name (drop_tb, 1);\n"
"else\n"
"drop_tb := \'\';\n"
"\n"
"\n"
"if (drop_col is null)\n"
"{\n"
"skip_on_this := \'\';\n"
"drop_col := \'\';\n"
"}\n"
"else\n"
"{\n"
"skip_on_this := drop_tb;\n"
"drop_tb := \'\';\n"
"}\n"
"\n"
"_uc := 0; _dc := 0;\n"
"for select distinct FK_TABLE as fk_table_name, FK_NAME as fkname from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (PK_TABLE, pktb)\n"
"and not (0 = casemode_strcmp (FK_TABLE, PK_TABLE) and 0 = casemode_strcmp (PKCOLUMN_NAME, FKCOLUMN_NAME))\n"
"\n"
"do {\n"
"\n"
"fktb := complete_table_name (fk_table_name, 1);\n"
"_u := 0; _d := 0;\n"
"for select PKCOLUMN_NAME as pk_col_name, FKCOLUMN_NAME as fk_col_name, UPDATE_RULE, DELETE_RULE from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (PK_TABLE, pktb) and\n"
"0 = casemode_strcmp (FK_TABLE, fk_table_name)\n"
"and 0 <> casemode_strcmp (FK_TABLE, drop_tb)\n"
"and FK_NAME = fkname\n"
"and not (0 = casemode_strcmp (FK_TABLE, skip_on_this) and 0 = casemode_strcmp (FKCOLUMN_NAME, drop_col))\n"
"do\n"
"{\n"
"if (UPDATE_RULE = 0)\n"
"{\n"
"uwhe := concat (uwhe, \'\"\', fk_col_name, \'\" = O.\"\', pk_col_name, \'\" and \');\n"
"pku := concat (pku, \'N.\"\', pk_col_name, \'\" <> O.\"\', pk_col_name, \'\" or \');\n"
"_u := 1;\n"
"_uc := _uc + 1;\n"
"}\n"
"\n"
"if (DELETE_RULE = 0)\n"
"{\n"
"vars := concat (vars, \'\\n DECLARE _VAR_\', DB.DBA.SYS_ALFANUM_NAME (pk_col_name), \' ANY;\\n _VAR_\',\n"
"DB.DBA.SYS_ALFANUM_NAME (pk_col_name), sprintf (\' := O.\"%I\"\', pk_col_name), \';\\n\');\n"
"whe := concat (whe, \'\"\', fk_col_name, \'\" = _VAR_\', DB.DBA.SYS_ALFANUM_NAME (pk_col_name), \' and \');\n"
"_d := 1;\n"
"_dc := _dc + 1;\n"
"}\n"
"}\n"
"\n"
"if (_d)\n"
"{\n"
"whe := substring (whe, 1, length (whe) - 5);\n"
"ins := concat (ins, \' { \', vars, sprintf (\'if (exists (select 1 from \"%I\".\"%I\".\"%I\"\',\n"
"name_part (fk_table_name, 0), name_part (fk_table_name, 1), name_part (fk_table_name,2)),\n"
"\' WHERE \', whe, \')) \\n\',\n"
"sprintf (\'signal (\'\'S1000\'\',\'\'DELETE statement conflicted with COLUMN REFERENCE constraint \"%s\"\'\', \'\'SR304\'\');\\n\', fkname), \' } \');\n"
"}\n"
"\n"
"if (_u)\n"
"{\n"
"uwhe := substring (uwhe, 1, length (uwhe) - 5);\n"
"pku := concat (\'(\', substring (pku, 1, length (pku) - 4), \') and \');\n"
"\n"
"upd := concat (upd, sprintf (\'if (%s exists (select 1 from \"%I\".\"%I\".\"%I\"\', pku,\n"
"name_part (fktb, 0), name_part (fktb, 1), name_part (fktb,2)), \' WHERE \', uwhe, \')) \\n\',\n"
"sprintf (\'signal (\'\'S1000\'\',\'\'UPDATE statement conflicted with COLUMN REFERENCE constraint \"%s\"\'\', \'\'SR305\'\');\\n\', fkname));\n"
"}\n"
"vars := \'\'; whe := \'\'; uwhe := \'\'; pku := \'\';\n"
"}\n"
"\n"
"\n"
"if (_dc > 0)\n"
"{\n"
"stmt := concat (\'CREATE TRIGGER \', upper (trig_pref),\n"
"sprintf (\'_PK_CHECK_DELETE BEFORE DELETE ON \"%I\".\"%I\".\"%I\" order 99 referencing old as O {\\n if (\'\'ON\'\' <> registry_get (\'\'FK_UNIQUE_CHEK\'\'))\\n\\t return;\\n\', name_part (pktb, 0), name_part (pktb, 1), name_part (pktb,2)), ins, \'\\n}\\n\');\n"
"DB.DBA.execstr1 (stmt);\n"
"\n"
"}\n"
"else if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = concat (upper (trig_pref), \'_PK_CHECK_DELETE\')))\n"
"{\n"
"stmt := concat (sprintf (\'DROP TRIGGER \"%I\".\"%I\".\', name_part (pktb, 0), name_part (pktb, 1)), upper (trig_pref), \'_PK_CHECK_DELETE\');\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"\n"
"if (_uc > 0)\n"
"{\n"
"stmt := concat (\'CREATE TRIGGER \', upper (trig_pref),\n"
"sprintf (\'_PK_CHECK_UPDATE BEFORE UPDATE ON \"%I\".\"%I\".\"%I\" order 99 REFERENCING OLD AS O, NEW AS N {\\n if (\'\'ON\'\' <> registry_get (\'\'FK_UNIQUE_CHEK\'\'))\\n\\t return;\\n\',\n"
"name_part (pktb, 0), name_part (pktb, 1), name_part (pktb,2)), upd, \'\\n}\\n\');\n"
"\n"
"DB.DBA.execstr1 (stmt);\n"
"}\n"
"else if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = concat (upper (trig_pref), \'_PK_CHECK_UPDATE\')))\n"
"{\n"
"stmt := concat (sprintf (\'DROP TRIGGER \"%I\".\"%I\".\', name_part (pktb, 0), name_part (pktb, 1)), upper (trig_pref), \'_PK_CHECK_UPDATE\');\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"}\n"
"--src system.sql:1842\n";

static const char *proc40 = 
"create procedure execstr1 (in str varchar)\n"
"{\n"
"declare st, msg varchar;\n"
"st := \'00000\';\n"
"__set_user_id (\'dba\');\n"
"exec (str, st, msg, vector (), 0, null, null);\n"
"__pop_user_id ();\n"
"if (st <> \'00000\')\n"
"{\n"
"txn_error (6);\n"
"signal (st, msg);\n"
"}\n"
"}\n"
"--src system.sql:1958\n";

static const char *proc41 = 
"create procedure DB.DBA.ddl_fk_check_input (in fktb varchar, in to_drop integer)\n"
"{\n"
"declare uniq, trig_pref, vars, whe, uwhe, stmt, ins, upd, pktb, nself, uself varchar;\n"
"\n"
"vars := \'\'; whe := \'\'; uwhe := \'\'; ins := \'\'; upd := \'\';\n"
"fktb := complete_table_name (fktb, 1);\n"
"if (exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = fktb))\n"
"return;\n"
"trig_pref := SYS_ALFANUM_NAME (fktb);\n"
"\n"
"if (to_drop = 1)\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = concat (upper (trig_pref), \'_FK_CHECK_UPDATE\')))\n"
"{\n"
"stmt := concat (sprintf (\'DROP TRIGGER \"%I\".\"%I\".\', name_part (fktb, 0), name_part (fktb, 1)), upper (trig_pref), \'_FK_CHECK_UPDATE\');\n"
"DB.DBA.execstr (stmt);\n"
"stmt := concat (sprintf (\'DROP TRIGGER \"%I\".\"%I\".\', name_part (fktb, 0), name_part (fktb, 1)), upper (trig_pref), \'_FK_CHECK_INSERT\');\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"return;\n"
"}\n"
"\n"
"to_drop := 1;\n"
"\n"
"declare ncond, uncond	varchar;\n"
"ncond := \'\'; uncond := \'\'; nself := \'\'; uself := \'\';\n"
"for select distinct PK_TABLE as pk_table_name, FK_NAME as fkname from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (FK_TABLE, fktb)\n"
"and not (0 = casemode_strcmp (FK_TABLE, PK_TABLE) and 0 = casemode_strcmp (PKCOLUMN_NAME, FKCOLUMN_NAME))\n"
"\n"
"do {\n"
"pktb := complete_table_name (pk_table_name, 1);\n"
"for select PKCOLUMN_NAME as pk_col_name, FKCOLUMN_NAME as fk_col_name from DB.DBA.SYS_FOREIGN_KEYS\n"
"where 0 = casemode_strcmp (FK_TABLE, fktb) and\n"
"0 = casemode_strcmp (PK_TABLE, pk_table_name) and FK_NAME = fkname do\n"
"{\n"
"vars := concat (vars, \'\\n DECLARE _VAR_\', DB.DBA.SYS_ALFANUM_NAME (fk_col_name), \' ANY;\\n _VAR_\',\n"
"DB.DBA.SYS_ALFANUM_NAME (fk_col_name), sprintf (\' := N.\"%I\"\', fk_col_name), \';\\n\');\n"
"whe := concat (whe, \'\"\', pk_col_name, \'\" = _VAR_\', DB.DBA.SYS_ALFANUM_NAME (fk_col_name), \' and \');\n"
"uwhe := concat (uwhe, \'\"\', pk_col_name, \'\" = N.\"\', fk_col_name, \'\" and \');\n"
"ncond := concat (ncond, sprintf (\'_VAR_%s IS NOT NULL\', DB.DBA.SYS_ALFANUM_NAME (fk_col_name)), \' and \');\n"
"uncond := concat (uncond, sprintf (\'N.\"%I\" IS NOT NULL\', fk_col_name), \' and \');\n"
"if (0 = casemode_strcmp (fktb, pk_table_name))\n"
"{\n"
"nself := concat (nself, \' N.\"\', fk_col_name, \'\" <> N.\"\', pk_col_name, \'\" and \');\n"
"uself := concat (uself, \' N.\"\', fk_col_name, \'\" <> N.\"\', pk_col_name, \'\" and \');\n"
"}\n"
"}\n"
"whe := substring (whe, 1, length (whe) - 5);\n"
"uwhe := substring (uwhe, 1, length (uwhe) - 5);\n"
"\n"
"ins := concat (ins, vars, sprintf (\'if (%s %s not exists (select 1 from \"%I\".\"%I\".\"%I\"\',\n"
"ncond, nself, name_part (pk_table_name, 0), name_part (pk_table_name, 1), name_part (pk_table_name,2)),\n"
"\' WHERE \', whe, \')) \\n\',\n"
"sprintf (\'signal (\'\'S1000\'\',\'\'INSERT statement conflicted with FOREIGN KEY constraint referencing table \"%s\"\'\', \'\'SR306\'\');\\n\', pk_table_name));\n"
"upd := concat (upd, sprintf (\'if (%s %s not exists (select 1 from \"%I\".\"%I\".\"%I\"\',\n"
"uncond, uself, name_part (pktb, 0), name_part (pktb, 1), name_part (pktb,2)), \' WHERE \', uwhe, \')) \\n\',\n"
"sprintf (\'signal (\'\'S1000\'\',\'\'UPDATE statement conflicted with FOREIGN KEY constraint referencing table \"%s\"\'\', \'\'SR307\'\');\\n\', pk_table_name));\n"
"vars := \'\'; whe := \'\'; uwhe := \'\'; ncond := \'\'; uncond := \'\';\n"
"to_drop := 0;\n"
"}\n"
"\n"
"if (to_drop = 1)\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_TRIGGERS where name_part (T_NAME, 2) = concat (upper (trig_pref), \'_FK_CHECK_UPDATE\')))\n"
"{\n"
"stmt := concat (sprintf (\'DROP TRIGGER \"%I\".\"%I\".\', name_part (fktb, 0), name_part (fktb, 1)), upper (trig_pref), \'_FK_CHECK_UPDATE\');\n"
"DB.DBA.execstr (stmt);\n"
"stmt := concat (sprintf (\'DROP TRIGGER \"%I\".\"%I\".\', name_part (fktb, 0), name_part (fktb, 1)), upper (trig_pref), \'_FK_CHECK_INSERT\');\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"return;\n"
"}\n"
"\n"
"stmt := concat (\'CREATE TRIGGER \', upper (trig_pref),\n"
"sprintf (\'_FK_CHECK_INSERT before insert on \"%I\".\"%I\".\"%I\" order 99 referencing new as N { if (\'\'ON\'\' <> registry_get (\'\'FK_UNIQUE_CHEK\'\')) return;\\n\',\n"
"name_part (fktb, 0), name_part (fktb, 1), name_part (fktb,2)), ins, \'\\n}\\n\');\n"
"DB.DBA.execstr1 (stmt);\n"
"stmt := concat (\'CREATE TRIGGER \', upper (trig_pref),\n"
"sprintf (\'_FK_CHECK_UPDATE before update on \"%I\".\"%I\".\"%I\" order 99 REFERENCING OLD AS O, NEW AS N { if (\'\'ON\'\' <> registry_get (\'\'FK_UNIQUE_CHEK\'\')) return;\\n\',\n"
"name_part (fktb, 0), name_part (fktb, 1), name_part (fktb,2)), upd, \'\\n}\\n\');\n"
"DB.DBA.execstr1 (stmt);\n"
"}\n"
"--src system.sql:1976\n";

static const char *proc42 = 
"create procedure DB.DBA.col_check (in tb varchar, in col varchar)\n"
"{\n"
"if (not isstring (tb) or not isstring (col))\n"
"signal (\'22023\', \'Function check_col needs string as argument\', \'SR303\');\n"
"declare ret varchar;\n"
"declare c cursor for select \"COLUMN\" from DB.DBA.SYS_COLS\n"
"where 0 = casemode_strcmp (\"TABLE\", tb) and 0 = casemode_strcmp (\"COLUMN\", col);\n"
"whenever not found goto err;\n"
"open c (prefetch 1);\n"
"fetch c into ret;\n"
"close c;\n"
"return ret;\n"
"err:;\n"
"close c;\n"
"signal (\'42S22\', sprintf (\'The column \"%s\" is not defined in the given table\', col), \'SR084\');\n"
"}\n"
"--src system.sql:2089\n";

static const char *proc43 = 
"create procedure DB.DBA.col_of_type (in tb varchar, in col varchar, in type_needed int)\n"
"{\n"
"if (not isstring (tb) or not isstring (col))\n"
"return 0;\n"
"declare ret, _col_dtp int;\n"
"ret := 0;\n"
"declare c cursor for select COL_DTP from DB.DBA.SYS_COLS\n"
"where 0 = casemode_strcmp (\"TABLE\", tb) and 0 = casemode_strcmp (\"COLUMN\", col);\n"
"whenever not found goto nf;\n"
"open c (prefetch 1);\n"
"fetch c into _col_dtp;\n"
"if (_col_dtp = type_needed)\n"
"ret := 1;\n"
"nf:;\n"
"close c;\n"
"return ret;\n"
"}\n"
"--src system.sql:2107\n";

static const char *other2 = 
"charset_define (\'MIK\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x410\\x411\\x412\\x413\\x414\\x415\\x416\\x417\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x420\\x421\\x422\\x423\\x424\\x425\\x426\\x427\\x428\\x429\\x42A\\x42B\\x42C\\x42D\\x42E\\x42F\\x430\\x431\\x432\\x433\\x434\\x435\\x436\\x437\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x440\\x441\\x442\\x443\\x444\\x445\\x446\\x447\\x448\\x449\\x44A\\x44B\\x44C\\x44D\\x44E\\x44F\\x2514\\x2534\\x252C\\x251C\\x2500\\x253C\\x2563\\x2551\\x255A\\x2554\\x2569\\x2566\\x2560\\x2550\\x256C\\x2510\\x2591\\x2592\\x2593\\x2502\\x2524\\x2116\\xA7\\x2557\\x255D\\x2518\\x250C\\x2588\\x2584\\x258C\\x2590\\x2580\\x3B1\\x3B2\\x393\\x3C0\\x3A3\\x3C3\\x3BC\\x3C4\\x3A6\\x398\\x3A9\\x3B4\\x221E\\x2205\\x2208\\x2229\\x2261\\xB1\\x2265\\x2264\\x2320\\x2321\\xF7\\x2248\\xB0\\x2219\\xB7\\x221A\\x207F\\xB2\\x25A0\\xA0\', vector (\'999\', \'CP999\'))\n";
static const char *other3 = 
"charset_define (\'WINDOWS-1250\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x20AC\\x81\\x201A\\x83\\x201E\\x2026\\x2020\\x2021\\x88\\x2030\\x160\\x2039\\x15A\\x164\\x17D\\x179\\x90\\x2018\\x2019\\x201C\\x201D\\x2022\\x2013\\x2014\\x98\\x2122\\x161\\x203A\\x15B\\x165\\x17E\\x17A\\xA0\\x2C7\\x2D8\\x141\\xA4\\x104\\xA6\\xA7\\xA8\\xA9\\x15E\\xAB\\xAC\\xAD\\xAE\\x17B\\xB0\\xB1\\x2DB\\x142\\xB4\\xB5\\xB6\\xB7\\xB8\\x105\\x15F\\xBB\\x13D\\x2DD\\x13E\\x17C\\x154\\xC1\\xC2\\x102\\xC4\\x139\\x106\\xC7\\x10C\\xC9\\x118\\xCB\\x11A\\xCD\\xCE\\x10E\\x110\\x143\\x147\\xD3\\xD4\\x150\\xD6\\xD7\\x158\\x16E\\xDA\\x170\\xDC\\xDD\\x162\\xDF\\x155\\xE1\\xE2\\x103\\xE4\\x13A\\x107\\xE7\\x10D\\xE9\\x119\\xEB\\x11B\\xED\\xEE\\x10F\\x111\\x144\\x148\\xF3\\xF4\\x151\\xF6\\xF7\\x159\\x16F\\xFA\\x171\\xFC\\xFD\\x163\\x2D9\', vector (\'CP1250\', \'MS-EE\'))\n";
static const char *other4 = 
"charset_define (\'WINDOWS-1251\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x402\\x403\\x201A\\x453\\x201E\\x2026\\x2020\\x2021\\x20AC\\x2030\\x409\\x2039\\x40A\\x40C\\x40B\\x40F\\x452\\x2018\\x2019\\x201C\\x201D\\x2022\\x2013\\x2014\\x98\\x2122\\x459\\x203A\\x45A\\x45C\\x45B\\x45F\\xA0\\x40E\\x45E\\x408\\xA4\\x490\\xA6\\xA7\\x401\\xA9\\x404\\xAB\\xAC\\xAD\\xAE\\x407\\xB0\\xB1\\x406\\x456\\x491\\xB5\\xB6\\xB7\\x451\\x2116\\x454\\xBB\\x458\\x405\\x455\\x457\\x410\\x411\\x412\\x413\\x414\\x415\\x416\\x417\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x420\\x421\\x422\\x423\\x424\\x425\\x426\\x427\\x428\\x429\\x42A\\x42B\\x42C\\x42D\\x42E\\x42F\\x430\\x431\\x432\\x433\\x434\\x435\\x436\\x437\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x440\\x441\\x442\\x443\\x444\\x445\\x446\\x447\\x448\\x449\\x44A\\x44B\\x44C\\x44D\\x44E\\x44F\', vector (\'CP1251\', \'MS-CYRL\'))\n";
static const char *other5 = 
"charset_define (\'WINDOWS-1252\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x20AC\\x81\\x201A\\x192\\x201E\\x2026\\x2020\\x2021\\x2C6\\x2030\\x160\\x2039\\x152\\x8D\\x17D\\x8F\\x90\\x2018\\x2019\\x201C\\x201D\\x2022\\x2013\\x2014\\x2DC\\x2122\\x161\\x203A\\x153\\x9D\\x17E\\x178\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\xDE\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\xF0\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', vector (\'CP1252\', \'MS-ANSI\'))\n";
static const char *other6 = 
"charset_define (\'WINDOWS-1257\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x20AC\\x81\\x201A\\x83\\x201E\\x2026\\x2020\\x2021\\x88\\x2030\\x8A\\x2039\\x8C\\xA8\\x2C7\\xB8\\x90\\x2018\\x2019\\x201C\\x201D\\x2022\\x2013\\x2014\\x98\\x2122\\x9A\\x203A\\x9C\\xAF\\x2DB\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xD8\\xA9\\x156\\xAB\\xAC\\xAD\\xAE\\xC6\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xF8\\xB9\\x157\\xBB\\xBC\\xBD\\xBE\\xE6\\x104\\x12E\\x100\\x106\\xC4\\xC5\\x118\\x112\\x10C\\xC9\\x179\\x116\\x122\\x136\\x12A\\x13B\\x160\\x143\\x145\\xD3\\x14C\\xD5\\xD6\\xD7\\x172\\x141\\x15A\\x16A\\xDC\\x17B\\x17D\\xDF\\x105\\x12F\\x101\\x107\\xE4\\xE5\\x119\\x113\\x10D\\xE9\\x17A\\x117\\x123\\x137\\x12B\\x13C\\x161\\x144\\x146\\xF3\\x14D\\xF5\\xF6\\xF7\\x173\\x142\\x15B\\x16B\\xFC\\x17C\\x17E\\x2D9\', vector (\'CP1257\', \'WINBALTRIM\'))\n";
static const char *other7 = 
"charset_define (\'IBM437\', N\'\\x263A\\x263B\\x2665\\x2666\\x2663\\x2660\\x2022\\x25D8\\x25E6\\x25D9\\x2642\\x2640\\x266A\\x266B\\x263C\\x25B6\\x25C0\\x2195\\x203C\\xB6\\xA7\\x25AC\\x21A8\\x2191\\x2193\\x2192\\x2190\\x2310\\x2194\\x25B2\\x25BC\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\xC7\\xFC\\xE9\\xE2\\xE4\\xE0\\xE5\\xE7\\xEA\\xEB\\xE8\\xEF\\xEE\\xEC\\xC4\\xC5\\xC9\\xE6\\xC6\\xF4\\xF6\\xF2\\xFB\\xF9\\xFF\\xD6\\xDC\\xA2\\xA3\\xA5\\x20A7\\x192\\xE1\\xED\\xF3\\xFA\\xF1\\xD1\\xAA\\xBA\\xBF\\x2310\\xAC\\xBD\\xBC\\xA1\\xAB\\xBB\\x2591\\x2592\\x2593\\x2502\\x2524\\x2561\\x2562\\x2556\\x2555\\x2563\\x2551\\x2557\\x255D\\x255C\\x255B\\x2510\\x2514\\x2534\\x252C\\x251C\\x2500\\x253C\\x255E\\x255F\\x255A\\x2554\\x2569\\x2566\\x2560\\x2550\\x256C\\x2567\\x2568\\x2564\\x2565\\x2559\\x2558\\x2552\\x2553\\x256B\\x256A\\x2518\\x250C\\x2588\\x2584\\x258C\\x2590\\x2580\\x3B1\\x3B2\\x393\\x3C0\\x3A3\\x3C3\\x3BC\\x3C4\\x3A6\\x398\\x3A9\\x3B4\\x221E\\x2205\\x2208\\x2229\\x2261\\xB1\\x2265\\x2264\\x2320\\x2321\\xF7\\x2248\\xB0\\x2219\\xB7\\x221A\\x207F\\xB2\\x25A0\\xA0\', vector (\'CP437\', \'437\', \'CSPC8CODEPAGE437\'))\n";
static const char *other8 = 
"charset_define (\'IBM850\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\xC7\\xFC\\xE9\\xE2\\xE4\\xE0\\xE5\\xE7\\xEA\\xEB\\xE8\\xEF\\xEE\\xEC\\xC4\\xC5\\xC9\\xE6\\xC6\\xF4\\xF6\\xF2\\xFB\\xF9\\xFF\\xD6\\xDC\\xF8\\xA3\\xD8\\xD7\\x192\\xE1\\xED\\xF3\\xFA\\xF1\\xD1\\xAA\\xBA\\xBF\\xAE\\xAC\\xBD\\xBC\\xA1\\xAB\\xBB\\x2591\\x2592\\x2593\\x2502\\x2524\\xC1\\xC2\\xC0\\xA9\\x2563\\x2551\\x2557\\x255D\\xA2\\xA5\\x2510\\x2514\\x2534\\x252C\\x251C\\x2500\\x253C\\xE3\\xC3\\x255A\\x2554\\x2569\\x2566\\x2560\\x2550\\x256C\\xA4\\xF0\\xD0\\xCA\\xCB\\xC8\\x131\\xCD\\xCE\\xCF\\x2518\\x250C\\x2588\\x2584\\xA6\\xCC\\x2580\\xD3\\xDF\\xD4\\xD2\\xF5\\xD5\\xB5\\xFE\\xDE\\xDA\\xDB\\xD9\\xFD\\xDD\\xAF\\xB4\\xAD\\xB1\\x2017\\xBE\\xB6\\xA7\\xF7\\xB8\\xB0\\xA8\\xB7\\xB9\\xB3\\xB2\\x25A0\\xA0\', vector (\'CP850\', \'850\', \'CSPC850MULTILINGUAL\'))\n";
static const char *other9 = 
"charset_define (\'IBM852\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\xC7\\xFC\\xE9\\xE2\\xE4\\x16F\\x107\\xE7\\x142\\xEB\\x150\\x151\\xEE\\x179\\xC4\\x106\\xC9\\x139\\x13A\\xF4\\xF6\\x13D\\x13E\\x15A\\x15B\\xD6\\xDC\\x164\\x165\\x141\\xD7\\x10D\\xE1\\xED\\xF3\\xFA\\x104\\x105\\x17D\\x17E\\x118\\x119\\xAC\\x17A\\x10C\\x15F\\xAB\\xBB\\x2591\\x2592\\x2593\\x2502\\x2524\\xC1\\xC2\\x11A\\x15E\\x2563\\x2551\\x2557\\x255D\\x17B\\x17C\\x2510\\x2514\\x2534\\x252C\\x251C\\x2500\\x253C\\x102\\x103\\x255A\\x2554\\x2569\\x2566\\x2560\\x2550\\x256C\\xA4\\x111\\x110\\x10E\\xCB\\x10F\\x147\\xCD\\xCE\\x11B\\x2518\\x250C\\x2588\\x2584\\x162\\x16E\\x2580\\xD3\\xDF\\xD4\\x143\\x144\\x148\\x160\\x161\\x154\\xDA\\x155\\x170\\xFD\\xDD\\x163\\xB4\\xAD\\x2DD\\x2DB\\x2C7\\x2D8\\xA7\\xF7\\xB8\\xB0\\xA8\\x2D9\\x171\\x158\\x159\\x25A0\\xA0\', vector (\'CP852\', \'852\', \'CSPCP852\'))\n";
static const char *other10 = 
"charset_define (\'IBM855\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x452\\x402\\x453\\x403\\x451\\x401\\x454\\x404\\x455\\x405\\x456\\x406\\x457\\x407\\x458\\x408\\x459\\x409\\x45A\\x40A\\x45B\\x40B\\x45C\\x40C\\x45E\\x40E\\x45F\\x40F\\x44E\\x42E\\x44A\\x42A\\x430\\x410\\x431\\x411\\x446\\x426\\x434\\x414\\x435\\x415\\x444\\x424\\x433\\x413\\xAB\\xBB\\x2591\\x2592\\x2593\\x2502\\x2524\\x445\\x425\\x438\\x418\\x2563\\x2551\\x2557\\x255D\\x439\\x419\\x2510\\x2514\\x2534\\x252C\\x251C\\x2500\\x253C\\x43A\\x41A\\x255A\\x2554\\x2569\\x2566\\x2560\\x2550\\x256C\\xA4\\x43B\\x41B\\x43C\\x41C\\x43D\\x41D\\x43E\\x41E\\x43F\\x2518\\x250C\\x2588\\x2584\\x41F\\x44F\\x2580\\x42F\\x440\\x420\\x441\\x421\\x442\\x422\\x443\\x423\\x436\\x416\\x432\\x412\\x44C\\x42C\\x2116\\xAD\\x44B\\x42B\\x437\\x417\\x448\\x428\\x44D\\x42D\\x449\\x429\\x447\\x427\\xA7\\x25A0\\xA0\', vector (\'CP855\', \'855\', \'CSIBM855\'))\n";
static const char *other11 = 
"charset_define (\'IBM866\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x410\\x411\\x412\\x413\\x414\\x415\\x416\\x417\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x420\\x421\\x422\\x423\\x424\\x425\\x426\\x427\\x428\\x429\\x42A\\x42B\\x42C\\x42D\\x42E\\x42F\\x430\\x431\\x432\\x433\\x434\\x435\\x436\\x437\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x2591\\x2592\\x2593\\x2502\\x2524\\x2561\\x2562\\x2556\\x2555\\x2563\\x2551\\x2557\\x255D\\x255C\\x255B\\x2510\\x2514\\x2534\\x252C\\x251C\\x2500\\x253C\\x255E\\x255F\\x255A\\x2554\\x2569\\x2566\\x2560\\x2550\\x256C\\x2567\\x2568\\x2564\\x2565\\x2559\\x2558\\x2552\\x2553\\x256B\\x256A\\x2518\\x250C\\x2588\\x2584\\x258C\\x2590\\x2580\\x440\\x441\\x442\\x443\\x444\\x445\\x446\\x447\\x448\\x449\\x44A\\x44B\\x44C\\x44D\\x44E\\x44F\\x401\\x451\\x404\\x454\\x407\\x457\\x40E\\x45E\\xB0\\x2022\\xB7\\x221A\\x2116\\xA4\\x25A0\\xA0\', vector (\'CP866\', \'866\', \'CSIBM866\'))\n";
static const char *other12 = 
"charset_define (\'IBM874\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x20AC\\x81\\x82\\x83\\x84\\x2026\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x2018\\x2019\\x201C\\x201D\\x2022\\x2013\\x2014\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xE01\\xE02\\xE03\\xE04\\xE05\\xE06\\xE07\\xE08\\xE09\\xE0A\\xE0B\\xE0C\\xE0D\\xE0E\\xE0F\\xE10\\xE11\\xE12\\xE13\\xE14\\xE15\\xE16\\xE17\\xE18\\xE19\\xE1A\\xE1B\\xE1C\\xE1D\\xE1E\\xE1F\\xE20\\xE21\\xE22\\xE23\\xE24\\xE25\\xE26\\xE27\\xE28\\xE29\\xE2A\\xE2B\\xE2C\\xE2D\\xE2E\\xE2F\\xE30\\xE31\\xE32\\xE33\\xE34\\xE35\\xE36\\xE37\\xE38\\xE39\\xE3A\\xDB\\xDC\\xDD\\xDE\\xE3F\\xE40\\xE41\\xE42\\xE43\\xE44\\xE45\\xE46\\xE47\\xE48\\xE49\\xE4A\\xE4B\\xE4C\\xE4D\\xE4E\\xE4F\\xE50\\xE51\\xE52\\xE53\\xE54\\xE55\\xE56\\xE57\\xE58\\xE59\\xE5A\\xE5B\\xFC\\xFD\\xFE\\xFF\', vector (\'CP874\', \'874\'))\n";
static const char *other13 = 
"charset_define (\'GOST19768-87\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\xA4\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x401\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\x410\\x411\\x412\\x413\\x414\\x415\\x416\\x417\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x420\\x421\\x422\\x423\\x424\\x425\\x426\\x427\\x428\\x429\\x42A\\x42B\\x42C\\x42D\\x42E\\x42F\\x430\\x431\\x432\\x433\\x434\\x435\\x436\\x437\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x440\\x441\\x442\\x443\\x444\\x445\\x446\\x447\\x448\\x449\\x44A\\x44B\\x44C\\x44D\\x44E\\x44F\\xF0\\x451\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', NULL)\n";
static const char *other14 = 
"charset_define (\'ISO-8859-1\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\xDE\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\xF0\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', vector (\'ISO_8859-1\', \'ISO_8859-1:1987\', \'ISO-IR-100\', \'LATIN1\', \'L1\', \'IBM819\', \'CP819\', \'819\', \'CSISOLATIN1\'))\n";
static const char *other15 = 
"charset_define (\'ISO-8859-10\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x104\\x112\\x122\\x12A\\x128\\x136\\xA7\\x13B\\x110\\x160\\x166\\x17D\\xAD\\x16A\\x14A\\xB0\\x105\\x113\\x123\\x12B\\x129\\x137\\xB7\\x13C\\x111\\x161\\x167\\x17E\\x2015\\x16B\\x14B\\x100\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\x12E\\x10C\\xC9\\x118\\xCB\\x116\\xCD\\xCE\\xCF\\xD0\\x145\\x14C\\xD3\\xD4\\xD5\\xD6\\x168\\xD8\\x172\\xDA\\xDB\\xDC\\xDD\\xDE\\xDF\\x101\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\x12F\\x10D\\xE9\\x119\\xEB\\x117\\xED\\xEE\\xEF\\xF0\\x146\\x14D\\xF3\\xF4\\xF5\\xF6\\x169\\xF8\\x173\\xFA\\xFB\\xFC\\xFD\\xFE\\x138\', vector (\'ISO_8859-10\', \'ISO_8859-10:1992\', \'ISO-IR-157\', \'L6\', \'LATIN6\', \'CSISOLATIN6\'))\n";
static const char *other16 = 
"charset_define (\'ISO-8859-11\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xE01\\xE02\\xE03\\xE04\\xE05\\xE06\\xE07\\xE08\\xE09\\xE0A\\xE0B\\xE0C\\xE0D\\xE0E\\xE0F\\xE10\\xE11\\xE12\\xE13\\xE14\\xE15\\xE16\\xE17\\xE18\\xE19\\xE1A\\xE1B\\xE1C\\xE1D\\xE1E\\xE1F\\xE20\\xE21\\xE22\\xE23\\xE24\\xE25\\xE26\\xE27\\xE28\\xE29\\xE2A\\xE2B\\xE2C\\xE2D\\xE2E\\xE2F\\xE30\\xE31\\xE32\\xE33\\xE34\\xE35\\xE36\\xE37\\xE38\\xE39\\xE3A\\xDB\\xDC\\xDD\\xDE\\xE3F\\xE40\\xE41\\xE42\\xE43\\xE44\\xE45\\xE46\\xE47\\xE48\\xE49\\xE4A\\xE4B\\xE4C\\xE4D\\xE4E\\xE4F\\xE50\\xE51\\xE52\\xE53\\xE54\\xE55\\xE56\\xE57\\xE58\\xE59\\xE5A\\xE5B\\xFC\\xFD\\xFE\\xFF\', vector (\'ISO_8859-11\'))\n";
static const char *other17 = 
"charset_define (\'ISO-8859-13\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x201D\\xA2\\xA3\\xA4\\x201E\\xA6\\xA7\\xD8\\xA9\\x156\\xAB\\xAC\\xAD\\xAE\\xC6\\xB0\\xB1\\xB2\\xB3\\x201C\\xB5\\xB6\\xB7\\xF8\\xB9\\x157\\xBB\\xBC\\xBD\\xBE\\xE6\\x104\\x12E\\x100\\x106\\xC4\\xC5\\x118\\x112\\x10C\\xC9\\x179\\x116\\x122\\x136\\x12A\\x13B\\x160\\x143\\x145\\xD3\\x14C\\xD5\\xD6\\xD7\\x172\\x141\\x15A\\x16A\\xDC\\x17B\\x17D\\xDF\\x105\\x12F\\x101\\x107\\xE4\\xE5\\x119\\x113\\x10D\\xE9\\x17A\\x117\\x123\\x137\\x12B\\x13C\\x161\\x144\\x146\\xF3\\x14D\\xF5\\xF6\\xF7\\x173\\x142\\x15B\\x16B\\xFC\\x17C\\x17E\\x2019\', vector (\'ISO_8859-13\'))\n";
static const char *other18 = 
"charset_define (\'ISO-8859-14\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x1E02\\x1E03\\xA3\\x10A\\x10B\\x1E0A\\xA7\\x1E80\\xA9\\x1E82\\x1E0B\\x1EF2\\xAD\\xAE\\x178\\x1E1E\\x1E1F\\x120\\x121\\x1E40\\x1E41\\xB6\\x1E56\\x1E81\\x1E57\\x1E83\\x1E60\\x1EF3\\x1E84\\x1E85\\x1E61\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\x174\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\x1E6A\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\x176\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\x175\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\x1E6B\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\x177\\xFF\', vector (\'ISO_8859-14\', \'ISO_8859-14:1998\', \'LATIN8\', \'L8\', \'ISO-CELTIC\', \'ISO-IR-199\'))\n";
static const char *other19 = 
"charset_define (\'ISO-8859-15\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\x20AC\\xA5\\x160\\xA7\\x161\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\x17D\\xB5\\xB6\\xB7\\x17E\\xB9\\xBA\\xBB\\x152\\x153\\x178\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\xDE\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\xF0\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', vector (\'ISO_8859-15\'))\n";
static const char *other20 = 
"charset_define (\'ISO-8859-2\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x104\\x2D8\\x141\\xA4\\x13D\\x15A\\xA7\\xA8\\x160\\x15E\\x164\\x179\\xAD\\x17D\\x17B\\xB0\\x105\\x2DB\\x142\\xB4\\x13E\\x15B\\x2C7\\xB8\\x161\\x15F\\x165\\x17A\\x2DD\\x17E\\x17C\\x154\\xC1\\xC2\\x102\\xC4\\x139\\x106\\xC7\\x10C\\xC9\\x118\\xCB\\x11A\\xCD\\xCE\\x10E\\x110\\x143\\x147\\xD3\\xD4\\x150\\xD6\\xD7\\x158\\x16E\\xDA\\x170\\xDC\\xDD\\x162\\xDF\\x155\\xE1\\xE2\\x103\\xE4\\x13A\\x107\\xE7\\x10D\\xE9\\x119\\xEB\\x11B\\xED\\xEE\\x10F\\x111\\x144\\x148\\xF3\\xF4\\x151\\xF6\\xF7\\x159\\x16F\\xFA\\x171\\xFC\\xFD\\x163\\x2D9\', vector (\'ISO_8859-2\', \'ISO_8859-2:1987\', \'ISO-IR-101\', \'LATIN2\', \'L2\', \'CSISOLATIN2\'))\n";
static const char *other21 = 
"charset_define (\'ISO-8859-3\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x126\\x2D8\\xA3\\xA4\\xA5\\x124\\xA7\\xA8\\x130\\x15E\\x11E\\x134\\xAD\\xAE\\x17B\\xB0\\x127\\xB2\\xB3\\xB4\\xB5\\x125\\xB7\\xB8\\x131\\x15F\\x11F\\x135\\xBD\\xBE\\x17C\\xC0\\xC1\\xC2\\xC3\\xC4\\x10A\\x108\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\x120\\xD6\\xD7\\x11C\\xD9\\xDA\\xDB\\xDC\\x16C\\x15C\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\x10B\\x109\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\xF0\\xF1\\xF2\\xF3\\xF4\\x121\\xF6\\xF7\\x11D\\xF9\\xFA\\xFB\\xFC\\x16D\\x15D\\x2D9\', vector (\'ISO_8859-3\', \'ISO_8859-3:1988\', \'ISO-IR-109\', \'LATIN3\', \'L3\', \'CSISOLATIN3\'))\n";
static const char *other22 = 
"charset_define (\'ISO-8859-4\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x104\\x138\\x156\\xA4\\x128\\x13B\\xA7\\xA8\\x160\\x112\\x122\\x166\\xAD\\x17D\\xAF\\xB0\\x105\\x2DB\\x157\\xB4\\x129\\x13C\\x2C7\\xB8\\x161\\x113\\x123\\x167\\x14A\\x17E\\x14B\\x100\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\x12E\\x10C\\xC9\\x118\\xCB\\x116\\xCD\\xCE\\x12A\\x110\\x145\\x14C\\x136\\xD4\\xD5\\xD6\\xD7\\xD8\\x172\\xDA\\xDB\\xDC\\x168\\x16A\\xDF\\x101\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\x12F\\x10D\\xE9\\x119\\xEB\\x117\\xED\\xEE\\x12B\\x111\\x146\\x14D\\x137\\xF4\\xF5\\xF6\\xF7\\xF8\\x173\\xFA\\xFB\\xFC\\x169\\x16B\\x2D9\', vector (\'ISO_8859-4\', \'ISO-IR-110\', \'LATIN4\', \'L4\', \'CSISOLATIN4\', \'ISO_8859-4:1988\'))\n";
static const char *other23 = 
"charset_define (\'ISO-8859-5\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x401\\x402\\x403\\x404\\x405\\x406\\x407\\x408\\x409\\x40A\\x40B\\x40C\\xAD\\x40E\\x40F\\x410\\x411\\x412\\x413\\x414\\x415\\x416\\x417\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x420\\x421\\x422\\x423\\x424\\x425\\x426\\x427\\x428\\x429\\x42A\\x42B\\x42C\\x42D\\x42E\\x42F\\x430\\x431\\x432\\x433\\x434\\x435\\x436\\x437\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x440\\x441\\x442\\x443\\x444\\x445\\x446\\x447\\x448\\x449\\x44A\\x44B\\x44C\\x44D\\x44E\\x44F\\x2116\\x451\\x452\\x453\\x454\\x455\\x456\\x457\\x458\\x459\\x45A\\x45B\\x45C\\xA7\\x45E\\x45F\', vector (\'ISO_8859-5\', \'CYRILLIC\', \'ISO-IR-144\', \'CSISOLATINCYRILLIC\', \'ISO_8859-5:1988\'))\n";
static const char *other24 = 
"charset_define (\'ISO-8859-6\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\x60C\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\x61B\\xBC\\xBD\\xBE\\x61F\\xC0\\x621\\x622\\x623\\x624\\x625\\x626\\x627\\x628\\x629\\x62A\\x62B\\x62C\\x62D\\x62E\\x62F\\x630\\x631\\x632\\x633\\x634\\x635\\x636\\x637\\x638\\x639\\x63A\\xDB\\xDC\\xDD\\xDE\\xDF\\x640\\x641\\x642\\x643\\x644\\x645\\x646\\x647\\x648\\x649\\x64A\\x64B\\x64C\\x64D\\x64E\\x64F\\x650\\x651\\x652\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', vector (\'ISO_8859-6\', \'ARABIC\', \'ISO-IR-127\', \'ECMA-114\', \'ASMO-708\', \'CSISOLATINARABIC\', \'ISO_8859-6:1987\'))\n";
static const char *other25 = 
"charset_define (\'ISO-8859-7\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x2BD\\x2BC\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\x2015\\xB0\\xB1\\xB2\\xB3\\x384\\x385\\x386\\xB7\\x388\\x389\\x38A\\xBB\\x38C\\xBD\\x38E\\x38F\\x390\\x391\\x392\\x393\\x394\\x395\\x396\\x397\\x398\\x399\\x39A\\x39B\\x39C\\x39D\\x39E\\x39F\\x3A0\\x3A1\\xD2\\x3A3\\x3A4\\x3A5\\x3A6\\x3A7\\x3A8\\x3A9\\x3AA\\x3AB\\x3AC\\x3AD\\x3AE\\x3AF\\x3B0\\x3B1\\x3B2\\x3B3\\x3B4\\x3B5\\x3B6\\x3B7\\x3B8\\x3B9\\x3BA\\x3BB\\x3BC\\x3BD\\x3BE\\x3BF\\x3C0\\x3C1\\x3C2\\x3C3\\x3C4\\x3C5\\x3C6\\x3C7\\x3C8\\x3C9\\x3CA\\x3CB\\x3CC\\x3CD\\x3CE\\xFF\', vector (\'ISO_8859-7\', \'ISO_8859-7:1987\', \'ISO-IR-126\', \'ELOT_928\', \'ECMA-118\', \'GREEK\', \'GREEK8\', \'CSISOLATINGREEK\'))\n";
static const char *other26 = 
"charset_define (\'ISO-8859-8\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xD7\\xAB\\xAC\\xAD\\xAE\\x203E\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xF7\\xBB\\xBC\\xBD\\xBE\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\xDE\\x2017\\x5D0\\x5D1\\x5D2\\x5D3\\x5D4\\x5D5\\x5D6\\x5D7\\x5D8\\x5D9\\x5DA\\x5DB\\x5DC\\x5DD\\x5DE\\x5DF\\x5E0\\x5E1\\x5E2\\x5E3\\x5E4\\x5E5\\x5E6\\x5E7\\x5E8\\x5E9\\x5EA\\xFB\\xFC\\xFD\\xFE\\xFF\', vector (\'ISO_8859-8\', \'ISO_8859-8:1988\', \'ISO-IR-138\', \'HEBREW\', \'CSISOLATINHEBREW\'))\n";
static const char *other27 = 
"charset_define (\'ISO-8859-9\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\x11E\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\x130\\x15E\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\x11F\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\x131\\x15F\\xFF\', vector (\'ISO_8859-9\', \'ISO_8859-9:1989\', \'LATIN5\', \'L5\', \'ISO-IR-148\', \'LATIN5\', \'L5\', \'CSISOLATIN5\'))\n";
static const char *other28 = 
"charset_define (\'KOI-0\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\xA4\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\xDE\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\xF0\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', NULL)\n";
static const char *other29 = 
"charset_define (\'KOI-7\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\xA4\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\xC0\\xC1\\xC2\\xC3\\xC4\\xC5\\xC6\\xC7\\xC8\\xC9\\xCA\\xCB\\xCC\\xCD\\xCE\\xCF\\xD0\\xD1\\xD2\\xD3\\xD4\\xD5\\xD6\\xD7\\xD8\\xD9\\xDA\\xDB\\xDC\\xDD\\xDE\\xDF\\xE0\\xE1\\xE2\\xE3\\xE4\\xE5\\xE6\\xE7\\xE8\\xE9\\xEA\\xEB\\xEC\\xED\\xEE\\xEF\\xF0\\xF1\\xF2\\xF3\\xF4\\xF5\\xF6\\xF7\\xF8\\xF9\\xFA\\xFB\\xFC\\xFD\\xFE\\xFF\', NULL)\n";
static const char *other30 = 
"charset_define (\'KOI8-A\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\xA4\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\xA3\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\xB3\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\x44E\\x430\\x431\\x446\\x434\\x435\\x444\\x433\\x445\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x44F\\x440\\x441\\x442\\x443\\x436\\x432\\x44C\\x44B\\x437\\x448\\x44D\\x449\\x447\\x44A\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\xFF\', NULL)\n";
static const char *other31 = 
"charset_define (\'KOI8-B\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\xA1\\xA2\\x451\\xA4\\xA5\\xA6\\xA7\\xA8\\xA9\\xAA\\xAB\\xAC\\xAD\\xAE\\xAF\\xB0\\xB1\\xB2\\x401\\xB4\\xB5\\xB6\\xB7\\xB8\\xB9\\xBA\\xBB\\xBC\\xBD\\xBE\\xBF\\x44E\\x430\\x431\\x446\\x434\\x435\\x444\\x433\\x445\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x44F\\x440\\x441\\x442\\x443\\x436\\x432\\x44C\\x44B\\x437\\x448\\x44D\\x449\\x447\\x44A\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\x42A\', NULL)\n";
static const char *other32 = 
"charset_define (\'KOI8-E\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x80\\x81\\x82\\x83\\x84\\x85\\x86\\x87\\x88\\x89\\x8A\\x8B\\x8C\\x8D\\x8E\\x8F\\x90\\x91\\x92\\x93\\x94\\x95\\x96\\x97\\x98\\x99\\x9A\\x9B\\x9C\\x9D\\x9E\\x9F\\xA0\\x452\\x453\\x451\\x454\\x455\\x456\\x457\\x458\\x459\\x45A\\x45B\\x45C\\xAD\\x45E\\x45F\\x2116\\x402\\x403\\x401\\x404\\x405\\x406\\x407\\x408\\x409\\x40A\\x40B\\x40C\\xA4\\x40E\\x40F\\x44E\\x430\\x431\\x446\\x434\\x435\\x444\\x433\\x445\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x44F\\x440\\x441\\x442\\x443\\x436\\x432\\x44C\\x44B\\x437\\x448\\x44D\\x449\\x447\\x44A\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\x42A\', NULL)\n";
static const char *other33 = 
"charset_define (\'KOI8-F\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x2500\\x2502\\x250C\\x2510\\x2514\\x2518\\x251C\\x2524\\x252C\\x2534\\x253C\\x2580\\x2584\\x2588\\x258C\\x2590\\x2591\\x2018\\x2019\\x201C\\x201D\\x2022\\x2013\\x2014\\xA9\\x2122\\xA0\\xBB\\xAE\\xAB\\xB7\\xA4\\xA0\\x452\\x453\\x451\\x454\\x455\\x456\\x457\\x458\\x459\\x45A\\x45B\\x45C\\x491\\x45E\\x45F\\x2116\\x402\\x403\\x401\\x404\\x405\\x406\\x407\\x408\\x409\\x40A\\x40B\\x40C\\x490\\x40E\\x40F\\x44E\\x430\\x431\\x446\\x434\\x435\\x444\\x433\\x445\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x44F\\x440\\x441\\x442\\x443\\x436\\x432\\x44C\\x44B\\x437\\x448\\x44D\\x449\\x447\\x44A\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\x42A\', NULL)\n";
static const char *other34 = 
"charset_define (\'KOI8-R\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x2500\\x2502\\x250C\\x2510\\x2514\\x2518\\x251C\\x2524\\x252C\\x2534\\x253C\\x2580\\x2584\\x2588\\x258C\\x2590\\x2591\\x2592\\x2593\\x2320\\x25A0\\x2022\\x221A\\x2248\\x2264\\x2265\\xA0\\x2321\\xB0\\xB2\\xB7\\xF7\\x2550\\x2551\\x2552\\x451\\x2553\\x2554\\x2555\\x2556\\x2557\\x2558\\x2559\\x255A\\x255B\\x255C\\x255D\\x255E\\x255F\\x2560\\x2561\\x401\\x2562\\x2563\\x2564\\x2565\\x2566\\x2567\\x2568\\x2569\\x256A\\x256B\\x256C\\xA9\\x44E\\x430\\x431\\x446\\x434\\x435\\x444\\x433\\x445\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x44F\\x440\\x441\\x442\\x443\\x436\\x432\\x44C\\x44B\\x437\\x448\\x44D\\x449\\x447\\x44A\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\x42A\', vector (\'CSKOI8R\'))\n";
static const char *other35 = 
"charset_define (\'KOI8-U\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x2500\\x2502\\x250C\\x2510\\x2514\\x2518\\x251C\\x2524\\x252C\\x2534\\x253C\\x2580\\x2584\\x2588\\x258C\\x2590\\x2591\\x2592\\x2593\\x2320\\x25A0\\x2022\\x221A\\x2248\\x2264\\x2265\\xA0\\x2321\\xB0\\xB2\\xB7\\xF7\\x2550\\x2551\\x2552\\x451\\x454\\x2554\\x456\\x457\\x2557\\x2558\\x2559\\x255A\\x255B\\x491\\x255D\\x255E\\x255F\\x2560\\x2561\\x401\\x404\\x2563\\x406\\x407\\x2566\\x2567\\x2568\\x2569\\x256A\\x490\\x256C\\xA9\\x44E\\x430\\x431\\x446\\x434\\x435\\x444\\x433\\x445\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x44F\\x440\\x441\\x442\\x443\\x436\\x432\\x44C\\x44B\\x437\\x448\\x44D\\x449\\x447\\x44A\\x42E\\x410\\x411\\x426\\x414\\x415\\x424\\x413\\x425\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x42F\\x420\\x421\\x422\\x423\\x416\\x412\\x42C\\x42B\\x417\\x428\\x42D\\x429\\x427\\x42A\', NULL)\n";
static const char *other36 = 
"charset_define (\'MAC-UKRAINIAN\', N\'\\x1\\x2\\x3\\x4\\x5\\x6\\x7\\x8\\x9\\xA\\xB\\xC\\xD\\xE\\xF\\x10\\x11\\x12\\x13\\x14\\x15\\x16\\x17\\x18\\x19\\x1A\\x1B\\x1C\\x1D\\x1E\\x1F\\x20\\x21\\x22\\x23\\x24\\x25\\x26\\x27\\x28\\x29\\x2A\\x2B\\x2C\\x2D\\x2E\\x2F\\x30\\x31\\x32\\x33\\x34\\x35\\x36\\x37\\x38\\x39\\x3A\\x3B\\x3C\\x3D\\x3E\\x3F\\x40\\x41\\x42\\x43\\x44\\x45\\x46\\x47\\x48\\x49\\x4A\\x4B\\x4C\\x4D\\x4E\\x4F\\x50\\x51\\x52\\x53\\x54\\x55\\x56\\x57\\x58\\x59\\x5A\\x5B\\x5C\\x5D\\x5E\\x5F\\x60\\x61\\x62\\x63\\x64\\x65\\x66\\x67\\x68\\x69\\x6A\\x6B\\x6C\\x6D\\x6E\\x6F\\x70\\x71\\x72\\x73\\x74\\x75\\x76\\x77\\x78\\x79\\x7A\\x7B\\x7C\\x7D\\x7E\\x7F\\x410\\x411\\x412\\x413\\x414\\x415\\x416\\x417\\x418\\x419\\x41A\\x41B\\x41C\\x41D\\x41E\\x41F\\x420\\x421\\x422\\x423\\x424\\x425\\x426\\x427\\x428\\x429\\x42A\\x42B\\x42C\\x42D\\x42E\\x42F\\x2020\\xB0\\x490\\xA3\\xA7\\x2022\\xB6\\x406\\xAE\\xA9\\x2122\\x402\\x452\\x2260\\x403\\x453\\x221E\\xB1\\x2264\\x2265\\x456\\xB5\\x491\\x408\\x404\\x454\\x407\\x457\\x409\\x459\\x40A\\x45A\\x458\\x405\\xAC\\x221A\\x192\\x2248\\x2206\\xAB\\xBB\\x2026\\xA0\\x40B\\x45B\\x40C\\x45C\\x455\\x2013\\x2014\\x201C\\x201D\\x2018\\x2019\\xF7\\x201E\\x40E\\x45E\\x40F\\x45F\\x2116\\x401\\x451\\x44F\\x430\\x431\\x432\\x433\\x434\\x435\\x436\\x437\\x438\\x439\\x43A\\x43B\\x43C\\x43D\\x43E\\x43F\\x440\\x441\\x442\\x443\\x444\\x445\\x446\\x447\\x448\\x449\\x44A\\x44B\\x44C\\x44D\\x44E\\xA4\', NULL)\n";
static const char *proc44 = 
"create procedure\n"
"scheduler_init ()\n"
"{\n"
"if (registry_get (\'__scheduler_do_now__\') = \'1\')\n"
"registry_set (\'__scheduler_do_now__\', \'c\');\n"
"else\n"
"registry_set (\'__scheduler_do_now__\', \'0\');\n"
"}\n"
"--src system.sql:2257\n";

static const char *other37 = 
"scheduler_init ()\n";
static const char *proc45 = 
" create procedure SYS_GENERATE_ALL_OPS (in col_name varchar, in col_dtp integer := 193)\n"
"{\n"
"declare func, args varchar;\n"
"func :=\n"
"case dv_type_title (col_dtp)\n"
"when \'VARCHAR\'   then \'left\'\n"
"when \'VARBINARY\' then \'left\'\n"
"when \'NVARCHAR\'  then \'left\'\n"
"else \'\'\n"
"end;\n"
"args :=\n"
"case func\n"
"when \'left\' then \', 2000\'\n"
"else \'\'\n"
"end;\n"
"return sprintf(\n"
"\' count (distinct \"%I\"), \' ||\n"
"\' %s (min (\"%I\")%s), \' ||\n"
"\' %s (max (\"%I\")%s), \' ||\n"
"\' avg (raw_length(\"%I\")), \' ||\n"
"\'count (\"%I\")\',\n"
"col_name,\n"
"func, col_name, args,\n"
"func, col_name, args,\n"
"col_name,\n"
"col_name);\n"
"}\n"
"--src system.sql:2271\n";

static const char *proc46 = 
" create procedure SYS_GENERATE_ALL_VARS (in col_name varchar, in rate varchar:=null, in n_dist_rate varchar:=null )\n"
"{\n"
"if (rate is null)\n"
"{\n"
"return sprintf (\' n_dist_%I, min_%I, max_%I, avg_len_%I, vals_%I\', col_name, col_name, col_name, col_name, col_name);\n"
"}\n"
"else\n"
"{\n"
"if (n_dist_rate is null)\n"
"{\n"
"return sprintf (\' n_dist_%I, min_%I, max_%I, avg_len_%I, vals_%I*%s\', col_name, col_name, col_name, col_name, col_name, rate);\n"
"}\n"
"else\n"
"{\n"
"return sprintf (\' n_dist_%I*%s, min_%I, max_%I, avg_len_%I, vals_%I*%s\', col_name, n_dist_rate, col_name, col_name, col_name, col_name, rate);\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:2302\n";

static const char *tbl2 = 
"create table SYS_STAT_VDB_MAPPERS (\n"
"SVDM_TYPE varchar,\n"
"SVDM_PROC varchar not null,\n"
"SVDM_DBMS_NAME_MASK varchar not null,\n"
"SVDM_DBMS_VER_MASK varchar not null,\n"
"primary key (SVDM_TYPE, SVDM_DBMS_NAME_MASK, SVDM_DBMS_VER_MASK))\n";

static const char *other38 = 
" insert soft SYS_STAT_VDB_MAPPERS\n"
"(SVDM_TYPE,\n"
"SVDM_PROC,\n"
"SVDM_DBMS_NAME_MASK,\n"
"SVDM_DBMS_VER_MASK)\n"
"values\n"
"(\'SYS_COL_STAT\',\n"
"\'DB.DBA.__ORACLE_SYS_COL_STAT\',\n"
"\'%ORACLE%\',\n"
"\'%\')\n";
static const char *other39 = 
" insert soft SYS_STAT_VDB_MAPPERS\n"
"(SVDM_TYPE,\n"
"SVDM_PROC,\n"
"SVDM_DBMS_NAME_MASK,\n"
"SVDM_DBMS_VER_MASK)\n"
"values\n"
"(\'SYS_COL_STAT\',\n"
"\'DB.DBA.__VIRTUOSO_SYS_COL_STAT\',\n"
"\'%VIRTUOSO%\',\n"
"\'%\')\n";
static const char *proc47 = 
"create procedure DB.DBA.__ORACLE_SYS_COL_STAT (in DSN varchar, in RT_NAME varchar, in RT_REMOTE_NAME varchar)\n"
"returns ANY\n"
"{\n"
"\n"
"declare _meta, _res any;\n"
"\n"
"rexecute (DSN,\n"
"\'select c.COLUMN_NAME, c.NUM_DISTINCT, NULL, NULL, c.AVG_COL_LEN, t.NUM_ROWS - c.NUM_NULLS, t.NUM_ROWS \' ||\n"
"\' from ALL_TABLES t, ALL_TAB_COLUMNS c where t.TABLE_NAME = c.TABLE_NAME and t.OWNER = c.OWNER and \' ||\n"
"\'  t.OWNER = ? and t.TABLE_NAME = ?\',\n"
"NULL, NULL, vector (name_part (RT_REMOTE_NAME, 1, NULL), name_part (RT_REMOTE_NAME, 2, NULL)),\n"
"NULL, _meta, _res);\n"
"\n"
"if (isarray (_res) and length (_res) > 0 and isarray (_res[0]) and isarray (_meta) and isarray (_meta[0]))\n"
"{\n"
"declare _inx, _len integer;\n"
"_inx := 0;\n"
"_len := length (_res);\n"
"exec_result_names (_meta[0]);\n"
"while (_inx < _len)\n"
"{\n"
"exec_result (_res[_inx]);\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src system.sql:2356\n";

static const char *proc48 = 
"create procedure DB.DBA.__VIRTUOSO_SYS_COL_STAT (in DSN varchar, in RT_NAME varchar, in RT_REMOTE_NAME varchar)\n"
"returns ANY\n"
"{\n"
"\n"
"declare _meta, _res any;\n"
"\n"
"rexecute (DSN,\n"
"\'select CS_COL, CS_N_DISTINCT, encode_base64 (serialize (CS_MIN)), encode_base64 (serialize (CS_MAX)), \' ||\n"
"\' CS_AVG_LEN, CS_N_VALUES, CS_N_ROWS from DB.DBA.ALL_COL_STAT where CS_TABLE = complete_table_name (?, 1)\',\n"
"NULL, NULL, vector (RT_REMOTE_NAME),\n"
"NULL, _meta, _res);\n"
"\n"
"if (isarray (_res) and length (_res) > 0 and isarray (_res[0]) and isarray (_meta) and isarray (_meta[0]))\n"
"{\n"
"declare _inx, _len integer;\n"
"_inx := 0;\n"
"_len := length (_res);\n"
"exec_result_names (_meta[0]);\n"
"while (_inx < _len)\n"
"{\n"
"declare _res_row any;\n"
"_res_row := _res[_inx];\n"
"_res_row[2] := deserialize (decode_base64 (_res_row[2]));\n"
"_res_row[3] := deserialize (decode_base64 (_res_row[3]));\n"
"exec_result (_res_row);\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src system.sql:2385\n";

static const char *other40 = 
" insert soft SYS_STAT_VDB_MAPPERS\n"
"(SVDM_TYPE,\n"
"SVDM_PROC,\n"
"SVDM_DBMS_NAME_MASK,\n"
"SVDM_DBMS_VER_MASK)\n"
"values\n"
"(\'SYS_COL_STAT\',\n"
"\'DB.DBA.__INFORMIX_SYS_COL_STAT\',\n"
"\'%INFORMIX%\',\n"
"\'%\')\n";
static const char *proc49 = 
"create procedure DB.DBA.__INFORMIX_SYS_COL_STAT (in DSN varchar, in RT_NAME varchar, in RT_REMOTE_NAME varchar)\n"
"{\n"
"declare _meta, _res any;\n"
"declare i_meta, i_res any;\n"
"declare CS_COL, CS_N_DISTINCT, CS_MIN, CS_MAX, CS_AVG_LEN, CS_N_VALUES, CS_N_ROWS int;\n"
"declare tabid, colid int;\n"
"\n"
"rexecute (DSN, \'select t.nrows, c.colname, c.colno, c.colmin, c.colmax, c.collength, c.coltype from systables t, syscolumns c where c.tabid = t.tabid and t.owner = ? and t.tabname = ?\',\n"
"NULL, NULL, vector (name_part (RT_REMOTE_NAME, 1, NULL), name_part (RT_REMOTE_NAME, 2, NULL)), NULL, _meta, _res);\n"
"\n"
"rexecute (DSN, \'select part1, nunique from sysindexes i, systables t where t.tabid = i.tabid and t.owner = ? and t.tabname = ?\',\n"
"NULL, NULL, vector (name_part (RT_REMOTE_NAME, 1, NULL), name_part (RT_REMOTE_NAME, 2, NULL)), NULL, i_meta, i_res);\n"
"\n"
"if (isarray (_res) and length (_res) > 0 and isarray (_res[0]) and isarray (_meta) and isarray (_meta[0]))\n"
"{\n"
"declare _len, i_len, col_type int;\n"
"declare arr, crow any;\n"
"if (isarray (i_res) and length (i_res) > 0 and isarray (i_res[0]) and isarray (i_meta) and isarray (i_meta[0]))\n"
"i_len := length (i_res);\n"
"else\n"
"i_len := 0;\n"
"\n"
"result_names (CS_COL, CS_N_DISTINCT, CS_MIN, CS_MAX, CS_AVG_LEN, CS_N_VALUES, CS_N_ROWS);\n"
"arr := make_array (7, \'any\');\n"
"_len := length (_res);\n"
"for (declare i int, i := 0; i < _len; i := i + 1)\n"
"{\n"
"crow := _res[i];\n"
"CS_N_ROWS := crow[0];\n"
"CS_COL := trim(crow[1]);\n"
"CS_AVG_LEN := crow[5];\n"
"CS_N_VALUES := CS_N_ROWS;\n"
"CS_N_DISTINCT := CS_N_ROWS / 10;\n"
"col_type := mod (crow[6], 256);\n"
"\n"
"if (col_type = 5 or col_type = 8)\n"
"{\n"
"CS_AVG_LEN := crow[5]/256;\n"
"}\n"
"\n"
"if (col_type = 0 or col_type = 13 or col_type = 15 or col_type = 16)\n"
"{\n"
"if (crow[5] > 0)\n"
"{\n"
"CS_AVG_LEN := mod (crow[5], 256);\n"
"}\n"
"else\n"
"{\n"
"CS_AVG_LEN := mod ((crow[5] + 65536), 256);\n"
"}\n"
"}\n"
"else if (col_type = 10 or col_type = 14)\n"
"{\n"
"CS_AVG_LEN := mod (crow[5], 256);\n"
"}\n"
"\n"
"if (col_type > 0 and col_type < 7)\n"
"{\n"
"CS_MIN := crow[3];\n"
"CS_MAX := crow[4];\n"
"}\n"
"else\n"
"{\n"
"CS_MIN := null;\n"
"CS_MAX := null;\n"
"}\n"
"\n"
"for (declare j int, j := 0; j < i_len; j := j + 1)\n"
"{\n"
"if (i_res[j][0] = crow[2])\n"
"{\n"
"CS_N_DISTINCT := i_res[j][1];\n"
"j := i_len;\n"
"}\n"
"}\n"
"\n"
"if (cs_n_distinct is null) cs_n_distinct := cs_n_rows;\n"
"result (CS_COL, CS_N_DISTINCT, CS_MIN, CS_MAX, CS_AVG_LEN, CS_N_VALUES, CS_N_ROWS);\n"
"}\n"
"}\n"
"return null;\n"
"}\n"
"--src system.sql:2431\n";

static const char *proc50 = 
"create procedure DB.DBA.__DB2_SYS_COL_STAT (in DSN varchar, in RT_NAME varchar, in RT_REMOTE_NAME varchar)\n"
"returns ANY\n"
"{\n"
"\n"
"declare _meta, _res any;\n"
"\n"
"rexecute (DSN,\n"
"\'select c.COLNAME, c.COLCARD, c.LOW2KEY, c.HIGH2KEY, c.AVGCOLLEN, t.CARD - c.NUMNULLS, t.CARD \' ||\n"
"\'from SYSSTAT.COLUMNS c, SYSSTAT.TABLES t \' ||\n"
"\'where t.TABNAME = c.TABNAME and t.TABSCHEMA = c.TABSCHEMA and c.TABSCHEMA = ? and c.TABNAME = ?\',\n"
"NULL, NULL, vector (name_part (RT_REMOTE_NAME, 1, NULL), name_part (RT_REMOTE_NAME, 2, NULL)),\n"
"NULL, _meta, _res);\n"
"\n"
"if (isarray (_res) and length (_res) > 0 and isarray (_res[0]) and isarray (_meta) and isarray (_meta[0]))\n"
"{\n"
"declare _inx, _len integer;\n"
"_inx := 0;\n"
"_len := length (_res);\n"
"exec_result_names (_meta[0]);\n"
"while (_inx < _len)\n"
"{\n"
"exec_result (_res[_inx]);\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src system.sql:2515\n";

static const char *other41 = 
" insert soft SYS_STAT_VDB_MAPPERS\n"
"(SVDM_TYPE,\n"
"SVDM_PROC,\n"
"SVDM_DBMS_NAME_MASK,\n"
"SVDM_DBMS_VER_MASK)\n"
"values\n"
"(\'SYS_COL_STAT\',\n"
"\'DB.DBA.__DB2_SYS_COL_STAT\',\n"
"\'%DB2%\',\n"
"\'%\')\n";
static const char *proc51 = 
"create procedure SYS_STAT_VDB_SYNC ()\n"
"{\n"
"declare _ds_conn_str any;\n"
"if (sys_stat (\'vdb_stat_refresh_disabled\') = 1)\n"
"return;\n"
"for select RT_DSN, RT_REMOTE_NAME, DS_CONN_STR, RT_NAME\n"
"from DB.DBA.SYS_REMOTE_TABLE, DB.DBA.SYS_DATA_SOURCE where RT_DSN = DS_DSN do\n"
"{\n"
"declare rc int;\n"
"_ds_conn_str := deserialize (DS_CONN_STR);\n"
"rc := SYS_STAT_ANALYZE_VDB (RT_DSN, RT_REMOTE_NAME, _ds_conn_str, RT_NAME, 10, 1);\n"
"if (rc = 1)\n"
"{\n"
"commit work;\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:2557\n";

static const char *proc52 = 
" create procedure SYS_STAT_ANALYZE_VDB (\n"
"in _ds_dsn varchar,\n"
"in _rt_remote_name varchar,\n"
"in _ds_conn_str any,\n"
"in tb_name varchar,\n"
"in perc_trsh int := 0,\n"
"in logerr int := 0\n"
")\n"
"{\n"
"declare vdb_stats_mapper varchar;\n"
"declare exit handler for sqlstate \'*\', NOT FOUND { goto map_done; };\n"
"declare _dbms_name, _dbms_ver varchar;\n"
"_dbms_name := get_keyword (17, _ds_conn_str, \'\');\n"
"_dbms_ver := get_keyword (18, _ds_conn_str, \'\');\n"
"\n"
"vdb_stats_mapper := NULL;\n"
"select top 1 SVDM_PROC into vdb_stats_mapper from SYS_STAT_VDB_MAPPERS\n"
"where\n"
"SVDM_TYPE = \'SYS_COL_STAT\' and\n"
"upper (_dbms_name) like SVDM_DBMS_NAME_MASK and\n"
"upper (_dbms_ver) like SVDM_DBMS_VER_MASK;\n"
"\n"
"if (vdb_stats_mapper is null)\n"
"goto map_done;\n"
"\n"
"declare res, _stat, _meta, _err any;\n"
"_stat := \'00000\';\n"
"if (0 <> exec (sprintf (\'\"%I\" (?, ? ,?)\', vdb_stats_mapper),\n"
"_stat, _err, vector (_ds_dsn, tb_name, _rt_remote_name), 10000, _meta, res))\n"
"goto map_done;\n"
"\n"
"if (not isarray (res))\n"
"goto map_done;\n"
"\n"
"if (length (res) = 0)\n"
"goto map_done;\n"
"\n"
"if (not isarray (res[0]))\n"
"goto map_done;\n"
"\n"
"if (length (res[0]) < 7)\n"
"goto map_done;\n"
"\n"
"if (perc_trsh > 0)\n"
"{\n"
"foreach (any elm in res) do\n"
"{\n"
"declare col_name varchar;\n"
"declare nrows, n_distinct int;\n"
"declare onrows, on_distinct int;\n"
"declare _percent, _base int;\n"
"\n"
"\n"
"col_name := elm[0];\n"
"n_distinct := elm[1];\n"
"nrows := elm[6];\n"
"\n"
"whenever not found goto update_stats;\n"
"select CS_N_DISTINCT, CS_N_ROWS into on_distinct, onrows\n"
"from DB.DBA.SYS_COL_STAT where CS_TABLE = tb_name and CS_COL = col_name;\n"
"\n"
"if (nrows <> onrows)\n"
"{\n"
"_base := __min (onrows, nrows);\n"
"if (_base > 0)\n"
"_percent := ((abs (nrows - onrows)*100)/_base);\n"
"else\n"
"_percent := 100;\n"
"if (_percent >= perc_trsh)\n"
"goto update_stats;\n"
"}\n"
"\n"
"if (n_distinct <> on_distinct)\n"
"{\n"
"_base := __min (n_distinct, on_distinct);\n"
"if (_base > 0)\n"
"_percent := ((abs (n_distinct - on_distinct)*100)/_base);\n"
"else\n"
"_percent := 100;\n"
"if (_percent >= perc_trsh)\n"
"goto update_stats;\n"
"}\n"
"\n"
"}\n"
"return 0;\n"
"}\n"
"update_stats:;\n"
"declare res_len, res_inx integer;\n"
"res_len := length (res);\n"
"res_inx := 0;\n"
"delete from DB.DBA.SYS_COL_STAT where CS_TABLE = tb_name;\n"
"while (res_inx < res_len)\n"
"{\n"
"declare rr, _min, _max any;\n"
"rr := res[res_inx];\n"
"_min := rr[2];\n"
"_max := rr[3];\n"
"\n"
"if (isstring (_min) or iswidestring (_min) or isbinary (_min))\n"
"_min := left (_min, 1000);\n"
"if (isstring (_max) or iswidestring (_max) or isbinary (_max))\n"
"_max := left (_max, 1000);\n"
"insert into DB.DBA.SYS_COL_STAT\n"
"(CS_TABLE, CS_COL, CS_N_DISTINCT, CS_MIN, CS_MAX, CS_AVG_LEN, CS_N_VALUES, CS_N_ROWS)\n"
"values\n"
"(tb_name, rr[0], rr[1], _min, _max, rr[4], rr[5], rr[6]);\n"
"res_inx := res_inx + 1;\n"
"}\n"
"__ddl_changed (tb_name);\n"
"\n"
"if (logerr)\n"
"{\n"
"log_message (sprintf (\'The statistics for table %s has been changed\', tb_name));\n"
"}\n"
"return 1;\n"
"map_done:;\n"
"if (logerr and isstring (_stat) and  _stat <> \'00000\')\n"
"log_message (sprintf (\'Can\\\'t contact to the DSN \"%s\" to refresh statistics on table \"%s\"\', _ds_dsn, tb_name));\n"
"\n"
"return 0;\n"
"}\n"
"--src system.sql:2578\n";

static const char *proc53 = 
" create procedure SYS_STAT_ANALYZE (in tb_name varchar, in pcnt integer:=5, in ignore_vdb integer:=1)\n"
"{\n"
"declare stmt, proc_name varchar;\n"
"declare proc any;\n"
"declare cr cursor for\n"
"select c.\"COLUMN\", c.COL_DTP\n"
"from DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS c\n"
"where\n"
"k.KEY_TABLE = tb_name and\n"
"c.\"COLUMN\" <> \'_IDN\' and\n"
"k.KEY_IS_MAIN = 1 and\n"
"k.KEY_MIGRATE_TO is null and\n"
"kp.KP_KEY_ID = k.KEY_ID and\n"
"COL_ID = KP_COL and\n"
"COL_DTP not in (125, 131, 132, 134, 254);\n"
"declare rc integer;\n"
"declare is_vdb integer;\n"
"declare tot_count integer;\n"
"declare _ds_dsn, _rt_remote_name varchar;\n"
"declare _ds_conn_str any;\n"
"\n"
"_ds_dsn := _rt_remote_name := NULL;\n"
"{\n"
"declare exit handler for not found { _ds_dsn := _rt_remote_name := NULL; };\n"
"\n"
"select RT_DSN, RT_REMOTE_NAME, deserialize (DS_CONN_STR)\n"
"into _ds_dsn, _rt_remote_name, _ds_conn_str\n"
"from DB.DBA.SYS_REMOTE_TABLE, DB.DBA.SYS_DATA_SOURCE\n"
"where RT_NAME = tb_name and RT_DSN = DS_DSN;\n"
"}\n"
"\n"
"if (_ds_dsn is null)\n"
"is_vdb := 0;\n"
"else\n"
"is_vdb := 1;\n"
"\n"
"if (is_vdb and ignore_vdb)\n"
"return;\n"
"\n"
"rc := 0;\n"
"\n"
"if (pcnt > 0)\n"
"rc := SYS_STAT_ANALYZE_VDB (_ds_dsn, _rt_remote_name, _ds_conn_str, tb_name);\n"
"\n"
"\n"
"if (rc = 1)\n"
"return;\n"
"\n"
"connection_set (\'rnd-stat-rate\', 0.0);\n"
"\n"
"proc := string_output ();\n"
"proc_name := sprintf (\'\"%I\"..\"STAT_ANALYZE_%I_%I\"\',\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2));\n"
"http (sprintf (\'create procedure %s () { \\n\', proc_name), proc);\n"
"http (\'set isolation=\'\'uncommitted\'\'; \\n\', proc);\n"
"http (sprintf (\'delete from DB.DBA.SYS_COL_STAT where CS_TABLE = \'\'%S\'\'; \\n\', tb_name), proc);\n"
"open cr;\n"
"whenever not found goto done;\n"
"declare all_ops varchar;\n"
"declare all_vars varchar;\n"
"\n"
"all_ops := \'\';\n"
"all_vars := \'\';\n"
"\n"
"while (1)\n"
"{\n"
"declare col_name, stat, msg varchar;\n"
"declare col_dtp integer;\n"
"fetch cr into col_name, col_dtp;\n"
"http (sprintf (\' declare n_dist_%I integer; \\n\', col_name), proc);\n"
"http (sprintf (\' declare min_%I any; \\n\', col_name), proc);\n"
"http (sprintf (\' declare max_%I any; \\n\', col_name), proc);\n"
"http (sprintf (\' declare avg_len_%I integer; \\n\', col_name), proc);\n"
"http (sprintf (\' declare vals_%I integer; \\n\', col_name), proc);\n"
"\n"
"if (all_ops = \'\')\n"
"{\n"
"all_ops := SYS_GENERATE_ALL_OPS (col_name, col_dtp);\n"
"all_vars := SYS_GENERATE_ALL_VARS (col_name);\n"
"}\n"
"else\n"
"{\n"
"all_ops := concat (all_ops, \',\', SYS_GENERATE_ALL_OPS (col_name, col_dtp));\n"
"all_vars := concat (all_vars, \',\', SYS_GENERATE_ALL_VARS (col_name));\n"
"}\n"
"}\n"
"done:\n"
"close cr;\n"
"if (all_ops = \'\')\n"
"goto fin;\n"
"\n"
"http (\'declare n_rows varchar; \\n\', proc);\n"
"\n"
"if (pcnt)\n"
"{\n"
"if (is_vdb = 1)\n"
"{\n"
"http (\'declare tot_count integer;\\n\', proc);\n"
"http (sprintf (\'tot_count := DB.DBA.__VD_GET_SQLSTATS_COUNT (\'\'%S\'\', \'\'%S\'\');\\n\',\n"
"_ds_dsn, _rt_remote_name), proc);\n"
"http (\'if (tot_count is NULL)\\n\', proc);\n"
"http (\'{\\n\', proc);\n"
"http (sprintf (\'  declare cr_count cursor for select count (*) from \"%I\".\"%I\".\"%I\";\\n\',\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2)), proc);\n"
"http (\'  open cr_count;\\n fetch cr_count into tot_count;\\n close cr_count;\\n\', proc);\n"
"http (\'}\\n\', proc);\n"
"http (\'declare cr2 cursor for \\n\', proc);\n"
"http (sprintf (\'select %s, count (*) from (select top 1000 * from \\\"%I\\\".\\\"%I\\\".\\\"%I\\\") f; \\n\',\n"
"all_ops,\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2)), proc);\n"
"}\n"
"else\n"
"{\n"
"http (\'declare cr2 cursor for \\n\', proc);\n"
"http (sprintf (\'select %s, count (*) from \"%I\".\"%I\".\"%I\" table option ( random %d ); \\n\',\n"
"all_ops,\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2),\n"
"pcnt), proc);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'declare cr2 cursor for \\n\', proc);\n"
"http (sprintf (\'select %s, count (*) from \"%I\".\"%I\".\"%I\"; \\n\',\n"
"all_ops,\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2)), proc);\n"
"}\n"
"\n"
"\n"
"http (\'open cr2; \\n\', proc);\n"
"http (sprintf (\'fetch cr2 into %s, n_rows; \\n\', all_vars) , proc);\n"
"\n"
"\n"
"open cr;\n"
"whenever not found goto done2;\n"
"\n"
"if (pcnt)\n"
"{\n"
"http (\' declare rate float; \\n\', proc);\n"
"http (\' declare ndist_rate float; \\n\', proc);\n"
"if (is_vdb = 1)\n"
"{\n"
"http (\' if (tot_count > 1000) rate := tot_count / 1000.0; \\n\', proc);\n"
"http (\' else rate := 1; \\n\', proc);\n"
"}\n"
"else\n"
"{\n"
"http (\' rate := connection_get (\\\'rnd-stat-rate\\\'); \\n\', proc);\n"
"}\n"
"}\n"
"while (1)\n"
"{\n"
"declare col_name varchar;\n"
"declare col_dtp integer;\n"
"fetch cr into col_name, col_dtp;\n"
"\n"
"if (pcnt)\n"
"{\n"
"http (sprintf (\' if (rate = 0 AND vals_%I <> 0 ) { rate := 1; }; \\n\', col_name), proc);\n"
"http (sprintf (\' if (n_dist_%I < 20) { ndist_rate := 1; } else {ndist_rate := rate; }; \\n\', col_name), proc);\n"
"\n"
"if (col_dtp = 189 or col_dtp = 247)\n"
"{\n"
"http (sprintf (\' if ((n_dist_%I * ndist_rate) > (max_%I - min_%I)) { ndist_rate := 1; n_dist_%I := max_%I - min_%I; } \\n\',\n"
"col_name, col_name, col_name, col_name, col_name, col_name), proc);\n"
"}\n"
"\n"
"http (\'insert into DB.DBA.SYS_COL_STAT (CS_TABLE,CS_COL,CS_N_DISTINCT,CS_MIN,CS_MAX, CS_AVG_LEN, CS_N_VALUES,CS_N_ROWS) \', proc);\n"
"http (sprintf (\'values (\\\'%S\\\',\\\'%S\\\',%s, n_rows * %s); \\n\',\n"
"tb_name, col_name, SYS_GENERATE_ALL_VARS (col_name, \'rate\', \'ndist_rate\'), \'rate\'), proc);\n"
"}\n"
"else\n"
"{\n"
"http (\'insert into DB.DBA.SYS_COL_STAT (CS_TABLE,CS_COL,CS_N_DISTINCT,CS_MIN,CS_MAX, CS_AVG_LEN, CS_N_VALUES,CS_N_ROWS) \', proc);\n"
"http (sprintf (\'values (\\\'%S\\\',\\\'%S\\\',%s, n_rows); \\n\',\n"
"tb_name, col_name, SYS_GENERATE_ALL_VARS (col_name)), proc);\n"
"}\n"
"\n"
"}\n"
"done2:\n"
"http (\'close cr2; \\n\', proc);\n"
"close cr;\n"
"fin:\n"
"\n"
"\n"
"http (sprintf (\'__ddl_changed (\'\'%S\'\'); \\n\', tb_name), proc);\n"
"http (\'}\\n\', proc);\n"
"\n"
"proc := string_output_string (proc);\n"
"\n"
"exec (proc, NULL, NULL);\n"
"exec (sprintf (\'%s ()\', proc_name), NULL, NULL);\n"
"exec (sprintf (\'drop procedure %s\', proc_name), NULL, NULL);\n"
"}\n"
"--src system.sql:2703\n";

static const char *proc54 = 
" create procedure SYS_DB_STAT (in pcnt integer:=null, in ignore_vdb integer:=1)\n"
"{\n"
"declare cnt integer;\n"
"cnt:=0;\n"
"if (pcnt is null) pcnt := 5;\n"
"for select distinct (KEY_TABLE) as TB_NAME from SYS_KEYS where\n"
"not exists (\n"
"select * from SYS_VIEWS where KEY_TABLE = V_NAME\n"
") do {\n"
"if (TB_NAME <> \'DB.DBA.SYS_COL_STAT\')\n"
"{\n"
"SYS_STAT_ANALYZE (TB_NAME, pcnt, ignore_vdb);\n"
"cnt := cnt + 1;\n"
"}\n"
"}\n"
"return cnt;\n"
"}\n"
"--src system.sql:2911\n";

static const char *proc55 = 
" create procedure SYS_STAT_HISTOGRAM (in tb_name varchar, in col_name varchar,\n"
"in n_buckets integer, in prec integer := 1)\n"
"{\n"
"declare proc any;\n"
"declare proc_name,escaped_tb_name varchar;\n"
"declare is_inx, is_analyzed integer;\n"
"\n"
"select count (*) into is_analyzed from DB.DBA.SYS_COL_STAT where CS_TABLE = tb_name and CS_COL = col_name;\n"
"\n"
"select count (*) into is_inx from DB.DBA.SYS_KEYS, DB.DBA.SYS_KEY_PARTS, DB.DBA.SYS_COLS\n"
"where\n"
"KP_KEY_ID = KEY_ID and\n"
"KP_NTH = 0 and\n"
"KP_COL = COL_ID and\n"
"KEY_TABLE = tb_name and\n"
"\"COLUMN\" = col_name;\n"
"\n"
"proc_name := sprintf (\'\"%I\"..\"STAT_HIST_%I_%I_%I\"\',\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2),\n"
"col_name);\n"
"escaped_tb_name := sprintf (\'\"%I\".\"%I\".\"%I\"\',\n"
"name_part (tb_name, 0),\n"
"name_part (tb_name, 1),\n"
"name_part (tb_name, 2));\n"
"proc := string_output();\n"
"http (sprintf (\'create procedure %s (in n_buckets integer := %d, in prec integer := %d) {\\n\',\n"
"proc_name, n_buckets, prec), proc);\n"
"http (\'declare row_cnt, inx, last_inx integer; \\n\', proc);\n"
"http (\'declare _column_val any; \\n\', proc);\n"
"http (\'set isolation=\'\'uncommitted\'\'; \\n\', proc);\n"
"http (\'inx := 0; \\n\', proc);\n"
"http (sprintf (\n"
"\'delete from DB.DBA.SYS_COL_HIST where CH_TABLE = \'\'%S\'\' and CH_COL = \'\'%S\'\'; \\n\',\n"
"tb_name, col_name), proc);\n"
"if (is_inx = 0)\n"
"{\n"
"http (\'row_cnt := 0; \\n\', proc);\n"
"http (sprintf (\n"
"\'for select \"%I\" from %s where \\n\',\n"
"col_name, escaped_tb_name), proc);\n"
"http (sprintf (\n"
"\' (row_cnt := row_cnt + 1, mod (row_cnt - 1, prec, \"%I\")) = 0 order by \"%I\" do\\n{\\n\',\n"
"col_name, col_name), proc);\n"
"http (sprintf (\n"
"\'  _column_val := \"%I\"; \', col_name), proc);\n"
"http (\'if (mod (inx, (row_cnt / n_buckets) / prec) = 0) \\n{\\n\', proc);\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'select count (*) into row_cnt from %s; \\n\',\n"
"escaped_tb_name), proc);\n"
"http (sprintf (\n"
"\'for select \"%I\" from %s order by \"%I\" do \\n{\\n\',\n"
"col_name, escaped_tb_name, col_name), proc);\n"
"http (\'if (mod (inx, prec) = 0 and mod (inx, row_cnt / (n_buckets * prec)) = 0)\\n{\\n\', proc);\n"
"}\n"
"http (\'insert into DB.DBA.SYS_COL_HIST (CH_TABLE, CH_COL, CH_NTH_SAMPLE, CH_VALUE) values\\n\', proc);\n"
"http (sprintf (\n"
"\' (\'\'%S\'\', \'\'%S\'\', inx, \"%I\"); \\n\',\n"
"tb_name, col_name, col_name), proc);\n"
"http (\'last_inx := inx;\\n}\\n inx := inx + 1;\\n}\\n\', proc);\n"
"http (\'if (row_cnt > 0 and last_inx < inx)\\n\', proc);\n"
"http (\'insert into DB.DBA.SYS_COL_HIST (CH_TABLE, CH_COL, CH_NTH_SAMPLE, CH_VALUE) values\\n\', proc);\n"
"http (sprintf (\n"
"\' (\'\'%S\'\', \'\'%S\'\', inx, _column_val); \\n\',\n"
"tb_name, col_name), proc);\n"
"if (is_analyzed > 0)\n"
"http (sprintf (\n"
"\'__ddl_changed (\'\'%S\'\');\\n\',\n"
"tb_name), proc);\n"
"http (\'}\', proc);\n"
"proc := string_output_string (proc);\n"
"exec (proc);\n"
"exec (sprintf (\'%s ()\', proc_name));\n"
"exec (sprintf (\'drop procedure %s\', proc_name));\n"
"\n"
"if (is_analyzed = 0)\n"
"DB..SYS_STAT_ANALYZE (tb_name, prec);\n"
"}\n"
"--src system.sql:2931\n";

static const char *tbl3 = 
"create table\n"
"DB.DBA.SYS_SOAP_DATATYPES (SDT_NAME varchar,\n"
"SDT_SCH long varchar,\n"
"SDT_SOAP_SCH long varchar,\n"
"SDT_TYPE integer,\n"
"SDT_UDT varchar,\n"
"primary key (SDT_NAME, SDT_TYPE))\n"
"alter index SYS_SOAP_DATATYPES on DB.DBA.SYS_SOAP_DATATYPES partition cluster replicated\n";

static const char *proc56 = 
"create procedure\n"
"soap_dt_define (in name varchar, in sch varchar, in udt_name varchar := null)\n"
"{\n"
"declare xt, xte any;\n"
"declare is_elem integer;\n"
"xt := NULL; xte := null; is_elem := 0;\n"
"if (sch is not null)\n"
"{\n"
"declare err, name1, tns varchar;\n"
"if (isentity (sch))\n"
"xte := sch;\n"
"else\n"
"xte := xml_tree_doc (xml_tree (sch));\n"
"xt := xslt (\'http://local.virt/soap_sch\', xte, vector (\'udt_struct\', case when isstring(udt_name) then 1 else 0 end));\n"
"err := xpath_eval (\'string(//@error)\', xt, 1);\n"
"if (xpath_eval (\'/element\', xte, 1) is not null)\n"
"is_elem := 1;\n"
"if (xpath_eval (\'/attribute\', xte, 1) is not null)\n"
"is_elem := -1;\n"
"err := cast (err as varchar);\n"
"if (err <> \'\')\n"
"signal (\'22023\', err, \'SODT1\');\n"
"name1 := cast(xpath_eval (\'string(/@name)\', xt, 1) as varchar);\n"
"tns := cast(xpath_eval (\'string(/@targetNamespace)\', xte, 1) as varchar);\n"
"if (tns is null or tns = \'\')\n"
"name := name1;\n"
"else\n"
"name := sprintf (\'%s:%s\', tns, name1);\n"
"insert replacing DB.DBA.SYS_SOAP_DATATYPES (SDT_NAME,SDT_SCH,SDT_TYPE, SDT_UDT)\n"
"values (name, sch, is_elem, udt_name);\n"
"{\n"
"declare cmpl, cname, cname2,  sch2 varchar;\n"
"cmpl := xpath_eval (\'/element/complexType\', xte, 1);\n"
"\n"
"if (cmpl is not null)\n"
"{\n"
"cname := sprintf (\'elementType__%s\', name1);\n"
"if (tns is null or tns = \'\')\n"
"cname2 := cname;\n"
"else\n"
"cname2 := sprintf (\'%s:%s\', tns, cname);\n"
"sch2 := xslt (\'http://local.virt/soap_sch\', cmpl, vector (\'type_name\', cname));\n"
"__soap_dt_define (cname2, sch2, sch2, 0, udt_name);\n"
"insert replacing DB.DBA.SYS_SOAP_DATATYPES (SDT_NAME,SDT_SCH, SDT_TYPE, SDT_UDT) values (cname2, sch2, 0, udt_name);\n"
"}\n"
"}\n"
"}\n"
"else\n"
"delete from DB.DBA.SYS_SOAP_DATATYPES where SDT_NAME = name;\n"
"__soap_dt_define (name, xt, xte, is_elem, udt_name);\n"
"return name;\n"
"}\n"
"--src system.sql:3048\n";

static const char *proc57 = 
" create procedure SET_IDENTITY_COLUMN (in tbl_name varchar, in col_name varchar, in num integer)\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_COLS where \"TABLE\" = tbl_name and \"COLUMN\" = col_name))\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_COLS where \"TABLE\" = tbl_name))\n"
"signal (\'10050\', concat (\'No table \', tbl_name, \' in call to SET_IDENTITY_COLUMN\'));\n"
"else\n"
"signal (\'10050\', concat (\'No column \', col_name, \' in table \', tbl_name, \' in call to SET_IDENTITY_COLUMN\'));\n"
"}\n"
"return sequence_set (concat (name_part (tbl_name, 0, \'DB\'), \'.\',\n"
"name_part (tbl_name, 1, user), \'.\', tbl_name, \'.\', col_name), num, 0);\n"
"}\n"
"--src system.sql:3105\n";

static const char *proc58 = 
" create procedure GET_IDENTITY_COLUMN (in tbl_name varchar, in col_name varchar, in no_check int := 0)\n"
"{\n"
"if (no_check = 0 and not exists (select 1 from DB.DBA.SYS_COLS where \"TABLE\" = tbl_name and \"COLUMN\" = col_name))\n"
"{\n"
"if (not exists (select 1 from DB.DBA.SYS_COLS where \"TABLE\" = tbl_name))\n"
"signal (\'10050\', concat (\'No table \', tbl_name, \' in call to GET_IDENTITY_COLUMN\'));\n"
"else\n"
"signal (\'10050\', concat (\'No column \', col_name, \' in table \', tbl_name, \' in call to GET_IDENTITY_COLUMN\'));\n"
"}\n"
"return sequence_set (concat (name_part (tbl_name, 0, \'DB\'), \'.\',\n"
"name_part (tbl_name, 1, user), \'.\', tbl_name, \'.\', col_name), 0, 2);\n"
"}\n"
"--src system.sql:3120\n";

static const char *other42 = 
"xml_add_system_path(\'file://system/\')\n";
static const char *proc59 = 
"create procedure\n"
"DAV_USER_SET_PASSWORD (in name varchar, in passwd varchar)\n"
"{\n"
"USER_PASSWORD_SET (name, passwd);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src system.sql:3138\n";

static const char *proc60 = 
" create procedure DB.DBA.HTTP_CLIENT (\n"
"in url varchar,\n"
"in uid varchar := null,\n"
"in pwd varchar := null,\n"
"in http_method varchar := \'GET\',\n"
"in http_headers varchar := null,\n"
"in body varchar := null,\n"
"in cert_file varchar := null,\n"
"in cert_pwd varchar := null,\n"
"in timeout int := null,\n"
"in proxy varchar := null,\n"
"in ca_certs varchar := null,\n"
"in insecure int := 0,\n"
"in n_redirects int := 0\n"
")\n"
"{\n"
"\n"
"if (cert_file is null and url like \'https://%\')\n"
"cert_file := \'1\';\n"
"if (http_headers is not null)\n"
"{\n"
"http_headers := rtrim (http_headers, \'\\r\\n\');\n"
"if (length (http_headers))\n"
"http_headers := http_headers || \'\\r\\n\';\n"
"}\n"
"return http_client_internal (url, uid, pwd, http_method, http_headers, body, cert_file, cert_pwd, null, timeout, proxy, ca_certs, insecure, n_redirects);\n"
"}\n"
"--src system.sql:3156\n";

static const char *proc61 = 
" create procedure DB.DBA.HTTP_CLIENT_EXT (\n"
"in url varchar,\n"
"in uid varchar := null,\n"
"in pwd varchar := null,\n"
"in http_method varchar := \'GET\',\n"
"in http_headers varchar := null,\n"
"in body varchar := null,\n"
"in cert_file varchar := null,\n"
"in cert_pwd varchar := null,\n"
"inout headers any,\n"
"in timeout int := null,\n"
"in proxy varchar := null,\n"
"in ca_certs varchar := null,\n"
"in insecure int := 0,\n"
"in n_redirects int := 0\n"
")\n"
"{\n"
"\n"
"if (cert_file is null and url like \'https://%\')\n"
"cert_file := \'1\';\n"
"if (http_headers is not null)\n"
"{\n"
"http_headers := rtrim (http_headers, \'\\r\\n\');\n"
"if (length (http_headers))\n"
"http_headers := http_headers || \'\\r\\n\';\n"
"}\n"
"return http_client_internal (url, uid, pwd, http_method, http_headers, body, cert_file, cert_pwd, headers, timeout, proxy, ca_certs, insecure, n_redirects);\n"
"}\n"
"--src system.sql:3186\n";

static const char *proc62 = 
" create procedure SQL_PROCEDURE_COLUMNSW (\n"
"in qual varchar,\n"
"in owner varchar,\n"
"in name varchar,\n"
"in col varchar,\n"
"in casemode integer,\n"
"in is_odbc3 integer\n"
")\n"
"{\n"
"declare PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME, TYPE_NAME, REMARKS nvarchar;\n"
"declare COLUMN_SIZE, BUFFER_LENGTH integer;\n"
"declare COLUMN_TYPE, DATA_TYPE, DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE smallint;\n"
"\n"
"declare COLUMN_DEF, IS_NULLABLE nvarchar;\n"
"declare SQL_DATA_TYPE, SQL_DATETIME_SUB smallint;\n"
"declare CHAR_OCTET_LENGTH, ORDINAL_POSITION integer;\n"
"\n"
"\n"
"result_names (PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME,\n"
"COLUMN_TYPE, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH,\n"
"DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE, REMARKS,\n"
"COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE);\n"
"\n"
"declare full_name varchar;\n"
"declare inx, sz integer;\n"
"declare cols, elt any;\n"
"\n"
"full_name := name;\n"
"if (owner is not null)\n"
"full_name := concat (owner, \'.\', full_name);\n"
"else if (qual is not null)\n"
"full_name := concat (\'.\', full_name);\n"
"\n"
"if (qual is not null)\n"
"full_name := concat (qual, \'.\', full_name);\n"
"\n"
"for\n"
"select\n"
"P_NAME\n"
"from DB.DBA.SYS_PROCEDURES\n"
"where\n"
"either (casemode,\n"
"charset_recode (upper (charset_recode (P_NAME, \'UTF-8\', \'_WIDE_\')), \'_WIDE_\', \'UTF-8\'),\n"
"P_NAME) like\n"
"either (casemode, charset_recode (upper (charset_recode (full_name, \'UTF-8\', \'_WIDE_\')), \'_WIDE_\', \'UTF-8\'), full_name)\n"
"and __proc_exists (P_NAME) is not null\n"
"do\n"
"{\n"
"cols := procedure_cols (P_NAME);\n"
"if (cols)\n"
"{\n"
"sz := length (cols);\n"
"inx := 0;\n"
"while (inx < sz)\n"
"{\n"
"elt := aref (cols, inx);\n"
"if (either (casemode, upper (aref (elt, 3)), aref (elt, 3)) like\n"
"either (casemode, upper (col), col))\n"
"{\n"
"result (\n"
"charset_recode (aref (elt, 0), \'UTF-8\', \'_WIDE_\'),\n"
"charset_recode (aref (elt, 1), \'UTF-8\', \'_WIDE_\'),\n"
"charset_recode (aref (elt, 2), \'UTF-8\', \'_WIDE_\'),\n"
"charset_recode (aref (elt, 3), \'UTF-8\', \'_WIDE_\'),\n"
"aref (elt, 4),\n"
"either (is_odbc3, dv_to_sql_type3 (aref (elt, 5)), dv_to_sql_type (aref (elt, 5))),\n"
"dv_type_title (aref (elt, 5)),\n"
"aref (elt, 7),\n"
"aref (elt, 7),\n"
"aref (elt, 6),\n"
"10,\n"
"aref (elt, 8),\n"
"NULL,\n"
"\n"
"NULL,\n"
"either (is_odbc3, dv_to_sql_type3 (aref (elt, 5)), dv_to_sql_type (aref (elt, 5))),\n"
"NULL,\n"
"aref (elt, 7),\n"
"aref (elt, 9),\n"
"either (aref (elt, 8), \'YES\', \'NO\')\n"
");\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:3218\n";

static const char *proc63 = 
"create procedure\n"
"DB.DBA.__XML_TEMPLATE (in path any, in params any, in lines any, in enc any := null)\n"
"{\n"
"declare xt any;\n"
"declare xslt, f varchar;\n"
"\n"
"f := concat (http_root (), http_physical_path ());\n"
"if ({?\'template\'} is not null and not isstring (file_stat (f, 3)))\n"
"xt := xtree_doc({?\'template\'}, 0);\n"
"else\n"
"xt := xtree_doc(file_to_string (f), 0);\n"
"\n"
"if (enc is not null)\n"
"{\n"
"if (is_http_ctx ())\n"
"{\n"
"set http_charset=enc;\n"
"}\n"
"else\n"
"xml_tree_doc_encoding (xt, enc);\n"
"}\n"
"else\n"
"enc := current_charset ();\n"
"\n"
"\n"
"__set_user_id (http_map_get (\'vsp_uid\'));\n"
"xslt := xml_template (xt, params);\n"
"\n"
"\n"
"if (xslt is not null)\n"
"{\n"
"if (xslt = \'__xml_template_default\')\n"
"xslt := \'precompiled:__xml_template_default\';\n"
"else if ({?\'__base_url\'} is not null)\n"
"xslt := WS.WS.EXPAND_URL ({?\'__base_url\'}, xslt);\n"
"else\n"
"xslt := WS.WS.EXPAND_URL (concat (\'file:\', http_physical_path ()), xslt);\n"
"http_xslt (xslt);\n"
"}\n"
"\n"
"if ({?\'contenttype\'} is not null)\n"
"http_header (sprintf (\'Content-type: %s; charset=\"%s\"\\r\\nCache-Control: no-cache, must-revalidate\\r\\nPragma: no-cache\\r\\nExpires: Thu, 01 Dec 1994 01:02:03 GMT\\r\\n\', {?\'contenttype\'}, enc));\n"
"else if (xslt is null)\n"
"http_header (sprintf (\'Content-type: text/xml; charset=\"%s\"\\r\\nCache-Control: no-cache, must-revalidate\\r\\nPragma: no-cache\\r\\nExpires: Thu, 01 Dec 1994 01:02:03 GMT\\r\\n\', enc));\n"
"if ({?\'content-filename\'} is not null)\n"
"{\n"
"http_header (concat (http_header_get (), sprintf (\'Content-Disposition: inline; filename=\"%s\"\\r\\n\', {?\'content-filename\'})));\n"
"}\n"
"__pop_user_id ();\n"
"}\n"
"--src system.sql:3309\n";

static const char *proc64 = 
" create procedure\n"
"DB.DBA.XQ_TEMPLATE (inout q varchar, inout ctx varchar, inout ses any, inout map_schema any)\n"
"{\n"
"declare res, qry, uri, doc any;\n"
"declare i, l integer;\n"
"if (isstring (map_schema))\n"
"qry := sprintf (\'for $r in xmlview(\"%s\")%s return $r\', map_schema, q);\n"
"else\n"
"qry := q;\n"
"\n"
"if (isstring (ctx) and length (ctx))\n"
"{\n"
"uri := DB.DBA.XML_URI_RESOLVE_LIKE_GET (\'\', ctx);\n"
"doc := DB.DBA.XML_URI_GET (\'\', uri);\n"
"doc := xtree_doc (doc, 0, uri);\n"
"}\n"
"else\n"
"{\n"
"doc := xper_doc(\'<blank/>\', 0, ctx);\n"
"}\n"
"\n"
"res := xquery_eval (qry, doc, 0);\n"
"i := 0; l := length (res);\n"
"while (i<l)\n"
"{\n"
"http_value (res[i], NULL, ses);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src system.sql:3542\n";

static const char *proc65 = 
" create procedure\n"
"DB.DBA.SQLX_OR_SPARQL_TEMPLATE (inout q varchar, inout params any, inout ses any, inout q_type any)\n"
"{\n"
"declare h, res, qry any;\n"
"qry := q;\n"
"\n"
"if (q_type)\n"
"{\n"
"declare arr, _text, decl, i, l any;\n"
"_text := substring (qry, 7, length (qry));\n"
"arr := sparql_lex_analyze (_text);\n"
"l := length (arr)-2;\n"
"for (i := 0; i < l; i := i + 1)\n"
"{\n"
"declare elm any;\n"
"if (isstring (arr[i][2]) and isstring (arr[i+1][2]) and isstring (arr[i+2][2]))\n"
"{\n"
"elm := lower (arr[i][2]);\n"
"if (elm = \'define\' and lower (arr[i+1][2]) = \'output:format\')\n"
"{\n"
"if (upper (arr[i+2][2]) = \'\"RDF/XML\"\')\n"
"goto done;\n"
"else\n"
"signal (\'22023\', \'The output:format must be RDF/XML\');\n"
"}\n"
"}\n"
"}\n"
"qry := \'SPARQL define output:format \"RDF/XML\" \' || _text;\n"
"done:;\n"
"}\n"
"\n"
"exec (qry,  null, null, params, 0, null, null, h);\n"
"while (0 = exec_next(h, null, null, res))\n"
"{\n"
"if (isarray (res) and length (res))\n"
"{\n"
"foreach (any elm in res) do\n"
"{\n"
"if (isentity (elm))\n"
"http_value (elm, null, ses);\n"
"else if (isstring (elm) or __tag (elm) = 185)\n"
"http (elm, ses);\n"
"}\n"
"}\n"
"}\n"
"exec_close (h);\n"
"params := 0;\n"
"return;\n"
"}\n"
"--src system.sql:3574\n";

static const char *other43 = 
"xslt_sheet (\'__xml_template_default\', xml_tree_doc (xml_tree(\n"
"\'<?xml version=\"1.0\"?>\n"
"<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" >\n"
"<xsl:output method=\"html\"/>\n"
"<xsl:template match=\"/\">\n"
"<HTML>\n"
"<title>Search results</title>\n"
"<BODY>\n"
"<H4>Search results</H4>\n"
"<TABLE BORDER=\"0\">\n"
"<xsl:apply-templates select=\"*\" />\n"
"</TABLE>\n"
"</BODY>\n"
"</HTML>\n"
"</xsl:template>\n"
"<xsl:template match=\"resource\">\n"
"<TR>\n"
"<TD><b>Document:</b></TD><TD><A><xsl:attribute name=\"HREF\"><xsl:value-of select=\"@name\"/></xsl:attribute><xsl:value-of select=\"@name\"/></A></TD>\n"
"</TR>\n"
"<TR>\n"
"<TD><b>Last Modified:</b></TD>\n"
"<TD><xsl:value-of select=\"substring (@modified ,1, 19)\"/></TD>\n"
"</TR>\n"
"<TR>\n"
"<TD><b>Size:</b></TD>\n"
"<TD><xsl:value-of select=\"@length\"/> bytes</TD>\n"
"</TR>\n"
"<TR>\n"
"<TD colspan=\"2\">&nbsp;</TD>\n"
"</TR>\n"
"</xsl:template>\n"
"</xsl:stylesheet>\'))\n"
")\n";
static const char *proc66 = 
"create procedure\n"
"cov_store (in f varchar, in add_line integer := 0)\n"
"{\n"
"declare i, l, i1, l1 integer;\n"
"declare arr, arr1 any;\n"
"declare result varchar;\n"
"declare ses any;\n"
"arr1 := pldbg_stats (NULL, add_line, null, 1);\n"
"if (length (arr1) < 1)\n"
"return NULL;\n"
"ses := string_output ();\n"
"http (\'<?xml version=\"1.0\" ?>\\n<pl_stats>\', ses);\n"
"i1:=0; l1:=length(arr1);\n"
"while (i1 < l1)\n"
"{\n"
"arr := arr1[i1];\n"
"if (length (arr))\n"
"{\n"
"declare tag_name, udt_name any;\n"
"tag_name := \'proc\';\n"
"udt_name := \'\';\n"
"if (length (arr[0]) > 5 and arr[0][5] is not null)\n"
"{\n"
"tag_name := \'method\';\n"
"udt_name := sprintf (\' class=\"%V\"\', arr[0][5]);\n"
"}\n"
"if (add_line)\n"
"result := sprintf (\'\\n\\t<%s name=\"%V\" calls=\"%08d\" file=\"%V\" lct=\"%d\" time=\"%d\" self=\"%d\" %s>\', tag_name, arr[0][0], arr[0][2], arr[0][1], arr[0][3], arr[0][4], arr[0][6], udt_name);\n"
"else\n"
"result := sprintf (\'\\n\\t<%s name=\"%V\" calls=\"%08d\" file=\"%V\" time=\"%d\" self=\"%d\" %s>\', tag_name, arr[0][0], arr[0][2], arr[0][1], arr[0][4], arr[0][6], udt_name);\n"
"i := 0;\n"
"l := length (arr[1]);\n"
"while (i < l)\n"
"{\n"
"if (add_line)\n"
"result := concat (result, sprintf (\'\\n\\t\\t<line no=\"%06d\" ctr=\"%06d\"><![CDATA[%s]]></line>\', arr[1][i][0], arr[1][i][1], replace(replace(arr[1][i][2], \'\"\', \'\'\'\'), \']]>\', \']]>]]<![CDATA[>\')));\n"
"else\n"
"result := concat (result, sprintf (\'\\n\\t\\t<line no=\"%06d\" ctr=\"%06d\" />\', arr[1][i][0], arr[1][i][1]));\n"
"i := i + 1;\n"
"}\n"
"i := 0;\n"
"l := length (arr[2]);\n"
"while (i < l)\n"
"{\n"
"result := concat (result, sprintf (\'\\n\\t\\t<caller name=\"%V\" ct=\"%06d\" />\', arr[2][i][0], arr[2][i][1]));\n"
"i := i + 1;\n"
"}\n"
"result := concat (result, sprintf(\'\\n\\t</%s>\', tag_name));\n"
"http (result, ses);\n"
"}\n"
"i1 := i1+ 1;\n"
"}\n"
"http (\'</pl_stats>\', ses);\n"
"string_to_file (f, ses, -2);\n"
"}\n"
"--src system.sql:3664\n";

static const char *proc67 = 
"create procedure\n"
"cov_load (in f varchar)\n"
"{\n"
"declare rep varchar;\n"
"declare xt any;\n"
"declare xp any;\n"
"declare i, j, k, l integer;\n"
"if (not isstring (file_stat (f, 3)))\n"
"return;\n"
"rep := file_to_string (f);\n"
"xt := xml_tree_doc (rep);\n"
"xp := xpath_eval (\'/pl_stats/proc|/pl_stats/method\', xt, 0);\n"
"i := 0; l := length (xp);\n"
"while (i < l)\n"
"{\n"
"declare name, udt varchar;\n"
"declare calls, tim, sel integer;\n"
"declare lin, cal, res, lins, cals any;\n"
"name := cast (xpath_eval (\'@name\',xp[i], 1) as varchar);\n"
"udt := cast (xpath_eval (\'@class\',xp[i], 1) as varchar);\n"
"calls := cast (xpath_eval (\'@calls\',xp[i], 1) as integer);\n"
"tim := cast (xpath_eval (\'@time\',xp[i], 1) as integer);\n"
"sel := cast (xpath_eval (\'@self\',xp[i], 1) as integer);\n"
"if (tim is null) tim := 0;\n"
"if (sel is null) sel := 0;\n"
"lin := xpath_eval (\'line\', xp[i], 0);\n"
"cal := xpath_eval (\'caller\', xp[i], 0);\n"
"res := vector (vector (name, \'unnamed\', calls, tim, udt, sel));\n"
"j := 0; k := length (lin);\n"
"lins := vector ();\n"
"while (j < k)\n"
"{\n"
"declare line_no, cnt integer;\n"
"line_no := cast (xpath_eval (\'@no\',lin[j], 1) as integer);\n"
"cnt := cast (xpath_eval (\'@ctr\', lin[j], 1) as integer);\n"
"lins := vector_concat (lins, vector (vector (line_no, cnt)));\n"
"j := j + 1;\n"
"}\n"
"\n"
"j := 0; k := length (cal);\n"
"cals := vector ();\n"
"while (j < k)\n"
"{\n"
"declare cnt integer;\n"
"declare caller varchar;\n"
"caller := cast (xpath_eval (\'@name\',cal[j], 1) as varchar);\n"
"cnt := cast (xpath_eval (\'@ct\', cal[j], 1) as integer);\n"
"cals := vector_concat (cals, vector (vector (caller, cnt)));\n"
"j := j + 1;\n"
"}\n"
"res := vector_concat (res, vector(lins), vector(cals));\n"
"pldbg_stats_load (res);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src system.sql:3722\n";

static const char *proc68 = 
"create procedure\n"
"cov_report (in f varchar, in odir varchar)\n"
"{\n"
"\n"
"declare r, s, xt, files, fls, xe any;\n"
"declare i, l integer;\n"
"if (odir not like \'%/\')\n"
"odir := concat (odir, \'/\');\n"
"xe := xml_tree_doc (file_to_string (f));\n"
"xt := xpath_eval (\'/pl_stats/*/@file\', xe, 0);\n"
"files := vector ();\n"
"fls := \'<files>\';\n"
"i := 0; l := length (xt);\n"
"while (i < l)\n"
"{\n"
"declare elm varchar;\n"
"elm := cast (xt[i] as varchar);\n"
"if (not position (elm, files))\n"
"{\n"
"files := vector_concat (files, vector (elm));\n"
"fls := fls || sprintf (\'<file name=\"%s\"/>\', elm);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"fls := fls || \'</files>\';\n"
"i := 0; l := length (files);\n"
"while (i < l)\n"
"{\n"
"declare fname varchar;\n"
"r := xslt (\'http://local.virt/cov_report\', xe, vector (\'file_name\', files[i]));\n"
"s := string_output ();\n"
"http_value (r, null, s);\n"
"fname := files[i];\n"
"fname := replace (fname, \'\\\\\', \'/\');\n"
"if (strrchr (fname, \'/\') is not null)\n"
"fname := subseq (fname, strrchr (fname, \'/\') + 1);\n"
"string_to_file (concat(odir,fname,\'.cov\'), s, -2);\n"
"i := i + 1;\n"
"}\n"
"r := xslt (\'http://local.virt/cov_time\', xe, vector (\'files\', xtree_doc (fls)));\n"
"s := string_output ();\n"
"http_value (r, null, s);\n"
"string_to_file (concat(odir,\'profile\',\'.prof\'), s, -2);\n"
"}\n"
"--src system.sql:3780\n";

static const char *proc69 = 
"create procedure\n"
"vd_remote_proc_wrapper (in _dsn varchar, in pro varchar, in dest varchar, in meta any, out state varchar, out msg varchar, in make_rset integer := 0, in descr varchar := \'\')\n"
"{\n"
"declare pars any;\n"
"declare q,o,n, par, typ, rname, _comment, stmt1, rcols, rcols1, rcols2, remote_st varchar;\n"
"declare q1,o1,n1, cmn1, rset varchar;\n"
"declare have_rset, posit, i, l integer;\n"
"declare loop_str varchar;\n"
"\n"
"declare infos, dbms, driv any;\n"
"infos := vector ();\n"
"if (_dsn <> \'\')\n"
"{\n"
"whenever not found goto nfnd;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = _dsn;\n"
"nfnd:;\n"
"}\n"
"\n"
"dbms := upper (get_keyword (17, infos, \'\'));\n"
"driv := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"q := name_part (dest, 0);\n"
"o := name_part (dest, 1);\n"
"n := name_part (dest, 2);\n"
"\n"
"_comment := coalesce (descr, \'\');\n"
"\n"
"if (_comment <> \'\')\n"
"_comment := concat (\'\\-\\-##\', _comment, \'\');\n"
"\n"
"q1 := name_part (pro, 0);\n"
"o1 := name_part (pro, 1);\n"
"n1 := name_part (pro, 2);\n"
"\n"
"have_rset := 0;\n"
"rset := \', {resultset 1000, \';\n"
"stmt1 := sprintf (\'create procedure \"%I\".\"%I\".\"%I\" (\', q,o,n);\n"
"rcols := \'\'; rcols1 := \'\'; rcols2 := \'\'; posit := 0;\n"
"if (q1 = \'\')\n"
"{\n"
"if (dbms like \'%ORACLE%\' and (driv like \'MSORCL32.DLL%\' or driv like \'OPLODBC.SO\'))\n"
"rname := concat (o1,\'.\',n1);\n"
"else\n"
"rname := quote_dotted (_dsn, concat (o1,\'.\',n1));\n"
"remote_st := sprintf (\'{call %s (\', rname);\n"
"}\n"
"else\n"
"{\n"
"declare pro1 varchar;\n"
"pro1 := pro;\n"
"if (pro1 like \'%;%\')\n"
"{\n"
"declare semi integer;\n"
"declare pro2, num2 varchar;\n"
"semi := strrchr (pro, \';\');\n"
"pro2 := pro1; num2 := \'\';\n"
"if (semi is not null)\n"
"{\n"
"pro2 := subseq (pro1, 0, semi);\n"
"num2 := subseq (pro1, semi, length (pro1));\n"
"}\n"
"rname := quote_dotted (_dsn, pro2);\n"
"rname := concat (rname, num2);\n"
"}\n"
"else\n"
"rname := quote_dotted (_dsn, pro1);\n"
"remote_st := sprintf (\'{call %s (\', rname);\n"
"}\n"
"\n"
"declare br integer;\n"
"if (isarray (meta))\n"
"pars := meta;\n"
"else\n"
"pars := vector ();\n"
"i := 0; l := length (pars); br := 0;\n"
"while (i < l)\n"
"{\n"
"declare t, na, dt, st varchar;\n"
"na := pars [i][1];\n"
"t := pars [i][0];\n"
"\n"
"dt := pars [i][2];\n"
"st := pars [i][3];\n"
"\n"
"if (t = \'RESULTSET\' and dbms like \'%ORACLE%\')\n"
"{\n"
"rset := concat (rset, na, \',\');\n"
"have_rset := 1;\n"
"goto nexti;\n"
"}\n"
"\n"
"if (t = \'RETURNS\')\n"
"{\n"
"br := 1;\n"
"}\n"
"else if (t <> \'RESULTSET\')\n"
"{\n"
"stmt1 := concat (stmt1, t, \' \', na, \' \', dt);\n"
"rcols := concat (rcols, na, \',\');\n"
"if (t = \'IN\')\n"
"rcols1 := concat (rcols1, na, \',\');\n"
"else\n"
"rcols1 := concat (rcols1, sprintf (\'vector (\'\'%s\'\', \'\'%s\'\', 0, %s),\',t,dt,na));\n"
"if (t <> \'IN\')\n"
"rcols2 := concat (rcols2, na, sprintf (\' := params[%d] ;\', posit));\n"
"posit := posit + 1;\n"
"remote_st := concat (remote_st, \'?,\');\n"
"}\n"
"if (st <> \'\')\n"
"{\n"
"if (t <> \'RETURNS\')\n"
"stmt1 := concat (stmt1, \' __soap_type \'\'\', st, \'\'\'\');\n"
"}\n"
"if (t <> \'RETURNS\')\n"
"stmt1 := concat (stmt1, \',\');\n"
"nexti:\n"
"i := i + 1;\n"
"}\n"
"stmt1 := trim (stmt1, \', \');\n"
"remote_st := trim (remote_st, \', \');\n"
"\n"
"if (have_rset)\n"
"{\n"
"rset := rtrim (rset, \', \');\n"
"rset := concat (rset, \'}\');\n"
"remote_st := concat (remote_st, rset);\n"
"}\n"
"\n"
"remote_st := concat (remote_st, \')\');\n"
"if (remote_st like \'%()\')\n"
"remote_st := trim (remote_st,\')(\');\n"
"rcols := trim (rcols, \', \');\n"
"\n"
"rcols1 := rtrim (rcols1, \', \');\n"
"\n"
"if (make_rset)\n"
"loop_str := \'\\n if (isarray (mdta) and isarray (dta)) { exec_result_names(mdta[0]);\\ndeclare i, l integer;\\ni := 0; l := length (dta);\\n while(i<l) {\\n   exec_result(dta[i]);\\n   i:=i+1;\\n } }\';\n"
"else\n"
"loop_str := \'\\nreturn dta;\';\n"
"\n"
"remote_st := remote_st || \'}\';\n"
"\n"
"stmt1 := concat (stmt1, sprintf ( \') returns any array array\\n{ \\n\\-\\-PL Wrapper for remote procedure\\n%s\\n\\-\\-\"DSN:%s PROCEDURE:%s\"\\ndeclare dta, mdta any; \\ndeclare params any; \\nparams := vector (%s); \\nset_user_id (\'\'dba\'\');\\nrexecute (%s, %s, NULL, NULL, params, 0, mdta, dta); \\n%s\\n%s\\n}\', _comment, _dsn, pro, rcols1, WS.WS.STR_SQL_APOS (_dsn), WS.WS.STR_SQL_APOS (remote_st), rcols2, loop_str));\n"
"state := \'00000\';\n"
"exec (stmt1, state, msg);\n"
"}\n"
"--src system.sql:3828\n";

static const char *other44 = 
"update SYS_COLS set COL_PREC = 2147483647 where COL_DTP = 125 and COL_PREC < 2147483647\n";
static const char *proc70 = 
"create procedure EXEC_STMT (in stmt_text varchar, in mode integer)\n"
"{\n"
"declare state, msg varchar;\n"
"declare meta, res any;\n"
"\n"
"if (mode)\n"
"return execstr (stmt_text);\n"
"\n"
"exec (stmt_text, state, msg, vector (), 100, meta, res);\n"
"}\n"
"--src system.sql:3980\n";

static const char *proc71 = 
"create procedure EXEC_AS (in stmt_text varchar, in uname varchar, in mode integer := 0)\n"
"{\n"
"declare state, msg varchar;\n"
"declare meta, res any;\n"
"\n"
"set_user_id (uname);\n"
"\n"
"if (mode)\n"
"return execstr (stmt_text);\n"
"\n"
"exec (stmt_text, state, msg, vector (), 100, meta, res);\n"
"}\n"
"--src system.sql:3992\n";

static const char *proc72 = 
" create procedure RSTMTEXEC (in dsn varchar, in stmt varchar, in max_rows integer := 0, in params_array any := null)\n"
"{\n"
"declare stmt_compilation, cursor_handle, curr_row any;\n"
"declare row_ctr integer;\n"
"\n"
"rexecute (dsn, stmt, NULL, NULL, params_array, NULL, stmt_compilation, NULL, cursor_handle);\n"
"\n"
"if (not isarray (stmt_compilation))\n"
"signal (\'22023\', \'The statement in RSTMTEXEC should have a resultset\', \'VD086\');\n"
"\n"
"exec_result_names (stmt_compilation[0]);\n"
"\n"
"row_ctr := 0;\n"
"if (max_rows >= 0)\n"
"{\n"
"while (0 = rnext (cursor_handle, curr_row))\n"
"{\n"
"if (isarray (curr_row))\n"
"exec_result (curr_row);\n"
"row_ctr := row_ctr + 1;\n"
"if (max_rows > 0 and row_ctr >= max_rows)\n"
"goto done;\n"
"}\n"
"}\n"
"done:\n"
"rclose (cursor_handle);\n"
"}\n"
"--src system.sql:4008\n";

static const char *proc73 = 
"create procedure FTI_MAKE_SEARCH_STRING_INNER (in exp varchar, inout words any)\n"
"{\n"
"declare exp1 varchar;\n"
"declare war, vt any;\n"
"declare m, n int;\n"
"\n"
"words := vector ();\n"
"\n"
"if (length (exp) < 2)\n"
"return null;\n"
"\n"
"exp := trim (exp, \' \');\n"
"\n"
"if (strchr (exp, \' \') is null)\n"
"{\n"
"words := vector (trim (exp, \'\"\'));\n"
"return concat (\'\"\', trim (exp, \'\"\'), \'\"\');\n"
"}\n"
"\n"
"\n"
"exp1 := \'\';\n"
"\n"
"if (strchr (exp, \'\"\') is not null or\n"
"strchr (exp, \'\'\'\') is not null)\n"
"{\n"
"declare tmp, w varchar;\n"
"tmp := exp;\n"
"w := regexp_match (\'[\"][^\"]+[\"]|[\'\'][^\'\']+[\'\']|[^\"\'\' ]+\', tmp, 1);\n"
"while (w is not null)\n"
"{\n"
"w := trim (w, \'\"\'\' \');\n"
"if (upper(w) not in (\'AND\', \'NOT\', \'NEAR\', \'OR\')\n"
"and length (w) > 1\n"
"and not vt_is_noise (w, \'utf-8\', \'x-ViAny\'))\n"
"{\n"
"exp1 := concat (exp1, sprintf (\'\"%s\" AND \', w));\n"
"words := vector_concat (words, vector (w));\n"
"}\n"
"w := regexp_match (\'[\"][^\"]+[\"]|[\'\'][^\'\']+[\'\']|[^\"\'\' ]+\', tmp, 1);\n"
"}\n"
"if (length (exp1) > 6)\n"
"{\n"
"exp1 := substring (exp1, 1, length (exp1) - 5);\n"
"goto end_parse;\n"
"}\n"
"}\n"
"\n"
"vt := vt_batch (100, \'x-ViAny\', \'UTF-8\');\n"
"vt_batch_feed (vt, exp, 0, 0);\n"
"\n"
"war := vt_batch_strings_array (vt);\n"
"words := vector ();\n"
"\n"
"m := length (war);\n"
"n := 0;\n"
"exp1 := \'(\';\n"
"while (n < m)\n"
"{\n"
"declare word1 varchar;\n"
"if (war[n] not in (\'AND\', \'NOT\', \'NEAR\', \'OR\')\n"
"and length (war[n]) > 1\n"
"and not vt_is_noise (war[n], \'utf-8\', \'x-ViAny\'))\n"
"{\n"
"word1 := war[n];\n"
"words := vector_concat (words, vector (word1));\n"
"if (strchr (word1, \'.\') is not null or strchr (word1, \'-\') is not null\n"
"or regexp_match (\'^[A-Za-z_][A-Za-z0-9_-]*\', word1) is null)\n"
"word1 := concat (\'\"\', word1, \'\"\');\n"
"exp1 := concat (exp1, word1, \' AND \');\n"
"}\n"
"n := n + 2;\n"
"}\n"
"\n"
"if (length (exp1) > 5)\n"
"{\n"
"exp1 := substring (exp1, 1, length (exp1) - 5);\n"
"exp1 := concat (exp1, \')\');\n"
"}\n"
"else\n"
"exp1 := null;\n"
"\n"
"end_parse:\n"
"return exp1;\n"
"}\n"
"--src system.sql:4038\n";

static const char *proc74 = 
"create procedure FTI_MAKE_SEARCH_STRING (in exp varchar)\n"
"{\n"
"declare words any;\n"
"return FTI_MAKE_SEARCH_STRING_INNER (exp, words);\n"
"}\n"
"--src system.sql:4124\n";

static const char *tbl4 = 
"create table DB.DBA.CLR_VAC (\n"
"VAC_DATA LONG VARCHAR,\n"
"VAC_INTERNAL_NAME VARCHAR,\n"
"VAC_REAL_NAME VARCHAR,\n"
"VAC_FULL_NAME VARCHAR,\n"
"VAC_FULL_FILE_NAME VARCHAR,\n"
"VAC_PERM_SET INTEGER,\n"
"VAC_CREATE TIMESTAMP,\n"
"primary key (VAC_INTERNAL_NAME)\n"
")\n";


static const char *other45 = 
" exec_quiet (\'create type __ANY as (__any any)\')\n";
static const char *proc75 = 
"create procedure exec_quiet (in expn varchar)\n"
"{\n"
"declare sta, msg varchar;\n"
"exec (expn, sta, msg);\n"
"}\n"
"--src system.sql:4150\n";

static const char *other46 = 
"exec_quiet (\'create type __ANY as (__any any)\')\n";
static const char *udt0 = 
" create type XMLType\n"
"as (\n"
"xt_ent any,\n"
"xt_schema varchar,\n"
"xt_validated integer\n"
")\n"
"method existsNode (_xpath varchar) returns integer,\n"
"method existsNode (_xpath varchar, _nsmap varchar) returns integer,\n"
"method extract (_xpath varchar) returns any,\n"
"method extract (_xpath varchar, _nsmap varchar) returns any,\n"
"method query (_xquery varchar) returns any,\n"
"method isFragment () returns integer,\n"
"method getClobVal () returns nvarchar,\n"
"method getNumVal () returns numeric,\n"
"method getStringVal () returns nvarchar,\n"
"method transform (_xsl any) returns XMLType,\n"
"method transform (_xsl any, _param_map any) returns XMLType,\n"
"method isSchemaBased () returns integer,\n"
"method getSchemaURL () returns varchar,\n"
"method getRootElement () returns any,\n"
"method createSchemaBasedXML () returns any,\n"
"method createSchemaBasedXML (_url varchar) returns any,\n"
"method createNonSchemaBasedXML () returns any,\n"
"method getNamespace () returns nvarchar,\n"
"method schemaValidate () returns any,\n"
"method isSchemaValidated () returns integer,\n"
"method setSchemaValidated () returns integer,\n"
"method setSchemaValidated (_flag integer) returns integer,\n"
"method isSchemaValid () returns integer,\n"
"method isSchemaValid (_url varchar) returns integer,\n"
"method isSchemaValid (_url varchar, _elemname varchar) returns integer,\n"
"constructor method XMLType (_src any),\n"
"constructor method XMLType (_src any, _schema varchar),\n"
"constructor method XMLType (_src any, _schema varchar, _validated integer),\n"
"constructor method XMLType (_src any, _schema varchar, _validated integer, _wellformed integer)\n";

static const char *other47 = 
"create method existsNode (in _xpath varchar) returns integer for XMLType\n"
"{\n"
"declare _hit any;\n"
"_hit := xpath_eval (_xpath, self.xt_ent, 1);\n"
"if (__tag (_hit) = 230)\n"
"return 1;\n"
"return 0;\n"
"}\n";

static const char *other48 = 
"create method existsNode (in _xpath varchar, in _nsmap varchar) returns integer for XMLType\n"
"{\n"
"declare _hit any;\n"
"if (_nsmap is not null)\n"
"if (_xpath <> \'\' and aref (_xpath, 0) = \'[\')\n"
"_xpath := concat (\'[\', _nsmap, \' \', subseq (_xpath, 1));\n"
"else\n"
"_xpath := concat (\'[\', _nsmap, \']\', _xpath);\n"
"_hit := xpath_eval (_xpath, self.xt_ent, 1);\n"
"if (__tag (_hit) = 230)\n"
"return 1;\n"
"return 0;\n"
"}\n";

static const char *other49 = 
"create method extract (in _xpath varchar) returns any for XMLType\n"
"{\n"
"declare _hit any;\n"
"_hit := xpath_eval (_xpath, self.xt_ent, 1);\n"
"if (__tag (_hit) = 230)\n"
"return XMLType (_hit);\n"
"return _hit;\n"
"}\n";

static const char *other50 = 
"create method query (in _xquery varchar) returns any for XMLType\n"
"{\n"
"declare _hit any;\n"
"_hit := xquery_eval (_xquery, self.xt_ent, 1);\n"
"if (__tag (_hit) = 230)\n"
"return XMLType (_hit);\n"
"return _hit;\n"
"}\n";

static const char *other51 = 
"create method extract (in _xpath varchar, in _nsmap varchar) returns any for XMLType\n"
"{\n"
"declare _hit any;\n"
"if (_nsmap is not null)\n"
"if (_xpath <> \'\' and aref (_xpath, 0) = \'[\')\n"
"_xpath := concat (\'[\', _nsmap, \' \', subseq (_xpath, 1));\n"
"else\n"
"_xpath := concat (\'[\', _nsmap, \']\', _xpath);\n"
"_hit := xpath_eval (_xpath, self.xt_ent, 1);\n"
"if (__tag(_hit) = 230)\n"
"return XMLType (_hit);\n"
"return _hit;\n"
"}\n";

static const char *other52 = 
"create method isFragment () returns integer for XMLType\n"
"{\n"
"if (xpath_eval (\'count(/*)\', self.xt_ent) = 1)\n"
"return 0;\n"
"return 1;\n"
"}\n";

static const char *other53 = 
"create method getClobVal () returns nvarchar for XMLType\n"
"{\n"
"return xpath_eval (\'serialize(.)\', self.xt_ent, 1);\n"
"}\n";

static const char *other54 = 
"create method getNumVal () returns numeric for XMLType\n"
"{\n"
"return xpath_eval (\'number(.)\', self.xt_ent, 1);\n"
"}\n";

static const char *other55 = 
"create method getStringVal () returns nvarchar for XMLType\n"
"{\n"
"return xpath_eval (\'string(.)\', self.xt_ent, 1);\n"
"}\n";

static const char *other56 = 
"create method transform (inout _xsl any) returns XMLType for XMLType\n"
"{\n"
"signal (\'42000\', \'Virtuoso does not support method XMLType.transform(); use xslt built-in function instead\');\n"
"}\n";

static const char *other57 = 
"create method transform (inout _xsl any, in _param_map any) returns XMLType for XMLType\n"
"{\n"
"signal (\'42000\', \'Virtuoso does not support method XMLType.transform(); use xslt built-in function instead\');\n"
"}\n";

static const char *other58 = 
"create method isSchemaBased () returns integer for XMLType\n"
"{\n"
"if (self.xt_schema is null)\n"
"return 0;\n"
"return 1;\n"
"}\n";

static const char *other59 = 
"create method getSchemaURL () returns varchar for XMLType\n"
"{\n"
"return self.xt_schema;\n"
"}\n";

static const char *other60 = 
"create method getRootElement () returns any for XMLType\n"
"{\n"
"declare _roots any;\n"
"_roots := xpath_eval (\'/*\', self.xt_ent, 0);\n"
"if (length (_roots) <> 1)\n"
"return null;\n"
"return XMLType (aref (_roots, 0), self.xt_schema);\n"
"}\n";

static const char *other61 = 
"create method createSchemaBasedXML () returns any for XMLType\n"
"{\n"
"return XMLType (self.xt_ent);\n"
"}\n";

static const char *other62 = 
"create method createSchemaBasedXML (in _url varchar) returns any for XMLType\n"
"{\n"
"if (_url = self.xt_schema)\n"
"return self;\n"
"return XMLType (self.xt_ent, _url);\n"
"}\n";

static const char *other63 = 
"create method createNonSchemaBasedXML () returns any for XMLType\n"
"{\n"
"return XMLType (self.xt_ent);\n"
"}\n";

static const char *other64 = 
"create method getNamespace () returns nvarchar for XMLType\n"
"{\n"
"declare _res nvarchar;\n"
"if (self.xt_schema is null)\n"
"return null;\n"
"if (xpath_eval (\'count(/*)\', self.xt_ent) <> 1)\n"
"return null;\n"
"_res := xpath_eval (\'namespace-uri(/*)\', self.xt_ent);\n"
"\n"
"\n"
"\n"
"return _res;\n"
"}\n";

static const char *other65 = 
"create method schemaValidate () returns any for XMLType\n"
"{\n"
"if (self.xt_validated <> 0)\n"
"return null;\n"
"if (self.xt_schema is null)\n"
"signal (\'42000\', \'Document is not schema-based\');\n"
"xml_validate_schema (self.xt_ent,\n"
"0,\n"
"coalesce (xml_doc_get_base_uri (self.xt_ent), \'\'),\n"
"\'UTF-8\',\n"
"\'x-any\',\n"
"\'Validation=SGML FsaBadWs=IGNORE SignalOnError=ENABLE\',\n"
"\'xs:\', \':xs\', self.xt_schema );\n"
"self.xt_validated := 1;\n"
"}\n";

static const char *other66 = 
"create method isSchemaValidated () returns integer for XMLType\n"
"{\n"
"return self.xt_validated;\n"
"}\n";

static const char *other67 = 
"create method setSchemaValidated () returns integer for XMLType\n"
"{\n"
"if (self.xt_schema is null)\n"
"signal (\'42000\', \'Document is not schema-based\');\n"
"self.xt_validated := 1;\n"
"return 1;\n"
"}\n";

static const char *other68 = 
"create method setSchemaValidated (in _flag integer) returns integer for XMLType\n"
"{\n"
"if (self.xt_schema is null)\n"
"signal (\'42000\', \'Document is not schema-based\');\n"
"self.xt_validated := _flag;\n"
"return _flag;\n"
"}\n";

static const char *other69 = 
"create method isSchemaValid () returns integer for XMLType\n"
"{\n"
"if (self.xt_schema is null)\n"
"signal (\'42000\', \'Document is not schema-based and no schema URL is provided for XMLType.isSchemaValid().\');\n"
"whenever sqlstate \'42000\' goto err;\n"
"xml_validate_schema (self.xt_ent,\n"
"0,\n"
"coalesce (xml_doc_get_base_uri (self.xt_ent), \'\'),\n"
"\'UTF-8\',\n"
"\'x-any\',\n"
"\'Validation=SGML FsaBadWs=IGNORE SignalOnError=ENABLE\',\n"
"\'xs:\', \':xs\', self.xt_schema );\n"
"return 1;\n"
"\n"
"err:\n"
"return 0;\n"
"}\n";

static const char *other70 = 
"create method isSchemaValid (in _url varchar) returns integer for XMLType\n"
"{\n"
"whenever sqlstate \'42000\' goto err;\n"
"xml_validate_schema (self.xt_ent,\n"
"0,\n"
"coalesce (xml_doc_get_base_uri (self.xt_ent), \'\'),\n"
"\'UTF-8\',\n"
"\'x-any\',\n"
"\'Validation=SGML FsaBadWs=IGNORE SignalOnError=ENABLE\',\n"
"\'xs:\', \':xs\', _url );\n"
"return 1;\n"
"\n"
"err:\n"
"return 0;\n"
"}\n";

static const char *other71 = 
"create method isSchemaValid (in _url varchar, in _elemname varchar) returns integer for XMLType\n"
"{\n"
"whenever sqlstate \'42000\' goto err;\n"
"xml_validate_schema (self.xt_ent,\n"
"0,\n"
"coalesce (xml_doc_get_base_uri (self.xt_ent), \'\'),\n"
"\'UTF-8\',\n"
"\'x-any\',\n"
"\'Validation=SGML FsaBadWs=IGNORE SignalOnError=ENABLE\',\n"
"\'xs:\', \':xs\', _url );\n"
"return 1;\n"
"\n"
"err:\n"
"return 0;\n"
"}\n";

static const char *other72 = 
"create constructor method XMLType (in _src any) for XMLType\n"
"{\n"
"if (__tag (_src) = 230)\n"
"self.xt_ent := _src;\n"
"else if (__tag (_src) = 193)\n"
"self.xt_ent := xml_tree_doc(_src);\n"
"else\n"
"self.xt_ent := xtree_doc (_src);\n"
"self.xt_schema := null;\n"
"self.xt_validated := 0;\n"
"}\n";

static const char *other73 = 
"create constructor method XMLType (in _src any, in _schema varchar) for XMLType\n"
"{\n"
"if (__tag (_src) = 230)\n"
"self.xt_ent := _src;\n"
"else if (__tag (_src) = 193)\n"
"self.xt_ent := xml_tree_doc(_src);\n"
"else\n"
"self.xt_ent := xtree_doc (_src);\n"
"self.xt_schema := _schema;\n"
"self.xt_validated := 0;\n"
"}\n";

static const char *other74 = 
"create constructor method XMLType (in _src any, in _schema varchar, in _validated integer) for XMLType\n"
"{\n"
"if (__tag (_src) = 230)\n"
"self.xt_ent := _src;\n"
"else if (__tag (_src) = 193)\n"
"self.xt_ent := xml_tree_doc(_src);\n"
"else\n"
"self.xt_ent := xtree_doc (_src);\n"
"self.xt_schema := _schema;\n"
"self.xt_validated := _validated;\n"
"}\n";

static const char *other75 = 
"create constructor method XMLType (in _src any, in _schema varchar, in _validated integer, in _wellformed integer) for XMLType\n"
"{\n"
"if (__tag (_src) = 230)\n"
"self.xt_ent := _src;\n"
"else if (__tag (_src) = 193)\n"
"self.xt_ent := xml_tree_doc(_src);\n"
"else\n"
"self.xt_ent := xtree_doc (_src);\n"
"self.xt_schema := _schema;\n"
"self.xt_validated := _validated;\n"
"}\n";

static const char *other76 = 
"create constructor method XMLType (in _src any, in _schema varchar := null, in _validated integer := 0, in _wellformed integer := 0) for XMLType\n"
"{\n"
"if (__tag (_src) = 230)\n"
"self.xt_ent := _src;\n"
"else\n"
"self.xt_ent := xtree_doc (_src);\n"
"self.xt_schema := _schema;\n"
"self.xt_validated := _validated;\n"
"}\n";

static const char *proc76 = 
" create function createXML (in _src any, in _schema varchar := null, in _validated integer := 0, in _wellformed integer := 0) returns XMLType\n"
"{\n"
"declare _res XMLType;\n"
"_res := XMLType (_src, _schema, _validated, _wellformed);\n"
"return _res;\n"
"}\n"
"--src system.sql:4550\n";

static const char *other77 = 
"grant execute on XMLType to public\n";
static const char *proc77 = 
" create procedure DB.DBA.SYS_CREATE_XML_SCHEMA (in _txt varchar)\n"
"{\n"
"declare _log varchar;\n"
"declare _parsed any;\n"
"declare _xsd_top any;\n"
"declare _target_ns any;\n"
"declare _cres_uri any;\n"
"_parsed := xtree_doc (_txt, 0, \'(argument of CREATE XML SCHEMA statement)\', \'UTF-8\', \'x-any\', \'Validation=RIGOROUS BuildStandalone=ENABLE\');\n"
"_xsd_top := xpath_eval (\'[xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"] /xs:schema\', _parsed, 0);\n"
"if (0 = length(_xsd_top))\n"
"signal (\'XSD01\', \'No XMLSchema top element found in the provided XML document\');\n"
"if (1 < length(_xsd_top))\n"
"signal (\'XSD01\', \'The provided XML document is not a valida schema\');\n"
"_target_ns := xpath_eval (\'@targetNamespace\', _xsd_top[0]);\n"
"if (_target_ns is NULL)\n"
"signal (\'XSD01\', \'No \"targetNamespace\" attribute in top-level \"xs:schema\" element in the provided XML document\');\n"
"if (_target_ns = \'\')\n"
"signal (\'XSD01\', \'The value of the \"targetNamespace\" attribute in top-level \"xs:schema\" element is not a well-formed URI\');\n"
"_cres_uri := \'x-virt-cache-xsd--\' || _target_ns;\n"
"if (exists (select top 1 1 from SYS_CACHED_RESOURCES where CRES_URI=_cres_uri))\n"
"signal (\'XSD01\', sprintf (\'The XMLSchema for target namespace \"%s\" is already declared\', _target_ns));\n"
"insert into SYS_CACHED_RESOURCES (CRES_URI, CRES_CONTENT)\n"
"values (_cres_uri, _txt);\n"
"}\n"
"--src system.sql:4562\n";

static const char *proc78 = 
" create procedure DB.DBA.XML_COLUMN_SCHEMA_VALIDATE (\n"
"in _table varchar, in _column varchar, in _xml any,\n"
"in _xsd_uri varchar, in _top_name varchar, in _dtd_cfg varchar)\n"
"{\n"
"declare _log varchar;\n"
"\n"
"if (_xml is null)\n"
"return null;\n"
"\n"
"xml_validate_schema (\n"
"_xml, 0, sprintf(\'(value to be placed in column %s of %s)\', _table, _column),\n"
"\'UTF-8\', \'x-any\',\n"
"case when (_dtd_cfg is null) then \'Validation=RIGOROUS AttrMisformat=ERROR AttrMissing=ERROR FSA=ERROR IdDuplicates=ERROR IdrefIntegrity=ERROR SignalOnError=ENABLE\' else concat (_dtd_cfg, \' SignalOnError=ENABLE\') end,\n"
"\'xs:\', \':xs\', \'x-virt-cache-xsd--\' || _xsd_uri );\n"
"\n"
"\n"
"return null;\n"
"}\n"
"--src system.sql:4589\n";

static const char *proc79 = 
" create function SYS_TREE_OF_ARRAYS_CONTAINS (in _haystack any, in _needle any)\n"
"{\n"
"declare _ctr integer;\n"
"if (__tag (_haystack) = __tag (_needle))\n"
"return equ (_haystack, _needle);\n"
"if (isstring (_haystack) or not (isarray (_haystack)))\n"
"return 0;\n"
"_ctr := length (_haystack);\n"
"while (_ctr > 0)\n"
"{\n"
"_ctr := _ctr - 1;\n"
"if (SYS_TREE_OF_ARRAYS_CONTAINS (aref (_haystack, _ctr), _needle))\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src system.sql:4610\n";

static const char *proc80 = 
" create procedure DB.DBA.SYS_DROP_XML_SCHEMA (in _target_ns varchar)\n"
"{\n"
"declare _log varchar;\n"
"declare _parsed any;\n"
"declare _xsd_top any;\n"
"declare _cres_uri any;\n"
"_cres_uri := \'x-virt-cache-xsd--\' || _target_ns;\n"
"if (not exists (select top 1 1 from SYS_CACHED_RESOURCES where CRES_URI=_cres_uri))\n"
"signal (\'XSD01\', sprintf (\'Undefined XMLSchema name in DROP XML SCHEMA \"%s\"\', _target_ns));\n"
"for\n"
"select C_TABLE from SYS_CONSTRAINTS where\n"
"SYS_TREE_OF_ARRAYS_CONTAINS (deserialize(C_MODE), cast (_target_ns as varchar)) do\n"
"signal (\'XSD01\', sprintf (\'Can not DROP XML SCHEMA \"%s\" because the schema is in use in constraint of table %s\', _target_ns, C_TABLE));\n"
"delete from SYS_CACHED_RESOURCES where CRES_URI =_cres_uri;\n"
"}\n"
"--src system.sql:4629\n";

static const char *proc81 = 
" create procedure REGEXP_LIKE (in source_string any, in pattern any, in match_parameter integer := null)\n"
"returns integer\n"
"{\n"
"if (match_parameter is not null)\n"
"signal (\'22023\', \'match_parameter not supported yet\', \'SR371\');\n"
"if (source_string is null or pattern is null)\n"
"return 0;\n"
"else\n"
"{\n"
"if ((not isstring (source_string)) and (not iswidestring (source_string)))\n"
"source_string := cast (source_string as varchar);\n"
"if ((not isstring (pattern)) and (not iswidestring (pattern)))\n"
"pattern := cast (pattern as varchar);\n"
"}\n"
"return either (isnull (regexp_match (pattern, source_string)), 0, 1);\n"
"}\n"
"--src system.sql:4647\n";

static const char *proc82 = 
" create procedure REGEXP_REPLACE (in source_string any, in pattern any,\n"
"in replace_string varchar := \'\', in position integer := 1,\n"
"in occurrence any := 1, in match_parameter integer := null)\n"
"{\n"
"if (source_string is null or pattern is null or replace_string is null)\n"
"return source_string;\n"
"else\n"
"{\n"
"if ((not isstring (source_string)) and (not iswidestring (source_string)))\n"
"source_string := cast (source_string as varchar);\n"
"if ((not isstring (pattern)) and (not iswidestring (pattern)))\n"
"pattern := cast (pattern as varchar);\n"
"if ((not isstring (replace_string)) and (not iswidestring (replace_string)))\n"
"replace_string := cast (replace_string as varchar);\n"
"}\n"
"\n"
"if (match_parameter is not null)\n"
"signal (\'22023\', \'match_parameter not supported yet\', \'SR372\');\n"
"declare cur_pos, copied_up_to, nth integer;\n"
"declare ret any;\n"
"\n"
"ret := either (iswidestring (source_string), N\'\', \'\');\n"
"cur_pos := position - 1;\n"
"copied_up_to := position - 1;\n"
"nth := 1;\n"
"\n"
"while (cur_pos < length (source_string))\n"
"{\n"
"declare exprs any;\n"
"\n"
"exprs := regexp_parse (pattern, source_string, cur_pos);\n"
"\n"
"if (not isarray (exprs))\n"
"goto done;\n"
"\n"
"declare start_inx, end_inx integer;\n"
"start_inx := exprs[0];\n"
"end_inx := exprs[1];\n"
"\n"
"if (occurrence is null or occurrence = nth)\n"
"{\n"
"if (start_inx > copied_up_to)\n"
"ret := concat (ret, subseq (source_string, copied_up_to, start_inx));\n"
"\n"
"if (length (exprs) > 2)\n"
"{\n"
"declare expr_inx integer;\n"
"declare replace_str any;\n"
"declare replace_string_tmp any;\n"
"replace_string_tmp := replace_string;\n"
"expr_inx := 1;\n"
"\n"
"while (expr_inx * 2 < length (exprs))\n"
"{\n"
"declare replace_str_found varchar;\n"
"\n"
"if (exprs[expr_inx * 2] >= 0 and exprs[expr_inx * 2 + 1] >= 0)\n"
"replace_str_found := subseq (source_string, exprs[expr_inx * 2], exprs [expr_inx * 2 + 1]);\n"
"else\n"
"replace_str_found := either (iswidestring (source_string), N\'\', \'\');\n"
"\n"
"replace_str := sprintf (\'\\\\%d\', expr_inx);\n"
"if (iswidestring (source_string))\n"
"replace_str := cast (replace_str as nvarchar);\n"
"replace_string_tmp := replace (replace_string_tmp, replace_str,\n"
"replace_str_found);\n"
"expr_inx := expr_inx + 1;\n"
"}\n"
"while (expr_inx < 10)\n"
"{\n"
"replace_str := sprintf (\'\\\\%d\', expr_inx);\n"
"if (iswidestring (source_string))\n"
"replace_str := cast (replace_str as nvarchar);\n"
"replace_string_tmp := replace (replace_string_tmp, replace_str,\n"
"either (iswidestring (source_string), N\'\', \'\'));\n"
"expr_inx := expr_inx + 1;\n"
"}\n"
"ret := concat (ret, replace_string_tmp);\n"
"}\n"
"else\n"
"ret := concat (ret, replace_string);\n"
"copied_up_to := end_inx;\n"
"if (occurrence is not null)\n"
"goto done;\n"
"}\n"
"\n"
"nth := nth + 1;\n"
"cur_pos := end_inx;\n"
"}\n"
"done:\n"
"if (copied_up_to < length (source_string))\n"
"ret := concat (ret, subseq (source_string, copied_up_to, length (source_string)));\n"
"\n"
"return ret;\n"
"}\n"
"--src system.sql:4667\n";

static const char *proc83 = 
" create procedure REGEXP_INSTR (in source_string varchar, in pattern varchar,\n"
"in start_position integer := 1, in occurrence integer := 1, in return_option integer := 0,\n"
"in match_parameter integer := null)\n"
"returns integer\n"
"{\n"
"\n"
"if (source_string is null or pattern is null)\n"
"return null;\n"
"else\n"
"{\n"
"if ((not isstring (source_string)) and (not iswidestring (source_string)))\n"
"source_string := cast (source_string as varchar);\n"
"if ((not isstring (pattern)) and (not iswidestring (pattern)))\n"
"pattern := cast (pattern as varchar);\n"
"}\n"
"\n"
"if (match_parameter is not null)\n"
"signal (\'22023\', \'match_parameter not supported yet\', \'SR373\');\n"
"\n"
"declare cur_pos, nth integer;\n"
"\n"
"cur_pos := start_position - 1;\n"
"nth := 1;\n"
"\n"
"while (cur_pos < length (source_string) and nth <= occurrence)\n"
"{\n"
"declare exprs any;\n"
"\n"
"exprs := regexp_parse (pattern, source_string, cur_pos);\n"
"\n"
"if (not isarray (exprs))\n"
"return null;\n"
"\n"
"declare start_inx, end_inx integer;\n"
"start_inx := exprs[0];\n"
"end_inx := exprs[1];\n"
"\n"
"if (occurrence = nth)\n"
"{\n"
"if (return_option = 0)\n"
"return start_inx + 1;\n"
"else if (return_option = 1)\n"
"return end_inx + 1;\n"
"else\n"
"signal (\'22023\', \'return_option should be 0 or 1\', \'SR374\');\n"
"}\n"
"\n"
"cur_pos := end_inx;\n"
"nth := nth + 1;\n"
"}\n"
"\n"
"return null;\n"
"}\n"
"--src system.sql:4766\n";

static const char *proc84 = 
" create procedure HTTP_REQUESTED_URL ()\n"
"{\n"
"declare hf, pat, proto, meth, so, eo, lines any;\n"
"if (not is_http_ctx())\n"
"signal (\'22023\', \'http_requested_url function outside of http context\', \'HT069\');\n"
"lines := http_request_header ();\n"
"pat := lines[0];\n"
"proto := http_request_get (\'SERVER_PROTOCOL\');\n"
"meth := http_request_get (\'REQUEST_METHOD\');\n"
"so := strstr (pat, meth || \' \');\n"
"eo := strstr (pat, \' \' || proto);\n"
"pat := trim(subseq (pat, so + length (meth) + 1, eo), \' \\r\\n\');\n"
"hf := rfc1808_parse_uri (pat);\n"
"return WS.WS.EXPAND_URL(soap_current_url (), hf[2]);\n"
"}\n"
"--src system.sql:4822\n";

static const char *proc85 = 
" create procedure HTTP_URL_HANDLER ()\n"
"{\n"
"if (not is_http_ctx())\n"
"signal (\'22023\', \'http_url_handler function outside of http context\', \'HT068\');\n"
"return WS.WS.EXPAND_URL(soap_current_url (), http_path());\n"
"}\n"
"--src system.sql:4840\n";

static const char *proc86 = 
"create procedure DB.DBA.SCHEDULER_NOTIFY ()\n"
"{\n"
"declare arr, err_text, current_rec, mime_parts, hdrs, hostname any;\n"
"\n"
"arr := vector ();\n"
"\n"
"current_rec := null;\n"
"err_text := \'\';\n"
"hostname := sys_stat (\'st_host_name\');\n"
"\n"
"if (not isstring (hostname))\n"
"return;\n"
"\n"
"hdrs := sprintf (\'Subject: [Scheduled Event Errors] %s\\r\\n\', hostname);\n"
"\n"
"for select SE_NAME, SE_SQL, SE_LAST_ERROR, SE_NOTIFY from SYS_SCHEDULED_EVENT where\n"
"SE_LAST_ERROR is not null and SE_ENABLE_NOTIFY = 1 and SE_NOTIFICATION_SENT = 0 order by SE_NOTIFY do\n"
"{\n"
"arr := vector_concat (arr, vector (vector (SE_NAME, SE_SQL, SE_LAST_ERROR, SE_NOTIFY)));\n"
"}\n"
"\n"
"commit work;\n"
"foreach (any elm in arr) do\n"
"{\n"
"declare _SE_NAME, _SE_SQL, _SE_LAST_ERROR, _SE_NOTIFY any;\n"
"_SE_NAME := elm[0];\n"
"_SE_SQL := elm[1];\n"
"_SE_LAST_ERROR := elm[2];\n"
"_SE_NOTIFY := elm[3];\n"
"\n"
"\n"
"if (current_rec is null)\n"
"{\n"
"current_rec := _SE_NOTIFY;\n"
"err_text := \'\';\n"
"}\n"
"else if (current_rec <> _SE_NOTIFY)\n"
"{\n"
"mime_parts := vector (DB.DBA.MIME_PART (\'text/html\', null, null, err_text));\n"
"update SYS_SCHEDULED_EVENT set SE_NOTIFICATION_SENT = 1 where SE_NOTIFY = current_rec and SE_NOTIFICATION_SENT = 0;\n"
"commit work;\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"goto next;\n"
"};\n"
"smtp_send (null, current_rec, current_rec, concat (hdrs, DB.DBA.MIME_BODY (mime_parts)));\n"
"next:;\n"
"}\n"
"current_rec := _SE_NOTIFY;\n"
"err_text := \'\';\n"
"}\n"
"err_text := err_text || \'<pre>\' || _SE_NAME || \' \' || _SE_SQL || \'\\r\\n\' || blob_to_string (_SE_LAST_ERROR) || \'</pre>\\r\\n\' ;\n"
"}\n"
"if (length (err_text) and current_rec is not null)\n"
"{\n"
"mime_parts := vector (DB.DBA.MIME_PART (\'text/html\', null, null, err_text));\n"
"update SYS_SCHEDULED_EVENT set SE_NOTIFICATION_SENT = 1 where SE_NOTIFY = current_rec and SE_NOTIFICATION_SENT = 0;\n"
"commit work;\n"
"smtp_send (null, current_rec, current_rec, concat (hdrs, DB.DBA.MIME_BODY (mime_parts)));\n"
"}\n"
"}\n"
"--src system.sql:4850\n";

static const char *proc87 = 
"create procedure\n"
"SYS_CHECK_OLD_BLOG ()\n"
"{\n"
"if (registry_get (\'__weblog2_tables_is_upgrated\') = \'OK\')\n"
"return;\n"
"if(exists(select 1 from DB.DBA.SYS_KEYS where KEY_TABLE = \'DB.DBA.SYS_BLOGS\'))\n"
"{\n"
"declare mtd, dta, state, msg any;\n"
"state := \'00000\';\n"
"exec (\'select count (*) from DB.DBA.SYS_BLOGS\', state, msg, vector (), 1, mtd, dta);\n"
"if (\'00000\' <> state)\n"
"return;\n"
"if (dta[0][0] > 1)\n"
"log_message (\'Detected old blog instance. Please update it with latest blog.vad\');\n"
"}\n"
"}\n"
"--src system.sql:4916\n";

static const char *other78 = 
"SYS_CHECK_OLD_BLOG ()\n";
static const char *proc88 = 
" create procedure\n"
"HTTP_GET_HOST ()\n"
"{\n"
"declare ret varchar;\n"
"ret := null;\n"
"if (is_http_ctx ())\n"
"{\n"
"ret := http_request_header (http_request_header (), \'Host\', null, sys_connected_server_address ());\n"
"}\n"
"else\n"
"{\n"
"ret := sys_connected_server_address ();\n"
"}\n"
"if (ret is null)\n"
"ret := sys_stat (\'st_host_name\')||\':\'||server_http_port ();\n"
"return ret;\n"
"}\n"
"--src system.sql:4939\n";

static const char *proc89 = 
" create procedure\n"
"date_rfc1123 (in dt datetime)\n"
"{\n"
"return soap_print_box (dt, \'\', 1);\n"
"}\n"
"--src system.sql:4959\n";

static const char *proc90 = 
" create procedure\n"
"date_iso8601 (in dt datetime)\n"
"{\n"
"return soap_print_box (dt, \'\', 0);\n"
"}\n"
"--src system.sql:4967\n";

static const char *proc91 = 
"create procedure DB.DBA.INSTALLER_VAD (in _pak_name varchar)\n"
"{\n"
"declare state, msg, m_dta, res any;\n"
"declare out_message varchar;\n"
"declare idx, len integer;\n"
"\n"
"state := \'00000\';\n"
"msg := \'none\';\n"
"out_message := \'\';\n"
"\n"
"exec (\'VAD_INSTALL(?, 0, 1)\',\n"
"state, msg, vector (_pak_name), 100, m_dta, res);\n"
"\n"
"if (\'00000\' <> state)\n"
"{\n"
"out_message := msg;\n"
"goto finish;\n"
"}\n"
"\n"
"idx := 0;\n"
"len := length (res);\n"
"\n"
"while (idx < len)\n"
"{\n"
"if (res[idx][0] <> \'00000\')\n"
"out_message := out_message || res[idx][1] || \' \';\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"finish:;\n"
"\n"
"string_to_file (\'../vad/install.res\', out_message, -2);\n"
"return;\n"
"}\n"
"--src system.sql:4974\n";

static const char *proc92 = 
"create procedure DB.DBA.VACUUM (in table_name varchar := \'%\', in index_name varchar := \'%\')\n"
"{\n"
"declare stmt, stat, msg varchar;\n"
"set isolation=\'uncommitted\';\n"
"for select distinct KEY_TABLE as _table_name, KEY_NAME as _index_name from SYS_KEYS where\n"
"KEY_TABLE like table_name and KEY_NAME like index_name and KEY_MIGRATE_TO is null do\n"
"{\n"
"if (not exists (select 1 from SYS_VIEWS where V_NAME = _table_name) and\n"
"not exists (select 1 from SYS_REMOTE_TABLE where RT_NAME = _table_name))\n"
"{\n"
"stmt := sprintf (\'select count(*) from \"%I\".\"%I\".\"%I\" table option (index %I, vacuum 0)\',\n"
"name_part (_table_name,0),\n"
"name_part (_table_name,1),\n"
"name_part (_table_name,2),\n"
"name_part (_index_name,2)\n"
");\n"
"stat := \'00000\';\n"
"exec (stmt, stat, msg, vector (), 0);\n"
"dbg_printf (\'%s %s\', stat, stmt);\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:5010\n";

static const char *proc93 = 
"create procedure tc_result (in n varchar, in is_cl int := 0)\n"
"{\n"
"declare r int;\n"
"declare exit handler for sqlstate \'*\' {\n"
"result (-1, n);\n"
"};\n"
"if (is_cl and 1 <> sys_stat (\'cl_run_local_only\'))\n"
"r := cl_sys_stat (n);\n"
"else\n"
"r := sys_stat (n);\n"
"if (r = 0)\n"
"return;\n"
"result (r, n);\n"
"}\n"
"--src system.sql:5036\n";

static const char *proc94 = 
"create procedure tc_stat (in is_cl int := 0)\n"
"{\n"
"declare cond varchar (60);\n"
"declare n int;\n"
"result_names (n, cond);\n"
"tc_result (\'tc_initial_while_closing\', is_cl);\n"
"tc_result (\'tc_initial_while_closing_died\', is_cl);\n"
"tc_result (\'tc_client_dropped_connection\', is_cl);\n"
"tc_result (\'tc_no_client_in_tp_data\', is_cl);\n"
"tc_result (\'tc_bp_get_buffer\', is_cl);\n"
"tc_result (\'tc_bp_get_buffer_loop\', is_cl);\n"
"tc_result (\'tc_first_free_replace\', is_cl);\n"
"tc_result (\'tc_hi_lock_new_lock\', is_cl);\n"
"tc_result (\'tc_hi_lock_old_dp_no_lock\', is_cl);\n"
"tc_result (\'tc_hi_lock_old_dp_no_lock_deadlock\', is_cl);\n"
"tc_result (\'tc_hi_lock_old_dp_no_lock_put_lock\', is_cl);\n"
"tc_result (\'tc_hi_lock_lock\', is_cl);\n"
"tc_result (\'tc_hi_lock_lock_deadlock\', is_cl);\n"
"tc_result (\'tc_pg_write_compact\', is_cl);\n"
"tc_result (\'tc_write_cancel\', is_cl);\n"
"tc_result (\'tc_write_scrapped_buf\', is_cl);\n"
"tc_result (\'tc_serializable_land_reset\', is_cl);\n"
"tc_result (\'tc_dive_cache_compares\', is_cl);\n"
"tc_result (\'tc_desc_serial_reset\', is_cl);\n"
"tc_result (\'tc_try_land_write\', is_cl);\n"
"tc_result (\'tc_try_land_reset\', is_cl);\n"
"tc_result (\'tc_up_transit_parent_change\', is_cl);\n"
"tc_result (\'tc_dp_set_parent_being_read\', is_cl);\n"
"tc_result (\'tc_dp_changed_while_waiting_mtx\', is_cl);\n"
"tc_result (\'tc_dive_split\', is_cl);\n"
"tc_result (\'tc_dtrans_split\', is_cl);\n"
"tc_result (\'tc_up_transit_wait\', is_cl);\n"
"tc_result (\'tc_double_deletes\', is_cl);\n"
"tc_result (\'tc_delete_parent_waits\', is_cl);\n"
"tc_result (\'tc_wait_trx_self_kill\', is_cl);\n"
"tc_result (\'tc_split_while_committing\', is_cl);\n"
"tc_result (\'tc_rb_code_non_unique\', is_cl);\n"
"tc_result (\'tc_set_by_pl_wait\', is_cl);\n"
"tc_result (\'tc_split_2nd_read\', is_cl);\n"
"tc_result (\'tc_read_wait\', is_cl);\n"
"tc_result (\'tc_write_wait\', is_cl);\n"
"tc_result (\'tc_reentry_split\', is_cl);\n"
"tc_result (\'tc_pl_moved_in_reentry\', is_cl);\n"
"tc_result (\'tc_release_pl_on_deleted_dp\', is_cl);\n"
"tc_result (\'tc_release_pl_on_absent_dp\', is_cl);\n"
"tc_result (\'tc_cpt_lt_start_wait\', is_cl);\n"
"tc_result (\'tc_cpt_rollback\', is_cl);\n"
"tc_result (\'tc_wait_for_closing_lt\', is_cl);\n"
"tc_result (\'tc_pl_non_owner_wait_ref_deld\', is_cl);\n"
"tc_result (\'tc_pl_split\', is_cl);\n"
"tc_result (\'tc_pl_split_multi_owner_page\', is_cl);\n"
"tc_result (\'tc_pl_split_while_wait\', is_cl);\n"
"tc_result (\'tc_insert_follow_wait\', is_cl);\n"
"tc_result (\'tc_history_itc_delta_wait\', is_cl);\n"
"tc_result (\'tc_page_wait_reset\', is_cl);\n"
"tc_result (\'tc_key_sample_reset\', is_cl);\n"
"tc_result (\'tc_posthumous_lock\', is_cl);\n"
"tc_result (\'tc_finalize_while_being_read\', is_cl);\n"
"tc_result (\'tc_rollback_cpt_page\', is_cl);\n"
"tc_result (\'tc_kill_closing\', is_cl);\n"
"tc_result (\'tc_dive_cache_hits\', is_cl);\n"
"tc_result (\'tc_deadlock_win_get_lock\', is_cl);\n"
"tc_result (\'tc_double_deadlock\', is_cl);\n"
"tc_result (\'tc_update_wait_move\', is_cl);\n"
"tc_result (\'tc_root_cache_miss\', is_cl);\n"
"tc_result (\'tc_dive_would_deadlock\', is_cl);\n"
"tc_result (\'tc_enter_transiting_bm_inx\', is_cl);\n"
"tc_result (\'tc_root_image_miss\', is_cl);\n"
"tc_result (\'tc_root_image_ref_deleted\', is_cl);\n"
"tc_result (\'tc_root_write\', is_cl);\n"
"tc_result (\'tc_cpt_rollback_retry\', is_cl);\n"
"tc_result (\'tc_uncommit_cpt_page\', is_cl);\n"
"tc_result (\'tc_repl_cycle\', is_cl);\n"
"tc_result (\'tc_repl_connect_quick_reuse\', is_cl);\n"
"tc_result (\'tc_no_thread_kill_idle\', is_cl);\n"
"tc_result (\'tc_no_thread_kill_vdb\', is_cl);\n"
"tc_result (\'tc_no_thread_kill_running\', is_cl);\n"
"tc_result (\'tc_deld_row_rl_rb\', is_cl);\n"
"tc_result (\'tc_blob_read\', is_cl);\n"
"tc_result (\'tc_blob_write\', is_cl);\n"
"tc_result (\'tc_blob_ra\', is_cl);\n"
"tc_result (\'tc_blob_ra_size\', is_cl);\n"
"tc_result (\'tc_get_buf_failed\', is_cl);\n"
"tc_result (\'tc_read_wait_decoy\', is_cl);\n"
"tc_result (\'tc_read_absent_while_finalize\', is_cl);\n"
"tc_result (\'tc_read_wait_while_ra_finding_buf\', is_cl);\n"
"tc_result (\'tc_unregister_enter\', is_cl);\n"
"tc_result (\'tc_autocompact_split\', is_cl);\n"
"tc_result (\'tc_get_buffer_while_stat\', is_cl);\n"
"tc_result (\'tc_page_fill_hash_overflow\', is_cl);\n"
"tc_result (\'tc_bp_wait_flush\', is_cl);\n"
"tc_result (\'tc_cl_keep_alives\', is_cl);\n"
"tc_result (\'tc_cl_branch_wanted_queries\', is_cl);\n"
"tc_result (\'tc_cl_branch_missed_rb\', is_cl);\n"
"tc_result (\'tc_cl_keep_alive_timeouts\', is_cl);\n"
"tc_result (\'tc_cl_deadlocks\', is_cl);\n"
"tc_result (\'tc_cl_wait_queries\', is_cl);\n"
"tc_result (\'tc_cl_kill_1pc\', is_cl);\n"
"tc_result (\'tc_cl_kill_2pc\', is_cl);\n"
"}\n"
"--src system.sql:5052\n";

static const char *proc95 = 
"create procedure cl_exec_srv (in str varchar, in params any)\n"
"{\n"
"declare st, msg varchar;\n"
"st := \'00000\';\n"
"exec (str, st, msg, params);\n"
"if (st <> \'00000\') signal (st, msg);\n"
"}\n"
"--src system.sql:5154\n";

static const char *proc96 = 
"create procedure daq_results (in daq any)\n"
"{\n"
"declare r any;\n"
"for (;;)\n"
"{\n"
"r := daq_next (daq);\n"
"if (0 = r)\n"
"return;\n"
"\n"
"if (length (r) >2 and isarray (r[2]) and r[2][0] = 3)\n"
"{\n"
"declare err any;\n"
"err := r[2][1];\n"
"if (isarray (err))\n"
"signal (err[1], err[2]);\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:5164\n";

static const char *proc97 = 
"create procedure cl_all_hosts ()\n"
"{\n"
"declare map, inx, hosts any;\n"
"map := cl_control (0, \'cl_host_map\');\n"
"hosts := vector ();\n"
"for (inx := 0; inx < length (map); inx := inx + 1)\n"
"{\n"
"if (map[inx] <> 1 and map[inx] <> 7)\n"
"hosts := vector_concat (hosts, vector (inx));\n"
"}\n"
"return hosts;\n"
"}\n"
"--src system.sql:5185\n";

static const char *proc98 = 
"create procedure cl_exec (in str varchar, in params any := null, in txn int := 0, in hosts any := null, in delay float := null, in best_effort int := 0,\n"
"in control int := 0, in as_read int := 0)\n"
"{\n"
"declare d, flags any;\n"
"if (0 = txn)\n"
"commit work;\n"
"if (sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"declare st, msg varchar;\n"
"st := \'00000\';\n"
"exec (str, st, msg, params);\n"
"if (st <> \'00000\')\n"
"signal (st, msg);\n"
"return;\n"
"}\n"
"if (params is null)\n"
"params := vector ();\n"
"d := daq (txn);\n"
"if (delay is not null)\n"
"delay (delay);\n"
"if (as_read and hosts is null)\n"
"{\n"
"hosts := cl_all_hosts ();\n"
"flags := 0;\n"
"}\n"
"else if (as_read)\n"
"flags := 0;\n"
"else\n"
"flags := 1;\n"
"if (best_effort)\n"
"flags := bit_or (flags, 32);\n"
"if (control)\n"
"flags := bit_or (flags, 64);\n"
"if (hosts is null)\n"
"daq_call (d, \'DB.DBA.SYS_COLS\', \'SYS_COLS_BY_NAME\', \'DB.DBA.CL_EXEC_SRV\', vector (str, params), flags);\n"
"else\n"
"daq_call (d, \'__ALL\', hosts, \'DB.DBA.CL_EXEC_SRV\', vector (str, params), flags);\n"
"daq_results (d);\n"
"}\n"
"--src system.sql:5199\n";

static const char *proc99 = 
"create procedure CL_STAT_SRV (in x varchar, in k varchar, in fl varchar)\n"
"{\n"
"if (k is not null)\n"
"return key_stat (x, k, fl);\n"
"return sys_stat (x);\n"
"}\n"
"--src system.sql:5240\n";

static const char *proc100 = 
"create procedure daq_next_or_error (in daq any)\n"
"{\n"
"declare r, err any;\n"
"r := daq_next (daq);\n"
"if (0 = r)\n"
"return null;\n"
"if (length (r) >2 and isarray (r[2]) and r[2][0] = 3)\n"
"{\n"
"declare err any;\n"
"err := r[2][1];\n"
"if (isarray (err))\n"
"signal (err[2], err[2]);\n"
"}\n"
"\n"
"return r[2][1];\n"
"}\n"
"--src system.sql:5249\n";

static const char *proc101 = 
"create procedure cl_sys_stat (in x varchar, in  k varchar := null, in fl varchar := null)\n"
"{\n"
"declare daq, r any;\n"
"declare s int;\n"
"if (1 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"if (k is null)\n"
"return sys_stat (x);\n"
"else\n"
"return key_stat (x, k, fl);\n"
"}\n"
"daq := daq (0);\n"
"daq_call (daq, \'DB.DBA.SYS_COLS\', \'SYS_COLS_BY_NAME\', \'DB.DBA.CL_STAT_SRV\', vector (x, k, fl), 1);\n"
"while (r:= daq_next (daq))\n"
"{\n"
"if (length (r) >2 and isarray (r[2]) and r[2][0] = 3)\n"
"{\n"
"declare err any;\n"
"err := r[2][1];\n"
"if (isarray (err))\n"
"signal (err[2], err[2]);\n"
"}\n"
"s := s + r[2][1];\n"
"}\n"
"return s;\n"
"}\n"
"--src system.sql:5267\n";

static const char *proc102 = 
"create procedure IF_CLUSTER (in str varchar)\n"
"{\n"
"if (sys_stat (\'cl_run_local_only\') <> 2) return;\n"
"str := trim (str, \';\');\n"
"exec (str);\n"
"}\n"
"--src system.sql:5295\n";

static const char *proc103 = 
"create procedure IF_NO_CLUSTER (in str varchar)\n"
"{\n"
"if (sys_stat (\'cl_run_local_only\') = 2) return;\n"
"str := trim (str, \';\');\n"
"exec (str);\n"
"}\n"
"--src system.sql:5303\n";

static const char *proc104 = 
"create procedure CL_START_SRV ()\n"
"{\n"
"return sys_stat (\'db_exists\');\n"
"}\n"
"--src system.sql:5312\n";

static const char *proc105 = 
"create procedure cl_init_seqs ()\n"
"{\n"
"\n"
"declare seqs, name any;\n"
"declare inx, s_next int;\n"
"seqs := get_all_sequences ();\n"
"for (inx := 0; inx < length (seqs); inx := inx + 2)\n"
"{\n"
"name := cast (seqs[inx] as varchar);\n"
"if (name not like \'__MAX__%\' and name not like \'__NEXT__%\')\n"
"{\n"
"s_next := __sequence_set (sprintf (\'__NEXT__%s\', name), 0, 2);\n"
"sequence_set (sprintf (\'__MAX__%s\', name), 0, 1);\n"
"if (0 = s_next)\n"
"{\n"
"__sequence_set (sprintf (\'__NEXT__%s\', name), sequence_set (name, 0, 2), 1);\n"
"}\n"
"}\n"
"}\n"
"commit work;\n"
"}\n"
"--src system.sql:5318\n";

static const char *proc106 = 
"create procedure cl_reset_seqs ()\n"
"{\n"
"\n"
"declare seqs, name any;\n"
"declare inx, s_next int;\n"
"seqs := get_all_sequences ();\n"
"for (inx := 0; inx < length (seqs); inx := inx + 2)\n"
"{\n"
"name := cast (seqs[inx] as varchar);\n"
"if (name not like \'__MAX__%\' and name not like \'__NEXT__%\')\n"
"{\n"
"__sequence_set (sprintf (\'__MAX__%s\', name), 0, 0);\n"
"}\n"
"}\n"
"rdf_seq_init_srv ();\n"
"}\n"
"--src system.sql:5342\n";

static const char *proc107 = 
"create procedure cl_new_db ()\n"
"{\n"
"cl_init_seqs ();\n"
"cl_control (sys_stat (\'cl_this_host\'), \'ch_status\', 0);\n"
"cl_wait_start ();\n"
"log_message (\'new clustered database:Init of RDF\');\n"
"rdf_dpipes ();\n"
"rdf_cl_init ();\n"
"DB.DBA.RDF_CREATE_SPARQL_ROLES_CL ();\n"
"WS.WS.SYS_DAV_INIT ();\n"
"cl_exec (\'checkpoint\');\n"
"}\n"
"--src system.sql:5360\n";

static const char *proc108 = 
"create procedure cl_node_started ()\n"
"{\n"
"if (sys_stat (\'cl_run_local_only\') = 1)\n"
"return;\n"
"if (sys_stat (\'cl_this_host\') = sys_stat (\'cl_master_host\'))\n"
"{\n"
"if ((select cl_map from sys_cluster where cl_name = \'__ALL\') is null)\n"
"{\n"
"cl_control (sys_stat (\'cl_this_host\'), \'ch_status\', 0);\n"
"cl_wait_start ();\n"
"delete from sys_cluster where cl_name = \'__ALL\';\n"
"insert into sys_cluster (cl_name, cl_HOSTS, cl_map) values (\'__ALL\', null, clm_map (\'__ALL\'));\n"
"commit work;\n"
"cl_exec (\'cl_read_cluster (\'\'__ALL\'\')\');\n"
"}\n"
"if (0 = sys_stat (\'db_exists\'))\n"
"{\n"
"cl_new_db ();\n"
"}\n"
"}\n"
"}\n"
"--src system.sql:5375\n";

static const char *proc109 = 
"create procedure ddl_ren_k_new_name (in kn varchar, in o varchar, in n varchar)\n"
"{\n"
"if (name_part (kn, 2) = name_part (o, 2))\n"
"return name_part (n, 2);\n"
"else\n"
"return kn;\n"
"}\n"
"--src system.sql:5399\n";

static const char *proc110 = 
"create procedure DB.DBA.DDL_TABLE_RENAMED (in o varchar, in n varchar)\n"
"{\n"
"__ddl_table_renamed (o, n);\n"
"log_text (\'__ddl_table_renamed (?, ?)\', o, n);\n"
"}\n"
"--src system.sql:5409\n";

static const char *proc111 = 
"create procedure rename_table (in n varchar, in o varchar)\n"
"{\n"
"if (exists (select 1 from SYS_KEYS where KEY_TABLE = n)) {\n"
"signal (\'42S01\', \'Table already exists in rename table.\', \'SR277\');\n"
"}\n"
"ddl_owner_check (o);\n"
"if (exists (select 1 from SYS_VIEWS where V_NAME = o))\n"
"signal (\'42S02\', \'ALTER TABLE not supported for views. Drop the view and recreate it instead.\', \'SR327\');\n"
"if (not (exists (select 1 from SYS_KEYS where KEY_TABLE = o))) {\n"
"signal (\'42S02\', \'Bad table in rename table.\', \'SR278\');\n"
"}\n"
"update SYS_COLS set \"TABLE\" = n where \"TABLE\" = o;\n"
"for select COL_CHECK, \"COLUMN\" as COL from SYS_COLS where \"TABLE\" = n do {\n"
"declare num int;\n"
"if (strstr (COL_CHECK, \'I\') is not null)\n"
"{\n"
"num := GET_IDENTITY_COLUMN (o, COL, 1);\n"
"SET_IDENTITY_COLUMN (n, COL, num);\n"
"}\n"
"}\n"
"update SYS_KEYS set KEY_TABLE = n where KEY_TABLE = o;\n"
"update SYS_KEYS set KEY_NAME = n where KEY_TABLE = n and KEY_NAME = o;\n"
"update SYS_FOREIGN_KEYS set PK_TABLE = n where PK_TABLE = o;\n"
"update SYS_FOREIGN_KEYS set FK_TABLE = n where FK_TABLE = o;\n"
"\n"
"update SYS_PARTITION set PART_TABLE = n, PART_KEY = ddl_ren_k_new_name (PART_KEY, o, n),\n"
"PART_DATA = vector (PART_DATA[0], n, ddl_ren_k_new_name (PART_KEY, o, n), PART_DATA[3], PART_DATA[4])\n"
"where PART_TABLE = o;\n"
"cl_exec (\'DB.DBA.ddl_table_renamed (?, ?)\', vector (o, n), txn => 1);\n"
"}\n"
"--src system.sql:5417\n";

static const char *proc112 = 
"create procedure VT_GET_CLUSTER (in tablename varchar, in k varchar)\n"
"{\n"
"declare ret any;\n"
"if (k is null)\n"
"return \'\';\n"
"k := name_part (k, 2);\n"
"ret := coalesce ((select PART_CLUSTER from DB.DBA.SYS_PARTITION where PART_TABLE = tablename and PART_KEY = k), \'\');\n"
"if (ret = \'__ALL\')\n"
"return \'\';\n"
"return \' cluster \' || ret;\n"
"}\n"
"--src system.sql:5450\n";

static const char *proc113 = 
"create procedure VT_GET_CLUSTER_COL_OPTS (in tablename varchar, in k varchar, in col varchar)\n"
"{\n"
"declare opts, ret any;\n"
"declare tmp any;\n"
"if (k is null)\n"
"return \'\';\n"
"ret := \'\';\n"
"k := name_part (k, 2);\n"
"opts := (select PART_DATA from DB.DBA.SYS_PARTITION where PART_TABLE = tablename and PART_KEY = k);\n"
"if (not isarray (opts))\n"
"return \'\';\n"
"if (length (opts) < 5)\n"
"return \'\';\n"
"if (length (opts[4]) < 1)\n"
"return \'\';\n"
"tmp := opts[4][0];\n"
"if (cast (tmp [1] as varchar) <> col)\n"
"return \'\';\n"
"if (tmp [2] = 1)\n"
"{\n"
"if (tmp[3] <> 65535)\n"
"ret := sprintf (\'(0hex%x)\', tmp[3]);\n"
"}\n"
"else if (tmp [2] = 3)\n"
"{\n"
"if (tmp[3] <> 0)\n"
"{\n"
"ret := sprintf (\'(%d, 0hex%x)\', tmp[3], tmp[4]);\n"
"}\n"
"}\n"
"return ret;\n"
"}\n"
"--src system.sql:5463\n";

static const char *proc114 = 
"create procedure\n"
"DB.DBA.SYS_SQL_VECTOR_PRINT (in in_vector any)\n"
"{\n"
"declare len, idx integer;\n"
"declare temp varchar;\n"
"declare res varchar;\n"
"\n"
"if (isstring (in_vector))\n"
"in_vector := vector (in_vector);\n"
"\n"
"len := length (in_vector);\n"
"res:=\'\';\n"
"idx := 0;\n"
"while ( idx < len ) {\n"
"if (idx > 0 )\n"
"res := concat (res, \', \');\n"
"temp := aref (in_vector, idx);\n"
"res := concat (res, SYS_SQL_VAL_PRINT (temp));\n"
"idx := idx+1;\n"
"}\n"
"return (res);\n"
"}\n"
"--src system.sql:5497\n";

static const char *proc115 = 
"create procedure\n"
"DB.DBA.SYS_SQL_VAL_PRINT (in v any)\n"
"{\n"
"\n"
"if (isstring (v))\n"
"return sprintf (\'\\\'%S\\\'\', replace (v, \'\\\\\', \'\\\\\\\\\'));\n"
"else if (v is null)\n"
"return \'NULL\';\n"
"else if (isinteger (v))\n"
"return sprintf (\'%d\', v);\n"
"else if (isfloat (v) or isdouble (v))\n"
"return sprintf (\'%f\', v);\n"
"else if (isnumeric (v))\n"
"return cast (v as varchar);\n"
"else if (__tag (v) = 193)\n"
"{\n"
"return concat (\'vector (\',SYS_SQL_VECTOR_PRINT (v),\')\');\n"
"}\n"
"else\n"
"signal (\'22023\', sprintf(\'Unsupported type %d\', __tag (v)));\n"
"}\n"
"--src system.sql:5521\n";

static const char *proc116 = 
"create procedure view_from_tbl (in _dir varchar, in _tbls any)\n"
"{\n"
"declare create_class_stmt, create_view_stmt, prefix, ns, uriqa_str, ret any;\n"
"\n"
"ret := make_array (2, \'any\');\n"
"prefix := \'SPARQL\\n\';\n"
"\n"
"ns := sprintf (\'prefix %s: <http://%s/%s#>\\n\', _dir, cfg_item_value (virtuoso_ini_path (), \'URIQA\', \'DefaultHost\'), _dir);\n"
"ns := ns || \'prefix northwind: <http://demo.openlinksw.com/schemas/northwind#>\n"
"prefix demo: <http://www.openlinksw.com/schemas/demo#>\n"
"prefix oplsioc: <http://www.openlinksw.com/schemas/oplsioc#>\n"
"prefix sioc: <http://rdfs.org/sioc/ns#>\n"
"prefix foaf: <http://xmlns.com/foaf/0.1/>\n"
"prefix wgs: <http://www.w3.org/2003/01/geo/wgs84_pos#>\\n\';\n"
"\n"
"uriqa_str := cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\');\n"
"\n"
"create_class_stmt := \'\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"create_class_stmt := create_class_stmt || view_create_class (_tbls[xx], uriqa_str, _dir);\n"
"\n"
"create_class_stmt := prefix || ns || create_class_stmt;\n"
"\n"
"aset (ret, 0, create_class_stmt);\n"
"\n"
"create_view_stmt := view_create_view (_tbls, _dir);\n"
"create_view_stmt := prefix || ns || create_view_stmt;\n"
"\n"
"aset (ret, 1, create_view_stmt);\n"
"\n"
"return ret;\n"
"}\n"
"--src system.sql:5547\n";

static const char *proc117 = 
"create procedure view_create_view (in _tbls any, in _dir varchar)\n"
"{\n"
"declare ret, qual, qual_l, tbl_name, tbl_name_l, pks, pk_text, uriqa_str any;\n"
"declare sufix, tname, tbl any;\n"
"\n"
"uriqa_str := cfg_item_value(virtuoso_ini_path(), \'URIQA\',\'DefaultHost\');\n"
"qual := name_part (_tbls[0], 0);\n"
"qual_l := lcase (qual);\n"
"\n"
"ret := \'alter quad storage virtrdf:DefaultQuadStorage\\n\';\n"
"sufix := \'_s\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"ret := ret || \' from \' || _tbls[xx] || \' as \' || lcase (name_part (_tbls[xx], 3) || sufix) || \'\\n\';\n"
"\n"
"ret := ret || view_get_where_from_foreign_key (_tbls, sufix) || \'\\n\';\n"
"\n"
"ret := ret || \' { create virtrdf:\' || qual || \'\n"
"as graph iri (\"http://\' || uriqa_str || \'/\' || qual_l || \'\") option (exclusive) \\n{ \\n\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"tbl := _tbls[xx];\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := lcase (tbl_name);\n"
"pks := view_get_primary_key (tbl);\n"
"tname := tbl_name_l || sufix;\n"
"pk_text := \'\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (pks) ; xx := xx + 1)\n"
"pk_text := tname || \'.\' || pks[xx][0] || \',\';\n"
"\n"
"pk_text := trim (pk_text, \',\');\n"
"\n"
"\n"
"ret := ret || sprintf (\'%s:%s (%s)\\n\', _dir, tbl_name_l, pk_text);\n"
"\n"
"for select \"COLUMN\" from SYS_COLS where \"TABLE\" = tbl do\n"
"{\n"
"ret := ret || sprintf (\'%s:%s %s.%s as virtrdf:%s-%s ;\\n\',\n"
"_dir, lcase(\"COLUMN\"), tname, \"COLUMN\", tbl_name_l, lcase(\"COLUMN\") );\n"
"\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS where FK_TABLE = tbl and FKCOLUMN_NAME= \"COLUMN\"\n"
"AND position (PK_TABLE, _tbls) <> 0))\n"
"{\n"
"for (select name_part (PK_TABLE, 2) as PK_TABLE_NAME, PKCOLUMN_NAME from DB.DBA.SYS_FOREIGN_KEYS\n"
"where FK_TABLE = tbl and FKCOLUMN_NAME= \"COLUMN\" AND position (PK_TABLE, _tbls) <> 0) do\n"
"{\n"
"ret := ret || sprintf (\'%s:has_%s %s:%s (%s%s.%s) as virtrdf:%s-%s_has_%s ;\\n\\n\',\n"
"_dir, lcase (PK_TABLE_NAME), _dir, PK_TABLE_NAME,\n"
"tbl_name_l, sufix, \"COLUMN\", tbl_name, tbl_name_l, lcase (PK_TABLE_NAME));\n"
"}\n"
"}\n"
"\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_FOREIGN_KEYS where PK_TABLE = tbl and FKCOLUMN_NAME= \"COLUMN\"\n"
"AND position (FK_TABLE, _tbls) <> 0))\n"
"{\n"
"for (select name_part (FK_TABLE, 2) as FK_TABLE_NAME, FKCOLUMN_NAME, PK_TABLE,\n"
"FK_TABLE, FKCOLUMN_NAME\n"
"from DB.DBA.SYS_FOREIGN_KEYS\n"
"where PK_TABLE = tbl and PKCOLUMN_NAME= \"COLUMN\" AND position (FK_TABLE, _tbls) <> 0) do\n"
"{\n"
"ret := ret || sprintf (\'%s:%s_of %s:%s (%s%s.%s) as virtrdf:%s-%s_of ;\\n\\n\',\n"
"_dir, lcase (FK_TABLE_NAME),\n"
"_dir, FK_TABLE_NAME,\n"
"FK_TABLE_NAME, sufix, view_get_pk (FK_TABLE),\n"
"lcase (name_part (PK_TABLE, 2)),\n"
"FK_TABLE_NAME);\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"ret := trim (ret, \'\\n\');\n"
"ret := trim (ret, \';\');\n"
"ret := ret || \'.\\n\\n\';\n"
"}\n"
"\n"
"ret := ret || \' } }\';\n"
"\n"
"return ret;\n"
"\n"
"}\n"
"--src system.sql:5583\n";

static const char *proc118 = 
"create procedure view_dv_to_printf_str_type (in _dv varchar)\n"
"{\n"
"if (_dv = 189 or _dv = 188) return \'%d\';\n"
"if (_dv = 182) return \'%U\';\n"
"signal (\'XXXXX\', sprintf (\'Unknown DV %i in view_dv_to_printf_str_type\', _dv));\n"
"}\n"
"--src system.sql:5672\n";

static const char *proc119 = 
"create procedure view_dv_to_sql_str_type (in _dv varchar)\n"
"{\n"
"if (_dv = 189 or _dv = 188) return \'integer\';\n"
"if (_dv = 182) return \'varchar\';\n"
"signal (\'XXXXX\', sprintf (\'Unknown DV %i\', _dv));\n"
"}\n"
"--src system.sql:5680\n";

static const char *proc120 = 
"create procedure view_create_class (in _tbl varchar, in _host varchar, in _f varchar)\n"
"{\n"
"declare ret, qual, tbl_name, tbl_name_l, pks, pk_text, sk_len any;\n"
"\n"
"qual := name_part (_tbl, 0);\n"
"tbl_name := name_part (_tbl, 3);\n"
"tbl_name_l := lcase (tbl_name);\n"
"pks := view_get_primary_key (_tbl);\n"
"\n"
"pk_text := \'\';\n"
"sk_len := \'\';\n"
"\n"
"if (length (pks) = 0)\n"
"return \'\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (pks) ; xx := xx + 1)\n"
"{\n"
"pk_text := pk_text || \'in \' || pks[xx][0] || \' \' || view_dv_to_sql_str_type(pks[xx][1]) || \' not null,\';\n"
"sk_len := sk_len || \'/\' || view_dv_to_printf_str_type (pks[xx][1]);\n"
"}\n"
"\n"
"pk_text := trim (pk_text, \',\');\n"
"sk_len  := trim (sk_len , \'/\');\n"
"\n"
"\n"
"\n"
"ret := sprintf (\'create iri class %s:%s \"http://%s/%s/%s/%s/%s#this\" (%s) . \\n\',\n"
"_f, tbl_name_l, _host, _f, tbl_name_l, pks[0][0], sk_len, pk_text);\n"
"\n"
"return ret;\n"
"}\n"
"--src system.sql:5688\n";

static const char *proc121 = 
"create procedure view_get_primary_key (in _tbl varchar)\n"
"{\n"
"return DB.DBA.REPL_PK_COLS (_tbl);\n"
"}\n"
"--src system.sql:5721\n";

static const char *proc122 = 
"create procedure view_get_pk (in _tbl varchar)\n"
"{\n"
"return DB.DBA.REPL_PK_COLS (_tbl)[0][0];\n"
"}\n"
"--src system.sql:5727\n";

static const char *proc123 = 
"create procedure view_get_where_from_foreign_key (in _tbls varchar, in _suff varchar)\n"
"{\n"
"declare ret, tbl any;\n"
"\n"
"ret := \'\';\n"
"\n"
"foreach (any tbl in _tbls) do\n"
"\n"
"for (SELECT name_part (PK_TABLE, 1) as PK_TABLE_SCHEMA, PK_TABLE,\n"
"name_part (PK_TABLE, 2) as PK_TABLE_NAME, PKCOLUMN_NAME as PK_COLUMN_NAME,\n"
"name_part (FK_TABLE, 1) as FK_TABLE_SCHEMA,\n"
"name_part (FK_TABLE, 2) as FK_TABLE_NAME, FKCOLUMN_NAME AS FK_COLUMN_NAME,\n"
"KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME\n"
"FROM DB.DBA.SYS_FOREIGN_KEYS WHERE FK_TABLE like tbl) do\n"
"\n"
"{\n"
"if (position (PK_TABLE, _tbls) <> 0)\n"
"{\n"
"ret := ret || sprintf (\' where (^{%s%s.}^.\"%s\" = ^{%s%s.}^.\"%s\") \\n\',\n"
"lcase (FK_TABLE_NAME), _suff, FK_COLUMN_NAME,\n"
"lcase (PK_TABLE_NAME), _suff, PK_COLUMN_NAME);\n"
"}\n"
"}\n"
"\n"
"return ret;\n"
"}\n"
"--src system.sql:5733\n";

static const char *proc124 = 
"create procedure text_est_text (in tb varchar)\n"
"{\n"
"declare temp, ic, tc varchar;\n"
"temp := \'\n"
"create procedure \"<q>\".\"<o>\".\"TEXT_EST_<tb>\" (in str varchar)\n"
"{\n"
"declare key_est, key_ct, rno int;\n"
"declare cr cursor for select \"<idc>\" from \"<q>\".\"<o>\".\"<tb>\" where contains (\"<tc>\", str);\n"
"key_est := key_estimate (\'\'<q>.<o>.<tb>\'\', \'\'<tb>\'\');\n"
"set isolation = \'\'uncommitted\'\';\n"
"open cr;\n"
"whenever not found goto done;\n"
"while (1)\n"
"{\n"
"fetch cr into rno;\n"
"key_ct := key_ct + 1;\n"
"if (key_ct = 100)\n"
"return cast ((( cast (key_est as double precision) / rno)  * 100) as int);\n"
"}\n"
"done: return key_ct;\n"
"}\';\n"
"temp := replace (temp, \'<q>\', name_part (tb, 0));\n"
"temp := replace (temp, \'<o>\', name_part (tb, 1));\n"
"temp := replace (temp, \'<tb>\', name_part (tb, 2));\n"
"whenever not found goto nf;\n"
"select vi_col, vi_id_col into tc, ic from sys_vt_index where vi_table = tb;\n"
"temp := replace (temp, \'<tc>\', tc);\n"
"temp := replace (temp, \'<idc>\', ic);\n"
"return temp;\n"
"nf:\n"
"signal (\'22023\', \'The table has no text index.\');\n"
"}\n"
"--src system.sql:5764\n";

static const char *proc125 = 
"create procedure CL_RANGE_WORDS_SRV (in l varchar, in h varchar, in mask varchar, in tb varchar)\n"
"{\n"
"declare md, res, msg, st any;\n"
"st := \'00000\';\n"
"exec (sprintf (\'select distinct vt_word from \"%I\".\"%I\".\"%I\" table option (no cluster) where vt_word >= ? and vt_word < ? and vt_word like ?\', name_part (tb, 0), name_part (tb, 1), name_part (tb, 2)),\n"
"msg, st, vector (l, h, mask), 1000, md, res);\n"
"if (st <> \'00000\') signal (st, msg);\n"
"return res;\n"
"}\n"
"--src system.sql:5801\n";

static const char *proc126 = 
"create procedure cl_range_words (in tb varchar, in l varchar, in h varchar, in mask varchar)\n"
"{\n"
"declare daq, r, d any;\n"
"daq := daq (0);\n"
"d := dict_new ();\n"
"daq_call (daq, \'DB.DBA.SYS_COLS\', \'SYS_COLS_BY_NAME\', \'DB.DBA.CL_RANGE_WORDS_SRV\', vector (l, h, mask, tb), 1);\n"
"while (r:= daq_next (daq))\n"
"{\n"
"if (length (r) >2 and isarray (r[2]) and r[2][0] = 3)\n"
"{\n"
"declare err any;\n"
"err := r[2][1];\n"
"if (isarray (err))\n"
"signal (err[2], err[2]);\n"
"}\n"
"foreach (any w in r[2][1]) do\n"
"dict_put (d, w[0], 1);\n"
"}\n"
"return dict_list_keys (d, 2);\n"
"}\n"
"--src system.sql:5812\n";

static const char *tbl5 = 
"create table SYS_HTTP_CLIENT_CACHE (\n"
"HCC_URI varchar,\n"
"HCC_HASH varchar,\n"
"HCC_TS timestamp,\n"
"HCC_HEADER any,\n"
"HCC_BODY long varbinary,\n"
"primary key (HCC_URI, HCC_HASH))\n";

static const char *view0 = 
"create view DB.DBA.TABLE_COLS as\n"
"select k.KEY_TABLE as \"TABLE\",\n"
"c.\"COLUMN\" as \"COLUMN\",\n"
"c.COL_ID,\n"
"c.COL_DTP,\n"
"c.COL_PREC,\n"
"c.COL_SCALE,\n"
"c.COL_DEFAULT,\n"
"c.COL_CHECK,\n"
"c.COL_NULLABLE,\n"
"c.COL_NTH,\n"
"c.COL_OPTIONS\n"
"from DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, DB.DBA.SYS_COLS c\n"
"where k.KEY_ID = kp.KP_KEY_ID and k.KEY_IS_MAIN = 1 and k.KEY_MIGRATE_TO is null and kp.KP_COL = c.COL_ID\n";

static const char *other79 = 
"grant select on DB.DBA.TABLE_COLS to public\n";
static const char *proc127 = 
"create procedure csv_load_file (in f varchar, in _from int := 0, in _to int := null, in tb varchar := null, in log_mode int := 2, in opts any := null)\n"
"{\n"
"declare s any;\n"
"s := file_open (f);\n"
"return csv_load (s, _from, _to, tb, log_mode, opts);\n"
"}\n"
"--src system.sql:5862\n";

static const char *proc128 = 
"create procedure csv_load (in s any, in _from int := 0, in _to int := null, in tb varchar := null, in log_mode int := 2, in opts any := null)\n"
"{\n"
"declare r, log_ses any;\n"
"declare stmt, enc varchar;\n"
"declare inx, old_mode, num_cols, nrows, mode, log_error int;\n"
"declare delim, quot char;\n"
"\n"
"delim := quot := enc := mode := null;\n"
"log_error := 0;\n"
"if (isvector (opts) and mod (length (opts), 2) = 0)\n"
"{\n"
"delim := get_keyword (\'csv-delimiter\', opts);\n"
"quot  := get_keyword (\'csv-quote\', opts);\n"
"enc := get_keyword (\'encoding\', opts);\n"
"mode := get_keyword (\'mode\', opts);\n"
"log_error := get_keyword (\'log\', opts, 0);\n"
"}\n"
"\n"
"stmt := csv_ins_stmt (tb, num_cols);\n"
"old_mode := log_enable (log_mode, 1);\n"
"inx := 0;\n"
"nrows  := 0;\n"
"log_ses := string_output ();\n"
"while (isvector (r := get_csv_row (s, delim, quot, enc, mode)))\n"
"{\n"
"if (inx >= _from)\n"
"{\n"
"if (length (r) = num_cols)\n"
"{\n"
"declare stat, message varchar;\n"
"stat := \'00000\';\n"
"exec (stmt, stat, message, r, vector (\'max_rows\', 0, \'use_cache\', 1));\n"
"if (stat <> \'00000\')\n"
"{\n"
"if (log_error)\n"
"{\n"
"http (sprintf (\'<error line=\"%d\"><![CDATA[%s]]></error>\', inx, message), log_ses);\n"
"}\n"
"else\n"
"{\n"
"log_message (sprintf (\'CSV import: error importing row: %d\', inx));\n"
"log_message (message);\n"
"}\n"
"}\n"
"else\n"
"nrows := nrows + 1;\n"
"}\n"
"else\n"
"{\n"
"if (log_error)\n"
"http (sprintf (\'<error line=\"%d\">different number of columns</error>\', inx), log_ses);\n"
"else\n"
"log_message (sprintf (\'CSV import: wrong number of values at line: %d\', inx));\n"
"}\n"
"}\n"
"if (inx > _to)\n"
"goto end_loop;\n"
"inx := inx + 1;\n"
"}\n"
"end_loop:;\n"
"log_enable (old_mode, 1);\n"
"if (log_error)\n"
"return vector (nrows, log_ses);\n"
"return nrows;\n"
"}\n"
"--src system.sql:5870\n";

static const char *proc129 = 
"create procedure csv_parse (in s any, in cb varchar, inout cbd any, in _from int := 0, in _to int := null, in opts any := null)\n"
"{\n"
"declare r any;\n"
"declare inx, mode int;\n"
"declare delim, quot, enc char;\n"
"\n"
"delim := quot := enc := mode := null;\n"
"if (isvector (opts) and mod (length (opts), 2) = 0)\n"
"{\n"
"delim := get_keyword (\'csv-delimiter\', opts);\n"
"quot  := get_keyword (\'csv-quote\', opts);\n"
"enc := get_keyword (\'encoding\', opts);\n"
"mode := get_keyword (\'mode\', opts);\n"
"}\n"
"\n"
"inx := 0;\n"
"while (isvector (r := get_csv_row (s, delim, quot, enc, mode)))\n"
"{\n"
"if (inx >= _from)\n"
"call (cb) (r, inx, cbd);\n"
"inx := inx + 1;\n"
"if (inx > _to)\n"
"goto end_loop;\n"
"}\n"
"end_loop:;\n"
"return inx;\n"
"}\n"
"--src system.sql:5937\n";

static const char *proc130 = 
"create procedure csv_ins_stmt (in tb varchar, out num_cols int)\n"
"{\n"
"declare ss any;\n"
"declare cols any;\n"
"declare i int;\n"
"tb := complete_table_name (tb, 0);\n"
"cols := vector ();\n"
"for select \"COLUMN\" as col from SYS_COLS where \"TABLE\" = tb and \"COLUMN\" <> \'_IDN\' and COL_CHECK <> \'I\' order by COL_ID do\n"
"{\n"
"cols := vector_concat (cols, vector (col));\n"
"}\n"
"if (length (cols) = 0)\n"
"signal (\'22023\', \'No such table\');\n"
"ss := string_output ();\n"
"http (sprintf (\'INSERT INTO \"%I\".\"%I\".\"%I\" (\',\n"
"name_part (tb, 0),\n"
"name_part (tb, 1),\n"
"name_part (tb, 2)\n"
"), ss);\n"
"for (i := 0; i < length (cols); i := i + 1)\n"
"{\n"
"http (sprintf (\'\"%I\" \', cols[i]), ss);\n"
"if (i < length (cols) - 1)\n"
"http (\', \', ss);\n"
"}\n"
"http (\') values (\', ss);\n"
"for (i := 0; i < length (cols); i := i + 1)\n"
"{\n"
"http (\' ?\', ss);\n"
"if (i < length (cols) - 1)\n"
"http (\',\', ss);\n"
"}\n"
"http (\')\', ss);\n"
"num_cols := length (cols);\n"
"return string_output_string (ss);\n"
"}\n"
"--src system.sql:5966\n";

static const char *proc131 = 
"create procedure csv_file_header_check (in f any, in num_to_check int := 10)\n"
"{\n"
"declare h, r, s, i any;\n"
"s := file_open (f);\n"
"h := get_csv_row (s);\n"
"if (not isvector (h))\n"
"return 0;\n"
"for (i := 0; i < num_to_check; i := i + 1)\n"
"{\n"
"r := get_csv_row (s);\n"
"if (not isvector (r) or length (r) <> length (h))\n"
"return 0;\n"
"}\n"
"return h;\n"
"}\n"
"--src system.sql:6004\n";

static const char *proc132 = 
"create procedure csv_table_def (in f varchar)\n"
"{\n"
"declare head any;\n"
"declare s, r, ss any;\n"
"declare i int;\n"
"\n"
"if (not csv_file_header_check (f))\n"
"signal (\'22023\', \'Cannot guess the table definition\');\n"
"\n"
"s := file_open (f);\n"
"head := get_csv_row (s);\n"
"r := get_csv_row (s);\n"
"ss := string_output ();\n"
"http (sprintf (\'CREATE TABLE \"%I\" ( \\n\', SYS_ALFANUM_NAME (f)), ss);\n"
"for (i := 0; i < length (head); i := i + 1)\n"
"{\n"
"http (sprintf (\'\\t\"%I\" %s\', SYS_ALFANUM_NAME (head[i]), dv_type_title (__tag (r[i]))), ss);\n"
"if (i < length (head) - 1)\n"
"http (\', \\n\', ss);\n"
"}\n"
"http (\')\', ss);\n"
"return string_output_string (ss);\n"
"}\n"
"--src system.sql:6021\n";

static const char *proc133 = 
"create procedure csv_cols_def (in f varchar)\n"
"{\n"
"declare head any;\n"
"declare s, r, ss, vec any;\n"
"declare i int;\n"
"\n"
"if (not csv_file_header_check (f))\n"
"signal (\'22023\', \'Cannot guess the table definition\');\n"
"\n"
"s := file_open (f);\n"
"head := get_csv_row (s);\n"
"r := get_csv_row (s);\n"
"vec := vector ();\n"
"for (i := 0; i < length (head); i := i + 1)\n"
"{\n"
"vec := vector_concat (vec, vector (vector (SYS_ALFANUM_NAME (head[i]), dv_type_title (__tag (r[i])))));\n"
"}\n"
"return vec;\n"
"}\n"
"--src system.sql:6046\n";

/* system2.sql */

static const char *proc134 = 
"create procedure DB.DBA.SYS_INDEX_SPACE_STATS_PROC ()\n"
"{\n"
"declare ISS_KEY_ID, ISS_NROWS, ISS_ROW_BYTES, ISS_BLOB_PAGES, ISS_ROW_PAGES integer;\n"
"\n"
"result_names (ISS_KEY_ID, ISS_NROWS, ISS_ROW_BYTES, ISS_BLOB_PAGES, ISS_ROW_PAGES);\n"
"\n"
"declare _res any;\n"
"_res := sys_index_space_usage ();\n"
"\n"
"if (isarray (_res))\n"
"{\n"
"declare _inx, _len integer;\n"
"_inx := 0;\n"
"_len := length (_res);\n"
"\n"
"while (_inx < _len)\n"
"{\n"
"declare _row any;\n"
"_row := _res[_inx];\n"
"\n"
"result (_row[0], _row[1], _row[2], _row[3], _row[4]);\n"
"_inx := _inx + 1;\n"
"}\n"
"}\n"
"}\n"
"--src system2.sql:22\n";

static const char *view1 = 
"create view DB.DBA.SYS_INDEX_SPACE_STATS as\n"
"select\n"
"KEY_TABLE as ISS_KEY_TABLE,\n"
"KEY_NAME as ISS_KEY_NAME,\n"
"ISS_KEY_ID,\n"
"ISS_NROWS,\n"
"ISS_ROW_BYTES,\n"
"ISS_BLOB_PAGES,\n"
"ISS_ROW_PAGES,\n"
"ISS_ROW_PAGES + ISS_BLOB_PAGES as ISS_PAGES\n"
"from\n"
"DB.DBA.SYS_INDEX_SPACE_STATS_PROC () (\n"
"ISS_KEY_ID integer,\n"
"ISS_NROWS integer,\n"
"ISS_ROW_BYTES integer,\n"
"ISS_BLOB_PAGES integer,\n"
"ISS_ROW_PAGES integer) _tmp,\n"
"DB.DBA.SYS_KEYS table option (order)\n"
"where\n"
"ISS_KEY_ID = KEY_ID\n";

static const char *proc135 = 
" create procedure DB.DBA.__VD_GET_SQLSTATS_COUNT (in _ds_dsn varchar, in _remote_name varchar)\n"
"{\n"
"declare exit handler for sqlstate \'*\' { return NULL; };\n"
"declare stats any;\n"
"stats := sql_statistics (_ds_dsn,\n"
"name_part (_remote_name, 0, NULL),\n"
"name_part (_remote_name, 1, NULL),\n"
"name_part (_remote_name, 2, NULL),\n"
"1,\n"
"0);\n"
"\n"
"if (isarray (stats))\n"
"{\n"
"declare inx, len integer;\n"
"len := length (stats);\n"
"inx := 0;\n"
"while (inx < len)\n"
"{\n"
"declare stat any;\n"
"declare stat_type, stat_cardinality integer;\n"
"stat := stats[inx];\n"
"\n"
"stat_type := stat[6];\n"
"stat_cardinality := stat[10];\n"
"if (stat_type = 0 and stat_cardinality is not null)\n"
"return stat_cardinality;\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"return NULL;\n"
"}\n"
"--src system2.sql:72\n";

static const char *proc136 = 
" create procedure DB.DBA.VD_STATISTICS (in _dsn varchar := \'%\', in vd_table_mask varchar := \'%\')\n"
"{\n"
"declare _ds_dsn, _ds_conn_str any;\n"
"declare changed_tables any;\n"
"declare cr cursor for\n"
"SELECT DS_DSN, deserialize (DS_CONN_STR) from DB.DBA.SYS_DATA_SOURCE where DS_DSN like _dsn;\n"
"\n"
"whenever NOT FOUND goto done;\n"
"\n"
"changed_tables := vector ();\n"
"\n"
"open cr (exclusive, prefetch 1);\n"
"while (1 = 1)\n"
"{\n"
"declare _pos integer;\n"
"declare _rpc_time float;\n"
"\n"
"fetch cr into _ds_dsn, _ds_conn_str;\n"
"\n"
"_rpc_time := vdd_measure_rpc_time (_ds_dsn);\n"
"\n"
"_pos := position (-200, _ds_conn_str, 0, 2);\n"
"if (_pos > 0)\n"
"aset (_ds_conn_str, _pos, _rpc_time);\n"
"else\n"
"_ds_conn_str := vector_concat (_ds_conn_str, vector (-200, _rpc_time));\n"
"\n"
"update DB.DBA.SYS_DATA_SOURCE set DS_CONN_STR = serialize (_ds_conn_str)\n"
"where current of cr;\n"
"\n"
"for select RT_REMOTE_NAME, RT_NAME from SYS_REMOTE_TABLE\n"
"where RT_DSN = _ds_dsn and RT_NAME like vd_table_mask do\n"
"{\n"
"declare exit handler for sqlstate \'*\' { ; };\n"
"declare stats_updated integer;\n"
"declare stat_cardinality integer;\n"
"\n"
"stats_updated := 0;\n"
"\n"
"stat_cardinality := DB.DBA.__VD_GET_SQLSTATS_COUNT (_ds_dsn, RT_REMOTE_NAME);\n"
"if (stat_cardinality is not null)\n"
"{\n"
"insert replacing SYS_COL_STAT\n"
"(CS_TABLE, CS_COL, CS_N_DISTINCT, CS_MIN, CS_MAX,\n"
"CS_AVG_LEN,\n"
"CS_N_VALUES, CS_N_ROWS)\n"
"select\n"
"KEY_TABLE, \"COLUMN\", stat_cardinality, NULL, NULL,\n"
"(case when COL_PREC = 0 then 30\n"
"when dv_type_title (COL_DTP) like \'LONG %\' then 30 else COL_PREC end),\n"
"stat_cardinality, stat_cardinality\n"
"from\n"
"SYS_COLS, SYS_KEYS, SYS_KEY_PARTS\n"
"where\n"
"KEY_IS_MAIN = 1 and\n"
"KEY_MIGRATE_TO is NULL and\n"
"KEY_SUPER_ID = KEY_ID and\n"
"KP_KEY_ID = KEY_ID and\n"
"KP_COL = COL_ID and\n"
"KEY_TABLE = RT_NAME;\n"
"\n"
"if (row_count () > 0)\n"
"stats_updated := 1;\n"
"}\n"
"if (stats_updated)\n"
"changed_tables := vector_concat (changed_tables, vector (RT_NAME));\n"
"}\n"
"}\n"
"done:\n"
"close cr;\n"
"declare inx, len integer;\n"
"inx := 0;\n"
"len := length (changed_tables);\n"
"while (inx < len)\n"
"{\n"
"__ddl_changed (changed_tables[inx]);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src system2.sql:106\n";

static const char *proc137 = 
" create procedure DB.DBA.TABLE_SET_POLICY (in _tb varchar, in _proc varchar, in _type varchar := \'IDUS\')\n"
"{\n"
"declare tb_name, proc_name varchar;\n"
"declare is_view integer;\n"
"\n"
"tb_name := complete_table_name (_tb, 1);\n"
"if (1 <> (select count(*) from DB.DBA.SYS_KEYS\n"
"where\n"
"KEY_TABLE = tb_name and\n"
"KEY_IS_MAIN = 1 and\n"
"KEY_MIGRATE_TO is null))\n"
"signal (\'22023\', sprintf (\'No table or duplicate table %s in TABLE_SET_POLICY\', _tb), \'SR382\');\n"
"\n"
"if (name_part (tb_name, 1) <> user and user <> \'dba\')\n"
"signal (\'42S02\', sprintf (\'Access denied for table %s in TABLE_SET_POLICY\', _tb), \'SR383\');\n"
"\n"
"proc_name := complete_proc_name (_proc, 1);\n"
"if (not isstring (__proc_exists (proc_name)))\n"
"signal (\'22023\', sprintf (\'The procedure %s does not exist in TABLE_SET_POLICY\', _proc), \'SR384\');\n"
"\n"
"is_view := case when exists (select 1 from SYS_VIEWS where V_NAME = tb_name) then 1 else 0 end;\n"
"\n"
"declare _stat, _msg varchar;\n"
"if (exec (\'call (?) (?, ?)\', _stat, _msg, vector (proc_name, tb_name, \'S\')))\n"
"{\n"
"signal (\'42000\', sprintf (\'Trying in TABLE_SET_POLICY the procedure %s yielded an error : [%s]%s\', proc_name, _stat, _msg), \'SR385\');\n"
"}\n"
"declare inx, len integer;\n"
"\n"
"len := length (_type);\n"
"inx := 0;\n"
"while (inx < len)\n"
"{\n"
"declare opt varchar;\n"
"opt := upper (chr (_type[inx]));\n"
"\n"
"if (opt not in (\'I\', \'D\', \'U\', \'S\'))\n"
"signal (\'22023\', sprintf (\'Invalid option %s specified in TABLE_SET_POLICY\', opt), \'SR386\');\n"
"\n"
"if (is_view and opt <> \'S\')\n"
"signal (\'22023\', sprintf (\n"
"\'insert/delete/update policies must be declared for an actual table, \' ||\n"
"\'not a view %s in TABLE_SET_POLICY\', tb_name), \'SR391\');\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_RLS_POLICY where RLSP_TABLE = tb_name and RLSP_OP = proc_name))\n"
"signal (\'22023\',\n"
"sprintf (\'Procedure for option %s for table %s already defined in TABLE_SET_POLICY. Drop it first\',\n"
"opt, _tb), \'SR387\');\n"
"\n"
"insert into DB.DBA.SYS_RLS_POLICY (RLSP_TABLE, RLSP_FUNC, RLSP_OP)\n"
"values (tb_name, proc_name, opt);\n"
"\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"__ddl_changed (tb_name);\n"
"}\n"
"--src system2.sql:189\n";

static const char *proc138 = 
" create procedure DB.DBA.TABLE_DROP_POLICY (in _tb varchar, in _type varchar := \'IUDS\')\n"
"{\n"
"declare tb_name varchar;\n"
"\n"
"tb_name := complete_table_name (_tb, 1);\n"
"if (1 <> (select count(*) from DB.DBA.SYS_KEYS\n"
"where\n"
"KEY_TABLE = tb_name and\n"
"KEY_IS_MAIN = 1 and\n"
"KEY_MIGRATE_TO is null))\n"
"signal (\'22023\', sprintf (\'No table or duplicate table %s in TABLE_DROP_POLICY\', _tb), \'SR388\');\n"
"\n"
"if (name_part (tb_name, 1) <> user and user <> \'dba\')\n"
"signal (\'42S02\', sprintf (\'Access denied for table %s in TABLE_DROP_POLICY\', _tb), \'SR389\');\n"
"\n"
"delete from DB.DBA.SYS_RLS_POLICY where RLSP_TABLE = tb_name and strchr (upper (_type), RLSP_OP) is not NULL;\n"
"\n"
"if (row_count () > 0)\n"
"__ddl_changed (tb_name);\n"
"}\n"
"--src system2.sql:249\n";

static const char *view2 = 
"create view ALL_COL_STAT as\n"
"select * from DB.DBA.SYS_COL_STAT where __any_grants (CS_TABLE)\n";

static const char *other80 = 
"grant select on ALL_COL_STAT to public\n";
static const char *view3 = 
"create view USER_COL_STAT as\n"
"select * from DB.DBA.SYS_COL_STAT where name_part (CS_TABLE, 1, NULL) = case user when \'dba\' then \'DBA\' else user end\n";

static const char *other81 = 
"grant select on USER_COL_STAT to public\n";
static const char *view4 = 
"create view ALL_COL_HIST as\n"
"select * from DB.DBA.SYS_COL_HIST where __any_grants (CH_TABLE)\n";

static const char *other82 = 
"grant select on ALL_COL_HIST to public\n";
static const char *view5 = 
"create view USER_COL_HIST as\n"
"select * from DB.DBA.SYS_COL_HIST where name_part (CH_TABLE, 1, NULL) = case user when \'dba\' then \'DBA\' else user end\n";

static const char *other83 = 
"grant select on USER_COL_HIST to public\n";
static const char *proc139 = 
"create procedure SINV_CREATE_INVERSE (in _SINVM_NAME_IN varchar, in _SINV_INVERSE any, in _SINVM_FLAGS integer)\n"
"{\n"
"declare _SINVM_NAME varchar;\n"
"if (isstring (_SINV_INVERSE))\n"
"{\n"
"_SINV_INVERSE := vector (_SINV_INVERSE);\n"
"}\n"
"else if (length (_SINV_INVERSE) > 1)\n"
"_SINVM_FLAGS := 0;\n"
"\n"
"declare inx integer;\n"
"inx := 0;\n"
"\n"
"_SINVM_NAME := fix_identifier_case (_SINVM_NAME_IN);\n"
"_SINVM_NAME := __proc_exists (_SINVM_NAME, 2);\n"
"if (not isstring (_SINVM_NAME))\n"
"{\n"
"_SINVM_NAME := __proc_exists (_SINVM_NAME_IN, 1);\n"
"if (not isstring (_SINVM_NAME))\n"
"signal (\'22023\', sprintf (\n"
"\'Non-existent function %s passed as argument 1 to SINV_CREATE_INVERSE\', _SINVM_NAME_IN),\n"
"\'SR456\');\n"
"}\n"
"\n"
"declare _inverse varchar;\n"
"foreach (varchar _inverse_in in _SINV_INVERSE) do\n"
"{\n"
"_inverse := fix_identifier_case (_inverse_in);\n"
"_inverse := __proc_exists (_inverse, 2);\n"
"if (not isstring (_inverse))\n"
"{\n"
"_inverse := fix_identifier_case (_inverse_in);\n"
"_inverse := __proc_exists (_inverse, 1);\n"
"if (not isstring (_inverse))\n"
"signal (\'22023\', sprintf (\n"
"\'Non-existent function %s passed as %dth value in argument 2 to SINV_CREATE_INVERSE\',\n"
"_SINVM_NAME_IN, inx + 1),\n"
"\'SR457\');\n"
"}\n"
"\n"
"insert into SYS_SQL_INVERSE (SINV_FUNCTION, SINV_ARGUMENT, SINV_INVERSE, SINV_FLAGS)\n"
"values (_SINVM_NAME, inx, _inverse, _SINVM_FLAGS);\n"
"inx := inx + 1;\n"
"}\n"
"sinv_read_invers_sys (_SINVM_NAME);\n"
"if (inx = 1)\n"
"{\n"
"insert into SYS_SQL_INVERSE (SINV_FUNCTION, SINV_ARGUMENT, SINV_INVERSE, SINV_FLAGS)\n"
"values (_inverse, 0, _SINVM_NAME, _SINVM_FLAGS);\n"
"sinv_read_invers_sys (_inverse);\n"
"}\n"
"}\n"
"--src system2.sql:299\n";

static const char *proc140 = 
"create procedure SINV_DROP_INVERSE (in _SINVM_NAME_IN varchar)\n"
"{\n"
"declare _SINVM_NAME varchar;\n"
"_SINVM_NAME := fix_identifier_case (_SINVM_NAME_IN);\n"
"_SINVM_NAME := __proc_exists (_SINVM_NAME, 2);\n"
"if (not isstring (_SINVM_NAME))\n"
"{\n"
"_SINVM_NAME := __proc_exists (_SINVM_NAME_IN, 1);\n"
"if (not isstring (_SINVM_NAME))\n"
"signal (\'22023\', sprintf (\n"
"\'Non-existent function %s passed as argument 1 to SINV_DROP_INVERSE\', _SINVM_NAME_IN),\n"
"\'SR458\');\n"
"}\n"
"delete from SYS_SQL_INVERSE where SINV_FUNCTION = _SINVM_NAME;\n"
"sinv_read_invers_sys (_SINVM_NAME);\n"
"}\n"
"--src system2.sql:353\n";

static const char *proc141 = 
"create procedure SINV_CREATE_KEY_MAPPING (in map_name varchar,  in part_defs any, in do_drops integer := 1)\n"
"{\n"
"declare inx, len_of_part_defs integer;\n"
"\n"
"declare col_def_list, col_list, ocol_list, where_cond, gen_col_list, proc_parm_list, inv_vector varchar;\n"
"\n"
"if (isstring (map_name))\n"
"map_name := fix_identifier_case (map_name);\n"
"col_def_list := \'\';\n"
"col_list := \'\';\n"
"ocol_list := \'\';\n"
"where_cond := \'\';\n"
"gen_col_list := \'\';\n"
"proc_parm_list := \'\';\n"
"inv_vector := \'\';\n"
"\n"
"for (inx := 0, len_of_part_defs := length (part_defs); inx < len_of_part_defs; inx := inx + 2)\n"
"{\n"
"declare var_name, var_type varchar;\n"
"\n"
"var_name := fix_identifier_case (part_defs[inx]);\n"
"var_type := part_defs[inx + 1];\n"
"\n"
"col_def_list := concat (col_def_list, sprintf (\'K%d %I\', (inx/2) + 1, var_type));\n"
"col_list := concat (col_list, sprintf (\'K%d\', (inx/2) + 1));\n"
"ocol_list := concat (ocol_list, var_name);\n"
"proc_parm_list := concat (proc_parm_list, sprintf (\'in \"%I\" %s\', var_name, var_type));\n"
"where_cond := concat (where_cond, sprintf (\'K%d = \"%I\"\', (inx/2) + 1, var_name));\n"
"inv_vector := concat (inv_vector, sprintf (\'\'\'%s_%s\'\'\', map_name, var_name));\n"
"if (inx < len_of_part_defs - 2)\n"
"{\n"
"col_def_list := concat (col_def_list, \',\\n \');\n"
"col_list := concat (col_list, \', \');\n"
"ocol_list := concat (ocol_list, \', \');\n"
"proc_parm_list := concat (proc_parm_list, \', \');\n"
"where_cond := concat (where_cond, \' and \');\n"
"inv_vector := concat (inv_vector, \',\');\n"
"}\n"
"}\n"
"if (do_drops > 0)\n"
"{\n"
"declare stat, msg any;\n"
"stat := NULL;\n"
"exec (sprintf (\'\\nDB.DBA.SINV_DROP_INVERSE (\'\'%s\'\')\\n\', map_name), stat, msg);\n"
"if (stat is not null)\n"
"{\n"
"sql_warning (stat, \'IN005\', msg);\n"
"stat := NULL;\n"
"}\n"
"exec (sprintf (\'\\nsequence_remove (\'\'%s\'\')\\n\', map_name), stat, msg);\n"
"if (stat is not null)\n"
"{\n"
"sql_warning (stat, \'INV01\', msg);\n"
"stat := NULL;\n"
"}\n"
"exec (sprintf (\'\\ndrop function \"%I\"\\n\', map_name), stat, msg);\n"
"if (stat is not null)\n"
"{\n"
"sql_warning (stat, \'INV02\', msg);\n"
"stat := NULL;\n"
"}\n"
"for (inx := 0, len_of_part_defs := length (part_defs); inx < len_of_part_defs; inx := inx + 2)\n"
"{\n"
"declare var_name varchar;\n"
"\n"
"var_name := fix_identifier_case (part_defs[inx]);\n"
"exec (sprintf (\'\\ndrop function \"%I_%I\"\\n\', map_name, var_name), stat, msg);\n"
"if (stat is not null)\n"
"{\n"
"sql_warning (stat, \'INV03\', msg);\n"
"stat := NULL;\n"
"}\n"
"}\n"
"exec (sprintf (\'\\ndrop table \"MAP_%I\"\\n\', map_name), stat, msg);\n"
"if (stat is not null)\n"
"{\n"
"sql_warning (stat, \'INV04\', msg);\n"
"stat := NULL;\n"
"}\n"
"}\n"
"\n"
"if (do_drops = 2)\n"
"return;\n"
"\n"
"exec (sprintf (concat (\n"
"\'\\ncreate table \"MAP_%I\" (\\n\',\n"
"\' ID integer,\\n\',\n"
"\' %s,\\n\',\n"
"\' primary key (%s))\\n\'),\n"
"map_name,\n"
"col_def_list, col_list\n"
"));\n"
"\n"
"exec (sprintf (concat (\n"
"\'create index \"MAP_%I_ID\" on \"MAP_%I\" (ID)\\n\'),\n"
"map_name, map_name));\n"
"\n"
"exec (sprintf (concat (\n"
"\'\\ncreate function \"%I\" (%s) returns integer\\n\',\n"
"\'{\\n\',\n"
"\'  declare _ID integer;\\n\',\n"
"\'  set isolation = \'\'committed\'\';\\n\',\n"
"\'  whenever not found  goto none1;\\n\',\n"
"\'  select ID into _ID from \"MAP_%I\" where\\n\',\n"
"\'    %s;\\n\',\n"
"\'  return _ID;\\n\',\n"
"\'none1:\\n\',\n"
"\'  set isolation = \'\'serializable\'\';\\n\',\n"
"\'  whenever not found  goto none2;\\n\',\n"
"\'  select ID into _ID from \"MAP_%I\" where\\n\',\n"
"\'    %s;\\n\',\n"
"\'  return _ID;\\n\',\n"
"\'none2:\\n\',\n"
"\'  _ID := sequence_next (\'\'%s\'\');\\n\',\n"
"\'  insert into \"MAP_%I\" (ID, %s) values (_ID, %s);\\n\',\n"
"\'  return _ID;\\n\',\n"
"\'}\\n\'),\n"
"map_name, proc_parm_list,\n"
"map_name, where_cond,\n"
"map_name, where_cond,\n"
"map_name,\n"
"map_name, col_list, ocol_list));\n"
"\n"
"for (inx := 0, len_of_part_defs := length (part_defs); inx < len_of_part_defs; inx := inx + 2)\n"
"{\n"
"declare var_name, var_type varchar;\n"
"\n"
"var_name := fix_identifier_case (part_defs[inx]);\n"
"var_type := part_defs[inx + 1];\n"
"\n"
"exec (sprintf (concat (\n"
"\'\\ncreate function \"%I_%I\" (in _ID integer) returns %s\\n\',\n"
"\'{\\n\',\n"
"\'  return (select K%d from \"MAP_%I\" where ID = _ID);\\n\',\n"
"\'}\\n\'),\n"
"map_name, var_name, var_type,\n"
"(inx/2) + 1, map_name));\n"
"}\n"
"\n"
"\n"
"exec (sprintf (\n"
"\'\\nDB.DBA.SINV_CREATE_INVERSE (\'\'%s\'\', vector (%s), 0)\\n\',\n"
"map_name, inv_vector));\n"
"}\n"
"--src system2.sql:371\n";

static const char *proc142 = 
"create procedure SYS_CREATE_TABLE_AS (\n"
"in tb_name varchar, in _parse_tree any, in with_data integer,\n"
"in exec_it integer := 1)\n"
"{\n"
"declare _desc, _rows any;\n"
"declare _cols any;\n"
"declare _n_cols, _inx integer;\n"
"declare _stmt varchar;\n"
"\n"
"\n"
"\n"
"\n"
"exec (_parse_tree, NULL, NULL, NULL, 1, _desc, _rows);\n"
"\n"
"_cols := _desc[0];\n"
"_n_cols := length (_cols);\n"
"\n"
"_stmt := sprintf (\'create table %s (\', REPL_FQNAME (tb_name));\n"
"for (_inx := 0; _inx < _n_cols; _inx := _inx + 1)\n"
"{\n"
"declare _col any;\n"
"declare _col_name varchar;\n"
"\n"
"_col := aref(_cols, _inx);\n"
"_col_name := repl_undot_name (aref(_col, 0));\n"
"\n"
"_stmt := concat(_stmt,\n"
"sprintf(\'\"%I\" \', _col_name), REPL_COLTYPE (_col));\n"
"\n"
"if (_inx + 1 < _n_cols)\n"
"_stmt:= concat(_stmt, \', \');\n"
"}\n"
"_stmt := concat(_stmt, \')\');\n"
"\n"
"if (exec_it <> 0)\n"
"{\n"
"\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"\n"
"\n"
"resignal;\n"
"};\n"
"exec (_stmt);\n"
"if (with_data <> 0)\n"
"{\n"
"\n"
"declare _insert_stmt, _tb_dotted any;\n"
"_tb_dotted :=\n"
"vector (\n"
"200,\n"
"tb_name,\n"
"NULL,\n"
"0,\n"
"0,\n"
"0\n"
");\n"
"\n"
"aref_set_0 (_tb_dotted, 3);\n"
"aref_set_0 (_tb_dotted, 4);\n"
"aref_set_0 (_tb_dotted, 5);\n"
"\n"
"_insert_stmt := vector (\n"
"110,\n"
"_tb_dotted,\n"
"0,\n"
"_parse_tree,\n"
"0, 0, 0\n"
");\n"
"aref_set_0 (_insert_stmt, 2);\n"
"aref_set_0 (_insert_stmt, 4);\n"
"exec (_insert_stmt);\n"
"\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"else\n"
"return _stmt;\n"
"}\n"
"--src system2.sql:517\n";

static const char *proc143 = 
" create procedure\n"
"encode_b32_num (in i integer) returns varchar\n"
"{\n"
"declare s varchar;\n"
"declare x integer;\n"
"\n"
"x := i;\n"
"s := \'\';\n"
"\n"
"declare b32_s varchar;\n"
"b32_s := \'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567\';\n"
"\n"
"while (1 = 1)\n"
"{\n"
"s := chr (aref (b32_s, mod(x, 32))) || s;\n"
"x := floor (x / 32);\n"
"if (x = 0) goto done;\n"
"}\n"
"done:\n"
"return s;\n"
"}\n"
"--src system2.sql:608\n";

static const char *proc144 = 
" create procedure\n"
"decode_b32_num (in s varchar) returns integer\n"
"{\n"
"declare x integer; x := 0;\n"
"declare y integer;\n"
"\n"
"declare b32_s, typo_s, corr_s varchar;\n"
"\n"
"b32_s := \'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567\';\n"
"typo_s := \'1089\';\n"
"corr_s := \'IOBG\';\n"
"\n"
"declare i integer;\n"
"declare c varchar;\n"
"\n"
"i := 0;\n"
"\n"
"while (i < length(s))\n"
"{\n"
"c := chr (aref (s, i));\n"
"\n"
"y := locate (c, typo_s);\n"
"if (y > 0) c := chr(aref (corr_s, y - 1));\n"
"\n"
"y := locate (c, b32_s);\n"
"\n"
"if (y > 0)\n"
"x := (x * 32) + y - 1;\n"
"else\n"
"signal (\'42000\', \'Invalid character in decode_b32_num\');\n"
"\n"
"i := i + 1;\n"
"}\n"
"return x;\n"
"}\n"
"--src system2.sql:632\n";

static const char *other84 = 
"add_protected_sequence (\'/!URIQA/\')\n";
static const char *other85 = 
"add_protected_sequence (\'/!sparql/\')\n";
static const char *other86 = 
"add_protected_sequence (\'DAV_HOME_DIR_UPDATE\')\n";
static const char *other87 = 
"add_protected_sequence (\'DB.DBA.DAV_RDF_GRAPH_URI\')\n";
static const char *other88 = 
"add_protected_sequence (\'DB.DBA.RDF_QUAD_FT_UPGRADE\')\n";
static const char *other89 = 
"add_protected_sequence (\'DB.DBA.RDF_QUAD_FT_UPGRADE-tridgell32-2\')\n";
static const char *other90 = 
"add_protected_sequence (\'DB.DBA.__UPDATE_SOAP_USERS_ACCESS\')\n";
static const char *other91 = 
"add_protected_sequence (\'DB.DBA.virt_proxy_init_state\')\n";
static const char *other92 = 
"add_protected_sequence (\'DELAY_UPDATE_DB_DBA_RDF_OBJ\')\n";
static const char *other93 = 
"add_protected_sequence (\'DELAY_UPDATE_WS_WS_HOSTFS_RES_CACHE\')\n";
static const char *other94 = 
"add_protected_sequence (\'DELAY_UPDATE_WS_WS_HOSTFS_RES_META\')\n";
static const char *other95 = 
"add_protected_sequence (\'FK_UNIQUE_CHEK\')\n";
static const char *other96 = 
"add_protected_sequence (\'NNTP_SERVER_ID\')\n";
static const char *other97 = 
"add_protected_sequence (\'RDF_DATATYPE_TWOBYTE\')\n";
static const char *other98 = 
"add_protected_sequence (\'RDF_LANGUAGE_TWOBYTE\')\n";
static const char *other99 = 
"add_protected_sequence (\'RDF_PREF_SEQ\')\n";
static const char *other100 = 
"add_protected_sequence (\'RDF_RO_ID\')\n";
static const char *other101 = 
"add_protected_sequence (\'RDF_URL_IID_BLANK\')\n";
static const char *other102 = 
"add_protected_sequence (\'RDF_URL_IID_NAMED\')\n";
static const char *other103 = 
"add_protected_sequence (\'RDF_URL_IID_NAMED_BLANK\')\n";
static const char *other104 = 
"add_protected_sequence (\'UDDI_operator\')\n";
static const char *other105 = 
"add_protected_sequence (\'URIQADefaultHost\')\n";
static const char *other106 = 
"add_protected_sequence (\'URIQAFingerprint\')\n";
static const char *other107 = 
"add_protected_sequence (\'VAD_atomic\')\n";
static const char *other108 = 
"add_protected_sequence (\'VAD_errcount\')\n";
static const char *other109 = 
"add_protected_sequence (\'VAD_is_run\')\n";
static const char *other110 = 
"add_protected_sequence (\'VAD_msg\')\n";
static const char *other111 = 
"add_protected_sequence (\'VAD_wet_run\')\n";
static const char *other112 = 
"add_protected_sequence (\'WS.WS.SYS_DAV_INIT-status\')\n";
static const char *other113 = 
"add_protected_sequence (\'WSRMServerID\')\n";
static const char *other114 = 
"add_protected_sequence (\'__FTI_VERSION__\')\n";
static const char *other115 = 
"add_protected_sequence (\'__IRI8\')\n";
static const char *other116 = 
"add_protected_sequence (\'__IRI_MAX8\')\n";
static const char *other117 = 
"add_protected_sequence (\'__NEXT__vad_id\')\n";
static const char *other118 = 
"add_protected_sequence (\'__REPL_CREATE_UPDATABLE_SNAPSHOT_LOG_WS.WS.SYS_DAV_RES\')\n";
static const char *other119 = 
"add_protected_sequence (\'__http_vd_upgrade\')\n";
static const char *other120 = 
"add_protected_sequence (\'__nntp_from_header\')\n";
static const char *other121 = 
"add_protected_sequence (\'__nntp_organization_header\')\n";
static const char *other122 = 
"add_protected_sequence (\'__no_vspx_temp\')\n";
static const char *other123 = 
"add_protected_sequence (\'__repl_this_server\')\n";
static const char *other124 = 
"add_protected_sequence (\'__scheduler_do_now__\')\n";
static const char *other125 = 
"add_protected_sequence (\'__spam_filtering\')\n";
static const char *other126 = 
"add_protected_sequence (\'__wsrm_version__\')\n";
static const char *other127 = 
"add_protected_sequence (\'dbpump_id\')\n";
static const char *other128 = 
"add_protected_sequence (\'dbpump_temp\')\n";
static const char *other129 = 
"add_protected_sequence (\'uuid_state\')\n";
static const char *other130 = 
"add_protected_sequence (\'vad_id\')\n";
static const char *other131 = 
"add_protected_sequence (\'vad_tmp\')\n";
static const char *other132 = 
"add_protected_sequence (\'vdd_init\')\n";
/* odbccat.sql */

static const char *proc145 = 
"create procedure\n"
"sql_normalize_qon (in dsn varchar, inout infos any, inout qual varchar, inout owner varchar, inout name varchar)\n"
"{\n"
"\n"
"\n"
"if (sql_normalize_qon_oracle_oracle (dsn, infos, qual, owner, name)) return;\n"
"if (sql_normalize_qon_oracle_msora (dsn, infos, qual, owner, name)) return;\n"
"if (sql_normalize_qon_infohub_dcsyb30 (dsn, infos, qual, owner, name)) return;\n"
"if (sql_normalize_qon_viaserv_opl (dsn, infos, qual, owner, name)) return;\n"
"\n"
"return;\n"
"}\n"
"--src odbccat.sql:22\n";

static const char *proc146 = 
"create procedure\n"
"sql_filter_qon (inout infos any, inout result any, in qual varchar, in owner varchar, in name varchar)\n"
"{\n"
"\n"
"declare filter any;\n"
"if (not isarray(result))\n"
"return;\n"
"\n"
"filter := NULL;\n"
"\n"
"if (sql_filter_qon_oracle_oracle (infos, filter, qual, owner, name)) goto foun;\n"
"\n"
"return;\n"
"foun:\n"
"\n"
"if (isarray(filter))\n"
"{\n"
"if (length (filter) > 0 and isstring (aref(filter, 0)))\n"
"aset (filter, 0, replace (replace (replace (aref(filter, 0), \'\\\\\', \'\\\\\\\\\'), \'%\', \'\\\\%\'), \'_\', \'\\\\_\'));\n"
"if (length (filter) > 1 and isstring (aref(filter, 1)))\n"
"aset (filter, 1, replace (replace (replace (aref(filter, 1), \'\\\\\', \'\\\\\\\\\'), \'%\', \'\\\\%\'), \'_\', \'\\\\_\'));\n"
"if (length (filter) > 2 and isstring (aref(filter, 2)))\n"
"aset (filter, 2, replace (replace (replace (aref(filter, 2), \'\\\\\', \'\\\\\\\\\'), \'%\', \'\\\\%\'), \'_\', \'\\\\_\'));\n"
"}\n"
"\n"
"if (isarray (filter))\n"
"{\n"
"declare inx integer;\n"
"declare result_out, res_row any;\n"
"inx := 0;\n"
"result_out := NULL;\n"
"while (inx < length (result))\n"
"{\n"
"res_row := aref_set_0 (result, inx);\n"
"\n"
"if (not ((length (filter) > 0 and isstring (aref (filter, 0)) and (aref (res_row, 0) not like aref (filter, 0))) or\n"
"(length (filter) > 1 and isstring (aref (filter, 1)) and (aref (res_row, 1) not like aref (filter, 1))) or\n"
"(length (filter) > 2 and isstring (aref (filter, 2)) and (aref (res_row, 2) not like aref (filter, 2)))))\n"
"{\n"
"\n"
"if (result_out is null)\n"
"result_out := vector (res_row);\n"
"else\n"
"result_out := vector_concat (result_out, vector (res_row));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"result := result_out;\n"
"}\n"
"}\n"
"--src odbccat.sql:36\n";

static const char *proc147 = 
"create procedure\n"
"sql_columns (in dsn varchar, in qual varchar, in owner varchar, in name varchar, in col varchar)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name, _col varchar;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"_col := col;\n"
"\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"\n"
"\n"
"result := _sql_columns (dsn, qual,\n"
"sql_escape_meta_identifier (dsn, owner),\n"
"sql_escape_meta_identifier (dsn, name),\n"
"sql_escape_meta_identifier (dsn, col));\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"\n"
"sql_columns_post_oracle_openlink (infos, result);\n"
"\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Bad DSN in sql_columns\', \'VD073\');\n"
"}\n"
"--src odbccat.sql:88\n";

static const char *proc148 = 
"create procedure\n"
"sql_tables (in dsn varchar, in qual varchar, in owner varchar, in name varchar, in typ varchar)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name, _typ varchar;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"_typ := typ;\n"
"\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"\n"
"if (1 = sql_tables_pre_infohub_dcsyb30 (infos, typ));\n"
"if (1 = sql_tables_pre_excel_drv (infos, typ));\n"
"\n"
"result := _sql_tables (dsn,\n"
"sql_escape_meta_identifier (dsn, qual),\n"
"sql_escape_meta_identifier (dsn, owner),\n"
"sql_escape_meta_identifier (dsn, name),\n"
"typ);\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"\n"
"if (1 = sql_tables_post_infohub_dcsyb30 (infos, result, _typ));\n"
"if (1 = sql_tables_post_excel_drv (dsn, infos, result, _typ));\n"
"if (1 = sql_tables_post_progress_win_openlink (infos, result, _typ));\n"
"\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Bad DSN in sql_tables\', \'VD074\');\n"
"}\n"
"--src odbccat.sql:121\n";

static const char *proc149 = 
"create procedure\n"
"sql_primary_keys (in dsn varchar, in qual varchar, in owner varchar, in name varchar)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name varchar;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"\n"
"\n"
"result := _sql_primary_keys (dsn, qual, owner, name);\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"\n"
"\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Bad DSN in sql_primary_keys\', \'VD075\');\n"
"}\n"
"--src odbccat.sql:159\n";

static const char *proc150 = 
"create procedure\n"
"sql_statistics (in dsn varchar, in qual varchar, in owner varchar, in name varchar, in uniqu integer, in acc integer)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name varchar;\n"
"declare _uniqu, _acc integer;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"_uniqu := uniqu;\n"
"_acc := acc;\n"
"\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"\n"
"\n"
"result := _sql_statistics (dsn, qual, owner, name, uniqu, acc);\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"\n"
"\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Bad DSN in sql_statistics\', \'VD076\');\n"
"}\n"
"--src odbccat.sql:187\n";

static const char *proc151 = 
"create procedure\n"
"sql_procedures (in dsn varchar, in qual varchar, in owner varchar, in name varchar)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name varchar;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"\n"
"\n"
"result := _sql_procedures (dsn, qual,\n"
"sql_escape_meta_identifier (dsn, owner),\n"
"sql_escape_meta_identifier (dsn, name));\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"\n"
"\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Bad DSN in sql_procedures\', \'VD077\');\n"
"}\n"
"--src odbccat.sql:218\n";

static const char *proc152 = 
"create procedure\n"
"sql_procedure_cols (in dsn varchar, in qual any, in owner any, in name varchar, in col varchar)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name, _col varchar;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"_col := col;\n"
"\n"
"if (qual = 0) qual := \'\';\n"
"if (owner = 0) owner := \'\';\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"\n"
"\n"
"result := _sql_procedure_columns (dsn, qual, owner, name, col);\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"\n"
"\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Bad DSN in sql_procedures\', \'VD077\');\n"
"}\n"
"--src odbccat.sql:248\n";

static const char *proc153 = 
" create procedure\n"
"sql_foreign_keys (in dsn varchar, in qual varchar, in owner varchar, in name varchar, in qual2 varchar, in owner2 varchar, in name2 varchar)\n"
"{\n"
"declare result, infos any;\n"
"declare _qual, _owner, _name varchar;\n"
"_qual := qual;\n"
"_owner := owner;\n"
"_name := name;\n"
"infos := null;\n"
"whenever not found goto nf;\n"
"select deserialize (DS_CONN_STR) into infos from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsn;\n"
"\n"
"sql_normalize_qon (dsn, infos, qual, owner, name);\n"
"sql_normalize_qon (dsn, infos, qual2, owner2, name2);\n"
"\n"
"result := _sql_foreign_keys (dsn, qual, owner, name, qual2, owner2, name2);\n"
"\n"
"sql_filter_qon (infos, result, _qual, _owner, _name);\n"
"return result;\n"
"nf:\n"
"signal (\'HZ000\', \'Invalid DSN in sql_foreign_keys\', \'VD075\');\n"
"}\n"
"--src odbccat.sql:279\n";

static const char *proc154 = 
"create procedure __virt_sql_qon_is_oracle_oracle (inout infos any,\n"
"inout qual varchar, inout owner varchar, inout name varchar)\n"
"{\n"
"declare dbms_name, driver_name, driver_ver varchar;\n"
"declare ver_arr any;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"driver_ver := upper (get_keyword (7, infos, \'\'));\n"
"\n"
"if (upper (dbms_name) like \'%ORACLE%\' and (driver_name like \'SQOCI%.DLL\' or driver_name like \'SQORA32%.DLL\'))\n"
"{\n"
"if (isstring (driver_ver))\n"
"{\n"
"ver_arr := split_and_decode (driver_ver,0,\'\\0\\0.\');\n"
"if (isarray (ver_arr) and length (ver_arr) >= 3)\n"
"{\n"
"declare v1, v2, v3 integer;\n"
"v1 := atoi (ver_arr [0]);\n"
"v2 := atoi (ver_arr [1]);\n"
"v3 := atoi (ver_arr [2]);\n"
"if (v1 > 8)\n"
"goto check_special_chars;\n"
"if (v1 = 8)\n"
"{\n"
"if (v2 > 1)\n"
"goto check_special_chars;\n"
"if (v2 = 1)\n"
"{\n"
"if (v3 >= 705)\n"
"goto check_special_chars;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"else\n"
"return 0;\n"
"\n"
"check_special_chars:\n"
"if (isstring (qual) and (strstr (qual, \'\\\\_\') or strstr (qual, \'\\\\%\')))\n"
"return 1;\n"
"if (isstring (owner) and (strstr (owner, \'\\\\_\') or strstr (owner, \'\\\\%\')))\n"
"return 1;\n"
"if (isstring (name) and (strstr (name, \'\\\\_\') or strstr (name, \'\\\\%\')))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:309\n";

static const char *proc155 = 
"create procedure\n"
"sql_normalize_qon_oracle_oracle (in dsn varchar, inout infos any, inout qual varchar, inout owner varchar, inout name varchar)\n"
"{\n"
"if (__virt_sql_qon_is_oracle_oracle (infos, qual, owner, name) > 0)\n"
"{\n"
"qual := NULL;\n"
"\n"
"if (name is not null)\n"
"name := NULL;\n"
"else if (owner is not null)\n"
"owner := NULL;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:359\n";

static const char *proc156 = 
"create procedure\n"
"sql_filter_qon_oracle_oracle (inout infos any, inout filter any, in qual varchar, in owner varchar, in name varchar)\n"
"{\n"
"filter := NULL;\n"
"if (__virt_sql_qon_is_oracle_oracle (infos, qual, owner, name) > 0)\n"
"{\n"
"filter := vector (qual, owner, name);\n"
"\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:376\n";

static const char *proc157 = 
"create procedure\n"
"sql_normalize_qon_oracle_msora (in dsn varchar, inout infos any, inout qual varchar, inout owner varchar, inout name varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (upper (dbms_name) like \'%ORACLE%\' and upper (driver_name) like \'MSORCL32.DLL\')\n"
"{\n"
"qual := NULL;\n"
"if (isstring (owner) and length (owner) > 0) owner := concat (\'\"\', owner, \'\"\');\n"
"if (isstring (name) and length (name) > 0) name := concat (\'\"\', name, \'\"\');\n"
"\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:393\n";

static const char *proc158 = 
"create procedure\n"
"sql_normalize_qon_infohub_dcsyb30 (in dsn varchar, inout infos any, inout qual varchar, inout owner varchar, inout name varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (dbms_name like \'%INFOHUB%\' and driver_name like \'DCSYB30.DLL\')\n"
"{\n"
"\n"
"vd_autocommit (dsn, 1);\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:419\n";

static const char *proc159 = 
"create procedure\n"
"sql_tables_pre_infohub_dcsyb30 (inout infos any, inout typ varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (dbms_name like \'%INFOHUB%\' and driver_name like \'DCSYB30.DLL\')\n"
"{\n"
"\n"
"typ := NULL;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:436\n";

static const char *proc160 = 
"create procedure\n"
"sql_tables_post_infohub_dcsyb30 (inout infos any, inout result any, inout typ varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (dbms_name like \'%INFOHUB%\' and driver_name like \'DCSYB30.DLL\')\n"
"{\n"
"\n"
"declare broken_typ any;\n"
"declare inx, inx1, is_in integer;\n"
"declare result_out, res_row any;\n"
"\n"
"if (0 = isstring (typ) or length (typ) < 1)\n"
"return 1;\n"
"broken_typ := split_and_decode (typ, 1, \'\\0\'\',\');\n"
"\n"
"inx := 0;\n"
"result_out := NULL;\n"
"\n"
"while (inx < length (result))\n"
"{\n"
"res_row := aref_set_0 (result, inx);\n"
"inx1 := 0;\n"
"is_in := 0;\n"
"\n"
"\n"
"while (inx1 < length (broken_typ))\n"
"{\n"
"\n"
"if (upper (aref (res_row, 3)) like trim (aref (broken_typ, inx1)))\n"
"{\n"
"is_in := 1;\n"
"inx1 := length (broken_typ);\n"
"}\n"
"inx1 := inx1 + 1;\n"
"}\n"
"if (is_in)\n"
"{\n"
"\n"
"if (result_out is null)\n"
"result_out := vector (res_row);\n"
"else\n"
"result_out := vector_concat (result_out, vector (res_row));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"result := result_out;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:454\n";

static const char *proc161 = 
"create procedure sql_columns_post_oracle_openlink (inout infos any, inout result any)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (upper (dbms_name) like \'%ORACLE%\' and (driver_name like \'OLOD3032.DLL\' or driver_name like \'OPLODBC.SO%\'))\n"
"{\n"
"\n"
"declare row_inx integer;\n"
"row_inx := 0;\n"
"while (row_inx < length (result))\n"
"{\n"
"declare row_data any;\n"
"declare data_type integer;\n"
"declare type_name varchar;\n"
"\n"
"row_data := aref (result, row_inx);\n"
"data_type := cast (aref (row_data, 4) as integer);\n"
"type_name := cast (aref (row_data, 5) as varchar);\n"
"if (data_type = 12 and type_name = \'FLOAT\')\n"
"{\n"
"\n"
"aset (row_data, 4, 8);\n"
"aset (result, row_inx, row_data);\n"
"}\n"
"row_inx := row_inx + 1;\n"
"}\n"
"\n"
"}\n"
"}\n"
"--src odbccat.sql:514\n";

static const char *proc162 = 
"create procedure\n"
"sql_tables_post_progress_win_openlink (inout infos any, inout result any, inout typ varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (dbms_name like \'%PROGRESS%\' and driver_name like \'OLOD4032.DLL\')\n"
"{\n"
"\n"
"declare broken_typ any;\n"
"declare inx, inx1, is_in integer;\n"
"declare result_out, res_row any;\n"
"\n"
"if (0 = isstring (typ) or length (typ) < 1)\n"
"return 1;\n"
"broken_typ := split_and_decode (typ, 1, \'\\0\'\',\');\n"
"\n"
"inx := 0;\n"
"result_out := NULL;\n"
"\n"
"while (inx < length (result))\n"
"{\n"
"res_row := aref_set_0 (result, inx);\n"
"inx1 := 0;\n"
"is_in := 0;\n"
"\n"
"\n"
"while (inx1 < length (broken_typ))\n"
"{\n"
"\n"
"if (upper (aref (res_row, 3)) like trim (aref (broken_typ, inx1)))\n"
"{\n"
"is_in := 1;\n"
"inx1 := length (broken_typ);\n"
"}\n"
"inx1 := inx1 + 1;\n"
"}\n"
"if (is_in)\n"
"{\n"
"\n"
"if (result_out is null)\n"
"result_out := vector (res_row);\n"
"else\n"
"result_out := vector_concat (result_out, vector (res_row));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"result := result_out;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:551\n";

static const char *proc163 = 
"create procedure\n"
"sql_tables_post_excel_drv (in dsn varchar, inout infos any, inout result any, inout typ varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (dbms_name like \'%EXCEL%\' and driver_name like \'ODBCJT32.DLL\')\n"
"{\n"
"\n"
"declare broken_typ any;\n"
"declare inx, inx1, is_in integer;\n"
"declare result_out, res_row any;\n"
"\n"
"if (0 = isstring (typ) or length (typ) < 1)\n"
"return 1;\n"
"broken_typ := split_and_decode (typ, 1, \'\\0\'\',\');\n"
"\n"
"inx := 0;\n"
"result_out := NULL;\n"
"\n"
"while (inx < length (result))\n"
"{\n"
"res_row := aref_set_0 (result, inx);\n"
"inx1 := 0;\n"
"is_in := 0;\n"
"\n"
"\n"
"while (inx1 < length (broken_typ))\n"
"{\n"
"\n"
"if (upper (aref (res_row, 3)) like trim (aref (broken_typ, inx1)))\n"
"{\n"
"is_in := 1;\n"
"inx1 := length (broken_typ);\n"
"}\n"
"inx1 := inx1 + 1;\n"
"}\n"
"if (is_in)\n"
"{\n"
"\n"
"declare cols any;\n"
"cols := sql_columns (dsn, null, null, aref (res_row, 2), null);\n"
"if (cols is not null and length (cols) > 0)\n"
"{\n"
"if (result_out is null)\n"
"result_out := vector (res_row);\n"
"else\n"
"result_out := vector_concat (result_out, vector (res_row));\n"
"}\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"result := result_out;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:611\n";

static const char *proc164 = 
"create procedure\n"
"sql_tables_pre_excel_drv (inout infos any, inout typ varchar)\n"
"{\n"
"declare dbms_name, driver_name varchar;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"\n"
"if (dbms_name like \'%EXCEL%\' and driver_name like \'ODBCJT32.DLL\')\n"
"{\n"
"typ := NULL;\n"
"return 1;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:672\n";

static const char *proc165 = 
"create procedure\n"
"sql_normalize_qon_viaserv_opl (in dsn varchar, inout infos any, inout qual varchar, inout owner varchar, inout name varchar)\n"
"{\n"
"declare dbms_name, driver_name, driver_ver varchar;\n"
"declare ver_arr any;\n"
"dbms_name := upper (get_keyword (17, infos, \'\'));\n"
"driver_name := upper (get_keyword (6, infos, \'\'));\n"
"driver_ver := upper (get_keyword (7, infos, \'\'));\n"
"\n"
"if (upper (dbms_name) like \'%VIASQL%\' and (driver_name like \'OLOD40%.DLL\' or driver_name like \'OPL%.so\'))\n"
"{\n"
"\n"
"if (isstring (qual))\n"
"{\n"
"qual := replace (qual, \'\\\\%\', \'%\');\n"
"qual := replace (qual, \'\\\\_\', \'_\');\n"
"}\n"
"if (isstring (owner))\n"
"{\n"
"owner := replace (owner, \'\\\\%\', \'%\');\n"
"owner := replace (owner, \'\\\\_\', \'_\');\n"
"}\n"
"if (isstring (name))\n"
"{\n"
"name := replace (name, \'\\\\%\', \'%\');\n"
"name := replace (name, \'\\\\_\', \'_\');\n"
"}\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src odbccat.sql:694\n";

/* useraggr.sql */

static const char *proc166 = 
" create procedure STD_COUNT (in _env varchar)\n"
"{\n"
"return aref (deserialize(_env), 0);\n"
"}\n"
"--src useraggr.sql:23\n";

static const char *proc167 = 
" create procedure STD11_INIT (inout _env varchar)\n"
"{\n"
"_env := serialize (vector (0, 0.0));\n"
"}\n"
"--src useraggr.sql:30\n";

static const char *proc168 = 
" create procedure STD12_INIT (inout _env varchar)\n"
"{\n"
"_env := serialize (vector (0, 0.0,0.0));\n"
"}\n"
"--src useraggr.sql:37\n";

static const char *proc169 = 
" create procedure STD13_INIT (inout _env varchar)\n"
"{\n"
"_env := serialize (vector (0, 0.0,0.0, 0.0));\n"
"}\n"
"--src useraggr.sql:44\n";

static const char *proc170 = 
" create procedure VAR_ACC (inout _env varchar, in val numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if (val is null)\n"
"return;\n"
"declare ctx any;\n"
"ctx := deserialize (_env);\n"
"\n"
"aset( ctx, 1, aref (ctx, 1) + val);\n"
"aset( ctx, 2, aref (ctx, 2) + val*val);\n"
"aset( ctx, 0, aref (ctx, 0) + 1);\n"
"_env := serialize (ctx);\n"
"}\n"
"--src useraggr.sql:51\n";

static const char *proc171 = 
" create procedure VAR_POP_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"declare _env any;\n"
"_env := deserialize (_ctx);\n"
"declare c integer;\n"
"c := aref (_env, 0);\n"
"if (c = 0)\n"
"return null;\n"
"return  (aref (_env, 2) - aref (_env, 1) * aref (_env, 1) / c) / c;\n"
"}\n"
"--src useraggr.sql:68\n";

static const char *proc172 = 
" create procedure VAR_SAMP_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"declare _env any;\n"
"_env := deserialize (_ctx);\n"
"declare c integer;\n"
"c := aref (_env, 0);\n"
"if (c = 0)\n"
"return null;\n"
"if (c = 1)\n"
"return 0.0;\n"
"return  (aref (_env, 2) - aref (_env, 1) * aref (_env, 1) / c) / (c - 1);\n"
"}\n"
"--src useraggr.sql:83\n";

static const char *proc173 = 
" create procedure VAR_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"if (STD_COUNT (_ctx) = 1)\n"
"return null;\n"
"return VAR_SAMP_FIN (_ctx);\n"
"}\n"
"--src useraggr.sql:100\n";

static const char *proc174 = 
" create procedure STDDEV_POP_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"declare c integer;\n"
"declare _env any;\n"
"_env := deserialize (_ctx);\n"
"c := aref (_env, 0);\n"
"if (c = 0)\n"
"return null;\n"
"\n"
"return  sqrt ((aref (_env, 2) - aref (_env, 1) * aref (_env, 1) / c) / c) ;\n"
"}\n"
"--src useraggr.sql:111\n";

static const char *proc175 = 
" create procedure STDDEV_SAMP_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"declare c integer;\n"
"declare _env any;\n"
"_env := deserialize (_ctx);\n"
"c := aref (_env, 0);\n"
"if (c = 0)\n"
"return null;\n"
"if (c = 1)\n"
"return 0.0;\n"
"return  sqrt ((aref (_env, 2) - aref (_env, 1) * aref (_env, 1) / c) / ( c - 1));\n"
"}\n"
"--src useraggr.sql:127\n";

static const char *proc176 = 
" create procedure STDDEV_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"if (STD_COUNT (_ctx) = 1)\n"
"return null;\n"
"return STDDEV_SAMP_FIN (_ctx);\n"
"}\n"
"--src useraggr.sql:144\n";

static const char *proc177 = 
" create procedure COVAR_ACC (inout _ctx any,\n"
"in expr1 numeric,\n"
"in expr2 numeric)\n"
"{\n"
"if (_ctx is null)\n"
"return;\n"
"if (expr1 is null or expr2 is null)\n"
"return;\n"
"\n"
"declare _env any;\n"
"\n"
"_env := deserialize (_ctx);\n"
"\n"
"aset (_env, 1, aref (_env,1)+expr1);\n"
"aset (_env, 2, aref (_env,2)+expr2);\n"
"aset (_env, 3, aref (_env,3)+expr2*expr1);\n"
"aset (_env, 0, aref (_env,0)+1);\n"
"\n"
"_ctx := serialize (_env);\n"
"}\n"
"--src useraggr.sql:155\n";

static const char *proc178 = 
" create procedure COVAR_SAMP_FIN (inout _ctx any)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"declare _env any;\n"
"_env := deserialize (_ctx);\n"
"if (aref (_env, 0) = 0)\n"
"return null;\n"
"if (aref (_env, 0) = 1)\n"
"return 0.0;\n"
"\n"
"return (aref (_env, 3) - aref(_env,2) * aref (_env,1) / aref (_env, 0)) / ( aref (_env, 0) - 1);\n"
"}\n"
"--src useraggr.sql:178\n";

static const char *proc179 = 
" create procedure COVAR_POP_FIN (inout _ctx any)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"declare _env any;\n"
"_env := deserialize (_ctx);\n"
"if (aref (_env, 0) = 0)\n"
"return null;\n"
"if (aref (_env, 0) = 1)\n"
"return 0.0;\n"
"\n"
"return (aref (_env, 3) - aref(_env,2) * aref (_env,1) / aref (_env, 0))/ aref (_env,0);\n"
"}\n"
"--src useraggr.sql:194\n";

static const char *proc180 = 
" create procedure COVAR_FIN (inout _ctx varchar)\n"
"{\n"
"if (_ctx is null)\n"
"return null;\n"
"if (STD_COUNT (_ctx) = 1)\n"
"return null;\n"
"return COVAR_SAMP_FIN (_ctx);\n"
"}\n"
"--src useraggr.sql:210\n";

static const char *other133 = 
"create aggregate DB.DBA.VAR_POP (in val numeric) returns numeric from\n"
"STD12_INIT, VAR_ACC, VAR_POP_FIN\n";

static const char *other134 = 
"create aggregate DB.DBA.VAR_SAMP (in val numeric) returns numeric from\n"
"STD12_INIT, VAR_ACC, VAR_SAMP_FIN\n";

static const char *other135 = 
"create aggregate DB.DBA.VAR (in val numeric) returns numeric from\n"
"STD12_INIT, VAR_ACC, VAR_FIN\n";

static const char *other136 = 
"create aggregate DB.DBA.STDDEV_POP (in val numeric) returns numeric from\n"
"STD12_INIT, VAR_ACC, STDDEV_POP_FIN\n";

static const char *other137 = 
"create aggregate DB.DBA.STDDEV_SAMP (in val numeric) returns numeric from\n"
"STD12_INIT, VAR_ACC, STDDEV_SAMP_FIN\n";

static const char *other138 = 
"create aggregate DB.DBA.STDDEV (in val numeric) returns numeric from\n"
"STD12_INIT, VAR_ACC, STDDEV_FIN\n";

static const char *other139 = 
"create aggregate DB.DBA.COVAR_SAMP (in expr1 numeric, in expr2 numeric) returns numeric from\n"
"STD13_INIT, COVAR_ACC, COVAR_SAMP_FIN\n";

static const char *other140 = 
"create aggregate DB.DBA.COVAR_POP (in expr1 numeric, in expr2 numeric) returns numeric from\n"
"STD13_INIT, COVAR_ACC, COVAR_POP_FIN\n";

static const char *other141 = 
"create aggregate DB.DBA.COVAR (in expr1 numeric, in expr2 numeric) returns numeric from\n"
"STD13_INIT, COVAR_ACC, COVAR_FIN\n";

static const char *proc181 = 
" create procedure REGR_SLOPE_INIT (inout _env varchar)\n"
"{\n"
"declare _ctx1 varchar;\n"
"declare _ctx2 varchar;\n"
"\n"
"STD13_INIT (_ctx1);\n"
"STD12_INIT (_ctx2);\n"
"\n"
"_env := serialize (vector (0, _ctx1, _ctx2));\n"
"}\n"
"--src useraggr.sql:249\n";

static const char *proc182 = 
" create procedure REGR_SLOPE_ACC (inout _env varchar, in expr1 numeric, in expr2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if ( (expr1 is null) or (expr2 is null))\n"
"return;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _ctx1 varchar;\n"
"declare _ctx2 varchar;\n"
"\n"
"_ctx1 := aref (_ctx, 1);\n"
"_ctx2 := aref (_ctx, 2);\n"
"\n"
"aset (_ctx, 0, aref (_ctx,0) + 1);\n"
"COVAR_ACC (_ctx1, expr1, expr2);\n"
"VAR_ACC (_ctx2, expr2);\n"
"\n"
"aset (_ctx, 1, _ctx1);\n"
"aset (_ctx, 2, _ctx2);\n"
"\n"
"_env := serialize (_ctx);\n"
"}\n"
"--src useraggr.sql:262\n";

static const char *proc183 = 
" create procedure REGR_SLOPE_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"declare c integer;\n"
"\n"
"_ctx := deserialize (_env);\n"
"\n"
"c := aref (_ctx, 0);\n"
"if (c = 0)\n"
"return 0;\n"
"if (c = 1)\n"
"return null;\n"
"\n"
"declare _ctx1 varchar;\n"
"declare _ctx2 varchar;\n"
"declare covar_pop_val numeric;\n"
"declare var_pop_val numeric;\n"
"\n"
"_ctx1 := aref (_ctx, 1);\n"
"_ctx2 := aref (_ctx, 2);\n"
"\n"
"\n"
"covar_pop_val := COVAR_POP_FIN (_ctx1);\n"
"var_pop_val := VAR_POP_FIN (_ctx2);\n"
"\n"
"if (var_pop_val = 0)\n"
"return null;\n"
"return covar_pop_val / var_pop_val;\n"
"}\n"
"--src useraggr.sql:289\n";

static const char *other142 = 
"create aggregate DB.DBA.REGR_SLOPE (in expr1 numeric, in expr2 numeric) returns numeric from REGR_SLOPE_INIT, REGR_SLOPE_ACC, REGR_SLOPE_FIN\n";

static const char *proc184 = 
" create procedure REGR_INTERCEPT_INIT (inout _env varchar)\n"
"{\n"
"declare _ctx_regr_slope varchar;\n"
"\n"
"REGR_SLOPE_INIT (_ctx_regr_slope);\n"
"_env := serialize (vector (0, 0.0, 0.0, _ctx_regr_slope));\n"
"}\n"
"--src useraggr.sql:326\n";

static const char *proc185 = 
" create procedure REGR_INTERCEPT_ACC (inout _env varchar, in expr1 numeric, in expr2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if ((expr1 is null) or (expr2 is null))\n"
"return;\n"
"\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"aset (_ctx, 0, aref (_ctx, 0) + 1);\n"
"aset (_ctx, 1, aref (_ctx, 1) + expr1);\n"
"aset (_ctx, 2, aref (_ctx, 2) + expr2);\n"
"\n"
"declare _ctx_r varchar;\n"
"_ctx_r := aref (_ctx, 3);\n"
"REGR_SLOPE_ACC (_ctx_r, expr1, expr2);\n"
"aset (_ctx, 3, _ctx_r);\n"
"\n"
"_env := serialize (_ctx);\n"
"}\n"
"--src useraggr.sql:336\n";

static const char *proc186 = 
" create procedure REGR_INTERCEPT_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"declare c integer;\n"
"c := aref (_ctx, 0);\n"
"if ((c = 0) or (c = 1))\n"
"return null;\n"
"\n"
"return aref (_ctx, 1) / c - REGR_SLOPE_FIN (aref (_ctx, 3)) * aref (_ctx, 2) / c;\n"
"}\n"
"--src useraggr.sql:360\n";

static const char *other143 = 
"create aggregate DB.DBA.REGR_INTERCEPT (in expr1 numeric, in expr2 numeric) returns numeric from REGR_INTERCEPT_INIT, REGR_INTERCEPT_ACC, REGR_INTERCEPT_FIN\n";

static const char *proc187 = 
" create procedure REGR_COUNT_INIT (inout _env integer)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src useraggr.sql:379\n";

static const char *proc188 = 
" create procedure REGR_COUNT_ACC (inout _env integer, in expr numeric, in expr2 numeric)\n"
"{\n"
"if ((_env is null) or (expr is null) or (expr2 is null))\n"
"return;\n"
"_env := _env + 1;\n"
"}\n"
"--src useraggr.sql:386\n";

static const char *proc189 = 
" create procedure REGR_COUNT_FIN (inout _env integer)\n"
"{\n"
"return _env;\n"
"}\n"
"--src useraggr.sql:395\n";

static const char *proc190 = 
" create procedure REGR_COUNT_MERGE (inout _e1 integer, inout _e2 integer)\n"
"{\n"
"_e1 := _e1 + _e2;\n"
"}\n"
"--src useraggr.sql:402\n";

static const char *other144 = 
"create aggregate DB.DBA.REGR_COUNT (in expr1 numeric, in expr2 numeric) returns numeric from REGR_COUNT_INIT, REGR_COUNT_ACC, REGR_COUNT_FIN, REGR_COUNT_MERGE\n";

static const char *proc191 = 
" create procedure REGR_AVG_ACC (inout _env varchar, in expr1 numeric, in expr2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"\n"
"if ( (expr1 is null) or (expr2 is null))\n"
"return;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"aset (_ctx, 0, aref (_ctx, 0) + 1);\n"
"aset (_ctx, 1, aref (_ctx, 1) + expr1);\n"
"aset (_ctx, 2, aref (_ctx, 2) + expr2);\n"
"\n"
"_env := serialize (_ctx);\n"
"}\n"
"--src useraggr.sql:412\n";

static const char *proc192 = 
" create procedure REGR_AVGX_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"if (aref (_ctx, 0) = 0)\n"
"return null;\n"
"return aref (_ctx, 1) / aref (_ctx,0);\n"
"}\n"
"--src useraggr.sql:431\n";

static const char *proc193 = 
" create procedure REGR_AVGY_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"if (aref (_ctx, 0) = 0)\n"
"return null;\n"
"return aref (_ctx, 2) / aref (_ctx,0);\n"
"}\n"
"--src useraggr.sql:444\n";

static const char *other145 = 
"create aggregate DB.DBA.REGR_AVGX (in x numeric, in y numeric) returns numeric from\n"
"STD12_INIT, REGR_AVG_ACC, REGR_AVGX_FIN\n";

static const char *other146 = 
"create aggregate DB.DBA.REGR_AVGY (in x numeric, in y numeric) returns numeric from\n"
"STD12_INIT, REGR_AVG_ACC, REGR_AVGY_FIN\n";

static const char *proc194 = 
" create procedure CORR_INIT (inout _env varchar)\n"
"{\n"
"declare _ctx_cov varchar;\n"
"declare _ctx_stdev1 varchar;\n"
"declare _ctx_stdev2 varchar;\n"
"\n"
"STD13_INIT (_ctx_cov);\n"
"STD12_INIT (_ctx_stdev1);\n"
"STD12_INIT (_ctx_stdev2);\n"
"\n"
"_env := serialize (vector (0, _ctx_cov, _ctx_stdev1, _ctx_stdev2));\n"
"}\n"
"--src useraggr.sql:465\n";

static const char *proc195 = 
" create procedure CORR_ACC (inout _env varchar, in e1 numeric, in e2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if ((e1 is null) or (e2 is null))\n"
"return;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _ctx_cov varchar;\n"
"declare _ctx_stdev1 varchar;\n"
"declare _ctx_stdev2 varchar;\n"
"\n"
"_ctx_cov := aref (_ctx, 1);\n"
"_ctx_stdev1 := aref (_ctx, 2);\n"
"_ctx_stdev2 := aref (_ctx, 3);\n"
"\n"
"COVAR_ACC (_ctx_cov, e1, e2);\n"
"VAR_ACC (_ctx_stdev1, e1);\n"
"VAR_ACC (_ctx_stdev2, e2);\n"
"\n"
"aset (_ctx, 0, aref (_ctx, 0) + 1);\n"
"aset (_ctx, 1, _ctx_cov);\n"
"aset (_ctx, 2, _ctx_stdev1);\n"
"aset (_ctx, 3, _ctx_stdev2);\n"
"\n"
"_env := serialize (_ctx);\n"
"}\n"
"--src useraggr.sql:480\n";

static const char *proc196 = 
" create procedure CORR_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _ctx_cov_val numeric;\n"
"declare _ctx_stdev1_val numeric;\n"
"declare _ctx_stdev2_val numeric;\n"
"\n"
"_ctx_cov_val := COVAR_POP_FIN (aref (_ctx, 1));\n"
"_ctx_stdev1_val := STDDEV_POP_FIN (aref (_ctx, 2));\n"
"_ctx_stdev2_val := STDDEV_POP_FIN (aref (_ctx, 3));\n"
"\n"
"if (_ctx_cov_val is null)\n"
"return null;\n"
"if (_ctx_stdev1_val is null or _ctx_stdev1_val = 0)\n"
"return null;\n"
"if (_ctx_stdev2_val is null or _ctx_stdev2_val = 0)\n"
"return null;\n"
"\n"
"return _ctx_cov_val / _ctx_stdev1_val / _ctx_stdev2_val;\n"
"}\n"
"--src useraggr.sql:511\n";

static const char *other147 = 
"create aggregate DB.DBA.CORR (in x numeric, in y numeric) returns numeric from\n"
"CORR_INIT, CORR_ACC, CORR_FIN\n";

static const char *proc197 = 
" create procedure REGR_R2_INIT (inout _env varchar)\n"
"{\n"
"declare _ctx_vp1 varchar;\n"
"declare _ctx_vp2 varchar;\n"
"declare _ctx_corr varchar;\n"
"\n"
"STD12_INIT (_ctx_vp1);\n"
"STD12_INIT (_ctx_vp2);\n"
"CORR_INIT (_ctx_corr);\n"
"\n"
"_env := serialize (vector (_ctx_vp1, _ctx_vp2, _ctx_corr));\n"
"}\n"
"--src useraggr.sql:542\n";

static const char *proc198 = 
" create procedure REGR_R2_ACC (inout _env varchar, in e1 numeric, in e2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if (e1 is null or e2 is null)\n"
"return;\n"
"declare _ctx  any;\n"
"\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _ctx_vp1 varchar;\n"
"declare _ctx_vp2 varchar;\n"
"declare _ctx_corr varchar;\n"
"\n"
"_ctx_vp1 := aref (_ctx, 0);\n"
"_ctx_vp2 := aref (_ctx, 1);\n"
"_ctx_corr := aref (_ctx, 2);\n"
"\n"
"VAR_ACC (_ctx_vp1, e1);\n"
"VAR_ACC (_ctx_vp2, e2);\n"
"CORR_ACC (_ctx_corr, e1, e2);\n"
"\n"
"aset (_ctx, 0, _ctx_vp1);\n"
"aset (_ctx, 1, _ctx_vp2);\n"
"aset (_ctx, 2, _ctx_corr);\n"
"\n"
"_env := serialize (_ctx);\n"
"}\n"
"--src useraggr.sql:557\n";

static const char *proc199 = 
" create procedure REGR_R2_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _vp1 numeric;\n"
"declare _vp2 numeric;\n"
"declare _corr numeric;\n"
"\n"
"_vp2 := VAR_POP_FIN (aref(_ctx, 1));\n"
"if (_vp2 is null or _vp2 = 0)\n"
"return null;\n"
"_vp1 := VAR_POP_FIN (aref(_ctx, 0));\n"
"if (_vp1 is null or _vp1 = 0)\n"
"return 1;\n"
"_corr := CORR_FIN (aref (_ctx, 2));\n"
"return _corr * _corr;\n"
"}\n"
"--src useraggr.sql:588\n";

static const char *other148 = 
"create aggregate DB.DBA.REGR_R2 (in e1 numeric, in e2 numeric) returns numeric from\n"
"REGR_R2_INIT, REGR_R2_ACC, REGR_R2_FIN\n";

static const char *proc200 = 
" create procedure REGR_SXX_ACC (inout _env varchar, in e1 numeric, in e2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if (e1 is null or e2 is null)\n"
"return;\n"
"\n"
"VAR_ACC (_env, e2);\n"
"}\n"
"--src useraggr.sql:616\n";

static const char *proc201 = 
" create procedure REGR_SYY_ACC (inout _env varchar, in e1 numeric, in e2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if (e1 is null or e2 is null)\n"
"return;\n"
"\n"
"VAR_ACC (_env, e1);\n"
"}\n"
"--src useraggr.sql:628\n";

static const char *proc202 = 
" create procedure REGR_SXY_ACC (inout _env varchar, in e1 numeric, in e2 numeric)\n"
"{\n"
"if (_env is null)\n"
"return;\n"
"if (e1 is null or e2 is null)\n"
"return;\n"
"\n"
"COVAR_ACC (_env, e1, e2);\n"
"}\n"
"--src useraggr.sql:640\n";

static const char *proc203 = 
" create procedure REGR_S___FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _var numeric;\n"
"\n"
"_var := VAR_POP_FIN (_env);\n"
"if (_var is null)\n"
"return null;\n"
"return aref (_ctx,0) * _var;\n"
"}\n"
"--src useraggr.sql:652\n";

static const char *proc204 = 
" create procedure REGR_SXY_FIN (inout _env varchar)\n"
"{\n"
"if (_env is null)\n"
"return null;\n"
"declare _ctx any;\n"
"_ctx := deserialize (_env);\n"
"\n"
"declare _var numeric;\n"
"\n"
"_var := COVAR_POP_FIN (_env);\n"
"if (_var is null)\n"
"return null;\n"
"return aref (_ctx,0) * _var;\n"
"}\n"
"--src useraggr.sql:669\n";

static const char *other149 = 
"create aggregate DB.DBA.REGR_SXX (in e1 numeric, in e2 numeric) returns numeric from\n"
"STD12_INIT, REGR_SXX_ACC, REGR_S___FIN\n";

static const char *other150 = 
"create aggregate DB.DBA.REGR_SYY (in e1 numeric, in e2 numeric) returns numeric from\n"
"STD12_INIT, REGR_SYY_ACC, REGR_S___FIN\n";

static const char *other151 = 
"create aggregate DB.DBA.REGR_SXY (in e1 numeric, in e2 numeric) returns numeric from\n"
"STD13_INIT, REGR_SXY_ACC, REGR_SXY_FIN\n";

static const char *proc205 = 
" create procedure xte_nodebld_final_root (in acc any) returns any\n"
"{\n"
"return xte_nodebld_xmlagg_final (acc, xte_head (UNAME\' root\'));\n"
"}\n"
"--src useraggr.sql:698\n";

static const char *other152 = 
"create aggregate DB.DBA.XMLAGG (in _child any) returns any\n"
"from xte_nodebld_init, xte_nodebld_xmlagg_acc, xte_nodebld_final_root\n";

static const char *other153 = 
"create aggregate DB.DBA.VECTOR_AGG (in _child any) returns any\n"
"from vectorbld_init, vectorbld_agg_acc, vectorbld_agg_final\n";

static const char *other154 = 
"create aggregate DB.DBA.BAG_AGG (in _child any) returns any\n"
"from vectorbld_init, vectorbld_agg_acc, vectorbld_agg_final\n";

static const char *other155 = 
"create aggregate DB.DBA.VECTOR_CONCAT_AGG (in _child any) returns any\n"
"from vectorbld_init, vectorbld_concat_agg_acc, vectorbld_agg_final\n";

static const char *other156 = 
"create aggregate DB.DBA.XQ_SEQUENCE_AGG (in _child any) returns any\n"
"from xq_sequencebld_init, xq_sequencebld_agg_acc, xq_sequencebld_agg_final\n";

/* vt_text.sql */

static const char *proc206 = 
"create procedure DB.DBA.execstmt (in stmt varchar, out stat varchar, out msg varchar)\n"
"{\n"
"stat := \'00000\';\n"
"exec (stmt, stat, msg, vector (), 0, null, null);\n"
"if (stat <> \'00000\')\n"
"{\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src vt_text.sql:27\n";

static const char *proc207 = 
"create procedure DB.DBA.vt_create_ftt (in tb varchar, in id varchar, in dbcol varchar, in is_intr integer)\n"
"{\n"
"declare stmt, stat, msg, verr varchar;\n"
"declare tbn0, tbn1, tbn2, data_table_suffix, theuser varchar;\n"
"\n"
"verr := \'\';\n"
"tb := complete_table_name ((tb), 1);\n"
"tbn0 := name_part (tb, 0);\n"
"tbn1 := name_part (tb, 1);\n"
"tbn2 := name_part (tb, 2);\n"
"data_table_suffix := concat (tbn0, \'_\', tbn1, \'_\', tbn2);\n"
"data_table_suffix := DB.DBA.SYS_ALFANUM_NAME (replace (data_table_suffix, \' \', \'_\'));\n"
"theuser := user;\n"
"if (theuser = \'dba\') theuser := \'DBA\';\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_VT_INDEX where 0 = casemode_strcmp (VI_TABLE,  tb)))\n"
"{\n"
"verr := \'FT035\';\n"
"stat := \'42S02\';\n"
"msg := sprintf (\'Text index should be enabled for the table \"%s\"\', tb);\n"
"goto err;\n"
"}\n"
"\n"
"if (not isstring (id))\n"
"select VI_ID_COL into id from DB.DBA.SYS_VT_INDEX where 0 = casemode_strcmp (VI_TABLE,  tb);\n"
"\n"
"if (not isstring (dbcol))\n"
"select VI_COL into dbcol from DB.DBA.SYS_VT_INDEX where 0 = casemode_strcmp (VI_TABLE,  tb);\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_COLS where \"TABLE\" = tb and \"COLUMN\" = id))\n"
"{\n"
"stat := \'42S22\';\n"
"verr := \'FT036\';\n"
"msg := sprintf (\'The id column \"%s\" does not exist in table \"%s\" definition\', id, tb);\n"
"goto err;\n"
"}\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_COLS where \"TABLE\" = tb and \"COLUMN\" = dbcol))\n"
"{\n"
"stat := \'42S22\';\n"
"verr := \'FT037\';\n"
"msg := sprintf (\'The data column \"%s\" does not exist in table \"%s\" definition\', dbcol, tb);\n"
"goto err;\n"
"}\n"
"\n"
"\n"
"if (is_intr = 2 and exists (select 1 from DB.DBA.SYS_KEYS\n"
"where KEY_TABLE = sprintf (\'%s.%s.%s_%s_QUERY\', tbn0, tbn1, tbn2, dbcol)))\n"
"return;\n"
"\n"
"\n"
"if (not exists\n"
"(select 1 from DB.DBA.SYS_PROCEDURES where P_NAME = sprintf (\'%I.%I.VT_HITS_%I\', tbn0, tbn1, tbn2)))\n"
"{\n"
"stmt := concat (\n"
"sprintf (\n"
"\'create procedure \"%I\".\"%I\".\"VT_BATCH_PROCESS_%s\" (inout vtb any, in doc_id int) {\\n\',tbn0, tbn1, data_table_suffix),\n"
"\'declare invd any;\\n\n"
"invd := vt_batch_strings_array (vtb);\\n\n"
"if (length (invd) < 1) return;\\n\',\n"
"sprintf (\'\"%I\".\"%I\".\"VT_HITS_%I\" (vtb, invd);\\n\', tbn0, tbn1, tbn2),\n"
"sprintf (\n"
"\'log_text (\'\'\"%I\".\"%I\".\"VT_BATCH_REAL_PROCESS_%s\" (?, ?)\'\', invd, doc_id);\\n\', tbn0, tbn1, data_table_suffix),\n"
"\'log_enable (0);\\n\',\n"
"sprintf (\n"
"\'\"%I\".\"%I\".\"VT_BATCH_REAL_PROCESS_%s\" (invd, doc_id);\\n\',tbn0, tbn1, data_table_suffix),\n"
"\'log_enable (1);}\\n\');\n"
"DB.DBA.execstr (stmt);\n"
"}\n"
"\n"
"\n"
"stmt := sprintf (\'CREATE TABLE \"%I\".\"%I\".\"%I\"\n"
"(TT_WORD VARCHAR, TT_ID INTEGER, TT_QUERY VARCHAR, TT_CD VARCHAR,\n"
"TT_COMMENT VARCHAR, TT_XPATH VARCHAR, TT_PREDICATE VARCHAR,\n"
"PRIMARY KEY (TT_WORD, TT_ID))\',\n"
"tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_QUERY\'));\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"stmt := sprintf (\'CREATE TABLE \"%I\".\"%I\".\"%I\"\n"
"(TTU_T_ID INTEGER, TTU_U_ID INTEGER, TTU_NOTIFY VARCHAR, TTU_COMMENT VARCHAR,\n"
"PRIMARY KEY (TTU_T_ID, TTU_U_ID))\',\n"
"tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_USER\'));\n"
"\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"stmt := sprintf (\'CREATE TABLE \"%I\".\"%I\".\"%I\"\n"
"(TTH_U_ID INTEGER, TTH_D_ID any, TTH_T_ID INTEGER, TTH_TITLE VARCHAR,\n"
"TTH_URL VARCHAR, TTH_TS TIMESTAMP, TTH_NOTIFY VARCHAR,\n"
"PRIMARY KEY (TTH_U_ID, TTH_TS, TTH_D_ID, TTH_T_ID))\',\n"
"tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_HIT\'));\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"\n"
"\n"
"stmt := sprintf (\'CREATE TRIGGER \"%I_FTT_D\" AFTER DELETE ON \"%I\".\"%I\".\"%I\" ORDER 3 %s\n"
"DELETE FROM \"%I\".\"%I\".\"%I_%I_HIT\" WHERE TTH_D_ID = \"%I\"; %s\',\n"
"tbn2, tbn0, tbn1, tbn2, \'{\', tbn0, tbn1, tbn2, dbcol, id, \'}\');\n"
"\n"
"\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"stmt := concat ( sprintf (\'create procedure \"%I\".\"%I\".\"VT_HITS_%I\"\', tbn0, tbn1, tbn2), \'(inout vtb any, inout strs any)\n"
"{\n"
"declare tried, hits, doc_id, u_id integer;\n"
"declare len, inx int;\n"
"inx := 0;len := length (strs);tried := 0;\',\n"
"sprintf (\'if (registry_get (\'\'tt_%s_%s_%s\'\') = \'\'OFF\'\') return;\', tbn0, tbn1, tbn2),\n"
"\'while (inx < len)\n"
"{\n"
"for select TT_ID, TT_QUERY, TT_COMMENT, TT_CD, TT_XPATH from \',\n"
"sprintf (\'\"%I\".\"%I\".\"%I\"\', tbn0, tbn1, concat(tbn2, \'_\', dbcol, \'_QUERY\')), \'\n"
"where TT_WORD = aref (strs, inx) do\n"
"{\n"
"declare ids, ntf, xp any;\n"
"tried := tried + 1;\n"
"declare ii, is_xp int;\n"
"is_xp := 0;\n"
"if (TT_XPATH is not null and TT_XPATH <> \'\'\'\')\n"
"{\n"
"xp := deserialize (TT_QUERY);\n"
"ids := vt_batch_match (vtb, xp);\n"
"is_xp := 1;\n"
"}\n"
"else\n"
"ids := vt_batch_match (vtb, TT_QUERY);\n"
"hits := hits + length (ids);\n"
"ii := 0;\',\n"
"sprintf (\'select TTU_NOTIFY, TTU_U_ID into ntf, u_id from \"%I\".\"%I\".\"%I_%I_USER\" where TTU_T_ID = TT_ID;\', tbn0, tbn1, tbn2, dbcol),\n"
"\'while (ii < length (ids))\n"
"{\n"
"doc_id := aref (ids, ii);\n"
"if (<INSERT_COND>)\n"
"{\n"
"\', sprintf (\'if ((is_xp = 0)\n"
"or (is_xp = 1 and exists (select 1 from \"%I\".\"%I\".\"%I\"\n"
"where \"%I\" = doc_id and xpath_contains (\"%I\", TT_XPATH))))\',\n"
"tbn0, tbn1, tbn2, id, dbcol),\n"
"sprintf (\'insert soft \"%I\".\"%I\".\"%I\" (TTH_U_ID, TTH_T_ID, TTH_D_ID, TTH_NOTIFY)\n"
"select TTU_U_ID, TT_ID, doc_id, ntf from \"%I\".\"%I\".\"%I\" where TTU_T_ID = TT_ID;\n"
"}\n"
"ii := ii + 1;\n"
"}\n"
"}\n"
"inx := inx + 2;\n"
"}\n"
"\n"
"}\',  tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_HIT\'),\n"
"tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_USER\')));\n"
"\n"
"if (0 <> casemode_strcmp (tb, \'WS.WS.SYS_DAV_RES\'))\n"
"stmt := replace (stmt, \'<INSERT_COND>\', \'1 = 1\');\n"
"else\n"
"stmt := replace (stmt, \'<INSERT_COND>\', \'WS.WS.CHECK_READ_ACCESS (u_id, doc_id)\');\n"
"\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"stmt := sprintf (\' create procedure \"%I\".\"%I\".\"TT_WORD_FREQ_%I\" (in w varchar)\n"
"{\n"
"declare l1, l2 integer;\n"
"l1 := 0; l2 := 0;\n"
"whenever not found goto none;\n"
"select sum (length (VT_DATA)),\n"
"sum (length (VT_LONG_DATA)) into l1, l2 from \"%I\".\"%I\".\"%I_%I_WORDS\"\n"
"where VT_WORD = w;\n"
"\n"
"none:\n"
"return (coalesce (l1, 0)  + coalesce (l2, 0));\n"
"}\', tbn0, tbn1, tbn2, tbn0, tbn1, tbn2, dbcol);\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"stmt := sprintf (\'create procedure \"%I\".\"%I\".\"TT_QUERY_%I\" (in exp varchar, in u_id int, in comment varchar,\n"
"in notify varchar, in user_data varchar := null, in predicate varchar := null)\n"
"{\n"
"declare t_id, ix, len integer;\n"
"declare w any;\n"
"t_id := coalesce ((select top 1 TT_ID + 1 from \"%I\".\"%I\".\"%I_%I_QUERY\"\n"
"order by TT_ID desc), 1);\n"
"w := \"%I\".\"%I\".\"TT_QUERY_WORD_%I\" (exp, 0);\n"
"len := length (w); ix := 0;\n"
"while (ix < len) {\n"
"insert into  \"%I\".\"%I\".\"%I_%I_QUERY\" (TT_ID, TT_QUERY, TT_WORD, TT_COMMENT, TT_CD, TT_PREDICATE)\n"
"values (t_id, exp, aref (w, ix), comment, user_data, predicate);\n"
"ix := ix + 1;\n"
"}\n"
"insert soft \"%I\".\"%I\".\"%I_%I_USER\" (TTU_T_ID, TTU_U_ID, TTU_NOTIFY, TTU_COMMENT)\n"
"values (t_id, u_id, notify, comment);\n"
"}\', tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2, dbcol);\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"\n"
"stmt := sprintf (\'create procedure \"%I\".\"%I\".\"TT_XPATH_QUERY_%I\" (in exp varchar, in u_id int, in comment varchar,\n"
"in notify varchar, in user_data varchar := null, in predicate varchar := null)\n"
"{\n"
"declare t_id, ix, len integer;\n"
"declare w any;\n"
"declare xp any;\n"
"xp := xpath_text (exp);\n"
"t_id := coalesce ((select top 1 TT_ID + 1 from \"%I\".\"%I\".\"%I_%I_QUERY\"\n"
"order by TT_ID desc), 1);\n"
"w := \"%I\".\"%I\".\"TT_QUERY_WORD_%I\" (xp, 1);\n"
"len := length (w); ix := 0;\n"
"while (ix < len) {\n"
"insert into  \"%I\".\"%I\".\"%I_%I_QUERY\" (TT_ID, TT_QUERY, TT_WORD, TT_COMMENT, TT_XPATH, TT_CD, TT_PREDICATE)\n"
"values (t_id, serialize (xp), aref (w, ix), comment, exp, user_data, predicate);\n"
"ix := ix + 1;\n"
"}\n"
"insert soft \"%I\".\"%I\".\"%I_%I_USER\" (TTU_T_ID, TTU_U_ID, TTU_NOTIFY, TTU_COMMENT)\n"
"values (t_id, u_id, notify, comment);\n"
"}\', tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2, dbcol);\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"\n"
"\n"
"declare pname varchar;\n"
"pname := sprintf (\'\"%I\".\"%I\".\"TT_QUERY_WORD_1_%I\"\', tbn0, tbn1, tbn2);\n"
"stmt := sprintf (\'create procedure %s\n"
"(in tree any, inout best_w varchar, inout score integer, in topop integer, inout words any)\n"
"{\n"
"declare op integer;\n"
"if (isarray (tree))\n"
"{\n"
"op := aref (tree, 0);\n"
"if (op = 4 or op = 1210 or op = 1209)\n"
"{\n"
"declare inx int;\n"
"inx := 0;\n"
"while (inx < length (tree))\n"
"{\n"
"%s (aref (tree, inx), best_w, score, op, words);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"else if (op = 1211)\n"
"{\n"
"%s (aref (tree, 2), best_w, score, op, words);\n"
"}\n"
"else if (op = 1)\n"
"{\n"
"declare ct int;\n"
"declare searched_word varchar;\n"
"searched_word := aref (tree, 2);\n"
"if (strchr (searched_word, \'\'*\'\') is not null)\n"
"return;\n"
"ct := \"%I\".\"%I\".\"TT_WORD_FREQ_%I\" (searched_word);\n"
"if (ct < score and topop <> 3)\n"
"{\n"
"score := ct;\n"
"best_w := searched_word;\n"
"}\n"
"else if (topop = 3)\n"
"best_w := searched_word;\n"
"}\n"
"else if (op = 3)\n"
"{\n"
"declare inx, sc1 int;\n"
"inx := 0;\n"
"while (inx < length (tree))\n"
"{\n"
"best_w := null;\n"
"sc1 := score;\n"
"score := 1000000000;\n"
"%s (aref (tree, inx), best_w, score, op, words);\n"
"if (words is null and best_w is not null)\n"
"words := vector (best_w);\n"
"else if (best_w is not null)\n"
"words := vector_concat (words, vector (best_w));\n"
"score := sc1;\n"
"best_w := null;\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"}\n"
"}\', pname, pname, pname, tbn0, tbn1, tbn2, pname);\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"stmt := sprintf (\'create procedure \"%I\".\"%I\".\"TT_QUERY_WORD_%I\" (in exp varchar, in is_xpath integer)\n"
"{\n"
"declare tree, ws1 any;\n"
"declare w varchar;\n"
"declare sc int;\n"
"sc := 1000000000;\n"
"w := \'\'__\'\';\n"
"ws1 := null;\n"
"if (is_xpath = 0)\n"
"tree := vt_parse (exp);\n"
"else\n"
"tree := exp;\n"
"%s (tree, w, sc, 0, ws1);\n"
"if (w is not null)\n"
"return vector (w);\n"
"else if (isarray (ws1))\n"
"return ws1;\n"
"return vector (\'\'__\'\');\n"
"}\', tbn0, tbn1, tbn2, pname);\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"\n"
"stmt := sprintf (\'create procedure \"%I\".\"%I\".\"TT_NOTIFY_%I\" () {\n"
"declare stat, msg, ntf, comment varchar;\n"
"declare _u_id, _ts, _d_id, _t_id, rc_call any;\n"
"\n"
"for select distinct TTH_NOTIFY as _tt_notify from  \"%I\".\"%I\".\"%I_%I_HIT\" where TTH_NOTIFY like \'\'%%@%%\'\' do\n"
"{\n"
"declare _message, _msg_tit varchar;\n"
"declare _cnt_hits integer;\n"
"declare _short_text varchar;\n"
"declare hits_data any;\n"
"_cnt_hits := 0;\n"
"_message := \'\'\\\\r\\\\nQuery/Hit Date/Document ID\'\';\n"
"hits_data := vector ();\n"
"for select TTH_U_ID, TTH_TS, TTH_D_ID, TTH_T_ID, TTH_NOTIFY\n"
"from  \"%I\".\"%I\".\"%I_%I_HIT\" where TTH_NOTIFY = _tt_notify\n"
"order by TTH_TS\n"
"do\n"
"{\n"
"whenever not found goto nfq;\n"
"select coalesce (TT_COMMENT, TT_QUERY) into comment from\n"
"\"%I\".\"%I\".\"%I_%I_QUERY\" where TT_ID = TTH_T_ID;\n"
"nfq:\n"
"if (comment is null)\n"
"comment := \'\'*** no query ***\'\';\n"
"_cnt_hits := _cnt_hits + 1;\n"
"hits_data := vector_concat (hits_data, vector (vector (comment, TTH_TS, TTH_D_ID)));\n"
"_message := concat (_message, \'\'\\\\r\\\\n\'\', comment, \'\'/\'\',\n"
"substring (datestring (TTH_TS), 1, 19), \'\'/\'\',\n"
"cast (TTH_D_ID as varchar));\n"
"}\n"
"stat := \'\'00000\'\';\n"
"_msg_tit := concat (\'\'Subject: Text trigger notification: New \'\',\n"
"cast (_cnt_hits as varchar) , \'\' hit(s) registered\\\\r\\\\n\'\');\n"
"_message := concat (_msg_tit, _message);\n"
"\n"
"rc_call := 0;\n"
"if (__proc_exists (\'\'%s.%s.%s_INFO_TEXT\'\'))\n"
"{\n"
"rc_call := call (\'\'%s.%s.%s_INFO_TEXT\'\') (_tt_notify, hits_data);\n"
"}\n"
"if (not rc_call)\n"
"{\n"
"exec (\'\'smtp_send (null,?,?,?)\'\', stat, msg,\n"
"vector (_tt_notify, _tt_notify, _message));\n"
"}\n"
"update \"%I\".\"%I\".\"%I_%I_HIT\" set TTH_NOTIFY = \'\'\'\' where TTH_NOTIFY = _tt_notify;\n"
"}\n"
"return;\n"
"}\',\n"
"tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2, dbcol,\n"
"tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2,\n"
"tbn0, tbn1, tbn2, dbcol);\n"
"\n"
"\n"
"\n"
"if (DB.DBA.execstmt (stmt, stat, msg))\n"
"goto err;\n"
"\n"
"\n"
"insert into DB.DBA.SYS_SCHEDULED_EVENT (SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values (sprintf (\'Notification for text hits on \"%s.%s.%s\"\', tbn0, tbn1, tbn2), now (), sprintf (\'\"%I\".\"%I\".\"TT_NOTIFY_%I\"()\', tbn0, tbn1, tbn2), 10);\n"
"\n"
"return 0;\n"
"\n"
"err:\n"
"if (stat <> \'42S01\' and verr <> \'FT035\' and verr <> \'FTT036\' and  verr <> \'FT037\')\n"
"DB.DBA.vt_drop_ftt (tb, dbcol);\n"
"if (is_intr <> 2 and verr <> \'\')\n"
"{\n"
"signal (stat, msg, verr);\n"
"}\n"
"else if (is_intr <> 2 and verr = \'\')\n"
"{\n"
"signal (stat, msg);\n"
"}\n"
"}\n"
"--src vt_text.sql:39\n";

static const char *proc208 = 
"create procedure DB.DBA.vt_drop_ftt (in tb varchar, in dbcol varchar)\n"
"{\n"
"declare stmt, stat, msg varchar;\n"
"declare tbn0, tbn1, tbn2 varchar;\n"
"\n"
"\n"
"tb := complete_table_name ((tb), 1);\n"
"tbn0 := name_part (tb, 0);\n"
"tbn1 := name_part (tb, 1);\n"
"tbn2 := name_part (tb, 2);\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_VT_INDEX where 0 = casemode_strcmp (VI_TABLE,  tb)))\n"
"signal (\'42S02\', sprintf (\'Text index not defined for \"%s\"\', tb), \'FT034\');\n"
"\n"
"if (not isstring (dbcol))\n"
"select VI_COL into dbcol from DB.DBA.SYS_VT_INDEX where 0 = casemode_strcmp (VI_TABLE,  tb);\n"
"\n"
"stmt := sprintf (\'DROP TRIGGER \"%I\".\"%I\".\"%I_FTT_D\"\', tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"VT_HITS_%I\"\' , tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"TT_WORD_FREQ_%I\"\', tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"TT_QUERY_%I\"\', tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"TT_XPATH_QUERY_%I\"\', tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"TT_QUERY_WORD_1_%I\"\', tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"TT_QUERY_WORD_%I\"\',tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP PROCEDURE \"%I\".\"%I\".\"TT_NOTIFY_%I\"\',tbn0, tbn1, tbn2);\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP TABLE \"%I\".\"%I\".\"%I\"\', tbn0, tbn1, concat (tbn2, \'_\', dbcol,\'_QUERY\'));\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP TABLE \"%I\".\"%I\".\"%I\"\', tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_USER\'));\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'DROP TABLE \"%I\".\"%I\".\"%I\"\', tbn0, tbn1, concat (tbn2, \'_\', dbcol, \'_HIT\'));\n"
"\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"stmt := sprintf (\'create procedure \"%I\".\"%I\".\"VT_HITS_%I\" (inout vtb any, inout strs any)\n"
"{ return; }\', tbn0, tbn1, tbn2 );\n"
"DB.DBA.execstmt (stmt, stat, msg);\n"
"\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = sprintf (\'Notification for text hits on \"%s.%s.%s\"\', tbn0, tbn1, tbn2);\n"
"return;\n"
"}\n"
"--src vt_text.sql:427\n";

static const char *other157 = 
"grant execute on DB.DBA.vt_create_text_index to public\n";
/* phrasematch.sql */

static const char *proc209 = 
"create procedure AP_EXEC_NO_ERROR (in expr varchar)\n"
"{\n"
"declare state, message, meta, result any;\n"
"exec(expr, state, message, vector(), 0, meta, result);\n"
"}\n"
"--src phrasematch.sql:23\n";

static const char *tbl6 = 
"create table DB.DBA.SYS_ANN_PHRASE_CLASS\n"
"(\n"
"APC_ID integer not null primary key,\n"
"APC_NAME varchar(255),\n"
"APC_OWNER_UID integer,\n"
"APC_READER_GID integer,\n"
"APC_CALLBACK varchar,\n"
"APC_APP_ENV any\n"
")\n"
"alter index SYS_ANN_PHRASE_CLASS on DB.DBA.SYS_ANN_PHRASE_CLASS partition cluster replicated\n"
"create unique index SYS_ANN_PHRASE_CLASS_APC_NAME on DB.DBA.SYS_ANN_PHRASE_CLASS (APC_NAME) partition cluster replicated\n";

static const char *tbl7 = 
"create table DB.DBA.SYS_ANN_PHRASE_SET\n"
"(\n"
"APS_ID integer not null primary key,\n"
"APS_NAME varchar(255),\n"
"APS_OWNER_UID integer,\n"
"APS_READER_GID integer,\n"
"APS_APC_ID integer not null,\n"
"APS_LANG_NAME varchar not null,\n"
"APS_APP_ENV any,\n"
"APS_SIZE any,\n"
"APS_LOAD_AT_BOOT integer not null\n"
")\n"
"alter index SYS_ANN_PHRASE_SET on DB.DBA.SYS_ANN_PHRASE_SET partition cluster replicated\n"
"create unique index SYS_ANN_PHRASE_SET_APS_NAME on DB.DBA.SYS_ANN_PHRASE_SET (APS_NAME) partition cluster replicated\n";

static const char *tbl8 = 
"create table DB.DBA.SYS_ANN_PHRASE\n"
"(\n"
"AP_APS_ID integer not null,\n"
"AP_CHKSUM integer,\n"
"AP_TEXT varchar,\n"
"AP_LINK_DATA any,\n"
"AP_LINK_DATA_LONG long varchar,\n"
"primary key (AP_APS_ID, AP_CHKSUM, AP_TEXT)\n"
")\n"
"alter index SYS_ANN_PHRASE on DB.DBA.SYS_ANN_PHRASE partition cluster replicated\n";

static const char *tbl9 = 
"create table DB.DBA.SYS_ANN_AD_ACCOUNT (\n"
"AAA_ID integer not null primary key,\n"
"AAA_NAME varchar(255),\n"
"AAA_OWNER_UID integer,\n"
"AAA_READER_GID integer,\n"
"AAA_DETAILS long xml,\n"
"AAA_APP_ENV any\n"
")\n"
"alter index SYS_ANN_AD_ACCOUNT on DB.DBA.SYS_ANN_AD_ACCOUNT partition cluster replicated\n"
"create unique index SYS_ANN_AD_ACCOUNT_AAA_NAME on DB.DBA.SYS_ANN_AD_ACCOUNT (AAA_NAME) partition cluster replicated\n";

static const char *tbl10 = 
"create table DB.DBA.SYS_ANN_LINK (\n"
"AL_ID integer primary key,\n"
"AL_OWNER_UID integer,\n"
"AL_URI varchar,\n"
"AL_TEXT varchar,\n"
"AL_NOTE varchar,\n"
"AL_TAGS any,\n"
"AL_CALLBACK varchar,\n"
"AL_APP_ENV any\n"
")\n"
"alter index SYS_ANN_LINK on DB.DBA.SYS_ANN_LINK partition cluster replicated\n";

static const char *tbl11 = 
"create table DB.DBA.SYS_ANN_AD_RULE (\n"
"AAR_AAA_ID integer not null,\n"
"AAR_APS_ID integer not null,\n"
"AAR_AP_CHKSUM integer not null,\n"
"AAR_TEXT varchar not null,\n"
"AAR_AL_ID integer not null,\n"
"AAR_APP_ENV any,\n"
"primary key (AAR_AAA_ID, AAR_APS_ID, AAR_AP_CHKSUM, AAR_TEXT, AAR_AL_ID)\n"
")\n"
"alter index SYS_ANN_AD_RULE on DB.DBA.SYS_ANN_AD_RULE partition cluster replicated\n";

static const char *trig0 = 
"create trigger SYS_ANN_PHRASE_CLASS_I after insert on DB.DBA.SYS_ANN_PHRASE_CLASS referencing new as N\n"
"{\n"
"ap_class_status (N.APC_ID, 1, 1);\n"
"}\n"
"--src phrasematch.sql:148\n";

static const char *trig1 = 
"create trigger SYS_ANN_PHRASE_CLASS_U after update on DB.DBA.SYS_ANN_PHRASE_CLASS referencing new as N\n"
"{\n"
"ap_class_status (N.APC_ID, 1, 1);\n"
"}\n"
"--src phrasematch.sql:154\n";

static const char *trig2 = 
"create trigger SYS_ANN_PHRASE_CLASS_BD before delete on DB.DBA.SYS_ANN_PHRASE_CLASS referencing old as O\n"
"{\n"
"if (exists (select top 1 1 from DB.DBA.SYS_ANN_PHRASE_SET where APS_APC_ID = O.APC_ID))\n"
"signal (\'42000\', sprintf (\'Integrity violation: can not delete annotation phrase class \"%s\" that is referenced by a phrase set\', O.APC_NAME));\n"
"ap_class_status (O.APC_ID, 0);\n"
"}\n"
"--src phrasematch.sql:160\n";

static const char *trig3 = 
"create trigger SYS_ANN_PHRASE_SET_I after insert on DB.DBA.SYS_ANN_PHRASE_SET referencing new as N\n"
"{\n"
"ap_set_status (N.APS_ID, 1, 1);\n"
"}\n"
"--src phrasematch.sql:168\n";

static const char *trig4 = 
"create trigger SYS_ANN_PHRASE_SET_U after update on DB.DBA.SYS_ANN_PHRASE_SET referencing new as N\n"
"{\n"
"ap_set_status (N.APS_ID, 1, 1);\n"
"}\n"
"--src phrasematch.sql:174\n";

static const char *trig5 = 
"create trigger SYS_ANN_PHRASE_SET_BD before delete on DB.DBA.SYS_ANN_PHRASE_SET referencing old as O\n"
"{\n"
"ap_set_status (O.APS_ID, 0);\n"
"}\n"
"--src phrasematch.sql:180\n";

static const char *proc210 = 
"create procedure DB.DBA.ANN_BOOT()\n"
"{\n"
"ap_global_init ();\n"
"for select APC_ID from DB.DBA.SYS_ANN_PHRASE_CLASS do\n"
"{\n"
"ap_class_status (APC_ID, 1, 0);\n"
"}\n"
"for select APS_ID, APS_LOAD_AT_BOOT from DB.DBA.SYS_ANN_PHRASE_SET do\n"
"{\n"
"ap_set_status (APS_ID, case (APS_LOAD_AT_BOOT) when 0 then 1 else 2 end, 0);\n"
"}\n"
"}\n"
"--src phrasematch.sql:186\n";

static const char *proc211 = 
"create function ANN_AUTHENTICATE (in id any, in what char (1), in access char, in auth_uname any, in auth_pwd varchar, inout auth_uid integer := null) returns integer\n"
"{\n"
"declare uid, owner_uid, reader_gid, res_id integer;\n"
"declare pwd varchar;\n"
"whenever not found goto obj_nf;\n"
"if (\'C\' = what)\n"
"{\n"
"if (isinteger (id))\n"
"select APC_ID, APC_OWNER_UID, APC_READER_GID into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_PHRASE_CLASS where APC_ID = id;\n"
"else\n"
"select APC_ID, APC_OWNER_UID, APC_READER_GID into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_PHRASE_CLASS where APC_NAME = id;\n"
"}\n"
"else if (\'S\' = what)\n"
"{\n"
"if (isinteger (id))\n"
"select APS_ID, APS_OWNER_UID, APS_READER_GID into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_PHRASE_SET where APS_ID = id;\n"
"else\n"
"select APS_ID, APS_OWNER_UID, APS_READER_GID into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_PHRASE_SET where APS_NAME = id;\n"
"}\n"
"else if (\'A\' = what)\n"
"{\n"
"if (isinteger (id))\n"
"select AAA_ID, AAA_OWNER_UID, AAA_READER_GID into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_AD_ACCOUNT where AAA_ID = id;\n"
"else\n"
"select AAA_ID, AAA_OWNER_UID, AAA_READER_GID into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_AD_ACCOUNT where AAA_NAME = id;\n"
"}\n"
"else if (\'L\' = what)\n"
"{\n"
"if (isinteger (id))\n"
"select AL_ID, AL_OWNER_UID, null into res_id, owner_uid, reader_gid from DB.DBA.SYS_ANN_LINK where AL_ID = id;\n"
"else\n"
"return -7;\n"
"}\n"
"else return -14;\n"
"whenever not found goto user_nf;\n"
"if (auth_uid is null)\n"
"{\n"
"if (isinteger (auth_uname))\n"
"select U_PASSWORD, U_ID into pwd, uid from DB.DBA.SYS_USERS where U_ID = auth_uname and (0 = U_ACCOUNT_DISABLED) and U_SQL_ENABLE;\n"
"else\n"
"select U_PASSWORD, U_ID into pwd, uid from DB.DBA.SYS_USERS where U_NAME = auth_uname;\n"
"if (isstring (pwd))\n"
"{\n"
"if ((pwd[0] = 0 and not pwd_magic_calc (auth_uname, auth_pwd) = pwd) or (pwd[0] <> 0 and pwd <> auth_pwd))\n"
"{\n"
"\n"
"return -12;\n"
"}\n"
"}\n"
"auth_uid := uid;\n"
"}\n"
"else\n"
"uid := auth_uid;\n"
"\n"
"if (0 = uid)\n"
"return res_id;\n"
"if (owner_uid is not null)\n"
"{\n"
"if (owner_uid = uid)\n"
"return res_id;\n"
"if (\'W\' = access)\n"
"return -12;\n"
"}\n"
"if (reader_gid is not null)\n"
"{\n"
"if (exists (select top 1 1 from DB.DBA.SYS_USER_GROUP where UG_UID = uid and UG_GID = reader_gid))\n"
"return res_id;\n"
"return -12;\n"
"}\n"
"return res_id;\n"
"obj_nf:\n"
"return -1;\n"
"user_nf:\n"
"\n"
"return -12;\n"
"}\n"
"--src phrasematch.sql:200\n";

static const char *proc212 = 
"create function ANN_GETID (in what varchar )\n"
"{\n"
"if (\'C\' = what)\n"
"{\n"
"return coalesce (\n"
"(select top 1 (t.APC_ID-1) from DB.DBA.SYS_ANN_PHRASE_CLASS as t where t.APC_ID > 1 and not exists (select top 1 1 from DB.DBA.SYS_ANN_PHRASE_CLASS as i where i.APC_ID = t.APC_ID-1)),\n"
"(select max (u.APC_ID+1) from DB.DBA.SYS_ANN_PHRASE_CLASS as u),\n"
"1 );\n"
"}\n"
"if (\'S\' = what)\n"
"{\n"
"return coalesce (\n"
"(select top 1 (t.APS_ID-1) from DB.DBA.SYS_ANN_PHRASE_SET as t where t.APS_ID > 1 and not exists (select top 1 1 from DB.DBA.SYS_ANN_PHRASE_SET as i where i.APS_ID = t.APS_ID-1)),\n"
"(select max (u.APS_ID+1) from DB.DBA.SYS_ANN_PHRASE_SET as u),\n"
"1 );\n"
"}\n"
"if (\'A\' = what)\n"
"{\n"
"return coalesce (\n"
"(select top 1 (t.AAA_ID-1) from DB.DBA.SYS_ANN_AD_ACCOUNT as t where t.AAA_ID > 1 and not exists (select top 1 1 from DB.DBA.SYS_ANN_AD_ACCOUNT as i where i.AAA_ID = t.AAA_ID-1)),\n"
"(select max (u.AAA_ID+1) from DB.DBA.SYS_ANN_AD_ACCOUNT as u),\n"
"1 );\n"
"}\n"
"if (\'L\' = what)\n"
"{\n"
"return coalesce (\n"
"(select top 1 (t.AL_ID-1) from DB.DBA.SYS_ANN_LINK as t where t.AL_ID > 1 and not exists (select top 1 1 from DB.DBA.SYS_ANN_LINK as i where i.AL_ID = t.AL_ID-1)),\n"
"(select max (u.AL_ID+1) from DB.DBA.SYS_ANN_LINK as u),\n"
"1 );\n"
"}\n"
"return -14;\n"
"}\n"
"--src phrasematch.sql:278\n";

static const char *proc213 = 
" create function ANN_PHRASE_CLASS_ADD (in _name varchar, in _owner_uid integer, in _reader_gid integer, in _callback varchar, in _app_env any, in mode varchar, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare auth_uid, _id integer;\n"
"mode := lower (mode);\n"
"auth_uid := NULL;\n"
"_id := ANN_AUTHENTICATE (_name, \'C\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_id < -1)\n"
"return _id;\n"
"if (_id = -1)\n"
"_id := ANN_GETID (\'C\');\n"
"else\n"
"{\n"
"if (\'into\' = mode)\n"
"signal (\'23000\', sprintf (\'Uniqueness violation: Annotation phrase class \'\'%s\'\' exists\', _name));\n"
"if (\'soft\' = mode)\n"
"return _id;\n"
"}\n"
"return ANN_PHRASE_CLASS_ADD_INT (_id, _name, _owner_uid, _reader_gid, _callback, _app_env);\n"
"}\n"
"--src phrasematch.sql:313\n";

static const char *proc214 = 
"create function ANN_PHRASE_CLASS_ADD_INT (in _id integer, in _name varchar, in _owner_uid integer, in _reader_gid integer, in _callback varchar, in _app_env any)\n"
"{\n"
"insert replacing DB.DBA.SYS_ANN_PHRASE_CLASS (APC_ID, APC_NAME, APC_OWNER_UID, APC_READER_GID, APC_CALLBACK, APC_APP_ENV)\n"
"values (_id, _name, _owner_uid, _reader_gid, _callback, _app_env);\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:334\n";

static const char *proc215 = 
" create function ANN_PHRASE_CLASS_DEL (in _name varchar, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare auth_uid, _id integer;\n"
"auth_uid := NULL;\n"
"_id := ANN_AUTHENTICATE (_name, \'C\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_id < 0)\n"
"return _id;\n"
"if (exists (select top 1 1 from DB.DBA.SYS_ANN_PHRASE_SET where APS_APC_ID = _id))\n"
"{\n"
"declare use_sample_name varchar;\n"
"use_sample_name := coalesce ((select top 1 APS_NAME from DB.DBA.SYS_ANN_PHRASE_SET where ANN_AUTHENTICATE (APS_NAME, \'S\', \'R\', auth_uname, auth_pwd, auth_uid)));\n"
"if (use_sample_name is null)\n"
"signal (\'23000\', sprintf (\'Integrity violation: annotation phrase class \'\'%s\'\' is used in definition of some annotation phrase set\', _name));\n"
"else\n"
"signal (\'23000\', sprintf (\'Integrity violation: annotation phrase class \'\'%s\'\' is used in definition of annotation phrase set \'\'%s\'\'\', _name, use_sample_name));\n"
"}\n"
"delete from DB.DBA.SYS_ANN_PHRASE_CLASS where APC_ID = _id;\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:343\n";

static const char *proc216 = 
" create function ANN_PHRASE_SET_ADD (in _name varchar, in _owner_uid integer, in _reader_gid integer, in _apc_name varchar, in _lang_name varchar, in _app_env any, in _size integer, in _load_at_boot integer, in mode varchar, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare auth_uid, _id, _apc_id integer;\n"
"mode := lower (mode);\n"
"auth_uid := NULL;\n"
"_apc_id := ANN_AUTHENTICATE (_apc_name, \'C\', \'R\', auth_uname, auth_pwd, auth_uid);\n"
"if (_apc_id < 0)\n"
"return _apc_id;\n"
"_id := ANN_AUTHENTICATE (_name, \'S\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_id < -1)\n"
"return _id;\n"
"if (_id = -1)\n"
"_id := ANN_GETID (\'S\');\n"
"else\n"
"{\n"
"declare old_lang_name varchar;\n"
"if (\'into\' = mode)\n"
"signal (\'23000\', sprintf (\'Uniqueness violation: Annotation phrase set \'\'%s\'\' exists\', _name));\n"
"old_lang_name := coalesce ((select APS_LANG_NAME from DB.DBA.SYS_ANN_PHRASE_SET where APS_ID = _id));\n"
"if (_lang_name <> old_lang_name)\n"
"signal (\'23000\', sprintf (\'Integrity violation: Annotation phrase set \'\'%s\'\' uses language \'\'%s\'\' that can not be replaced with \'\'%s\'\'\', _name, old_lang_name, _lang_name));\n"
"if (\'soft\' = mode)\n"
"return _id;\n"
"}\n"
"return ANN_PHRASE_SET_ADD_INT (_id, _name, _owner_uid, _reader_gid, _apc_id, _lang_name, _app_env, _size, _load_at_boot);\n"
"}\n"
"--src phrasematch.sql:365\n";

static const char *proc217 = 
"create function ANN_PHRASE_SET_ADD_INT (in _id integer, in _name varchar, in _owner_uid integer, in _reader_gid integer, in _apc_id integer, in _lang_name varchar, in _app_env any, in _size integer, in _load_at_boot integer)\n"
"{\n"
"insert replacing DB.DBA.SYS_ANN_PHRASE_SET (APS_ID, APS_NAME, APS_OWNER_UID, APS_READER_GID, APS_APC_ID, APS_LANG_NAME, APS_APP_ENV, APS_SIZE, APS_LOAD_AT_BOOT)\n"
"values (_id, _name, _owner_uid, _reader_gid, _apc_id, _lang_name, _app_env, _size, _load_at_boot);\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:393\n";

static const char *proc218 = 
" create function ANN_PHRASE_SET_DEL (in _name varchar, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare auth_uid, _id integer;\n"
"auth_uid := NULL;\n"
"_id := ANN_AUTHENTICATE (_name, \'S\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_id < 0)\n"
"return _id;\n"
"if (exists (select top 1 1 from DB.DBA.SYS_ANN_AD_RULE where AAR_APS_ID = _id))\n"
"{\n"
"declare use_sample_name varchar;\n"
"use_sample_name := coalesce ((select top 1 AAA_NAME from DB.DBA.SYS_ANN_AD_RULE join DB.DBA.SYS_ANN_AD_ACCOUNT on (AAR_AAA_ID = AAA_ID) where AAR_APS_ID = _id and ANN_AUTHENTICATE (AAA_ID, \'A\', \'R\', auth_uname, auth_pwd, auth_uid)));\n"
"if (use_sample_name is null)\n"
"signal (\'23000\', sprintf (\'Integrity violation: annotation phrase set \'\'%s\'\' is used by some advertizer\', _name));\n"
"else\n"
"signal (\'23000\', sprintf (\'Integrity violation: annotation phrase set \'\'%s\'\' is used by advertizer \'\'%s\'\'\', _name, use_sample_name));\n"
"}\n"
"delete from DB.DBA.SYS_ANN_PHRASE where AP_APS_ID = _id;\n"
"delete from DB.DBA.SYS_ANN_PHRASE_SET where APS_ID = _id;\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:402\n";

static const char *proc219 = 
" create function ANN_LINK_ADD (in _owner_uid integer, in _uri varchar, in _text varchar, in _note varchar, in _tags any, in _callback varchar, in _app_env any) returns integer\n"
"{\n"
"declare _id integer;\n"
"_id := ANN_GETID (\'L\');\n"
"insert into DB.DBA.SYS_ANN_LINK (AL_ID, AL_OWNER_UID, AL_URI, AL_TEXT, AL_NOTE, AL_TAGS, AL_CALLBACK, AL_APP_ENV)\n"
"values (_id, _owner_uid, _uri, _text, _note, _tags, _callback, _app_env);\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:425\n";

static const char *proc220 = 
" create function ANN_LINK_MODIFY (in _id integer, in _owner_uid integer, in _uri varchar, in _text varchar, in _note varchar, in _tags any, in _callback varchar, in _app_env any, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare _res integer;\n"
"declare auth_uid integer;\n"
"auth_uid := NULL;\n"
"_res := ANN_AUTHENTICATE (_id, \'L\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_res < 0)\n"
"return _res;\n"
"insert replacing DB.DBA.SYS_ANN_LINK (AL_ID, AL_OWNER_UID, AL_URI, AL_TEXT, AL_NOTE, AL_TAGS, AL_CALLBACK, AL_APP_ENV)\n"
"values (_id, _owner_uid, _uri, _text, _note, _tags, _callback, _app_env);\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:436\n";

static const char *proc221 = 
" create function ANN_LINK_DEL (in _id integer, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare _res integer;\n"
"declare auth_uid integer;\n"
"auth_uid := NULL;\n"
"_res := ANN_AUTHENTICATE (_id, \'L\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_res < 0)\n"
"return _res;\n"
"if (exists (select top 1 1 from DB.DBA.SYS_ANN_AD_RULE where AAR_AL_ID = _id))\n"
"{\n"
"declare use_sample_name varchar;\n"
"use_sample_name := coalesce ((select top 1 AAA_NAME from DB.DBA.SYS_ANN_AD_RULE join DB.DBA.SYS_ANN_AD_ACCOUNT on (AAR_AAA_ID = AAA_ID) where AAR_AL_ID = _id and ANN_AUTHENTICATE (AAA_ID, \'A\', \'R\', auth_uname, auth_pwd, auth_uid)));\n"
"if (use_sample_name is null)\n"
"signal (\'23000\', sprintf (\'Integrity violation: advertizing link %d is used by some advertizer\', _id));\n"
"else\n"
"signal (\'23000\', sprintf (\'Integrity violation: advertizing link %d is used by advertizer \'\'%s\'\'\', _id, use_sample_name));\n"
"}\n"
"delete from DB.DBA.SYS_ANN_LINK where AL_ID = _id;\n"
"return _id;\n"
"}\n"
"--src phrasematch.sql:451\n";

static const char *proc222 = 
" create function ANN_AD_RULE_ADD (in aaa_name varchar, in aps_name varchar, in _text varchar, in _al_id integer, in _app_env any, in _lang_name varchar, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare _aaa_id, _aps_id, _ap_chksum integer;\n"
"declare auth_uid integer;\n"
"declare _aps_lang_name varchar;\n"
"declare old_data, old_al any;\n"
"declare old_al_idx integer;\n"
"auth_uid := NULL;\n"
"_aaa_id := ANN_AUTHENTICATE (aaa_name, \'A\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_aaa_id < 0)\n"
"return _aaa_id;\n"
"_aps_id := ANN_AUTHENTICATE (aps_name, \'S\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_aps_id < 0)\n"
"return _aps_id;\n"
"if (not exists (select top 1 1 from DB.DBA.SYS_ANN_LINK where AL_ID = _al_id))\n"
"return -1;\n"
"_aps_lang_name := coalesce ((select APS_LANG_NAME from DB.DBA.SYS_ANN_PHRASE_SET where APS_ID = _aps_id));\n"
"if (_lang_name <> _aps_lang_name)\n"
"signal (\'23000\', sprintf (\'Integrity violation: language \'\'%s\'\' in advertizing rule conflicts with language \'\'%s\'\' of phrase set \'\'%s\'\'\', _lang_name, _aps_lang_name, aps_name));\n"
"_ap_chksum := ap_phrase_chksum (_text, _lang_name);\n"
"old_data := coalesce ((select AP_LINK_DATA from DB.DBA.SYS_ANN_PHRASE where AP_APS_ID = _aps_id and AP_CHKSUM=_ap_chksum and AP_TEXT = _text), vector ());\n"
"if (not isarray (old_data))\n"
"return -9;\n"
"if (mod (length (old_data), 2))\n"
"return -9;\n"
"old_al_idx := position (\'AL\', old_data, 1, 2);\n"
"if (0 = old_al_idx)\n"
"old_data := vector_concat (vector (\'AL\', vector (_al_id, _aaa_id, _app_env)), old_data);\n"
"else\n"
"{\n"
"old_al := aref_set_0 (old_data, old_al_idx);\n"
"if (mod (length (old_al), 3))\n"
"return -9;\n"
"if (0 <> position (_al_id, old_al, 1, 3))\n"
"{\n"
"old_data [old_al_idx] := old_al;\n"
"return -8;\n"
"}\n"
"old_data [old_al_idx] := vector_concat (old_al, vector (_al_id, _aaa_id, _app_env));\n"
"}\n"
"ap_add_phrases (_aps_id, vector (vector (_text, old_data)));\n"
"insert replacing DB.DBA.SYS_ANN_AD_RULE (AAR_AAA_ID, AAR_APS_ID, AAR_AP_CHKSUM, AAR_TEXT, AAR_AL_ID, AAR_APP_ENV)\n"
"values (_aaa_id, _aps_id, _ap_chksum, _text, _al_id, _app_env);\n"
"commit work;\n"
"return 0;\n"
"}\n"
"--src phrasematch.sql:474\n";

static const char *proc223 = 
" create function ANN_AD_RULE_DEL (in aaa_name varchar, in aps_name varchar, in _text varchar, in _al_id integer, in _lang_name varchar, in auth_uname varchar, in auth_pwd varchar) returns integer\n"
"{\n"
"declare _aaa_id, _aps_id, _ap_chksum integer;\n"
"declare auth_uid integer;\n"
"declare _aps_lang_name varchar;\n"
"declare old_data, old_al, pos_to_del any;\n"
"declare old_al_idx, res integer;\n"
"auth_uid := NULL;\n"
"_aaa_id := ANN_AUTHENTICATE (aaa_name, \'A\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_aaa_id < 0)\n"
"return _aaa_id;\n"
"_aps_id := ANN_AUTHENTICATE (aps_name, \'S\', \'W\', auth_uname, auth_pwd, auth_uid);\n"
"if (_aps_id < 0)\n"
"return _aps_id;\n"
"if (not exists (select top 1 1 from DB.DBA.SYS_ANN_LINK where AL_ID = _al_id))\n"
"return -1;\n"
"_aps_lang_name := coalesce ((select APS_LANG_NAME from DB.DBA.SYS_ANN_PHRASE_SET where APS_ID = _aps_id));\n"
"if (_lang_name <> _aps_lang_name)\n"
"signal (\'23000\', sprintf (\'Integrity violation: language \'\'%s\'\' in advertizing rule conflicts with language \'\'%s\'\' of phrase set \'\'%s\'\'\', _lang_name, _aps_lang_name, aps_name));\n"
"_ap_chksum := ap_phrase_chksum (_text, _lang_name);\n"
"whenever not found goto phrase_nf;\n"
"select AP_LINK_DATA into old_data from DB.DBA.SYS_ANN_PHRASE where AP_APS_ID = _aps_id and AP_CHKSUM=_ap_chksum and AP_TEXT = _text;\n"
"if (not isarray (old_data))\n"
"{\n"
"res := -9;\n"
"goto phrase_done;\n"
"}\n"
"if (mod (length (old_data), 2))\n"
"{\n"
"res := -9;\n"
"goto phrase_done;\n"
"}\n"
"old_al_idx := position (\'AL\', old_data, 1, 2);\n"
"if (0 = old_al_idx)\n"
"{\n"
"res := -1;\n"
"goto phrase_done;\n"
"}\n"
"old_al := aref_set_0 (old_data, old_al_idx);\n"
"if (mod (length (old_al), 3))\n"
"{\n"
"res := -1;\n"
"goto phrase_done;\n"
"}\n"
"pos_to_del := position (_al_id, old_al, 1, 3);\n"
"if (0 = pos_to_del)\n"
"{\n"
"old_data [old_al_idx] := old_al;\n"
"res := -1;\n"
"goto phrase_done;\n"
"}\n"
"if (length (old_al) > 3)\n"
"{\n"
"old_al := vector_concat (subseq (old_al, 0, pos_to_del - 1), subseq (old_al, pos_to_del + 2));\n"
"old_data [old_al_idx] := old_al;\n"
"}\n"
"else\n"
"{\n"
"if (length (old_data) > 2)\n"
"old_data := vector_concat (subseq (old_data, 0, old_al_idx - 1), subseq (old_data, old_al_idx + 1));\n"
"else\n"
"{\n"
"ap_add_phrases (_aps_id, vector (vector (_text)));\n"
"res := 0;\n"
"goto phrase_done;\n"
"}\n"
"}\n"
"ap_add_phrases (_aps_id, vector (vector (_text, old_data)));\n"
"res := 0;\n"
"goto phrase_done;\n"
"\n"
"phrase_nf:\n"
"res := -1;\n"
"\n"
"phrase_done:\n"
"delete from DB.DBA.SYS_ANN_AD_RULE where (AAR_AAA_ID = _aaa_id) and (AAR_APS_ID = _aps_id) and (AAR_AP_CHKSUM = _ap_chksum) and (AAR_TEXT = _text) and (AAR_AL_ID = _al_id);\n"
"commit work;\n"
"return res;\n"
"}\n"
"--src phrasematch.sql:523\n";

static const char *proc224 = 
"create procedure DB.DBA.ANN_ZAP ()\n"
"{\n"
"declare _aps_id, _prev_aps_id integer;\n"
"declare _text, _prev_text varchar;\n"
"whenever not found goto phrase_nf;\n"
"_prev_aps_id := -1;\n"
"_prev_text := \'\';\n"
"\n"
"next_phrase:\n"
"select AP_APS_ID, AP_TEXT into _aps_id, _text from DB.DBA.SYS_ANN_PHRASE;\n"
"if ((_aps_id = _prev_aps_id) and (_text = _prev_text))\n"
"signal (\'OBLOM\', sprintf (\'Unable to remove phrase \'\'%s\'\' of set %d\', _text, _aps_id));\n"
"ap_add_phrases (_aps_id, vector (vector (_text)));\n"
"_prev_aps_id := _aps_id;\n"
"_prev_text := _text;\n"
"goto next_phrase;\n"
"\n"
"phrase_nf:\n"
"delete from DB.DBA.SYS_ANN_AD_RULE;\n"
"delete from DB.DBA.SYS_ANN_LINK;\n"
"delete from DB.DBA.SYS_ANN_AD_ACCOUNT;\n"
"delete from DB.DBA.SYS_ANN_PHRASE_SET;\n"
"delete from DB.DBA.SYS_ANN_PHRASE_CLASS;\n"
"commit work;\n"
"}\n"
"--src phrasematch.sql:604\n";

static const char *other158 = 
"AP_EXEC_NO_ERROR (\'DB.DBA.ANN_BOOT()\')\n";
/* hosting.sql */

static const char *proc225 = 
"create procedure WS.WS.GET_CGI_VARS_VECTOR (inout lines any) returns ANY\n"
"{\n"
"declare options any;\n"
"declare sys_addr varchar;\n"
"declare server_addr varchar;\n"
"declare host varchar;\n"
"declare line varchar;\n"
"declare fld varchar;\n"
"declare server_name varchar;\n"
"declare first_colon integer;\n"
"\n"
"sys_addr := sys_connected_server_address ();\n"
"server_addr := split_and_decode (sys_addr, 0, \'\\0\\0:\');\n"
"server_name := server_addr[0];\n"
"host := http_request_header (lines, \'HOST\', null, null);\n"
"if (host is not null)\n"
"{\n"
"first_colon := strchr (host, \':\');\n"
"if (first_colon is null)\n"
"server_name := trim (host);\n"
"else\n"
"server_name := trim (subseq (host, 0, first_colon));\n"
"}\n"
"options := vector (\n"
"\'__VIRT_CGI\', 		\'1\'\n"
",\'__VIRT_APP_UID\', 		http_map_get (\'vsp_uid\')\n"
",\'__VIRT_APP_LPATH\', 	http_map_get (\'domain\')\n"
",\'__VIRT_APP_PPATH\', 	http_map_get (\'mounted\')\n"
",\'SERVER_SOFTWARE\', 		\'Virtuoso Universal Server/6.0\'\n"
",\'SERVER_SIGNATURE\',		\'Virtuoso Universal Server/6.0 on \' || sys_addr\n"
",\'SERVER_NAME\', 		server_name\n"
",\'SERVER_ADDR\', 		server_addr[0]\n"
",\'DOCUMENT_ROOT\', 		http_root()\n"
",\'GATEWAY_INTERFACE\',	\'CGI/1.1\'\n"
",\'SERVER_PROTOCOL\',		http_request_get (\'SERVER_PROTOCOL\')\n"
",\'SERVER_PORT\',		server_addr[1]\n"
",\'REQUEST_METHOD\',		http_request_get (\'REQUEST_METHOD\')\n"
",\'REQUEST_URI\',		http_request_get (\'REQUEST_URI\')\n"
"\n"
",\'PATH_TRANSLATED\',		http_root() || http_physical_path ()\n"
",\'SCRIPT_NAME\',		http_path ()\n"
",\'SCRIPT_FILENAME\',		http_root() || http_physical_path ()\n"
",\'QUERY_STRING\',		http_request_get (\'QUERY_STRING\')\n"
",\'REMOTE_ADDR\',		http_client_ip ()\n"
",\'AUTHORIZATION\',		http_auth ()\n"
",\'CONTENT_TYPE\',		http_request_header_full (lines, \'Content-Type\', \'\')\n"
",\'CONTENT_LENGTH\',		http_request_header_full (lines, \'Content-Length\', \'0\')\n"
");\n"
"if (is_https_ctx ())\n"
"options := vector_concat (options, vector (\'HTTPS\', \'on\'));\n"
"\n"
"declare inx integer;\n"
"inx := 1;\n"
"while (inx < length (lines))\n"
"{\n"
"line := lines[inx];\n"
"first_colon := strchr (line, \':\');\n"
"if (first_colon is not null)\n"
"{\n"
"fld := trim (subseq (line, 0, first_colon));\n"
"options := vector_concat (options, vector (\n"
"concat (\'HTTP_\', upper (replace (fld, \'-\', \'_\'))),\n"
"http_request_header_full (lines, fld)));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return options;\n"
"}\n"
"--src hosting.sql:22\n";

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


static int
sch_udt_def_exists (client_connection_t *cli, const char *udt_name)
{
  sql_class_t *udt = sch_name_to_type (isp_schema (NULL), udt_name);
  if (udt &&  UDT_IS_INSTANTIABLE(udt))
    {
      return 1;
    }
  return 0;
}

#define DEFINE_UDT(name, udt) \
   if (!sch_udt_def_exists (bootstrap_cli, (name))) \
     ddl_ensure_table ("do this always", udt);


void
sqls_define (void)
{
  /* system.sql */

  ddl_ensure_table ("DB.DBA.SYS_VT_INDEX", tbl0);
  ddl_ensure_table ("DB.DBA.SYS_CACHED_RESOURCES", tbl1);
  DEFINE_PROC ("DB.DBA.SYS_CACHED_RESOURCE_ADD", proc0); 
  DEFINE_PUBLIC_PROC ("WS.WS.PARSE_URI", proc1); 
  DEFINE_PUBLIC_PROC ("WS.WS.EXPAND_URL", proc2);
  DEFINE_PROC ("repl_undot_name", proc3);
  DEFINE_PROC ("REPL_FQNAME", proc4);
  DEFINE_PROC ("REPL_COLTYPE_PS", proc5);
  DEFINE_PROC ("REPL_COLTYPE", proc6);
  DEFINE_PROC ("WS.WS.HEX_DIGIT", proc7);
  DEFINE_PROC ("WS.WS.STR_SQL_APOS", proc8);
  DEFINE_PROC ("WS.WS.STR_FT_QUOT", proc9); 
  DEFINE_PUBLIC_PROC ("SQL_PROCEDURE_COLUMNS", proc10); 
  DEFINE_PUBLIC_PROC ("XML_URI_RESOLVE_LIKE_GET", proc11);
  DEFINE_PROC ("XML_URI_GET_AND_CACHE", proc12); 
  DEFINE_PUBLIC_PROC ("XML_URI_PARSE_VIRT", proc13);
  DEFINE_PROC ("XML_URI_GET", proc14);
  DEFINE_PROC ("XML_URI_GET_STRING", proc15);
  DEFINE_PROC ("XML_URI_GET_STRING_OR_ENT", proc16);
  DEFINE_PROC ("XML_COLLECTION_DIR_LIST_LOCAL", proc17);
  DEFINE_PROC ("XML_COLLECTION_DIR_LIST_TABLE", proc18);
  DEFINE_PROC ("HTTP_GET_AUTH_INFO", proc19);
  DEFINE_PROC ("XML_COLLECTION_DIR_LIST_REMOTE", proc20);
  DEFINE_PROC ("XML_COLLECTION_DIR_LIST", proc21);
  ddl_ensure_table ("do this always", other0);
  DEFINE_PROC ("SYS_ALFANUM_NAME", proc22); 
  DEFINE_PUBLIC_PROC ("SYS_COPY_TABLE", proc23); 
  DEFINE_PUBLIC_PROC ("ddl_pk_fill_pk_parts", proc24); 
  DEFINE_PUBLIC_PROC ("ddl_pk_copy_inx", proc25); 
  DEFINE_PUBLIC_PROC ("ddl_pk_change_1", proc26); 
  DEFINE_PUBLIC_PROC ("ddl_pk_change_final", proc27); 
  DEFINE_PUBLIC_PROC ("ddl_pk_modify_check", proc28); 
  DEFINE_PUBLIC_PROC ("ddl_pk_is_changed", proc29); 
  DEFINE_PUBLIC_PROC ("ddl_pk_modify", proc30);
  DEFINE_PROC ("DB.DBA.fk_check_input_values", proc31);
  ddl_ensure_table ("do this always", other1);
  DEFINE_PROC ("DB.DBA.ddl_check_constraint", proc32);
  DEFINE_PROC ("ddl_fk_modify", proc33); 
  DEFINE_PUBLIC_PROC ("ddl_alter_constr", proc34);
  DEFINE_PROC ("ddl_unq_modify", proc35);
  DEFINE_PROC ("ddl_check_modify", proc36);
  DEFINE_PROC ("__HTTP_XSLT", proc37);
  DEFINE_PROC ("DB.DBA.ddl_fk_rules", proc38);
  DEFINE_PROC ("DB.DBA.ddl_pk_check_input", proc39);
  DEFINE_PROC ("execstr1", proc40);
  DEFINE_PROC ("DB.DBA.ddl_fk_check_input", proc41);
  DEFINE_PROC ("DB.DBA.col_check", proc42);
  DEFINE_PROC ("DB.DBA.col_of_type", proc43);
  ddl_ensure_table ("do this always", other2);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
  ddl_ensure_table ("do this always", other5);
  ddl_ensure_table ("do this always", other6);
  ddl_ensure_table ("do this always", other7);
  ddl_ensure_table ("do this always", other8);
  ddl_ensure_table ("do this always", other9);
  ddl_ensure_table ("do this always", other10);
  ddl_ensure_table ("do this always", other11);
  ddl_ensure_table ("do this always", other12);
  ddl_ensure_table ("do this always", other13);
  ddl_ensure_table ("do this always", other14);
  ddl_ensure_table ("do this always", other15);
  ddl_ensure_table ("do this always", other16);
  ddl_ensure_table ("do this always", other17);
  ddl_ensure_table ("do this always", other18);
  ddl_ensure_table ("do this always", other19);
  ddl_ensure_table ("do this always", other20);
  ddl_ensure_table ("do this always", other21);
  ddl_ensure_table ("do this always", other22);
  ddl_ensure_table ("do this always", other23);
  ddl_ensure_table ("do this always", other24);
  ddl_ensure_table ("do this always", other25);
  ddl_ensure_table ("do this always", other26);
  ddl_ensure_table ("do this always", other27);
  ddl_ensure_table ("do this always", other28);
  ddl_ensure_table ("do this always", other29);
  ddl_ensure_table ("do this always", other30);
  ddl_ensure_table ("do this always", other31);
  ddl_ensure_table ("do this always", other32);
  ddl_ensure_table ("do this always", other33);
  ddl_ensure_table ("do this always", other34);
  ddl_ensure_table ("do this always", other35);
  ddl_ensure_table ("do this always", other36);
  DEFINE_PROC ("scheduler_init", proc44);
  ddl_ensure_table ("do this always", other37); 
  DEFINE_PUBLIC_PROC ("SYS_GENERATE_ALL_OPS", proc45); 
  DEFINE_PUBLIC_PROC ("SYS_GENERATE_ALL_VARS", proc46);
  ddl_ensure_table ("DB.DBA.SYS_STAT_VDB_MAPPERS", tbl2);/* AWK macro AWK AFTER*/
  ddl_ensure_table ("do this always", other38);/* AWK macro AWK AFTER*/
  ddl_ensure_table ("do this always", other39);
  DEFINE_PROC ("DB.DBA.__ORACLE_SYS_COL_STAT", proc47);
  DEFINE_PROC ("DB.DBA.__VIRTUOSO_SYS_COL_STAT", proc48);/* AWK macro AWK AFTER*/
  ddl_ensure_table ("do this always", other40);
  DEFINE_PROC ("DB.DBA.__INFORMIX_SYS_COL_STAT", proc49);
  DEFINE_PROC ("DB.DBA.__DB2_SYS_COL_STAT", proc50);/* AWK macro AWK AFTER*/
  ddl_ensure_table ("do this always", other41);
  DEFINE_PROC ("SYS_STAT_VDB_SYNC", proc51); 
  DEFINE_PUBLIC_PROC ("SYS_STAT_ANALYZE_VDB", proc52); 
  DEFINE_PUBLIC_PROC ("SYS_STAT_ANALYZE", proc53); 
  DEFINE_PUBLIC_PROC ("SYS_DB_STAT", proc54); 
  DEFINE_PUBLIC_PROC ("SYS_STAT_HISTOGRAM", proc55);
  ddl_ensure_table ("DB.DBA.SYS_SOAP_DATATYPES", tbl3);
  DEFINE_PROC ("soap_dt_define", proc56); 
  DEFINE_PUBLIC_PROC ("SET_IDENTITY_COLUMN", proc57); 
  DEFINE_PUBLIC_PROC ("GET_IDENTITY_COLUMN", proc58);
  ddl_ensure_table ("do this always", other42);
  DEFINE_PROC ("DAV_USER_SET_PASSWORD", proc59);/* AWK macro AWK PLBIF http_client*/
  DEFINE_PUBLIC_PROC ("DB.DBA.HTTP_CLIENT", proc60);/* AWK macro AWK PLBIF http_client_ext*/
  DEFINE_PUBLIC_PROC ("DB.DBA.HTTP_CLIENT_EXT", proc61); 
  DEFINE_PUBLIC_PROC ("SQL_PROCEDURE_COLUMNSW", proc62);
  DEFINE_PROC ("DB.DBA.__XML_TEMPLATE", proc63); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XQ_TEMPLATE", proc64); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SQLX_OR_SPARQL_TEMPLATE", proc65);
  ddl_ensure_table ("do this always", other43);
  DEFINE_PROC ("cov_store", proc66);
  DEFINE_PROC ("cov_load", proc67);
  DEFINE_PROC ("cov_report", proc68);
  DEFINE_PROC ("vd_remote_proc_wrapper", proc69);
  ddl_ensure_table ("do this always", other44);
  DEFINE_PROC ("EXEC_STMT", proc70);
  DEFINE_PROC ("EXEC_AS", proc71); 
  DEFINE_PUBLIC_PROC ("RSTMTEXEC", proc72);
  DEFINE_PROC ("FTI_MAKE_SEARCH_STRING_INNER", proc73);
  DEFINE_PROC ("FTI_MAKE_SEARCH_STRING", proc74);
  ddl_ensure_table ("DB.DBA.CLR_VAC", tbl4);
  DEFINE_PROC ("exec_quiet", proc75);
  ddl_ensure_table ("do this always", other46); 
  DEFINE_UDT (case_mode == CM_UPPER ? "XMLTYPE" : "XMLType", udt0);
  ddl_ensure_table ("do this always", other47);
  ddl_ensure_table ("do this always", other48);
  ddl_ensure_table ("do this always", other49);
  ddl_ensure_table ("do this always", other50);
  ddl_ensure_table ("do this always", other51);
  ddl_ensure_table ("do this always", other52);
  ddl_ensure_table ("do this always", other53);
  ddl_ensure_table ("do this always", other54);
  ddl_ensure_table ("do this always", other55);
  ddl_ensure_table ("do this always", other56);
  ddl_ensure_table ("do this always", other57);
  ddl_ensure_table ("do this always", other58);
  ddl_ensure_table ("do this always", other59);
  ddl_ensure_table ("do this always", other60);
  ddl_ensure_table ("do this always", other61);
  ddl_ensure_table ("do this always", other62);
  ddl_ensure_table ("do this always", other63);
  ddl_ensure_table ("do this always", other64);
  ddl_ensure_table ("do this always", other65);
  ddl_ensure_table ("do this always", other66);
  ddl_ensure_table ("do this always", other67);
  ddl_ensure_table ("do this always", other68);
  ddl_ensure_table ("do this always", other69);
  ddl_ensure_table ("do this always", other70);
  ddl_ensure_table ("do this always", other71);
  ddl_ensure_table ("do this always", other72);
  ddl_ensure_table ("do this always", other73);
  ddl_ensure_table ("do this always", other74);
  ddl_ensure_table ("do this always", other75);
  ddl_ensure_table ("do this always", other76); 
  DEFINE_PUBLIC_PROC ("createXML", proc76);
  ddl_ensure_table ("do this always", other77); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SYS_CREATE_XML_SCHEMA", proc77); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_COLUMN_SCHEMA_VALIDATE", proc78); 
  DEFINE_PUBLIC_PROC ("SYS_TREE_OF_ARRAYS_CONTAINS", proc79); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SYS_DROP_XML_SCHEMA", proc80);/* AWK macro AWK PLBIF regexp_like*/
  DEFINE_PUBLIC_PROC ("REGEXP_LIKE", proc81);/* AWK macro AWK PLBIF regexp_replace*/
  DEFINE_PUBLIC_PROC ("REGEXP_REPLACE", proc82);/* AWK macro AWK PLBIF regexp_instr*/
  DEFINE_PUBLIC_PROC ("REGEXP_INSTR", proc83);/* AWK macro AWK PLBIF http_requested_url*/
  DEFINE_PUBLIC_PROC ("HTTP_REQUESTED_URL", proc84);/* AWK macro AWK PLBIF http_url_handler*/
  DEFINE_PUBLIC_PROC ("HTTP_URL_HANDLER", proc85);
  DEFINE_PROC ("DB.DBA.SCHEDULER_NOTIFY", proc86);
  DEFINE_PROC ("SYS_CHECK_OLD_BLOG", proc87);
  ddl_ensure_table ("do this always", other78); 
  DEFINE_PUBLIC_PROC ("HTTP_GET_HOST", proc88); 
  DEFINE_PUBLIC_PROC ("date_rfc1123", proc89); 
  DEFINE_PUBLIC_PROC ("date_iso8601", proc90);
  DEFINE_PROC ("DB.DBA.INSTALLER_VAD", proc91);
  DEFINE_PROC ("DB.DBA.VACUUM", proc92);
  DEFINE_PROC ("tc_result", proc93);
  DEFINE_PROC ("tc_stat", proc94);
  DEFINE_PROC ("cl_exec_srv", proc95);
  DEFINE_PROC ("daq_results", proc96);
  DEFINE_PROC ("cl_all_hosts", proc97);
  DEFINE_PROC ("cl_exec", proc98);
  DEFINE_PROC ("CL_STAT_SRV", proc99);
  DEFINE_PROC ("daq_next_or_error", proc100);
  DEFINE_PROC ("cl_sys_stat", proc101);
  DEFINE_PROC ("IF_CLUSTER", proc102);
  DEFINE_PROC ("IF_NO_CLUSTER", proc103);
  DEFINE_PROC ("CL_START_SRV", proc104);
  DEFINE_PROC ("cl_init_seqs", proc105);
  DEFINE_PROC ("cl_reset_seqs", proc106);
  DEFINE_PROC ("cl_new_db", proc107);
  DEFINE_PROC ("cl_node_started", proc108);
  DEFINE_PROC ("ddl_ren_k_new_name", proc109);
  DEFINE_PROC ("DB.DBA.DDL_TABLE_RENAMED", proc110);
  DEFINE_PROC ("rename_table", proc111);
  DEFINE_PROC ("VT_GET_CLUSTER", proc112);
  DEFINE_PROC ("VT_GET_CLUSTER_COL_OPTS", proc113);
  DEFINE_PROC ("DB.DBA.SYS_SQL_VECTOR_PRINT", proc114);
  DEFINE_PROC ("DB.DBA.SYS_SQL_VAL_PRINT", proc115);
  DEFINE_PROC ("view_from_tbl", proc116);
  DEFINE_PROC ("view_create_view", proc117);
  DEFINE_PROC ("view_dv_to_printf_str_type", proc118);
  DEFINE_PROC ("view_dv_to_sql_str_type", proc119);
  DEFINE_PROC ("view_create_class", proc120);
  DEFINE_PROC ("view_get_primary_key", proc121);
  DEFINE_PROC ("view_get_pk", proc122);
  DEFINE_PROC ("view_get_where_from_foreign_key", proc123);
  DEFINE_PROC ("text_est_text", proc124);
  DEFINE_PROC ("CL_RANGE_WORDS_SRV", proc125);
  DEFINE_PROC ("cl_range_words", proc126);
  ddl_ensure_table ("DB.DBA.SYS_HTTP_CLIENT_CACHE", tbl5);
  ddl_ensure_table ("DB.DBA.TABLE_COLS", view0);
  ddl_ensure_table ("do this always", other79);
  DEFINE_PROC ("csv_load_file", proc127);
  DEFINE_PROC ("csv_load", proc128);
  DEFINE_PROC ("csv_parse", proc129);
  DEFINE_PROC ("csv_ins_stmt", proc130);
  DEFINE_PROC ("csv_file_header_check", proc131);
  DEFINE_PROC ("csv_table_def", proc132);
  DEFINE_PROC ("csv_cols_def", proc133);

  /* system2.sql */

  DEFINE_PROC ("DB.DBA.SYS_INDEX_SPACE_STATS_PROC", proc134);
  ddl_ensure_table ("DB.DBA.SYS_INDEX_SPACE_STATS", view1); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__VD_GET_SQLSTATS_COUNT", proc135); 
  DEFINE_PUBLIC_PROC ("DB.DBA.VD_STATISTICS", proc136); 
  DEFINE_PUBLIC_PROC ("DB.DBA.TABLE_SET_POLICY", proc137); 
  DEFINE_PUBLIC_PROC ("DB.DBA.TABLE_DROP_POLICY", proc138);
  ddl_ensure_table ("DB.DBA.ALL_COL_STAT", view2);
  ddl_ensure_table ("do this always", other80);
  ddl_ensure_table ("DB.DBA.USER_COL_STAT", view3);
  ddl_ensure_table ("do this always", other81);
  ddl_ensure_table ("DB.DBA.ALL_COL_HIST", view4);
  ddl_ensure_table ("do this always", other82);
  ddl_ensure_table ("DB.DBA.USER_COL_HIST", view5);
  ddl_ensure_table ("do this always", other83);
  DEFINE_PROC ("SINV_CREATE_INVERSE", proc139);
  DEFINE_PROC ("SINV_DROP_INVERSE", proc140);
  DEFINE_PROC ("SINV_CREATE_KEY_MAPPING", proc141);
  DEFINE_PROC ("SYS_CREATE_TABLE_AS", proc142); 
  DEFINE_PUBLIC_PROC ("encode_b32_num", proc143); 
  DEFINE_PUBLIC_PROC ("decode_b32_num", proc144);
  ddl_ensure_table ("do this always", other84);
  ddl_ensure_table ("do this always", other85);
  ddl_ensure_table ("do this always", other86);
  ddl_ensure_table ("do this always", other87);
  ddl_ensure_table ("do this always", other88);
  ddl_ensure_table ("do this always", other89);
  ddl_ensure_table ("do this always", other90);
  ddl_ensure_table ("do this always", other91);
  ddl_ensure_table ("do this always", other92);
  ddl_ensure_table ("do this always", other93);
  ddl_ensure_table ("do this always", other94);
  ddl_ensure_table ("do this always", other95);
  ddl_ensure_table ("do this always", other96);
  ddl_ensure_table ("do this always", other97);
  ddl_ensure_table ("do this always", other98);
  ddl_ensure_table ("do this always", other99);
  ddl_ensure_table ("do this always", other100);
  ddl_ensure_table ("do this always", other101);
  ddl_ensure_table ("do this always", other102);
  ddl_ensure_table ("do this always", other103);
  ddl_ensure_table ("do this always", other104);
  ddl_ensure_table ("do this always", other105);
  ddl_ensure_table ("do this always", other106);
  ddl_ensure_table ("do this always", other107);
  ddl_ensure_table ("do this always", other108);
  ddl_ensure_table ("do this always", other109);
  ddl_ensure_table ("do this always", other110);
  ddl_ensure_table ("do this always", other111);
  ddl_ensure_table ("do this always", other112);
  ddl_ensure_table ("do this always", other113);
  ddl_ensure_table ("do this always", other114);
  ddl_ensure_table ("do this always", other115);
  ddl_ensure_table ("do this always", other116);
  ddl_ensure_table ("do this always", other117);
  ddl_ensure_table ("do this always", other118);
  ddl_ensure_table ("do this always", other119);
  ddl_ensure_table ("do this always", other120);
  ddl_ensure_table ("do this always", other121);
  ddl_ensure_table ("do this always", other122);
  ddl_ensure_table ("do this always", other123);
  ddl_ensure_table ("do this always", other124);
  ddl_ensure_table ("do this always", other125);
  ddl_ensure_table ("do this always", other126);
  ddl_ensure_table ("do this always", other127);
  ddl_ensure_table ("do this always", other128);
  ddl_ensure_table ("do this always", other129);
  ddl_ensure_table ("do this always", other130);
  ddl_ensure_table ("do this always", other131);
  ddl_ensure_table ("do this always", other132);

  /* odbccat.sql */

  DEFINE_PROC ("sql_normalize_qon", proc145);
  DEFINE_PROC ("sql_filter_qon", proc146);
  DEFINE_PROC ("sql_columns", proc147);
  DEFINE_PROC ("sql_tables", proc148);
  DEFINE_PROC ("sql_primary_keys", proc149);
  DEFINE_PROC ("sql_statistics", proc150);
  DEFINE_PROC ("sql_procedures", proc151);
  DEFINE_PROC ("sql_procedure_cols", proc152);/* AWK macro AWK PLBIF sql_foreign_keys*/
  DEFINE_PUBLIC_PROC ("sql_foreign_keys", proc153);
  DEFINE_PROC ("__virt_sql_qon_is_oracle_oracle", proc154);
  DEFINE_PROC ("sql_normalize_qon_oracle_oracle", proc155);
  DEFINE_PROC ("sql_filter_qon_oracle_oracle", proc156);
  DEFINE_PROC ("sql_normalize_qon_oracle_msora", proc157);
  DEFINE_PROC ("sql_normalize_qon_infohub_dcsyb30", proc158);
  DEFINE_PROC ("sql_tables_pre_infohub_dcsyb30", proc159);
  DEFINE_PROC ("sql_tables_post_infohub_dcsyb30", proc160);
  DEFINE_PROC ("sql_columns_post_oracle_openlink", proc161);
  DEFINE_PROC ("sql_tables_post_progress_win_openlink", proc162);
  DEFINE_PROC ("sql_tables_post_excel_drv", proc163);
  DEFINE_PROC ("sql_tables_pre_excel_drv", proc164);
  DEFINE_PROC ("sql_normalize_qon_viaserv_opl", proc165);

  /* useraggr.sql */
 
  DEFINE_PUBLIC_PROC ("STD_COUNT", proc166); 
  DEFINE_PUBLIC_PROC ("STD11_INIT", proc167); 
  DEFINE_PUBLIC_PROC ("STD12_INIT", proc168); 
  DEFINE_PUBLIC_PROC ("STD13_INIT", proc169); 
  DEFINE_PUBLIC_PROC ("VAR_ACC", proc170); 
  DEFINE_PUBLIC_PROC ("VAR_POP_FIN", proc171); 
  DEFINE_PUBLIC_PROC ("VAR_SAMP_FIN", proc172); 
  DEFINE_PUBLIC_PROC ("VAR_FIN", proc173); 
  DEFINE_PUBLIC_PROC ("STDDEV_POP_FIN", proc174); 
  DEFINE_PUBLIC_PROC ("STDDEV_SAMP_FIN", proc175); 
  DEFINE_PUBLIC_PROC ("STDDEV_FIN", proc176); 
  DEFINE_PUBLIC_PROC ("COVAR_ACC", proc177); 
  DEFINE_PUBLIC_PROC ("COVAR_SAMP_FIN", proc178); 
  DEFINE_PUBLIC_PROC ("COVAR_POP_FIN", proc179); 
  DEFINE_PUBLIC_PROC ("COVAR_FIN", proc180);
  ddl_ensure_table ("do this always", other133);
  ddl_ensure_table ("do this always", other134);
  ddl_ensure_table ("do this always", other135);
  ddl_ensure_table ("do this always", other136);
  ddl_ensure_table ("do this always", other137);
  ddl_ensure_table ("do this always", other138);
  ddl_ensure_table ("do this always", other139);
  ddl_ensure_table ("do this always", other140);
  ddl_ensure_table ("do this always", other141); 
  DEFINE_PUBLIC_PROC ("REGR_SLOPE_INIT", proc181); 
  DEFINE_PUBLIC_PROC ("REGR_SLOPE_ACC", proc182); 
  DEFINE_PUBLIC_PROC ("REGR_SLOPE_FIN", proc183);
  ddl_ensure_table ("do this always", other142); 
  DEFINE_PUBLIC_PROC ("REGR_INTERCEPT_INIT", proc184); 
  DEFINE_PUBLIC_PROC ("REGR_INTERCEPT_ACC", proc185); 
  DEFINE_PUBLIC_PROC ("REGR_INTERCEPT_FIN", proc186);
  ddl_ensure_table ("do this always", other143); 
  DEFINE_PUBLIC_PROC ("REGR_COUNT_INIT", proc187); 
  DEFINE_PUBLIC_PROC ("REGR_COUNT_ACC", proc188); 
  DEFINE_PUBLIC_PROC ("REGR_COUNT_FIN", proc189); 
  DEFINE_PUBLIC_PROC ("REGR_COUNT_MERGE", proc190);
  ddl_ensure_table ("do this always", other144); 
  DEFINE_PUBLIC_PROC ("REGR_AVG_ACC", proc191); 
  DEFINE_PUBLIC_PROC ("REGR_AVGX_FIN", proc192); 
  DEFINE_PUBLIC_PROC ("REGR_AVGY_FIN", proc193);
  ddl_ensure_table ("do this always", other145);
  ddl_ensure_table ("do this always", other146); 
  DEFINE_PUBLIC_PROC ("CORR_INIT", proc194); 
  DEFINE_PUBLIC_PROC ("CORR_ACC", proc195); 
  DEFINE_PUBLIC_PROC ("CORR_FIN", proc196);
  ddl_ensure_table ("do this always", other147); 
  DEFINE_PUBLIC_PROC ("REGR_R2_INIT", proc197); 
  DEFINE_PUBLIC_PROC ("REGR_R2_ACC", proc198); 
  DEFINE_PUBLIC_PROC ("REGR_R2_FIN", proc199);
  ddl_ensure_table ("do this always", other148); 
  DEFINE_PUBLIC_PROC ("REGR_SXX_ACC", proc200); 
  DEFINE_PUBLIC_PROC ("REGR_SYY_ACC", proc201); 
  DEFINE_PUBLIC_PROC ("REGR_SXY_ACC", proc202); 
  DEFINE_PUBLIC_PROC ("REGR_S___FIN", proc203); 
  DEFINE_PUBLIC_PROC ("REGR_SXY_FIN", proc204);
  ddl_ensure_table ("do this always", other149);
  ddl_ensure_table ("do this always", other150);
  ddl_ensure_table ("do this always", other151); 
  DEFINE_PUBLIC_PROC ("xte_nodebld_final_root", proc205);
  ddl_ensure_table ("do this always", other152);
  ddl_ensure_table ("do this always", other153);
  ddl_ensure_table ("do this always", other154);
  ddl_ensure_table ("do this always", other155);
  ddl_ensure_table ("do this always", other156);

  /* vt_text.sql */

  DEFINE_PROC ("DB.DBA.execstmt", proc206);
  DEFINE_PROC ("DB.DBA.vt_create_ftt", proc207);
  DEFINE_PROC ("DB.DBA.vt_drop_ftt", proc208);
  ddl_ensure_table ("do this always", other157);

  /* phrasematch.sql */

  DEFINE_PROC ("AP_EXEC_NO_ERROR", proc209);
  ddl_ensure_table ("DB.DBA.SYS_ANN_PHRASE_CLASS", tbl6);
  ddl_ensure_table ("DB.DBA.SYS_ANN_PHRASE_SET", tbl7);
  ddl_ensure_table ("DB.DBA.SYS_ANN_PHRASE", tbl8);
  ddl_ensure_table ("DB.DBA.SYS_ANN_AD_ACCOUNT", tbl9);
  ddl_ensure_table ("DB.DBA.SYS_ANN_LINK", tbl10);
  ddl_ensure_table ("DB.DBA.SYS_ANN_AD_RULE", tbl11);
  ddl_std_proc (trig0, 0x0);
  ddl_std_proc (trig1, 0x0);
  ddl_std_proc (trig2, 0x0);
  ddl_std_proc (trig3, 0x0);
  ddl_std_proc (trig4, 0x0);
  ddl_std_proc (trig5, 0x0);
  DEFINE_PROC ("DB.DBA.ANN_BOOT", proc210);
  DEFINE_PROC ("ANN_AUTHENTICATE", proc211);
  DEFINE_PROC ("ANN_GETID", proc212); 
  DEFINE_PUBLIC_PROC ("ANN_PHRASE_CLASS_ADD", proc213);
  DEFINE_PROC ("ANN_PHRASE_CLASS_ADD_INT", proc214); 
  DEFINE_PUBLIC_PROC ("ANN_PHRASE_CLASS_DEL", proc215); 
  DEFINE_PUBLIC_PROC ("ANN_PHRASE_SET_ADD", proc216);
  DEFINE_PROC ("ANN_PHRASE_SET_ADD_INT", proc217); 
  DEFINE_PUBLIC_PROC ("ANN_PHRASE_SET_DEL", proc218); 
  DEFINE_PUBLIC_PROC ("ANN_LINK_ADD", proc219); 
  DEFINE_PUBLIC_PROC ("ANN_LINK_MODIFY", proc220); 
  DEFINE_PUBLIC_PROC ("ANN_LINK_DEL", proc221); 
  DEFINE_PUBLIC_PROC ("ANN_AD_RULE_ADD", proc222); 
  DEFINE_PUBLIC_PROC ("ANN_AD_RULE_DEL", proc223);
  DEFINE_PROC ("DB.DBA.ANN_ZAP", proc224);
  ddl_ensure_table ("do this always", other158);

  /* hosting.sql */

  DEFINE_PROC ("WS.WS.GET_CGI_VARS_VECTOR", proc225);
}


void
sqls_arfw_define (void)
{
  /* system.sql */

  ddl_ensure_table ("do this always", other45);

}


void
sqls_bif_init (void)
{

  pl_bif_name_define ("http_client");
  pl_bif_name_define ("http_client_ext");
  pl_bif_name_define ("regexp_like");
  pl_bif_name_define ("regexp_replace");
  pl_bif_name_define ("regexp_instr");
  pl_bif_name_define ("http_requested_url");
  pl_bif_name_define ("http_url_handler");
  pl_bif_name_define ("sql_foreign_keys");
}
