###################################################
# client calls generator
# Copyright tridge@samba.org 2003
# Copyright jelmer@samba.org 2005-2006
# released under the GNU GPL

package Parse::Pidl::Samba4::NDR::Client;

use Parse::Pidl::Samba4 qw(choose_header is_intree);
use Parse::Pidl::Util qw(has_property);

use vars qw($VERSION);
$VERSION = '0.01';

use strict;

my($res,$res_hdr);

sub ParseFunctionSend($$$)
{
	my ($interface, $fn, $name) = @_;
	my $uname = uc $name;

	my $proto = "struct rpc_request *dcerpc_$name\_send(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx, struct $name *r)";

	$res_hdr .= "\n$proto;\n";

	$res .= "$proto\n{\n";

	if (has_property($fn, "todo")) {
		$res .= "\treturn NULL;\n";
	} else {
		$res .= "
	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG($name, r);
	}

	return dcerpc_ndr_request_send(p, NULL, &ndr_table_$interface->{NAME},
				       NDR_$uname, true, mem_ctx, r);
";
	}

	$res .= "}\n\n";
}

sub ParseFunctionSync($$$)
{
	my ($interface, $fn, $name) = @_;
	my $uname = uc $name;

	my $proto = "NTSTATUS dcerpc_$name(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx, struct $name *r)";

	$res_hdr .= "\n$proto;\n";
	$res .= "$proto\n{\n";

	if (has_property($fn, "todo")) {
		$res .= "\treturn NT_STATUS_NOT_IMPLEMENTED;\n";
	} else {
		$res .= "
	NTSTATUS status;

	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG($name, r);
	}

	status = dcerpc_ndr_request(p, NULL, &ndr_table_$interface->{NAME},
				    NDR_$uname, mem_ctx, r);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG($name, r);		
	}
";
    
        if (defined($fn->{RETURN_TYPE}) and $fn->{RETURN_TYPE} eq "NTSTATUS") {
             $res .= "\tif (NT_STATUS_IS_OK(status)) status = r->out.result;\n";
        }
	$res .= 
"
	return status;
";
	}

	$res .= "}\n\n";
}

#####################################################################
# parse a function
sub ParseFunction($$)
{
	my ($interface, $fn) = @_;

	ParseFunctionSend($interface, $fn, $fn->{NAME});
	ParseFunctionSync($interface, $fn, $fn->{NAME});
}

my %done;

#####################################################################
# parse the interface definitions
sub ParseInterface($)
{
	my($interface) = shift;

	$res_hdr .= "#ifndef _HEADER_RPC_$interface->{NAME}\n";
	$res_hdr .= "#define _HEADER_RPC_$interface->{NAME}\n\n";

	if (defined $interface->{PROPERTIES}->{uuid}) {
		$res_hdr .= "extern const struct ndr_interface_table ndr_table_$interface->{NAME};\n";
	}

	$res .= "/* $interface->{NAME} - client functions generated by pidl */\n\n";

	foreach my $fn (@{$interface->{FUNCTIONS}}) {
		next if not defined($fn->{OPNUM});
		next if defined($done{$fn->{NAME}});
		ParseFunction($interface, $fn);
		$done{$fn->{NAME}} = 1;
	}

	$res_hdr .= "#endif /* _HEADER_RPC_$interface->{NAME} */\n";

	return $res;
}

sub Parse($$$$)
{
	my($ndr,$header,$ndr_header,$client_header) = @_;

	$res = "";
	$res_hdr = "";

	$res .= "/* client functions auto-generated by pidl */\n";
	$res .= "\n";
	if (is_intree()) {
		$res .= "#include \"includes.h\"\n";
	} else {
		$res .= "#ifndef _GNU_SOURCE\n";
		$res .= "#define _GNU_SOURCE\n";
		$res .= "#endif\n";
		$res .= "#include <stdio.h>\n";
		$res .= "#include <stdbool.h>\n";
		$res .= "#include <stdlib.h>\n";
		$res .= "#include <stdint.h>\n";
		$res .= "#include <stdarg.h>\n";
		$res .= "#include <core/ntstatus.h>\n";
	}
	$res .= "#include \"$ndr_header\"\n";
	$res .= "#include \"$client_header\"\n";
	$res .= "\n";

	$res_hdr .= choose_header("librpc/rpc/dcerpc.h", "dcerpc.h")."\n";
	$res_hdr .= "#include \"$header\"\n";

	foreach my $x (@{$ndr}) {
		($x->{TYPE} eq "INTERFACE") && ParseInterface($x);
	}

	return ($res,$res_hdr);
}

1;
