/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* users.sql */

static const char *view0 = 
"create view SYS_USER_GROUP (UG_UID, UG_GID) as select GI_SUPER, GI_SUB\n"
"from SYS_ROLE_GRANTS where GI_DIRECT = 1\n";

static const char *trig0 = 
"create trigger SYS_ROLE_GRANTS_REVOKE after delete on SYS_ROLE_GRANTS referencing old as O\n"
"{\n"
"declare super, sub, grantor integer;\n"
"\n"
"super := O.GI_SUPER;\n"
"sub := O.GI_SUB;\n"
"grantor := O.GI_GRANT;\n"
"if (not exists (select 1 from SYS_ROLE_GRANTS\n"
"where GI_SUPER = super and GI_GRANT <> grantor and GI_SUB = sub))\n"
"{\n"
"if (exists (select 1 from SYS_USERS where U_ID = super and U_SQL_ENABLE)\n"
"and\n"
"exists (select 1 from SYS_USERS where U_ID = sub and U_SQL_ENABLE))\n"
"sec_revoke_user_role (super, sub);\n"
"}\n"
"delete from SYS_ROLE_GRANTS where GI_GRANT = super and GI_SUB = sub;\n"
"\n"
"}\n"
"--src users.sql:41\n";

static const char *trig1 = 
"create trigger SYS_ROLE_GRANTS_GRANT after insert on SYS_ROLE_GRANTS referencing new as N\n"
"{\n"
"\n"
"\n"
"for select GI_SUPER, GI_SUB, GI_GRANT, GI_DIRECT, GI_ADMIN from SYS_ROLE_GRANTS\n"
"where GI_SUB = N.GI_SUPER do\n"
"{\n"
"insert into SYS_ROLE_GRANTS (GI_SUPER, GI_SUB, GI_GRANT, GI_DIRECT, GI_ADMIN)\n"
"values (GI_SUPER, N.GI_SUB, GI_GRANT, 0, GI_ADMIN);\n"
"if (exists (select 1 from SYS_USERS where U_ID = N.GI_SUB and U_SQL_ENABLE)\n"
"and\n"
"exists (select 1 from SYS_USERS where U_ID = GI_SUPER and U_SQL_ENABLE))\n"
"sec_grant_user_role (GI_SUPER, N.GI_SUB);\n"
"}\n"
"}\n"
"--src users.sql:61\n";

static const char *trig2 = 
"create trigger SYS_PRIMARY_GROUP_NULLIFY after delete on SYS_USERS referencing old as O\n"
"{\n"
"declare gid integer;\n"
"declare opts, keys any;\n"
"declare i, l int;\n"
"\n"
"gid := O.U_ID;\n"
"update SYS_USERS set U_GROUP = U_ID where U_GROUP = gid;\n"
"delete from SYS_ROLE_GRANTS where GI_SUPER = gid or GI_SUB = gid or GI_GRANT = gid;\n"
"\n"
"\n"
"opts := O.U_OPTS;\n"
"opts := deserialize (opts);\n"
"if (not isarray (opts))\n"
"return;\n"
"\n"
"keys := get_keyword_ucase (\'KEYS\', opts, NULL);\n"
"if (keys is null)\n"
"return;\n"
"\n"
"i := 0; l := length (keys);\n"
"while (i < l)\n"
"{\n"
"if (keys[i] is not null and xenc_key_exists (keys[i]))\n"
"xenc_key_remove (keys[i], 0);\n"
"i := i + 2;\n"
"}\n"
"}\n"
"--src users.sql:79\n";

static const char *proc0 = 
"create procedure\n"
"GET_SEC_OBJECT_ID (in _name varchar, out id integer, out is_sql integer, out opts any)\n"
"{\n"
"if (0 = casemode_strcmp (_name, \'PUBLIC\'))\n"
"{\n"
"id := 1;\n"
"is_sql := 1;\n"
"opts := vector ();\n"
"return;\n"
"}\n"
"\n"
"declare _u_full_name, _u_e_mail, _u_home, _u_perms, _pwd_mode, _pwd_mode_data,\n"
"_login_qual, _sql_enable, _dav_enable, _get_pwd, _u_group, _is_role, _disabled any;\n"
"declare inl_opts any;\n"
"whenever not found goto nf;\n"
"select U_ID, U_SQL_ENABLE, deserialize(blob_to_string (U_OPTS)), U_DAV_ENABLE, U_FULL_NAME, U_E_MAIL,\n"
"U_GROUP, U_DEF_PERMS, U_PASSWORD_HOOK,\n"
"U_PASSWORD_HOOK_DATA, U_GET_PASSWORD, U_DEF_QUAL, U_HOME, U_IS_ROLE, U_ACCOUNT_DISABLED\n"
"into id, is_sql, opts, _dav_enable, _u_full_name, _u_e_mail,\n"
"_u_group, _u_perms, _pwd_mode,\n"
"_pwd_mode_data, _get_pwd, _login_qual, _u_home, _is_role, _disabled\n"
"from SYS_USERS where U_NAME = _name;\n"
"\n"
"if (not isarray(opts))\n"
"opts := vector ();\n"
"\n"
"inl_opts := vector (\n"
"\'PASSWORD_MODE\', _pwd_mode,\n"
"\'PASSWORD_MODE_DATA\', _pwd_mode_data,\n"
"\'GET_PASSWORD\', _get_pwd,\n"
"\'SQL_ENABLE\', is_sql,\n"
"\'DAV_ENABLE\', _dav_enable,\n"
"\'LOGIN_QUALIFIER\', _login_qual,\n"
"\'PRIMARY_GROUP\', _u_group,\n"
"\'E-MAIL\', _u_e_mail,\n"
"\'FULL_NAME\', _u_full_name,\n"
"\'HOME\', _u_home,\n"
"\'PERMISSIONS\', _u_perms,\n"
"\'DISABLED\', _disabled);\n"
"\n"
"opts := vector_concat (opts, inl_opts);\n"
"\n"
"return;\n"
"nf:\n"
"signal (\'42000\', sprintf (\'The object \"%s\" does not exist.\', _name), \'U0002\');\n"
"}\n"
"--src users.sql:142\n";

static const char *proc1 = 
"create procedure DB.DBA.SECURITY_CL_EXEC_AND_LOG (in txt varchar, in args any)\n"
"{\n"
"cl_exec (txt, args);\n"
"cl_exec (\'log_text_array (?, ?)\', vector (txt, args), 1);\n"
"}\n"
"--src users.sql:190\n";

static const char *proc2 = 
"create procedure\n"
"USER_CREATE (in _name varchar, in passwd varchar, in options any := NULL)\n"
"{\n"
"declare _pwd, _pwd_mode, _pwd_mode_data, _login_qual varchar;\n"
"declare _dav_enable, _sql_enable integer;\n"
"declare _prim_group, _get_pwd varchar;\n"
"declare _u_id, _prim_group_id, _disabled integer;\n"
"declare _u_full_name, _u_e_mail, _u_home, _u_perms varchar;\n"
"declare  _u_sys_name, _u_sys_pass, _u_sec_sys_name, _u_sec_sys_pass varchar;\n"
"\n"
"if (length (_name) < 1)\n"
"signal (\'22023\', concat (\'The user name cannot be empty\'), \'U0003\');\n"
"\n"
"\n"
"\n"
"if (options is null)\n"
"options := vector ();\n"
"\n"
"{\n"
"declare i, l integer;\n"
"declare new_opts any;\n"
"declare exit handler for sqlstate \'2202*\' {\n"
"signal (__SQL_STATE, sprintf (\'The options parameter must be an array of name/value pairs\'), \'U0004\');\n"
"};\n"
"_pwd_mode := get_keyword_ucase (\'PASSWORD_MODE\', options, NULL);\n"
"_pwd_mode_data := get_keyword_ucase (\'PASSWORD_MODE_DATA\', options, NULL);\n"
"_get_pwd := get_keyword_ucase (\'GET_PASSWORD\', options, NULL);\n"
"_sql_enable := cast (get_keyword_ucase (\'SQL_ENABLE\', options, 1) as integer);\n"
"_dav_enable := cast (get_keyword_ucase (\'DAV_ENABLE\', options, 0) as integer);\n"
"_login_qual := get_keyword_ucase (\'LOGIN_QUALIFIER\', options, \'DB\');\n"
"_prim_group := get_keyword_ucase (\'PRIMARY_GROUP\', options, NULL);\n"
"\n"
"_u_e_mail := get_keyword_ucase (\'E-MAIL\', options, \'\');\n"
"_u_full_name := get_keyword_ucase (\'FULL_NAME\', options, NULL);\n"
"_u_home := get_keyword_ucase (\'HOME\', options, NULL);\n"
"_u_perms := get_keyword_ucase (\'PERMISSIONS\', options, \'110100000R\');\n"
"_disabled := get_keyword_ucase (\'DISABLED\', options, 0);\n"
"\n"
"_u_sec_sys_name := get_keyword_ucase (\'SYSTEM_UNAME\', options, NULL);\n"
"_u_sec_sys_pass := get_keyword_ucase (\'SYSTEM_UPASS\', options, NULL);\n"
"\n"
"i := 0; l := length (options);\n"
"new_opts := vector ();\n"
"while (i < l)\n"
"{\n"
"if (upper(options[i]) not in (\'PASSWORD_MODE\', \'PASSWORD_MODE_DATA\', \'GET_PASSWORD\', \'SQL_ENABLE\', \'DAV_ENABLE\', \'LOGIN_QUALIFIER\', \'PRIMARY_GROUP\', \'E-MAIL\', \'FULL_NAME\', \'HOME\', \'PERMISSIONS\', \'DISABLED\'))\n"
"{\n"
"new_opts := vector_concat (new_opts, vector (options[i], options[i+1]));\n"
"}\n"
"i := i + 2;\n"
"}\n"
"}\n"
"if (_login_qual = \'\')\n"
"signal (\'22023\', \'Qualifier cannot be empty string\');\n"
"\n"
"_pwd := pwd_magic_calc (_name, passwd, 0);\n"
"_u_sys_name := pwd_magic_calc (_name, _u_sec_sys_name, 0);\n"
"_u_sys_pass := pwd_magic_calc (_name, _u_sec_sys_pass, 0);\n"
"\n"
"_u_id := coalesce ((select U_ID from SYS_USERS where U_NAME = _name),\n"
"(select max(U_ID) from SYS_USERS) + 1);\n"
"\n"
"if (_u_id < 100)\n"
"_u_id := 100;\n"
"\n"
"if (isstring (_prim_group))\n"
"_prim_group_id := coalesce ((select U_ID from SYS_USERS where U_NAME = _prim_group), NULL);\n"
"else if (isinteger (_prim_group))\n"
"_prim_group_id := cast (_prim_group as integer);\n"
"else\n"
"_prim_group_id := _u_id;\n"
"\n"
"insert replacing SYS_USERS (U_ID, U_NAME, U_PASSWORD, U_GROUP, U_FULL_NAME, U_E_MAIL,\n"
"U_ACCOUNT_DISABLED, U_DAV_ENABLE, U_SQL_ENABLE, U_DATA, U_OPTS,\n"
"U_PASSWORD_HOOK, U_PASSWORD_HOOK_DATA, U_GET_PASSWORD, U_DEF_QUAL,\n"
"U_HOME, U_DEF_PERMS)\n"
"values (_u_id, _name, _pwd, _prim_group_id, _u_full_name, _u_e_mail, _disabled, _dav_enable, _sql_enable,\n"
"concat (\'Q \', _login_qual), serialize (options),\n"
"_pwd_mode, _pwd_mode_data, _get_pwd, _login_qual,\n"
"_u_home, _u_perms);\n"
"\n"
"if (_sql_enable)\n"
"{\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_set_user_struct (?,?,?,?,?,?,?)\', vector (\n"
"_name, passwd, _u_id, _prim_group_id, concat (\'Q \', _login_qual), 0, _u_sys_name, _u_sys_pass ) );\n"
"if (_disabled = 1)\n"
"{\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_user_enable (?, ?)\', vector (\n"
"_name, 0 ) );\n"
"}\n"
"}\n"
"\n"
"return _u_id;\n"
"}\n"
"--src users.sql:197\n";

static const char *proc3 = 
"create procedure\n"
"USER_ROLE_CREATE (in _name varchar, in is_dav integer := 0)\n"
"{\n"
"declare _g_id integer;\n"
"declare _sql_enable integer;\n"
"if (length (_name) < 1)\n"
"signal (\'22023\', concat (\'The role name cannot be empty\'), \'U0005\');\n"
"if (exists (select 1 from SYS_USERS where U_NAME = _name))\n"
"signal (\'37000\', concat (\'The object \'\'\', _name, \'\'\' already exists\'), \'U0006\');\n"
"_g_id := (select max(U_ID) from SYS_USERS) + 1;\n"
"if (_g_id < 100)\n"
"_g_id := 100;\n"
"_sql_enable := 1;\n"
"if (is_dav)\n"
"_sql_enable := 0;\n"
"insert into SYS_USERS (U_ID, U_NAME, U_GROUP, U_IS_ROLE, U_DAV_ENABLE, U_SQL_ENABLE) values (_g_id, _name, _g_id, 1, is_dav, _sql_enable);\n"
"if (_sql_enable)\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_set_user_struct (?,?,?,?,?,?)\',\n"
"vector (_name, \'\', _g_id, _g_id, NULL, 1) );\n"
"return _g_id;\n"
"}\n"
"--src users.sql:294\n";

static const char *proc4 = 
"create procedure\n"
"USER_ROLE_DROP (in _name varchar)\n"
"{\n"
"declare _u_id, _u_is_sql integer;\n"
"declare opts any;\n"
"GET_SEC_OBJECT_ID (_name, _u_id, _u_is_sql, opts);\n"
"delete from SYS_USERS where U_NAME = _name and U_IS_ROLE = 1;\n"
"if (not row_count())\n"
"signal (\'37000\', concat (\'The role \'\'\', _name, \'\'\' does not exist\'), \'U0007\');\n"
"\n"
"delete from SYS_ROLE_GRANTS where GI_SUPER = _u_id or GI_SUB = _u_id or GI_GRANT = _u_id;\n"
"delete from SYS_GRANTS where G_USER = _u_id;\n"
"if (_u_is_sql)\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_remove_user_struct(?)\', vector (_name));\n"
"}\n"
"--src users.sql:317\n";

static const char *proc5 = 
"create procedure\n"
"USER_CHANGE_PASSWORD (in _name varchar, in old_pwd varchar, in new_pwd varchar)\n"
"{\n"
"if (exists (select 1 from SYS_USERS where U_NAME = _name and U_IS_ROLE = 0 and pwd_magic_calc (U_NAME, U_PASSWORD, 1) = old_pwd))\n"
"{\n"
"if (exists (select 1 from SYS_USERS where U_NAME = _name and U_SQL_ENABLE = 1))\n"
"USER_SET_PASSWORD (_name, new_pwd);\n"
"else\n"
"{\n"
"update SYS_USERS set U_PASSWORD = pwd_magic_calc (_name, new_pwd) where U_NAME = _name;\n"
"}\n"
"}\n"
"else if (exists (select 1 from SYS_USERS where U_NAME = _name and U_IS_ROLE = 0))\n"
"signal (\'42000\', concat (\'The old password for \'\'\', _name, \'\'\' does not match\'), \'U0008\');\n"
"else\n"
"signal (\'37000\', concat (\'The user \'\'\', _name, \'\'\' does not exist\'), \'U0009\');\n"
"}\n"
"--src users.sql:334\n";

static const char *proc6 = 
"create procedure USER_PASSWORD_SET (in name varchar, in passwd varchar)\n"
"{\n"
"declare _u_id, _u_group integer;\n"
"declare _u_data varchar;\n"
"if (exists (select 1 from SYS_USERS where U_NAME = name and U_SQL_ENABLE = 1))\n"
"{\n"
"user_set_password (name, passwd);\n"
"return 0;\n"
"}\n"
"select U_ID, U_GROUP into _u_id, _u_group from DB.DBA.SYS_USERS where U_NAME = USER;\n"
"if (not (_u_id = 0 or _u_group = 0))\n"
"signal (\'42000\', \'Function DB.DBA.USER_PASSWORD_SET is restricted to dba group\', \'SR285\');\n"
"if (not exists (select 1 from DB.DBA.SYS_USERS where U_NAME = name and U_DAV_ENABLE = 1 and U_IS_ROLE = 0))\n"
"signal (\'42000\', concat (\'The user \'\'\', name, \'\'\' does not exist\'), \'SR286\');\n"
"if (not isstring (passwd) or length (passwd) < 1)\n"
"signal (\'42000\', concat (\'The new password for \'\'\', name, \'\'\' cannot be empty\'), \'SR287\');\n"
"update DB.DBA.SYS_USERS set U_PASSWORD = pwd_magic_calc (name, passwd) where U_NAME = name;\n"
"return 0;\n"
"}\n"
"--src users.sql:353\n";

static const char *proc7 = 
"create procedure\n"
"USER_SET_QUALIFIER (in _name varchar, in qual varchar)\n"
"{\n"
"if (exists (select 1 from SYS_USERS where U_NAME = _name and U_IS_ROLE = 0))\n"
"{\n"
"if (not length (qual))\n"
"signal (\'22023\', \'Qualifier cannot be empty string\');\n"
"update DB.DBA.SYS_USERS set U_DATA = concatenate (\'Q \', qual), U_DEF_QUAL = qual where U_NAME = _name;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_set_user_data(?,?)\', vector (_name, concatenate (\'Q \', qual)));\n"
"}\n"
"else\n"
"{\n"
"signal (\'37000\', concat (\'The user \'\'\', _name, \'\'\' does not exist\'), \'U0010\');\n"
"}\n"
"}\n"
"--src users.sql:374\n";

static const char *proc8 = 
"create procedure\n"
"USER_SET_ROLE (in _name varchar, in new_role varchar)\n"
"{\n"
"signal (\'42000\', \'Not implemented.\');\n"
"}\n"
"--src users.sql:392\n";

static const char *proc9 = 
"create procedure\n"
"GET_INHERITED_GRANTS (in g_id integer, in prim integer, inout inh any)\n"
"{\n"
"for select GI_SUB from SYS_ROLE_GRANTS where GI_SUPER = g_id and GI_DIRECT = 1\n"
"do\n"
"{\n"
"\n"
"if (GI_SUB <> prim)\n"
"{\n"
"if (not position (GI_SUB, inh))\n"
"inh := vector_concat (inh, vector (GI_SUB));\n"
"GET_INHERITED_GRANTS (GI_SUB, prim, inh);\n"
"}\n"
"else\n"
"{\n"
"signal (\'42000\', sprintf (\'Circular role grant detected\'), \'U0011\');\n"
"}\n"
"}\n"
"}\n"
"--src users.sql:399\n";

static const char *proc10 = 
"create procedure\n"
"USER_GRANT_ROLE (in _name varchar, in _role varchar, in grant_opt integer := 0)\n"
"{\n"
"declare _u_id, _g_id, _u_is_sql, _g_is_sql, primary_group integer;\n"
"declare opts, inh any;\n"
"GET_SEC_OBJECT_ID (_name, _u_id, _u_is_sql, opts);\n"
"GET_SEC_OBJECT_ID (_role, _g_id, _g_is_sql, opts);\n"
"primary_group := USER_GET_OPTION (_name, \'PRIMARY_GROUP\');\n"
"if (_u_id = _g_id)\n"
"{\n"
"signal (\'42000\', sprintf (\'Circular role grant detected\'), \'U0011\');\n"
"}\n"
"\n"
"if (not exists (select 1 from SYS_USERS where U_NAME = _role and U_IS_ROLE = 1))\n"
"{\n"
"signal (\'37000\', sprintf (\'Role \"%s\" does not exist\', _role), \'U0012\');\n"
"}\n"
"if (_g_id = http_nobody_uid () or _g_id = http_nogroup_gid ())\n"
"{\n"
"signal (\'37000\', sprintf (\'System role \"%s\" can not be granted to \"%s\"\', _role, _name), \'U0013\');\n"
"}\n"
"if (_u_id = http_nobody_uid () or _u_id = http_nogroup_gid ())\n"
"{\n"
"signal (\'37000\', sprintf (\'Role \"%s\" can not be granted to special account \"%s\"\', _role, _name), \'U0014\');\n"
"}\n"
"\n"
"{\n"
"declare i, l integer;\n"
"declare exit handler for sqlstate \'23000\' {\n"
"signal (\'42000\', sprintf (\'The object \"%s\" already have role \"%s\" assigned\', _name, _role), \'U0013\');\n"
"};\n"
"inh := vector ();\n"
"GET_INHERITED_GRANTS (_g_id, _g_id, inh);\n"
"if (position (_u_id, inh))\n"
"{\n"
"signal (\'42000\', sprintf (\'Circular role grant detected\'), \'U0011\');\n"
"}\n"
"insert into SYS_ROLE_GRANTS (GI_SUPER, GI_SUB, GI_ADMIN, GI_DIRECT, GI_GRANT)\n"
"values (_u_id, _g_id, grant_opt, 1, _g_id);\n"
"i := 0; l := length (inh);\n"
"while (i < l)\n"
"{\n"
"if (primary_group is null or inh[i] <> primary_group)\n"
"{\n"
"insert into SYS_ROLE_GRANTS (GI_SUPER, GI_SUB, GI_ADMIN, GI_DIRECT, GI_GRANT)\n"
"values (_u_id, inh[i], grant_opt, 0, _g_id);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"if (_u_is_sql)\n"
"{\n"
"for select distinct rg.GI_SUB as GI_SUB from SYS_ROLE_GRANTS as rg, SYS_USERS as u where\n"
"rg.GI_SUPER = _u_id and rg.GI_GRANT = _g_id and u.U_ID = GI_SUB and u.U_SQL_ENABLE\n"
"do\n"
"{\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_grant_user_role (?,?)\', vector (_u_id, GI_SUB));\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src users.sql:421\n";

static const char *proc11 = 
"create procedure\n"
"USER_REVOKE_ROLE (in _name varchar, in _role varchar)\n"
"{\n"
"declare _u_id, _g_id, _u_is_sql, _g_is_sql integer;\n"
"declare opts any;\n"
"GET_SEC_OBJECT_ID (_name, _u_id, _u_is_sql, opts);\n"
"GET_SEC_OBJECT_ID (_role, _g_id, _g_is_sql, opts);\n"
"if ((_g_id = http_nogroup_gid () and _u_id = http_nobody_uid ()) or (_g_id = http_admin_gid() and _u_id = http_dav_uid()))\n"
"{\n"
"signal (\'37000\', sprintf (\'Built-in role \"%s\" can not be revoked from built-in user \"%s\"\', _role, _name), \'U0015\');\n"
"}\n"
"for select distinct GI_SUB as sub from SYS_ROLE_GRANTS where\n"
"GI_SUPER = _u_id and GI_GRANT = _g_id\n"
"do\n"
"{\n"
"declare gra integer;\n"
"gra := _g_id;\n"
"if (not exists (select 1 from SYS_ROLE_GRANTS\n"
"where GI_SUPER = _u_id and GI_GRANT <> gra and GI_SUB = sub))\n"
"{\n"
"if (_u_is_sql and\n"
"exists (select 1 from SYS_USERS where U_ID = sub and U_SQL_ENABLE) )\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_revoke_user_role (?,?)\', vector (_u_id, sub));\n"
"}\n"
"}\n"
"\n"
"\n"
"delete from SYS_ROLE_GRANTS where GI_SUPER = _u_id and GI_GRANT = _g_id;\n"
"if (not row_count ())\n"
"signal (\'42000\', concat (\'The user \'\'\', _name, \'\'\' does not have granted role \"\', _role, \'\".\'), \'U0014\');\n"
"\n"
"\n"
"\n"
"}\n"
"--src users.sql:483\n";

static const char *proc12 = 
"create procedure\n"
"USER_DROP (in _name varchar, in _cascade integer := 0)\n"
"{\n"
"if (_cascade)\n"
"{\n"
"declare _tables, _udts any;\n"
"_tables := DB.DBA.__DDL_GET_DROP_USER_TABLES (_name);\n"
"_udts := __ddl_udt_get_udt_list_by_user (_name);\n"
"\n"
"\n"
"FOR select P_NAME, P_TYPE from DB.DBA.SYS_PROCEDURES where P_OWNER = _name do\n"
"{\n"
"if (P_TYPE = 3)\n"
"{\n"
"exec (sprintf (\'drop module \"%I\".\"%I\".\"%I\"\',\n"
"name_part (P_NAME, 0), name_part (P_NAME, 1), name_part (P_NAME, 2)));\n"
"}\n"
"else\n"
"{\n"
"exec (sprintf (\'drop procedure \"%I\".\"%I\".\"%I\"\',\n"
"name_part (P_NAME, 0), name_part (P_NAME, 1), name_part (P_NAME, 2)));\n"
"}\n"
"}\n"
"declare _inx integer;\n"
"\n"
"_inx := 0;\n"
"while (_inx < length (_tables))\n"
"{\n"
"exec (sprintf (\'drop table \"%I\".\"%I\".\"%I\"\',\n"
"name_part (_tables[_inx], 0), name_part (_tables[_inx], 1), name_part (_tables[_inx], 2)));\n"
"_inx := _inx + 2;\n"
"}\n"
"\n"
"\n"
"_inx := 0;\n"
"while (_inx < length (_udts))\n"
"{\n"
"exec (sprintf (\'drop type \"%I\".\"%I\".\"%I\"\',\n"
"name_part (_udts[_inx], 0), name_part (_udts[_inx], 1), name_part (_udts[_inx], 2)));\n"
"_inx := _inx + 2;\n"
"}\n"
"}\n"
"declare _u_id, _u_is_sql integer;\n"
"declare opts any;\n"
"GET_SEC_OBJECT_ID (_name, _u_id, _u_is_sql, opts);\n"
"delete from SYS_USERS where U_NAME = _name and U_IS_ROLE = 0;\n"
"if (not row_count ())\n"
"signal (\'37000\', concat (\'The user \'\'\', _name, \'\'\' does not exist\'), \'U0015\');\n"
"delete from SYS_USER_GROUP where UG_UID = _u_id;\n"
"delete from SYS_GRANTS where G_USER = _u_id;\n"
"if (_u_is_sql)\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_remove_user_struct(?)\', vector (_name));\n"
"}\n"
"--src users.sql:520\n";

static const char *proc13 = 
"create procedure\n"
"USER_SET_OPTION (in _name varchar, in opt varchar, in value any)\n"
"{\n"
"declare _u_id, _u_is_sql integer;\n"
"declare opts, passwd any;\n"
"\n"
"declare _u_full_name, _u_e_mail, _u_home, _u_perms, _pwd_mode, _pwd_mode_data,\n"
"_login_qual, _sql_enable, _dav_enable, _get_pwd, _u_group, _u_group_id, _disabled any;\n"
"\n"
"GET_SEC_OBJECT_ID (_name, _u_id, _u_is_sql, opts);\n"
"if (position (opt, opts))\n"
"{\n"
"aset (opts, position (opt, opts), value);\n"
"}\n"
"else\n"
"{\n"
"opts := vector_concat (opts, vector (opt, value));\n"
"}\n"
"\n"
"_pwd_mode := get_keyword_ucase (\'PASSWORD_MODE\', opts, NULL);\n"
"_pwd_mode_data := get_keyword_ucase (\'PASSWORD_MODE_DATA\', opts, NULL);\n"
"_get_pwd := get_keyword_ucase (\'GET_PASSWORD\', opts, NULL);\n"
"_sql_enable := get_keyword_ucase (\'SQL_ENABLE\', opts, 1);\n"
"_dav_enable := get_keyword_ucase (\'DAV_ENABLE\', opts, 0);\n"
"_login_qual := get_keyword_ucase (\'LOGIN_QUALIFIER\', opts, \'DB\');\n"
"_u_group := get_keyword_ucase (\'PRIMARY_GROUP\', opts, NULL);\n"
"_u_e_mail := get_keyword_ucase (\'E-MAIL\', opts, \'\');\n"
"_u_full_name := get_keyword_ucase (\'FULL_NAME\', opts, NULL);\n"
"_u_home := get_keyword_ucase (\'HOME\', opts, NULL);\n"
"_u_perms := get_keyword_ucase (\'PERMISSIONS\', opts, \'110100000R\');\n"
"_disabled := get_keyword_ucase (\'DISABLED\', opts, 0);\n"
"\n"
"if (isstring (_u_group))\n"
"_u_group_id := coalesce ((select U_ID from SYS_USERS where U_NAME = _u_group), NULL);\n"
"else if (isinteger (_u_group))\n"
"_u_group_id := _u_group;\n"
"else\n"
"_u_group_id := _u_id;\n"
"\n"
"\n"
"{\n"
"declare i, l int;\n"
"declare ret any;\n"
"ret := vector ();\n"
"i := 0; l := length (opts);\n"
"while (i < l)\n"
"{\n"
"if (upper(opts[i]) not in (\'PASSWORD_MODE\', \'PASSWORD_MODE_DATA\', \'GET_PASSWORD\', \'SQL_ENABLE\', \'DAV_ENABLE\', \'LOGIN_QUALIFIER\', \'PRIMARY_GROUP\', \'E-MAIL\', \'FULL_NAME\', \'HOME\', \'PERMISSIONS\', \'DISABLED\'))\n"
"{\n"
"ret := vector_concat (ret, vector (opts[i], opts[i+1]));\n"
"}\n"
"i := i + 2;\n"
"}\n"
"opts := ret;\n"
"}\n"
"\n"
"\n"
"update SYS_USERS set U_OPTS = serialize (opts),\n"
"U_PASSWORD_HOOK = _pwd_mode,\n"
"U_PASSWORD_HOOK_DATA = _pwd_mode_data,\n"
"U_GET_PASSWORD = _get_pwd,\n"
"U_SQL_ENABLE = _sql_enable,\n"
"U_DAV_ENABLE = _dav_enable,\n"
"U_DEF_QUAL = _login_qual,\n"
"U_DATA = case when length (_login_qual) then concat (\'Q \', _login_qual) else NULL end,\n"
"U_GROUP = _u_group_id,\n"
"U_E_MAIL = _u_e_mail,\n"
"U_FULL_NAME = _u_full_name,\n"
"U_HOME = _u_home,\n"
"U_DEF_PERMS = _u_perms,\n"
"U_ACCOUNT_DISABLED = _disabled\n"
"where U_NAME = _name;\n"
"\n"
"if (_sql_enable)\n"
"{\n"
"select pwd_magic_calc (U_NAME, U_PASSWORD, 1) into passwd from SYS_USERS where U_NAME = _name;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_set_user_struct (?,?,?,?,?)\',\n"
"vector (\n"
"_name, passwd, _u_id, _u_group_id,\n"
"case when _login_qual is not null then concat (\'Q \', _login_qual) else NULL end ) );\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_user_enable (?, ?)\',\n"
"vector (_name, case when _disabled = 0 then 1 else 0 end) );\n"
"}\n"
"else\n"
"{\n"
"declare exit handler for sqlstate \'28000\'\n"
"{\n"
"goto done;\n"
"};\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'sec_remove_user_struct(?)\', vector (_name));\n"
"done:;\n"
"}\n"
"}\n"
"--src users.sql:575\n";

static const char *proc14 = 
"create procedure\n"
"USER_GET_OPTION (in _name varchar, in opt varchar)\n"
"{\n"
"declare _u_id, _u_is_sql integer;\n"
"declare opts any;\n"
"GET_SEC_OBJECT_ID (_name, _u_id, _u_is_sql, opts);\n"
"return get_keyword_ucase (upper (opt), opts, NULL);\n"
"}\n"
"--src users.sql:671\n";

static const char *proc15 = 
"create procedure\n"
"USER_MGR_SET_OPTION (in opt varchar, in val varchar)\n"
"{\n"
"signal (\'42000\', \'Not implemented.\');\n"
"}\n"
"--src users.sql:682\n";

static const char *proc16 = 
"create procedure\n"
"USER_MGR_GET_OPTION (in opt varchar) returns varchar\n"
"{\n"
"signal (\'42000\', \'Not implemented.\');\n"
"}\n"
"--src users.sql:690\n";

static const char *proc17 = 
"create procedure\n"
"LIST_USER_ROLE_GRANTS ()\n"
"{\n"
"declare arr, rarr any;\n"
"declare i, l integer;\n"
"declare j, k integer;\n"
"declare name, rolen varchar;\n"
"arr := list_role_grants ();\n"
"i := 0; l := length (arr);\n"
"result_names (name, rolen);\n"
"while (i < l)\n"
"{\n"
"name := arr[i];\n"
"rarr := arr[i+1];\n"
"j := 0; k := length (rarr);\n"
"rolen := \'\';\n"
"while (j < k)\n"
"{\n"
"if (j > 0)\n"
"rolen := concat (rolen, \',\');\n"
"rolen := concat (rolen, \' \', rarr[j]);\n"
"j := j + 1;\n"
"}\n"
"result (name, rolen);\n"
"i := i + 2;\n"
"}\n"
"}\n"
"--src users.sql:708\n";

static const char *proc18 = 
"create procedure\n"
"USER_KEY_IS_FILE (in f varchar, out path varchar)\n"
"{\n"
"declare hinfo any;\n"
"if (f is null)\n"
"return 0;\n"
"hinfo := rfc1808_parse_uri (f);\n"
"if (lower(hinfo[0]) = \'file\')\n"
"{\n"
"path := hinfo[2];\n"
"return 1;\n"
"}\n"
"else\n"
"return 0;\n"
"}\n"
"--src users.sql:737\n";

static const char *proc19 = 
"create procedure\n"
"USER_KEY_STORE (in username varchar, in key_name varchar, in key_type varchar, in key_format varchar, in key_passwd varchar, in key_value varchar := NULL)\n"
"{\n"
"declare keys, path any;\n"
"declare inx int;\n"
"\n"
"if (USER_KEY_IS_FILE (key_name, path))\n"
"key_value := NULL;\n"
"else if (key_value is null)\n"
"{\n"
"key_value := xenc_key_serialize (key_name);\n"
"if (key_value is null)\n"
"key_value := xenc_key_serialize (key_name, 1);\n"
"if (key_value is null)\n"
"signal (\'22023\', \'Can not serialize the key\');\n"
"}\n"
"\n"
"keys := coalesce (USER_GET_OPTION (username, \'KEYS\'), vector ());\n"
"inx := position (key_name, keys);\n"
"if (inx > 0)\n"
"aset (keys, inx, vector (key_type, key_format, key_value, key_passwd));\n"
"else\n"
"keys := vector_concat (keys, vector (key_name, vector (key_type, key_format, key_value, key_passwd)));\n"
"USER_SET_OPTION (username, \'KEYS\', keys);\n"
"}\n"
"--src users.sql:755\n";

static const char *proc20 = 
" create procedure\n"
"USER_KEY_DELETE (in username varchar, in key_name varchar)\n"
"{\n"
"declare keys any;\n"
"declare inx int;\n"
"if (lower(user) <> \'dba\' and username <> user)\n"
"signal (\'42000\', \'Can\\\'t delete non own keys\');\n"
"keys := coalesce (USER_GET_OPTION (username, \'KEYS\'), vector ());\n"
"inx := position (key_name, keys);\n"
"if (inx > 0)\n"
"{\n"
"\n"
"aset (keys, inx, NULL);\n"
"aset (keys, inx - 1, NULL);\n"
"USER_SET_OPTION (username, \'KEYS\', keys);\n"
"}\n"
"}\n"
"--src users.sql:783\n";

static const char *proc21 = 
"create procedure\n"
"USER_KEYS_INIT (in username varchar, in opts any)\n"
"{\n"
"declare i, l, fmt, debug, u_id int;\n"
"declare keys, path, key_value, key_type, key_passwd, key_pkey, os_u_name, os_u_pass any;\n"
"declare certs any;\n"
"\n"
"debug := 1;\n"
"\n"
"opts := deserialize (blob_to_string (opts));\n"
"\n"
"__set_user_os_acount_int (username, NULL, NULL);\n"
"\n"
"if (not isarray (opts))\n"
"return 0;\n"
"\n"
"keys := get_keyword_ucase (\'KEYS\', opts, NULL);\n"
"certs := get_keyword_ucase (\'LOGIN_CERTIFICATES\', opts, NULL);\n"
"os_u_name := get_keyword_ucase (\'SYSTEM_UNAME\', opts, NULL);\n"
"os_u_pass := get_keyword_ucase (\'SYSTEM_UPASS\', opts, NULL);\n"
"\n"
"if (os_u_name is not NULL)\n"
"{\n"
"os_u_name := pwd_magic_calc (username, os_u_name, 0);\n"
"os_u_pass := pwd_magic_calc (username, os_u_pass, 0);\n"
"__set_user_os_acount_int (username, os_u_name, os_u_pass);\n"
"}\n"
"\n"
"\n"
"if (certs is not null)\n"
"{\n"
"l := length (certs); i := 0;\n"
"while (i < l)\n"
"{\n"
"if (certs[i] is not null)\n"
"sec_set_user_cert (username, certs [i]);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"\n"
"if (keys is null)\n"
"return 0;\n"
"\n"
"if (debug) log_message (\'XENC: Loading key for user : \' || username);\n"
"\n"
"l := length (keys); i := 0; key_pkey := null;\n"
"while (i < l)\n"
"{\n"
"if (keys[i] is null)\n"
"goto next;\n"
"\n"
"key_type := keys[i+1][0];\n"
"fmt := keys[i+1][1];\n"
"key_value := keys[i+1][2];\n"
"key_passwd := keys[i+1][3];\n"
"if (USER_KEY_IS_FILE (keys[i], path))\n"
"{\n"
"if (isstring (file_stat (path)))\n"
"key_value := file_to_string (path);\n"
"else\n"
"{\n"
"log_message (sprintf (\'XENC: Can\\\'t open key file: %s\', path));\n"
"goto next;\n"
"}\n"
"}\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\' {\n"
"__pop_user_id ();\n"
"log_message (\'XENC: \' || __SQL_MESSAGE);\n"
"goto next;\n"
"};\n"
"__set_user_id (username);\n"
"__USER_LOAD_KEY_BY_TYPE (keys[i], key_value, key_type, fmt, key_pkey, key_passwd);\n"
"__pop_user_id ();\n"
"if (debug) log_message (\'XENC:   Loaded : \' || keys[i]);\n"
"}\n"
"next:\n"
"i := i + 2;\n"
"}\n"
"return 0;\n"
"}\n"
"--src users.sql:803\n";

static const char *proc22 = 
"create procedure\n"
"__USER_LOAD_KEY_BY_TYPE (inout key_name varchar, inout key_value any, inout key_type any, inout fmt int, inout key_pkey any, inout key_passwd any)\n"
"{\n"
"if (key_type = \'3DES\')\n"
"{\n"
"\n"
"xenc_key_3DES_read (key_name, key_value, fmt, key_passwd);\n"
"}\n"
"else if (key_type = \'DSA\')\n"
"{\n"
"xenc_key_DSA_read (key_name, key_value, fmt, key_passwd);\n"
"}\n"
"else if (key_type = \'RSA\')\n"
"{\n"
"xenc_key_RSA_read (key_name, key_value, fmt, key_passwd);\n"
"}\n"
"else if (0 and key_type = \'AES\')\n"
"{\n"
" ;\n"
"}\n"
"else if (key_type = \'X.509\')\n"
"{\n"
"\n"
"xenc_key_create_cert (key_name, cast (key_value as varchar), key_type, fmt, NULL, key_passwd);\n"
"xenc_set_primary_key (key_name);\n"
"}\n"
"else\n"
"{\n"
"signal (\'22023\', \'Unknown key type\');\n"
"}\n"
"}\n"
"--src users.sql:887\n";

static const char *proc23 = 
" create procedure\n"
"USER_KEY_LOAD (\n"
"in key_name varchar,\n"
"in key_value any,\n"
"in key_type varchar,\n"
"in key_format varchar,\n"
"in key_passwd varchar := NULL,\n"
"in key_pkey any := NULL,\n"
"in store_pwd int := 0)\n"
"{\n"
"declare path varchar;\n"
"declare fmt any;\n"
"declare cert varchar;\n"
"\n"
"if (USER_KEY_IS_FILE (key_name, path))\n"
"key_value := file_to_string (path);\n"
"\n"
"fmt := case upper (key_format) when \'PEM\' then 1 when \'PKCS12\' then 2 when \'DER\' then 3 else -1 end;\n"
"\n"
"key_type := upper (key_type);\n"
"\n"
"if (key_type = \'X.509\')\n"
"cert := key_value;\n"
"else\n"
"cert := NULL;\n"
"\n"
"__USER_LOAD_KEY_BY_TYPE (key_name, key_value, key_type, fmt, key_pkey, key_passwd);\n"
"USER_KEY_STORE (user, key_name, key_type, fmt, case store_pwd when 1 then key_passwd else NULL end, cert);\n"
"}\n"
"--src users.sql:921\n";

static const char *proc24 = 
"create procedure\n"
"USER_CERT_REGISTER (in username varchar, in cert varchar, in pwd varchar := \'\', in coding varchar := \'PKCS12\')\n"
"{\n"
"declare certs, path, cfp, cont any;\n"
"declare inx, enc int;\n"
"\n"
"if (cert like \'__:__:__:__:__:__:__:__:__:__:__:__:__:__:__:__%\')\n"
"{\n"
"cfp := cert;\n"
"goto process;\n"
"}\n"
"\n"
"if (USER_KEY_IS_FILE (cert, path))\n"
"cont := file_to_string (path);\n"
"else\n"
"cont := cert;\n"
"\n"
"enc := case upper (coding) when \'PKCS12\' then 2 when \'DER\' then 1 when \'PEM\' then 0 else 0 end;\n"
"\n"
"cfp := get_certificate_info (6, cont, enc, pwd);\n"
"\n"
"if (cfp is null)\n"
"signal (\'22023\', \'The certificate have been supplied is not valid or corrupted\', \'U....\');\n"
"process:\n"
"certs := coalesce (USER_GET_OPTION (username, \'LOGIN_CERTIFICATES\'), vector ());\n"
"inx := position (cfp, certs);\n"
"if (inx > 0)\n"
"return;\n"
"certs := vector_concat (certs, vector (cfp));\n"
"USER_SET_OPTION (username, \'LOGIN_CERTIFICATES\', certs);\n"
"sec_set_user_cert (username, cfp);\n"
"}\n"
"--src users.sql:952\n";

static const char *proc25 = 
"create procedure\n"
"USER_CERT_UNREGISTER (in username varchar, in cert varchar, in pwd varchar := \'\', in coding varchar := \'PKCS12\')\n"
"{\n"
"declare certs, new_certs any;\n"
"declare path, cfp, cont any;\n"
"declare inx, len, enc int;\n"
"\n"
"if (cert like \'__:__:__:__:__:__:__:__:__:__:__:__:__:__:__:__%\')\n"
"{\n"
"cfp := cert;\n"
"goto process;\n"
"}\n"
"\n"
"if (USER_KEY_IS_FILE (cert, path))\n"
"cont := file_to_string (path);\n"
"else\n"
"cont := cert;\n"
"\n"
"enc := case upper (coding) when \'PKCS12\' then 2 when \'DER\' then 1 when \'PEM\' then 0 else 0 end;\n"
"\n"
"cfp := get_certificate_info (6, cont, enc, pwd);\n"
"\n"
"if (cfp is null)\n"
"signal (\'22023\', \'The certificate have been supplied is not valid or corrupted\', \'U....\');\n"
"\n"
"process:\n"
"certs := coalesce (USER_GET_OPTION (username, \'LOGIN_CERTIFICATES\'), vector ());\n"
"inx := position (cfp, certs);\n"
"if (inx = 0)\n"
"return;\n"
"aset (certs, inx-1, NULL);\n"
"len := length (certs); inx := 0; new_certs := vector ();\n"
"while (inx < len)\n"
"{\n"
"if (certs[inx] is not null)\n"
"new_certs := vector_concat (new_certs, vector (certs[inx]));\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"USER_SET_OPTION (username, \'LOGIN_CERTIFICATES\', new_certs);\n"
"sec_remove_user_cert (username, cfp);\n"
"}\n"
"--src users.sql:986\n";

static const char *proc26 = 
"create procedure\n"
"\"DB\".\"DBA\".\"USER_CERT_LOGIN\" (\n"
"inout user_name varchar,\n"
"in digest varchar,\n"
"in session_random varchar)\n"
"{\n"
"declare cn, fp, new_user, certs any;\n"
"declare rc int;\n"
"rc := -1;\n"
"\n"
"if (user_name = \'\' or user_name is null)\n"
"{\n"
"declare ext_oid varchar;\n"
"declare exit handler for sqlstate \'*\' {\n"
"goto normal_auth;\n"
"};\n"
"\n"
"\n"
"cn := get_certificate_info (2);\n"
"\n"
"fp := get_certificate_info (6);\n"
"\n"
"if (fp is null)\n"
"goto normal_auth;\n"
"\n"
"ext_oid := cfg_item_value (virtuoso_ini_path(), \'Parameters\', \'X509ExtensionOID\');\n"
"\n"
"if (ext_oid is not null)\n"
"new_user := get_certificate_info (7, null, null, null, ext_oid);\n"
"else\n"
"new_user := get_certificate_info (7);\n"
"\n"
"if (new_user is null)\n"
"new_user := sec_get_user_by_cert (fp);\n"
"\n"
"certs := coalesce (USER_GET_OPTION (new_user, \'LOGIN_CERTIFICATES\'), vector ());\n"
"\n"
"if (new_user is not null and position (fp, certs) > 0)\n"
"{\n"
"\n"
"user_name := new_user;\n"
"log_message (sprintf (\'Certificate \"%s\" [%s] is used to identify user \"%s\"\',\n"
"cn, fp, new_user));\n"
"rc := 1;\n"
"}\n"
"}\n"
"\n"
"normal_auth:\n"
"if (__proc_exists (\'DB.DBA.DBEV_LOGIN\'))\n"
"{\n"
"rc := \"DB\".\"DBA\".\"DBEV_LOGIN\" (user_name, digest, session_random);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.FOAF_SSL_LOGIN (user_name, digest, session_random);\n"
"if (rc = 0)\n"
"rc := DB.DBA.LDAP_LOGIN (user_name, digest, session_random);\n"
"}\n"
"return rc;\n"
"}\n"
"--src users.sql:1031\n";

static const char *proc27 = 
"create procedure\n"
"SET_USER_OS_ACOUNT (in username varchar, in os_u_name varchar,\n"
"in os_u_pass varchar, in only_check_sys_user integer := 0)\n"
"{\n"
"if (only_check_sys_user)\n"
"return __set_user_os_acount_int (username, os_u_name, os_u_pass, only_check_sys_user);\n"
"if (__set_user_os_acount_int (username, os_u_name, os_u_pass))\n"
"{\n"
"USER_SET_OPTION (username, \'SYSTEM_UNAME\', pwd_magic_calc (username, os_u_name, 0));\n"
"USER_SET_OPTION (username, \'SYSTEM_UPASS\', pwd_magic_calc (username, os_u_pass, 0));\n"
"return 1;\n"
"}\n"
"signal (\'42000\',\n"
"concat (\'Can\'\'t login system user \', os_u_name, \'. Logon failure: unknown user name or bad password.\'),\n"
"\'SR359\');\n"
"}\n"
"--src users.sql:1093\n";

static const char *other0 = 
"grant execute on \"DB.DBA.SET_USER_OS_ACOUNT\" to public\n";
static const char *proc28 = 
"create procedure DB.DBA.__DDL_TABLE_FIND_DEPS (in tb varchar, inout deps any)\n"
"{\n"
"declare tb_key_id integer;\n"
"declare tb_owner varchar;\n"
"\n"
"if (get_keyword (tb, deps, 0) = 1)\n"
"return;\n"
"\n"
"tb_owner := name_part (tb, 1);\n"
"\n"
"tb_key_id := NULL;\n"
"select KEY_ID into tb_key_id from DB.DBA.SYS_KEYS\n"
"where KEY_TABLE = tb and KEY_IS_MAIN = 1 and KEY_MIGRATE_TO is null;\n"
"if (tb_key_id is NULL)\n"
"signal (\'42000\',\n"
"concat (\'DB Schema inconsistency : Cannot find table \"\', tb, \'\" in DB.DBA.SYS_KEYS\'),\n"
"\'SR355\');\n"
"\n"
"for select SUB as _sub from DB.DBA.SYS_KEY_SUBKEY where SUPER = tb_key_id do\n"
"{\n"
"if (get_keyword (_sub, deps, 0) = 0)\n"
"{\n"
"declare stb_name varchar;\n"
"declare new_deps any;\n"
"\n"
"stb_name := NULL;\n"
"select KEY_TABLE into stb_name from DB.DBA.SYS_KEYS where KEY_ID = _sub;\n"
"if (stb_name is NULL)\n"
"signal (\'42000\',\n"
"concat (\'DB Schema inconsistency : Cannot key id \"\', _sub, \'\" in DB.DBA.SYS_KEYS\'),\n"
"\'SR356\');\n"
"\n"
"if (name_part (stb_name, 1) <> tb_owner)\n"
"signal (\'42000\',\n"
"concat (\'cannot drop table \"\', tb, \'\" because table \"\', stb_name, \'\" references it\'),\n"
"\'SR357\');\n"
"if (stb_name <> tb)\n"
"{\n"
"DB.DBA.__DDL_TABLE_FIND_DEPS (stb_name, deps);\n"
"}\n"
"}\n"
"}\n"
"\n"
"for select FK_TABLE as _fk_table from DB.DBA.SYS_FOREIGN_KEYS\n"
"where PK_TABLE = tb and FK_TABLE <> PK_TABLE do\n"
"{\n"
"if (get_keyword (_fk_table, deps, 0) = 0)\n"
"{\n"
"if (name_part (_fk_table, 1) <> tb_owner)\n"
"signal (\'42000\',\n"
"concat (\'cannot drop table \"\', tb, \'\" because table \"\', _fk_table, \'\" references it\'),\n"
"\'SR358\');\n"
"DB.DBA.__DDL_TABLE_FIND_DEPS (_fk_table, deps);\n"
"}\n"
"}\n"
"if (get_keyword (tb, deps, 0) = 0)\n"
"deps := vector_concat (deps, vector (tb, 1));\n"
"}\n"
"--src users.sql:1114\n";

static const char *proc29 = 
"create procedure DB.DBA.__DDL_GET_DROP_USER_TABLES (in owner varchar)\n"
"{\n"
"declare deps any;\n"
"deps := vector ();\n"
"\n"
"for select distinct KEY_TABLE as tb from DB.DBA.SYS_KEYS where KEY_MIGRATE_TO is NULL\n"
"and name_part (key_table, 1) = owner do\n"
"{\n"
"DB.DBA.__DDL_TABLE_FIND_DEPS (tb, deps);\n"
"}\n"
"\n"
"return deps;\n"
"}\n"
"--src users.sql:1175\n";

static const char *proc30 = 
"create procedure DB.DBA.__UPDATE_SOAP_USERS_ACCESS ()\n"
"{\n"
"\n"
"if (sequence_next (\'DB.DBA.__UPDATE_SOAP_USERS_ACCESS\') > 0)\n"
"return;\n"
"\n"
"for (select U_NAME from SYS_USERS where U_NAME in (\'Compound1\', \'Compound2\',\n"
"\'DocLit\', \'DocPars\', \'EmptySA\', \'_2PC\', \'Import1\', \'Import2\', \'Import3\', \'RpcEnc\',\n"
"\'SOAP\',	\'XQ\', \'interop4\', \'BACKUP\', \'interop4d\', \'interop4h\', \'interop4hcr\',\n"
"\'interop4xsd\', \'nterop4hcd\', \'nterop4hsd\', \'interop4hcd\', \'interop4hsd\', \'TestHeaders\',\n"
"\'TestList\') and U_NAME =  pwd_magic_calc (U_NAME, U_PASSWORD, 1) and U_ACCOUNT_DISABLED = 0) do\n"
"{\n"
"USER_SET_OPTION (U_NAME, \'DISABLED\', 1);\n"
"log_message (\'The login for account \' || U_NAME || \' is disabled.\');\n"
"}\n"
"\n"
"for (select U_NAME from SYS_USERS where U_NAME in (\'FORI\', \'INTEROP\') and U_ACCOUNT_DISABLED = 0) do\n"
"{\n"
"USER_SET_OPTION (U_NAME, \'DISABLED\', 1);\n"
"log_message (\'The login for account \' || U_NAME || \' is disabled.\');\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME = \'petshop\'))\n"
"{\n"
"exec (\'drop user petshop\');\n"
"log_message (\'The user petshop is deleted.\');\n"
"}\n"
"}\n"
"--src users.sql:1191\n";

static const char *other1 = 
"DB.DBA.__UPDATE_SOAP_USERS_ACCESS ()\n";
static const char *tbl0 = 
"create table SYS_LDAP_SERVERS\n"
"(\n"
"LS_ADDRESS varchar,\n"
"LS_BASE varchar,\n"
"LS_BIND_DN varchar,\n"
"LS_ACCOUNT varchar,\n"
"LS_PASSWORD varchar,\n"
"LS_UID_FLD  varchar,\n"
"LS_TRY_SSL int default 0,\n"
"LS_LDAP_VERSION int default 2,\n"
"primary key (LS_ADDRESS)\n"
")\n";

static const char *proc31 = 
"create procedure\n"
"DB.DBA.LDAP_LOGIN (inout user_name varchar, in digest varchar, in session_random varchar)\n"
"{\n"
"declare result, uopt, pass, epwd any;\n"
"\n"
"WHENEVER SQLSTATE \'28000\' GOTO LDAP_VALIDATION_FAILURE;\n"
"\n"
"if (lcase(user_name) <> \'dba\')\n"
"{\n"
"declare lserv, base, bind, lacc, lpwd, luid, ltry, lver, ltyp, upwd any;\n"
"uopt := USER_GET_OPTION (user_name, \'LDAPServer\');\n"
"if (not isarray (uopt) or length (uopt) <> 2)\n"
"return -1;\n"
"\n"
"lserv := uopt[0];\n"
"ltyp := uopt[1];\n"
"\n"
"whenever not found goto LDAP_SERVER_REMOVED;\n"
"select LS_BASE, LS_BIND_DN, LS_ACCOUNT, LS_PASSWORD, LS_UID_FLD, LS_TRY_SSL, LS_LDAP_VERSION\n"
"into base, bind, lacc, lpwd, luid, ltry, lver from SYS_LDAP_SERVERS where LS_ADDRESS = lserv;\n"
"\n"
"if (is_http_ctx())\n"
"{\n"
"if (get_keyword (\'authtype\', session_random) = \'basic\')\n"
"upwd := get_keyword (\'pass\', session_random);\n"
"else\n"
"return 0;\n"
"}\n"
"else\n"
"{\n"
"epwd := sys_stat (\'sql_encryption_on_password\');\n"
"if (epwd = 0)\n"
"return 0;\n"
"else if (epwd = 2)\n"
"upwd := pwd_magic_calc(user_name, digest, 1);\n"
"else if (epwd = 1)\n"
"upwd := digest;\n"
"else\n"
"return 0;\n"
"}\n"
"\n"
"\n"
"connection_set (\'LDAP_VERSION\', lver);\n"
"\n"
"if (ltyp = 0)\n"
"{\n"
"result := LDAP_SEARCH(lserv,\n"
"ltry, base, sprintf (\'(%s=%s)\', luid, user_name),\n"
"sprintf(\'%s=%s, %s\', luid, user_name, bind),\n"
"upwd);\n"
"\n"
"return 1;\n"
"}\n"
"else if (ltyp = 1)\n"
"{\n"
"declare ent any;\n"
"result := LDAP_SEARCH(lserv,\n"
"ltry, base, sprintf (\'(%s=%s)\', luid, user_name),\n"
"sprintf(\'%s=%s, %s\', luid, lacc, bind),\n"
"lpwd);\n"
"ent := get_keyword (\'entry\', result, vector ());\n"
"if (get_keyword (luid, ent) is not null)\n"
"{\n"
"\n"
"return -1;\n"
"}\n"
"return 0;\n"
"}\n"
"\n"
"}\n"
"\n"
"LDAP_SERVER_REMOVED:\n"
"return -1;\n"
"\n"
"LDAP_VALIDATION_FAILURE:\n"
"return 0;\n"
"}\n"
"--src users.sql:1241\n";

static const char *tbl1 = 
"create table SYS_USER_WEBID (UW_U_NAME varchar, UW_WEBID varchar, primary key (UW_WEBID))\n"
"alter index SYS_USER_WEBID on SYS_USER_WEBID partition cluster replicated\n"
"create index SYS_USER_WEBID_NAME on SYS_USER_WEBID (UW_U_NAME) partition cluster replicated\n";

static const char *proc32 = 
"create procedure\n"
"DB.DBA.FOAF_SSL_LOGIN (inout user_name varchar, in digest varchar, in session_random varchar)\n"
"{\n"
"declare stat, msg, meta, data, info, qr, hf, graph, gr any;\n"
"declare agent varchar;\n"
"declare rc int;\n"
"rc := 0;\n"
"gr := null;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"rollback work;\n"
"goto err_ret;\n"
"}\n"
" ;\n"
"\n"
"if (client_attr (\'client_ssl\') = 0)\n"
"return 0;\n"
"\n"
"info := get_certificate_info (9);\n"
"agent := get_certificate_info (7, null, null, null, \'2.5.29.17\');\n"
"\n"
"if (not isarray (info) or agent is null or agent not like \'URI:%\')\n"
"return 0;\n"
"\n"
"agent := subseq (agent, 4);\n"
"hf := rfc1808_parse_uri (agent);\n"
"hf[5] := \'\';\n"
"gr := uuid ();\n"
"graph := WS.WS.VFS_URI_COMPOSE (hf);\n"
"qr := sprintf (\'sparql load <%S> into graph <%S>\', graph, gr);\n"
"stat := \'00000\';\n"
"exec (qr, stat, msg);\n"
"commit work;\n"
"qr := sprintf (\n"
"\'sparql define input:storage \"\" \'||\n"
"\' prefix cert: <http://www.w3.org/ns/auth/cert#> \'||\n"
"\' prefix rsa: <http://www.w3.org/ns/auth/rsa#> \' ||\n"
"\' select (str (bif:coalesce (?exp_val, ?exp))) (str (bif:coalesce (?mod_val, ?mod))) \'||\n"
"\' from <%S> \'||\n"
"\' where { \'||\n"
"\' 	  ?id cert:identity <%S> ; rsa:public_exponent ?exp ; rsa:modulus ?mod . \' ||\n"
"\' 	  optional { ?exp cert:decimal ?exp_val . ?mod cert:hex ?mod_val . } \'||\n"
"\'       } \',\n"
"gr, agent);\n"
"stat := \'00000\';\n"
"exec (qr, stat, msg, vector (), 0, meta, data);\n"
"if (stat = \'00000\' and length (data) and data[0][0] = cast (info[1] as varchar) and data[0][1] = bin2hex (info[2]))\n"
"{\n"
"declare uname varchar;\n"
"uname := (select UW_U_NAME from SYS_USER_WEBID where UW_WEBID = agent);\n"
"if (length (uname))\n"
"{\n"
"user_name := uname;\n"
"rc := 1;\n"
"}\n"
"}\n"
"err_ret:\n"
"if (gr is not null)\n"
"exec (sprintf (\'sparql clear graph <%S>\', gr), stat, msg);\n"
"commit work;\n"
"return rc;\n"
"}\n"
"--src users.sql:1326\n";

static const char *proc33 = 
"create procedure\n"
"USERS_GET_DEF_QUAL (in dta varchar)\n"
"{\n"
"if (not length (dta))\n"
"{\n"
"return (\'DB\');\n"
"}\n"
"dta := split_and_decode (dta, 0, \'   \');\n"
"return (get_keyword (\'Q\', dta, \'\'));\n"
"}\n"
"--src users.sql:1391\n";

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name))) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_sys (void)
{
  /* users.sql */

  ddl_ensure_table ("DB.DBA.SYS_USER_GROUP", view0);
  ddl_std_proc (trig0, 0x0);
  ddl_std_proc (trig1, 0x0);
  ddl_std_proc (trig2, 0x0);
  DEFINE_PROC ("GET_SEC_OBJECT_ID", proc0);
  DEFINE_PROC ("DB.DBA.SECURITY_CL_EXEC_AND_LOG", proc1);
  DEFINE_PROC ("USER_CREATE", proc2);
  DEFINE_PROC ("USER_ROLE_CREATE", proc3);
  DEFINE_PROC ("USER_ROLE_DROP", proc4);
  DEFINE_PROC ("USER_CHANGE_PASSWORD", proc5);
  DEFINE_PROC ("USER_PASSWORD_SET", proc6);
  DEFINE_PROC ("USER_SET_QUALIFIER", proc7);
  DEFINE_PROC ("USER_SET_ROLE", proc8);
  DEFINE_PROC ("GET_INHERITED_GRANTS", proc9);
  DEFINE_PROC ("USER_GRANT_ROLE", proc10);
  DEFINE_PROC ("USER_REVOKE_ROLE", proc11);
  DEFINE_PROC ("USER_DROP", proc12);
  DEFINE_PROC ("USER_SET_OPTION", proc13);
  DEFINE_PROC ("USER_GET_OPTION", proc14);
  DEFINE_PROC ("USER_MGR_SET_OPTION", proc15);
  DEFINE_PROC ("USER_MGR_GET_OPTION", proc16);
  DEFINE_PROC ("LIST_USER_ROLE_GRANTS", proc17);
  DEFINE_PROC ("USER_KEY_IS_FILE", proc18);
  DEFINE_PROC ("USER_KEY_STORE", proc19); 
  DEFINE_PUBLIC_PROC ("USER_KEY_DELETE", proc20);
  DEFINE_PROC ("USER_KEYS_INIT", proc21);
  DEFINE_PROC ("__USER_LOAD_KEY_BY_TYPE", proc22); 
  DEFINE_PUBLIC_PROC ("USER_KEY_LOAD", proc23);
  DEFINE_PROC ("USER_CERT_REGISTER", proc24);
  DEFINE_PROC ("USER_CERT_UNREGISTER", proc25);
  DEFINE_PROC ("DB.DBA.USER_CERT_LOGIN", proc26);
  DEFINE_PROC ("SET_USER_OS_ACOUNT", proc27);
  ddl_ensure_table ("do this always", other0);
  DEFINE_PROC ("DB.DBA.__DDL_TABLE_FIND_DEPS", proc28);
  DEFINE_PROC ("DB.DBA.__DDL_GET_DROP_USER_TABLES", proc29);
  DEFINE_PROC ("DB.DBA.__UPDATE_SOAP_USERS_ACCESS", proc30);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("DB.DBA.SYS_LDAP_SERVERS", tbl0);
  DEFINE_PROC ("DB.DBA.LDAP_LOGIN", proc31);
  ddl_ensure_table ("DB.DBA.SYS_USER_WEBID", tbl1);
  DEFINE_PROC ("DB.DBA.FOAF_SSL_LOGIN", proc32);
  DEFINE_PROC ("USERS_GET_DEF_QUAL", proc33);
}


void
sqls_arfw_define_sys (void)
{
}
