/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigTemplate {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\{%[\\p{Print}&&[^\\}]]+%\\}");
    private String template;
    private Map<String, List<String>> variableMap = new LinkedHashMap<String, List<String>>();

    public ConfigTemplate(String template) {
        this.setTemplate(template);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template must not be null");
        }
        this.template = template;
        this.parseTemplate();
    }

    private void parseTemplate() {
        Matcher matcher = TOKEN_PATTERN.matcher(this.template);
        while (matcher.find()) {
            String group = matcher.group();
            String[] tokensArray = group.substring(2, group.length() - 2).split("\\|");
            List<String> tokens = Arrays.asList(tokensArray);
            String var = tokens.get(0).trim();
            List<String> values = tokens.subList(1, tokens.size());
            if (var.length() == 0) {
                throw new IllegalArgumentException("Illegal template token: " + matcher.group());
            }
            if (this.variableMap.containsKey(var)) continue;
            this.variableMap.put(var, values);
        }
    }

    public Map<String, List<String>> getVariableMap() {
        return Collections.unmodifiableMap(this.variableMap);
    }

    public String render(Map<String, String> valueMap) {
        StringBuffer result = new StringBuffer(this.template.length());
        Matcher matcher = TOKEN_PATTERN.matcher(this.template);
        while (matcher.find()) {
            String group = matcher.group();
            String[] tokensArray = group.substring(2, group.length() - 2).split("\\|");
            String var = tokensArray[0].trim();
            String value = valueMap.get(var);
            if (value == null) {
                List<String> values = this.variableMap.get(var);
                value = !values.isEmpty() ? values.get(0) : "";
            }
            matcher.appendReplacement(result, value);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

