/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright 2003 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "parser.h"

#define INITIAL 0
#define mediaquery 1
#define at_rule 2
#define block 3

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 64
#define YY_END_OF_BUFFER 65
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[396] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   65,   63,
        2,    2,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   49,   63,   63,   63,   63,   14,   14,   14,   57,
       63,   63,   63,   49,   62,   14,   14,   14,   61,   59,
       58,   63,   60,    2,    0,    0,    0,   13,    0,    0,
        0,   17,    8,    0,    0,    9,    0,    0,    0,   14,
       14,   50,    0,   48,    0,    0,   49,    0,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   15,   47,
       47,   42,    0,    0,    0,    0,    0,    0,    0,    0,
       14,   14,    7,   54,   14,    0,    0,   14,   14,    0,

       14,    6,    5,   50,    0,   49,   47,   14,   14,   14,
        0,   17,    0,    0,    0,   13,    0,    0,   17,   17,
       17,    0,    0,    0,   13,    0,    0,    4,   15,    0,
        0,   47,   47,   47,    0,   47,   33,   47,   29,   31,
       47,   43,   35,   47,   34,   41,   47,   37,   36,   32,
       47,    0,    0,    0,    0,    0,    0,    0,    0,   14,
       14,   14,   15,   14,   14,   55,   55,   14,   47,   12,
       10,   14,    0,   17,    0,    0,    0,   17,   17,   17,
        0,    0,    0,    1,   47,   47,   47,   47,   38,   47,
       46,   15,   39,    3,    0,    0,    0,    0,    0,    0,

        0,   14,   14,   51,    0,   55,   55,   55,   54,   47,
       44,   11,   16,   16,    0,    0,   17,   17,    0,    0,
        0,   47,   47,   47,   40,    0,    0,    0,    0,    0,
        0,   19,   14,   14,   56,   55,   55,   55,   55,    0,
        0,    0,    0,   53,    0,   45,    0,   17,    0,    0,
       17,   17,    0,   47,   47,   30,    0,    0,    0,    0,
       20,    0,   14,   14,   56,   55,   55,   55,   55,   55,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   53,
        0,    0,    0,   17,    0,    0,   17,   17,    0,   47,
       47,    0,    0,    0,   18,    0,   14,   14,   56,   55,

       55,   55,   55,   55,   55,    0,   52,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   16,   16,
        0,    0,   17,   17,    0,   47,   47,    0,   22,    0,
        0,   14,   56,   55,   55,   55,   55,   55,   55,   55,
        0,   52,    0,    0,    0,   52,    0,    0,    0,    0,
       17,   47,    0,    0,    0,    0,    0,    0,   56,    0,
        0,    0,   28,    0,    0,    0,    0,   21,   23,   56,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   24,    0,    0,    0,   25,    0,   26,    0,
        0,    0,    0,   27,    0

    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   40,   53,   54,   55,
       12,   28,   12,   29,   30,   12,   31,   32,   33,   34,

       35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
       45,   46,   47,   48,   49,   50,   51,   52,   40,   53,
       54,   55,   56,   57,   58,   59,    1,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,

       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60
    } ;

static yyconst flex_int32_t yy_meta[61] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        7,    4,    4,    4,    4,    8,    4,    9,    4,    9,
       10,   10,   10,   10,   10,   10,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    4,    4,    4,    4,    9
    } ;

static yyconst flex_int16_t yy_base[426] =
    {   0,
        0,    0,   42,   46,   40,   44,   60,   61, 1046, 1881,
       76,  101,  106,   64,   56, 1021,   86, 1010,  102, 1012,
     1010,  136, 1011,   95,  127,  986,   57,  107,  178, 1881,
      978,  970,  965,  108, 1881,  112,  180,  179, 1881, 1881,
     1881,  181, 1881,  216,  225,  935,   67, 1881,  263,   65,
      203,  942, 1881,  109,  298, 1881,  937,  189,  211,   87,
      234,  234,  936, 1881,  923,  929,    0,  254,  121,  921,
      122,  108,  226,  105,  221,  212,  173,  231,  255,  285,
       66,  920,  925,  901,  903,  894,  889,  896,  899,  898,
      249,  337, 1881, 1881,  278,  289,  907,  331,  300,  353,

      333, 1881, 1881,  357,  900,  343,  281,  332,  353,  366,
      378,  394,  871,  309,  233,  242,  429,  464,  888,  499,
      887,  385,  379,  280,  335,  534,  569, 1881,   71,  898,
      184,  877,  604,  875,  420,  308,  874,  316,  873,  872,
      229,  852,  851,  328,  850,  830,  369,  829,  828,  825,
      368,  834,  813,  819,  792,  789,  800,  771,  776,  455,
      410,  639,  791,  456,  430,  289,  783,  431,  365,  465,
      466,  494,  492,  525,  763,  415,  560,  595,  779,  674,
      493,  630,  790, 1881,  665,  764,  709,  411,  763,  408,
      759,  419,  758, 1881,  734,  728,  724,  727,  732,  735,

      734,  700,  716, 1881,  725,  331,  729,  727,  760,  486,
      701,  535,  746,  762,  680,  768,  784,  790,  806,  711,
      455,  812,  828,  536,  698,  682,  673,  702,  671,  687,
      667, 1881,  834,  850,  856,  455,  668,  667,  665,  891,
      905,  570,  571, 1881,  932,  662,  891,  923,  639,  940,
      948,  956,  964,  972,  980,  659,  643,  647,  645,  603,
     1881,  606,  988,  996, 1004,  456,  592,  591,  589,  588,
      539,  605,  644, 1039,  606, 1074, 1053, 1086, 1113, 1127,
     1154, 1189, 1113, 1145,  581, 1180, 1197, 1205, 1213, 1221,
     1229,  593,  533,  549, 1881,  546, 1237, 1245, 1253,  489,

      550,  549,  527,  526,  525,  652, 1881,  782,  660, 1288,
     1315, 1350,  689,  656, 1296, 1385, 1420, 1294, 1881, 1341,
      506, 1376,  583, 1411, 1428,  826, 1436, 1120, 1881,  486,
      485, 1444, 1452,  499, 1881, 1881, 1881, 1881, 1881, 1881,
     1329,  675,  696, 1460, 1495,  710,  726, 1481, 1497,  466,
      618,  870,  477,  476,  459,  478,  448,  443, 1503, 1519,
     1525, 1541, 1881,  416,  414,  363,  358, 1881, 1881, 1881,
     1547, 1563, 1569,  353,  315,  270,  253, 1585, 1591, 1607,
      233,  250, 1881,  223, 1613, 1629, 1881,  158, 1881,  152,
      109,   84,   22, 1881, 1881, 1664, 1669, 1678, 1683, 1690,

     1696, 1705, 1712, 1717, 1726, 1736, 1738, 1745, 1750, 1757,
     1764, 1774, 1781, 1786, 1796, 1801, 1810, 1815, 1824, 1833,
     1842, 1847, 1856, 1865, 1870
    } ;

static yyconst flex_int16_t yy_def[426] =
    {   0,
      395,    1,    1,    1,    1,    1,    1,    1,  395,  395,
      395,  395,  395,  396,  397,  395,  398,  395,  399,  395,
      395,  395,  395,  395,  400,  395,  401,  401,  401,  395,
      395,  395,  395,   22,  395,  401,  401,  401,  395,  395,
      395,  397,  395,  395,  395,  395,  396,  395,  402,  397,
      403,  404,  395,  398,  405,  395,  395,  395,  400,  401,
      401,   22,  406,  395,  407,  395,   22,  408,  409,  409,
      409,  409,  409,  409,  409,  409,  409,  409,  409,  409,
      409,  409,  395,  395,  395,  395,  395,  395,  395,  395,
      401,  401,  395,  395,  401,  410,  395,  401,  401,  395,

      401,  395,  395,   22,  395,   22,  409,  401,  401,  401,
      395,  404,  395,  396,  396,  396,  396,  402,  404,  112,
      404,  411,  398,  398,  398,  398,  405,  395,  395,  406,
      412,  409,  409,  409,  413,  409,  409,  409,  409,  409,
      409,  409,  409,  409,  409,  409,  409,  409,  409,  409,
      409,  395,  395,  395,  395,  395,  395,  395,  395,   92,
      401,   92,  395,  401,  401,  414,  395,  401,  409,  401,
      401,  401,  395,  112,  395,  396,  117,  120,  404,  120,
      398,  126,  415,  395,  133,  409,  133,  409,  409,  409,
      409,  409,  409,  395,  395,  395,  395,  395,  395,  395,

      395,   92,  162,  395,  395,  416,  395,  395,  417,  409,
      409,  401,  395,  112,  395,  117,  120,  180,  126,  415,
      412,  133,  187,  409,  409,  395,  395,  395,  395,  395,
      395,  395,   92,  162,  395,  418,  395,  395,  395,  417,
      417,  419,  420,  395,  421,  409,  395,  112,  395,  117,
      120,  180,  126,  133,  187,  409,  395,  395,  395,  395,
      395,  395,   92,  162,  395,  422,  395,  395,  395,  395,
      395,  419,  395,  423,  420,  424,  417,  417,  417,  417,
      417,  421,  395,  112,  395,  117,  120,  180,  126,  133,
      187,  395,  395,  395,  395,  395,   92,  162,  395,  425,

      395,  395,  395,  395,  395,  395,  395,  419,  419,  419,
      419,  423,  420,  420,  420,  420,  424,  281,  395,  112,
      395,  117,  320,  180,  126,  409,  187,  395,  395,  395,
      395,  162,  395,  395,  395,  395,  395,  395,  395,  395,
      419,  419,  419,  311,  420,  420,  420,  316,  281,  395,
      320,  409,  395,  395,  395,  395,  395,  395,  395,  311,
      316,  281,  395,  395,  395,  395,  395,  395,  395,  395,
      311,  316,  281,  395,  395,  395,  395,  311,  316,  281,
      395,  395,  395,  395,  311,  316,  395,  395,  395,  395,
      395,  395,  395,  395,    0,  395,  395,  395,  395,  395,

      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395
    } ;

static yyconst flex_int16_t yy_nxt[1942] =
    {   0,
       10,   11,   12,   11,   11,   11,   13,   14,   15,   16,
       10,   10,   17,   10,   10,   18,   10,   19,   20,   21,
       22,   10,   23,   10,   10,   10,   24,   25,   26,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   28,   27,   27,   27,   27,   27,   27,
       29,   27,   27,   27,   27,   30,   31,   10,   32,   27,
       33,   40,   34,   35,   33,   40,   34,   35,   42,   42,
       94,   48,   36,   50,   48,  394,   36,   44,   44,   44,
       44,   44,  395,   51,   96,   37,   38,   97,   97,   37,
       38,   49,   51,  135,   49,   41,  151,   39,   48,   41,

       94,   39,   44,   44,   44,   44,   44,   45,   45,   45,
       45,   45,   84,   55,   96,   10,   10,   43,   43,   57,
       94,   48,   58,   97,   98,   94,  105,   85,  106,   59,
       86,  393,  135,   87,   96,  135,   55,   88,   89,   96,
       90,  107,  138,  392,   46,   61,   64,   92,  135,  135,
      136,   99,  141,   65,   66,  108,   67,   92,   92,   92,
       92,   92,   92,   68,  137,   69,   70,   70,   71,   72,
       73,   70,   74,   75,   76,   70,   77,   70,   78,   79,
       70,   80,   70,   81,   82,   70,   70,   70,   70,   70,
       70,   94,   94,   94,  100,   70,   97,   98,   50,  131,

      135,  111,  391,  184,  390,   96,   96,   96,   51,   58,
      144,  112,  112,  112,  112,  112,  112,   44,   44,   44,
       44,   44,  110,  120,  109,  101,   45,   45,   45,   45,
       45,   92,  129,  120,  120,  120,  120,  120,  120,  135,
       48,   92,   92,   92,   92,   92,   92,   94,  135,   48,
       97,   98,  395,  135,   62,  143,  135,  389,  135,  190,
       49,   96,   94,   46,   47,   47,   47,  114,  139,   49,
      116,   97,  147,  145,  133,  142,   96,   70,  140,  146,
      388,  387,  135,  117,  133,  133,  133,  133,  133,  133,
      118,   94,   48,  117,  117,  117,  117,  117,  117,   54,

       54,   54,  123,  384,  383,   96,  205,   55,  135,  162,
      125,   47,  135,   94,  207,  138,   48,  148,  126,  162,
      162,  162,  162,  162,  162,  127,  169,   96,  126,  126,
      126,  126,  126,  126,  149,  135,   49,  150,   91,   91,
       91,   91,   91,  135,   94,   94,   94,   48,  205,  165,
       94,  164,  189,  382,  188,  135,  237,  160,   96,   96,
       96,  105,   55,  106,   96,  170,   94,  160,  160,  160,
      160,  160,  160,  166,  168,  395,  107,  104,  167,   94,
       96,   54,  191,  166,  166,  166,  166,  166,  166,  192,
      107,   48,  135,   96,  381,  135,  135,  210,  173,  377,

       70,  193,  171,  211,  376,  180,   55,  172,  173,  173,
      173,  173,  173,  173,  174,  180,  180,  180,  180,  180,
      180,  122,   48,   94,  174,  174,  174,  174,  174,  174,
      115,  176,  176,  176,  115,  135,   48,   96,  135,  192,
      187,  225,   49,  204,  209,  224,  135,  375,  374,  177,
      187,  187,  187,  187,  187,  187,   49,   96,   96,  177,
      177,  177,  177,  177,  177,   47,   47,   47,  114,   94,
      221,  116,  205,  205,  184,  202,  164,  369,   94,  204,
      267,  301,  368,   96,  117,  202,  202,  202,  202,  202,
      202,  118,   96,   96,  117,  117,  117,  117,  117,  117,

      119,  119,  119,  119,  119,   48,  205,   94,  367,  366,
      365,  364,  213,  135,  335,  363,  205,  358,  357,  178,
       55,   96,  213,  213,  213,  213,  213,  213,  246,  178,
      178,  178,  178,  178,  178,  124,  181,  181,  181,  124,
      271,  271,  271,  271,  271,  214,   48,  212,   94,  350,
      340,  339,  338,  244,  182,  214,  214,  214,  214,  214,
      214,   55,   96,  135,  182,  182,  182,  182,  182,  182,
       54,   54,   54,  123,  337,  336,  331,  273,  256,  330,
      216,  125,  329,  273,  119,  119,  119,  119,  119,  126,
      216,  216,  216,  216,  216,  216,  127,  274,  276,  126,

      126,  126,  126,  126,  126,  132,  132,  132,  132,  132,
      328,  321,  273,  305,  304,  217,  303,  302,  273,  179,
      179,  179,  179,  179,  185,  217,  217,  217,  217,  217,
      217,  135,  274,  276,  185,  185,  185,  185,  185,  185,
      161,  161,  161,  161,  161,  306,  306,  306,  306,  306,
      219,  296,  295,  306,  306,  306,  306,  306,  307,  203,
      219,  219,  219,  219,  219,  219,  307,  273,  273,  203,
      203,  203,  203,  203,  203,  179,  179,  179,  179,  179,
      294,  293,  273,  276,  292,  222,  135,  274,  285,  135,
      270,  275,  269,  268,  218,  222,  222,  222,  222,  222,

      222,  273,  274,  273,  218,  218,  218,  218,  218,  218,
      186,  186,  186,  186,  186,  262,  276,  261,  260,  259,
      233,  258,  273,  274,  257,  135,  221,  249,  135,  223,
      233,  233,  233,  233,  233,  233,  234,  276,  273,  223,
      223,  223,  223,  223,  223,  235,  234,  234,  234,  234,
      234,  234,  239,  276,  238,  235,  235,  235,  235,  235,
      235,  240,  240,  240,  240,  240,  247,  242,  232,  231,
      230,  229,  243,  228,  244,  227,  247,  247,  247,  247,
      247,  247,  248,  226,  272,  135,  135,  245,  250,  273,
      135,  135,  248,  248,  248,  248,  248,  248,  250,  250,

      250,  250,  250,  250,  251,  221,  122,  215,  208,  274,
      252,  163,  201,  200,  251,  251,  251,  251,  251,  251,
      252,  252,  252,  252,  252,  252,  253,  132,  132,  132,
      132,  132,  254,  199,  198,  197,  253,  253,  253,  253,
      253,  253,  254,  254,  254,  254,  254,  254,  255,  196,
      195,  194,  135,  135,  263,  135,  135,  135,  255,  255,
      255,  255,  255,  255,  263,  263,  263,  263,  263,  263,
      264,  186,  186,  186,  186,  186,  265,  135,  135,  135,
      264,  264,  264,  264,  264,  264,  265,  265,  265,  265,
      265,  265,  240,  240,  240,  240,  240,  135,  242,  135,

      135,  135,  135,  243,  135,  244,  271,  271,  271,  271,
      271,  283,  395,  131,  122,  122,  175,  395,  245,  244,
      104,  283,  283,  283,  283,  283,  283,  163,  159,  158,
      157,  156,  245,  271,  271,  271,  271,  277,  155,  279,
      154,  153,  152,  284,  279,  279,  280,  135,  135,   62,
       68,  131,  281,  284,  284,  284,  284,  284,  284,  282,
      286,  128,  281,  281,  281,  281,  281,  281,  287,  122,
      286,  286,  286,  286,  286,  286,  288,  113,  287,  287,
      287,  287,  287,  287,  289,  104,  288,  288,  288,  288,
      288,  288,  290,  103,  289,  289,  289,  289,  289,  289,

      291,  102,  290,  290,  290,  290,  290,  290,  297,   93,
      291,  291,  291,  291,  291,  291,  298,   83,  297,  297,
      297,  297,  297,  297,  299,   63,  298,  298,  298,  298,
      298,  298,   62,   56,  299,  299,  299,  299,  299,  299,
      272,  272,  272,  308,   53,  395,  310,  395,  395,  395,
      395,  395,  395,  395,  271,  271,  271,  271,  271,  311,
      395,  395,  395,  395,  395,  395,  312,  244,  395,  311,
      311,  311,  311,  311,  311,  275,  275,  275,  313,  395,
      245,  395,  395,  395,  395,  395,  315,  271,  271,  271,
      271,  271,  395,  395,  316,  395,  395,  395,  395,  395,

      244,  317,  395,  395,  316,  316,  316,  316,  316,  316,
      395,  395,  395,  245,  271,  271,  271,  271,  271,  395,
      395,  395,  395,  395,  395,  395,  395,  244,  271,  271,
      271,  271,  271,  319,  395,  395,  395,  395,  395,  395,
      245,  244,  395,  319,  319,  319,  319,  319,  319,  395,
      395,  395,  395,  353,  245,  277,  277,  277,  277,  277,
      395,  395,  354,  395,  395,  320,  395,  355,  244,  395,
      395,  356,  395,  395,  318,  320,  320,  320,  320,  320,
      320,  245,  395,  395,  318,  318,  318,  318,  318,  318,
      271,  271,  271,  271,  277,  395,  279,  395,  395,  395,

      322,  279,  279,  280,  395,  395,  395,  395,  395,  281,
      322,  322,  322,  322,  322,  322,  282,  323,  395,  281,
      281,  281,  281,  281,  281,  324,  395,  323,  323,  323,
      323,  323,  323,  325,  395,  324,  324,  324,  324,  324,
      324,  326,  395,  325,  325,  325,  325,  325,  325,  327,
      395,  326,  326,  326,  326,  326,  326,   95,  395,  327,
      327,  327,  327,  327,  327,  332,  395,   95,   95,   95,
       95,   95,   95,  333,  395,  332,  332,  332,  332,  332,
      332,  395,  395,  333,  333,  333,  333,  333,  333,  341,
      306,  306,  306,  341,  395,  273,  395,  345,  306,  306,

      306,  345,  342,  395,  395,  395,  395,  395,  273,  395,
      346,  395,  395,  395,  349,  274,  309,  343,  343,  343,
      309,  395,  273,  276,  349,  349,  349,  349,  349,  349,
      341,  306,  306,  306,  341,  344,  273,  395,  395,  395,
      395,  395,  274,  342,  395,  344,  344,  344,  344,  344,
      344,  272,  272,  272,  308,  395,  274,  310,  395,  395,
      395,  121,  395,  395,  395,  395,  395,  395,  395,  395,
      311,  121,  121,  121,  121,  121,  121,  312,  395,  395,
      311,  311,  311,  311,  311,  311,  314,  347,  347,  347,
      314,  395,  395,  395,  395,  395,   47,  273,  395,  395,

      395,  395,  395,  395,  395,  348,   47,   47,   47,   47,
       47,   47,  276,  395,  395,  348,  348,  348,  348,  348,
      348,  275,  275,  275,  313,  395,  395,  395,  395,  395,
      395,  351,  315,  395,  395,  395,  395,  395,  395,  395,
      316,  351,  351,  351,  351,  351,  351,  317,   54,  395,
      316,  316,  316,  316,  316,  316,  352,  395,   54,   54,
       54,   54,   54,   54,   95,  395,  352,  352,  352,  352,
      352,  352,  359,  395,   95,   95,   95,   95,   95,   95,
      360,  395,  359,  359,  359,  359,  359,  359,  395,  395,
      360,  360,  360,  360,  360,  360,  345,  306,  306,  306,

      345,  361,  395,  395,  395,  395,  395,  273,  395,  346,
      395,  361,  361,  361,  361,  361,  361,  362,  395,  395,
      395,  395,  276,  370,  395,  395,  395,  362,  362,  362,
      362,  362,  362,  370,  370,  370,  370,  370,  370,  371,
      395,  395,  395,  395,  395,  372,  395,  395,  395,  371,
      371,  371,  371,  371,  371,  372,  372,  372,  372,  372,
      372,  373,  395,  395,  395,  395,  395,  378,  395,  395,
      395,  373,  373,  373,  373,  373,  373,  378,  378,  378,
      378,  378,  378,  379,  395,  395,  395,  395,  395,  380,
      395,  395,  395,  379,  379,  379,  379,  379,  379,  380,

      380,  380,  380,  380,  380,  385,  395,  395,  395,  395,
      395,  386,  395,  395,  395,  385,  385,  385,  385,  385,
      385,  386,  386,  386,  386,  386,  386,  241,  395,  395,
      395,  395,  395,  272,  395,  395,  395,  241,  241,  241,
      241,  241,  241,  272,  272,  272,  272,  272,  272,  275,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  275,
      275,  275,  275,  275,  275,   47,  395,   47,   47,   47,
       47,   47,   47,   47,   52,  395,  395,   52,   52,   54,
      395,   54,   54,   54,   54,   54,   54,   54,   60,   60,
      395,   60,   60,   91,   91,   91,   91,   91,   91,   91,

       95,   95,   95,  395,   95,   95,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  119,  119,  119,  119,  119,
      119,  119,  121,  121,  395,  121,  121,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  130,  130,  130,  130,
      130,  130,  130,  130,  130,  130,   70,   70,  132,  132,
      132,  132,  132,  132,  132,  134,  134,  395,  134,  134,
      161,  161,  161,  161,  161,  161,  161,  179,  179,  179,
      179,  179,  179,  179,  183,  183,  183,  183,  183,  183,
      183,  183,  183,  183,  186,  186,  186,  186,  186,  186,
      186,  206,  206,  206,  395,  206,  220,  220,  220,  220,

      220,  220,  220,  220,  220,  220,  236,  236,  236,  395,
      236,  241,  241,  241,  395,  241,  241,  241,  241,  241,
      266,  266,  266,  395,  266,  272,  395,  272,  272,  272,
      272,  272,  272,  272,  275,  395,  275,  275,  275,  275,
      275,  275,  275,  278,  278,  278,  278,  278,  278,  278,
      278,  278,  300,  300,  300,  395,  300,  309,  309,  309,
      309,  309,  309,  309,  309,  309,  314,  314,  314,  314,
      314,  314,  314,  314,  314,  334,  334,  334,  395,  334,
        9,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,

      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395
    } ;

static yyconst flex_int16_t yy_chk[1942] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        3,    5,    3,    3,    4,    6,    4,    4,    7,    8,
       27,   14,    3,   15,   47,  393,    4,   11,   11,   11,
       11,   11,   50,   15,   27,    3,    3,  129,  129,    4,
        4,   14,   50,   81,   47,    5,   81,    3,   17,    6,

       60,    4,   12,   12,   12,   12,   12,   13,   13,   13,
       13,   13,   24,   17,   60,    7,    8,    7,    8,   19,
       28,   54,   19,   28,   28,   36,   34,   24,   34,   19,
       24,  392,   74,   24,   28,   72,   54,   24,   24,   36,
       24,   34,   72,  391,   13,   19,   22,   25,   69,   71,
       69,   28,   74,   22,   22,   36,   22,   25,   25,   25,
       25,   25,   25,   22,   71,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   29,   38,   37,   29,   22,   37,   37,   42,  131,

       77,   42,  390,  131,  388,   29,   38,   37,   42,   58,
       77,   42,   42,   42,   42,   42,   42,   44,   44,   44,
       44,   44,   38,   51,   37,   29,   45,   45,   45,   45,
       45,   59,   58,   51,   51,   51,   51,   51,   51,   76,
      115,   59,   59,   59,   59,   59,   59,   61,   75,  116,
       61,   61,   62,   73,   62,   76,  141,  384,   78,  141,
      115,   61,   91,   45,   49,   49,   49,   49,   73,  116,
       49,   79,   79,   78,   68,   75,   91,   62,   73,   78,
      382,  381,   79,   49,   68,   68,   68,   68,   68,   68,
       49,   95,  124,   49,   49,   49,   49,   49,   49,   55,

       55,   55,   55,  377,  376,   95,  166,  124,  107,   96,
       55,  114,   80,   99,  166,  107,  114,   80,   55,   96,
       96,   96,   96,   96,   96,   55,  107,   99,   55,   55,
       55,   55,   55,   55,   80,  136,  114,   80,   92,   92,
       92,   92,   92,  138,   98,  108,  101,  125,  206,   99,
       92,   98,  138,  375,  136,  144,  206,   92,   98,  108,
      101,  106,  125,  106,   92,  108,  109,   92,   92,   92,
       92,   92,   92,  100,  101,  104,  106,  104,  100,  110,
      109,  123,  144,  100,  100,  100,  100,  100,  100,  147,
      104,  123,  169,  110,  374,  151,  147,  169,  111,  367,

      104,  151,  109,  169,  366,  122,  123,  110,  111,  111,
      111,  111,  111,  111,  112,  122,  122,  122,  122,  122,
      122,  112,  176,  161,  112,  112,  112,  112,  112,  112,
      117,  117,  117,  117,  117,  190,  117,  161,  188,  192,
      135,  190,  176,  165,  168,  188,  192,  365,  364,  117,
      135,  135,  135,  135,  135,  135,  117,  165,  168,  117,
      117,  117,  117,  117,  117,  118,  118,  118,  118,  164,
      221,  118,  236,  266,  221,  160,  164,  358,  170,  171,
      236,  266,  357,  164,  118,  160,  160,  160,  160,  160,
      160,  118,  170,  171,  118,  118,  118,  118,  118,  118,

      120,  120,  120,  120,  120,  181,  300,  172,  356,  355,
      354,  353,  173,  210,  300,  350,  334,  331,  330,  120,
      181,  172,  173,  173,  173,  173,  173,  173,  210,  120,
      120,  120,  120,  120,  120,  126,  126,  126,  126,  126,
      271,  271,  271,  271,  271,  174,  126,  172,  212,  321,
      305,  304,  303,  271,  126,  174,  174,  174,  174,  174,
      174,  126,  212,  224,  126,  126,  126,  126,  126,  126,
      127,  127,  127,  127,  302,  301,  296,  242,  224,  294,
      177,  127,  293,  243,  323,  323,  323,  323,  323,  127,
      177,  177,  177,  177,  177,  177,  127,  242,  243,  127,

      127,  127,  127,  127,  127,  133,  133,  133,  133,  133,
      292,  285,  272,  270,  269,  178,  268,  267,  275,  351,
      351,  351,  351,  351,  133,  178,  178,  178,  178,  178,
      178,  133,  272,  275,  133,  133,  133,  133,  133,  133,
      162,  162,  162,  162,  162,  273,  273,  273,  273,  273,
      182,  262,  260,  306,  306,  306,  306,  306,  273,  162,
      182,  182,  182,  182,  182,  182,  306,  309,  314,  162,
      162,  162,  162,  162,  162,  180,  180,  180,  180,  180,
      259,  258,  342,  314,  257,  185,  256,  309,  249,  246,
      239,  313,  238,  237,  180,  185,  185,  185,  185,  185,

      185,  313,  342,  343,  180,  180,  180,  180,  180,  180,
      187,  187,  187,  187,  187,  231,  313,  230,  229,  228,
      202,  227,  346,  343,  226,  225,  220,  215,  211,  187,
      202,  202,  202,  202,  202,  202,  203,  346,  347,  187,
      187,  187,  187,  187,  187,  205,  203,  203,  203,  203,
      203,  203,  208,  347,  207,  205,  205,  205,  205,  205,
      205,  209,  209,  209,  209,  209,  213,  209,  201,  200,
      199,  198,  209,  197,  209,  196,  213,  213,  213,  213,
      213,  213,  214,  195,  308,  193,  191,  209,  216,  308,
      189,  186,  214,  214,  214,  214,  214,  214,  216,  216,

      216,  216,  216,  216,  217,  183,  179,  175,  167,  308,
      218,  163,  159,  158,  217,  217,  217,  217,  217,  217,
      218,  218,  218,  218,  218,  218,  219,  326,  326,  326,
      326,  326,  222,  157,  156,  155,  219,  219,  219,  219,
      219,  219,  222,  222,  222,  222,  222,  222,  223,  154,
      153,  152,  150,  326,  233,  149,  148,  146,  223,  223,
      223,  223,  223,  223,  233,  233,  233,  233,  233,  233,
      234,  352,  352,  352,  352,  352,  235,  145,  143,  142,
      234,  234,  234,  234,  234,  234,  235,  235,  235,  235,
      235,  235,  240,  240,  240,  240,  240,  352,  240,  140,

      139,  137,  134,  240,  132,  240,  241,  241,  241,  241,
      241,  247,  241,  130,  121,  119,  113,  241,  240,  241,
      105,  247,  247,  247,  247,  247,  247,   97,   90,   89,
       88,   87,  241,  245,  245,  245,  245,  245,   86,  245,
       85,   84,   83,  248,  245,  245,  245,   82,   70,   66,
       65,   63,  245,  248,  248,  248,  248,  248,  248,  245,
      250,   57,  245,  245,  245,  245,  245,  245,  251,   52,
      250,  250,  250,  250,  250,  250,  252,   46,  251,  251,
      251,  251,  251,  251,  253,   33,  252,  252,  252,  252,
      252,  252,  254,   32,  253,  253,  253,  253,  253,  253,

      255,   31,  254,  254,  254,  254,  254,  254,  263,   26,
      255,  255,  255,  255,  255,  255,  264,   23,  263,  263,
      263,  263,  263,  263,  265,   21,  264,  264,  264,  264,
      264,  264,   20,   18,  265,  265,  265,  265,  265,  265,
      274,  274,  274,  274,   16,    9,  274,    0,    0,    0,
        0,    0,    0,    0,  277,  277,  277,  277,  277,  274,
      277,    0,    0,    0,    0,  277,  274,  277,    0,  274,
      274,  274,  274,  274,  274,  276,  276,  276,  276,    0,
      277,    0,    0,    0,    0,    0,  276,  278,  278,  278,
      278,  278,    0,  278,  276,    0,    0,    0,  278,    0,

      278,  276,    0,    0,  276,  276,  276,  276,  276,  276,
        0,    0,    0,  278,  279,  279,  279,  279,  279,    0,
      279,    0,    0,    0,    0,  279,    0,  279,  280,  280,
      280,  280,  280,  283,  280,    0,    0,    0,    0,  280,
      279,  280,    0,  283,  283,  283,  283,  283,  283,    0,
        0,    0,    0,  328,  280,  281,  281,  281,  281,  281,
        0,  281,  328,    0,    0,  284,  281,  328,  281,    0,
        0,  328,    0,    0,  281,  284,  284,  284,  284,  284,
      284,  281,    0,    0,  281,  281,  281,  281,  281,  281,
      282,  282,  282,  282,  282,    0,  282,    0,    0,    0,

      286,  282,  282,  282,    0,    0,    0,    0,    0,  282,
      286,  286,  286,  286,  286,  286,  282,  287,    0,  282,
      282,  282,  282,  282,  282,  288,    0,  287,  287,  287,
      287,  287,  287,  289,    0,  288,  288,  288,  288,  288,
      288,  290,    0,  289,  289,  289,  289,  289,  289,  291,
        0,  290,  290,  290,  290,  290,  290,  297,    0,  291,
      291,  291,  291,  291,  291,  298,    0,  297,  297,  297,
      297,  297,  297,  299,    0,  298,  298,  298,  298,  298,
      298,    0,    0,  299,  299,  299,  299,  299,  299,  310,
      310,  310,  310,  310,    0,  310,    0,  315,  315,  315,

      315,  315,  310,    0,    0,    0,    0,    0,  315,    0,
      315,    0,    0,    0,  318,  310,  311,  311,  311,  311,
      311,    0,  311,  315,  318,  318,  318,  318,  318,  318,
      341,  341,  341,  341,  341,  311,  341,    0,    0,    0,
        0,    0,  311,  341,    0,  311,  311,  311,  311,  311,
      311,  312,  312,  312,  312,    0,  341,  312,    0,    0,
        0,  320,    0,    0,    0,    0,    0,    0,    0,    0,
      312,  320,  320,  320,  320,  320,  320,  312,    0,    0,
      312,  312,  312,  312,  312,  312,  316,  316,  316,  316,
      316,    0,    0,    0,    0,    0,  322,  316,    0,    0,

        0,    0,    0,    0,    0,  316,  322,  322,  322,  322,
      322,  322,  316,    0,    0,  316,  316,  316,  316,  316,
      316,  317,  317,  317,  317,    0,    0,    0,    0,    0,
        0,  324,  317,    0,    0,    0,    0,    0,    0,    0,
      317,  324,  324,  324,  324,  324,  324,  317,  325,    0,
      317,  317,  317,  317,  317,  317,  327,    0,  325,  325,
      325,  325,  325,  325,  332,    0,  327,  327,  327,  327,
      327,  327,  333,    0,  332,  332,  332,  332,  332,  332,
      344,    0,  333,  333,  333,  333,  333,  333,    0,    0,
      344,  344,  344,  344,  344,  344,  345,  345,  345,  345,

      345,  348,    0,    0,    0,    0,    0,  345,    0,  345,
        0,  348,  348,  348,  348,  348,  348,  349,    0,    0,
        0,    0,  345,  359,    0,    0,    0,  349,  349,  349,
      349,  349,  349,  359,  359,  359,  359,  359,  359,  360,
        0,    0,    0,    0,    0,  361,    0,    0,    0,  360,
      360,  360,  360,  360,  360,  361,  361,  361,  361,  361,
      361,  362,    0,    0,    0,    0,    0,  371,    0,    0,
        0,  362,  362,  362,  362,  362,  362,  371,  371,  371,
      371,  371,  371,  372,    0,    0,    0,    0,    0,  373,
        0,    0,    0,  372,  372,  372,  372,  372,  372,  373,

      373,  373,  373,  373,  373,  378,    0,    0,    0,    0,
        0,  379,    0,    0,    0,  378,  378,  378,  378,  378,
      378,  379,  379,  379,  379,  379,  379,  380,    0,    0,
        0,    0,    0,  385,    0,    0,    0,  380,  380,  380,
      380,  380,  380,  385,  385,  385,  385,  385,  385,  386,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  386,
      386,  386,  386,  386,  386,  396,    0,  396,  396,  396,
      396,  396,  396,  396,  397,    0,    0,  397,  397,  398,
        0,  398,  398,  398,  398,  398,  398,  398,  399,  399,
        0,  399,  399,  400,  400,  400,  400,  400,  400,  400,

      401,  401,  401,    0,  401,  401,  402,  402,  402,  402,
      402,  402,  402,  402,  402,  403,  403,  403,  403,  403,
      403,  403,  404,  404,    0,  404,  404,  405,  405,  405,
      405,  405,  405,  405,  405,  405,  406,  406,  406,  406,
      406,  406,  406,  406,  406,  406,  407,  407,  408,  408,
      408,  408,  408,  408,  408,  409,  409,    0,  409,  409,
      410,  410,  410,  410,  410,  410,  410,  411,  411,  411,
      411,  411,  411,  411,  412,  412,  412,  412,  412,  412,
      412,  412,  412,  412,  413,  413,  413,  413,  413,  413,
      413,  414,  414,  414,    0,  414,  415,  415,  415,  415,

      415,  415,  415,  415,  415,  415,  416,  416,  416,    0,
      416,  417,  417,  417,    0,  417,  417,  417,  417,  417,
      418,  418,  418,    0,  418,  419,    0,  419,  419,  419,
      419,  419,  419,  419,  420,    0,  420,  420,  420,  420,
      420,  420,  420,  421,  421,  421,  421,  421,  421,  421,
      421,  421,  422,  422,  422,    0,  422,  423,  423,  423,
      423,  423,  423,  423,  423,  423,  424,  424,  424,  424,
      424,  424,  424,  424,  424,  425,  425,  425,    0,  425,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,

      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  395,  395,
      395
    } ;

YY_DECL
{
	register yy_state_type yy_current_state;
	register unsigned short *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 396 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 1881 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 30 "tokenizer.flex"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 32 "tokenizer.flex"
{yyTok = S; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 34 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 35 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 36 "tokenizer.flex"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 37 "tokenizer.flex"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 38 "tokenizer.flex"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 39 "tokenizer.flex"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 40 "tokenizer.flex"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 41 "tokenizer.flex"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 42 "tokenizer.flex"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 43 "tokenizer.flex"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 45 "tokenizer.flex"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "tokenizer.flex"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 47 "tokenizer.flex"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 50 "tokenizer.flex"
{yyTok = HEXCOLOR; return yyTok;}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 51 "tokenizer.flex"
{yyTok = HASH; return yyTok;}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 53 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "tokenizer.flex"
{BEGIN(at_rule); yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "tokenizer.flex"
{BEGIN(at_rule); yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "tokenizer.flex"
{BEGIN(at_rule); yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "tokenizer.flex"
{BEGIN(at_rule); yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "tokenizer.flex"
{BEGIN(at_rule); yyTok = KHTML_RULE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "tokenizer.flex"
{yyTok = KHTML_DECLS_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "tokenizer.flex"
{yyTok = KHTML_VALUE_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = KHTML_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 64 "tokenizer.flex"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 66 "tokenizer.flex"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 67 "tokenizer.flex"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 68 "tokenizer.flex"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 69 "tokenizer.flex"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 70 "tokenizer.flex"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 71 "tokenizer.flex"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 72 "tokenizer.flex"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 73 "tokenizer.flex"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 74 "tokenizer.flex"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 75 "tokenizer.flex"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 76 "tokenizer.flex"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 77 "tokenizer.flex"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 78 "tokenizer.flex"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 79 "tokenizer.flex"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 80 "tokenizer.flex"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 81 "tokenizer.flex"
{yyTok = DPI; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 82 "tokenizer.flex"
{yyTok = DPCM; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 83 "tokenizer.flex"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 47:
/* rule 47 can match eol */
YY_RULE_SETUP
#line 84 "tokenizer.flex"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 85 "tokenizer.flex"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 86 "tokenizer.flex"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 87 "tokenizer.flex"
{yyTok = FLOAT; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 90 "tokenizer.flex"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 52:
/* rule 52 can match eol */
YY_RULE_SETUP
#line 91 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 92 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 93 "tokenizer.flex"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 95 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 96 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 98 "tokenizer.flex"
{BEGIN(block); yyTok = *yytext; return yyTok;}
	YY_BREAK
case 58:
#line 100 "tokenizer.flex"
case 59:
#line 101 "tokenizer.flex"
case 60:
#line 102 "tokenizer.flex"
case 61:
#line 103 "tokenizer.flex"
case 62:
YY_RULE_SETUP
#line 103 "tokenizer.flex"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 104 "tokenizer.flex"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 106 "tokenizer.flex"
ECHO;
	YY_BREAK
#line 1593 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(at_rule):
case YY_STATE_EOF(block):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
