
  

#ifndef KJSEMBED_QCanvasPixmap_H
#define KJSEMBED_QCanvasPixmap_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class QCanvasPixmap;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for QCanvasPixmap methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasPixmapImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QCanvasPixmap_1,
       Constructor_QCanvasPixmap_2,
       Constructor_QCanvasPixmap_3,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_offsetX_5,
       Method_offsetY_6,
       Method_setOffset_7,
       Method_Last = -1
   };

   QCanvasPixmapImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasPixmapImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static QCanvasPixmap *toQCanvasPixmap( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QCanvasPixmap_1( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasPixmap_2( KJS::ExecState *exec, const KJS::List &args );
   KJS::Object QCanvasPixmap_3( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value offsetX_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value offsetY_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setOffset_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   QCanvasPixmap *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasPixmap_H

// Local Variables:
// c-basic-offset: 4
// End:


