/* Intel 80386 opcode table
   Copyright 2007
   Free Software Foundation, Inc.

   This file is part of GAS, the GNU Assembler, and GDB, the GNU Debugger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

#include "sysdep.h"
#include "libiberty.h"
#include "i386-opc.h"

const template i386_optab[] =
{

#define X None
#define NoSuf (No_bSuf|No_wSuf|No_lSuf|No_sSuf|No_xSuf|No_qSuf)
#define b_Suf (No_wSuf|No_lSuf|No_sSuf|No_xSuf|No_qSuf)
#define w_Suf (No_bSuf|No_lSuf|No_sSuf|No_xSuf|No_qSuf)
#define l_Suf (No_bSuf|No_wSuf|No_sSuf|No_xSuf|No_qSuf)
#define q_Suf (No_bSuf|No_wSuf|No_sSuf|No_lSuf|No_xSuf)
#define x_Suf (No_bSuf|No_wSuf|No_sSuf|No_lSuf|No_qSuf)
#define bw_Suf (No_lSuf|No_sSuf|No_xSuf|No_qSuf)
#define bl_Suf (No_wSuf|No_sSuf|No_xSuf|No_qSuf)
#define wl_Suf (No_bSuf|No_sSuf|No_xSuf|No_qSuf)
#define wlq_Suf (No_bSuf|No_sSuf|No_xSuf)
#define lq_Suf (No_bSuf|No_wSuf|No_sSuf|No_xSuf)
#define wq_Suf (No_bSuf|No_lSuf|No_sSuf|No_xSuf)
#define sl_Suf (No_bSuf|No_wSuf|No_xSuf|No_qSuf)
#define bwl_Suf (No_sSuf|No_xSuf|No_qSuf)
#define bwlq_Suf (No_sSuf|No_xSuf)
#define FP (NoSuf)
#define l_FP (l_Suf)
#define q_FP (q_Suf|NoRex64)
#define x_FP (x_Suf|FloatMF)
#define sl_FP (sl_Suf|FloatMF)

/* Move instructions.  */
/* We put the 64bit displacement first and we only mark constants
   larger than 32bit as Disp64.  */
{ "mov",   2,	0xa0, X, Cpu64,  bwlq_Suf|D|W,			{ Disp64, Acc, 0 } },
{ "mov",   2,	0xa0, X, CpuNo64,bwl_Suf|D|W,			{ Disp16|Disp32, Acc, 0 } },
{ "mov",   2,	0x88, X, 0,	 bwlq_Suf|D|W|Modrm,		{ Reg, Reg|AnyMem, 0} },
/* In the 64bit mode the short form mov immediate is redefined to have
   64bit value.  */
{ "mov",   2,	0xb0, X, 0,	 bwl_Suf|W|ShortForm,		{ EncImm, Reg8|Reg16|Reg32, 0 } },
{ "mov",   2,	0xc6, 0, 0,	 bwlq_Suf|W|Modrm,		{ EncImm, Reg|AnyMem, 0 } },
{ "mov",   2,	0xb0, X, Cpu64,	 q_Suf|W|ShortForm,		{ Imm64, Reg64, 0 } },
/* The segment register moves accept WordReg so that a segment register
   can be copied to a 32 bit register, and vice versa, without using a
   size prefix.  When moving to a 32 bit register, the upper 16 bits
   are set to an implementation defined value (on the Pentium Pro,
   the implementation defined value is zero).  */
{ "mov",   2,	0x8c, X, 0,	 wl_Suf|Modrm,			{ SReg2, WordReg|RegMem, 0 } },
{ "mov",   2,	0x8c, X, 0,	 w_Suf|Modrm|IgnoreSize,	{ SReg2, WordMem, 0 } },
{ "mov",   2,	0x8c, X, Cpu386, wl_Suf|Modrm,			{ SReg3, WordReg|RegMem, 0 } },
{ "mov",   2,	0x8c, X, Cpu386, w_Suf|Modrm|IgnoreSize,	{ SReg3, WordMem, 0 } },
{ "mov",   2,	0x8e, X, 0,	 wl_Suf|Modrm|IgnoreSize,	{ WordReg, SReg2, 0 } },
{ "mov",   2,	0x8e, X, 0,	 w_Suf|Modrm|IgnoreSize,	{ WordMem, SReg2, 0 } },
{ "mov",   2,	0x8e, X, Cpu386, wl_Suf|Modrm|IgnoreSize,	{ WordReg, SReg3, 0 } },
{ "mov",   2,	0x8e, X, Cpu386, w_Suf|Modrm|IgnoreSize,	{ WordMem, SReg3, 0 } },
/* Move to/from control debug registers.  In the 16 or 32bit modes they are 32bit.  In the 64bit
   mode they are 64bit.*/
{ "mov",   2, 0x0f20, X, Cpu386|CpuNo64, l_Suf|D|Modrm|IgnoreSize,{ Control, Reg32|RegMem, 0} },
{ "mov",   2, 0x0f20, X, Cpu64,	 q_Suf|D|Modrm|IgnoreSize|NoRex64,{ Control, Reg64|RegMem, 0} },
{ "mov",   2, 0x0f21, X, Cpu386|CpuNo64, l_Suf|D|Modrm|IgnoreSize,{ Debug, Reg32|RegMem, 0} },
{ "mov",   2, 0x0f21, X, Cpu64,	 q_Suf|D|Modrm|IgnoreSize|NoRex64,{ Debug, Reg64|RegMem, 0} },
{ "mov",   2, 0x0f24, X, Cpu386|CpuNo64, l_Suf|D|Modrm|IgnoreSize,	{ Test, Reg32|RegMem, 0} },
{ "movabs",2,	0xa0, X, Cpu64, bwlq_Suf|D|W,			{ Disp64, Acc, 0 } },
{ "movabs",2,	0xb0, X, Cpu64,	q_Suf|W|ShortForm,		{ Imm64, Reg64, 0 } },

/* Move with sign extend.  */
/* "movsbl" & "movsbw" must not be unified into "movsb" to avoid
   conflict with the "movs" string move instruction.  */
{"movsbl", 2, 0x0fbe, X, Cpu386, NoSuf|Modrm,			{ Reg8|ByteMem, Reg32, 0} },
{"movsbw", 2, 0x0fbe, X, Cpu386, NoSuf|Modrm,			{ Reg8|ByteMem, Reg16, 0} },
{"movswl", 2, 0x0fbf, X, Cpu386, NoSuf|Modrm,			{ Reg16|ShortMem,Reg32, 0} },
{"movsbq", 2, 0x0fbe, X, Cpu64,  NoSuf|Modrm|Rex64,		{ Reg8|ByteMem, Reg64, 0} },
{"movswq", 2, 0x0fbf, X, Cpu64,  NoSuf|Modrm|Rex64,		{ Reg16|ShortMem,Reg64, 0} },
{"movslq", 2,   0x63, X, Cpu64,  NoSuf|Modrm|Rex64,		{ Reg32|WordMem, Reg64, 0} },
/* Intel Syntax next 3 insns */
{"movsx",  2, 0x0fbe, X, Cpu386, b_Suf|Modrm,			{ Reg8|ByteMem, WordReg, 0} },
{"movsx",  2, 0x0fbf, X, Cpu386, w_Suf|Modrm,			{ Reg16|ShortMem, Reg32|Reg64, 0} },
{"movsx",  2,   0x63, X, Cpu64,  l_Suf|Modrm|Rex64,		{ Reg32|WordMem, Reg64, 0} },

/* Move with zero extend.  We can't remove "movzb" since existing
   assembly codes may use it.  */
{"movzb",  2, 0x0fb6, X, Cpu386, wl_Suf|Modrm,			{ Reg8|ByteMem, WordReg, 0} },
/* "movzbl" & "movzbw" should not be unified into "movzb" for
   consistency with the sign extending moves above.  */
{"movzbl", 2, 0x0fb6, X, Cpu386, NoSuf|Modrm,			{ Reg8|ByteMem, Reg32, 0} },
{"movzbw", 2, 0x0fb6, X, Cpu386, NoSuf|Modrm,			{ Reg8|ByteMem, Reg16, 0} },
{"movzwl", 2, 0x0fb7, X, Cpu386, NoSuf|Modrm,			{ Reg16|ShortMem, Reg32, 0} },
/* These instructions are not particulary useful, since the zero extend
   32->64 is implicit, but we can encode them.  */
{"movzbq", 2, 0x0fb6, X, Cpu64,  NoSuf|Modrm|Rex64,		{ Reg8|ByteMem,   Reg64, 0} },
{"movzwq", 2, 0x0fb7, X, Cpu64,  NoSuf|Modrm|Rex64,		{ Reg16|ShortMem, Reg64, 0} },
/* Intel Syntax next 2 insns (the 64-bit variants are not particulary useful,
   since the zero extend 32->64 is implicit, but we can encode them).  */
{"movzx",  2, 0x0fb6, X, Cpu386, b_Suf|Modrm,			{ Reg8|ByteMem, WordReg, 0} },
{"movzx",  2, 0x0fb7, X, Cpu386, w_Suf|Modrm,			{ Reg16|ShortMem, Reg32|Reg64, 0} },

/* Push instructions.  */
{"push",   1,	0x50, X, CpuNo64, wl_Suf|ShortForm|DefaultSize,	{ WordReg, 0, 0 } },
{"push",   1,	0xff, 6, CpuNo64, wl_Suf|Modrm|DefaultSize,	{ WordReg|WordMem, 0, 0 } },
{"push",   1,	0x6a, X, Cpu186|CpuNo64, wl_Suf|DefaultSize,	{ Imm8S, 0, 0} },
{"push",   1,	0x68, X, Cpu186|CpuNo64, wl_Suf|DefaultSize,	{ Imm16|Imm32, 0, 0} },
{"push",   1,	0x06, X, CpuNo64, wl_Suf|ShortForm|DefaultSize, { SReg2, 0, 0 } },
{"push",   1, 0x0fa0, X, Cpu386|CpuNo64, wl_Suf|ShortForm|DefaultSize, { SReg3, 0, 0 } },
/* In 64bit mode, the operand size is implicitly 64bit.  */
{"push",   1,	0x50, X, Cpu64,	wq_Suf|ShortForm|DefaultSize|NoRex64, { Reg16|Reg64, 0, 0 } },
{"push",   1,	0xff, 6, Cpu64,	wq_Suf|Modrm|DefaultSize|NoRex64, { Reg16|Reg64|WordMem, 0, 0 } },
{"push",   1,	0x6a, X, Cpu64,	wq_Suf|DefaultSize|NoRex64, { Imm8S, 0, 0} },
{"push",   1,	0x68, X, Cpu64,	wq_Suf|DefaultSize|NoRex64, { Imm32S|Imm16, 0, 0} },
{"push",   1, 0x0fa0, X, Cpu64,	wq_Suf|ShortForm|DefaultSize|NoRex64, { SReg3, 0, 0 } },

{"pusha",  0,	0x60, X, Cpu186|CpuNo64, wl_Suf|DefaultSize,	{ 0, 0, 0 } },

/* Pop instructions.  */
{"pop",	   1,	0x58, X, CpuNo64,	 wl_Suf|ShortForm|DefaultSize,	{ WordReg, 0, 0 } },
{"pop",	   1,	0x8f, 0, CpuNo64,	 wl_Suf|Modrm|DefaultSize,	{ WordReg|WordMem, 0, 0 } },
{"pop",	   1,	0x07, X, CpuNo64,	 wl_Suf|ShortForm|DefaultSize,	{ SReg2, 0, 0 } },
{"pop",	   1, 0x0fa1, X, Cpu386|CpuNo64, wl_Suf|ShortForm|DefaultSize,	{ SReg3, 0, 0 } },
/* In 64bit mode, the operand size is implicitly 64bit.  */
{"pop",	   1,	0x58, X, Cpu64,	 wq_Suf|ShortForm|DefaultSize|NoRex64,	{ Reg16|Reg64, 0, 0 } },
{"pop",	   1,	0x8f, 0, Cpu64,	 wq_Suf|Modrm|DefaultSize|NoRex64,	{ Reg16|Reg64|WordMem, 0, 0 } },
{"pop",	   1, 0x0fa1, X, Cpu64,  wq_Suf|ShortForm|DefaultSize|NoRex64,	{ SReg3, 0, 0 } },

{"popa",   0,	0x61, X, Cpu186|CpuNo64, wl_Suf|DefaultSize,		{ 0, 0, 0 } },

/* Exchange instructions.
   xchg commutes:  we allow both operand orders.

   In the 64bit code, xchg rax, rax is reused for new nop instruction.  */
{"xchg",   2,	0x90, X, 0,	wlq_Suf|ShortForm,	{ WordReg, Acc, 0 } },
{"xchg",   2,	0x90, X, 0,	wlq_Suf|ShortForm,	{ Acc, WordReg, 0 } },
{"xchg",   2,	0x86, X, 0,	bwlq_Suf|W|Modrm,	{ Reg, Reg|AnyMem, 0 } },
{"xchg",   2,	0x86, X, 0,	bwlq_Suf|W|Modrm,	{ Reg|AnyMem, Reg, 0 } },

/* In/out from ports.  */
/* XXX should reject %rax */
{"in",	   2,	0xe4, X, 0,	 bwl_Suf|W,		{ Imm8, Acc, 0 } },
{"in",	   2,	0xec, X, 0,	 bwl_Suf|W,		{ InOutPortReg, Acc, 0 } },
{"in",	   1,	0xe4, X, 0,	 bwl_Suf|W,		{ Imm8, 0, 0 } },
{"in",	   1,	0xec, X, 0,	 bwl_Suf|W,		{ InOutPortReg, 0, 0 } },
{"out",	   2,	0xe6, X, 0,	 bwl_Suf|W,		{ Acc, Imm8, 0 } },
{"out",	   2,	0xee, X, 0,	 bwl_Suf|W,		{ Acc, InOutPortReg, 0 } },
{"out",	   1,	0xe6, X, 0,	 bwl_Suf|W,		{ Imm8, 0, 0 } },
{"out",	   1,	0xee, X, 0,	 bwl_Suf|W,		{ InOutPortReg, 0, 0 } },

/* Load effective address.  */
{"lea",	   2, 0x8d,   X, 0,	 wlq_Suf|Modrm,		{ WordMem, WordReg, 0 } },

/* Load segment registers from memory.  */
{"lds",	   2,	0xc5, X, CpuNo64, wl_Suf|Modrm,	{ WordMem, WordReg, 0} },
{"les",	   2,	0xc4, X, CpuNo64, wl_Suf|Modrm,	{ WordMem, WordReg, 0} },
{"lfs",	   2, 0x0fb4, X, Cpu386, wl_Suf|Modrm,		{ WordMem, WordReg, 0} },
{"lgs",	   2, 0x0fb5, X, Cpu386, wl_Suf|Modrm,		{ WordMem, WordReg, 0} },
{"lss",	   2, 0x0fb2, X, Cpu386, wl_Suf|Modrm,		{ WordMem, WordReg, 0} },

/* Flags register instructions.  */
{"clc",	   0,	0xf8, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"cld",	   0,	0xfc, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"cli",	   0,	0xfa, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"clts",   0, 0x0f06, X, Cpu286, NoSuf,			{ 0, 0, 0} },
{"cmc",	   0,	0xf5, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"lahf",   0,	0x9f, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"sahf",   0,	0x9e, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"pushf",  0,	0x9c, X, CpuNo64,wl_Suf|DefaultSize,	{ 0, 0, 0} },
{"pushf",  0,	0x9c, X, Cpu64,	 wq_Suf|DefaultSize|NoRex64,{ 0, 0, 0} },
{"popf",   0,	0x9d, X, CpuNo64,wl_Suf|DefaultSize,	{ 0, 0, 0} },
{"popf",   0,	0x9d, X, Cpu64,	 wq_Suf|DefaultSize|NoRex64,{ 0, 0, 0} },
{"stc",	   0,	0xf9, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"std",	   0,	0xfd, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"sti",	   0,	0xfb, X, 0,	 NoSuf,			{ 0, 0, 0} },

/* Arithmetic.  */
{"add",	   2,	0x00, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"add",	   2,	0x83, 0, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"add",	   2,	0x04, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"add",	   2,	0x80, 0, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"inc",	   1,	0x40, X, CpuNo64,wl_Suf|ShortForm,	{ WordReg, 0, 0} },
{"inc",	   1,	0xfe, 0, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"sub",	   2,	0x28, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"sub",	   2,	0x83, 5, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"sub",	   2,	0x2c, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"sub",	   2,	0x80, 5, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"dec",	   1,	0x48, X, CpuNo64, wl_Suf|ShortForm,	{ WordReg, 0, 0} },
{"dec",	   1,	0xfe, 1, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"sbb",	   2,	0x18, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"sbb",	   2,	0x83, 3, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"sbb",	   2,	0x1c, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"sbb",	   2,	0x80, 3, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"cmp",	   2,	0x38, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"cmp",	   2,	0x83, 7, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"cmp",	   2,	0x3c, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"cmp",	   2,	0x80, 7, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"test",   2,	0x84, X, 0,	 bwlq_Suf|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"test",   2,	0x84, X, 0,	 bwlq_Suf|W|Modrm,	{ AnyMem, Reg, 0} },
{"test",   2,	0xa8, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"test",   2,	0xf6, 0, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"and",	   2,	0x20, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"and",	   2,	0x83, 4, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"and",	   2,	0x24, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"and",	   2,	0x80, 4, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"or",	   2,	0x08, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"or",	   2,	0x83, 1, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"or",	   2,	0x0c, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"or",	   2,	0x80, 1, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"xor",	   2,	0x30, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"xor",	   2,	0x83, 6, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"xor",	   2,	0x34, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"xor",	   2,	0x80, 6, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

/* clr with 1 operand is really xor with 2 operands.  */
{"clr",	   1,	0x30, X, 0,	 bwlq_Suf|W|Modrm|regKludge,	{ Reg, 0, 0 } },

{"adc",	   2,	0x10, X, 0,	 bwlq_Suf|D|W|Modrm,	{ Reg, Reg|AnyMem, 0} },
{"adc",	   2,	0x83, 2, 0,	 wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, 0} },
{"adc",	   2,	0x14, X, 0,	 bwlq_Suf|W,		{ EncImm, Acc, 0} },
{"adc",	   2,	0x80, 2, 0,	 bwlq_Suf|W|Modrm,	{ EncImm, Reg|AnyMem, 0} },

{"neg",	   1,	0xf6, 3, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },
{"not",	   1,	0xf6, 2, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"aaa",	   0,	0x37, X, CpuNo64,	 NoSuf,			{ 0, 0, 0} },
{"aas",	   0,	0x3f, X, CpuNo64,	NoSuf,			{ 0, 0, 0} },
{"daa",	   0,	0x27, X, CpuNo64,	NoSuf,			{ 0, 0, 0} },
{"das",	   0,	0x2f, X, CpuNo64,	NoSuf,			{ 0, 0, 0} },
{"aad",	   0, 0xd50a, X, CpuNo64,	NoSuf,			{ 0, 0, 0} },
{"aad",	   1,   0xd5, X, CpuNo64,	NoSuf,			{ Imm8, 0, 0} },
{"aam",	   0, 0xd40a, X, CpuNo64,	NoSuf,			{ 0, 0, 0} },
{"aam",	   1,   0xd4, X, CpuNo64,	NoSuf,			{ Imm8, 0, 0} },

/* Conversion insns.  */
/* Intel naming */
{"cbw",	   0,	0x98, X, 0,	 NoSuf|Size16,		{ 0, 0, 0} },
{"cdqe",   0,	0x98, X, Cpu64,	 NoSuf|Size64,		{ 0, 0, 0} },
{"cwde",   0,	0x98, X, 0,	 NoSuf|Size32,		{ 0, 0, 0} },
{"cwd",	   0,	0x99, X, 0,	 NoSuf|Size16,		{ 0, 0, 0} },
{"cdq",	   0,	0x99, X, 0,	 NoSuf|Size32,		{ 0, 0, 0} },
{"cqo",	   0,	0x99, X, Cpu64,	 NoSuf|Size64,		{ 0, 0, 0} },
/* AT&T naming */
{"cbtw",   0,	0x98, X, 0,	 NoSuf|Size16,		{ 0, 0, 0} },
{"cltq",   0,	0x98, X, Cpu64,	 NoSuf|Size64,		{ 0, 0, 0} },
{"cwtl",   0,	0x98, X, 0,	 NoSuf|Size32,		{ 0, 0, 0} },
{"cwtd",   0,	0x99, X, 0,	 NoSuf|Size16,		{ 0, 0, 0} },
{"cltd",   0,	0x99, X, 0,	 NoSuf|Size32,		{ 0, 0, 0} },
{"cqto",   0,	0x99, X, Cpu64,	 NoSuf|Size64,		{ 0, 0, 0} },

/* Warning! the mul/imul (opcode 0xf6) must only have 1 operand!  They are
   expanding 64-bit multiplies, and *cannot* be selected to accomplish
   'imul %ebx, %eax' (opcode 0x0faf must be used in this case)
   These multiplies can only be selected with single operand forms.  */
{"mul",	   1,	0xf6, 4, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },
{"imul",   1,	0xf6, 5, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },
{"imul",   2, 0x0faf, X, Cpu386, wlq_Suf|Modrm,		{ WordReg|WordMem, WordReg, 0} },
{"imul",   3,	0x6b, X, Cpu186, wlq_Suf|Modrm,		{ Imm8S, WordReg|WordMem, WordReg} },
{"imul",   3,	0x69, X, Cpu186, wlq_Suf|Modrm,		{ Imm16|Imm32S|Imm32, WordReg|WordMem, WordReg} },
/* imul with 2 operands mimics imul with 3 by putting the register in
   both i.rm.reg & i.rm.regmem fields.  regKludge enables this
   transformation.  */
{"imul",   2,	0x6b, X, Cpu186, wlq_Suf|Modrm|regKludge,{ Imm8S, WordReg, 0} },
{"imul",   2,	0x69, X, Cpu186, wlq_Suf|Modrm|regKludge,{ Imm16|Imm32S|Imm32, WordReg, 0} },

{"div",	   1,	0xf6, 6, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },
{"div",	   2,	0xf6, 6, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, Acc, 0} },
{"idiv",   1,	0xf6, 7, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },
{"idiv",   2,	0xf6, 7, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, Acc, 0} },

{"rol",	   2,	0xd0, 0, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"rol",	   2,	0xc0, 0, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"rol",	   2,	0xd2, 0, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"rol",	   1,	0xd0, 0, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"ror",	   2,	0xd0, 1, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"ror",	   2,	0xc0, 1, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"ror",	   2,	0xd2, 1, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"ror",	   1,	0xd0, 1, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"rcl",	   2,	0xd0, 2, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"rcl",	   2,	0xc0, 2, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"rcl",	   2,	0xd2, 2, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"rcl",	   1,	0xd0, 2, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"rcr",	   2,	0xd0, 3, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"rcr",	   2,	0xc0, 3, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"rcr",	   2,	0xd2, 3, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"rcr",	   1,	0xd0, 3, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"sal",	   2,	0xd0, 4, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"sal",	   2,	0xc0, 4, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"sal",	   2,	0xd2, 4, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"sal",	   1,	0xd0, 4, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"shl",	   2,	0xd0, 4, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"shl",	   2,	0xc0, 4, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"shl",	   2,	0xd2, 4, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"shl",	   1,	0xd0, 4, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"shr",	   2,	0xd0, 5, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"shr",	   2,	0xc0, 5, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"shr",	   2,	0xd2, 5, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"shr",	   1,	0xd0, 5, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"sar",	   2,	0xd0, 7, 0,	 bwlq_Suf|W|Modrm,	{ Imm1, Reg|AnyMem, 0} },
{"sar",	   2,	0xc0, 7, Cpu186, bwlq_Suf|W|Modrm,	{ Imm8, Reg|AnyMem, 0} },
{"sar",	   2,	0xd2, 7, 0,	 bwlq_Suf|W|Modrm,	{ ShiftCount, Reg|AnyMem, 0} },
{"sar",	   1,	0xd0, 7, 0,	 bwlq_Suf|W|Modrm,	{ Reg|AnyMem, 0, 0} },

{"shld",   3, 0x0fa4, X, Cpu386, wlq_Suf|Modrm,		{ Imm8, WordReg, WordReg|WordMem} },
{"shld",   3, 0x0fa5, X, Cpu386, wlq_Suf|Modrm,		{ ShiftCount, WordReg, WordReg|WordMem} },
{"shld",   2, 0x0fa5, X, Cpu386, wlq_Suf|Modrm,		{ WordReg, WordReg|WordMem, 0} },

{"shrd",   3, 0x0fac, X, Cpu386, wlq_Suf|Modrm,		{ Imm8, WordReg, WordReg|WordMem} },
{"shrd",   3, 0x0fad, X, Cpu386, wlq_Suf|Modrm,		{ ShiftCount, WordReg, WordReg|WordMem} },
{"shrd",   2, 0x0fad, X, Cpu386, wlq_Suf|Modrm,		{ WordReg, WordReg|WordMem, 0} },

/* Control transfer instructions.  */
{"call",   1,	0xe8, X, CpuNo64, wl_Suf|JumpDword|DefaultSize,	{ Disp16|Disp32, 0, 0} },
{"call",   1,	0xe8, X, Cpu64,	 wq_Suf|JumpDword|DefaultSize|NoRex64, { Disp16|Disp32, 0, 0} },
{"call",   1,	0xff, 2, CpuNo64, wl_Suf|Modrm|DefaultSize,	{ WordReg|WordMem|JumpAbsolute, 0, 0} },
{"call",   1,	0xff, 2, Cpu64,	 wq_Suf|Modrm|DefaultSize|NoRex64, { Reg16|Reg64|WordMem|LLongMem|JumpAbsolute, 0, 0} },
/* Intel Syntax */
{"call",   2,	0x9a, X, CpuNo64, wl_Suf|JumpInterSegment|DefaultSize, { Imm16, Imm16|Imm32, 0} },
/* Intel Syntax */
{"call",   1,	0xff, 3, 0,	 x_Suf|Modrm|DefaultSize,	{WordMem|JumpAbsolute, 0, 0} },
{"lcall",  2,	0x9a, X, CpuNo64, wl_Suf|JumpInterSegment|DefaultSize, {Imm16, Imm16|Imm32, 0} },
{"lcall",  1,	0xff, 3, 0,	 wl_Suf|Modrm|DefaultSize,	{WordMem|JumpAbsolute, 0, 0} },

{"jmp",	   1,	0xeb, X, 0,	 NoSuf|Jump,		{ Disp,0, 0} },
{"jmp",	   1,	0xff, 4, CpuNo64, wl_Suf|Modrm,		{ WordReg|WordMem|JumpAbsolute, 0, 0} },
{"jmp",	   1,	0xff, 4, Cpu64,	 wq_Suf|Modrm|NoRex64,	{ Reg16|Reg64|ShortMem|LLongMem|JumpAbsolute, 0, 0} },
/* Intel Syntax.  */
{"jmp",    2,	0xea, X, CpuNo64,wl_Suf|JumpInterSegment, { Imm16, Imm16|Imm32, 0} },
/* Intel Syntax.  */
{"jmp",    1,	0xff, 5, 0,	 x_Suf|Modrm,		{ WordMem|JumpAbsolute, 0, 0} },
{"ljmp",   2,	0xea, X, CpuNo64, wl_Suf|JumpInterSegment, { Imm16, Imm16|Imm32, 0} },
{"ljmp",   1,	0xff, 5, 0,	 wl_Suf|Modrm,		{ WordMem|JumpAbsolute, 0, 0} },

{"ret",	   0,	0xc3, X, CpuNo64,wl_Suf|DefaultSize,	{ 0, 0, 0} },
{"ret",	   1,	0xc2, X, CpuNo64,wl_Suf|DefaultSize,	{ Imm16, 0, 0} },
{"ret",	   0,	0xc3, X, Cpu64,  wq_Suf|DefaultSize|NoRex64,{ 0, 0, 0} },
{"ret",	   1,	0xc2, X, Cpu64,  wq_Suf|DefaultSize|NoRex64,{ Imm16, 0, 0} },
{"lret",   0,	0xcb, X, 0,	 wlq_Suf|DefaultSize,	{ 0, 0, 0} },
{"lret",   1,	0xca, X, 0,	 wlq_Suf|DefaultSize,	{ Imm16, 0, 0} },
{"enter",  2,	0xc8, X, Cpu186|CpuNo64, wl_Suf|DefaultSize,	{ Imm16, Imm8, 0} },
{"enter",  2,	0xc8, X, Cpu64,  wq_Suf|DefaultSize|NoRex64,	{ Imm16, Imm8, 0} },
{"leave",  0,	0xc9, X, Cpu186|CpuNo64, wl_Suf|DefaultSize,	{ 0, 0, 0} },
{"leave",  0,	0xc9, X, Cpu64,  wq_Suf|DefaultSize|NoRex64,	{ 0, 0, 0} },

/* Conditional jumps.  */
{"jo",	   1,	0x70, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jno",	   1,	0x71, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jb",	   1,	0x72, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jc",	   1,	0x72, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnae",   1,	0x72, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnb",	   1,	0x73, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnc",	   1,	0x73, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jae",	   1,	0x73, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"je",	   1,	0x74, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jz",	   1,	0x74, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jne",	   1,	0x75, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnz",	   1,	0x75, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jbe",	   1,	0x76, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jna",	   1,	0x76, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnbe",   1,	0x77, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"ja",	   1,	0x77, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"js",	   1,	0x78, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jns",	   1,	0x79, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jp",	   1,	0x7a, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jpe",	   1,	0x7a, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnp",	   1,	0x7b, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jpo",	   1,	0x7b, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jl",	   1,	0x7c, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnge",   1,	0x7c, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnl",	   1,	0x7d, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jge",	   1,	0x7d, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jle",	   1,	0x7e, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jng",	   1,	0x7e, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jnle",   1,	0x7f, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },
{"jg",	   1,	0x7f, X, 0,	 NoSuf|Jump,		{ Disp, 0, 0} },

/* jcxz vs. jecxz is chosen on the basis of the address size prefix.  */
{"jcxz",  1,	0xe3, X, CpuNo64,NoSuf|JumpByte|Size16, { Disp, 0, 0} },
{"jecxz",  1,	0xe3, X, CpuNo64,NoSuf|JumpByte|Size32, { Disp, 0, 0} },
{"jecxz",  1,	0x67e3, X, Cpu64,NoSuf|JumpByte|Size32, { Disp, 0, 0} },
{"jrcxz",  1,	0xe3, X, Cpu64,  NoSuf|JumpByte|Size64|NoRex64, { Disp, 0, 0} },

/* The loop instructions also use the address size prefix to select
   %cx rather than %ecx for the loop count, so the `w' form of these
   instructions emit an address size prefix rather than a data size
   prefix.  */
{"loop",   1,	0xe2, X, CpuNo64,wl_Suf|JumpByte,{ Disp, 0, 0} },
{"loop",   1,	0xe2, X, Cpu64,	 lq_Suf|JumpByte|NoRex64,{ Disp, 0, 0} },
{"loopz",  1,	0xe1, X, CpuNo64,wl_Suf|JumpByte,{ Disp, 0, 0} },
{"loopz",  1,	0xe1, X, Cpu64,	 lq_Suf|JumpByte|NoRex64,{ Disp, 0, 0} },
{"loope",  1,	0xe1, X, CpuNo64,wl_Suf|JumpByte,{ Disp, 0, 0} },
{"loope",  1,	0xe1, X, Cpu64,	 lq_Suf|JumpByte|NoRex64,{ Disp, 0, 0} },
{"loopnz", 1,	0xe0, X, CpuNo64,wl_Suf|JumpByte,{ Disp, 0, 0} },
{"loopnz", 1,	0xe0, X, Cpu64,	 lq_Suf|JumpByte|NoRex64,{ Disp, 0, 0} },
{"loopne", 1,	0xe0, X, CpuNo64,wl_Suf|JumpByte,{ Disp, 0, 0} },
{"loopne", 1,	0xe0, X, Cpu64,	 lq_Suf|JumpByte|NoRex64,{ Disp, 0, 0} },

/* Set byte on flag instructions.  */
{"seto",   1, 0x0f90, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setno",  1, 0x0f91, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setb",   1, 0x0f92, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setc",   1, 0x0f92, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnae", 1, 0x0f92, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnb",  1, 0x0f93, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnc",  1, 0x0f93, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setae",  1, 0x0f93, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"sete",   1, 0x0f94, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setz",   1, 0x0f94, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setne",  1, 0x0f95, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnz",  1, 0x0f95, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setbe",  1, 0x0f96, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setna",  1, 0x0f96, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnbe", 1, 0x0f97, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"seta",   1, 0x0f97, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"sets",   1, 0x0f98, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setns",  1, 0x0f99, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setp",   1, 0x0f9a, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setpe",  1, 0x0f9a, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnp",  1, 0x0f9b, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setpo",  1, 0x0f9b, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setl",   1, 0x0f9c, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnge", 1, 0x0f9c, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnl",  1, 0x0f9d, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setge",  1, 0x0f9d, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setle",  1, 0x0f9e, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setng",  1, 0x0f9e, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setnle", 1, 0x0f9f, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },
{"setg",   1, 0x0f9f, 0, Cpu386, b_Suf|Modrm,		{ Reg8|ByteMem, 0, 0} },

/* String manipulation.  */
{"cmps",   0,	0xa6, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"cmps",   2,	0xa6, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, AnyMem, 0} },
{"scmp",   0,	0xa6, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"scmp",   2,	0xa6, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, AnyMem, 0} },
{"ins",	   0,	0x6c, X, Cpu186, bwl_Suf|W|IsString,	{ 0, 0, 0} },
{"ins",	   2,	0x6c, X, Cpu186, bwl_Suf|W|IsString,	{ InOutPortReg, AnyMem|EsSeg, 0} },
{"outs",   0,	0x6e, X, Cpu186, bwl_Suf|W|IsString,	{ 0, 0, 0} },
{"outs",   2,	0x6e, X, Cpu186, bwl_Suf|W|IsString,	{ AnyMem, InOutPortReg, 0} },
{"lods",   0,	0xac, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"lods",   1,	0xac, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem, 0, 0} },
{"lods",   2,	0xac, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem, Acc, 0} },
{"slod",   0,	0xac, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"slod",   1,	0xac, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem, 0, 0} },
{"slod",   2,	0xac, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem, Acc, 0} },
{"movs",   0,	0xa4, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"movs",   2,	0xa4, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem, AnyMem|EsSeg, 0} },
{"smov",   0,	0xa4, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"smov",   2,	0xa4, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem, AnyMem|EsSeg, 0} },
{"scas",   0,	0xae, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"scas",   1,	0xae, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, 0, 0} },
{"scas",   2,	0xae, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, Acc, 0} },
{"ssca",   0,	0xae, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"ssca",   1,	0xae, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, 0, 0} },
{"ssca",   2,	0xae, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, Acc, 0} },
{"stos",   0,	0xaa, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"stos",   1,	0xaa, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, 0, 0} },
{"stos",   2,	0xaa, X, 0,	 bwlq_Suf|W|IsString,	{ Acc, AnyMem|EsSeg, 0} },
{"ssto",   0,	0xaa, X, 0,	 bwlq_Suf|W|IsString,	{ 0, 0, 0} },
{"ssto",   1,	0xaa, X, 0,	 bwlq_Suf|W|IsString,	{ AnyMem|EsSeg, 0, 0} },
{"ssto",   2,	0xaa, X, 0,	 bwlq_Suf|W|IsString,	{ Acc, AnyMem|EsSeg, 0} },
{"xlat",   0,	0xd7, X, 0,	 b_Suf|IsString,	{ 0, 0, 0} },
{"xlat",   1,	0xd7, X, 0,	 b_Suf|IsString,	{ AnyMem, 0, 0} },

/* Bit manipulation.  */
{"bsf",	   2, 0x0fbc, X, Cpu386, wlq_Suf|Modrm,		{ WordReg|WordMem, WordReg, 0} },
{"bsr",	   2, 0x0fbd, X, Cpu386, wlq_Suf|Modrm,		{ WordReg|WordMem, WordReg, 0} },
{"bt",	   2, 0x0fa3, X, Cpu386, wlq_Suf|Modrm,		{ WordReg, WordReg|WordMem, 0} },
{"bt",	   2, 0x0fba, 4, Cpu386, wlq_Suf|Modrm,		{ Imm8, WordReg|WordMem, 0} },
{"btc",	   2, 0x0fbb, X, Cpu386, wlq_Suf|Modrm,		{ WordReg, WordReg|WordMem, 0} },
{"btc",	   2, 0x0fba, 7, Cpu386, wlq_Suf|Modrm,		{ Imm8, WordReg|WordMem, 0} },
{"btr",	   2, 0x0fb3, X, Cpu386, wlq_Suf|Modrm,		{ WordReg, WordReg|WordMem, 0} },
{"btr",	   2, 0x0fba, 6, Cpu386, wlq_Suf|Modrm,		{ Imm8, WordReg|WordMem, 0} },
{"bts",	   2, 0x0fab, X, Cpu386, wlq_Suf|Modrm,		{ WordReg, WordReg|WordMem, 0} },
{"bts",	   2, 0x0fba, 5, Cpu386, wlq_Suf|Modrm,		{ Imm8, WordReg|WordMem, 0} },

/* Interrupts & op. sys insns.  */
/* See gas/config/tc-i386.c for conversion of 'int $3' into the special
   int 3 insn.  */
{"int",	   1,	0xcd, X, 0,	 NoSuf,			{ Imm8, 0, 0} },
{"int3",   0,	0xcc, X, 0,	 NoSuf,			{ 0, 0, 0} },
{"into",   0,	0xce, X, CpuNo64,	 NoSuf,			{ 0, 0, 0} },
{"iret",   0,	0xcf, X, 0,	 wlq_Suf|DefaultSize,	{ 0, 0, 0} },
/* i386sl, i486sl, later 486, and Pentium.  */
{"rsm",	   0, 0x0faa, X, Cpu386, NoSuf,			{ 0, 0, 0} },

{"bound",  2,	0x62, X, Cpu186|CpuNo64, wl_Suf|Modrm,		{ WordReg, WordMem, 0} },

{"hlt",	   0,	0xf4, X, 0,	 NoSuf,			{ 0, 0, 0} },

{"nop",    1, 0x0f1f, 0, Cpu686, wlq_Suf|Modrm,		{ WordReg|WordMem, 0, 0} },

/* nop is actually "xchg %ax,%ax" in 16bit mode, "xchg %eax,%eax" in
   32bit mode and "xchg %rax,%rax" in 64bit mode.  */
{"nop",	   0,	0x90, X, 0,	 NoSuf,			{ 0, 0, 0} },

/* Protection control.  */
{"arpl",   2,	0x63, X, Cpu286|CpuNo64, w_Suf|Modrm|IgnoreSize,{ Reg16, Reg16|ShortMem, 0} },
{"lar",	   2, 0x0f02, X, Cpu286, wlq_Suf|Modrm,		{ WordReg|WordMem, WordReg, 0} },
{"lgdt",   1, 0x0f01, 2, Cpu286|CpuNo64, wl_Suf|Modrm,		{ WordMem, 0, 0} },
{"lgdt",   1, 0x0f01, 2, Cpu64, q_Suf|Modrm|NoRex64,		{ LLongMem, 0, 0} },
{"lidt",   1, 0x0f01, 3, Cpu286|CpuNo64, wl_Suf|Modrm,		{ WordMem, 0, 0} },
{"lidt",   1, 0x0f01, 3, Cpu64, q_Suf|Modrm|NoRex64,		{ LLongMem, 0, 0} },
{"lldt",   1, 0x0f00, 2, Cpu286, w_Suf|Modrm|IgnoreSize,{ Reg16|ShortMem, 0, 0} },
{"lmsw",   1, 0x0f01, 6, Cpu286, w_Suf|Modrm|IgnoreSize,{ Reg16|ShortMem, 0, 0} },
{"lsl",	   2, 0x0f03, X, Cpu286, wlq_Suf|Modrm,		{ WordReg|WordMem, WordReg, 0} },
{"ltr",	   1, 0x0f00, 3, Cpu286, w_Suf|Modrm|IgnoreSize,{ Reg16|ShortMem, 0, 0} },

{"sgdt",   1, 0x0f01, 0, Cpu286|CpuNo64, wl_Suf|Modrm,		{ WordMem, 0, 0} },
{"sgdt",   1, 0x0f01, 0, Cpu64, q_Suf|Modrm|NoRex64,		{ LLongMem, 0, 0} },
{"sidt",   1, 0x0f01, 1, Cpu286|CpuNo64, wl_Suf|Modrm,		{ WordMem, 0, 0} },
{"sidt",   1, 0x0f01, 1, Cpu64, q_Suf|Modrm|NoRex64,		{ LLongMem, 0, 0} },
{"sldt",   1, 0x0f00, 0, Cpu286, wlq_Suf|Modrm,		{ WordReg, 0, 0} },
{"sldt",   1, 0x0f00, 0, Cpu286, w_Suf|Modrm|IgnoreSize,{ ShortMem, 0, 0} },
{"smsw",   1, 0x0f01, 4, Cpu286, wlq_Suf|Modrm,		{ WordReg, 0, 0} },
{"smsw",   1, 0x0f01, 4, Cpu286, w_Suf|Modrm|IgnoreSize,{ ShortMem, 0, 0} },
{"str",	   1, 0x0f00, 1, Cpu286, wlq_Suf|Modrm,		{ WordReg, 0, 0} },
{"str",	   1, 0x0f00, 1, Cpu286, w_Suf|Modrm|IgnoreSize,{ ShortMem, 0, 0} },

{"verr",   1, 0x0f00, 4, Cpu286, w_Suf|Modrm|IgnoreSize,{ Reg16|ShortMem, 0, 0} },
{"verw",   1, 0x0f00, 5, Cpu286, w_Suf|Modrm|IgnoreSize,{ Reg16|ShortMem, 0, 0} },

/* Floating point instructions.  */

/* load */
{"fld",	   1, 0xd9c0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fld",	   1,	0xd9, 0, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fld",	   1, 0xd9c0, X, 0,	 l_FP|ShortForm|IgnoreSize|Ugh, { FloatReg, 0, 0} },
/* Intel Syntax */
{"fld",    1,	0xdb, 5, 0,	 x_FP|Modrm,		{ LLongMem, 0, 0} },
{"fild",   1,	0xdf, 0, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },
{"fild",   1,	0xdf, 5, 0,	 q_FP|Modrm,		{ LLongMem, 0, 0} },
{"fildll", 1,	0xdf, 5, 0,	 FP|Modrm,		{ LLongMem, 0, 0} },
{"fldt",   1,	0xdb, 5, 0,	 FP|Modrm,		{ LLongMem, 0, 0} },
{"fbld",   1,	0xdf, 4, 0,	 x_Suf|Modrm,		{ LLongMem, 0, 0} },

/* store (no pop) */
{"fst",	   1, 0xddd0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fst",	   1,	0xd9, 2, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fst",	   1, 0xddd0, X, 0,	 l_FP|ShortForm|IgnoreSize|Ugh, { FloatReg, 0, 0} },
{"fist",   1,	0xdf, 2, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

/* store (with pop) */
{"fstp",   1, 0xddd8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fstp",   1,	0xd9, 3, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fstp",   1, 0xddd8, X, 0,	 l_FP|ShortForm|IgnoreSize|Ugh, { FloatReg, 0, 0} },
/* Intel Syntax */
{"fstp",   1,	0xdb, 7, 0,	 x_FP|Modrm,		{ LLongMem, 0, 0} },
{"fistp",  1,	0xdf, 3, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },
{"fistp",  1,	0xdf, 7, 0,	 q_FP|Modrm,		{ LLongMem, 0, 0} },
{"fistpll",1,	0xdf, 7, 0,	 FP|Modrm,		{ LLongMem, 0, 0} },
{"fstpt",  1,	0xdb, 7, 0,	 FP|Modrm,		{ LLongMem, 0, 0} },
{"fbstp",  1,	0xdf, 6, 0,	 x_Suf|Modrm,		{ LLongMem, 0, 0} },

/* exchange %st<n> with %st0 */
{"fxch",   1, 0xd9c8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
/* alias for fxch %st(1) */
{"fxch",   0, 0xd9c9, X, 0,	 FP,			{ 0, 0, 0} },

/* comparison (without pop) */
{"fcom",   1, 0xd8d0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
/* alias for fcom %st(1) */
{"fcom",   0, 0xd8d1, X, 0,	 FP,			{ 0, 0, 0} },
{"fcom",   1,	0xd8, 2, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fcom",   1, 0xd8d0, X, 0,	 l_FP|ShortForm|IgnoreSize|Ugh, { FloatReg, 0, 0} },
{"ficom",  1,	0xde, 2, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

/* comparison (with pop) */
{"fcomp",  1, 0xd8d8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
/* alias for fcomp %st(1) */
{"fcomp",  0, 0xd8d9, X, 0,	 FP,			{ 0, 0, 0} },
{"fcomp",  1,	0xd8, 3, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fcomp",  1, 0xd8d8, X, 0,	 l_FP|ShortForm|IgnoreSize|Ugh, { FloatReg, 0, 0} },
{"ficomp", 1,	0xde, 3, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },
{"fcompp", 0, 0xded9, X, 0,	 FP,			{ 0, 0, 0} },

/* unordered comparison (with pop) */
{"fucom",  1, 0xdde0, X, Cpu286, FP|ShortForm,		{ FloatReg, 0, 0} },
/* alias for fucom %st(1) */
{"fucom",  0, 0xdde1, X, Cpu286, FP,			{ 0, 0, 0} },
{"fucomp", 1, 0xdde8, X, Cpu286, FP|ShortForm,		{ FloatReg, 0, 0} },
/* alias for fucomp %st(1) */
{"fucomp", 0, 0xdde9, X, Cpu286, FP,			{ 0, 0, 0} },
{"fucompp",0, 0xdae9, X, Cpu286, FP,			{ 0, 0, 0} },

{"ftst",   0, 0xd9e4, X, 0,	 FP,			{ 0, 0, 0} },
{"fxam",   0, 0xd9e5, X, 0,	 FP,			{ 0, 0, 0} },

/* load constants into %st0 */
{"fld1",   0, 0xd9e8, X, 0,	 FP,			{ 0, 0, 0} },
{"fldl2t", 0, 0xd9e9, X, 0,	 FP,			{ 0, 0, 0} },
{"fldl2e", 0, 0xd9ea, X, 0,	 FP,			{ 0, 0, 0} },
{"fldpi",  0, 0xd9eb, X, 0,	 FP,			{ 0, 0, 0} },
{"fldlg2", 0, 0xd9ec, X, 0,	 FP,			{ 0, 0, 0} },
{"fldln2", 0, 0xd9ed, X, 0,	 FP,			{ 0, 0, 0} },
{"fldz",   0, 0xd9ee, X, 0,	 FP,			{ 0, 0, 0} },

/* Arithmetic.  */

/* add */
{"fadd",   2, 0xd8c0, X, 0,	 FP|ShortForm|FloatD,	{ FloatReg, FloatAcc, 0} },
/* alias for fadd %st(i), %st */
{"fadd",   1, 0xd8c0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
#if SYSV386_COMPAT
/* alias for faddp */
{"fadd",   0, 0xdec1, X, 0,	 FP|Ugh,		{ 0, 0, 0} },
#endif
{"fadd",   1,	0xd8, 0, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fiadd",  1,	0xde, 0, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

{"faddp",  2, 0xdec0, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"faddp",  1, 0xdec0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
/* alias for faddp %st, %st(1) */
{"faddp",  0, 0xdec1, X, 0,	 FP,			{ 0, 0, 0} },
{"faddp",  2, 0xdec0, X, 0,	 FP|ShortForm|Ugh,	{ FloatReg, FloatAcc, 0} },

/* subtract */
{"fsub",   1, 0xd8e0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
#if SYSV386_COMPAT
{"fsub",   2, 0xd8e0, X, 0,	 FP|ShortForm|FloatD,	{ FloatReg, FloatAcc, 0} },
/* alias for fsubp */
{"fsub",   0, 0xdee1, X, 0,	 FP|Ugh,		{ 0, 0, 0} },
#else
{"fsub",   2, 0xd8e0, X, 0,	 FP|ShortForm|FloatD|FloatR, { FloatReg, FloatAcc, 0} },
#endif
{"fsub",   1,	0xd8, 4, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fisub",  1,	0xde, 4, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

#if SYSV386_COMPAT
{"fsubp",  2, 0xdee0, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fsubp",  1, 0xdee0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fsubp",  0, 0xdee1, X, 0,	 FP,			{ 0, 0, 0} },
#if OLDGCC_COMPAT
{"fsubp",  2, 0xdee0, X, 0,	 FP|ShortForm|Ugh,	{ FloatReg, FloatAcc, 0} },
#endif
#else
{"fsubp",  2, 0xdee8, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fsubp",  1, 0xdee8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fsubp",  0, 0xdee9, X, 0,	 FP,			{ 0, 0, 0} },
#endif

/* subtract reverse */
{"fsubr",  1, 0xd8e8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
#if SYSV386_COMPAT
{"fsubr",  2, 0xd8e8, X, 0,	 FP|ShortForm|FloatD,	{ FloatReg, FloatAcc, 0} },
/* alias for fsubrp */
{"fsubr",  0, 0xdee9, X, 0,	 FP|Ugh,		{ 0, 0, 0} },
#else
{"fsubr",  2, 0xd8e8, X, 0,	 FP|ShortForm|FloatD|FloatR, { FloatReg, FloatAcc, 0} },
#endif
{"fsubr",  1,	0xd8, 5, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fisubr", 1,	0xde, 5, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

#if SYSV386_COMPAT
{"fsubrp", 2, 0xdee8, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fsubrp", 1, 0xdee8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fsubrp", 0, 0xdee9, X, 0,	 FP,			{ 0, 0, 0} },
#if OLDGCC_COMPAT
{"fsubrp", 2, 0xdee8, X, 0,	 FP|ShortForm|Ugh,	{ FloatReg, FloatAcc, 0} },
#endif
#else
{"fsubrp", 2, 0xdee0, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fsubrp", 1, 0xdee0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fsubrp", 0, 0xdee1, X, 0,	 FP,			{ 0, 0, 0} },
#endif

/* multiply */
{"fmul",   2, 0xd8c8, X, 0,	 FP|ShortForm|FloatD,	{ FloatReg, FloatAcc, 0} },
{"fmul",   1, 0xd8c8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
#if SYSV386_COMPAT
/* alias for fmulp */
{"fmul",   0, 0xdec9, X, 0,	 FP|Ugh,		{ 0, 0, 0} },
#endif
{"fmul",   1,	0xd8, 1, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fimul",  1,	0xde, 1, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

{"fmulp",  2, 0xdec8, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fmulp",  1, 0xdec8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fmulp",  0, 0xdec9, X, 0,	 FP,			{ 0, 0, 0} },
{"fmulp",  2, 0xdec8, X, 0,	 FP|ShortForm|Ugh,	{ FloatReg, FloatAcc, 0} },

/* divide */
{"fdiv",   1, 0xd8f0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
#if SYSV386_COMPAT
{"fdiv",   2, 0xd8f0, X, 0,	 FP|ShortForm|FloatD,	{ FloatReg, FloatAcc, 0} },
/* alias for fdivp */
{"fdiv",   0, 0xdef1, X, 0,	 FP|Ugh,		{ 0, 0, 0} },
#else
{"fdiv",   2, 0xd8f0, X, 0,	 FP|ShortForm|FloatD|FloatR, { FloatReg, FloatAcc, 0} },
#endif
{"fdiv",   1,	0xd8, 6, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fidiv",  1,	0xde, 6, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

#if SYSV386_COMPAT
{"fdivp",  2, 0xdef0, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fdivp",  1, 0xdef0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fdivp",  0, 0xdef1, X, 0,	 FP,			{ 0, 0, 0} },
#if OLDGCC_COMPAT
{"fdivp",  2, 0xdef0, X, 0,	 FP|ShortForm|Ugh,	{ FloatReg, FloatAcc, 0} },
#endif
#else
{"fdivp",  2, 0xdef8, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fdivp",  1, 0xdef8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fdivp",  0, 0xdef9, X, 0,	 FP,			{ 0, 0, 0} },
#endif

/* divide reverse */
{"fdivr",  1, 0xd8f8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
#if SYSV386_COMPAT
{"fdivr",  2, 0xd8f8, X, 0,	 FP|ShortForm|FloatD,	{ FloatReg, FloatAcc, 0} },
/* alias for fdivrp */
{"fdivr",  0, 0xdef9, X, 0,	 FP|Ugh,		{ 0, 0, 0} },
#else
{"fdivr",  2, 0xd8f8, X, 0,	 FP|ShortForm|FloatD|FloatR, { FloatReg, FloatAcc, 0} },
#endif
{"fdivr",  1,	0xd8, 7, 0,	 sl_FP|Modrm,		{ LongMem|LLongMem, 0, 0} },
{"fidivr", 1,	0xde, 7, 0,	 sl_FP|Modrm,		{ ShortMem|LongMem, 0, 0} },

#if SYSV386_COMPAT
{"fdivrp", 2, 0xdef8, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fdivrp", 1, 0xdef8, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fdivrp", 0, 0xdef9, X, 0,	 FP,			{ 0, 0, 0} },
#if OLDGCC_COMPAT
{"fdivrp", 2, 0xdef8, X, 0,	 FP|ShortForm|Ugh,	{ FloatReg, FloatAcc, 0} },
#endif
#else
{"fdivrp", 2, 0xdef0, X, 0,	 FP|ShortForm,		{ FloatAcc, FloatReg, 0} },
{"fdivrp", 1, 0xdef0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
{"fdivrp", 0, 0xdef1, X, 0,	 FP,			{ 0, 0, 0} },
#endif

{"f2xm1",  0, 0xd9f0, X, 0,	 FP,			{ 0, 0, 0} },
{"fyl2x",  0, 0xd9f1, X, 0,	 FP,			{ 0, 0, 0} },
{"fptan",  0, 0xd9f2, X, 0,	 FP,			{ 0, 0, 0} },
{"fpatan", 0, 0xd9f3, X, 0,	 FP,			{ 0, 0, 0} },
{"fxtract",0, 0xd9f4, X, 0,	 FP,			{ 0, 0, 0} },
{"fprem1", 0, 0xd9f5, X, Cpu286, FP,			{ 0, 0, 0} },
{"fdecstp",0, 0xd9f6, X, 0,	 FP,			{ 0, 0, 0} },
{"fincstp",0, 0xd9f7, X, 0,	 FP,			{ 0, 0, 0} },
{"fprem",  0, 0xd9f8, X, 0,	 FP,			{ 0, 0, 0} },
{"fyl2xp1",0, 0xd9f9, X, 0,	 FP,			{ 0, 0, 0} },
{"fsqrt",  0, 0xd9fa, X, 0,	 FP,			{ 0, 0, 0} },
{"fsincos",0, 0xd9fb, X, Cpu286, FP,			{ 0, 0, 0} },
{"frndint",0, 0xd9fc, X, 0,	 FP,			{ 0, 0, 0} },
{"fscale", 0, 0xd9fd, X, 0,	 FP,			{ 0, 0, 0} },
{"fsin",   0, 0xd9fe, X, Cpu286, FP,			{ 0, 0, 0} },
{"fcos",   0, 0xd9ff, X, Cpu286, FP,			{ 0, 0, 0} },
{"fchs",   0, 0xd9e0, X, 0,	 FP,			{ 0, 0, 0} },
{"fabs",   0, 0xd9e1, X, 0,	 FP,			{ 0, 0, 0} },

/* processor control */
{"fninit", 0, 0xdbe3, X, 0,	 FP,			{ 0, 0, 0} },
{"finit",  0, 0xdbe3, X, 0,	 FP|FWait,		{ 0, 0, 0} },
{"fldcw",  1,	0xd9, 5, 0,	 w_Suf|FloatMF|Modrm,	{ ShortMem, 0, 0} },
{"fnstcw", 1,	0xd9, 7, 0,	 w_Suf|FloatMF|Modrm,	{ ShortMem, 0, 0} },
{"fstcw",  1,	0xd9, 7, 0,	 w_Suf|FloatMF|FWait|Modrm, { ShortMem, 0, 0} },
/* XXX should reject %al, %eax, and %rax */
{"fnstsw", 1, 0xdfe0, X, 0,	 FP|IgnoreSize,		{ Acc, 0, 0} },
{"fnstsw", 1,	0xdd, 7, 0,	 w_Suf|FloatMF|Modrm,	{ ShortMem, 0, 0} },
{"fnstsw", 0, 0xdfe0, X, 0,	 FP,			{ 0, 0, 0} },
/* XXX should reject %al, %eax, and %rax */
{"fstsw",  1, 0xdfe0, X, 0,	 FP|FWait|IgnoreSize,	{ Acc, 0, 0} },
{"fstsw",  1,	0xdd, 7, 0,	 w_Suf|FloatMF|FWait|Modrm, { ShortMem, 0, 0} },
{"fstsw",  0, 0xdfe0, X, 0,	 FP|FWait,		{ 0, 0, 0} },
{"fnclex", 0, 0xdbe2, X, 0,	 FP,			{ 0, 0, 0} },
{"fclex",  0, 0xdbe2, X, 0,	 FP|FWait,		{ 0, 0, 0} },
/* Short forms of fldenv, fstenv use data size prefix.  */
{"fnstenv",1,	0xd9, 6, 0,	 sl_Suf|Modrm|DefaultSize,		{ LLongMem, 0, 0} },
{"fstenv", 1,	0xd9, 6, 0,	 sl_Suf|FWait|Modrm|DefaultSize,	{ LLongMem, 0, 0} },
{"fldenv", 1,	0xd9, 4, 0,	 sl_Suf|Modrm|DefaultSize,		{ LLongMem, 0, 0} },
{"fnsave", 1,	0xdd, 6, 0,	 sl_Suf|Modrm|DefaultSize,		{ LLongMem, 0, 0} },
{"fsave",  1,	0xdd, 6, 0,	 sl_Suf|FWait|Modrm|DefaultSize,	{ LLongMem, 0, 0} },
{"frstor", 1,	0xdd, 4, 0,	 sl_Suf|Modrm|DefaultSize,		{ LLongMem, 0, 0} },

{"ffree",  1, 0xddc0, X, 0,	 FP|ShortForm,		{ FloatReg, 0, 0} },
/* P6:free st(i), pop st */
{"ffreep", 1, 0xdfc0, X, Cpu686, FP|ShortForm,		{ FloatReg, 0, 0} },
{"fnop",   0, 0xd9d0, X, 0,	 FP,			{ 0, 0, 0} },
{"fwait",  0,	0x9b, X, 0,	 FP,			{ 0, 0, 0} },

/* Opcode prefixes; we allow them as separate insns too.  */

{"addr16", 0,	0x67, X, Cpu386|CpuNo64, NoSuf|IsPrefix|Size16|IgnoreSize,	{ 0, 0, 0} },
{"addr32", 0,	0x67, X, Cpu386,NoSuf|IsPrefix|Size32|IgnoreSize,	{ 0, 0, 0} },
{"aword",  0,	0x67, X, Cpu386|CpuNo64,NoSuf|IsPrefix|Size16|IgnoreSize,	{ 0, 0, 0} },
{"adword", 0,	0x67, X, Cpu386,NoSuf|IsPrefix|Size32|IgnoreSize,	{ 0, 0, 0} },
{"data16", 0,	0x66, X, Cpu386,NoSuf|IsPrefix|Size16|IgnoreSize,	{ 0, 0, 0} },
{"data32", 0,	0x66, X, Cpu386|CpuNo64,NoSuf|IsPrefix|Size32|IgnoreSize,	{ 0, 0, 0} },
{"word",   0,	0x66, X, Cpu386,NoSuf|IsPrefix|Size16|IgnoreSize,	{ 0, 0, 0} },
{"dword",  0,	0x66, X, Cpu386|CpuNo64,NoSuf|IsPrefix|Size32|IgnoreSize,	{ 0, 0, 0} },
{"lock",   0,	0xf0, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"wait",   0,   0x9b, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"cs",	   0,	0x2e, X, 0,	NoSuf|IsPrefix,	{ 0, 0, 0} },
{"ds",	   0,	0x3e, X, 0,	NoSuf|IsPrefix,	{ 0, 0, 0} },
{"es",	   0,	0x26, X, CpuNo64,	NoSuf|IsPrefix,	{ 0, 0, 0} },
{"fs",	   0,	0x64, X, Cpu386, NoSuf|IsPrefix,	{ 0, 0, 0} },
{"gs",	   0,	0x65, X, Cpu386, NoSuf|IsPrefix,	{ 0, 0, 0} },
{"ss",	   0,	0x36, X, CpuNo64,	NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rep",	   0,	0xf3, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"repe",   0,	0xf3, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"repz",   0,	0xf3, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"repne",  0,	0xf2, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"repnz",  0,	0xf2, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"ht",	   0,	0x3e, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"hnt",	   0,	0x2e, X, 0,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex",    0,	0x40, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexz",   0,	0x41, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexy",   0,	0x42, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexyz",  0,	0x43, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexx",   0,	0x44, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexxz",  0,	0x45, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexxy",  0,	0x46, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rexxyz", 0,	0x47, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64",  0,	0x48, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64z", 0,	0x49, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64y", 0,	0x4a, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64yz",0,	0x4b, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64x", 0,	0x4c, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64xz",0,	0x4d, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64xy",0,	0x4e, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex64xyz",0,	0x4f, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.b",  0,	0x41, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.x",  0,	0x42, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.xb", 0,	0x43, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.r",  0,	0x44, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.rb", 0,	0x45, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.rx", 0,	0x46, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.rxb",0,	0x47, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.w",  0,	0x48, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wb", 0,	0x49, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wx", 0,	0x4a, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wxb",0,	0x4b, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wr", 0,	0x4c, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wrb",0,	0x4d, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wrx",0,	0x4e, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },
{"rex.wrxb",0,	0x4f, X, Cpu64,	 NoSuf|IsPrefix,	{ 0, 0, 0} },

/* 486 extensions.  */

{"bswap",   1, 0x0fc8, X, Cpu486, lq_Suf|ShortForm,	{ Reg32|Reg64, 0, 0 } },
{"xadd",    2, 0x0fc0, X, Cpu486, bwlq_Suf|W|Modrm,	{ Reg, Reg|AnyMem, 0 } },
{"cmpxchg", 2, 0x0fb0, X, Cpu486, bwlq_Suf|W|Modrm,	{ Reg, Reg|AnyMem, 0 } },
{"invd",    0, 0x0f08, X, Cpu486, NoSuf,		{ 0, 0, 0} },
{"wbinvd",  0, 0x0f09, X, Cpu486, NoSuf,		{ 0, 0, 0} },
{"invlpg",  1, 0x0f01, 7, Cpu486, NoSuf|Modrm|IgnoreSize, { AnyMem, 0, 0} },

/* 586 and late 486 extensions.  */
{"cpuid",   0, 0x0fa2, X, Cpu486, NoSuf,		{ 0, 0, 0} },

/* Pentium extensions.  */
{"wrmsr",   0, 0x0f30, X, Cpu586, NoSuf,		{ 0, 0, 0} },
{"rdtsc",   0, 0x0f31, X, Cpu586, NoSuf,		{ 0, 0, 0} },
{"rdmsr",   0, 0x0f32, X, Cpu586, NoSuf,		{ 0, 0, 0} },
{"cmpxchg8b",1,0x0fc7, 1, Cpu586, q_Suf|Modrm,		{ LLongMem, 0, 0} },

/* Pentium II/Pentium Pro extensions.  */
{"sysenter",0, 0x0f34, X, Cpu686, NoSuf,		{ 0, 0, 0} },
{"sysexit", 0, 0x0f35, X, Cpu686, NoSuf,		{ 0, 0, 0} },
{"fxsave",  1, 0x0fae, 0, Cpu686, q_Suf|Modrm,		{ LLongMem, 0, 0} },
{"fxrstor", 1, 0x0fae, 1, Cpu686, q_Suf|Modrm,		{ LLongMem, 0, 0} },
{"rdpmc",   0, 0x0f33, X, Cpu686, NoSuf,		{ 0, 0, 0} },
/* official undefined instr. */
{"ud2",	    0, 0x0f0b, X, Cpu686, NoSuf,		{ 0, 0, 0} },
/* alias for ud2 */
{"ud2a",    0, 0x0f0b, X, Cpu686, NoSuf,		{ 0, 0, 0} },
/* 2nd. official undefined instr. */
{"ud2b",    0, 0x0fb9, X, Cpu686, NoSuf,		{ 0, 0, 0} },

{"cmovo",   2, 0x0f40, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovno",  2, 0x0f41, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovb",   2, 0x0f42, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovc",   2, 0x0f42, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnae", 2, 0x0f42, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovae",  2, 0x0f43, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnc",  2, 0x0f43, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnb",  2, 0x0f43, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmove",   2, 0x0f44, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovz",   2, 0x0f44, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovne",  2, 0x0f45, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnz",  2, 0x0f45, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovbe",  2, 0x0f46, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovna",  2, 0x0f46, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmova",   2, 0x0f47, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnbe", 2, 0x0f47, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovs",   2, 0x0f48, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovns",  2, 0x0f49, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovp",   2, 0x0f4a, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnp",  2, 0x0f4b, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovl",   2, 0x0f4c, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnge", 2, 0x0f4c, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovge",  2, 0x0f4d, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnl",  2, 0x0f4d, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovle",  2, 0x0f4e, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovng",  2, 0x0f4e, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovg",   2, 0x0f4f, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"cmovnle", 2, 0x0f4f, X, Cpu686, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },

{"fcmovb",  2, 0xdac0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovnae",2, 0xdac0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmove",  2, 0xdac8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovbe", 2, 0xdad0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovna", 2, 0xdad0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovu",  2, 0xdad8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovae", 2, 0xdbc0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovnb", 2, 0xdbc0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovne", 2, 0xdbc8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmova",  2, 0xdbd0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovnbe",2, 0xdbd0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcmovnu", 2, 0xdbd8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },

{"fcomi",   2, 0xdbf0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcomi",   0, 0xdbf1, X, Cpu686, FP|ShortForm,		{ 0, 0, 0} },
{"fcomi",   1, 0xdbf0, X, Cpu686, FP|ShortForm,		{ FloatReg, 0, 0} },
{"fucomi",  2, 0xdbe8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fucomi",  0, 0xdbe9, X, Cpu686, FP|ShortForm,		{ 0, 0, 0} },
{"fucomi",  1, 0xdbe8, X, Cpu686, FP|ShortForm,		{ FloatReg, 0, 0} },
{"fcomip",  2, 0xdff0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcompi",  2, 0xdff0, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fcompi",  0, 0xdff1, X, Cpu686, FP|ShortForm,		{ 0, 0, 0} },
{"fcompi",  1, 0xdff0, X, Cpu686, FP|ShortForm,		{ FloatReg, 0, 0} },
{"fucomip", 2, 0xdfe8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fucompi", 2, 0xdfe8, X, Cpu686, FP|ShortForm,		{ FloatReg, FloatAcc, 0} },
{"fucompi", 0, 0xdfe9, X, Cpu686, FP|ShortForm,		{ 0, 0, 0} },
{"fucompi", 1, 0xdfe8, X, Cpu686, FP|ShortForm,		{ FloatReg, 0, 0} },

/* Pentium4 extensions.  */

{"movnti",   2, 0x0fc3,    X, CpuP4, wlq_Suf|Modrm,		{ WordReg, WordMem, 0 } },
{"clflush",  1, 0x0fae,    7, CpuP4, NoSuf|Modrm|IgnoreSize,	{ ByteMem, 0, 0 } },
{"lfence",   0, 0x0fae, 0xe8, CpuP4, NoSuf|ImmExt,		{ 0, 0, 0 } },
{"mfence",   0, 0x0fae, 0xf0, CpuP4, NoSuf|ImmExt,		{ 0, 0, 0 } },
{"pause",    0, 0xf390,    X, CpuP4, NoSuf,		{ 0, 0, 0 } },

/* MMX/SSE2 instructions.  */

{"emms",     0, 0x0f77, X, CpuMMX, NoSuf,			{ 0, 0, 0 } },
/* These really shouldn't allow for Reg64 (movq is the right mnemonic for
   copying between Reg64/Mem64 and RegXMM/RegMMX, as is mandated by Intel's
   spec). AMD's spec, having been in existence for much longer, failed to
   recognize that and specified movd for 32- and 64-bit operations.  */
{"movd",     2, 0x0f6e, X, CpuMMX, NoSuf|IgnoreSize|Modrm, { Reg32|Reg64|LongMem, RegMMX, 0 } },
{"movd",     2, 0x0f7e, X, CpuMMX, NoSuf|IgnoreSize|Modrm, { RegMMX, Reg32|Reg64|LongMem, 0 } },
{"movd",     2, 0x660f6e,X,CpuSSE2,NoSuf|IgnoreSize|Modrm, { Reg32|Reg64|LongMem, RegXMM, 0 } },
{"movd",     2, 0x660f7e,X,CpuSSE2,NoSuf|IgnoreSize|Modrm, { RegXMM, Reg32|Reg64|LongMem, 0 } },
/* In the 64bit mode the short form mov immediate is redefined to have
   64bit displacement value.  */
{"movq",     2, 0x0f6f, X, CpuMMX, NoSuf|IgnoreSize|Modrm|NoRex64, { RegMMX|LLongMem, RegMMX, 0 } },
{"movq",     2, 0x0f7f, X, CpuMMX, NoSuf|IgnoreSize|Modrm|NoRex64, { RegMMX, RegMMX|LLongMem, 0 } },
{"movq",     2, 0xf30f7e,X,CpuSSE2,NoSuf|IgnoreSize|Modrm|NoRex64, { RegXMM|LLongMem, RegXMM, 0 } },
{"movq",     2, 0x660fd6,X,CpuSSE2,NoSuf|IgnoreSize|Modrm|NoRex64, { RegXMM, RegXMM|LLongMem, 0 } },
{"movq",     2, 0x0f6e, X, Cpu64,	NoSuf|IgnoreSize|Modrm, { Reg64|LLongMem, RegMMX, 0 } },
{"movq",     2, 0x0f7e, X, Cpu64,	NoSuf|IgnoreSize|Modrm, { RegMMX, Reg64|LLongMem, 0 } },
{"movq",     2, 0x660f6e,X,Cpu64,	NoSuf|IgnoreSize|Modrm, { Reg64|LLongMem, RegXMM, 0 } },
{"movq",     2, 0x660f7e,X,Cpu64,	NoSuf|IgnoreSize|Modrm, { RegXMM, Reg64|LLongMem, 0 } },
/* We put the 64bit displacement first and we only mark constants
   larger than 32bit as Disp64.  */
{"movq",   2,   0xa0, X, Cpu64,  NoSuf|D|W|Size64, { Disp64, Acc, 0 } },
{"movq",   2,	0x88, X, Cpu64,	 NoSuf|D|W|Modrm|Size64,{ Reg64, Reg64|AnyMem, 0 } },
{"movq",   2,	0xc6, 0, Cpu64,	 NoSuf|W|Modrm|Size64,	{ Imm32S, Reg64|WordMem, 0 } },
{"movq",   2,	0xb0, X, Cpu64,	 NoSuf|W|ShortForm|Size64,{ Imm64, Reg64, 0 } },
/* The segment register moves accept Reg64 so that a segment register
   can be copied to a 64 bit register, and vice versa.  */
{"movq",   2,	0x8c, X, Cpu64,  NoSuf|Modrm|Size64,	{ SReg2|SReg3, Reg64|RegMem, 0 } },
{"movq",   2,	0x8e, X, Cpu64,	 NoSuf|Modrm|Size64,	{ Reg64, SReg2|SReg3, 0 } },
/* Move to/from control debug registers.  In the 16 or 32bit modes they are 32bit.  In the 64bit
   mode they are 64bit.*/
{"movq",   2, 0x0f20, X, Cpu64,	 NoSuf|D|Modrm|IgnoreSize|NoRex64|Size64,{ Control, Reg64|RegMem, 0} },
{"movq",   2, 0x0f21, X, Cpu64,	 NoSuf|D|Modrm|IgnoreSize|NoRex64|Size64,{ Debug, Reg64|RegMem, 0} },
/* Real MMX instructions.  */
{"packssdw", 2, 0x0f6b, X, CpuMMX, NoSuf|IgnoreSize|Modrm, { RegMMX|LongMem, RegMMX, 0 } },
{"packssdw", 2, 0x660f6b,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"packsswb", 2, 0x0f63, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"packsswb", 2, 0x660f63,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"packuswb", 2, 0x0f67, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"packuswb", 2, 0x660f67,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddb",    2, 0x0ffc, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddb",    2, 0x660ffc,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddw",    2, 0x0ffd, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddw",    2, 0x660ffd,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddd",    2, 0x0ffe, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddd",    2, 0x660ffe,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddq",    2, 0x0fd4, X, CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegMMX|LLongMem, RegMMX, 0 } },
{"paddq",    2, 0x660fd4,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddsb",   2, 0x0fec, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddsb",   2, 0x660fec,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddsw",   2, 0x0fed, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddsw",   2, 0x660fed,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddusb",  2, 0x0fdc, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddusb",  2, 0x660fdc,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"paddusw",  2, 0x0fdd, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"paddusw",  2, 0x660fdd,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pand",     2, 0x0fdb, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pand",     2, 0x660fdb,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pandn",    2, 0x0fdf, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pandn",    2, 0x660fdf,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpeqb",  2, 0x0f74, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pcmpeqb",  2, 0x660f74,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpeqw",  2, 0x0f75, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pcmpeqw",  2, 0x660f75,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpeqd",  2, 0x0f76, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pcmpeqd",  2, 0x660f76,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpgtb",  2, 0x0f64, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pcmpgtb",  2, 0x660f64,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpgtw",  2, 0x0f65, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pcmpgtw",  2, 0x660f65,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpgtd",  2, 0x0f66, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pcmpgtd",  2, 0x660f66,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmaddwd",  2, 0x0ff5, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pmaddwd",  2, 0x660ff5,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmulhw",   2, 0x0fe5, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pmulhw",   2, 0x660fe5,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmullw",   2, 0x0fd5, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pmullw",   2, 0x660fd5,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"por",	     2, 0x0feb, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"por",	     2, 0x660feb,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psllw",    2, 0x0ff1, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psllw",    2, 0x660ff1,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psllw",    2, 0x0f71, 6, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psllw",    2, 0x660f71,6,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"pslld",    2, 0x0ff2, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pslld",    2, 0x660ff2,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pslld",    2, 0x0f72, 6, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"pslld",    2, 0x660f72,6,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psllq",    2, 0x0ff3, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psllq",    2, 0x660ff3,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psllq",    2, 0x0f73, 6, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psllq",    2, 0x660f73,6,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psraw",    2, 0x0fe1, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psraw",    2, 0x660fe1,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psraw",    2, 0x0f71, 4, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psraw",    2, 0x660f71,4,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psrad",    2, 0x0fe2, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psrad",    2, 0x660fe2,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psrad",    2, 0x0f72, 4, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psrad",    2, 0x660f72,4,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psrlw",    2, 0x0fd1, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psrlw",    2, 0x660fd1,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psrlw",    2, 0x0f71, 2, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psrlw",    2, 0x660f71,2,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psrld",    2, 0x0fd2, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psrld",    2, 0x660fd2,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psrld",    2, 0x0f72, 2, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psrld",    2, 0x660f72,2,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psrlq",    2, 0x0fd3, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psrlq",    2, 0x660fd3,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psrlq",    2, 0x0f73, 2, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ Imm8, RegMMX, 0 } },
{"psrlq",    2, 0x660f73,2,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ Imm8, RegXMM, 0 } },
{"psubb",    2, 0x0ff8, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubb",    2, 0x660ff8,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubw",    2, 0x0ff9, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubw",    2, 0x660ff9,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubd",    2, 0x0ffa, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubd",    2, 0x660ffa,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubq",    2, 0x0ffb, X, CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegMMX|LLongMem, RegMMX, 0 } },
{"psubq",    2, 0x660ffb,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubsb",   2, 0x0fe8, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubsb",   2, 0x660fe8,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubsw",   2, 0x0fe9, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubsw",   2, 0x660fe9,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubusb",  2, 0x0fd8, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubusb",  2, 0x660fd8,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"psubusw",  2, 0x0fd9, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"psubusw",  2, 0x660fd9,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpckhbw",2, 0x0f68, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"punpckhbw",2, 0x660f68,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpckhwd",2, 0x0f69, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"punpckhwd",2, 0x660f69,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpckhdq",2, 0x0f6a, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"punpckhdq",2, 0x660f6a,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpcklbw",2, 0x0f60, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"punpcklbw",2, 0x660f60,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpcklwd",2, 0x0f61, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"punpcklwd",2, 0x660f61,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpckldq",2, 0x0f62, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"punpckldq",2, 0x660f62,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },
{"pxor",     2, 0x0fef, X, CpuMMX, NoSuf|IgnoreSize|Modrm,		{ RegMMX|LongMem, RegMMX, 0 } },
{"pxor",     2, 0x660fef,X,CpuSSE2,NoSuf|IgnoreSize|Modrm,		{ RegXMM|LLongMem, RegXMM, 0 } },

/* PIII Katmai New Instructions / SIMD instructions.  */

{"addps",     2, 0x0f58,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"addss",     2, 0xf30f58,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"andnps",    2, 0x0f55,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"andps",     2, 0x0f54,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpeqps",   2, 0x0fc2,    0, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpeqss",   2, 0xf30fc2,  0, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpleps",   2, 0x0fc2,    2, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpless",   2, 0xf30fc2,  2, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpltps",   2, 0x0fc2,    1, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpltss",   2, 0xf30fc2,  1, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpneqps",  2, 0x0fc2,    4, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpneqss",  2, 0xf30fc2,  4, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpnleps",  2, 0x0fc2,    6, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpnless",  2, 0xf30fc2,  6, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpnltps",  2, 0x0fc2,    5, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpnltss",  2, 0xf30fc2,  5, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpordps",  2, 0x0fc2,    7, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpordss",  2, 0xf30fc2,  7, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpunordps",2, 0x0fc2,    3, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpunordss",2, 0xf30fc2,  3, CpuSSE, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpps",     3, 0x0fc2,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"cmpss",     3, 0xf30fc2,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|WordMem, RegXMM } },
{"comiss",    2, 0x0f2f,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cvtpi2ps",  2, 0x0f2a,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegXMM, 0 } },
{"cvtps2pi",  2, 0x0f2d,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegMMX, 0 } },
{"cvtsi2ss",  2, 0xf30f2a,  X, CpuSSE, lq_Suf|IgnoreSize|Modrm,{ Reg32|Reg64|WordMem|LLongMem, RegXMM, 0 } },
{"cvtss2si",  2, 0xf30f2d,  X, CpuSSE, lq_Suf|IgnoreSize|Modrm,{ RegXMM|WordMem, Reg32|Reg64, 0 } },
{"cvttps2pi", 2, 0x0f2c,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegMMX, 0 } },
{"cvttss2si", 2, 0xf30f2c,  X, CpuSSE, lq_Suf|IgnoreSize|Modrm,	{ RegXMM|WordMem, Reg32|Reg64, 0 } },
{"divps",     2, 0x0f5e,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"divss",     2, 0xf30f5e,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"ldmxcsr",   1, 0x0fae,    2, CpuSSE, NoSuf|IgnoreSize|Modrm, 	{ WordMem, 0, 0 } },
{"maskmovq",  2, 0x0ff7,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX, RegMMX, 0 } },
{"maxps",     2, 0x0f5f,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"maxss",     2, 0xf30f5f,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"minps",     2, 0x0f5d,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"minss",     2, 0xf30f5d,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"movaps",    2, 0x0f28,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movaps",    2, 0x0f29,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LLongMem, 0 } },
{"movhlps",   2, 0x0f12,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM, 0 } },
{"movhps",    2, 0x0f16,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ LLongMem, RegXMM, 0 } },
{"movhps",    2, 0x0f17,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, LLongMem, 0 } },
{"movlhps",   2, 0x0f16,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM, 0 } },
{"movlps",    2, 0x0f12,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ LLongMem, RegXMM, 0 } },
{"movlps",    2, 0x0f13,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, LLongMem, 0 } },
{"movmskps",  2, 0x0f50,    X, CpuSSE, lq_Suf|IgnoreSize|Modrm,	{ RegXMM, Reg32|Reg64, 0 } },
{"movntps",   2, 0x0f2b,    X, CpuSSE, NoSuf|IgnoreSize|Modrm, 	{ RegXMM, LLongMem, 0 } },
{"movntq",    2, 0x0fe7,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm, 	{ RegMMX, LLongMem, 0 } },
{"movntdq",   2, 0x660fe7,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm, 	{ RegXMM, LLongMem, 0 } },
{"movss",     2, 0xf30f10,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"movss",     2, 0xf30f11,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|WordMem, 0 } },
{"movups",    2, 0x0f10,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movups",    2, 0x0f11,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LLongMem, 0 } },
{"mulps",     2, 0x0f59,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"mulss",     2, 0xf30f59,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"orps",      2, 0x0f56,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pavgb",     2, 0x0fe0,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pavgb",     2, 0x660fe0,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pavgw",     2, 0x0fe3,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pavgw",     2, 0x660fe3,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pextrw",    3, 0x0fc5,    X, CpuMMX2,lq_Suf|IgnoreSize|Modrm,	{ Imm8, RegMMX, Reg32|Reg64 } },
{"pextrw",    3, 0x660fc5,  X, CpuSSE2,lq_Suf|IgnoreSize|Modrm,	{ Imm8, RegXMM, Reg32|Reg64 } },

/* Streaming SIMD extensions 4.1 Instructions.  */
{"pextrw",    3, 0x660f3a15,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm, { Imm8, RegXMM, Reg32|Reg64|ShortMem } },

{"pinsrw",    3, 0x0fc4,    X, CpuMMX2,lq_Suf|IgnoreSize|Modrm,	{ Imm8, Reg32|Reg64|ShortMem, RegMMX } },
{"pinsrw",    3, 0x660fc4,  X, CpuSSE2,lq_Suf|IgnoreSize|Modrm,	{ Imm8, Reg32|Reg64|ShortMem, RegXMM } },
{"pmaxsw",    2, 0x0fee,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pmaxsw",    2, 0x660fee,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmaxub",    2, 0x0fde,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pmaxub",    2, 0x660fde,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pminsw",    2, 0x0fea,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pminsw",    2, 0x660fea,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pminub",    2, 0x0fda,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pminub",    2, 0x660fda,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovmskb",  2, 0x0fd7,    X, CpuMMX2,lq_Suf|IgnoreSize|Modrm,	{ RegMMX, Reg32|Reg64, 0 } },
{"pmovmskb",  2, 0x660fd7,  X, CpuSSE2,lq_Suf|IgnoreSize|Modrm,	{ RegXMM, Reg32|Reg64, 0 } },
{"pmulhuw",   2, 0x0fe4,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"pmulhuw",   2, 0x660fe4,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"prefetchnta", 1, 0x0f18,  0, CpuMMX2,NoSuf|IgnoreSize|Modrm, 	{ LLongMem, 0, 0 } },
{"prefetcht0",  1, 0x0f18,  1, CpuMMX2,NoSuf|IgnoreSize|Modrm, 	{ LLongMem, 0, 0 } },
{"prefetcht1",  1, 0x0f18,  2, CpuMMX2,NoSuf|IgnoreSize|Modrm, 	{ LLongMem, 0, 0 } },
{"prefetcht2",  1, 0x0f18,  3, CpuMMX2,NoSuf|IgnoreSize|Modrm, 	{ LLongMem, 0, 0 } },
{"psadbw",    2, 0x0ff6,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegMMX, 0 } },
{"psadbw",    2, 0x660ff6,  X, CpuSSE2,NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pshufw",    3, 0x0f70,    X, CpuMMX2,NoSuf|IgnoreSize|Modrm,	{ Imm8, RegMMX|LLongMem, RegMMX } },
{"rcpps",     2, 0x0f53,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"rcpss",     2, 0xf30f53,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"rsqrtps",   2, 0x0f52,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"rsqrtss",   2, 0xf30f52,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"sfence",    0, 0x0fae, 0xf8, CpuMMX2,NoSuf|IgnoreSize|ImmExt,	{ 0, 0, 0 } },
{"shufps",    3, 0x0fc6,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"sqrtps",    2, 0x0f51,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"sqrtss",    2, 0xf30f51,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"stmxcsr",   1, 0x0fae,    3, CpuSSE, NoSuf|IgnoreSize|Modrm, 	{ WordMem, 0, 0 } },
{"subps",     2, 0x0f5c,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"subss",     2, 0xf30f5c,  X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"ucomiss",   2, 0x0f2e,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"unpckhps",  2, 0x0f15,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"unpcklps",  2, 0x0f14,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"xorps",     2, 0x0f57,    X, CpuSSE, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },

/* SSE-2 instructions.  */

{"addpd",     2, 0x660f58,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"addsd",     2, 0xf20f58,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"andnpd",    2, 0x660f55,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"andpd",     2, 0x660f54,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|WordMem, RegXMM, 0 } },
{"cmpeqpd",   2, 0x660fc2,  0, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpeqsd",   2, 0xf20fc2,  0, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmplepd",   2, 0x660fc2,  2, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmplesd",   2, 0xf20fc2,  2, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmpltpd",   2, 0x660fc2,  1, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpltsd",   2, 0xf20fc2,  1, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmpneqpd",  2, 0x660fc2,  4, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpneqsd",  2, 0xf20fc2,  4, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmpnlepd",  2, 0x660fc2,  6, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpnlesd",  2, 0xf20fc2,  6, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmpnltpd",  2, 0x660fc2,  5, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpnltsd",  2, 0xf20fc2,  5, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmpordpd",  2, 0x660fc2,  7, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpordsd",  2, 0xf20fc2,  7, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmpunordpd",2, 0x660fc2,  3, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpunordsd",2, 0xf20fc2,  3, CpuSSE2, NoSuf|IgnoreSize|Modrm|ImmExt,{ RegXMM|LongMem, RegXMM, 0 } },
{"cmppd",     3, 0x660fc2,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
/* Intel mode string compare.  */
{"cmpsd",     0, 0xa7,      X, 0, NoSuf|Size32|IsString, { 0, 0, 0} },
{"cmpsd",     2, 0xa7,      X, 0, NoSuf|Size32|IsString, { AnyMem, AnyMem|EsSeg, 0} },
{"cmpsd",     3, 0xf20fc2,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LongMem, RegXMM } },
{"comisd",    2, 0x660f2f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"cvtpi2pd",  2, 0x660f2a,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LLongMem, RegXMM, 0 } },
{"cvtsi2sd",  2, 0xf20f2a,  X, CpuSSE2, lq_Suf|IgnoreSize|Modrm,{ Reg32|Reg64|WordMem|LLongMem, RegXMM, 0 } },
{"divpd",     2, 0x660f5e,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"divsd",     2, 0xf20f5e,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"maxpd",     2, 0x660f5f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"maxsd",     2, 0xf20f5f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"minpd",     2, 0x660f5d,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"minsd",     2, 0xf20f5d,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"movapd",    2, 0x660f28,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movapd",    2, 0x660f29,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LLongMem, 0 } },
{"movhpd",    2, 0x660f16,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ LLongMem, RegXMM, 0 } },
{"movhpd",    2, 0x660f17,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, LLongMem, 0 } },
{"movlpd",    2, 0x660f12,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ LLongMem, RegXMM, 0 } },
{"movlpd",    2, 0x660f13,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, LLongMem, 0 } },
{"movmskpd",  2, 0x660f50,  X, CpuSSE2, lq_Suf|IgnoreSize|Modrm, { RegXMM, Reg32|Reg64, 0 } },
{"movntpd",   2, 0x660f2b,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm, 	{ RegXMM, LLongMem, 0 } },
/* Intel mode string move.  */
{"movsd",     0, 0xa5,      X, 0, NoSuf|Size32|IsString, { 0, 0, 0} },
{"movsd",     2, 0xa5,      X, 0, NoSuf|Size32|IsString, { AnyMem, AnyMem|EsSeg, 0} },
{"movsd",     2, 0xf20f10,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"movsd",     2, 0xf20f11,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LongMem, 0 } },
{"movupd",    2, 0x660f10,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movupd",    2, 0x660f11,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LLongMem, 0 } },
{"mulpd",     2, 0x660f59,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"mulsd",     2, 0xf20f59,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"orpd",      2, 0x660f56,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"shufpd",    3, 0x660fc6,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"sqrtpd",    2, 0x660f51,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"sqrtsd",    2, 0xf20f51,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"subpd",     2, 0x660f5c,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"subsd",     2, 0xf20f5c,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"ucomisd",   2, 0x660f2e,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"unpckhpd",  2, 0x660f15,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"unpcklpd",  2, 0x660f14,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"xorpd",     2, 0x660f57,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtdq2pd",  2, 0xf30fe6,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtpd2dq",  2, 0xf20fe6,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtdq2ps",  2, 0x0f5b,    X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtpd2pi",  2, 0x660f2d,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegMMX, 0 } },
{"cvtpd2ps",  2, 0x660f5a,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtps2pd",  2, 0x0f5a,    X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtps2dq",  2, 0x660f5b,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtsd2si",  2, 0xf20f2d,  X, CpuSSE2, lq_Suf|IgnoreSize|Modrm,{ RegXMM|LLongMem, Reg32|Reg64, 0 } },
{"cvtsd2ss",  2, 0xf20f5a,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvtss2sd",  2, 0xf30f5a,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvttpd2pi", 2, 0x660f2c,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegMMX, 0 } },
{"cvttsd2si", 2, 0xf20f2c,  X, CpuSSE2, lq_Suf|IgnoreSize|Modrm,{ RegXMM|WordMem, Reg32|Reg64, 0 } },
{"cvttpd2dq", 2, 0x660fe6,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cvttps2dq", 2, 0xf30f5b,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"maskmovdqu",2, 0x660ff7,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM, 0 } },
{"movdqa",    2, 0x660f6f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movdqa",    2, 0x660f7f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LLongMem, 0 } },
{"movdqu",    2, 0xf30f6f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movdqu",    2, 0xf30f7f,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegXMM|LLongMem, 0 } },
{"movdq2q",    2, 0xf20fd6,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM, RegMMX, 0 } },
{"movq2dq",   2, 0xf30fd6,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegMMX, RegXMM, 0 } },
{"pmuludq",   2, 0x0ff4,    X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pmuludq",   2, 0x660ff4,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"pshufd",    3, 0x660f70,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pshufhw",   3, 0xf30f70,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pshuflw",   3, 0xf20f70,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pslldq",    2, 0x660f73,  7, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM, 0 } },
{"psrldq",    2, 0x660f73,  3, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM, 0 } },
{"punpckhqdq",2, 0x660f6d,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"punpcklqdq",2, 0x660f6c,  X, CpuSSE2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },

/* SSE-3 instructions.  */

{"addsubpd",  2, 0x660fd0,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"addsubps",  2, 0xf20fd0,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"cmpxchg16b",1, 0x0fc7,    1, CpuSSE3|Cpu64, NoSuf|Modrm|Rex64, { LLongMem, 0, 0} },
{"fisttp",    1, 0xdf,      1, CpuSSE3, sl_FP|Modrm,	{ ShortMem|LongMem, 0, 0} },
{"fisttp",    1, 0xdd,      1, CpuSSE3, q_FP|Modrm,	{ LLongMem, 0, 0} },
{"fisttpll",  1, 0xdd,      1, CpuSSE3, FP|Modrm,	{ LLongMem, 0, 0} },
{"haddpd",    2, 0x660f7c,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"haddps",    2, 0xf20f7c,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"hsubpd",    2, 0x660f7d,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"hsubps",    2, 0xf20f7d,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"lddqu",     2, 0xf20ff0,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ LLongMem, RegXMM, 0 } },
{"monitor",   0, 0x0f01, 0xc8, CpuSSE3, NoSuf|ImmExt,	{ 0, 0, 0} },
/* monitor is very special. CX and DX are always 64bits with zero upper
   32bits in 64bit mode, and 32bits in 16bit and 32bit modes. The
   address size override prefix can be used to overrride the AX size in
   all modes.  */
/* Need to ensure only "monitor %eax/%ax,%ecx,%edx" is accepted. */
{"monitor",   3, 0x0f01, 0xc8, CpuSSE3|CpuNo64, NoSuf|ImmExt,	{ Reg16|Reg32, Reg32, Reg32 } },
/* Need to ensure only "monitor %rax/%eax,%rcx,%rdx" is accepted. */
{"monitor",   3, 0x0f01, 0xc8, CpuSSE3|Cpu64, NoSuf|ImmExt|NoRex64,	{ Reg32|Reg64, Reg64, Reg64 } },
{"movddup",   2, 0xf20f12,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movshdup",  2, 0xf30f16,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"movsldup",  2, 0xf30f12,  X, CpuSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"mwait",     0, 0x0f01, 0xc9, CpuSSE3, NoSuf|ImmExt,	{ 0, 0, 0} },
/* mwait is very special. AX and CX are always 64bits with zero upper
   32bits in 64bit mode, and 32bits in 16bit and 32bit modes.  */
/* Need to ensure only "mwait %eax,%ecx" is accepted.  */
{"mwait",     2, 0x0f01, 0xc9, CpuSSE3|CpuNo64, NoSuf|ImmExt,	{ Reg32, Reg32, 0} },
/* Need to ensure only "mwait %rax,%rcx" is accepted.  */
{"mwait",     2, 0x0f01, 0xc9, CpuSSE3|Cpu64, NoSuf|ImmExt|NoRex64,	{ Reg64, Reg64, 0} },

/* VMX instructions.  */
{"vmcall",    0, 0x0f01, 0xc1, CpuVMX, NoSuf|ImmExt,	{ 0, 0, 0} },
{"vmclear",   1, 0x660fc7,  6, CpuVMX, NoSuf|IgnoreSize|Modrm|NoRex64,	{ LLongMem, 0, 0} },
{"vmlaunch",  0, 0x0f01, 0xc2, CpuVMX, NoSuf|ImmExt,	{ 0, 0, 0} },
{"vmresume",  0, 0x0f01, 0xc3, CpuVMX, NoSuf|ImmExt,	{ 0, 0, 0} },
{"vmptrld",   1, 0x0fc7,    6, CpuVMX, NoSuf|IgnoreSize|Modrm|NoRex64,	{ LLongMem, 0, 0} },
{"vmptrst",   1, 0x0fc7,    7, CpuVMX, NoSuf|IgnoreSize|Modrm|NoRex64,	{ LLongMem, 0, 0} },
{"vmread",    2, 0x0f78,    X, CpuVMX|CpuNo64, l_Suf|Modrm,{ Reg32, Reg32|LongMem, 0} },
{"vmread",    2, 0x0f78,    X, CpuVMX|Cpu64, q_Suf|Modrm|NoRex64,{ Reg64, Reg64|LLongMem, 0} },
{"vmwrite",   2, 0x0f79,    X, CpuVMX|CpuNo64, l_Suf|Modrm,{ Reg32|LongMem, Reg32, 0} },
{"vmwrite",   2, 0x0f79,    X, CpuVMX|Cpu64, q_Suf|Modrm|NoRex64,{ Reg64|LLongMem, Reg64, 0} },
{"vmxoff",    0, 0x0f01, 0xc4, CpuVMX, NoSuf|ImmExt,	{ 0, 0, 0} },
{"vmxon",     1, 0xf30fc7,  6, CpuVMX, NoSuf|IgnoreSize|Modrm|NoRex64,	{ LLongMem, 0, 0} },

/* Supplemental Streaming SIMD extensions 3 Instructions.  */

{"phaddw",    2,   0x0f3801,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"phaddw",    2, 0x660f3801,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"phaddd",    2,   0x0f3802,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"phaddd",    2, 0x660f3802,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"phaddsw",   2,   0x0f3803,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"phaddsw",   2, 0x660f3803,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"phsubw",    2,   0x0f3805,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"phsubw",    2, 0x660f3805,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"phsubd",    2,   0x0f3806,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"phsubd",    2, 0x660f3806,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"phsubsw",   2,   0x0f3807,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"phsubsw",   2, 0x660f3807,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmaddubsw", 2,   0x0f3804,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pmaddubsw", 2, 0x660f3804,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmulhrsw", 2,    0x0f380b,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pmulhrsw", 2,  0x660f380b,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pshufb",   2,    0x0f3800,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pshufb",   2,  0x660f3800,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"psignb",   2,    0x0f3808,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"psignb",   2,  0x660f3808,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"psignw",   2,    0x0f3809,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"psignw",   2,  0x660f3809,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"psignd",   2,    0x0f380a,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"psignd",   2,  0x660f380a,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"palignr",  3,    0x0f3a0f,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegMMX|LongMem, RegMMX } },
{"palignr",  3,  0x660f3a0f,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pabsb",    2,    0x0f381c,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pabsb",    2,  0x660f381c,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pabsw",    2,    0x0f381d,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pabsw",    2,  0x660f381d,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pabsd",    2,    0x0f381e,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pabsd",    2,  0x660f381e,X, CpuSSSE3, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },

/* Streaming SIMD extensions 4.1 Instructions.  */

{"blendpd",  3,  0x660f3a0d,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"blendps",  3,  0x660f3a0c,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"blendvpd", 3,  0x660f3815,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm|regKludge, { RegXMM, RegXMM|LLongMem, RegXMM } },
{"blendvps", 3,  0x660f3814,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm|regKludge, { RegXMM, RegXMM|LLongMem, RegXMM } },
{"dppd",     3,  0x660f3a41,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"dpps",     3,  0x660f3a40,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"extractps",3,  0x660f3a17,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM, Reg32|Reg64|LongMem } },
{"insertps", 3,  0x660f3a21,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LongMem, RegXMM } },
{"movntdqa", 2,  0x660f382a,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ LLongMem, RegXMM, 0 } },
{"mpsadbw",  3,  0x660f3a42,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"packusdw", 2,  0x660f382b,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pblendvb", 3,  0x660f3810,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm|regKludge, { RegXMM, RegXMM|LLongMem, RegXMM } },
{"pblendw",  3,  0x660f3a0e,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pcmpeqq",  2,  0x660f3829,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pextrb",   3,  0x660f3a14,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM, Reg32|Reg64|ByteMem } },
{"pextrd",   3,  0x660f3a16,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM, Reg32|LongMem } },
{"pextrq",   3,  0x660f3a16,X, CpuSSE4_1|Cpu64, NoSuf|IgnoreSize|Modrm|Size64, { Imm8, RegXMM, Reg64|LLongMem } },
{"phminposuw",2, 0x660f3841,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pinsrb",   3,  0x660f3a20,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, Reg32|Reg64|ByteMem, RegXMM } },
{"pinsrd",   3,  0x660f3a22,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, Reg32|LongMem, RegXMM } },
{"pinsrq",   3,  0x660f3a22,X, CpuSSE4_1|Cpu64, NoSuf|IgnoreSize|Modrm|Size64, { Imm8, Reg64|LLongMem, RegXMM } },
{"pmaxsb",   2,  0x660f383c,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmaxsd",   2,  0x660f383d,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmaxud",   2,  0x660f383f,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmaxuw",   2,  0x660f383e,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pminsb",   2,  0x660f3838,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pminsd",   2,  0x660f3839,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pminud",   2,  0x660f383b,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pminuw",   2,  0x660f383a,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovsxbw", 2,  0x660f3820,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovsxbd", 2,  0x660f3821,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"pmovsxbq", 2,  0x660f3822,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|ShortMem, RegXMM, 0 } },
{"pmovsxwd", 2,  0x660f3823,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovsxwq", 2,  0x660f3824,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"pmovsxdq", 2,  0x660f3825,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovzxbw", 2,  0x660f3830,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovzxbd", 2,  0x660f3831,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"pmovzxbq", 2,  0x660f3832,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|ShortMem, RegXMM, 0 } },
{"pmovzxwd", 2,  0x660f3833,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmovzxwq", 2,  0x660f3834,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LongMem, RegXMM, 0 } },
{"pmovzxdq", 2,  0x660f3835,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmuldq",   2,  0x660f3828,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pmulld",   2,  0x660f3840,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"ptest",    2,  0x660f3817,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"roundpd",  3,  0x660f3a09,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"roundps",  3,  0x660f3a08,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"roundsd",  3,  0x660f3a0b,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"roundss",  3,  0x660f3a0a,X, CpuSSE4_1, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LongMem, RegXMM } },

/* Streaming SIMD extensions 4.2 Instructions.  */

{"pcmpgtq",   2,  0x660f3837,X, CpuSSE4_2, NoSuf|IgnoreSize|Modrm,	{ RegXMM|LLongMem, RegXMM, 0 } },
{"pcmpestri", 3,  0x660f3a61,X, CpuSSE4_2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pcmpestrm", 3,  0x660f3a60,X, CpuSSE4_2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pcmpistri", 3,  0x660f3a63,X, CpuSSE4_2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
{"pcmpistrm", 3,  0x660f3a62,X, CpuSSE4_2, NoSuf|IgnoreSize|Modrm,	{ Imm8, RegXMM|LLongMem, RegXMM } },
/* We put non-8bit version before 8bit so that crc32 with memory operand
   defaults to non-8bit.  */
{"crc32",     2,  0xf20f38f1,X, CpuSSE4_2, wl_Suf|Modrm,		{ Reg16|Reg32|ShortMem|LongMem, Reg32, 0 } },
{"crc32",     2,  0xf20f38f1,X, CpuSSE4_2|Cpu64, q_Suf|Modrm|Rex64,	{ Reg64|LLongMem, Reg64, 0 } },
{"crc32",     2,  0xf20f38f0,X, CpuSSE4_2, b_Suf|Modrm,			{ Reg8|ByteMem, Reg32, 0 } },
{"crc32",     2,  0xf20f38f0,X, CpuSSE4_2|Cpu64, b_Suf|Modrm|Rex64,	{ Reg8|ByteMem, Reg64, 0 } },

/* AMD 3DNow! instructions.  */

{"prefetch", 1, 0x0f0d,	   0, Cpu3dnow, NoSuf|IgnoreSize|Modrm,	{ ByteMem, 0, 0 } },
{"prefetchw",1, 0x0f0d,	   1, Cpu3dnow, NoSuf|IgnoreSize|Modrm,	{ ByteMem, 0, 0 } },
{"femms",    0, 0x0f0e,	   X, Cpu3dnow, NoSuf,			{ 0, 0, 0 } },
{"pavgusb",  2, 0x0f0f, 0xbf, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pf2id",    2, 0x0f0f, 0x1d, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pf2iw",    2, 0x0f0f, 0x1c, Cpu3dnowA,NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfacc",    2, 0x0f0f, 0xae, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfadd",    2, 0x0f0f, 0x9e, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfcmpeq",  2, 0x0f0f, 0xb0, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfcmpge",  2, 0x0f0f, 0x90, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfcmpgt",  2, 0x0f0f, 0xa0, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfmax",    2, 0x0f0f, 0xa4, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfmin",    2, 0x0f0f, 0x94, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfmul",    2, 0x0f0f, 0xb4, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfnacc",   2, 0x0f0f, 0x8a, Cpu3dnowA,NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfpnacc",  2, 0x0f0f, 0x8e, Cpu3dnowA,NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfrcp",    2, 0x0f0f, 0x96, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfrcpit1", 2, 0x0f0f, 0xa6, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfrcpit2", 2, 0x0f0f, 0xb6, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfrsqit1", 2, 0x0f0f, 0xa7, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfrsqrt",  2, 0x0f0f, 0x97, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfsub",    2, 0x0f0f, 0x9a, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pfsubr",   2, 0x0f0f, 0xaa, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pi2fd",    2, 0x0f0f, 0x0d, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pi2fw",    2, 0x0f0f, 0x0c, Cpu3dnowA,NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pmulhrw",  2, 0x0f0f, 0xb7, Cpu3dnow, NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },
{"pswapd",   2, 0x0f0f, 0xbb, Cpu3dnowA,NoSuf|IgnoreSize|Modrm|ImmExt,	{ RegMMX|LongMem, RegMMX, 0 } },

/* AMD extensions. */
{"syscall",  0, 0x0f05,    X, CpuK6,	NoSuf,			{ 0, 0, 0} },
{"sysret",   0, 0x0f07,    X, CpuK6,	lq_Suf|DefaultSize,	{ 0, 0, 0} },
{"swapgs",   0, 0x0f01, 0xf8, Cpu64,	NoSuf|ImmExt,		{ 0, 0, 0} },
{"rdtscp",   0, 0x0f01, 0xf9, CpuSledgehammer,NoSuf|ImmExt,	{ 0, 0, 0} },

/* AMD Pacifica additions.  */
{"clgi",     0, 0x0f01, 0xdd, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"invlpga",  0, 0x0f01, 0xdf, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
/* Need to ensure only "invlpga ...,%ecx" is accepted.  */
{"invlpga",  2, 0x0f01, 0xdf, CpuSVME,	NoSuf|ImmExt,		{ AnyMem, Reg32, 0 } },
{"skinit",   0, 0x0f01, 0xde, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"skinit",   1, 0x0f01, 0xde, CpuSVME,	NoSuf|ImmExt,		{ AnyMem, 0, 0 } },
{"stgi",     0, 0x0f01, 0xdc, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"vmload",   0, 0x0f01, 0xda, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"vmload",   1, 0x0f01, 0xda, CpuSVME,	NoSuf|ImmExt,		{ AnyMem, 0, 0 } },
{"vmmcall",  0, 0x0f01, 0xd9, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"vmrun",    0, 0x0f01, 0xd8, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"vmrun",    1, 0x0f01, 0xd8, CpuSVME,	NoSuf|ImmExt,		{ AnyMem, 0, 0 } },
{"vmsave",   0, 0x0f01, 0xdb, CpuSVME,	NoSuf|ImmExt,		{ 0, 0, 0 } },
{"vmsave",   1, 0x0f01, 0xdb, CpuSVME,	NoSuf|ImmExt,		{ AnyMem, 0, 0 } },


/* SSE4a instructions */
{"movntsd",  2, 0xf20f2b,  X, CpuSSE4a, NoSuf|IgnoreSize|Modrm, { RegXMM, LongMem, 0 } },
{"movntss",  2, 0xf30f2b,  X, CpuSSE4a, NoSuf|IgnoreSize|Modrm, { RegXMM, WordMem, 0 } },
{"extrq",    3, 0x660f78,  0, CpuSSE4a, NoSuf|IgnoreSize|Modrm, { Imm8, Imm8, RegXMM } },
{"extrq",    2, 0x660f79,  X, CpuSSE4a, NoSuf|IgnoreSize|Modrm, { RegXMM, RegXMM} },
{"insertq",  2, 0xf20f79,  X, CpuSSE4a, NoSuf|IgnoreSize|Modrm, { RegXMM, RegXMM} },
{"insertq",  4, 0xf20f78,  X, CpuSSE4a, NoSuf|IgnoreSize|Modrm, { Imm8, Imm8, RegXMM, RegXMM} },

/* ABM instructions */
{"popcnt",   2, 0xf30fb8,  X, CpuABM|CpuSSE4_2, wlq_Suf|Modrm,	{ WordReg|WordMem, WordReg, 0} },
{"lzcnt",    2, 0xf30fbd,  X, CpuABM, wlq_Suf|Modrm,          { WordReg|WordMem, WordReg, 0} },


/* VIA PadLock extensions.  */
{"xstore-rng",0, 0x000fa7, 0xc0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcrypt-ecb",0, 0xf30fa7, 0xc8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcrypt-cbc",0, 0xf30fa7, 0xd0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcrypt-ctr",0, 0xf30fa7, 0xd8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcrypt-cfb",0, 0xf30fa7, 0xe0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcrypt-ofb",0, 0xf30fa7, 0xe8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"montmul",   0, 0xf30fa6, 0xc0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xsha1",     0, 0xf30fa6, 0xc8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xsha256",   0, 0xf30fa6, 0xd0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
/* Aliases without hyphens.  */
{"xstorerng", 0, 0x000fa7, 0xc0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcryptecb", 0, 0xf30fa7, 0xc8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcryptcbc", 0, 0xf30fa7, 0xd0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcryptctr", 0, 0xf30fa7, 0xd8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcryptcfb", 0, 0xf30fa7, 0xe0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
{"xcryptofb", 0, 0xf30fa7, 0xe8, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },
/* Alias for xstore-rng.  */
{"xstore",    0, 0x000fa7, 0xc0, Cpu686|CpuPadLock, NoSuf|IsString|ImmExt, { 0, 0, 0} },

/* sentinel */
{NULL, 0, 0, 0, 0, 0, { 0, 0, 0} }
};

/* 386 register table.  */

const reg_entry i386_regtab[] =
{
  /* Make %st first as we test for it.  */
  {"st", FloatReg|FloatAcc, 0, 0},
  /* 8 bit regs */
  {"al", Reg8|Acc, 0, 0},
  {"cl", Reg8|ShiftCount, 0, 1},
  {"dl", Reg8, 0, 2},
  {"bl", Reg8, 0, 3},
  {"ah", Reg8, 0, 4},
  {"ch", Reg8, 0, 5},
  {"dh", Reg8, 0, 6},
  {"bh", Reg8, 0, 7},
  {"axl", Reg8|Acc, RegRex64, 0},  /* Must be in the "al + 8" slot.  */
  {"cxl", Reg8, RegRex64, 1},
  {"dxl", Reg8, RegRex64, 2},
  {"bxl", Reg8, RegRex64, 3},
  {"spl", Reg8, RegRex64, 4},
  {"bpl", Reg8, RegRex64, 5},
  {"sil", Reg8, RegRex64, 6},
  {"dil", Reg8, RegRex64, 7},
  {"r8b", Reg8, RegRex64|RegRex, 0},
  {"r9b", Reg8, RegRex64|RegRex, 1},
  {"r10b", Reg8, RegRex64|RegRex, 2},
  {"r11b", Reg8, RegRex64|RegRex, 3},
  {"r12b", Reg8, RegRex64|RegRex, 4},
  {"r13b", Reg8, RegRex64|RegRex, 5},
  {"r14b", Reg8, RegRex64|RegRex, 6},
  {"r15b", Reg8, RegRex64|RegRex, 7},
  /* 16 bit regs */
  {"ax", Reg16|Acc, 0, 0},
  {"cx", Reg16, 0, 1},
  {"dx", Reg16|InOutPortReg, 0, 2},
  {"bx", Reg16|BaseIndex, 0, 3},
  {"sp", Reg16, 0, 4},
  {"bp", Reg16|BaseIndex, 0, 5},
  {"si", Reg16|BaseIndex, 0, 6},
  {"di", Reg16|BaseIndex, 0, 7},
  {"r8w", Reg16, RegRex, 0},
  {"r9w", Reg16, RegRex, 1},
  {"r10w", Reg16, RegRex, 2},
  {"r11w", Reg16, RegRex, 3},
  {"r12w", Reg16, RegRex, 4},
  {"r13w", Reg16, RegRex, 5},
  {"r14w", Reg16, RegRex, 6},
  {"r15w", Reg16, RegRex, 7},
  /* 32 bit regs */
  {"eax", Reg32|BaseIndex|Acc, 0, 0},  /* Must be in ax + 16 slot.  */
  {"ecx", Reg32|BaseIndex, 0, 1},
  {"edx", Reg32|BaseIndex, 0, 2},
  {"ebx", Reg32|BaseIndex, 0, 3},
  {"esp", Reg32, 0, 4},
  {"ebp", Reg32|BaseIndex, 0, 5},
  {"esi", Reg32|BaseIndex, 0, 6},
  {"edi", Reg32|BaseIndex, 0, 7},
  {"r8d", Reg32|BaseIndex, RegRex, 0},
  {"r9d", Reg32|BaseIndex, RegRex, 1},
  {"r10d", Reg32|BaseIndex, RegRex, 2},
  {"r11d", Reg32|BaseIndex, RegRex, 3},
  {"r12d", Reg32|BaseIndex, RegRex, 4},
  {"r13d", Reg32|BaseIndex, RegRex, 5},
  {"r14d", Reg32|BaseIndex, RegRex, 6},
  {"r15d", Reg32|BaseIndex, RegRex, 7},
  {"rax", Reg64|BaseIndex|Acc, 0, 0},
  {"rcx", Reg64|BaseIndex, 0, 1},
  {"rdx", Reg64|BaseIndex, 0, 2},
  {"rbx", Reg64|BaseIndex, 0, 3},
  {"rsp", Reg64, 0, 4},
  {"rbp", Reg64|BaseIndex, 0, 5},
  {"rsi", Reg64|BaseIndex, 0, 6},
  {"rdi", Reg64|BaseIndex, 0, 7},
  {"r8", Reg64|BaseIndex, RegRex, 0},
  {"r9", Reg64|BaseIndex, RegRex, 1},
  {"r10", Reg64|BaseIndex, RegRex, 2},
  {"r11", Reg64|BaseIndex, RegRex, 3},
  {"r12", Reg64|BaseIndex, RegRex, 4},
  {"r13", Reg64|BaseIndex, RegRex, 5},
  {"r14", Reg64|BaseIndex, RegRex, 6},
  {"r15", Reg64|BaseIndex, RegRex, 7},
  /* Segment registers.  */
  {"es", SReg2, 0, 0},
  {"cs", SReg2, 0, 1},
  {"ss", SReg2, 0, 2},
  {"ds", SReg2, 0, 3},
  {"fs", SReg3, 0, 4},
  {"gs", SReg3, 0, 5},
  /* Control registers.  */
  {"cr0", Control, 0, 0},
  {"cr1", Control, 0, 1},
  {"cr2", Control, 0, 2},
  {"cr3", Control, 0, 3},
  {"cr4", Control, 0, 4},
  {"cr5", Control, 0, 5},
  {"cr6", Control, 0, 6},
  {"cr7", Control, 0, 7},
  {"cr8", Control, RegRex, 0},
  {"cr9", Control, RegRex, 1},
  {"cr10", Control, RegRex, 2},
  {"cr11", Control, RegRex, 3},
  {"cr12", Control, RegRex, 4},
  {"cr13", Control, RegRex, 5},
  {"cr14", Control, RegRex, 6},
  {"cr15", Control, RegRex, 7},
  /* Debug registers.  */
  {"db0", Debug, 0, 0},
  {"db1", Debug, 0, 1},
  {"db2", Debug, 0, 2},
  {"db3", Debug, 0, 3},
  {"db4", Debug, 0, 4},
  {"db5", Debug, 0, 5},
  {"db6", Debug, 0, 6},
  {"db7", Debug, 0, 7},
  {"db8", Debug, RegRex, 0},
  {"db9", Debug, RegRex, 1},
  {"db10", Debug, RegRex, 2},
  {"db11", Debug, RegRex, 3},
  {"db12", Debug, RegRex, 4},
  {"db13", Debug, RegRex, 5},
  {"db14", Debug, RegRex, 6},
  {"db15", Debug, RegRex, 7},
  {"dr0", Debug, 0, 0},
  {"dr1", Debug, 0, 1},
  {"dr2", Debug, 0, 2},
  {"dr3", Debug, 0, 3},
  {"dr4", Debug, 0, 4},
  {"dr5", Debug, 0, 5},
  {"dr6", Debug, 0, 6},
  {"dr7", Debug, 0, 7},
  {"dr8", Debug, RegRex, 0},
  {"dr9", Debug, RegRex, 1},
  {"dr10", Debug, RegRex, 2},
  {"dr11", Debug, RegRex, 3},
  {"dr12", Debug, RegRex, 4},
  {"dr13", Debug, RegRex, 5},
  {"dr14", Debug, RegRex, 6},
  {"dr15", Debug, RegRex, 7},
  /* Test registers.  */
  {"tr0", Test, 0, 0},
  {"tr1", Test, 0, 1},
  {"tr2", Test, 0, 2},
  {"tr3", Test, 0, 3},
  {"tr4", Test, 0, 4},
  {"tr5", Test, 0, 5},
  {"tr6", Test, 0, 6},
  {"tr7", Test, 0, 7},
  /* MMX and simd registers.  */
  {"mm0", RegMMX, 0, 0},
  {"mm1", RegMMX, 0, 1},
  {"mm2", RegMMX, 0, 2},
  {"mm3", RegMMX, 0, 3},
  {"mm4", RegMMX, 0, 4},
  {"mm5", RegMMX, 0, 5},
  {"mm6", RegMMX, 0, 6},
  {"mm7", RegMMX, 0, 7},
  {"xmm0", RegXMM, 0, 0},
  {"xmm1", RegXMM, 0, 1},
  {"xmm2", RegXMM, 0, 2},
  {"xmm3", RegXMM, 0, 3},
  {"xmm4", RegXMM, 0, 4},
  {"xmm5", RegXMM, 0, 5},
  {"xmm6", RegXMM, 0, 6},
  {"xmm7", RegXMM, 0, 7},
  {"xmm8", RegXMM, RegRex, 0},
  {"xmm9", RegXMM, RegRex, 1},
  {"xmm10", RegXMM, RegRex, 2},
  {"xmm11", RegXMM, RegRex, 3},
  {"xmm12", RegXMM, RegRex, 4},
  {"xmm13", RegXMM, RegRex, 5},
  {"xmm14", RegXMM, RegRex, 6},
  {"xmm15", RegXMM, RegRex, 7},
  /* No type will make this register rejected for all purposes except
     for addressing.  This saves creating one extra type for RIP.  */
  {"rip", BaseIndex, 0, 0},
  /* fp regs.  */
  {"st(0)", FloatReg|FloatAcc, 0, 0},
  {"st(1)", FloatReg, 0, 1},
  {"st(2)", FloatReg, 0, 2},
  {"st(3)", FloatReg, 0, 3},
  {"st(4)", FloatReg, 0, 4},
  {"st(5)", FloatReg, 0, 5},
  {"st(6)", FloatReg, 0, 6},
  {"st(7)", FloatReg, 0, 7}
};

const unsigned int i386_regtab_size = ARRAY_SIZE (i386_regtab);

/* Segment stuff.  */
const seg_entry cs = { "cs", 0x2e };
const seg_entry ds = { "ds", 0x3e };
const seg_entry ss = { "ss", 0x36 };
const seg_entry es = { "es", 0x26 };
const seg_entry fs = { "fs", 0x64 };
const seg_entry gs = { "gs", 0x65 };
