/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsILDAPBERElement.idl
 */

#ifndef __gen_nsILDAPBERElement_h__
#define __gen_nsILDAPBERElement_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsILDAPBERValue; /* forward declaration */


/* starting interface:    nsILDAPBERElement */
#define NS_ILDAPBERELEMENT_IID_STR "409f5b31-c062-4d11-a35b-0a09e7967bf2"

#define NS_ILDAPBERELEMENT_IID \
  {0x409f5b31, 0xc062, 0x4d11, \
    { 0xa3, 0x5b, 0x0a, 0x09, 0xe7, 0x96, 0x7b, 0xf2 }}

/**
 * nsILDAPBERElement is a wrapper interface for a C-SDK BerElement object.
 * Typically, this is used as an intermediate object to aid in the manual 
 * construction of a BER value.  Once the construction is completed by calling
 * methods on this object, an nsILDAPBERValue can be retrieved from the 
 * asValue attribute on this interface.
 *
 * <http://www.mozilla.org/directory/ietf-docs/draft-ietf-ldapext-ldap-c-api-05.txt>
 * contains some documentation that mostly (but not exactly) matches
 * the code that this wraps in section 17.
 */
class NS_NO_VTABLE nsILDAPBERElement : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ILDAPBERELEMENT_IID)

  /**
   * Initialize this object.  Must be called before calling any other method
   * on this interface.
   *
   * @param  aValue  value to preinitialize with; 0 for a new empty object
   *
   * @exception  NS_ERROR_NOT_IMPLEMENTED  preinitialization is currently
   *                                       not implemented
   * @exception  NS_ERROR_OUT_OF_MEMORY    unable to allocate the internal
   *                                       BerElement
   */
  /* void init (in nsILDAPBERValue aValue); */
  NS_IMETHOD Init(nsILDAPBERValue *aValue) = 0;

  /**
   * Most TAG_* constants can be used in the construction or passing in of 
   * values to the aTag arguments to most of the methods in this interface.
   */
/** 
   * When returned from a parsing method, 0xffffffff is referred to 
   * has the parse-error semantic (ie TAG_LBER_ERROR); when passing it to
   * a construction method, it is used to mean "pick the default tag for 
   * this type" (ie TAG_LBER_DEFAULT).
   */
  enum { TAG_LBER_ERROR = 4294967295U };

  enum { TAG_LBER_DEFAULT = 4294967295U };

  enum { TAG_LBER_END_OF_SEQORSET = 4294967294U };

  /** 
   * BER encoding types and masks
   */
  enum { TAG_LBER_PRIMITIVE = 0U };

  /**
   * The following two tags are carried over from the LDAP C SDK; their
   * exact purpose there is not well documented.  They both have
   * the same value there as well.
   */
  enum { TAG_LBER_CONSTRUCTED = 32U };

  enum { TAG_LBER_ENCODING_MASK = 32U };

  enum { TAG_LBER_BIG_TAG_MASK = 31U };

  enum { TAG_LBER_MORE_TAG_MASK = 128U };

  /**
   * general BER types we know about
   */
  enum { TAG_LBER_BOOLEAN = 1U };

  enum { TAG_LBER_INTEGER = 2U };

  enum { TAG_LBER_BITSTRING = 3U };

  enum { TAG_LBER_OCTETSTRING = 4U };

  enum { TAG_LBER_NULL = 5U };

  enum { TAG_LBER_ENUMERATED = 10U };

  enum { TAG_LBER_SEQUENCE = 48U };

  enum { TAG_LBER_SET = 49U };

  /**
   * Write a string to this element.  
   *
   * @param  aString  string to write
   * @param  aTag     tag for this string (if TAG_LBER_DEFAULT is used,
   *                  TAG_LBER_OCTETSTRING will be written).
   *
   * @return     number of bytes written
   *
   * @exception  NS_ERROR_FAILUE   C-SDK returned error
   */
  /* unsigned long putString (in AUTF8String aString, in unsigned long aTag); */
  NS_IMETHOD PutString(const nsACString & aString, PRUint32 aTag, PRUint32 *_retval) = 0;

  /**
   * Start a set.  Sets may be nested.
   *
   * @param  aTag  tag for this set (if TAG_LBER_DEFAULT is used, 
   *               TAG_LBER_SET will be written).
   *
   * @exception  NS_ERROR_FAILUE   C-SDK returned an error
   */
  /* void startSet (in unsigned long aTag); */
  NS_IMETHOD StartSet(PRUint32 aTag) = 0;

  /**
   * Cause the entire set started by the last startSet() call to be written.
   *
   * @exception  NS_ERROR_FAILUE   C-SDK returned an error
   *
   * @return     number of bytes written
   */
  /* unsigned long putSet (); */
  NS_IMETHOD PutSet(PRUint32 *_retval) = 0;

  /**
   * an nsILDAPBERValue version of this element.  Calls ber_flatten() under
   * the hood.
   *
   * @exception NS_ERROR_OUT_OF_MEMORY
   */
  /* readonly attribute nsILDAPBERValue asValue; */
  NS_IMETHOD GetAsValue(nsILDAPBERValue * *aAsValue) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSILDAPBERELEMENT \
  NS_IMETHOD Init(nsILDAPBERValue *aValue); \
  NS_IMETHOD PutString(const nsACString & aString, PRUint32 aTag, PRUint32 *_retval); \
  NS_IMETHOD StartSet(PRUint32 aTag); \
  NS_IMETHOD PutSet(PRUint32 *_retval); \
  NS_IMETHOD GetAsValue(nsILDAPBERValue * *aAsValue); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSILDAPBERELEMENT(_to) \
  NS_IMETHOD Init(nsILDAPBERValue *aValue) { return _to Init(aValue); } \
  NS_IMETHOD PutString(const nsACString & aString, PRUint32 aTag, PRUint32 *_retval) { return _to PutString(aString, aTag, _retval); } \
  NS_IMETHOD StartSet(PRUint32 aTag) { return _to StartSet(aTag); } \
  NS_IMETHOD PutSet(PRUint32 *_retval) { return _to PutSet(_retval); } \
  NS_IMETHOD GetAsValue(nsILDAPBERValue * *aAsValue) { return _to GetAsValue(aAsValue); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSILDAPBERELEMENT(_to) \
  NS_IMETHOD Init(nsILDAPBERValue *aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(aValue); } \
  NS_IMETHOD PutString(const nsACString & aString, PRUint32 aTag, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->PutString(aString, aTag, _retval); } \
  NS_IMETHOD StartSet(PRUint32 aTag) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartSet(aTag); } \
  NS_IMETHOD PutSet(PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->PutSet(_retval); } \
  NS_IMETHOD GetAsValue(nsILDAPBERValue * *aAsValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAsValue(aAsValue); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsLDAPBERElement : public nsILDAPBERElement
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSILDAPBERELEMENT

  nsLDAPBERElement();

private:
  ~nsLDAPBERElement();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsLDAPBERElement, nsILDAPBERElement)

nsLDAPBERElement::nsLDAPBERElement()
{
  /* member initializers and constructor code */
}

nsLDAPBERElement::~nsLDAPBERElement()
{
  /* destructor code */
}

/* void init (in nsILDAPBERValue aValue); */
NS_IMETHODIMP nsLDAPBERElement::Init(nsILDAPBERValue *aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long putString (in AUTF8String aString, in unsigned long aTag); */
NS_IMETHODIMP nsLDAPBERElement::PutString(const nsACString & aString, PRUint32 aTag, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void startSet (in unsigned long aTag); */
NS_IMETHODIMP nsLDAPBERElement::StartSet(PRUint32 aTag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long putSet (); */
NS_IMETHODIMP nsLDAPBERElement::PutSet(PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsILDAPBERValue asValue; */
NS_IMETHODIMP nsLDAPBERElement::GetAsValue(nsILDAPBERValue * *aAsValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsILDAPBERElement_h__ */
