.\" t
.\" @(#)FvwmM4.1	1/28/94
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH FvwmM4 2.0 12/12/94
.UC
.SH NAME
FvwmM4 \- the FVWM  M4 pre-processor
.SH SYNOPSIS
FvwmM4 is spawned by fvwm, so no command line invocation will work.

.SH DESCRIPTION
When called, this module will attempt to have M4 pre-process the file
specified in its invocation, and then have fvwm read the resulting file.

.SH INVOCATION
FvwmM4 can be invoked by inserting the line 'FvwmM4' in
the .fvwmrc file. It can also be called from a menu or mouse binding.
If the user wants his entire .fvwmrc file pre-processed with FvwmM4,
then fvwm should be invoked as fvwm -f "FvwmM4 .fvwmrc". Note that the
argument to the option "-f" should be enclosed 
in quotes, and no other quoting should be used. For example, a
typical invocation might be
.EX
fvwm -f "FvwmM4 -m4-squote { -m4-equote } .fvwmrc"
.EE

Some options can be specified on the command line:
.IP -m4-prefix
I think this makes all the m4 directives require the prefix "m4_".

.IP -m4opt \fIoption\fP
Lets you pass an option to the m4 program.

.IP -m4-squote \fIcharacter\fP
Lets you change the m4 start-of-quote character to \fIcharacter\fP.
.IP -m4-equote \fIcharacter\fP
Lets you change the m4 end-of-quote character to \fIcharacter\fP.
.IP -m4prog \fIname\fP
Instead of invoking "m4", fvwm will invoke \fIname\fP.
.IP -debug
Causes the temporary file create by m4 to
be retained. This file is usually called "/tmp/fvwmrcXXXXXX"


.SH CONFIGURATION OPTIONS
FvwmM4 defines some values for use in the pre-processor file:

.IP TWM_TYPE
Always set to "fvwm".
.IP SERVERHOST
The name of the machine running the X Server.
.IP CLIENTHOST
The name of the machine running fvwm.
.IP HOSTNAME
The hostname of the machine running fvwm. Generally the same as CLIENTHOST.
.IP OSTYPE
The operating system for CLIENTHOST.
.IP USER
The name of the person running fvwm.
.IP VERSION
The X11 version.
.IP REVISION
The X11 revision number.
.IP VENDOR
The X server vendor.
.IP RELEASE
The X server release number.
.IP WIDTH
The screen width in pixels.
.IP HEIGHT
The screen height in pixels.
.IP X_RESOLUTION
Some distance/pixel measurement for the horizontal direction, I think.
.IP Y_RESOLUTION
Some distance/pixel measurement for the vertical direction, I think.
.IP PLANES
Number of color planes for the X server display
.IP BITS_PER_RGB
Number of bits in each rgb triplet.
.IP CLASS
The X11 visual class, ie PsuedoColor.
.IP COLOR
Yes or No, Yes if the display class is neither StaticGrey or GreyScale.
.IP FVWM_VERSION
The fvwm version number, ie 2.0
.IP OPTIONS
Some combination of SHAPE, XPM, NO_SAVEUNDERS, and M4, as defined in
configure.h at compile time.
.IP FVWMDIR
The directory where fvwm looks for .fvwmrc and modules by default, as
determined at compile time.

.SH EXAMPLE PROLOG

.EX
define(TWM_TYPE,``fvwm'')dnl
define(SERVERHOST,``spx20'')dnl
define(CLIENTHOST,``grumpy'')dnl
define(HOSTNAME,``grumpy'')dnl
define(OSTYPE,``SunOS'')dnl
define(USER,``nation'')dnl
define(HOME,``/local/homes/dsp/nation'')dnl
define(VERSION,``11'')dnl
define(REVISION,``0'')dnl
define(VENDOR,``HDS human designed systems, inc. (2.1.2-D)'')dnl
define(RELEASE,``4'')dnl
define(WIDTH,``1280'')dnl
define(HEIGHT,``1024'')dnl
define(X_RESOLUTION,``3938'')dnl
define(Y_RESOLUTION,``3938'')dnl
define(PLANES,``8'')dnl
define(BITS_PER_RGB,``8'')dnl
define(CLASS,``PseudoColor'')dnl
define(COLOR,``Yes'')dnl
define(FVWM_VERSION,``1.24l'')dnl
define(OPTIONS,``SHAPE XPM M4 '')dnl
define(FVWMDIR,``/local/homes/dsp/nation/modules'')dnl
.EE

.SH AUTHOR
FvwmM4 is the result of a random bit mutation on a hard disk,
presumably a result of a  cosmic-ray or some such thing.
