/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class ISO2022_JP
extends Charset
implements HistoricallyNamedCharset {
    private static final int ASCII = 0;
    private static final int JISX0201_1976 = 1;
    private static final int JISX0208_1978 = 2;
    private static final int JISX0208_1983 = 3;
    private static final int JISX0201_1976_KANA = 4;
    private static final int SHIFTOUT = 5;

    public ISO2022_JP() {
        super("ISO-2022-JP", ExtendedCharsets.aliasesFor("ISO-2022-JP"));
    }

    public String historicalName() {
        return "ISO2022JP";
    }

    public boolean contains(Charset charset) {
        return charset instanceof JIS_X_0201 || charset instanceof US_ASCII || charset instanceof JIS_X_0208 || charset instanceof ISO2022_JP;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends JIS_X_0208_Decoder
    implements DelegatableDecoder {
        private int currentState = 0;

        private Decoder(Charset charset) {
            super(charset);
        }

        public void implReset() {
            this.currentState = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeArrayLoop(ByteBuffer var1_1, CharBuffer var2_2) {
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = var1_1.array();
            var9_9 = var1_1.arrayOffset() + var1_1.position();
            var10_10 = var1_1.arrayOffset() + var1_1.limit();
            if (!Decoder.$assertionsDisabled && var9_9 > var10_10) {
                throw new AssertionError();
            }
            var11_11 = var2_2.array();
            var12_12 = var2_2.arrayOffset() + var2_2.position();
            var13_13 = var2_2.arrayOffset() + var2_2.limit();
            if (!Decoder.$assertionsDisabled && var12_12 > var13_13) {
                throw new AssertionError();
            }
            var12_12 = var12_12 <= var13_13 ? var12_12 : var13_13;
            try {
                block27: for (var9_9 = var9_9 <= var10_10 ? var9_9 : var10_10; var9_9 < var10_10; var9_9 += var4_4) {
                    var5_5 = var8_8[var9_9] & 255;
                    var4_4 = 1;
                    if ((var5_5 & -128) != 0) {
                        var14_14 = CoderResult.malformedForLength(1);
                        return var14_14;
                    }
                    while (var5_5 == 27 || var5_5 == 14 || var5_5 == 15) {
                        block53: {
                            if (var5_5 != 27) break block53;
                            if (var9_9 + var4_4 + 2 > var10_10) {
                                var14_15 = CoderResult.UNDERFLOW;
                                return var14_15;
                            }
                            var6_6 = var8_8[var9_9 + var4_4] & 255;
                            ++var4_4;
                            if ((var6_6 & -128) != 0) {
                                var14_16 = CoderResult.malformedForLength(1);
                                return var14_16;
                            }
                            if (var6_6 != 40) ** GOTO lbl48
                            var7_7 = var8_8[var9_9 + var4_4] & 255;
                            ++var4_4;
                            if (var7_7 == 66) {
                                this.currentState = 0;
                            } else if (var7_7 == 74) {
                                this.currentState = 1;
                            } else if (var7_7 == 73) {
                                this.currentState = 4;
                            } else {
                                var14_17 = CoderResult.malformedForLength(2);
                                return var14_17;
lbl48:
                                // 1 sources

                                if (var6_6 == 36) {
                                    var7_7 = var8_8[var9_9 + var4_4] & 255;
                                    ++var4_4;
                                    if ((var7_7 & -128) != 0) {
                                        var14_18 = CoderResult.malformedForLength(2);
                                        return var14_18;
                                    }
                                    if (var7_7 == 64) {
                                        this.currentState = 2;
                                    } else if (var7_7 == 66) {
                                        this.currentState = 3;
                                    } else {
                                        var14_19 = CoderResult.malformedForLength(2);
                                        return var14_19;
                                    }
                                }
                            }
                            if (var9_9 + var4_4 + 1 > var10_10) {
                                var9_9 += var4_4;
                                var14_20 = CoderResult.UNDERFLOW;
                                return var14_20;
                            }
                            var5_5 = var8_8[var9_9 + var4_4] & 255;
                            ++var4_4;
                            continue;
                        }
                        if (var5_5 == 14) {
                            if (var9_9 + var4_4 >= var10_10) {
                                var14_21 = CoderResult.UNDERFLOW;
                                return var14_21;
                            }
                            var3_3 = this.currentState;
                            this.currentState = 5;
                            var5_5 = var8_8[var9_9 + var4_4] & 255;
                            ++var4_4;
                            if ((var5_5 & -128) == 0) continue;
                            var14_22 = CoderResult.malformedForLength(1);
                            return var14_22;
                        }
                        if (var5_5 != 15) continue;
                        if (var9_9 + var4_4 >= var10_10) {
                            var14_23 = CoderResult.UNDERFLOW;
                            return var14_23;
                        }
                        this.currentState = var3_3;
                        var5_5 = var8_8[var9_9 + var4_4] & 255;
                        ++var4_4;
                        if ((var5_5 & -128) == 0) continue;
                        var14_24 = CoderResult.malformedForLength(1);
                        return var14_24;
                    }
                    if (var12_12 + 1 > var13_13) {
                        var14_25 = CoderResult.OVERFLOW;
                        return var14_25;
                    }
                    switch (this.currentState) {
                        case 0: {
                            var11_11[var12_12++] = (char)(var5_5 & 255);
                            continue block27;
                        }
                        case 1: {
                            switch (var5_5) {
                                case 92: {
                                    var11_11[var12_12++] = 165;
                                    continue block27;
                                }
                                case 126: {
                                    var11_11[var12_12++] = 8254;
                                    continue block27;
                                }
                            }
                            var11_11[var12_12++] = (char)var5_5;
                            continue block27;
                        }
                        case 2: 
                        case 3: {
                            if (var9_9 + var4_4 + 1 > var10_10) {
                                var14_26 = CoderResult.UNDERFLOW;
                                return var14_26;
                            }
                            var6_6 = var8_8[var9_9 + var4_4] & 255;
                            ++var4_4;
                            var11_11[var12_12++] = this.decodeDouble(var5_5, var6_6);
                            continue block27;
                        }
                        case 4: 
                        case 5: {
                            if (var5_5 > 96) {
                                var14_27 = CoderResult.malformedForLength(1);
                                return var14_27;
                            }
                            var11_11[var12_12++] = (char)(var5_5 + 65344);
                        }
                    }
                }
                var14_28 = CoderResult.UNDERFLOW;
                return var14_28;
            }
            finally {
                var1_1.position(var9_9 - var1_1.arrayOffset());
                var2_2.position(var12_12 - var2_2.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeBufferLoop(ByteBuffer var1_1, CharBuffer var2_2) {
            var3_3 = var1_1.position();
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = 0;
            try {
                while (var1_1.hasRemaining()) {
                    var4_4 = var1_1.get();
                    var7_7 = 1;
                    if ((var4_4 & -128) != 0) {
                        var9_9 = CoderResult.malformedForLength(1);
                        return var9_9;
                    }
                    while (var4_4 == 27 || var4_4 == 14 || var4_4 == 15) {
                        block49: {
                            if (var4_4 != 27) break block49;
                            if (var1_1.remaining() < 1) {
                                var9_10 = CoderResult.UNDERFLOW;
                                return var9_10;
                            }
                            var5_5 = var1_1.get() & 255;
                            ++var7_7;
                            if ((var5_5 & -128) != 0) {
                                var9_11 = CoderResult.malformedForLength(2);
                                return var9_11;
                            }
                            if (var5_5 != 40) ** GOTO lbl41
                            if (var1_1.remaining() < 2) {
                                var9_12 = CoderResult.UNDERFLOW;
                                return var9_12;
                            }
                            var6_6 = var1_1.get() & 255;
                            ++var7_7;
                            if (var6_6 == 66) {
                                this.currentState = 0;
                            } else if (var6_6 == 74) {
                                this.currentState = 1;
                            } else if (var6_6 == 73) {
                                this.currentState = 4;
                            } else {
                                var9_13 = CoderResult.malformedForLength(3);
                                return var9_13;
lbl41:
                                // 1 sources

                                if (var5_5 == 36) {
                                    if (var1_1.remaining() < 2) {
                                        var9_14 = CoderResult.UNDERFLOW;
                                        return var9_14;
                                    }
                                    var6_6 = var1_1.get() & 255;
                                    ++var7_7;
                                    if ((var6_6 & -128) != 0) {
                                        var9_15 = CoderResult.malformedForLength(1);
                                        return var9_15;
                                    }
                                    if (var6_6 == 64) {
                                        this.currentState = 2;
                                    } else if (var6_6 == 66) {
                                        this.currentState = 3;
                                    } else {
                                        var9_16 = CoderResult.malformedForLength(1);
                                        return var9_16;
                                    }
                                }
                            }
                            var4_4 = var1_1.get() & 255;
                            ++var7_7;
                            continue;
                        }
                        if (var4_4 == 14) {
                            var8_8 = this.currentState;
                            this.currentState = 5;
                            var4_4 = var1_1.get() & 255;
                            ++var7_7;
                            if ((var4_4 & -128) == 0) continue;
                            var9_17 = CoderResult.malformedForLength(1);
                            return var9_17;
                        }
                        if (var4_4 != 15) continue;
                        this.currentState = var8_8;
                        var4_4 = var1_1.get() & 255;
                        ++var7_7;
                        if ((var4_4 & -128) == 0) continue;
                        var9_18 = CoderResult.malformedForLength(1);
                        return var9_18;
                    }
                    if (var2_2.remaining() < 1) {
                        var9_19 = CoderResult.OVERFLOW;
                        return var9_19;
                    }
                    block14 : switch (this.currentState) {
                        case 0: {
                            var2_2.put((char)(var4_4 & 255));
                            break;
                        }
                        case 1: {
                            switch (var4_4) {
                                case 92: {
                                    var2_2.put('\u00a5');
                                    break block14;
                                }
                                case 126: {
                                    var2_2.put('\u203e');
                                    break block14;
                                }
                            }
                            var2_2.put((char)var4_4);
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (var1_1.remaining() < 1) {
                                var9_20 = CoderResult.UNDERFLOW;
                                return var9_20;
                            }
                            var5_5 = var1_1.get() & 255;
                            ++var7_7;
                            var2_2.put(this.decodeDouble(var4_4, var5_5));
                            break;
                        }
                        case 4: 
                        case 5: {
                            if (var4_4 > 96) {
                                var9_21 = CoderResult.malformedForLength(1);
                                return var9_21;
                            }
                            var2_2.put((char)(var4_4 + 65344));
                        }
                    }
                    var3_3 += var7_7;
                }
                var9_22 = CoderResult.UNDERFLOW;
                return var9_22;
            }
            finally {
                var1_1.position(var3_3);
            }
        }

        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }
    }

    private static class Encoder
    extends JIS_X_0208_Encoder {
        private int currentMode = 0;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            super(charset, 4.0f, 8.0f);
        }

        protected void implReset() {
            boolean bl = false;
        }

        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.currentMode != 0) {
                if (byteBuffer.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)27);
                byteBuffer.put((byte)40);
                byteBuffer.put((byte)66);
                this.currentMode = 0;
            }
            return CoderResult.UNDERFLOW;
        }

        public boolean canEncode(char c) {
            return c <= '\u007f' || c >= '\uff61' && c <= '\uff9f' || c == '\u00a5' || c == '\u203e' || super.canEncode(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            n = n <= n2 ? n : n2;
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            try {
                while (n < n2) {
                    int n6 = this.currentMode;
                    char c = cArray[n];
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 66;
                            byArray[n3++] = (byte)c;
                            n6 = 0;
                            ++n;
                        } else {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)c;
                            ++n;
                        }
                    } else if (c >= '\uff61' && c <= '\uff9f') {
                        if (this.currentMode != 4) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 73;
                            byArray[n3++] = (byte)(c - 65344);
                            n6 = 4;
                            ++n;
                        } else {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)(c - 65344);
                            ++n;
                        }
                    } else if (c == '\u00a5') {
                        if (this.currentMode != 1) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 74;
                            byArray[n3++] = 92;
                            n6 = 1;
                            ++n;
                        } else {
                            byArray[n3++] = 92;
                            ++n;
                        }
                    } else if (c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 74;
                            byArray[n3++] = 126;
                            n6 = 1;
                            ++n;
                        } else {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 126;
                            ++n;
                        }
                    } else {
                        if (n4 - n3 < 5) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        int n7 = this.encodeDouble(c);
                        if (n7 != 0) {
                            if (this.currentMode != 3) {
                                byArray[n3++] = 27;
                                byArray[n3++] = 36;
                                byArray[n3++] = 66;
                                byArray[n3++] = (byte)(n7 >> 8);
                                byArray[n3++] = (byte)(n7 & 0xFF);
                                n6 = 3;
                                ++n;
                            } else {
                                byArray[n3++] = (byte)(n7 >> 8);
                                byArray[n3++] = (byte)(n7 & 0xFF);
                                ++n;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (n4 - n3 < n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentMode = n6;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2 = this.currentMode;
                    char c = charBuffer.get();
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)66);
                            byteBuffer.put((byte)c);
                            ++n;
                            n2 = 0;
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)c);
                            ++n;
                        }
                    } else if (c >= '\uff61' && c <= '\uff9f') {
                        if (this.currentMode != 4) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)73);
                            byteBuffer.put((byte)(c - 65344));
                            ++n;
                            n2 = 4;
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            ++n;
                            byteBuffer.put((byte)(c - 65344));
                        }
                    } else if (c == '\u00a5') {
                        if (this.currentMode != 1) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)74);
                            byteBuffer.put((byte)92);
                            ++n;
                            n2 = 1;
                        } else {
                            ++n;
                            byteBuffer.put((byte)92);
                        }
                    } else if (c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)74);
                            byteBuffer.put((byte)126);
                            ++n;
                            n2 = 1;
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)126);
                            ++n;
                        }
                    } else {
                        if (byteBuffer.remaining() < 5) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        int n3 = this.encodeDouble(c);
                        if (n3 != 0) {
                            if (this.currentMode != 3) {
                                byteBuffer.put((byte)27);
                                byteBuffer.put((byte)36);
                                byteBuffer.put((byte)66);
                                byteBuffer.put((byte)(n3 >> 8));
                                byteBuffer.put((byte)(n3 & 0xFF));
                                n2 = 3;
                                ++n;
                            } else {
                                byteBuffer.put((byte)(n3 >> 8));
                                byteBuffer.put((byte)(n3 & 0xFF));
                                ++n;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    this.currentMode = n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

