/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class UCompactIntArray
implements Cloneable {
    private static final int PLANEMASK = 196608;
    private static final int PLANESHIFT = 16;
    private static final int PLANECOUNT = 16;
    private static final int CODEPOINTMASK = 65535;
    private static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int defaultValue;
    private int[][] values = new int[16][];
    private short[][] indices = new short[16][];
    private boolean isCompact;
    private boolean[][] blockTouched = new boolean[16][];
    private boolean[] planeTouched = new boolean[16];

    public UCompactIntArray() {
    }

    public UCompactIntArray(int n2) {
        this();
        this.defaultValue = n2;
    }

    public int elementAt(int n2) {
        int n3 = (n2 & 0x30000) >> 16;
        if (!this.planeTouched[n3]) {
            return this.defaultValue;
        }
        return this.values[n3][(this.indices[n3][(n2 &= 0xFFFF) >> 7] & 0xFFFF) + (n2 & 0x7F)];
    }

    public void setElementAt(int n2, int n3) {
        int n4;
        if (this.isCompact) {
            this.expand();
        }
        if (!this.planeTouched[n4 = (n2 & 0x30000) >> 16]) {
            this.initPlane(n4);
        }
        this.values[n4][n2 &= 0xFFFF] = n3;
        this.blockTouched[n4][n2 >> 7] = true;
    }

    public void compact() {
        if (this.isCompact) {
            return;
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            if (!this.planeTouched[i2]) continue;
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices[i2].length) {
                this.indices[i2][n5] = -1;
                if (!this.blockTouched[i2][n5] && n4 != -1) {
                    this.indices[i2][n5] = n4;
                } else {
                    int n6 = n2 * 128;
                    if (n5 > n2) {
                        System.arraycopy(this.values[i2], n3, this.values[i2], n6, 128);
                    }
                    if (!this.blockTouched[i2][n5]) {
                        n4 = (short)n6;
                    }
                    this.indices[i2][n5] = (short)n6;
                    ++n2;
                }
                ++n5;
                n3 += 128;
            }
            n5 = n2 * 128;
            int[] nArray = new int[n5];
            System.arraycopy(this.values[i2], 0, nArray, 0, n5);
            this.values[i2] = nArray;
            this.blockTouched[i2] = null;
        }
        this.isCompact = true;
    }

    private void expand() {
        if (this.isCompact) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n2;
                if (!this.planeTouched[i2]) continue;
                this.blockTouched[i2] = new boolean[512];
                int[] nArray = new int[65536];
                for (n2 = 0; n2 < 65536; ++n2) {
                    nArray[n2] = this.values[i2][this.indices[i2][n2 >> 7] & 65535 + (n2 & 0x7F)];
                    this.blockTouched[i2][n2 >> 7] = true;
                }
                for (n2 = 0; n2 < 512; ++n2) {
                    this.indices[i2][n2] = (short)(n2 << 7);
                }
                this.values[i2] = nArray;
            }
            this.isCompact = false;
        }
    }

    private void initPlane(int n2) {
        int n3;
        this.values[n2] = new int[65536];
        this.indices[n2] = new short[512];
        this.blockTouched[n2] = new boolean[512];
        this.planeTouched[n2] = true;
        if (this.planeTouched[0] && n2 != 0) {
            System.arraycopy(this.indices[0], 0, this.indices[n2], 0, 512);
        } else {
            for (n3 = 0; n3 < 512; ++n3) {
                this.indices[n2][n3] = (short)(n3 << 7);
            }
        }
        for (n3 = 0; n3 < 65536; ++n3) {
            this.values[n2][n3] = this.defaultValue;
        }
    }

    public int getKSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (!this.planeTouched[i2]) continue;
            n2 += this.values[i2].length * 4 + this.indices[i2].length * 2;
        }
        return n2 / 1024;
    }
}

