/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.SerialNumber;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE_PROP = "ocsp.enable";
    public static final String OCSP_URL_PROP = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final int[] OCSP_NONCE_DATA = new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2};
    private static final ObjectIdentifier OCSP_NONCE_OID = ObjectIdentifier.newInternal(OCSP_NONCE_DATA);
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pKIXParameters;
        List<? extends Certificate> list = this.cp.getCertificates();
        this.certs = list.toArray(new X509Certificate[list.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean bl2) throws CertPathValidatorException {
        if (bl2) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        try {
            Iterator<? extends Certificate> iterator;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            Object object5;
            Object object6 = null;
            boolean bl2 = false;
            X500Principal x500Principal = null;
            X500Principal x500Principal2 = null;
            BigInteger bigInteger = null;
            String[] stringArray = OCSPChecker.getOCSPProperties();
            if (stringArray[1] != null) {
                x500Principal = new X500Principal(stringArray[1]);
            } else if (stringArray[2] != null && stringArray[3] != null) {
                x500Principal2 = new X500Principal(stringArray[2]);
                String string = OCSPChecker.stripOutSeparators(stringArray[3]);
                bigInteger = new BigInteger(string, 16);
            } else if (stringArray[2] != null || stringArray[3] != null) {
                throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
            }
            if (x500Principal != null || x500Principal2 != null) {
                bl2 = true;
            }
            boolean bl3 = true;
            X509CertImpl x509CertImpl = null;
            X509CertImpl x509CertImpl2 = X509CertImpl.toImpl((X509Certificate)certificate);
            --this.remainingCerts;
            if (this.remainingCerts != 0) {
                x509CertImpl = X509CertImpl.toImpl(this.certs[this.remainingCerts]);
                bl3 = false;
                if (!bl2) {
                    object6 = this.certs[this.remainingCerts];
                    if (DEBUG != null) {
                        DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                    }
                }
            }
            if (bl3 || bl2) {
                if (DEBUG != null && bl2) {
                    DEBUG.println("Searching trust anchors for responder's certificate");
                }
                if (!(object5 = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                    throw new CertPathValidatorException("Must specify at least one trust anchor");
                }
                serializable = x509CertImpl2.getIssuerX500Principal();
                while (object5.hasNext() && (bl3 || bl2)) {
                    object4 = (TrustAnchor)object5.next();
                    object3 = ((TrustAnchor)object4).getTrustedCert();
                    object2 = ((X509Certificate)object3).getSubjectX500Principal();
                    if (bl3 && ((X500Principal)serializable).equals(object2)) {
                        x509CertImpl = X509CertImpl.toImpl((X509Certificate)object3);
                        bl3 = false;
                        if (!bl2 && object6 == null) {
                            object6 = object3;
                            if (DEBUG != null) {
                                DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                            }
                        }
                    }
                    if (!bl2 || (x500Principal == null || !x500Principal.equals(object2)) && (x500Principal2 == null || bigInteger == null || !x500Principal2.equals(((X509Certificate)object3).getIssuerX500Principal()) || !bigInteger.equals(((X509Certificate)object3).getSerialNumber()))) continue;
                    object6 = object3;
                    bl2 = false;
                }
                if (x509CertImpl == null) {
                    throw new CertPathValidatorException("No trusted certificate for " + x509CertImpl2.getIssuerDN());
                }
                if (bl2) {
                    if (DEBUG != null) {
                        DEBUG.println("Searching cert stores for responder's certificate");
                    }
                    object4 = null;
                    if (x500Principal != null) {
                        object4 = new X509CertSelector();
                        ((X509CertSelector)object4).setSubject(x500Principal.getName());
                    } else if (x500Principal2 != null && bigInteger != null) {
                        object4 = new X509CertSelector();
                        ((X509CertSelector)object4).setIssuer(x500Principal2.getName());
                        ((X509CertSelector)object4).setSerialNumber(bigInteger);
                    }
                    if (object4 != null) {
                        object3 = this.pkixParams.getCertStores();
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (CertStore)object2.next();
                            iterator = ((CertStore)object).getCertificates((CertSelector)object4).iterator();
                            if (!iterator.hasNext()) continue;
                            object6 = (X509Certificate)iterator.next();
                            bl2 = false;
                            break;
                        }
                    }
                }
            }
            if (bl2) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
            object5 = new OCSPRequest(x509CertImpl2, x509CertImpl);
            serializable = OCSPChecker.getOCSPServerURL(x509CertImpl2, stringArray);
            object4 = (HttpURLConnection)((URL)serializable).openConnection();
            if (DEBUG != null) {
                DEBUG.println("connecting to OCSP service at: " + serializable);
            }
            ((URLConnection)object4).setDoOutput(true);
            ((URLConnection)object4).setDoInput(true);
            ((HttpURLConnection)object4).setRequestMethod("POST");
            ((URLConnection)object4).setRequestProperty("Content-type", "application/ocsp-request");
            object3 = ((OCSPRequest)object5).encodeBytes();
            object2 = ((OCSPRequest)object5).getCertId();
            ((URLConnection)object4).setRequestProperty("Content-length", String.valueOf(((Object)object3).length));
            object = ((URLConnection)object4).getOutputStream();
            ((OutputStream)object).write((byte[])object3);
            ((OutputStream)object).flush();
            if (DEBUG != null && ((HttpURLConnection)object4).getResponseCode() != 200) {
                DEBUG.println("Received HTTP error: " + ((HttpURLConnection)object4).getResponseCode() + " - " + ((HttpURLConnection)object4).getResponseMessage());
            }
            iterator = ((URLConnection)object4).getInputStream();
            int n2 = ((URLConnection)object4).getContentLength();
            if (n2 == -1) {
                n2 = Integer.MAX_VALUE;
            }
            byte[] byArray = new byte[n2];
            int n3 = 0;
            for (int i2 = 0; n3 != -1 && i2 < n2; i2 += n3) {
                n3 = ((InputStream)((Object)iterator)).read(byArray, i2, byArray.length - i2);
            }
            ((InputStream)((Object)iterator)).close();
            ((OutputStream)object).close();
            OCSPResponse oCSPResponse = new OCSPResponse(byArray, this.pkixParams, (X509Certificate)object6);
            if (!((CertId)object2).equals(oCSPResponse.getCertId())) {
                throw new CertPathValidatorException("Certificate in the OCSP response does not match the certificate supplied in the OCSP request.");
            }
            SerialNumber serialNumber = x509CertImpl2.getSerialNumberObject();
            int n4 = oCSPResponse.getCertStatus(serialNumber);
            if (DEBUG != null) {
                DEBUG.println("Status of certificate (with serial number " + serialNumber.getNumber() + ") is: " + OCSPResponse.certStatusToText(n4));
            }
            if (n4 == 1) {
                throw new CertificateRevokedException("Certificate has been revoked", this.cp, this.remainingCerts);
            }
            if (n4 == 2) {
                throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts);
            }
        }
        catch (CertificateRevokedException certificateRevokedException) {
            throw certificateRevokedException;
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw certPathValidatorException;
        }
        catch (Exception exception) {
            throw new CertPathValidatorException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL getOCSPServerURL(X509CertImpl x509CertImpl, String[] stringArray) throws CertificateParsingException, CertPathValidatorException {
        if (stringArray[0] != null) {
            try {
                return new URL(stringArray[0]);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CertPathValidatorException(malformedURLException);
            }
        }
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        try {
            List list = (List)authorityInfoAccessExtension.get("descriptions");
            for (AccessDescription accessDescription : list) {
                GeneralName generalName;
                if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
                try {
                    URIName uRIName = (URIName)generalName.getName();
                    return new URL(uRIName.getName());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new CertPathValidatorException(malformedURLException);
                    throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] stringArray = new String[4];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                stringArray[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                stringArray[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                stringArray[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                stringArray[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return stringArray;
    }

    private static String stripOutSeparators(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (HEX_DIGITS.indexOf(cArray[i2]) == -1) continue;
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }
}

