/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.cmdline;

import com.sun.org.apache.xalan.internal.xsltc.DOM;
import com.sun.org.apache.xalan.internal.xsltc.DOMEnhancedForDTM;
import com.sun.org.apache.xalan.internal.xsltc.StripFilter;
import com.sun.org.apache.xalan.internal.xsltc.TransletException;
import com.sun.org.apache.xalan.internal.xsltc.cmdline.ObjectFactory;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.dom.DOMWSFilter;
import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xalan.internal.xsltc.runtime.Parameter;
import com.sun.org.apache.xalan.internal.xsltc.runtime.output.TransletOutputHandlerFactory;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class Transform {
    private SerializationHandler _handler;
    private String _fileName;
    private String _className;
    private String _jarFileSrc;
    private boolean _isJarFileSpecified = false;
    private Vector _params = null;
    private boolean _uri;
    private boolean _debug;
    private int _iterations;
    private static boolean _allowExit = true;

    public Transform(String string, String string2, boolean bl2, boolean bl3, int n2) {
        this._fileName = string2;
        this._className = string;
        this._uri = bl2;
        this._debug = bl3;
        this._iterations = n2;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getClassName() {
        return this._className;
    }

    public void setParameters(Vector vector) {
        this._params = vector;
    }

    private void setJarFileInputSrc(boolean bl2, String string) {
        this._isJarFileSpecified = bl2;
        this._jarFileSrc = string;
    }

    private void doTransform() {
        block34: {
            try {
                Class clazz = ObjectFactory.findProviderClass(this._className, ObjectFactory.findClassLoader(), true);
                AbstractTranslet abstractTranslet = (AbstractTranslet)clazz.newInstance();
                abstractTranslet.postInitialization();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                try {
                    sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                }
                catch (Exception exception) {
                    sAXParserFactory.setNamespaceAware(true);
                }
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                XSLTCDTMManager xSLTCDTMManager = (XSLTCDTMManager)XSLTCDTMManager.getDTMManagerClass().newInstance();
                DOMWSFilter dOMWSFilter = abstractTranslet != null && abstractTranslet instanceof StripFilter ? new DOMWSFilter(abstractTranslet) : null;
                DOMEnhancedForDTM dOMEnhancedForDTM = (DOMEnhancedForDTM)((Object)xSLTCDTMManager.getDTM(new SAXSource(xMLReader, new InputSource(this._fileName)), false, dOMWSFilter, true, false, abstractTranslet.hasIdCall()));
                dOMEnhancedForDTM.setDocumentURI(this._fileName);
                abstractTranslet.prepassDocument(dOMEnhancedForDTM);
                int n2 = this._params.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Parameter parameter = (Parameter)this._params.elementAt(i2);
                    abstractTranslet.addParameter(parameter._name, parameter._value);
                }
                TransletOutputHandlerFactory transletOutputHandlerFactory = TransletOutputHandlerFactory.newInstance();
                transletOutputHandlerFactory.setOutputType(0);
                transletOutputHandlerFactory.setEncoding(abstractTranslet._encoding);
                transletOutputHandlerFactory.setOutputMethod(abstractTranslet._method);
                if (this._iterations == -1) {
                    abstractTranslet.transform((DOM)dOMEnhancedForDTM, transletOutputHandlerFactory.getSerializationHandler());
                } else if (this._iterations > 0) {
                    long l2 = System.currentTimeMillis();
                    for (int i3 = 0; i3 < this._iterations; ++i3) {
                        abstractTranslet.transform((DOM)dOMEnhancedForDTM, transletOutputHandlerFactory.getSerializationHandler());
                    }
                    l2 = System.currentTimeMillis() - l2;
                    System.err.println("\n<!--");
                    System.err.println("  transform  = " + (double)l2 / (double)this._iterations + " ms");
                    System.err.println("  throughput = " + 1000.0 / ((double)l2 / (double)this._iterations) + " tps");
                    System.err.println("-->");
                }
            }
            catch (TransletException transletException) {
                if (this._debug) {
                    transletException.printStackTrace();
                }
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + transletException.getMessage());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (RuntimeException runtimeException) {
                if (this._debug) {
                    runtimeException.printStackTrace();
                }
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + runtimeException.getMessage());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this._debug) {
                    fileNotFoundException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("FILE_NOT_FOUND_ERR", this._fileName);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (this._debug) {
                    malformedURLException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("INVALID_URI_ERR", this._fileName);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this._debug) {
                    classNotFoundException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (this._debug) {
                    unknownHostException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("INVALID_URI_ERR", this._fileName);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (this._debug) {
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                    sAXException.printStackTrace();
                }
                System.err.print(new ErrorMsg("RUNTIME_ERROR_KEY"));
                if (exception != null) {
                    System.err.println(exception.getMessage());
                } else {
                    System.err.println(sAXException.getMessage());
                }
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                if (this._debug) {
                    exception.printStackTrace();
                }
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + exception.getMessage());
                if (!_allowExit) break block34;
                System.exit(-1);
            }
        }
    }

    public static void printUsage() {
        System.err.println(new ErrorMsg("TRANSFORM_USAGE_STR"));
        if (_allowExit) {
            System.exit(-1);
        }
    }

    public static void _main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                int n2;
                int n3 = -1;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                String string = null;
                for (n2 = 0; n2 < stringArray.length && stringArray[n2].charAt(0) == '-'; ++n2) {
                    if (stringArray[n2].equals("-u")) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[n2].equals("-x")) {
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[n2].equals("-s")) {
                        _allowExit = false;
                        continue;
                    }
                    if (stringArray[n2].equals("-j")) {
                        bl4 = true;
                        string = stringArray[++n2];
                        continue;
                    }
                    if (stringArray[n2].equals("-n")) {
                        try {
                            n3 = Integer.parseInt(stringArray[++n2]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    Transform.printUsage();
                }
                if (stringArray.length - n2 < 2) {
                    Transform.printUsage();
                }
                Transform transform = new Transform(stringArray[n2 + 1], stringArray[n2], bl2, bl3, n3);
                transform.setJarFileInputSrc(bl4, string);
                Vector<Parameter> vector = new Vector<Parameter>();
                n2 += 2;
                while (n2 < stringArray.length) {
                    int n4 = stringArray[n2].indexOf(61);
                    if (n4 > 0) {
                        String string2 = stringArray[n2].substring(0, n4);
                        String string3 = stringArray[n2].substring(n4 + 1);
                        vector.addElement(new Parameter(string2, string3));
                    } else {
                        Transform.printUsage();
                    }
                    ++n2;
                }
                if (n2 == stringArray.length) {
                    transform.setParameters(vector);
                    transform.doTransform();
                    if (_allowExit) {
                        System.exit(0);
                    }
                }
            } else {
                Transform.printUsage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

