/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] exception_types;
    private String name;
    private Class[] parameter_types;
    private Class return_type;
    private int offset;

    private Method() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public native String getName();

    public native int getModifiers();

    public Class getReturnType() {
        if (this.return_type == null) {
            this.getType();
        }
        return this.return_type;
    }

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Method)) {
            return false;
        }
        Method m = (Method)obj;
        return this.declaringClass == m.declaringClass && this.offset == m.offset;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.declaringClass.getName().hashCode();
    }

    public String toString() {
        int i;
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer b = new StringBuffer();
        int mods = this.getModifiers();
        if (mods != 0) {
            Modifier.toString(mods, b);
            b.append(" ");
        }
        Method.appendClassName(b, this.return_type);
        b.append(" ");
        Method.appendClassName(b, this.declaringClass);
        b.append(".");
        b.append(this.getName());
        b.append("(");
        for (i = 0; i < this.parameter_types.length; ++i) {
            Method.appendClassName(b, this.parameter_types[i]);
            if (i >= this.parameter_types.length - 1) continue;
            b.append(",");
        }
        b.append(")");
        if (this.exception_types.length > 0) {
            b.append(" throws ");
            for (i = 0; i < this.exception_types.length; ++i) {
                Method.appendClassName(b, this.exception_types[i]);
                if (i >= this.exception_types.length - 1) continue;
                b.append(",");
            }
        }
        return b.toString();
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private native void getType();

    static void appendClassName(StringBuffer buf, Class k) {
        if (k.isArray()) {
            Method.appendClassName(buf, k.getComponentType());
            buf.append("[]");
        } else {
            buf.append(k.getName());
        }
    }
}

