/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferInt
extends DataBuffer {
    private int[] data;
    private int[][] bankData;

    public DataBufferInt(int size) {
        super(3, size);
        this.data = new int[size];
    }

    public DataBufferInt(int size, int numBanks) {
        super(3, size, numBanks);
        this.bankData = new int[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferInt(int[] dataArray, int size) {
        super(3, size);
        this.data = dataArray;
    }

    public DataBufferInt(int[] dataArray, int size, int offset) {
        super(3, size, 1, offset);
        this.data = dataArray;
    }

    public DataBufferInt(int[][] dataArray, int size) {
        super(3, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferInt(int[][] dataArray, int size, int[] offsets) {
        super(3, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public int[] getData() {
        return this.data;
    }

    public int[] getData(int bank) {
        return this.bankData[bank];
    }

    public int[][] getBankData() {
        return this.bankData;
    }

    public int getElem(int i) {
        return this.data[i + this.offset];
    }

    public int getElem(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]];
    }

    public void setElem(int i, int val) {
        this.data[i + this.offset] = val;
    }

    public void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }
}

