/* 
 * copyright 2002 Edscott Wilson Garcia (GPL-license)
 *
 * This is very simple example program to test several 
 * functions of the Disk Based Hash (DBH) and
 * verify sintaxis and behaviour. A hashed database 
 * is generated from the text input from keyboard.
 *
 * It is not an actual useful program, since the greatest
 * use for DBHashTables is for *very large* data sets. 
 * It is meant only as an example of how to call the
 * various DBH routines.
 *
 */



#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dbh.h>


void operate(DBHashTable *node)
{
     int i;
     printf("\nhash key=");
     for (i=0;i<DBH_KEYLENGTH(node);i++)  printf("%c",*(DBH_KEY(node)+i));
     printf("\tdata length in bytes=%d\tdata=%s",
		     DBH_RECORD_SIZE(node),(char *)DBH_DATA(node));

}

/******************************************************************/
int GetInput(void)
{
 char input[256];
 fgets(input,255,stdin);
 return (atoi(input));
}

int keysize=5;

char *  GetInRecord(DBHashTable *node)
{
 char *input;
 static char key[256];
 int j;
 memset(key,(int)'.',(size_t)DBH_KEYLENGTH(node));
 input=(char *)DBH_DATA(node);
 fgets(input,DBH_MAXIMUM_RECORD_SIZE(node),stdin);
 if (strstr(input,"exit")) return NULL;
 strncpy((void *)key,input,255);
 input[DBH_MAXIMUM_RECORD_SIZE(node)-1]=0;
 for (j=0;j<(int)(strlen(input));j++) if ((input[j]==10)||(input[j]==13))input[j]=0;
 /*printf("using %s to set key.\n",input);*/
 DBH_set_recordsize(node,1+strlen(input));
 {  /* clean entire key */
	 char skey[256];
	 memset(skey,(int)'.',(size_t)DBH_KEYLENGTH(node));
	 DBH_set_key(node,skey);
 }
 DBH_set_key(node,input);
 printf("key has been set to ");
 for (j=0;j<node->head_info->n_limit;j++)printf("%c",*((node->key)+j));
 printf("\n");
 DBH_set_data(node,input,strlen(input)+1);
 return key;
}

#define MESSAGE printf("*** type \"exit\" to terminate ***\n");
int main()
{
 int i,k,size,reopen=0;
 DBHashTable *node;
 char line[80];
 char *j,*filename="test.dbh";

 printf("sizeof(int)=%d\n",sizeof(int));
 printf("sizeof(long)=%d\n",sizeof(long));
 printf("sizeof(char)=%d\n",sizeof(char));
 printf("sizeof(unsigned char)=%d\n",sizeof(unsigned char));
 printf("sizeof(unsigned int)=%d\n",sizeof(unsigned int));

 if ((node=DBH_open(filename))==NULL) 
	 node=DBH_create(filename,(unsigned char)keysize);
 printf("DBH file:\n\trecords=%d\n\tmaximum record size=%d\n\tkeylength=%d",
		 DBH_RECORDS(node),
		 DBH_MAXIMUM_RECORD_SIZE(node),
		 DBH_KEYLENGTH(node));
		 
 /*DBH_info(node);*/
 loop:
 printf("\n(1)add (2)erase (3)unerase (4)prune (5)unprune (6)destroy\n\
(7) Load parent node (8) Load child node\n\
(R)regen (U)sortup (D)sortdown (L)load (F)find subtree root \n(S)size (I)info (P)sweep (Q)fanout (X)exit \n");
 if (fgets(line,79,stdin)==NULL) goto loop;
 switch (line[0])
 {
  case 'P': case 'p':  DBH_foreach_sweep(node,operate); goto loop;
  case 'Q': case 'q':  DBH_foreach_fanout(node,operate); goto loop;
  case 'I': case 'i':  DBH_info(node);  goto loop;
  case 'R': case 'r':  node=DBH_regen(node);  break;
  case 'U': case 'u':  node=DBH_sort(node,1);   break;
  case 'D': case 'd':  node=DBH_sort(node,0);  break;
  case 'L': case 'l':
   printf("\nkey:");  
   j=GetInRecord(node);
   if (j) {
    if (!DBH_load(node))printf("key not found!\n");
    else operate(node);
   }
   goto loop;
  case '1':
   i=0; MESSAGE; 
   do  {
     printf("\ndata %d:",i++);  
     j=GetInRecord(node);	
     if (j) DBH_update(node);
   } while (j); 
   /* flush buffers */
   DBH_close(node); node=DBH_open(filename);
   break;
  case '2':
   i=0; MESSAGE; 
   do  {
    printf("\nerase %d:",i++);   
    j=GetInRecord(node);	
    if (j){
	    if (DBH_erase(node)) printf("unerase success\n");
	    else printf("unerase failure\n");
    }
   } while (j); 
   break;
  case '3':
   i=0; MESSAGE; 
   do  {
    printf("\nunerase %d:",i++);   
    j=GetInRecord(node);	
    if (j) {
	    if (DBH_unerase(node)) printf("unerase success\n");
	    else printf("unerase failure\n");
    }
   } while (j); 
   break;
  case '4':
   { 
     char *key;
     printf("\nprune root key:"); 
     key=GetInRecord(node);
   
     printf("\nLength of subtree (1-%d):",DBH_KEYLENGTH(node));
     i=GetInput();
     if ((i>DBH_KEYLENGTH(node)) || (i<1)){
	  printf("invalid subtree length\n");
	 goto loop;
     } 
     if (DBH_prune(node,key,i)) {printf("prune success\n");}
     else printf("prune failed\n");
   }   
   break;
  case '5':
   { 
     char *key;
     printf("\nunprune root key:"); 
     key=GetInRecord(node);
   
     printf("\nLength of subtree (1-%d):",DBH_KEYLENGTH(node));
     i=GetInput();
     if ((i>DBH_KEYLENGTH(node)) || (i<1)){
	  printf("invalid subtree length\n");
	 goto loop;
     } 
     if (DBH_unprune(node,key,i)) {printf("unprune success\n");}
     else printf("unprune failed\n");
   }   
   break;
  case '6':
   DBH_destroy(node);   
   reopen=1;  
   node=NULL;
  case 'S': case 's':
   printf("\nNew register size:");   
   size=GetInput();
   DBH_Size(node,size);
   if (reopen) {
    printf("\nNew key size:");    
    keysize=GetInput();
    node=DBH_create(filename,(unsigned char)keysize);  
    DBH_info(node);   
    reopen=0;
   } goto loop;
  case '7':
   printf("\nRecord:"); 
   GetInRecord(node);
   i=DBH_load_parent(node);
   if (!i) {printf("cannot load parent node\n");}
   else {printf("parent node has %d branches:\n",i); operate(node);}
   goto loop;
  case '8':
   printf("\nRecord:"); 
   GetInRecord(node);
   printf("\nkey index of child branch (1-%d):",DBH_KEYLENGTH(node));
     i=GetInput();
     if ((i>DBH_KEYLENGTH(node)) || (i<1)){
	  printf("invalid key index\n");
	 goto loop;
     } 
     k=DBH_load_child(node,i);
     if (k) {printf("child node:\n"); operate(node);}
     else printf("child node not found.\n");
     goto loop;
#if 0
  case 'O': case 'o':
  {
   DBH_close(node);
   node=DBH_openmem(filename);  node->operate=operate;
   DBH_membarre(node,NULL,NULL,0);
   DBH_closemem(node);
   node=DBH_open(filename);  node->operate=operate;
  }  goto loop;
#endif
  case 'F': case 'f':
  {
   FILE_POINTER k;
   printf("\nfind subtree root:"); 
   GetInRecord(node);
   printf("\nSignificant bytes of the key (1-%d):",DBH_KEYLENGTH(node));
   i=GetInput();
   if ((i>DBH_KEYLENGTH(node)) || (i<1)) i=DBH_KEYLENGTH(node);
   k=DBH_find(node,i);
   if (!DBH_load_address(node,k)) printf("find object not found\n");
   else { 
	   printf("record found:\n"); 
	   operate(node);
   }
  }
  goto loop;
#if 0
  case 'M': case 'm':
  {
   DBHashTable *Mnode;
   Mnode=DBH_openmem(filename);  
   Mnode->operate=operate;
   printf("\nload from mem:");   
   GetInRecord(Mnode);
   if (!DBH_loadmem(Mnode)) printf("find object not found\n");
   else { printf("record found:\n"); operate(Mnode);}
   DBH_closemem(Mnode);
  }  goto loop;
/* only begin key spedified, with significant keylength */
/* tablenode=sorttabla(node,0,node->head_info->n_limit,1,"darky",NULL,3,0);break;*/
/* begin and end keys specified */
/* tablenode=sorttabla(node,0,node->head_info->n_limit,1,"darky","dorky",NULL);break;*/
 /* unrestricted */
 /* tablenode=sorttabla(node,0,node->head_info->n_limit,1,NULL,NULL,NULL);break;  */
#endif
  case 'X': case 'x':
   DBH_close(node);
   return 0;
  default: goto loop;
 }
 DBH_info(node);
 DBH_sweep(node,operate,NULL,NULL,0); /*unrestricted, equivalent to foreach_sweep*/
/*  DBH_sweep(node,"darky","dingo",NULL);*/
 goto loop;
}



