/* $XFree86$ */
/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_VT1622A_H_
#define _VIA_VT1622A_H_ 1

static const VIABIOSTVMASKTableRec vt1622aMaskTable = {
    { 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0, 0XFF, 0, 0, 0, 0, 0, 0, 0XFF, 0, 0XFF, 0, 0, 0XFF, 0XFF, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0XFF, 0, 0, 0, 0, 0, 0XFF, 0XFF, 0XFF, 0, 0, 0XFF, 0XFF, 0XFF, 0, 0, 0 },
    0X3F, 0X18, 75, 13, 22
};

static const VIABIOSTV3TableRec vt1622aTable[] = {
    {
        { 0X4, 0, 0, 0X6, 0X3, 0, 0X20, 0X28, 0X9A, 0XC, 0X55, 0, 0X52, 0X3B, 0XF, 0, 0, 0, 0XF8, 0X3E, 0X81, 0X56, 0XF1, 0X91, 0X24, 0X25, 0XEA, 0X10, 0, 0X80, 0, 0X11, 0X15, 0XC, 0X5F, 0X75, 0X8, 0X56, 0X2F, 0X90, 0X50, 0, 0, 0XA3, 0X29, 0X5B, 0XBF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X3B, 0XF, 0X7F, 0X23, 0X57, 0X2, 0XF, 0X26, 0X73, 0X63, 0X86, 0XC4, 0XEA, 0XDF, 0X5, 0X92, 0XA1, 0X84, 0, 0, 0X7F, 0X3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X5D, 0X4F, 0X4F, 0X81, 0X52, 0X9D, 0X56, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XE7, 0, 0XDF, 0, 0, 0XDF, 0X57, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XF, 0X7F, 0X7F, 0XF, 0X9A, 0X23, 0XB2, 0XEE, 0X57, 0XDF, 0XDF, 0X57, 0X11, 0XA, 0XE7, 0X2E, 0, 0, 0, 0, 0, 0X28, 0X50, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XF, 0X7F, 0X7F, 0XF, 0X9A, 0X23, 0XB2, 0XEE, 0X57, 0XDF, 0XDF, 0X57, 0X11, 0XA, 0XE7, 0X2E, 0, 0, 0, 0, 0, 0X50, 0XA0, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XF, 0X7F, 0X7F, 0XF, 0X9A, 0X23, 0XB2, 0XEE, 0X57, 0XDF, 0XDF, 0X57, 0X11, 0XA, 0XE7, 0X2E, 0, 0, 0, 0, 0, 0XA0, 0X40, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X7, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9127, 0X9C2B, 0X272C, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5065, 0X4B66, 0X4D67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0XBE16, 0X8717, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0, 0, 0X6, 0, 0, 0X20, 0XBF, 0X9F, 0X37, 0X5D, 0, 0X4F, 0X42, 0XF, 0, 0, 0, 0XAC, 0X15, 0X6E, 0X28, 0X2D, 0X77, 0X66, 0X2D, 0XED, 0X10, 0X2, 0X80, 0, 0X99, 0X17, 0XC, 0X31, 0X7A, 0X4, 0X62, 0X30, 0X8E, 0X4A, 0X5B, 0X15, 0XA0, 0X22, 0X5C, 0XCC, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X43, 0XE7, 0X7F, 0X23, 0X57, 0X2, 0X1F, 0X2F, 0X75, 0X63, 0X8A, 0XC8, 0XF0, 0XFF, 0X5, 0XD7, 0X8E, 0X83, 0X7F, 0XCF, 0XBF, 0X3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X78, 0X4F, 0X4F, 0X9C, 0X55, 0X85, 0X56, 0XBA, 0, 0X40, 0, 0, 0, 0, 0, 0, 0X8, 0, 0XDF, 0, 0, 0XDF, 0X57, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XE7, 0X7F, 0X7F, 0XE7, 0X9A, 0X23, 0XE2, 0X28, 0X57, 0XDF, 0XDF, 0X57, 0X51, 0XA, 0X8, 0X4D, 0, 0, 0, 0, 0, 0X28, 0X50, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XE7, 0X7F, 0X7F, 0XE7, 0X9A, 0X23, 0XE2, 0X28, 0X57, 0XDF, 0XDF, 0X57, 0X51, 0XA, 0X8, 0X4D, 0, 0, 0, 0, 0, 0X50, 0XA0, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XE7, 0X7F, 0X7F, 0XE7, 0X9A, 0X23, 0XE2, 0X28, 0X57, 0XDF, 0XDF, 0X57, 0X51, 0XA, 0X8, 0X4D, 0, 0, 0, 0, 0, 0XA0, 0X40, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X7, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X8D27, 0X962B, 0X202C, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4265, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X84, 0, 0, 0X4, 0X3, 0, 0X20, 0X58, 0XD4, 0X9, 0X52, 0, 0X51, 0X3B, 0XF, 0, 0, 0, 0X6A, 0XD, 0X4C, 0X1C, 0X96, 0X50, 0X5E, 0X1B, 0X3E, 0X10, 0X1, 0X80, 0, 0X44, 0X10, 0XA, 0X9C, 0X75, 0X4, 0X56, 0X41, 0X90, 0X6B, 0, 0, 0XA3, 0X29, 0X86, 0X10, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X3A, 0X27, 0X1F, 0X34, 0XED, 0X2, 0X27, 0XF5, 0X9D, 0X64, 0XB7, 0XD, 0X40, 0, 0X58, 0XB6, 0X3B, 0X85, 0, 0X1, 0XEF, 0X5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X80, 0X63, 0X63, 0X84, 0X69, 0X1A, 0XEC, 0XF0, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X5C, 0, 0X57, 0, 0, 0X57, 0XED, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X27, 0X1F, 0X1F, 0X27, 0XE3, 0X34, 0X49, 0XD6, 0XED, 0X57, 0X57, 0XED, 0X52, 0X12, 0X5D, 0X4D, 0, 0, 0, 0, 0, 0X32, 0X64, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X27, 0X1F, 0X1F, 0X27, 0XE3, 0X34, 0X49, 0XD6, 0XED, 0X57, 0X57, 0XED, 0X52, 0X12, 0X5D, 0X4D, 0, 0, 0, 0, 0, 0X64, 0XC8, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X27, 0X1F, 0X1F, 0X27, 0XE3, 0X34, 0X49, 0XD6, 0XED, 0X57, 0X57, 0XED, 0X52, 0X12, 0X5D, 0X4D, 0, 0, 0, 0, 0, 0XC8, 0X90, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9127, 0X9C2B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4365, 0X4A66, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X1216, 0X4917, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X84, 0, 0, 0X4, 0, 0, 0X20, 0X27, 0XB8, 0XD, 0X5C, 0, 0X4E, 0X40, 0XF, 0, 0, 0, 0XEC, 0X2A, 0XFD, 0X28, 0XE4, 0X7D, 0X7A, 0X27, 0X11, 0X10, 0X1, 0X80, 0, 0XAA, 0X13, 0XC, 0X9F, 0X79, 0XC, 0X62, 0X37, 0X8E, 0X54, 0X5B, 0X15, 0XA0, 0X22, 0X70, 0XF4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X41, 0X97, 0X1F, 0X33, 0XED, 0X2, 0X97, 0X87, 0X87, 0X63, 0X9F, 0XE7, 0X16, 0XE7, 0X16, 0XCC, 0XF3, 0X84, 0, 0X1, 0X4F, 0X4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6E, 0X63, 0X63, 0X92, 0X66, 0X8E, 0XEC, 0XF0, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X5C, 0, 0X57, 0, 0, 0X57, 0XED, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X97, 0X1F, 0X1F, 0X97, 0XDB, 0X33, 0X36, 0X72, 0XED, 0X57, 0X57, 0XED, 0X52, 0X12, 0X5D, 0X4D, 0, 0, 0, 0, 0, 0X32, 0X64, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X97, 0X1F, 0X1F, 0X97, 0XDB, 0X33, 0X36, 0X72, 0XED, 0X57, 0X57, 0XED, 0X52, 0X12, 0X5D, 0X4D, 0, 0, 0, 0, 0, 0X64, 0XC8, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X97, 0X1F, 0X1F, 0X97, 0XDB, 0X33, 0X36, 0X72, 0XED, 0X57, 0X57, 0XED, 0X52, 0X12, 0X5D, 0X4D, 0, 0, 0, 0, 0, 0XC8, 0X90, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5865, 0X5E66, 0X5E67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X84, 0, 0, 0X4, 0X3, 0, 0X20, 0X47, 0X12, 0X8, 0X50, 0, 0X50, 0X3A, 0XF, 0, 0, 0, 0XEF, 0X37, 0X77, 0X2A, 0XD6, 0X66, 0XEB, 0X14, 0XA1, 0X10, 0X5, 0X80, 0, 0X77, 0XD, 0X5, 0XEF, 0X73, 0XC, 0X56, 0X56, 0X90, 0X8B, 0, 0, 0XA3, 0X29, 0XB9, 0X6A, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X39, 0X87, 0XFF, 0X34, 0XB0, 0X3, 0X6F, 0XDC, 0XCD, 0X35, 0XF1, 0X5E, 0XA5, 0X7E, 0X5A, 0X33, 0X26, 0X87, 0, 0X1, 0X27, 0X8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X8C, 0X7F, 0X7F, 0X90, 0X81, 0X8, 0XAF, 0XF5, 0, 0X60, 0, 0, 0, 0, 0, 0, 0XC, 0, 0XFF, 0, 0, 0XFF, 0XB0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X87, 0XFF, 0XFF, 0X87, 0X23, 0X34, 0X9, 0X46, 0XB0, 0XFF, 0XFF, 0XB0, 0X9A, 0X13, 0X14, 0X7A, 0, 0, 0, 0, 0, 0X40, 0X80, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X87, 0XFF, 0XFF, 0X87, 0X23, 0X34, 0X9, 0X46, 0XB0, 0XFF, 0XFF, 0XB0, 0X9A, 0X13, 0X14, 0X7A, 0, 0, 0, 0, 0, 0X80, 0, 0X41, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X87, 0XFF, 0XFF, 0X87, 0X23, 0X34, 0X9, 0X46, 0XB0, 0XFF, 0XFF, 0XB0, 0X9A, 0X13, 0X14, 0X7A, 0, 0, 0, 0, 0, 0, 0, 0X86, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9127, 0X9C2B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5865, 0X4B66, 0X4A67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X1816, 0X6117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X84, 0, 0, 0X4, 0, 0, 0X20, 0X57, 0X25, 0X35, 0X5A, 0, 0X4D, 0X40, 0XF, 0, 0, 0, 0XE8, 0X23, 0XD1, 0X18, 0X72, 0XC3, 0X8C, 0X1A, 0X96, 0X10, 0X7, 0X80, 0, 0XFF, 0XF, 0XC, 0X87, 0X79, 0, 0X62, 0X53, 0X8E, 0X7B, 0X5B, 0X15, 0XA0, 0X22, 0XB6, 0X5A, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X40, 0XAF, 0XFF, 0X34, 0XB5, 0X3, 0X57, 0XA8, 0XC8, 0X35, 0XEC, 0X4C, 0XCC, 0X67, 0X5A, 0X14, 0X5C, 0X6, 0, 0X1, 0X1F, 0X7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X91, 0X7F, 0X7F, 0X95, 0X82, 0XB, 0XB4, 0XF5, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X3D, 0, 0XFF, 0, 0, 0XFF, 0XB5, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0X8, 0X5C, 0XB5, 0XFF, 0XFF, 0XB5, 0X9A, 0X13, 0X3C, 0X64, 0, 0, 0, 0, 0, 0X40, 0X80, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0X8, 0X5C, 0XB5, 0XFF, 0XFF, 0XB5, 0X9A, 0X13, 0X3C, 0X64, 0, 0, 0, 0, 0, 0X80, 0, 0X41, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0X8, 0X5C, 0XB5, 0XFF, 0XFF, 0XB5, 0X9A, 0X13, 0X3C, 0X64, 0, 0, 0, 0, 0, 0, 0, 0X86, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5065, 0X6966, 0X6967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X84, 0, 0, 0X4, 0X3, 0, 0X20, 0XA7, 0XC1, 0X7, 0X50, 0, 0X50, 0X39, 0XF, 0, 0, 0, 0XF0, 0X29, 0X67, 0X31, 0X63, 0XA8, 0X3C, 0X1D, 0X2A, 0X10, 0X3, 0X80, 0, 0X33, 0X11, 0X8, 0X47, 0X73, 0XC, 0X56, 0X3C, 0X90, 0X65, 0, 0, 0XA3, 0X29, 0X7C, 0, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X39, 0XAF, 0X4F, 0X34, 0X44, 0X2, 0XE3, 0XC2, 0X93, 0X63, 0XAD, 0XFD, 0X2B, 0X7C, 0X17, 0X6D, 0XCA, 0X84, 0, 0X1, 0X2F, 0X5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X91, 0X69, 0X69, 0X95, 0X6D, 0X1, 0X43, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XEF, 0, 0XDF, 0, 0, 0XDF, 0X44, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0XCE, 0XE, 0X44, 0XDF, 0XDF, 0X44, 0X11, 0XA, 0XEF, 0X3C, 0, 0, 0, 0, 0, 0X35, 0X6A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0XCE, 0XE, 0X44, 0XDF, 0XDF, 0X44, 0X11, 0XA, 0XEF, 0X3C, 0, 0, 0, 0, 0, 0X6A, 0XD4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0XCE, 0XE, 0X44, 0XDF, 0XDF, 0X44, 0X11, 0XA, 0XEF, 0X3C, 0, 0, 0, 0, 0, 0XD4, 0XA8, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9127, 0X9C2B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4465, 0X4566, 0X4567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X5B16, 0XA017, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0, 0, 0X6, 0, 0, 0X20, 0XA7, 0XE6, 0X6, 0X5C, 0, 0X4E, 0X41, 0XF, 0, 0, 0, 0XE6, 0X23, 0X84, 0X18, 0X18, 0X28, 0X87, 0X1F, 0X56, 0X10, 0X1, 0X80, 0, 0XCC, 0XF, 0XC, 0X60, 0X79, 0, 0X62, 0X46, 0X8E, 0X68, 0X5B, 0X15, 0XA0, 0X22, 0X94, 0X2A, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X40, 0XAF, 0X4F, 0X34, 0X57, 0X2, 0X7F, 0X31, 0XA9, 0X74, 0XD1, 0X2B, 0X5D, 0XAA, 0X58, 0XD7, 0X26, 0X83, 0, 0X1, 0X7F, 0X4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X91, 0X69, 0X69, 0X95, 0X6D, 0X1, 0X56, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XF2, 0, 0XDF, 0, 0, 0XDF, 0X57, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0XD1, 0XE, 0X57, 0XDF, 0XDF, 0X57, 0X11, 0XA, 0XF2, 0X3D, 0, 0, 0, 0, 0, 0X35, 0X6A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0XD1, 0XE, 0X57, 0XDF, 0XDF, 0X57, 0X11, 0XA, 0XF2, 0X3D, 0, 0, 0, 0, 0, 0X6A, 0XD4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0XD1, 0XE, 0X57, 0XDF, 0XDF, 0X57, 0X11, 0XA, 0XF2, 0X3D, 0, 0, 0, 0, 0, 0XD4, 0XA8, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5065, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X4, 0, 0, 0X6, 0X3, 0, 0X20, 0X3F, 0XB6, 0X7, 0X52, 0, 0X51, 0X3A, 0XF, 0, 0, 0, 0XED, 0X31, 0X50, 0X35, 0X18, 0X55, 0X55, 0X1E, 0X1E, 0X10, 0X3, 0X80, 0, 0X33, 0X12, 0X8, 0X57, 0X75, 0, 0X56, 0X3A, 0X90, 0X61, 0, 0, 0XA3, 0X29, 0X76, 0XF1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X3A, 0X47, 0XCF, 0X23, 0X57, 0X2, 0XBF, 0XAD, 0X8D, 0X63, 0XA4, 0XF3, 0X20, 0X36, 0X17, 0X92, 0X33, 0X84, 0, 0, 0XBF, 0X3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X64, 0X59, 0X59, 0X88, 0X5B, 0X81, 0X56, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XFF, 0, 0XDF, 0, 0, 0XDF, 0X57, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X47, 0XCF, 0XCF, 0X47, 0X9A, 0X23, 0XD9, 0XA, 0X57, 0XDF, 0XDF, 0X57, 0X51, 0XA, 0XFF, 0X26, 0, 0, 0, 0, 0, 0X2D, 0X5A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X47, 0XCF, 0XCF, 0X47, 0X9A, 0X23, 0XD9, 0XA, 0X57, 0XDF, 0XDF, 0X57, 0X51, 0XA, 0XFF, 0X26, 0, 0, 0, 0, 0, 0X5A, 0XB4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X47, 0XCF, 0XCF, 0X47, 0X9A, 0X23, 0XD9, 0XA, 0X57, 0XDF, 0XDF, 0X57, 0X51, 0XA, 0XFF, 0X26, 0, 0, 0, 0, 0, 0XB4, 0X68, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9127, 0X9C2B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4265, 0X4966, 0X4867, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0XC316, 0X4C17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0, 0, 0X6, 0, 0, 0X20, 0XF, 0XAF, 0X35, 0X5D, 0, 0X4F, 0X41, 0XF, 0, 0, 0, 0XF8, 0X3C, 0X73, 0X56, 0X32, 0X98, 0X83, 0X2D, 0XED, 0X10, 0X2, 0X80, 0, 0X99, 0X18, 0XC, 0X76, 0X7A, 0X44, 0X62, 0X30, 0X8E, 0X49, 0X5B, 0X15, 0XA0, 0X22, 0X5C, 0XBD, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X43, 0XF7, 0XCF, 0X22, 0XED, 0X2, 0X1D, 0X29, 0X75, 0X63, 0X88, 0XC6, 0XF0, 0XFA, 0XF, 0XCC, 0X30, 0X94, 0, 0, 0X8F, 0X3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X5A, 0X59, 0X59, 0X9E, 0X5B, 0X1D, 0XEC, 0XF0, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X7B, 0, 0X3F, 0, 0, 0X3F, 0XED, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XF7, 0XCF, 0XCF, 0XF7, 0X92, 0X22, 0XDE, 0XE8, 0XED, 0X3F, 0X3F, 0XED, 0X12, 0X12, 0X7F, 0X47, 0, 0, 0, 0, 0, 0X2D, 0X5A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XF7, 0XCF, 0XCF, 0XF7, 0X92, 0X22, 0XDE, 0XE8, 0XED, 0X3F, 0X3F, 0XED, 0X12, 0X12, 0X7F, 0X47, 0, 0, 0, 0, 0, 0X5A, 0XB4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XF7, 0XCF, 0XCF, 0XF7, 0X92, 0X22, 0XDE, 0XE8, 0XED, 0X3F, 0X3F, 0XED, 0X12, 0X12, 0X7F, 0X47, 0, 0, 0, 0, 0, 0XB4, 0X68, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5965, 0X4D66, 0X4A67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    }
};

static const VIABIOSTV3TableRec vt1622aOverTable[] = {
    {
        { 0X4, 0, 0, 0X6, 0X3, 0, 0X20, 0X10, 0X76, 0XA, 0X56, 0X5, 0X50, 0X3B, 0XF, 0, 0, 0, 0XED, 0X23, 0XC0, 0X34, 0X5E, 0XAA, 0XEA, 0X25, 0XE5, 0X10, 0X2, 0X80, 0, 0X11, 0X17, 0XC, 0X46, 0X73, 0XC, 0X56, 0X2E, 0X90, 0X4E, 0, 0, 0XA3, 0X29, 0X59, 0XBA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X3A, 0XCF, 0X7F, 0X22, 0X2F, 0X2, 0XFF, 0X59, 0X71, 0X62, 0X83, 0XC0, 0XE5, 0XC0, 0X5, 0X44, 0X44, 0X84, 0, 0, 0XFF, 0X2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X55, 0X4F, 0X4F, 0X99, 0X51, 0X18, 0X2E, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XEA, 0, 0XDF, 0, 0, 0XDF, 0X2F, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XCF, 0X7F, 0X7F, 0XCF, 0X92, 0X22, 0X9B, 0XC0, 0X2F, 0XDF, 0XDF, 0X2F, 0X11, 0XA, 0XE5, 0X27, 0, 0, 0, 0, 0, 0X28, 0X50, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XCF, 0X7F, 0X7F, 0XCF, 0X92, 0X22, 0X9B, 0XC0, 0X2F, 0XDF, 0XDF, 0X2F, 0X11, 0XA, 0XE5, 0X27, 0, 0, 0, 0, 0, 0X50, 0XA0, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XCF, 0X7F, 0X7F, 0XCF, 0X92, 0X22, 0X9B, 0XC0, 0X2F, 0XDF, 0XDF, 0X2F, 0X11, 0XA, 0XE5, 0X27, 0, 0, 0, 0, 0, 0XA0, 0X40, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4F65, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0XF416, 0X9F17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0, 0, 0X6, 0, 0, 0X20, 0X23, 0X4E, 0X2A, 0X61, 0, 0X4D, 0X47, 0XF, 0, 0, 0, 0X4A, 0XF, 0X37, 0X28, 0XBC, 0X44, 0XC, 0X36, 0XC7, 0X10, 0X2, 0X80, 0, 0X88, 0X1B, 0XC, 0XFF, 0X79, 0, 0X62, 0X28, 0X8E, 0X3E, 0X5B, 0X15, 0XA0, 0X22, 0X49, 0XCC, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X44, 0X47, 0X7F, 0X23, 0XF3, 0X1, 0X9F, 0X3F, 0X62, 0X62, 0X72, 0XA7, 0XCB, 0X5, 0X5, 0X33, 0X70, 0X83, 0, 0, 0X9F, 0X2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X64, 0X4F, 0X4F, 0X88, 0X53, 0X83, 0XF2, 0X1F, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XE5, 0, 0XDF, 0, 0, 0XDF, 0XF3, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X47, 0X7F, 0X7F, 0X47, 0X9A, 0X23, 0X95, 0X27, 0XF3, 0XDF, 0XDF, 0XF3, 0X49, 0X9, 0XE2, 0X24, 0, 0, 0, 0, 0, 0X28, 0X50, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X47, 0X7F, 0X7F, 0X47, 0X9A, 0X23, 0X95, 0X27, 0XF3, 0XDF, 0XDF, 0XF3, 0X49, 0X9, 0XE2, 0X24, 0, 0, 0, 0, 0, 0X50, 0XA0, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X47, 0X7F, 0X7F, 0X47, 0X9A, 0X23, 0X95, 0X27, 0XF3, 0XDF, 0XDF, 0XF3, 0X49, 0X9, 0XE2, 0X24, 0, 0, 0, 0, 0, 0XA0, 0X40, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9027, 0X992B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4265, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X84, 0, 0, 0X4, 0X3, 0, 0X20, 0X5F, 0XA4, 0X8, 0X51, 0, 0X50, 0X39, 0XF, 0, 0, 0, 0XE8, 0X33, 0XE6, 0X18, 0XE0, 0XCE, 0X61, 0X1C, 0X32, 0X10, 0X3, 0X80, 0, 0X33, 0X11, 0XA, 0X9B, 0X73, 0X8, 0X56, 0X3F, 0X90, 0X68, 0, 0, 0XA3, 0X29, 0X82, 0X2, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X39, 0X37, 0X21, 0X34, 0X98, 0X2, 0X1, 0X21, 0X97, 0X74, 0XB1, 0XFF, 0X34, 0XB6, 0X17, 0X11, 0, 0X85, 0, 0X1, 0X57, 0X5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X82, 0X63, 0X63, 0X86, 0X69, 0X1B, 0X97, 0XF0, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X59, 0, 0X57, 0, 0, 0X57, 0X98, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X37, 0X1F, 0X1F, 0X37, 0XE3, 0X34, 0X4A, 0XD7, 0X98, 0X57, 0X57, 0X98, 0X52, 0X12, 0X59, 0X5B, 0, 0, 0, 0, 0, 0X32, 0X64, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X37, 0X1F, 0X1F, 0X37, 0XE3, 0X34, 0X4A, 0XD7, 0X98, 0X57, 0X57, 0X98, 0X52, 0X12, 0X59, 0X5B, 0, 0, 0, 0, 0, 0X64, 0XC8, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X37, 0X1F, 0X1F, 0X37, 0XE3, 0X34, 0X4A, 0XD7, 0X98, 0X57, 0X57, 0X98, 0X52, 0X12, 0X59, 0X5B, 0, 0, 0, 0, 0, 0XC8, 0X90, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4265, 0X4566, 0X4567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X1416, 0XC717, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X84, 0, 0, 0X4, 0, 0, 0X20, 0X47, 0X90, 0X3B, 0X5A, 0, 0X4D, 0X3F, 0XF, 0, 0, 0, 0XE8, 0X24, 0X8F, 0X1C, 0X57, 0X8D, 0XE9, 0X27, 0XE, 0X10, 0X3, 0X80, 0, 0XAA, 0X14, 0XC, 0X2F, 0X79, 0, 0X62, 0X37, 0X8E, 0X54, 0X5B, 0X15, 0XA0, 0X22, 0X6E, 0XF4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X41, 0XE7, 0X1F, 0X33, 0X89, 0X2, 0X8D, 0XCD, 0X85, 0X63, 0X9C, 0XE4, 0X13, 0XD4, 0X16, 0X28, 0X60, 0X84, 0, 0X1, 0XF, 0X4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X78, 0X63, 0X63, 0X9C, 0X68, 0X94, 0X88, 0XF0, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X58, 0, 0X57, 0, 0, 0X57, 0X89, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XE7, 0X1F, 0X1F, 0XE7, 0XDB, 0X33, 0X73, 0XAF, 0X89, 0X57, 0X57, 0X89, 0X52, 0X12, 0X58, 0X5A, 0, 0, 0, 0, 0, 0X32, 0X64, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XE7, 0X1F, 0X1F, 0XE7, 0XDB, 0X33, 0X73, 0XAF, 0X89, 0X57, 0X57, 0X89, 0X52, 0X12, 0X58, 0X5A, 0, 0, 0, 0, 0, 0X64, 0XC8, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XE7, 0X1F, 0X1F, 0XE7, 0XDB, 0X33, 0X73, 0XAF, 0X89, 0X57, 0X57, 0X89, 0X52, 0X12, 0X58, 0X5A, 0, 0, 0, 0, 0, 0XC8, 0X90, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9027, 0X992B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5865, 0X4866, 0X4867, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X84, 0, 0, 0X4, 0X3, 0, 0X20, 0X52, 0XAE, 0X9, 0X50, 0, 0X50, 0X39, 0XF, 0, 0, 0, 0XE8, 0X33, 0XD, 0X15, 0XE, 0X44, 0X44, 0X18, 0X66, 0X10, 0X3, 0X80, 0, 0X55, 0XF, 0X5, 0XF1, 0X73, 0X8, 0X56, 0X4A, 0X90, 0X79, 0, 0, 0XA3, 0X29, 0X9B, 0X33, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X39, 0XAF, 0XFF, 0X34, 0X47, 0X3, 0XAF, 0XC3, 0XB1, 0X34, 0XD1, 0X30, 0X68, 0XB, 0X59, 0X66, 0X40, 0X86, 0, 0X1, 0X7F, 0X7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X91, 0X7F, 0X7F, 0X95, 0X82, 0XB, 0X46, 0XF5, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X4, 0, 0XFF, 0, 0, 0XFF, 0X47, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0XC, 0X57, 0X47, 0XFF, 0XFF, 0X47, 0X9A, 0X13, 0X2, 0X64, 0, 0, 0, 0, 0, 0X40, 0X80, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0XC, 0X57, 0X47, 0XFF, 0XFF, 0X47, 0X9A, 0X13, 0X2, 0X64, 0, 0, 0, 0, 0, 0X80, 0, 0X41, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0XC, 0X57, 0X47, 0XFF, 0XFF, 0X47, 0X9A, 0X13, 0X2, 0X64, 0, 0, 0, 0, 0, 0, 0, 0X86, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5765, 0X4566, 0X4567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X6316, 0X3D17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X84, 0, 0, 0X4, 0, 0, 0X20, 0X56, 0XC0, 0X32, 0X5A, 0, 0X4D, 0X40, 0XF, 0, 0, 0, 0XC9, 0X14, 0X79, 0X1C, 0X38, 0XE, 0X7B, 0X1D, 0X6D, 0X10, 0X3, 0X80, 0, 0XDD, 0XF, 0XC, 0XCA, 0X79, 0X8, 0X62, 0X4B, 0X8E, 0X6F, 0X5B, 0X15, 0XA0, 0X22, 0XA1, 0X5A, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X40, 0XAF, 0XFF, 0X34, 0X38, 0X3, 0XCF, 0XDF, 0XB4, 0X34, 0XD6, 0X35, 0X75, 0X47, 0X59, 0X47, 0X20, 0X5, 0, 0X1, 0X2F, 0X6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X91, 0X7F, 0X7F, 0X95, 0X81, 0XB, 0X37, 0XF5, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X3, 0, 0XFF, 0, 0, 0XFF, 0X38, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0XC, 0X57, 0X38, 0XFF, 0XFF, 0X38, 0X9A, 0X13, 0X1, 0X62, 0, 0, 0, 0, 0, 0X40, 0X80, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0XC, 0X57, 0X38, 0XFF, 0XFF, 0X38, 0X9A, 0X13, 0X1, 0X62, 0, 0, 0, 0, 0, 0X80, 0, 0X41, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0XFF, 0XFF, 0XAF, 0X23, 0X34, 0XC, 0X57, 0X38, 0XFF, 0XFF, 0X38, 0X9A, 0X13, 0X1, 0X62, 0, 0, 0, 0, 0, 0, 0, 0X86, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9027, 0X992B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5165, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X84, 0, 0, 0X4, 0X3, 0, 0X20, 0X4E, 0X9E, 0X7, 0X51, 0, 0X50, 0X3A, 0XF, 0, 0, 0, 0XED, 0X23, 0X8, 0X35, 0XA1, 0X64, 0X93, 0X1B, 0X3C, 0X10, 0X3, 0X80, 0, 0X44, 0X11, 0XA, 0XF0, 0X73, 0X4, 0X56, 0X41, 0X90, 0X6A, 0, 0, 0XA3, 0X29, 0X87, 0XA, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X39, 0XEF, 0X51, 0X33, 0X25, 0X2, 0X1F, 0X47, 0X9C, 0X74, 0XB5, 0XC, 0X3D, 0XF1, 0X57, 0X30, 0XC, 0X84, 0, 0X1, 0X1F, 0X4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X79, 0X69, 0X69, 0X9D, 0X6B, 0X94, 0X24, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XEA, 0, 0XDF, 0, 0, 0XDF, 0X25, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XEF, 0X4F, 0X4F, 0XEF, 0XDB, 0X33, 0X59, 0XA3, 0X25, 0XDF, 0XDF, 0X25, 0X51, 0XA, 0XEA, 0X2F, 0, 0, 0, 0, 0, 0X35, 0X6A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XEF, 0X4F, 0X4F, 0XEF, 0XDB, 0X33, 0X59, 0XA3, 0X25, 0XDF, 0XDF, 0X25, 0X51, 0XA, 0XEA, 0X2F, 0, 0, 0, 0, 0, 0X6A, 0XD4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XEF, 0X4F, 0X4F, 0XEF, 0XDB, 0X33, 0X59, 0XA3, 0X25, 0XDF, 0XDF, 0X25, 0X51, 0XA, 0XEA, 0X2F, 0, 0, 0, 0, 0, 0XD4, 0XA8, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5865, 0X4566, 0X4567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X6716, 0X3017, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X84, 0, 0, 0X4, 0, 0, 0X20, 0XA5, 0XA1, 0X38, 0X5E, 0, 0X4D, 0X41, 0XF, 0, 0, 0, 0XC7, 0X1E, 0X79, 0X1C, 0XEC, 0XE5, 0X64, 0X22, 0X39, 0X10, 0X3, 0X80, 0, 0XBB, 0X12, 0XC, 0X5A, 0X79, 0XC, 0X62, 0X40, 0X8E, 0X5F, 0X5B, 0X15, 0XA0, 0X22, 0X88, 0X2A, 0X10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X3A, 0XAF, 0X4F, 0X34, 0X25, 0X2, 0X1F, 0X4F, 0X9B, 0X74, 0XB7, 0XA, 0X3F, 0XF0, 0X58, 0X85, 0, 0X83, 0, 0X1, 0X1F, 0X4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X91, 0X69, 0X69, 0X95, 0X6D, 0X1, 0X24, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XEA, 0, 0XDF, 0, 0, 0XDF, 0X25, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0X66, 0XF, 0X25, 0XDF, 0XDF, 0X25, 0X11, 0XA, 0XEA, 0X2F, 0, 0, 0, 0, 0, 0X35, 0X6A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0X66, 0XF, 0X25, 0XDF, 0XDF, 0X25, 0X11, 0XA, 0XEA, 0X2F, 0, 0, 0, 0, 0, 0X6A, 0XD4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0XAF, 0X4F, 0X4F, 0XAF, 0XE3, 0X34, 0X66, 0XF, 0X25, 0XDF, 0XDF, 0X25, 0X11, 0XA, 0XEA, 0X2F, 0, 0, 0, 0, 0, 0XD4, 0XA8, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9027, 0X992B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4E65, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0X4, 0, 0, 0, 0X3, 0, 0X20, 0X28, 0X52, 0X8, 0X50, 0, 0X4E, 0X2F, 0XF, 0, 0, 0, 0X2D, 0X7, 0X28, 0X34, 0X1D, 0X66, 0X66, 0X24, 0XEE, 0X10, 0X2, 0X80, 0, 0X11, 0X16, 0X8, 0XDF, 0X76, 0X4, 0X56, 0X31, 0X90, 0X51, 0, 0, 0XA3, 0X29, 0X5D, 0XC3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X8, 0X3A, 0X1F, 0XCF, 0X23, 0XC, 0X2, 0X1F, 0XCE, 0X76, 0X23, 0X88, 0XC9, 0XEF, 0XFF, 0X5, 0, 0, 0, 0, 0, 0X1F, 0X3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X5F, 0X59, 0X59, 0X83, 0X5B, 0X9F, 0XB, 0X3E, 0, 0X40, 0, 0, 0, 0, 0, 0, 0XE0, 0, 0XDF, 0, 0, 0XDF, 0XC, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X1F, 0XCF, 0XCF, 0X1F, 0X9A, 0X23, 0XD6, 0XF8, 0XC, 0XDF, 0XDF, 0XC, 0X11, 0XA, 0XE1, 0X22, 0, 0, 0, 0, 0, 0X2D, 0X5A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X1F, 0XCF, 0XCF, 0X1F, 0X9A, 0X23, 0XD6, 0XF8, 0XC, 0XDF, 0XDF, 0XC, 0X11, 0XA, 0XE1, 0X22, 0, 0, 0, 0, 0, 0X5A, 0XB4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X1F, 0XCF, 0XCF, 0X1F, 0X9A, 0X23, 0XD6, 0XF8, 0XC, 0XDF, 0XDF, 0XC, 0X11, 0XA, 0XE1, 0X22, 0, 0, 0, 0, 0, 0XB4, 0X68, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X2A02, 0X6A65, 0X6266, 0X6567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X4D65, 0X4966, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X3, 0X811, 0X1E16, 0X5C17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    },
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0, 0, 0, 0, 0, 0X20, 0X3F, 0X89, 0X35, 0X50, 0, 0X43, 0X2E, 0XF, 0, 0, 0, 0XE8, 0X23, 0X84, 0X20, 0XCB, 0X8A, 0X9, 0X2A, 0XFF, 0X10, 0X2, 0X80, 0, 0X99, 0X17, 0XC, 0X6F, 0X79, 0X48, 0X62, 0X34, 0X8E, 0X4F, 0X5B, 0X15, 0XA0, 0X22, 0X67, 0XFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0X3A, 0X5F, 0XCF, 0X23, 0X70, 0X2, 0X5F, 0XBF, 0X7E, 0X23, 0X94, 0XD0, 0X27, 0X8F, 0X16, 0, 0, 0X4, 0, 0, 0X5F, 0X3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X67, 0X59, 0X59, 0X8B, 0X60, 0X84, 0X6F, 0XF0, 0, 0X60, 0, 0, 0, 0, 0, 0, 0X41, 0, 0X3F, 0, 0, 0X3F, 0X70, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X20, 0X40, 0, 0, 0X87, 0X1C, 0, 0 },
        { 0, 0, 0, 0X87, 0X1C, 0, 0, 0 },
        { 0X5F, 0XCF, 0XCF, 0X5F, 0X9A, 0X23, 0XF8, 0X20, 0X70, 0X3F, 0X3F, 0X70, 0X52, 0X12, 0X41, 0X48, 0, 0, 0, 0, 0, 0X2D, 0X5A, 0, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X5F, 0XCF, 0XCF, 0X5F, 0X9A, 0X23, 0XF8, 0X20, 0X70, 0X3F, 0X3F, 0X70, 0X52, 0X12, 0X41, 0X48, 0, 0, 0, 0, 0, 0X5A, 0XB4, 0X40, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0X5F, 0XCF, 0XCF, 0X5F, 0X9A, 0X23, 0XF8, 0X20, 0X70, 0X3F, 0X3F, 0X70, 0X52, 0X12, 0X41, 0X48, 0, 0, 0, 0, 0, 0XB4, 0X68, 0X81, 0, 0, 0X80, 0, 0X80, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X6, 0X2A02, 0X6A65, 0X6266, 0X6567, 0X9027, 0X992B, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0X4, 0X302, 0X5865, 0X4866, 0X4967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
    }
};

#endif /* _VIA_VT1622A_H_ */
