/*-
 * customsHname.c --
 *	Map host address to string
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsHname.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <sys/types.h>
#include    <sys/socket.h>
#include    <netdb.h>

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_Hostname --
 *	Return a static string describing host given by address,
 *	preferably a hostname.
 *
 * Results:
 *	See above.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
char *
Customs_Hostname(addr)
    struct in_addr	*addr;	    	/* Address of host */
{
    struct hostent *he;
	
    he = gethostbyaddr ((char *)addr, sizeof(struct in_addr), AF_INET);

    return he ? he->h_name : InetNtoA(*addr);
}
