/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.jvm.hotspot.jdi.VirtualMachineImpl;

public class EventSetImpl
extends ArrayList
implements EventSet {
    private VirtualMachineImpl vm;
    private byte suspendPolicy;
    private boolean needsFiltering = false;

    public String toString() {
        String string = "event set, policy:" + this.suspendPolicy + ", count:" + this.size() + " = {";
        Iterator iter = this.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            Event event = (Event)iter.next();
            if (!first) {
                string = string + ", ";
            }
            string = string + event.toString();
            first = false;
        }
        string = string + "}";
        return string;
    }

    EventSetImpl(VirtualMachine aVm) {
        this.vm = (VirtualMachineImpl)aVm;
    }

    EventSetImpl(VirtualMachine aVm, byte eventCmd) {
        this(aVm);
        this.suspendPolicy = 0;
        switch (eventCmd) {
            case 100: {
                break;
            }
            default: {
                throw new InternalException("Bad singleton event code");
            }
        }
    }

    EventSetImpl(EventSetImpl es, boolean internal) {
        this(es.vm);
        this.suspendPolicy = es.suspendPolicy;
    }

    EventSet userFilter() {
        if (this.needsFiltering) {
            return new EventSetImpl(this, false);
        }
        return this;
    }

    EventSet internalFilter() {
        if (this.needsFiltering) {
            return new EventSetImpl(this, true);
        }
        return null;
    }

    synchronized void build() {
    }

    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    public int suspendPolicy() {
        return this.suspendPolicy;
    }

    public void resume() {
    }

    public Iterator iterator() {
        return new Itr();
    }

    public EventIterator eventIterator() {
        return new Itr();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public class Itr
    implements EventIterator {
        int cursor = 0;

        public boolean hasNext() {
            return this.cursor != EventSetImpl.this.size();
        }

        public Object next() {
            try {
                Object nxt = EventSetImpl.this.get(this.cursor);
                ++this.cursor;
                return nxt;
            }
            catch (IndexOutOfBoundsException e) {
                throw (NoSuchElementException)new NoSuchElementException().initCause(e);
            }
        }

        public Event nextEvent() {
            return (Event)this.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

