/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.X509Certificate;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;

public class BuildStep {
    private static final Debug debug = Debug.getInstance("certpath");
    private Vertex vertex;
    private X509Certificate cert;
    private Throwable throwable;
    private int result;
    public static final int POSSIBLE = 1;
    public static final int BACK = 2;
    public static final int FOLLOW = 3;
    public static final int FAIL = 4;
    public static final int SUCCEED = 5;

    public BuildStep(Vertex vertex, int n2) {
        this.vertex = vertex;
        if (this.vertex != null) {
            this.cert = (X509Certificate)this.vertex.getCertificate();
            this.throwable = this.vertex.getThrowable();
        }
        this.result = n2;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public String getIssuerName() {
        if (this.cert != null) {
            try {
                return this.cert.getIssuerX500Principal().toString();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("BuildStep.getIssuerName() unexpected exception");
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public String getIssuerName(String string) {
        if (this.cert != null) {
            try {
                return this.cert.getIssuerX500Principal().toString();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("BuildStep.getIssuerName() unexpected exception");
                    exception.printStackTrace();
                }
                return string;
            }
        }
        return string;
    }

    public String getSubjectName() {
        if (this.cert != null) {
            try {
                return this.cert.getSubjectX500Principal().toString();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("BuildStep.getSubjectName() unexpected exception");
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public String getSubjectName(String string) {
        if (this.cert != null) {
            try {
                return this.cert.getSubjectX500Principal().toString();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("BuildStep.getSubjectName() unexpected exception");
                    exception.printStackTrace();
                }
                return string;
            }
        }
        return string;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getResult() {
        return this.result;
    }

    public String resultToString(int n2) {
        String string = "";
        switch (n2) {
            case 1: {
                string = "Certificate to be tried.\n";
                break;
            }
            case 2: {
                string = "Certificate backed out since path does not satisfy build requirements.\n";
                break;
            }
            case 3: {
                string = "Certificate satisfies conditions.\n";
                break;
            }
            case 4: {
                string = "Certificate backed out since path does not satisfy conditions.\n";
                break;
            }
            case 5: {
                string = "Certificate satisfies conditions.\n";
                break;
            }
            default: {
                string = "Internal error: Invalid step result value.\n";
            }
        }
        return string;
    }

    public String toString() {
        String string = "Internal Error\n";
        switch (this.result) {
            case 2: 
            case 4: {
                string = this.resultToString(this.result);
                string = string + this.vertex.throwableToString();
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = this.resultToString(this.result);
                break;
            }
            default: {
                string = "Internal Error: Invalid step result\n";
            }
        }
        return string;
    }

    public String verboseToString() {
        String string = this.resultToString(this.getResult());
        switch (this.result) {
            case 2: 
            case 4: {
                string = string + this.vertex.throwableToString();
                break;
            }
            case 3: 
            case 5: {
                string = string + this.vertex.moreToString();
                break;
            }
            case 1: {
                break;
            }
        }
        string = string + "Certificate contains:\n" + this.vertex.certToString();
        return string;
    }

    public String fullToString() {
        String string = this.resultToString(this.getResult());
        string = string + this.vertex.toString();
        return string;
    }
}

