/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CompositeFont;
import sun.font.CompositeGlyphMapper;
import sun.font.PhysicalFont;

public final class FontRunIterator {
    CompositeFont font;
    char[] text;
    int start;
    int limit;
    CompositeGlyphMapper mapper;
    int slot = -1;
    int pos;
    static final int SURROGATE_START = 65536;
    static final int LEAD_START = 55296;
    static final int LEAD_LIMIT = 56320;
    static final int TAIL_START = 56320;
    static final int TAIL_LIMIT = 57344;
    static final int LEAD_SURROGATE_SHIFT = 10;
    static final int SURROGATE_OFFSET = -56613888;
    static final int DONE = -1;

    public void init(CompositeFont compositeFont, char[] cArray, int n2, int n3) {
        if (compositeFont == null || cArray == null || n2 < 0 || n3 < n2 || n3 > cArray.length) {
            throw new IllegalArgumentException();
        }
        this.font = compositeFont;
        this.text = cArray;
        this.start = n2;
        this.limit = n3;
        this.mapper = (CompositeGlyphMapper)compositeFont.getMapper();
        this.slot = -1;
        this.pos = n2;
    }

    public PhysicalFont getFont() {
        return this.slot == -1 ? null : this.font.getSlotFont(this.slot);
    }

    public int getGlyphMask() {
        return this.slot << 24;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean next(int n2, int n3) {
        if (this.pos == n3) {
            return false;
        }
        int n4 = this.nextCodePoint(n3);
        int n5 = this.mapper.charToGlyph(n4) & 0xFF000000;
        this.slot = n5 >>> 24;
        while ((n4 = this.nextCodePoint(n3)) != -1 && (this.mapper.charToGlyph(n4) & 0xFF000000) == n5) {
        }
        this.pushback(n4);
        return true;
    }

    public boolean next() {
        return this.next(0, this.limit);
    }

    final int nextCodePoint() {
        return this.nextCodePoint(this.limit);
    }

    final int nextCodePoint(int n2) {
        char c2;
        int n3;
        if (this.pos >= n2) {
            return -1;
        }
        if ((n3 = this.text[this.pos++]) >= 55296 && n3 < 56320 && this.pos < n2 && (c2 = this.text[this.pos]) >= '\udc00' && c2 < '\ue000') {
            ++this.pos;
            n3 = (n3 << 10) + c2 + -56613888;
        }
        return n3;
    }

    final void pushback(int n2) {
        if (n2 >= 0) {
            this.pos = n2 >= 65536 ? (this.pos -= 2) : --this.pos;
        }
    }
}

