/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Collection;
import java.util.Iterator;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;

abstract class XModalStrategy {
    public static final int MODALITY_APPLICATION_MODAL = 1;
    public static final int MODALITY_TREE_MODAL = 2;
    public static final int MODALITY_APPCONTEXT_MODAL = 4;
    public static final int MODALITY_SYSTEM_MODAL = 8;
    public static final int MODALITY_TREE_SENSITIVE = 128;
    public static final int MODALITY_MOTIF_COMPAT = 1;
    private static XModalStrategy appModal;
    private int hints;

    XModalStrategy() {
    }

    public int getHints() {
        return this.hints;
    }

    protected void setHints(int n2) {
        this.hints = n2;
    }

    static synchronized XModalStrategy getModalStrategy(int n2) {
        if (n2 == 1) {
            if (appModal == null) {
                appModal = new XApplicationModalityTreeUnsensetive();
            }
            return appModal;
        }
        return null;
    }

    public abstract boolean isModalBlocked(XDialogPeer var1, XWindowPeer var2);

    public abstract void modalityStarts(XDialogPeer var1);

    public abstract void modalityEnds(XDialogPeer var1);

    static class XApplicationModalityTreeUnsensetive
    extends XModalStrategy {
        protected XApplicationModalityTreeUnsensetive() {
            this.setHints(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modalityStarts(XDialogPeer xDialogPeer) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                Collection collection = XWindowPeer.getAllUnblockedWindows();
                for (XWindowPeer xWindowPeer : collection) {
                    if (xWindowPeer == xDialogPeer || xWindowPeer.isModalExclude() || !xWindowPeer.isVisible() || xDialogPeer.isParentOf(xWindowPeer)) continue;
                    xWindowPeer.setModalBlocked(xDialogPeer, true);
                    xDialogPeer.addModalBlocked(xWindowPeer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modalityEnds(XDialogPeer xDialogPeer) {
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                Collection collection = xDialogPeer.getBlockedWindows();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ((XWindowPeer)iterator.next()).setModalBlocked(xDialogPeer, false);
                }
                xDialogPeer.clearBlockedWindows();
            }
        }

        public boolean isModalBlocked(XDialogPeer xDialogPeer, XWindowPeer xWindowPeer) {
            return xWindowPeer.isModalBlocked();
        }
    }
}

