/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.servicecontext;

import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContext;
import com.sun.corba.se.spi.servicecontext.ServiceContextData;
import com.sun.corba.se.spi.servicecontext.ServiceContextRegistry;
import com.sun.corba.se.spi.servicecontext.UnknownServiceContext;
import com.sun.org.omg.SendingContext.CodeBase;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContexts {
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;
    private ORB orb;
    private Map scMap;
    private boolean addAlignmentOnWrite;
    private CodeBase codeBase;
    private GIOPVersion giopVersion;
    private ORBUtilSystemException wrapper;

    private static boolean isDebugging(OutputStream outputStream) {
        ORB oRB = (ORB)outputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private static boolean isDebugging(InputStream inputStream) {
        ORB oRB = (ORB)inputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void writeNullServiceContext(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            ORBUtility.dprint("ServiceContexts", "Writing null service context");
        }
        outputStream.write_long(0);
    }

    private void createMapFromInputStream(InputStream inputStream) {
        this.orb = (ORB)inputStream.orb();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        int n2 = inputStream.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = inputStream.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Reading service context id " + n3);
            }
            byte[] byArray = OctetSeqHelper.read(inputStream);
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Service context" + n3 + " length: " + byArray.length);
            }
            this.scMap.put(new Integer(n3), byArray);
        }
    }

    public ServiceContexts(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.addAlignmentOnWrite = false;
        this.scMap = new HashMap();
        this.giopVersion = oRB.getORBData().getGIOPVersion();
        this.codeBase = null;
    }

    public ServiceContexts(InputStream inputStream) {
        this((ORB)inputStream.orb());
        this.codeBase = ((CDRInputStream)inputStream).getCodeBase();
        this.createMapFromInputStream(inputStream);
        this.giopVersion = ((CDRInputStream)inputStream).getGIOPVersion();
    }

    private ServiceContext unmarshal(Integer n2, byte[] byArray) {
        ServiceContextRegistry serviceContextRegistry = this.orb.getServiceContextRegistry();
        ServiceContextData serviceContextData = serviceContextRegistry.findServiceContextData(n2);
        ServiceContext serviceContext = null;
        if (serviceContextData == null) {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Could not find ServiceContextData for " + n2 + " using UnknownServiceContext");
            }
            serviceContext = new UnknownServiceContext((int)n2, byArray);
        } else {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Found " + serviceContextData);
            }
            EncapsInputStream encapsInputStream = new EncapsInputStream((org.omg.CORBA.ORB)this.orb, byArray, byArray.length, this.giopVersion, this.codeBase);
            encapsInputStream.consumeEndian();
            serviceContext = serviceContextData.makeServiceContext(encapsInputStream, this.giopVersion);
            if (serviceContext == null) {
                throw this.wrapper.svcctxUnmarshalError(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return serviceContext;
    }

    public void addAlignmentPadding() {
        this.addAlignmentOnWrite = true;
    }

    public void write(OutputStream outputStream, GIOPVersion gIOPVersion) {
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int n2 = this.scMap.size();
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Adding alignment padding");
            }
            ++n2;
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context has " + n2 + " components");
        }
        outputStream.write_long(n2);
        this.writeServiceContextsInOrder(outputStream, gIOPVersion);
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing alignment padding");
            }
            outputStream.write_long(-1106033203);
            outputStream.write_long(4);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context writing complete");
        }
    }

    private void writeServiceContextsInOrder(OutputStream outputStream, GIOPVersion gIOPVersion) {
        Integer n2 = new Integer(9);
        Object v2 = this.scMap.remove(n2);
        for (Integer n3 : this.scMap.keySet()) {
            this.writeMapEntry(outputStream, n3, this.scMap.get(n3), gIOPVersion);
        }
        if (v2 != null) {
            this.writeMapEntry(outputStream, n2, v2, gIOPVersion);
            this.scMap.put(n2, v2);
        }
    }

    private void writeMapEntry(OutputStream outputStream, Integer n2, Object object, GIOPVersion gIOPVersion) {
        if (object instanceof byte[]) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context bytes for id " + n2);
            }
            OctetSeqHelper.write(outputStream, (byte[])object);
        } else {
            ServiceContext serviceContext = (ServiceContext)object;
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context " + serviceContext);
            }
            serviceContext.write(outputStream, gIOPVersion);
        }
    }

    public void put(ServiceContext serviceContext) {
        Integer n2 = new Integer(serviceContext.getId());
        this.scMap.put(n2, serviceContext);
    }

    public void delete(int n2) {
        this.delete(new Integer(n2));
    }

    public void delete(Integer n2) {
        this.scMap.remove(n2);
    }

    public ServiceContext get(int n2) {
        return this.get(new Integer(n2));
    }

    public ServiceContext get(Integer n2) {
        Object v2 = this.scMap.get(n2);
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof byte[]) {
            ServiceContext serviceContext = this.unmarshal(n2, (byte[])v2);
            this.scMap.put(n2, serviceContext);
            return serviceContext;
        }
        return (ServiceContext)v2;
    }
}

