/*
 * Copyright (C) 2001-2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: lirc.c,v 1.1 2003/02/23 00:58:54 guenter Exp $
 *
 * lirc (infrared control) code based on oxine
 */

#include "config.h"

#include <string.h>
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>

#include <glib.h>

#ifdef HAVE_LIRC
#include <lirc/lirc_client.h>
#endif

static pthread_t             lirc_thread;
static struct lirc_config   *lircconfig;
static int                   lirc_fd;

/* lirc thread
  config file for lirc is ~/.gxine/lircrc
  prog name = gxine
  possible config are: (up, down, left, right, select, menu)
*/

#ifdef HAVE_LIRC
static void *lirc_run (void *data) {

  char  *code, *config;
  int    ret;
  gchar *fname;

  if ((lirc_fd = lirc_init ("gxine", 0)) == -1) {
    printf ("lirc: lirc_init failed. Make sure that you have lircd running\n");
    printf ("lirc: and that you have the permissions to connect to the socket\n");
    pthread_exit(NULL);
    return NULL;
  }

  fname = g_strconcat (g_get_home_dir(), "/.gxine/lircrc", NULL);

  if (lirc_readconfig (fname, &lircconfig, NULL) != 0) {

    printf("lirc: lirc_readconfig of %s failed\n", fname);
    pthread_exit (NULL);
    return NULL;
  }

  while(1) {
    
    pthread_testcancel();
    
    while (lirc_nextcode (&code) == 0) {

      pthread_testcancel();

      if (code == NULL) 
	break;
      
      while ((ret = lirc_code2char (lircconfig, code, &config) == 0) 
	     && (config != NULL)) {

#ifdef LOG
	printf ("lirc: got command '%s'\n", config);
#endif

	gdk_threads_enter();
	action_exec (config, NULL, NULL);
	gdk_threads_leave();

      }
      pthread_testcancel();
      
      free(code);

      if(ret == -1) 
	break;
    }
  }

  pthread_exit(NULL);
  return NULL;
}
#endif /* HAVE_LIRC */

void gxine_lirc_init (void) {

#ifdef HAVE_LIRC
  pthread_create (&lirc_thread, NULL, lirc_run, NULL);
#endif
  
}

void gxine_lirc_quit (void) {
#ifdef HAVE_LIRC
  pthread_cancel (lirc_thread);
#endif
}
