/*
 *  Copyright (C) 2001-2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include "jsobjectproxy.h"
#include "jsvalueproxy.h"
#include "jsopaqueproxy.h"

#include "jsproxy.h"

namespace KJSEmbed {

JSProxy::JSProxy( int type )
    : KJS::ObjectImp(),
      proxytype(type)
{
}

JSProxy::~JSProxy()
{
}

JSObjectProxy *JSProxy::toObjectProxy()
{
    return dynamic_cast<JSObjectProxy *>( this );
}

JSValueProxy *JSProxy::toValueProxy()
{
    return dynamic_cast<JSValueProxy *>( this );
}

JSOpaqueProxy *JSProxy::toOpaqueProxy()
{
    return dynamic_cast<JSOpaqueProxy *>( this );
}

//
// Static conversion methods
//

JSProxy *JSProxy::toProxy( KJS::ValueImp *imp )
{
    return dynamic_cast<JSProxy *>( imp );
}

JSObjectProxy *JSProxy::toObjectProxy( KJS::ValueImp *imp )
{
    return dynamic_cast<JSObjectProxy *>( imp );
}

JSValueProxy *JSProxy::toValueProxy( KJS::ValueImp *imp )
{
    return dynamic_cast<JSValueProxy *>( imp );
}

JSOpaqueProxy *JSProxy::toOpaqueProxy( KJS::ValueImp *imp )
{
    return dynamic_cast<JSOpaqueProxy *>( imp );
}

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:
