/***************************************************************************
                            kde_URLArgs.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_URLARGS
#define KDE_URLARGS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 URLArgs is a set of arguments bundled into a structure,
 to allow specifying how a URL should be opened by openURL().
 In other words, this is like arguments to openURL(), but without
 have to change the signature of openURL() (since openURL is a
 generic KParts method).
 The parts (with a browser extension) who care about urlargs will
 use those arguments, others will ignore them.

 This can also be used the other way round, when a part asks
 for a URL to be opened (with openURLRequest or createNewWindow).
 
 @short *
 URLArgs is a set of arguments bundled into a structure,
 to allow specifying how a URL should be opened by openURL().
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_URLArgs * kde_new_URLArgs();
kde_URLArgs * kde_new_URLArgs1(kde_URLArgs* args);
kde_URLArgs * kde_new_URLArgs2(int reload, int xOffset, int yOffset, qt_QString * serviceType);
void kde_del_URLArgs( kde_URLArgs* p );

/** *
 KHTML-specific field, header defining the type of the POST data.
   
*/
void kde_URLArgs_setContentType(kde_URLArgs* instPointer,qt_QString * contentType);

/** *
 KHTML-specific field, header defining the type of the POST data.
   
*/
qt_QString * kde_URLArgs_contentType(kde_URLArgs* instPointer);

/** *
 KHTML-specific field, whether to do a POST instead of a GET,
 for the next openURL.
   
*/
void kde_URLArgs_setDoPost(kde_URLArgs* instPointer,int enable);

/** *
 KHTML-specific field, whether to do a POST instead of a GET,
 for the next openURL.
   
*/
int kde_URLArgs_doPost(kde_URLArgs* instPointer);

/** *
 Whether to lock the history when opening the next URL.
 This is used during e.g. a redirection, to avoid a new entry
 in the history.
   
*/
void kde_URLArgs_setLockHistory(kde_URLArgs* instPointer,int lock);
int kde_URLArgs_lockHistory(kde_URLArgs* instPointer);

/** *
 Whether the URL should be opened in a new tab instead in a new window.
   
*/
void kde_URLArgs_setNewTab(kde_URLArgs* instPointer,int newTab);
int kde_URLArgs_newTab(kde_URLArgs* instPointer);

#ifdef __cplusplus
}
#endif
#endif
