/***************************************************************************
                            kde_Observer.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_OBSERVER
#define KDE_OBSERVER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Observer for @ref KIO::Job progress information
 This class, of which there is always only one instance,
 "observes" what jobs do and forwards this information
 to the progress-info server.

 It is a DCOP object so that the UI server can call the
 kill method when the user presses Cancel.

 @author David Faure <faure@kde.org>
 
 @short Observer for @ref KIO::Job progress information.
*/

/** *
 Called by the job constructor, to signal its presence to the
 UI Server.

*/
#ifdef __cplusplus
extern   "C" {
#endif
int kde_Observer_newJob(kde_Observer* instPointer,kde_Job* job, int showProgress);

/** *
 Called by the job destructor, to tell the UI Server that
 the job ended
   
*/
void kde_Observer_jobFinished(kde_Observer* instPointer,int progressId);

/** *

   
*/
int kde_Observer_openPassDlg(kde_Observer* instPointer,qt_QString * prompt, qt_QString * user, qt_QString * pass, int readOnly);
int kde_Observer_openPassDlg1(kde_Observer* instPointer,kde_AuthInfo* info);

/** *
 See renamedlg.h
   
*/

/** *
 See skipdlg.h
   
*/

/** *
 Called by the UI Server (using DCOP) to get all the metadata of the job
   
*/
void kde_Observer_stating(kde_Observer* instPointer,kde_Job* arg1, kde_KURL* url);
void kde_Observer_mounting(kde_Observer* instPointer,kde_Job* arg1, qt_QString * dev, qt_QString * point);
void kde_Observer_unmounting(kde_Observer* instPointer,kde_Job* arg1, qt_QString * point);
void kde_Observer_slotTotalFiles(kde_Observer* instPointer,kde_Job* arg1, unsigned long files);
void kde_Observer_slotTotalDirs(kde_Observer* instPointer,kde_Job* arg1, unsigned long dirs);
void kde_Observer_slotProcessedFiles(kde_Observer* instPointer,kde_Job* arg1, unsigned long files);
void kde_Observer_slotProcessedDirs(kde_Observer* instPointer,kde_Job* arg1, unsigned long dirs);
void kde_Observer_slotSpeed(kde_Observer* instPointer,kde_Job* arg1, unsigned long bytes_per_second);
void kde_Observer_slotPercent(kde_Observer* instPointer,kde_Job* arg1, unsigned long percent);
void kde_Observer_slotInfoMessage(kde_Observer* instPointer,kde_Job* arg1, qt_QString * msg);
void kde_Observer_slotCopying(kde_Observer* instPointer,kde_Job* arg1, kde_KURL* from, kde_KURL* to);
void kde_Observer_slotMoving(kde_Observer* instPointer,kde_Job* arg1, kde_KURL* from, kde_KURL* to);
void kde_Observer_slotDeleting(kde_Observer* instPointer,kde_Job* arg1, kde_KURL* url);
void kde_Observer_slotTransferring(kde_Observer* instPointer,kde_Job* arg1, kde_KURL* url);
void kde_Observer_slotCreatingDir(kde_Observer* instPointer,kde_Job* arg1, kde_KURL* dir);

/** *

*/
kde_Observer* kde_Observer_self( );

/** *
 Popup a message box. See @ref KIO::SlaveBase.
 This doesn't use DCOP anymore, it shows the dialog in the application's process.
 Otherwise, other apps would block when trying to communicate with UIServer.
   
*/
int kde_Observer_messageBox( int progressId, int type, qt_QString * text, qt_QString * caption, qt_QString * buttonYes, qt_QString * buttonNo);
kde_Observer * kde_new_Observer();
void kde_del_Observer( kde_Observer* p );
void kde_Observer_virtual_hook(kde_Observer* instPointer,int identifier, void* data);

/** Casts a 'kde_Observer *' to a 'kde_DCOPObject*' */
kde_DCOPObject* kde_Observer_DCOPObject(kde_Observer* instPointer);

/** Casts a 'kde_Observer *' to a 'qt_QObject *' */
qt_QObject * kde_Observer_QObject(kde_Observer* instPointer);

#ifdef __cplusplus
}
#endif
#endif
