/***************************************************************************
                            kde_KRandomSequence.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRANDOMSEQUENCE
#define KDE_KRANDOMSEQUENCE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A class to create a pseudo-random sequence

 Given a seed number, this class will produce a sequence of
 pseudo-random numbers.  This would typically be used in
 applications like games.

 In general, you should instantiate a KRandomSequence object and
 pass along your seed number in the constructor.  From then on,
 simply call @ref getDouble or @ref getLong to obtain the next
 number in the sequence.

 @author Sean Harmer <sh@astro.keele.ac.uk>
 
 @short *
 A class to create a pseudo-random sequence

*/

/** *
 Creates a pseudo-random sequence based on the seed lngSeed.

 A Pseudo-random sequence is different for each seed but can be 
 reproduced by starting the sequence with the same seed.

 If you need a single value which needs to be unpredictable, 
 you need to use kapp->random() instead.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KRandomSequence * kde_new_KRandomSequence(long lngSeed);

/** *
 Standard destructor
   
*/
void kde_del_KRandomSequence( kde_KRandomSequence* p );

/** *
 Copy constructor
   
*/
kde_KRandomSequence * kde_new_KRandomSequence1(kde_KRandomSequence* a);

/** *
 Restart the sequence based on lngSeed.

*/
void kde_KRandomSequence_setSeed(kde_KRandomSequence* instPointer,long lngSeed);

/** *
 Get the next number from the pseudo-random sequence.

*/
double kde_KRandomSequence_getDouble(kde_KRandomSequence* instPointer);

/** *
 Get the next number from the pseudo-random sequence.

*/
unsigned long kde_KRandomSequence_getLong(kde_KRandomSequence* instPointer,unsigned long max);

/** *
 Get a boolean from the pseudo-random sequence.

*/
int kde_KRandomSequence_getBool(kde_KRandomSequence* instPointer);

/** *
 Put a list in random order.

*/
void kde_KRandomSequence_randomize(kde_KRandomSequence* instPointer,qt_QGList* list);

/** *
 Modulate the random sequence. 

 If S(i) is the sequence of numbers that will follow 
 given the current state after calling modulate(i), 
 then S(i) != S(j) for i != j and   
      S(i) == S(j) for i == j.

 This can be usefull in game situation where "undo" restores
 the state of the random sequence. If the game modulates the
 random sequence with the move chosen by the player, the 
 random sequence will be identical whenever the player "redo"-s 
 his or hers original move, but different when the player 
 chooses another move.

 With this scenario "undo" can no longer be used to repeat a 
 certain move over and over again until the computer reacts 
 with a favourable response or to predict the response for a 
 certain move based on the response to another move.

*/
void kde_KRandomSequence_modulate(kde_KRandomSequence* instPointer,int i);

#ifdef __cplusplus
}
#endif
#endif
