/***************************************************************************
                            kde_KLed.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLED
#define KDE_KLED

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
* 
 Displays a round  or rectangular light emitting diode.

 It is configurable to five colors, the two on/off states and three
 styles (or "looks");

 It may display itself in a performant flat view, a round view with
 light spot or a round view sunken in the screen.

 @author Joerg Habenicht, Richard J. Moore (rich@kde.org) 1998, 1999
 
 @short An LED widget.

*/
#define KLED_Off	0
#define KLED_On	1
#define KLED_Rectangular	0
#define KLED_Circular	1
#define KLED_Flat	0
#define KLED_Raised	1
#define KLED_Sunken	2

/** *
 Constructs a green, round LED widget which will initially
 be turned on.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KLed * kde_new_KLed(qt_QWidget * parent, char* name);

/** *
 Constructor with the ledcolor, the parent widget, and the name.

 The State will be defaulted On and the Look round.

*/
kde_KLed * kde_new_KLed1(qt_QColor * col, qt_QWidget * parent, char* name);

/** *
 Constructor with the ledcolor, ledstate, ledlook,
 the parent widget, and the name.

 Differs from above only in the parameters, which configure all settings.

*/
kde_KLed * kde_new_KLed2(qt_QColor * col, int st, int look, int shape, qt_QWidget * parent, char* name);

/** *
 Destructor

*/
void kde_del_KLed( kde_KLed* p );

/** *
 Returns the current state of the widget (on/off).

*/
int kde_KLed_state(kde_KLed* instPointer);
int kde_KLed_shape(kde_KLed* instPointer);

/** *
 Returns the color of the widget

*/
qt_QColor * kde_KLed_color(kde_KLed* instPointer);

/** *
 Returns the look of the widget.

*/
int kde_KLed_look(kde_KLed* instPointer);

/** *
 Returns the factor to darken the LED.

*/
int kde_KLed_darkFactor(kde_KLed* instPointer);

/** *
 Sets the state of the widget to On or Off.

 The widget will be painted immediately.

*/
void kde_KLed_setState(kde_KLed* instPointer,int state);

/** *
 Set the shape of the LED to @p s.
   
*/
void kde_KLed_setShape(kde_KLed* instPointer,int s);

/** *
 Toggle the state of the LED from Off to On and vice versa.

 The widget will be repainted when returning to the main
 event loop.

   
*/
void kde_KLed_toggleState(kde_KLed* instPointer);

/** *
 Set the color of the widget.
 The Color is shown with the KLed::On state.
 The KLed::Off state is shown with QColor.dark() method

 The widget calls the update() method, so it will
 be updated when entering the main event loop.

*/
void kde_KLed_setColor(kde_KLed* instPointer,qt_QColor * color);

/** *
 Sets the factor to darken the LED in OFF state.
 Same as @ref QColor::dark().
 "darkfactor should be greater than 100, else the LED gets lighter
 in OFF state.
 Defaults to 300.

*/
void kde_KLed_setDarkFactor(kde_KLed* instPointer,int darkfactor);

/** *
 Sets the look of the widget.

 The look may be flat, round or sunken.
 The widget calls the update() method, so it will
 be updated when entering the main event loop.

*/
void kde_KLed_setLook(kde_KLed* instPointer,int look);
qt_QSize * kde_KLed_sizeHint(kde_KLed* instPointer);
qt_QSize * kde_KLed_minimumSizeHint(kde_KLed* instPointer);

/** *
 Toggles the state of the led from Off to On or vice versa.

 The widget repaints itself immediately.
   
*/
void kde_KLed_toggle(kde_KLed* instPointer);

/** *
 Sets the state of the widget to On.

 The widget will be painted immediately.

*/
void kde_KLed_on(kde_KLed* instPointer);

/** *
 Sets the state of the widget to Off.

 The widget will be painted immediately.

*/
void kde_KLed_off(kde_KLed* instPointer);

/** *
 Paints a circular, flat LED.
   
*/
void kde_KLed_paintFlat(kde_KLed* instPointer);

/** *
 Paints a circular, raised LED.
   
*/
void kde_KLed_paintRound(kde_KLed* instPointer);

/** *
 Paints a circular, sunken LED.
   
*/
void kde_KLed_paintSunken(kde_KLed* instPointer);

/** *
 Paints a rectangular, flat LED.
   
*/
void kde_KLed_paintRect(kde_KLed* instPointer);

/** *
 Paints a rectangular LED, either raised or 
 sunken, depending on its argument.
   
*/
void kde_KLed_paintRectFrame(kde_KLed* instPointer,int raised);
void kde_KLed_virtual_hook(kde_KLed* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
