/***************************************************************************
                            kde_KFileView.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILEVIEW
#define KDE_KFILEVIEW

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class defines an interface to all file views. Its intent is
 to allow to switch the view of the files in the selector very easily.
 It defines some pure virtual functions, that must be implemented to
 make a file view working.

 Since this class is not a widget, but it's meant to be added to other
 widgets, its most important function is @ref #widget. This should return
 a pointer to the implemented widget.

 @author Stephan Kulow <coolo@kde.org>

 @version $Id: kde_KFileView.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $

 @short A base class for views of the KDE file selector.
*/
#define KFILEVIEW_Files	1
#define KFILEVIEW_Directories	2
#define KFILEVIEW_All	KFILEVIEW_Files|KFILEVIEW_Directories

/** *
 Destructor
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_KFileView( kde_KFileView* p );

/** *
 inserts a list of items.

*/
void kde_KFileView_addItemList(kde_KFileView* instPointer,kde_KFileItemList* list);

/** *
 a pure virtual function to get a QWidget, that can be added to
 other widgets. This function is needed to make it possible for
 derived classes to derive from other widgets.

*/
qt_QWidget * kde_KFileView_widget(kde_KFileView* instPointer);

/** *
 ### As const-method, to be fixed in 3.0
     
*/
qt_QWidget * kde_KFileView_widget1(kde_KFileView* instPointer);

/** *
 Sets @p filename the current item in the view, if available.
     
*/
void kde_KFileView_setCurrentItem(kde_KFileView* instPointer,qt_QString * filename);

/** *
 Reimplement this to set @p item the current item in the view, e.g.
 the item having focus.
     
*/
void kde_KFileView_setCurrentItem1(kde_KFileView* instPointer,kde_KFileItem* item);

/** *

*/
kde_KFileItem* kde_KFileView_currentFileItem(kde_KFileView* instPointer);

/** *
 Clears the view and all item lists.
     
*/
void kde_KFileView_clear(kde_KFileView* instPointer);

/** *
 does a repaint of the view.

 The default implementation calls
 <pre>widget()->repaint(f)</pre>

*/
void kde_KFileView_updateView(kde_KFileView* instPointer,int f);
void kde_KFileView_updateView1(kde_KFileView* instPointer,kde_KFileItem* arg1);

/** *
 Removes an item from the list; has to be implemented by the view.
 Call KFileView::removeItem( item ) after removing it.
     
*/
void kde_KFileView_removeItem(kde_KFileView* instPointer,kde_KFileItem* item);

/** *
 This hook is called when all items of the currently listed directory
 are listed and inserted into the view, i.e. there won't come any new
 items anymore.
     
*/
void kde_KFileView_listingCompleted(kde_KFileView* instPointer);

/** *
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.
      
*/
int kde_KFileView_sorting(kde_KFileView* instPointer);

/** *
 Sets the sorting order of the view.

 Default is QDir::Name | QDir::IgnoreCase | QDir::DirsFirst
 Override this in your subclass and sort accordingly (usually by
 setting the sorting-key for every item and telling QIconView
 or QListView to sort.

 A view may choose to use a different sorting than QDir::Name, Time
 or Size. E.g. to sort by mimetype or any possible string. Set the
 sorting to QDir::Unsorted for that and do the rest internally.

*/
void kde_KFileView_setSorting(kde_KFileView* instPointer,int sort);

/** *
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir::Reversed).
     
*/
int kde_KFileView_isReversed(kde_KFileView* instPointer);
void kde_KFileView_sortReversed(kde_KFileView* instPointer);

/** *

*/
unsigned int kde_KFileView_count(kde_KFileView* instPointer);

/** *

*/
unsigned int kde_KFileView_numFiles(kde_KFileView* instPointer);

/** *

*/
unsigned int kde_KFileView_numDirs(kde_KFileView* instPointer);
void kde_KFileView_setSelectionMode(kde_KFileView* instPointer,int sm);
int kde_KFileView_selectionMode(kde_KFileView* instPointer);
void kde_KFileView_setViewMode(kde_KFileView* instPointer,int vm);
int kde_KFileView_viewMode(kde_KFileView* instPointer);

/** *

*/
qt_QString * kde_KFileView_viewName(kde_KFileView* instPointer);

/** *
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".
     
*/
void kde_KFileView_setViewName(kde_KFileView* instPointer,qt_QString * name);
void kde_KFileView_setParentView(kde_KFileView* instPointer,kde_KFileView* parent);

/** *
 The derived view must implement this function to add
 the file in the widget.

 Make sure to call this implementation, i.e.
 KFileView::insertItem( i );

     
*/
void kde_KFileView_insertItem(kde_KFileView* instPointer,kde_KFileItem* i);

/** *
 pure virtual function, that should be implemented to clear
 the view. At this moment the list is already empty

*/
void kde_KFileView_clearView(kde_KFileView* instPointer);

/** *
 pure virtual function, that should be implemented to make item i
 visible, i.e. by scrolling the view appropriately.
     
*/
void kde_KFileView_ensureItemVisible(kde_KFileView* instPointer,kde_KFileItem* i);

/** *
 Clears any selection, unhighlights everything. Must be implemented by
 the view.
     
*/
void kde_KFileView_clearSelection(kde_KFileView* instPointer);

/** *
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling setSelected() with every item.
 This works only in Multiselection mode of course.
     
*/
void kde_KFileView_selectAll(kde_KFileView* instPointer);

/** *
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.
     
*/
void kde_KFileView_invertSelection(kde_KFileView* instPointer);

/** *
 Tells the view that it should highlight the item.
 This function must be implemented by the view.

*/
void kde_KFileView_setSelected(kde_KFileView* instPointer,kde_KFileItem* arg1, int enable);

/** *

*/
int kde_KFileView_isSelected(kde_KFileView* instPointer,kde_KFileItem* arg1);

/** *

*/
kde_KFileItemList* kde_KFileView_selectedItems(kde_KFileView* instPointer);

/** *

*/
kde_KFileItemList* kde_KFileView_items(kde_KFileView* instPointer);
kde_KFileItem* kde_KFileView_firstFileItem(kde_KFileView* instPointer);
kde_KFileItem* kde_KFileView_nextItem(kde_KFileView* instPointer,kde_KFileItem* arg1);
kde_KFileItem* kde_KFileView_prevItem(kde_KFileView* instPointer,kde_KFileItem* arg1);

/** *
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on @ref onlyDoubleClickSelectsFiles().
     
*/
void kde_KFileView_setOnlyDoubleClickSelectsFiles(kde_KFileView* instPointer,int enable);

/** *

*/
int kde_KFileView_onlyDoubleClickSelectsFiles(kde_KFileView* instPointer);

/** *
 increases the number of dirs and files.

*/
int kde_KFileView_updateNumbers(kde_KFileView* instPointer,kde_KFileItem* i);

/** *

*/
kde_KActionCollection* kde_KFileView_actionCollection(kde_KFileView* instPointer);
kde_KFileViewSignaler* kde_KFileView_signaler(kde_KFileView* instPointer);
void kde_KFileView_readConfig(kde_KFileView* instPointer,kde_KConfig* arg1, qt_QString * group);
void kde_KFileView_writeConfig(kde_KFileView* instPointer,kde_KConfig* arg1, qt_QString * group);

/** *
 This method calculates a QString from the given parameters, that is
 suitable for sorting with e.g. QIconView or QListView. Their
 Item-classes usually have a setKey( const QString& ) method or a virtual
 method QString key() that is used for sorting.

*/
qt_QString * kde_KFileView_sortingKey( qt_QString * value, int isDir, int sortSpec);

/** *
 An overloaded method that takes not a QString, but a number as sort
 criterion. You can use this for file-sizes or dates/times for example.
 If you use a time_t, you need to cast that to KIO::filesize_t because
 of ambiguity problems.
     
*/

#ifdef __cplusplus
}
#endif
#endif
