/***************************************************************************
                            kde_KConfigBackEnd.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCONFIGBACKEND
#define KDE_KCONFIGBACKEND

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Abstract base class for KDE configuration file loading/saving.

 This class forms the base for all classes that implement some
 manner of loading/saving to configuration files.  It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. As of right now, the only back end available
 is one to read/write to INI-style files, but in the future, other
 formats may be available, such as XML or a database.

 @author Preston Brown <pbrown@kde.org>, 
         Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: kde_KConfigBackEnd.h,v 1.5 2002/12/30 14:37:05 geiseri Exp $

 @short KDE Configuration file loading/saving abstract base class.
*/

/** *
 Destructs the configuration backend.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_KConfigBackEnd( kde_KConfigBackEnd* p );

/** *
 Parses all configuration files for a configuration object.  This
 method must be reimplemented by the derived classes.

*/
int kde_KConfigBackEnd_parseConfigFiles(kde_KConfigBackEnd* instPointer);

/** *
 Writes configuration data to file(s).  This method must be
 reimplemented by the derived classes.

*/
void kde_KConfigBackEnd_sync(kde_KConfigBackEnd* instPointer,int bMerge);

/** *
 Changes the filenames associated with this back end.  You should
 probably reparse your config info after doing this.

*/
void kde_KConfigBackEnd_changeFileName(kde_KConfigBackEnd* instPointer,qt_QString * _fileName, char* _resType, int _useKDEGlobals);

/** *
 Returns the state of the app-config object.

*/

/** *
 Returns the filename as passed to the constructor.

*/
qt_QString * kde_KConfigBackEnd_fileName(kde_KConfigBackEnd* instPointer);

/** *
 Returns the resource type as passed to the constructor.

*/
char* kde_KConfigBackEnd_resource(kde_KConfigBackEnd* instPointer);

/** *
 Set the locale string that defines the current language.

*/
void kde_KConfigBackEnd_setLocaleString(kde_KConfigBackEnd* instPointer,qt_QCString* _localeString);

/** *
 Set the file mode for newly created files.

*/
void kde_KConfigBackEnd_setFileWriteMode(kde_KConfigBackEnd* instPointer,int mode);

#ifdef __cplusplus
}
#endif
#endif
