/***************************************************************************
                            kde_KBugReport.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KBUGREPORT
#define KDE_KBUGREPORT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A dialog box for sending bug reports.
 All the information needed by the dialog box
 (program name, version, bug-report address, etc.)
 comes from the @ref KAboutData class.
 Make sure you create an instance of KAboutData and pass it
 to @ref KCmdLineArgs.

 @author David Faure <faure@kde.org>
 
 @short A dialog box for sending bug reports.

*/

/** *
 Creates a bug-report dialog.
 Note that you shouldn't have to do this manually,
 since @ref KHelpMenu takes care of the menu item
 for "Report Bug..." and of creating a KBugReport dialog.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KBugReport * kde_new_KBugReport(qt_QWidget * parent, int modal, kde_KAboutData* aboutData);

/** *
 Destructor
   
*/
void kde_del_KBugReport( kde_KBugReport* p );
qt_QString * kde_KBugReport_text(kde_KBugReport* instPointer);
int kde_KBugReport_sendBugReport(kde_KBugReport* instPointer);
void kde_KBugReport_virtual_hook(kde_KBugReport* instPointer,int identifier, void* data);

/** *
 "Configure email" has been clicked - this calls kcmshell System/email
   
*/
void kde_KBugReport_slotConfigureEmail(kde_KBugReport* instPointer);

/** *
 Sets the "From" field from the e-mail configuration
 Called at creation time, but also after "Configure email" is closed.
   
*/
void kde_KBugReport_slotSetFrom(kde_KBugReport* instPointer);

/** *
 The URL-Label "http://bugs.kde.org/" was clicked.
   
*/
void kde_KBugReport_slotUrlClicked(kde_KBugReport* instPointer,qt_QString * arg1);

/** *
 OK has been clicked
   
*/
void kde_KBugReport_slotOk(kde_KBugReport* instPointer);

/** *
 Cancel has been clicked
   
*/
void kde_KBugReport_slotCancel(kde_KBugReport* instPointer);
void kde_KBugReport_appChanged(kde_KBugReport* instPointer,int arg1);
void kde_KBugReport_updateURL(kde_KBugReport* instPointer);

#ifdef __cplusplus
}
#endif
#endif
