/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.InternalSaxonError;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tinytree.TinyBuilder;
import javax.xml.transform.TransformerException;

public final class TextFragmentValue
extends SingletonNodeSet {
    private String text;
    private String baseURI;
    private Controller controller;

    public TextFragmentValue(String string, String string2, Controller controller) {
        this.text = string;
        this.node = null;
        this.baseURI = string2;
        this.controller = controller;
        this.generalUseAllowed = false;
    }

    public String asString() {
        return this.text;
    }

    public void outputStringValue(Outputter outputter, Context context) throws TransformerException {
        outputter.writeContent(this.text);
    }

    public double asNumber() {
        return Value.stringToNumber(this.text);
    }

    public boolean asBoolean() {
        return true;
    }

    public int getCount() {
        return 1;
    }

    public Expression simplify() {
        return this;
    }

    public NodeInfo getFirst() {
        return this.getRootNode();
    }

    public NodeEnumeration enumerate() {
        return new SingletonEnumeration(this.getRootNode());
    }

    public boolean equals(Value value) throws XPathException {
        if (value instanceof StringValue) {
            return this.text.equals(value.asString());
        }
        return new StringValue(this.text).equals(value);
    }

    public boolean notEquals(Value value) throws XPathException {
        return new StringValue(this.text).notEquals(value);
    }

    public boolean compare(int n, Value value) throws XPathException {
        return new StringValue(this.text).compare(n, value);
    }

    public int getType() {
        return 4;
    }

    public int getDataType() {
        return 4;
    }

    public DocumentInfo getRootNode() {
        if (this.node != null) {
            return (DocumentInfo)this.node;
        }
        try {
            int n = this.text.length();
            char[] cArray = new char[n];
            this.text.getChars(0, n, cArray, 0);
            TinyBuilder tinyBuilder = new TinyBuilder();
            tinyBuilder.setSystemId(this.baseURI);
            tinyBuilder.setNamePool(this.controller.getNamePool());
            ((Emitter)tinyBuilder).startDocument();
            ((Emitter)tinyBuilder).characters(cArray, 0, n);
            ((Emitter)tinyBuilder).endDocument();
            this.node = tinyBuilder.getCurrentDocument();
            this.controller.getDocumentPool().add((DocumentInfo)this.node, null);
            return (DocumentInfo)this.node;
        }
        catch (TransformerException transformerException) {
            throw new InternalSaxonError("Error building temporary tree: " + transformerException.getMessage());
        }
    }

    public void copy(Outputter outputter) throws TransformerException {
        outputter.writeContent(this.text);
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "** result tree fragment ** (" + this.text + ")");
    }
}

