#!/bin/sh

#
#	ppp-on
#
#	Set up a PPP link
#

LOCKDIR=/usr/spool/uucp
DEVICE=ttyS0
PHONE=555-1212
USER=ppp
PASSWORD=password
OUR_IP_ADDR=127.0.0.1

if [ -f $LOCKDIR/LCK..$DEVICE ]
then
    echo "PPP device is locked"
    exit 1
fi

fix-cua $DEVICE

(
    stty 19200 -tostop

    if chat -v -l LCK..$DEVICE ABORT "NO CARRIER" ABORT BUSY "" ATZ OK ATDT$PHONE CONNECT "" ogin: $USER ssword: \\q$PASSWORD
    then
	pppd -p -d -am $OUR_IP_ADDR: /dev/$DEVICE &
	sleep 10
	exit 0
    else
	echo "PPP call failed" 1>&2
	exit 1
    fi
) < /dev/$DEVICE > /dev/$DEVICE






