
/* linux/kernel/chr_drv/sound/soundcard.c

A driver for Soundcards (Current version supports AdLib, SoundBlaster and SB
   Pro)

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/ctype.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <sys/kd.h>
#include <linux/wait.h>
#include <linux/soundcard.h>
#include "sound_calls.h"
#include "sound_config.h"

#ifdef LOADABLE_SOUNDCARD

#include <linux/larix.h>
#include "dev_table.h"

#define OUTB outb
#define DEB(WHAT)		/* (WHAT) */
#define DEB1(WHAT)		/* (WHAT) */

extern void *kmalloc (long size);

char device_name[]= "SoundCard";

int
device_init (int major)
{

  printk ("Initializing SoundCard driver\n", major);
  soundcard_load (major);
  return (major * major);
}

int
device_unload (int major)
{
  printk ("Shutting down SoundCard driver\n");
  return soundcard_unload (major);
}

#endif
